//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcostmanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/OperationList.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armcostmanagement.OperationListResult{
		// 	Value: []*armcostmanagement.OperationForCostManagement{
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/budgets/read"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("List the budgets by a subscription or a management group."),
		// 				Operation: to.Ptr("List budgets"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("Budgets"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/budgets/read"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/query/action"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("Query usage data by a scope."),
		// 				Operation: to.Ptr("Query usage data"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("Query"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/query/action"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/exports/read"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("List the exports by scope."),
		// 				Operation: to.Ptr("List exports"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("Exports"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/exports/read"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/exports/write"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("Create or update the specified export."),
		// 				Operation: to.Ptr("Create and update export"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("Exports"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/exports/write"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/exports/action"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("Run the specified export."),
		// 				Operation: to.Ptr("Run export"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("Exports"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/exports/action"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/exports/run/action"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("Run exports."),
		// 				Operation: to.Ptr("Run exports"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("exports/run"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/exports/run/action"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/alerts/read"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("List alerts."),
		// 				Operation: to.Ptr("List Alerts"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("Alerts"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/alerts/read"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/operations/read"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("List all supported operations by Microsoft.CostManagement resource provider."),
		// 				Operation: to.Ptr("List supported operations"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("Operations"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/operations/read"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/views/action"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("Create view."),
		// 				Operation: to.Ptr("Create views"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("Views"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/views/action"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.CostManagement/views/write"),
		// 			Display: &armcostmanagement.OperationDisplay{
		// 				Description: to.Ptr("Update view."),
		// 				Operation: to.Ptr("Update views"),
		// 				Provider: to.Ptr("Microsoft.CostManagement"),
		// 				Resource: to.Ptr("Views"),
		// 			},
		// 			ID: to.Ptr("Microsoft.CostManagement/views/write"),
		// 	}},
		// }
	}
}
