//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SoftwareInventoriesClient contains the methods for the SoftwareInventories group.
// Don't use this type directly, use NewSoftwareInventoriesClient() instead.
type SoftwareInventoriesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSoftwareInventoriesClient creates a new instance of SoftwareInventoriesClient with the specified values.
//   - subscriptionID - Azure subscription ID
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSoftwareInventoriesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SoftwareInventoriesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SoftwareInventoriesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets a single software data of the virtual machine.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-05-01-preview
//   - resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
//   - resourceNamespace - The namespace of the resource.
//   - resourceType - The type of the resource.
//   - resourceName - Name of the resource.
//   - softwareName - Name of the installed software.
//   - options - SoftwareInventoriesClientGetOptions contains the optional parameters for the SoftwareInventoriesClient.Get method.
func (client *SoftwareInventoriesClient) Get(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, softwareName string, options *SoftwareInventoriesClientGetOptions) (SoftwareInventoriesClientGetResponse, error) {
	var err error
	const operationName = "SoftwareInventoriesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, resourceNamespace, resourceType, resourceName, softwareName, options)
	if err != nil {
		return SoftwareInventoriesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SoftwareInventoriesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SoftwareInventoriesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SoftwareInventoriesClient) getCreateRequest(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, softwareName string, options *SoftwareInventoriesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories/{softwareName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceNamespace == "" {
		return nil, errors.New("parameter resourceNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceNamespace}", url.PathEscape(resourceNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if softwareName == "" {
		return nil, errors.New("parameter softwareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{softwareName}", url.PathEscape(softwareName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SoftwareInventoriesClient) getHandleResponse(resp *http.Response) (SoftwareInventoriesClientGetResponse, error) {
	result := SoftwareInventoriesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Software); err != nil {
		return SoftwareInventoriesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByExtendedResourcePager - Gets the software inventory of the virtual machine.
//
// Generated from API version 2021-05-01-preview
//   - resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
//   - resourceNamespace - The namespace of the resource.
//   - resourceType - The type of the resource.
//   - resourceName - Name of the resource.
//   - options - SoftwareInventoriesClientListByExtendedResourceOptions contains the optional parameters for the SoftwareInventoriesClient.NewListByExtendedResourcePager
//     method.
func (client *SoftwareInventoriesClient) NewListByExtendedResourcePager(resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *SoftwareInventoriesClientListByExtendedResourceOptions) *runtime.Pager[SoftwareInventoriesClientListByExtendedResourceResponse] {
	return runtime.NewPager(runtime.PagingHandler[SoftwareInventoriesClientListByExtendedResourceResponse]{
		More: func(page SoftwareInventoriesClientListByExtendedResourceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SoftwareInventoriesClientListByExtendedResourceResponse) (SoftwareInventoriesClientListByExtendedResourceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SoftwareInventoriesClient.NewListByExtendedResourcePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByExtendedResourceCreateRequest(ctx, resourceGroupName, resourceNamespace, resourceType, resourceName, options)
			}, nil)
			if err != nil {
				return SoftwareInventoriesClientListByExtendedResourceResponse{}, err
			}
			return client.listByExtendedResourceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByExtendedResourceCreateRequest creates the ListByExtendedResource request.
func (client *SoftwareInventoriesClient) listByExtendedResourceCreateRequest(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *SoftwareInventoriesClientListByExtendedResourceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceNamespace == "" {
		return nil, errors.New("parameter resourceNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceNamespace}", url.PathEscape(resourceNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByExtendedResourceHandleResponse handles the ListByExtendedResource response.
func (client *SoftwareInventoriesClient) listByExtendedResourceHandleResponse(resp *http.Response) (SoftwareInventoriesClientListByExtendedResourceResponse, error) {
	result := SoftwareInventoriesClientListByExtendedResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SoftwaresList); err != nil {
		return SoftwareInventoriesClientListByExtendedResourceResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Gets the software inventory of all virtual machines in the subscriptions.
//
// Generated from API version 2021-05-01-preview
//   - options - SoftwareInventoriesClientListBySubscriptionOptions contains the optional parameters for the SoftwareInventoriesClient.NewListBySubscriptionPager
//     method.
func (client *SoftwareInventoriesClient) NewListBySubscriptionPager(options *SoftwareInventoriesClientListBySubscriptionOptions) *runtime.Pager[SoftwareInventoriesClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[SoftwareInventoriesClientListBySubscriptionResponse]{
		More: func(page SoftwareInventoriesClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SoftwareInventoriesClientListBySubscriptionResponse) (SoftwareInventoriesClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SoftwareInventoriesClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return SoftwareInventoriesClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *SoftwareInventoriesClient) listBySubscriptionCreateRequest(ctx context.Context, options *SoftwareInventoriesClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/softwareInventories"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *SoftwareInventoriesClient) listBySubscriptionHandleResponse(resp *http.Response) (SoftwareInventoriesClientListBySubscriptionResponse, error) {
	result := SoftwareInventoriesClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SoftwaresList); err != nil {
		return SoftwareInventoriesClientListBySubscriptionResponse{}, err
	}
	return result, nil
}
