//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
	"net/http"
	"net/url"
	"regexp"
)

// VolumesServer is a fake server for instances of the armstorsimple8000series.VolumesClient type.
type VolumesServer struct {
	// BeginCreateOrUpdate is the fake for method VolumesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, parameters armstorsimple8000series.Volume, options *armstorsimple8000series.VolumesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armstorsimple8000series.VolumesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method VolumesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *armstorsimple8000series.VolumesClientBeginDeleteOptions) (resp azfake.PollerResponder[armstorsimple8000series.VolumesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method VolumesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *armstorsimple8000series.VolumesClientGetOptions) (resp azfake.Responder[armstorsimple8000series.VolumesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDevicePager is the fake for method VolumesClient.NewListByDevicePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDevicePager func(deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.VolumesClientListByDeviceOptions) (resp azfake.PagerResponder[armstorsimple8000series.VolumesClientListByDeviceResponse])

	// NewListByVolumeContainerPager is the fake for method VolumesClient.NewListByVolumeContainerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByVolumeContainerPager func(deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *armstorsimple8000series.VolumesClientListByVolumeContainerOptions) (resp azfake.PagerResponder[armstorsimple8000series.VolumesClientListByVolumeContainerResponse])

	// NewListMetricDefinitionPager is the fake for method VolumesClient.NewListMetricDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricDefinitionPager func(deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *armstorsimple8000series.VolumesClientListMetricDefinitionOptions) (resp azfake.PagerResponder[armstorsimple8000series.VolumesClientListMetricDefinitionResponse])

	// NewListMetricsPager is the fake for method VolumesClient.NewListMetricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricsPager func(deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, filter string, options *armstorsimple8000series.VolumesClientListMetricsOptions) (resp azfake.PagerResponder[armstorsimple8000series.VolumesClientListMetricsResponse])
}

// NewVolumesServerTransport creates a new instance of VolumesServerTransport with the provided implementation.
// The returned VolumesServerTransport instance is connected to an instance of armstorsimple8000series.VolumesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVolumesServerTransport(srv *VolumesServer) *VolumesServerTransport {
	return &VolumesServerTransport{
		srv:                           srv,
		beginCreateOrUpdate:           newTracker[azfake.PollerResponder[armstorsimple8000series.VolumesClientCreateOrUpdateResponse]](),
		beginDelete:                   newTracker[azfake.PollerResponder[armstorsimple8000series.VolumesClientDeleteResponse]](),
		newListByDevicePager:          newTracker[azfake.PagerResponder[armstorsimple8000series.VolumesClientListByDeviceResponse]](),
		newListByVolumeContainerPager: newTracker[azfake.PagerResponder[armstorsimple8000series.VolumesClientListByVolumeContainerResponse]](),
		newListMetricDefinitionPager:  newTracker[azfake.PagerResponder[armstorsimple8000series.VolumesClientListMetricDefinitionResponse]](),
		newListMetricsPager:           newTracker[azfake.PagerResponder[armstorsimple8000series.VolumesClientListMetricsResponse]](),
	}
}

// VolumesServerTransport connects instances of armstorsimple8000series.VolumesClient to instances of VolumesServer.
// Don't use this type directly, use NewVolumesServerTransport instead.
type VolumesServerTransport struct {
	srv                           *VolumesServer
	beginCreateOrUpdate           *tracker[azfake.PollerResponder[armstorsimple8000series.VolumesClientCreateOrUpdateResponse]]
	beginDelete                   *tracker[azfake.PollerResponder[armstorsimple8000series.VolumesClientDeleteResponse]]
	newListByDevicePager          *tracker[azfake.PagerResponder[armstorsimple8000series.VolumesClientListByDeviceResponse]]
	newListByVolumeContainerPager *tracker[azfake.PagerResponder[armstorsimple8000series.VolumesClientListByVolumeContainerResponse]]
	newListMetricDefinitionPager  *tracker[azfake.PagerResponder[armstorsimple8000series.VolumesClientListMetricDefinitionResponse]]
	newListMetricsPager           *tracker[azfake.PagerResponder[armstorsimple8000series.VolumesClientListMetricsResponse]]
}

// Do implements the policy.Transporter interface for VolumesServerTransport.
func (v *VolumesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VolumesClient.BeginCreateOrUpdate":
		resp, err = v.dispatchBeginCreateOrUpdate(req)
	case "VolumesClient.BeginDelete":
		resp, err = v.dispatchBeginDelete(req)
	case "VolumesClient.Get":
		resp, err = v.dispatchGet(req)
	case "VolumesClient.NewListByDevicePager":
		resp, err = v.dispatchNewListByDevicePager(req)
	case "VolumesClient.NewListByVolumeContainerPager":
		resp, err = v.dispatchNewListByVolumeContainerPager(req)
	case "VolumesClient.NewListMetricDefinitionPager":
		resp, err = v.dispatchNewListMetricDefinitionPager(req)
	case "VolumesClient.NewListMetricsPager":
		resp, err = v.dispatchNewListMetricsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := v.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumeContainers/(?P<volumeContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple8000series.Volume](req)
		if err != nil {
			return nil, err
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		volumeContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeContainerName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginCreateOrUpdate(req.Context(), deviceNameParam, volumeContainerNameParam, volumeNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		v.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		v.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if v.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := v.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumeContainers/(?P<volumeContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		volumeContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeContainerName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginDelete(req.Context(), deviceNameParam, volumeContainerNameParam, volumeNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		v.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		v.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		v.beginDelete.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumeContainers/(?P<volumeContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	volumeContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeContainerName")])
	if err != nil {
		return nil, err
	}
	volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), deviceNameParam, volumeContainerNameParam, volumeNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Volume, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VolumesServerTransport) dispatchNewListByDevicePager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListByDevicePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDevicePager not implemented")}
	}
	newListByDevicePager := v.newListByDevicePager.get(req)
	if newListByDevicePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListByDevicePager(deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		newListByDevicePager = &resp
		v.newListByDevicePager.add(req, newListByDevicePager)
	}
	resp, err := server.PagerResponderNext(newListByDevicePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListByDevicePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDevicePager) {
		v.newListByDevicePager.remove(req)
	}
	return resp, nil
}

func (v *VolumesServerTransport) dispatchNewListByVolumeContainerPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListByVolumeContainerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByVolumeContainerPager not implemented")}
	}
	newListByVolumeContainerPager := v.newListByVolumeContainerPager.get(req)
	if newListByVolumeContainerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumeContainers/(?P<volumeContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		volumeContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeContainerName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListByVolumeContainerPager(deviceNameParam, volumeContainerNameParam, resourceGroupNameParam, managerNameParam, nil)
		newListByVolumeContainerPager = &resp
		v.newListByVolumeContainerPager.add(req, newListByVolumeContainerPager)
	}
	resp, err := server.PagerResponderNext(newListByVolumeContainerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListByVolumeContainerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByVolumeContainerPager) {
		v.newListByVolumeContainerPager.remove(req)
	}
	return resp, nil
}

func (v *VolumesServerTransport) dispatchNewListMetricDefinitionPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListMetricDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricDefinitionPager not implemented")}
	}
	newListMetricDefinitionPager := v.newListMetricDefinitionPager.get(req)
	if newListMetricDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumeContainers/(?P<volumeContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricsDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		volumeContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeContainerName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListMetricDefinitionPager(deviceNameParam, volumeContainerNameParam, volumeNameParam, resourceGroupNameParam, managerNameParam, nil)
		newListMetricDefinitionPager = &resp
		v.newListMetricDefinitionPager.add(req, newListMetricDefinitionPager)
	}
	resp, err := server.PagerResponderNext(newListMetricDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListMetricDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricDefinitionPager) {
		v.newListMetricDefinitionPager.remove(req)
	}
	return resp, nil
}

func (v *VolumesServerTransport) dispatchNewListMetricsPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListMetricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricsPager not implemented")}
	}
	newListMetricsPager := v.newListMetricsPager.get(req)
	if newListMetricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumeContainers/(?P<volumeContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		volumeContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeContainerName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListMetricsPager(deviceNameParam, volumeContainerNameParam, volumeNameParam, resourceGroupNameParam, managerNameParam, filterParam, nil)
		newListMetricsPager = &resp
		v.newListMetricsPager.add(req, newListMetricsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListMetricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricsPager) {
		v.newListMetricsPager.remove(req)
	}
	return resp, nil
}
