//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package network

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/network/mgmt/2022-07-01/network"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type Access = original.Access

const (
	Allow Access = original.Allow
	Deny  Access = original.Deny
)

type ActionType = original.ActionType

const (
	ActionTypeAllow          ActionType = original.ActionTypeAllow
	ActionTypeAnomalyScoring ActionType = original.ActionTypeAnomalyScoring
	ActionTypeBlock          ActionType = original.ActionTypeBlock
	ActionTypeLog            ActionType = original.ActionTypeLog
)

type AddressPrefixType = original.AddressPrefixType

const (
	IPPrefix   AddressPrefixType = original.IPPrefix
	ServiceTag AddressPrefixType = original.ServiceTag
)

type ApplicationGatewayBackendHealthServerHealth = original.ApplicationGatewayBackendHealthServerHealth

const (
	Down     ApplicationGatewayBackendHealthServerHealth = original.Down
	Draining ApplicationGatewayBackendHealthServerHealth = original.Draining
	Partial  ApplicationGatewayBackendHealthServerHealth = original.Partial
	Unknown  ApplicationGatewayBackendHealthServerHealth = original.Unknown
	Up       ApplicationGatewayBackendHealthServerHealth = original.Up
)

type ApplicationGatewayClientRevocationOptions = original.ApplicationGatewayClientRevocationOptions

const (
	None ApplicationGatewayClientRevocationOptions = original.None
	OCSP ApplicationGatewayClientRevocationOptions = original.OCSP
)

type ApplicationGatewayCookieBasedAffinity = original.ApplicationGatewayCookieBasedAffinity

const (
	Disabled ApplicationGatewayCookieBasedAffinity = original.Disabled
	Enabled  ApplicationGatewayCookieBasedAffinity = original.Enabled
)

type ApplicationGatewayCustomErrorStatusCode = original.ApplicationGatewayCustomErrorStatusCode

const (
	HTTPStatus403 ApplicationGatewayCustomErrorStatusCode = original.HTTPStatus403
	HTTPStatus502 ApplicationGatewayCustomErrorStatusCode = original.HTTPStatus502
)

type ApplicationGatewayFirewallMode = original.ApplicationGatewayFirewallMode

const (
	Detection  ApplicationGatewayFirewallMode = original.Detection
	Prevention ApplicationGatewayFirewallMode = original.Prevention
)

type ApplicationGatewayLoadDistributionAlgorithm = original.ApplicationGatewayLoadDistributionAlgorithm

const (
	IPHash           ApplicationGatewayLoadDistributionAlgorithm = original.IPHash
	LeastConnections ApplicationGatewayLoadDistributionAlgorithm = original.LeastConnections
	RoundRobin       ApplicationGatewayLoadDistributionAlgorithm = original.RoundRobin
)

type ApplicationGatewayOperationalState = original.ApplicationGatewayOperationalState

const (
	Running  ApplicationGatewayOperationalState = original.Running
	Starting ApplicationGatewayOperationalState = original.Starting
	Stopped  ApplicationGatewayOperationalState = original.Stopped
	Stopping ApplicationGatewayOperationalState = original.Stopping
)

type ApplicationGatewayProtocol = original.ApplicationGatewayProtocol

const (
	HTTP  ApplicationGatewayProtocol = original.HTTP
	HTTPS ApplicationGatewayProtocol = original.HTTPS
	TCP   ApplicationGatewayProtocol = original.TCP
	TLS   ApplicationGatewayProtocol = original.TLS
)

type ApplicationGatewayRedirectType = original.ApplicationGatewayRedirectType

const (
	Found     ApplicationGatewayRedirectType = original.Found
	Permanent ApplicationGatewayRedirectType = original.Permanent
	SeeOther  ApplicationGatewayRedirectType = original.SeeOther
	Temporary ApplicationGatewayRedirectType = original.Temporary
)

type ApplicationGatewayRequestRoutingRuleType = original.ApplicationGatewayRequestRoutingRuleType

const (
	Basic            ApplicationGatewayRequestRoutingRuleType = original.Basic
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = original.PathBasedRouting
)

type ApplicationGatewayRuleSetStatusOptions = original.ApplicationGatewayRuleSetStatusOptions

const (
	Deprecated ApplicationGatewayRuleSetStatusOptions = original.Deprecated
	GA         ApplicationGatewayRuleSetStatusOptions = original.GA
	Preview    ApplicationGatewayRuleSetStatusOptions = original.Preview
	Supported  ApplicationGatewayRuleSetStatusOptions = original.Supported
)

type ApplicationGatewaySkuName = original.ApplicationGatewaySkuName

const (
	StandardBasic  ApplicationGatewaySkuName = original.StandardBasic
	StandardLarge  ApplicationGatewaySkuName = original.StandardLarge
	StandardMedium ApplicationGatewaySkuName = original.StandardMedium
	StandardSmall  ApplicationGatewaySkuName = original.StandardSmall
	StandardV2     ApplicationGatewaySkuName = original.StandardV2
	WAFLarge       ApplicationGatewaySkuName = original.WAFLarge
	WAFMedium      ApplicationGatewaySkuName = original.WAFMedium
	WAFV2          ApplicationGatewaySkuName = original.WAFV2
)

type ApplicationGatewaySslCipherSuite = original.ApplicationGatewaySslCipherSuite

const (
	TLSDHEDSSWITH3DESEDECBCSHA       ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITH3DESEDECBCSHA
	TLSDHEDSSWITHAES128CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES128CBCSHA
	TLSDHEDSSWITHAES128CBCSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES128CBCSHA256
	TLSDHEDSSWITHAES256CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES256CBCSHA
	TLSDHEDSSWITHAES256CBCSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES256CBCSHA256
	TLSDHERSAWITHAES128CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES128CBCSHA
	TLSDHERSAWITHAES128GCMSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES128GCMSHA256
	TLSDHERSAWITHAES256CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES256CBCSHA
	TLSDHERSAWITHAES256GCMSHA384     ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES256GCMSHA384
	TLSECDHEECDSAWITHAES128CBCSHA    ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128CBCSHA
	TLSECDHEECDSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128CBCSHA256
	TLSECDHEECDSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128GCMSHA256
	TLSECDHEECDSAWITHAES256CBCSHA    ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256CBCSHA
	TLSECDHEECDSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256CBCSHA384
	TLSECDHEECDSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256GCMSHA384
	TLSECDHERSAWITHAES128CBCSHA      ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128CBCSHA
	TLSECDHERSAWITHAES128CBCSHA256   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128CBCSHA256
	TLSECDHERSAWITHAES128GCMSHA256   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128GCMSHA256
	TLSECDHERSAWITHAES256CBCSHA      ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256CBCSHA
	TLSECDHERSAWITHAES256CBCSHA384   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256CBCSHA384
	TLSECDHERSAWITHAES256GCMSHA384   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256GCMSHA384
	TLSRSAWITH3DESEDECBCSHA          ApplicationGatewaySslCipherSuite = original.TLSRSAWITH3DESEDECBCSHA
	TLSRSAWITHAES128CBCSHA           ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128CBCSHA
	TLSRSAWITHAES128CBCSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128CBCSHA256
	TLSRSAWITHAES128GCMSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128GCMSHA256
	TLSRSAWITHAES256CBCSHA           ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256CBCSHA
	TLSRSAWITHAES256CBCSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256CBCSHA256
	TLSRSAWITHAES256GCMSHA384        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256GCMSHA384
)

type ApplicationGatewaySslPolicyName = original.ApplicationGatewaySslPolicyName

const (
	AppGwSslPolicy20150501  ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20150501
	AppGwSslPolicy20170401  ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20170401
	AppGwSslPolicy20170401S ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20170401S
	AppGwSslPolicy20220101  ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20220101
	AppGwSslPolicy20220101S ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20220101S
)

type ApplicationGatewaySslPolicyType = original.ApplicationGatewaySslPolicyType

const (
	Custom     ApplicationGatewaySslPolicyType = original.Custom
	CustomV2   ApplicationGatewaySslPolicyType = original.CustomV2
	Predefined ApplicationGatewaySslPolicyType = original.Predefined
)

type ApplicationGatewaySslProtocol = original.ApplicationGatewaySslProtocol

const (
	TLSv10 ApplicationGatewaySslProtocol = original.TLSv10
	TLSv11 ApplicationGatewaySslProtocol = original.TLSv11
	TLSv12 ApplicationGatewaySslProtocol = original.TLSv12
	TLSv13 ApplicationGatewaySslProtocol = original.TLSv13
)

type ApplicationGatewayTier = original.ApplicationGatewayTier

const (
	ApplicationGatewayTierStandard      ApplicationGatewayTier = original.ApplicationGatewayTierStandard
	ApplicationGatewayTierStandardBasic ApplicationGatewayTier = original.ApplicationGatewayTierStandardBasic
	ApplicationGatewayTierStandardV2    ApplicationGatewayTier = original.ApplicationGatewayTierStandardV2
	ApplicationGatewayTierWAF           ApplicationGatewayTier = original.ApplicationGatewayTierWAF
	ApplicationGatewayTierWAFV2         ApplicationGatewayTier = original.ApplicationGatewayTierWAFV2
)

type ApplicationGatewayTierTypes = original.ApplicationGatewayTierTypes

const (
	ApplicationGatewayTierTypesStandard   ApplicationGatewayTierTypes = original.ApplicationGatewayTierTypesStandard
	ApplicationGatewayTierTypesStandardV2 ApplicationGatewayTierTypes = original.ApplicationGatewayTierTypesStandardV2
	ApplicationGatewayTierTypesWAF        ApplicationGatewayTierTypes = original.ApplicationGatewayTierTypesWAF
	ApplicationGatewayTierTypesWAFV2      ApplicationGatewayTierTypes = original.ApplicationGatewayTierTypesWAFV2
)

type ApplicationGatewayWafRuleActionTypes = original.ApplicationGatewayWafRuleActionTypes

const (
	ApplicationGatewayWafRuleActionTypesAllow          ApplicationGatewayWafRuleActionTypes = original.ApplicationGatewayWafRuleActionTypesAllow
	ApplicationGatewayWafRuleActionTypesAnomalyScoring ApplicationGatewayWafRuleActionTypes = original.ApplicationGatewayWafRuleActionTypesAnomalyScoring
	ApplicationGatewayWafRuleActionTypesBlock          ApplicationGatewayWafRuleActionTypes = original.ApplicationGatewayWafRuleActionTypesBlock
	ApplicationGatewayWafRuleActionTypesLog            ApplicationGatewayWafRuleActionTypes = original.ApplicationGatewayWafRuleActionTypesLog
	ApplicationGatewayWafRuleActionTypesNone           ApplicationGatewayWafRuleActionTypes = original.ApplicationGatewayWafRuleActionTypesNone
)

type ApplicationGatewayWafRuleStateTypes = original.ApplicationGatewayWafRuleStateTypes

const (
	ApplicationGatewayWafRuleStateTypesDisabled ApplicationGatewayWafRuleStateTypes = original.ApplicationGatewayWafRuleStateTypesDisabled
	ApplicationGatewayWafRuleStateTypesEnabled  ApplicationGatewayWafRuleStateTypes = original.ApplicationGatewayWafRuleStateTypesEnabled
)

type AssociationType = original.AssociationType

const (
	Associated AssociationType = original.Associated
	Contains   AssociationType = original.Contains
)

type AuthenticationMethod = original.AuthenticationMethod

const (
	EAPMSCHAPv2 AuthenticationMethod = original.EAPMSCHAPv2
	EAPTLS      AuthenticationMethod = original.EAPTLS
)

type AuthorizationUseStatus = original.AuthorizationUseStatus

const (
	Available AuthorizationUseStatus = original.Available
	InUse     AuthorizationUseStatus = original.InUse
)

type AutoLearnPrivateRangesMode = original.AutoLearnPrivateRangesMode

const (
	AutoLearnPrivateRangesModeDisabled AutoLearnPrivateRangesMode = original.AutoLearnPrivateRangesModeDisabled
	AutoLearnPrivateRangesModeEnabled  AutoLearnPrivateRangesMode = original.AutoLearnPrivateRangesModeEnabled
)

type AzureFirewallApplicationRuleProtocolType = original.AzureFirewallApplicationRuleProtocolType

const (
	AzureFirewallApplicationRuleProtocolTypeHTTP  AzureFirewallApplicationRuleProtocolType = original.AzureFirewallApplicationRuleProtocolTypeHTTP
	AzureFirewallApplicationRuleProtocolTypeHTTPS AzureFirewallApplicationRuleProtocolType = original.AzureFirewallApplicationRuleProtocolTypeHTTPS
	AzureFirewallApplicationRuleProtocolTypeMssql AzureFirewallApplicationRuleProtocolType = original.AzureFirewallApplicationRuleProtocolTypeMssql
)

type AzureFirewallNatRCActionType = original.AzureFirewallNatRCActionType

const (
	Dnat AzureFirewallNatRCActionType = original.Dnat
	Snat AzureFirewallNatRCActionType = original.Snat
)

type AzureFirewallNetworkRuleProtocol = original.AzureFirewallNetworkRuleProtocol

const (
	AzureFirewallNetworkRuleProtocolAny  AzureFirewallNetworkRuleProtocol = original.AzureFirewallNetworkRuleProtocolAny
	AzureFirewallNetworkRuleProtocolICMP AzureFirewallNetworkRuleProtocol = original.AzureFirewallNetworkRuleProtocolICMP
	AzureFirewallNetworkRuleProtocolTCP  AzureFirewallNetworkRuleProtocol = original.AzureFirewallNetworkRuleProtocolTCP
	AzureFirewallNetworkRuleProtocolUDP  AzureFirewallNetworkRuleProtocol = original.AzureFirewallNetworkRuleProtocolUDP
)

type AzureFirewallRCActionType = original.AzureFirewallRCActionType

const (
	AzureFirewallRCActionTypeAllow AzureFirewallRCActionType = original.AzureFirewallRCActionTypeAllow
	AzureFirewallRCActionTypeDeny  AzureFirewallRCActionType = original.AzureFirewallRCActionTypeDeny
)

type AzureFirewallSkuName = original.AzureFirewallSkuName

const (
	AZFWHub  AzureFirewallSkuName = original.AZFWHub
	AZFWVNet AzureFirewallSkuName = original.AZFWVNet
)

type AzureFirewallSkuTier = original.AzureFirewallSkuTier

const (
	AzureFirewallSkuTierBasic    AzureFirewallSkuTier = original.AzureFirewallSkuTierBasic
	AzureFirewallSkuTierPremium  AzureFirewallSkuTier = original.AzureFirewallSkuTierPremium
	AzureFirewallSkuTierStandard AzureFirewallSkuTier = original.AzureFirewallSkuTierStandard
)

type AzureFirewallThreatIntelMode = original.AzureFirewallThreatIntelMode

const (
	AzureFirewallThreatIntelModeAlert AzureFirewallThreatIntelMode = original.AzureFirewallThreatIntelModeAlert
	AzureFirewallThreatIntelModeDeny  AzureFirewallThreatIntelMode = original.AzureFirewallThreatIntelModeDeny
	AzureFirewallThreatIntelModeOff   AzureFirewallThreatIntelMode = original.AzureFirewallThreatIntelModeOff
)

type BastionConnectProtocol = original.BastionConnectProtocol

const (
	RDP BastionConnectProtocol = original.RDP
	SSH BastionConnectProtocol = original.SSH
)

type BastionHostSkuName = original.BastionHostSkuName

const (
	BastionHostSkuNameBasic    BastionHostSkuName = original.BastionHostSkuNameBasic
	BastionHostSkuNameStandard BastionHostSkuName = original.BastionHostSkuNameStandard
)

type BgpPeerState = original.BgpPeerState

const (
	BgpPeerStateConnected  BgpPeerState = original.BgpPeerStateConnected
	BgpPeerStateConnecting BgpPeerState = original.BgpPeerStateConnecting
	BgpPeerStateIdle       BgpPeerState = original.BgpPeerStateIdle
	BgpPeerStateStopped    BgpPeerState = original.BgpPeerStateStopped
	BgpPeerStateUnknown    BgpPeerState = original.BgpPeerStateUnknown
)

type CircuitConnectionStatus = original.CircuitConnectionStatus

const (
	Connected    CircuitConnectionStatus = original.Connected
	Connecting   CircuitConnectionStatus = original.Connecting
	Disconnected CircuitConnectionStatus = original.Disconnected
)

type CommissionedState = original.CommissionedState

const (
	Commissioned                    CommissionedState = original.Commissioned
	CommissionedNoInternetAdvertise CommissionedState = original.CommissionedNoInternetAdvertise
	Commissioning                   CommissionedState = original.Commissioning
	Decommissioning                 CommissionedState = original.Decommissioning
	Deprovisioned                   CommissionedState = original.Deprovisioned
	Deprovisioning                  CommissionedState = original.Deprovisioning
	Provisioned                     CommissionedState = original.Provisioned
	Provisioning                    CommissionedState = original.Provisioning
)

type ConfigurationType = original.ConfigurationType

const (
	Connectivity  ConfigurationType = original.Connectivity
	SecurityAdmin ConfigurationType = original.SecurityAdmin
)

type ConnectionMonitorEndpointFilterItemType = original.ConnectionMonitorEndpointFilterItemType

const (
	AgentAddress ConnectionMonitorEndpointFilterItemType = original.AgentAddress
)

type ConnectionMonitorEndpointFilterType = original.ConnectionMonitorEndpointFilterType

const (
	Include ConnectionMonitorEndpointFilterType = original.Include
)

type ConnectionMonitorSourceStatus = original.ConnectionMonitorSourceStatus

const (
	ConnectionMonitorSourceStatusActive   ConnectionMonitorSourceStatus = original.ConnectionMonitorSourceStatusActive
	ConnectionMonitorSourceStatusInactive ConnectionMonitorSourceStatus = original.ConnectionMonitorSourceStatusInactive
	ConnectionMonitorSourceStatusUnknown  ConnectionMonitorSourceStatus = original.ConnectionMonitorSourceStatusUnknown
)

type ConnectionMonitorTestConfigurationProtocol = original.ConnectionMonitorTestConfigurationProtocol

const (
	ConnectionMonitorTestConfigurationProtocolHTTP ConnectionMonitorTestConfigurationProtocol = original.ConnectionMonitorTestConfigurationProtocolHTTP
	ConnectionMonitorTestConfigurationProtocolIcmp ConnectionMonitorTestConfigurationProtocol = original.ConnectionMonitorTestConfigurationProtocolIcmp
	ConnectionMonitorTestConfigurationProtocolTCP  ConnectionMonitorTestConfigurationProtocol = original.ConnectionMonitorTestConfigurationProtocolTCP
)

type ConnectionMonitorType = original.ConnectionMonitorType

const (
	MultiEndpoint           ConnectionMonitorType = original.MultiEndpoint
	SingleSourceDestination ConnectionMonitorType = original.SingleSourceDestination
)

type ConnectionState = original.ConnectionState

const (
	ConnectionStateReachable   ConnectionState = original.ConnectionStateReachable
	ConnectionStateUnknown     ConnectionState = original.ConnectionStateUnknown
	ConnectionStateUnreachable ConnectionState = original.ConnectionStateUnreachable
)

type ConnectionStatus = original.ConnectionStatus

const (
	ConnectionStatusConnected    ConnectionStatus = original.ConnectionStatusConnected
	ConnectionStatusDegraded     ConnectionStatus = original.ConnectionStatusDegraded
	ConnectionStatusDisconnected ConnectionStatus = original.ConnectionStatusDisconnected
	ConnectionStatusUnknown      ConnectionStatus = original.ConnectionStatusUnknown
)

type ConnectivityTopology = original.ConnectivityTopology

const (
	HubAndSpoke ConnectivityTopology = original.HubAndSpoke
	Mesh        ConnectivityTopology = original.Mesh
)

type CoverageLevel = original.CoverageLevel

const (
	AboveAverage CoverageLevel = original.AboveAverage
	Average      CoverageLevel = original.Average
	BelowAverage CoverageLevel = original.BelowAverage
	Default      CoverageLevel = original.Default
	Full         CoverageLevel = original.Full
	Low          CoverageLevel = original.Low
)

type CreatedByType = original.CreatedByType

const (
	Application     CreatedByType = original.Application
	Key             CreatedByType = original.Key
	ManagedIdentity CreatedByType = original.ManagedIdentity
	User            CreatedByType = original.User
)

type CustomIPPrefixType = original.CustomIPPrefixType

const (
	Child    CustomIPPrefixType = original.Child
	Parent   CustomIPPrefixType = original.Parent
	Singular CustomIPPrefixType = original.Singular
)

type DdosSettingsProtectionMode = original.DdosSettingsProtectionMode

const (
	DdosSettingsProtectionModeDisabled                DdosSettingsProtectionMode = original.DdosSettingsProtectionModeDisabled
	DdosSettingsProtectionModeEnabled                 DdosSettingsProtectionMode = original.DdosSettingsProtectionModeEnabled
	DdosSettingsProtectionModeVirtualNetworkInherited DdosSettingsProtectionMode = original.DdosSettingsProtectionModeVirtualNetworkInherited
)

type DeleteExistingPeering = original.DeleteExistingPeering

const (
	False DeleteExistingPeering = original.False
	True  DeleteExistingPeering = original.True
)

type DeleteOptions = original.DeleteOptions

const (
	Delete DeleteOptions = original.Delete
	Detach DeleteOptions = original.Detach
)

type DeploymentStatus = original.DeploymentStatus

const (
	Deployed   DeploymentStatus = original.Deployed
	Deploying  DeploymentStatus = original.Deploying
	Failed     DeploymentStatus = original.Failed
	NotStarted DeploymentStatus = original.NotStarted
)

type DestinationPortBehavior = original.DestinationPortBehavior

const (
	DestinationPortBehaviorListenIfAvailable DestinationPortBehavior = original.DestinationPortBehaviorListenIfAvailable
	DestinationPortBehaviorNone              DestinationPortBehavior = original.DestinationPortBehaviorNone
)

type DhGroup = original.DhGroup

const (
	DhGroupDHGroup1    DhGroup = original.DhGroupDHGroup1
	DhGroupDHGroup14   DhGroup = original.DhGroupDHGroup14
	DhGroupDHGroup2    DhGroup = original.DhGroupDHGroup2
	DhGroupDHGroup2048 DhGroup = original.DhGroupDHGroup2048
	DhGroupDHGroup24   DhGroup = original.DhGroupDHGroup24
	DhGroupECP256      DhGroup = original.DhGroupECP256
	DhGroupECP384      DhGroup = original.DhGroupECP384
	DhGroupNone        DhGroup = original.DhGroupNone
)

type Direction = original.Direction

const (
	Inbound  Direction = original.Inbound
	Outbound Direction = original.Outbound
)

type EffectiveRouteSource = original.EffectiveRouteSource

const (
	EffectiveRouteSourceDefault               EffectiveRouteSource = original.EffectiveRouteSourceDefault
	EffectiveRouteSourceUnknown               EffectiveRouteSource = original.EffectiveRouteSourceUnknown
	EffectiveRouteSourceUser                  EffectiveRouteSource = original.EffectiveRouteSourceUser
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = original.EffectiveRouteSourceVirtualNetworkGateway
)

type EffectiveRouteState = original.EffectiveRouteState

const (
	Active  EffectiveRouteState = original.Active
	Invalid EffectiveRouteState = original.Invalid
)

type EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocol

const (
	EffectiveSecurityRuleProtocolAll EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocolAll
	EffectiveSecurityRuleProtocolTCP EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocolTCP
	EffectiveSecurityRuleProtocolUDP EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocolUDP
)

type EndpointType = original.EndpointType

const (
	AzureArcVM          EndpointType = original.AzureArcVM
	AzureSubnet         EndpointType = original.AzureSubnet
	AzureVM             EndpointType = original.AzureVM
	AzureVMSS           EndpointType = original.AzureVMSS
	AzureVNet           EndpointType = original.AzureVNet
	ExternalAddress     EndpointType = original.ExternalAddress
	MMAWorkspaceMachine EndpointType = original.MMAWorkspaceMachine
	MMAWorkspaceNetwork EndpointType = original.MMAWorkspaceNetwork
)

type EvaluationState = original.EvaluationState

const (
	EvaluationStateCompleted  EvaluationState = original.EvaluationStateCompleted
	EvaluationStateInProgress EvaluationState = original.EvaluationStateInProgress
	EvaluationStateNotStarted EvaluationState = original.EvaluationStateNotStarted
)

type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState

const (
	Configured       ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.Configured
	Configuring      ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.Configuring
	NotConfigured    ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.NotConfigured
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.ValidationNeeded
)

type ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringState

const (
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringStateDisabled
	ExpressRouteCircuitPeeringStateEnabled  ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringStateEnabled
)

type ExpressRouteCircuitSkuFamily = original.ExpressRouteCircuitSkuFamily

const (
	MeteredData   ExpressRouteCircuitSkuFamily = original.MeteredData
	UnlimitedData ExpressRouteCircuitSkuFamily = original.UnlimitedData
)

type ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTier

const (
	ExpressRouteCircuitSkuTierBasic    ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierBasic
	ExpressRouteCircuitSkuTierLocal    ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierLocal
	ExpressRouteCircuitSkuTierPremium  ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierPremium
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierStandard
)

type ExpressRouteLinkAdminState = original.ExpressRouteLinkAdminState

const (
	ExpressRouteLinkAdminStateDisabled ExpressRouteLinkAdminState = original.ExpressRouteLinkAdminStateDisabled
	ExpressRouteLinkAdminStateEnabled  ExpressRouteLinkAdminState = original.ExpressRouteLinkAdminStateEnabled
)

type ExpressRouteLinkConnectorType = original.ExpressRouteLinkConnectorType

const (
	LC ExpressRouteLinkConnectorType = original.LC
	SC ExpressRouteLinkConnectorType = original.SC
)

type ExpressRouteLinkMacSecCipher = original.ExpressRouteLinkMacSecCipher

const (
	GcmAes128    ExpressRouteLinkMacSecCipher = original.GcmAes128
	GcmAes256    ExpressRouteLinkMacSecCipher = original.GcmAes256
	GcmAesXpn128 ExpressRouteLinkMacSecCipher = original.GcmAesXpn128
	GcmAesXpn256 ExpressRouteLinkMacSecCipher = original.GcmAesXpn256
)

type ExpressRouteLinkMacSecSciState = original.ExpressRouteLinkMacSecSciState

const (
	ExpressRouteLinkMacSecSciStateDisabled ExpressRouteLinkMacSecSciState = original.ExpressRouteLinkMacSecSciStateDisabled
	ExpressRouteLinkMacSecSciStateEnabled  ExpressRouteLinkMacSecSciState = original.ExpressRouteLinkMacSecSciStateEnabled
)

type ExpressRoutePeeringState = original.ExpressRoutePeeringState

const (
	ExpressRoutePeeringStateDisabled ExpressRoutePeeringState = original.ExpressRoutePeeringStateDisabled
	ExpressRoutePeeringStateEnabled  ExpressRoutePeeringState = original.ExpressRoutePeeringStateEnabled
)

type ExpressRoutePeeringType = original.ExpressRoutePeeringType

const (
	AzurePrivatePeering ExpressRoutePeeringType = original.AzurePrivatePeering
	AzurePublicPeering  ExpressRoutePeeringType = original.AzurePublicPeering
	MicrosoftPeering    ExpressRoutePeeringType = original.MicrosoftPeering
)

type ExpressRoutePortAuthorizationUseStatus = original.ExpressRoutePortAuthorizationUseStatus

const (
	ExpressRoutePortAuthorizationUseStatusAvailable ExpressRoutePortAuthorizationUseStatus = original.ExpressRoutePortAuthorizationUseStatusAvailable
	ExpressRoutePortAuthorizationUseStatusInUse     ExpressRoutePortAuthorizationUseStatus = original.ExpressRoutePortAuthorizationUseStatusInUse
)

type ExpressRoutePortsBillingType = original.ExpressRoutePortsBillingType

const (
	ExpressRoutePortsBillingTypeMeteredData   ExpressRoutePortsBillingType = original.ExpressRoutePortsBillingTypeMeteredData
	ExpressRoutePortsBillingTypeUnlimitedData ExpressRoutePortsBillingType = original.ExpressRoutePortsBillingTypeUnlimitedData
)

type ExpressRoutePortsEncapsulation = original.ExpressRoutePortsEncapsulation

const (
	Dot1Q ExpressRoutePortsEncapsulation = original.Dot1Q
	QinQ  ExpressRoutePortsEncapsulation = original.QinQ
)

type ExtendedLocationTypes = original.ExtendedLocationTypes

const (
	EdgeZone ExtendedLocationTypes = original.EdgeZone
)

type FirewallPolicyFilterRuleCollectionActionType = original.FirewallPolicyFilterRuleCollectionActionType

const (
	FirewallPolicyFilterRuleCollectionActionTypeAllow FirewallPolicyFilterRuleCollectionActionType = original.FirewallPolicyFilterRuleCollectionActionTypeAllow
	FirewallPolicyFilterRuleCollectionActionTypeDeny  FirewallPolicyFilterRuleCollectionActionType = original.FirewallPolicyFilterRuleCollectionActionTypeDeny
)

type FirewallPolicyIDPSQuerySortOrder = original.FirewallPolicyIDPSQuerySortOrder

const (
	Ascending  FirewallPolicyIDPSQuerySortOrder = original.Ascending
	Descending FirewallPolicyIDPSQuerySortOrder = original.Descending
)

type FirewallPolicyIntrusionDetectionProtocol = original.FirewallPolicyIntrusionDetectionProtocol

const (
	FirewallPolicyIntrusionDetectionProtocolANY  FirewallPolicyIntrusionDetectionProtocol = original.FirewallPolicyIntrusionDetectionProtocolANY
	FirewallPolicyIntrusionDetectionProtocolICMP FirewallPolicyIntrusionDetectionProtocol = original.FirewallPolicyIntrusionDetectionProtocolICMP
	FirewallPolicyIntrusionDetectionProtocolTCP  FirewallPolicyIntrusionDetectionProtocol = original.FirewallPolicyIntrusionDetectionProtocolTCP
	FirewallPolicyIntrusionDetectionProtocolUDP  FirewallPolicyIntrusionDetectionProtocol = original.FirewallPolicyIntrusionDetectionProtocolUDP
)

type FirewallPolicyIntrusionDetectionStateType = original.FirewallPolicyIntrusionDetectionStateType

const (
	FirewallPolicyIntrusionDetectionStateTypeAlert FirewallPolicyIntrusionDetectionStateType = original.FirewallPolicyIntrusionDetectionStateTypeAlert
	FirewallPolicyIntrusionDetectionStateTypeDeny  FirewallPolicyIntrusionDetectionStateType = original.FirewallPolicyIntrusionDetectionStateTypeDeny
	FirewallPolicyIntrusionDetectionStateTypeOff   FirewallPolicyIntrusionDetectionStateType = original.FirewallPolicyIntrusionDetectionStateTypeOff
)

type FirewallPolicyNatRuleCollectionActionType = original.FirewallPolicyNatRuleCollectionActionType

const (
	DNAT FirewallPolicyNatRuleCollectionActionType = original.DNAT
)

type FirewallPolicyRuleApplicationProtocolType = original.FirewallPolicyRuleApplicationProtocolType

const (
	FirewallPolicyRuleApplicationProtocolTypeHTTP  FirewallPolicyRuleApplicationProtocolType = original.FirewallPolicyRuleApplicationProtocolTypeHTTP
	FirewallPolicyRuleApplicationProtocolTypeHTTPS FirewallPolicyRuleApplicationProtocolType = original.FirewallPolicyRuleApplicationProtocolTypeHTTPS
)

type FirewallPolicyRuleNetworkProtocol = original.FirewallPolicyRuleNetworkProtocol

const (
	FirewallPolicyRuleNetworkProtocolAny  FirewallPolicyRuleNetworkProtocol = original.FirewallPolicyRuleNetworkProtocolAny
	FirewallPolicyRuleNetworkProtocolICMP FirewallPolicyRuleNetworkProtocol = original.FirewallPolicyRuleNetworkProtocolICMP
	FirewallPolicyRuleNetworkProtocolTCP  FirewallPolicyRuleNetworkProtocol = original.FirewallPolicyRuleNetworkProtocolTCP
	FirewallPolicyRuleNetworkProtocolUDP  FirewallPolicyRuleNetworkProtocol = original.FirewallPolicyRuleNetworkProtocolUDP
)

type FirewallPolicySkuTier = original.FirewallPolicySkuTier

const (
	FirewallPolicySkuTierBasic    FirewallPolicySkuTier = original.FirewallPolicySkuTierBasic
	FirewallPolicySkuTierPremium  FirewallPolicySkuTier = original.FirewallPolicySkuTierPremium
	FirewallPolicySkuTierStandard FirewallPolicySkuTier = original.FirewallPolicySkuTierStandard
)

type FlowLogFormatType = original.FlowLogFormatType

const (
	JSON FlowLogFormatType = original.JSON
)

type GatewayLoadBalancerTunnelInterfaceType = original.GatewayLoadBalancerTunnelInterfaceType

const (
	GatewayLoadBalancerTunnelInterfaceTypeExternal GatewayLoadBalancerTunnelInterfaceType = original.GatewayLoadBalancerTunnelInterfaceTypeExternal
	GatewayLoadBalancerTunnelInterfaceTypeInternal GatewayLoadBalancerTunnelInterfaceType = original.GatewayLoadBalancerTunnelInterfaceTypeInternal
	GatewayLoadBalancerTunnelInterfaceTypeNone     GatewayLoadBalancerTunnelInterfaceType = original.GatewayLoadBalancerTunnelInterfaceTypeNone
)

type GatewayLoadBalancerTunnelProtocol = original.GatewayLoadBalancerTunnelProtocol

const (
	GatewayLoadBalancerTunnelProtocolNative GatewayLoadBalancerTunnelProtocol = original.GatewayLoadBalancerTunnelProtocolNative
	GatewayLoadBalancerTunnelProtocolNone   GatewayLoadBalancerTunnelProtocol = original.GatewayLoadBalancerTunnelProtocolNone
	GatewayLoadBalancerTunnelProtocolVXLAN  GatewayLoadBalancerTunnelProtocol = original.GatewayLoadBalancerTunnelProtocolVXLAN
)

type Geo = original.Geo

const (
	AFRI    Geo = original.AFRI
	APAC    Geo = original.APAC
	AQ      Geo = original.AQ
	EURO    Geo = original.EURO
	GLOBAL  Geo = original.GLOBAL
	LATAM   Geo = original.LATAM
	ME      Geo = original.ME
	NAM     Geo = original.NAM
	OCEANIA Geo = original.OCEANIA
)

type GroupConnectivity = original.GroupConnectivity

const (
	GroupConnectivityDirectlyConnected GroupConnectivity = original.GroupConnectivityDirectlyConnected
	GroupConnectivityNone              GroupConnectivity = original.GroupConnectivityNone
)

type HTTPConfigurationMethod = original.HTTPConfigurationMethod

const (
	Get  HTTPConfigurationMethod = original.Get
	Post HTTPConfigurationMethod = original.Post
)

type HTTPMethod = original.HTTPMethod

const (
	HTTPMethodGet HTTPMethod = original.HTTPMethodGet
)

type HubBgpConnectionStatus = original.HubBgpConnectionStatus

const (
	HubBgpConnectionStatusConnected    HubBgpConnectionStatus = original.HubBgpConnectionStatusConnected
	HubBgpConnectionStatusConnecting   HubBgpConnectionStatus = original.HubBgpConnectionStatusConnecting
	HubBgpConnectionStatusNotConnected HubBgpConnectionStatus = original.HubBgpConnectionStatusNotConnected
	HubBgpConnectionStatusUnknown      HubBgpConnectionStatus = original.HubBgpConnectionStatusUnknown
)

type HubRoutingPreference = original.HubRoutingPreference

const (
	HubRoutingPreferenceASPath       HubRoutingPreference = original.HubRoutingPreferenceASPath
	HubRoutingPreferenceExpressRoute HubRoutingPreference = original.HubRoutingPreferenceExpressRoute
	HubRoutingPreferenceVpnGateway   HubRoutingPreference = original.HubRoutingPreferenceVpnGateway
)

type HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatus

const (
	HubVirtualNetworkConnectionStatusConnected    HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatusConnected
	HubVirtualNetworkConnectionStatusConnecting   HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatusConnecting
	HubVirtualNetworkConnectionStatusNotConnected HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatusNotConnected
	HubVirtualNetworkConnectionStatusUnknown      HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatusUnknown
)

type IPAllocationMethod = original.IPAllocationMethod

const (
	Dynamic IPAllocationMethod = original.Dynamic
	Static  IPAllocationMethod = original.Static
)

type IPAllocationType = original.IPAllocationType

const (
	Hypernet  IPAllocationType = original.Hypernet
	Undefined IPAllocationType = original.Undefined
)

type IPFlowProtocol = original.IPFlowProtocol

const (
	IPFlowProtocolTCP IPFlowProtocol = original.IPFlowProtocolTCP
	IPFlowProtocolUDP IPFlowProtocol = original.IPFlowProtocolUDP
)

type IPVersion = original.IPVersion

const (
	IPv4 IPVersion = original.IPv4
	IPv6 IPVersion = original.IPv6
)

type IkeEncryption = original.IkeEncryption

const (
	AES128    IkeEncryption = original.AES128
	AES192    IkeEncryption = original.AES192
	AES256    IkeEncryption = original.AES256
	DES       IkeEncryption = original.DES
	DES3      IkeEncryption = original.DES3
	GCMAES128 IkeEncryption = original.GCMAES128
	GCMAES256 IkeEncryption = original.GCMAES256
)

type IkeIntegrity = original.IkeIntegrity

const (
	IkeIntegrityGCMAES128 IkeIntegrity = original.IkeIntegrityGCMAES128
	IkeIntegrityGCMAES256 IkeIntegrity = original.IkeIntegrityGCMAES256
	IkeIntegrityMD5       IkeIntegrity = original.IkeIntegrityMD5
	IkeIntegritySHA1      IkeIntegrity = original.IkeIntegritySHA1
	IkeIntegritySHA256    IkeIntegrity = original.IkeIntegritySHA256
	IkeIntegritySHA384    IkeIntegrity = original.IkeIntegritySHA384
)

type InboundSecurityRulesProtocol = original.InboundSecurityRulesProtocol

const (
	InboundSecurityRulesProtocolTCP InboundSecurityRulesProtocol = original.InboundSecurityRulesProtocolTCP
	InboundSecurityRulesProtocolUDP InboundSecurityRulesProtocol = original.InboundSecurityRulesProtocolUDP
)

type IntentPolicyBasedService = original.IntentPolicyBasedService

const (
	IntentPolicyBasedServiceAll            IntentPolicyBasedService = original.IntentPolicyBasedServiceAll
	IntentPolicyBasedServiceAllowRulesOnly IntentPolicyBasedService = original.IntentPolicyBasedServiceAllowRulesOnly
	IntentPolicyBasedServiceNone           IntentPolicyBasedService = original.IntentPolicyBasedServiceNone
)

type InterfaceAuxiliaryMode = original.InterfaceAuxiliaryMode

const (
	InterfaceAuxiliaryModeFloating       InterfaceAuxiliaryMode = original.InterfaceAuxiliaryModeFloating
	InterfaceAuxiliaryModeMaxConnections InterfaceAuxiliaryMode = original.InterfaceAuxiliaryModeMaxConnections
	InterfaceAuxiliaryModeNone           InterfaceAuxiliaryMode = original.InterfaceAuxiliaryModeNone
)

type InterfaceMigrationPhase = original.InterfaceMigrationPhase

const (
	InterfaceMigrationPhaseAbort     InterfaceMigrationPhase = original.InterfaceMigrationPhaseAbort
	InterfaceMigrationPhaseCommit    InterfaceMigrationPhase = original.InterfaceMigrationPhaseCommit
	InterfaceMigrationPhaseCommitted InterfaceMigrationPhase = original.InterfaceMigrationPhaseCommitted
	InterfaceMigrationPhaseNone      InterfaceMigrationPhase = original.InterfaceMigrationPhaseNone
	InterfaceMigrationPhasePrepare   InterfaceMigrationPhase = original.InterfaceMigrationPhasePrepare
)

type InterfaceNicType = original.InterfaceNicType

const (
	Elastic  InterfaceNicType = original.Elastic
	Standard InterfaceNicType = original.Standard
)

type IpsecEncryption = original.IpsecEncryption

const (
	IpsecEncryptionAES128    IpsecEncryption = original.IpsecEncryptionAES128
	IpsecEncryptionAES192    IpsecEncryption = original.IpsecEncryptionAES192
	IpsecEncryptionAES256    IpsecEncryption = original.IpsecEncryptionAES256
	IpsecEncryptionDES       IpsecEncryption = original.IpsecEncryptionDES
	IpsecEncryptionDES3      IpsecEncryption = original.IpsecEncryptionDES3
	IpsecEncryptionGCMAES128 IpsecEncryption = original.IpsecEncryptionGCMAES128
	IpsecEncryptionGCMAES192 IpsecEncryption = original.IpsecEncryptionGCMAES192
	IpsecEncryptionGCMAES256 IpsecEncryption = original.IpsecEncryptionGCMAES256
	IpsecEncryptionNone      IpsecEncryption = original.IpsecEncryptionNone
)

type IpsecIntegrity = original.IpsecIntegrity

const (
	IpsecIntegrityGCMAES128 IpsecIntegrity = original.IpsecIntegrityGCMAES128
	IpsecIntegrityGCMAES192 IpsecIntegrity = original.IpsecIntegrityGCMAES192
	IpsecIntegrityGCMAES256 IpsecIntegrity = original.IpsecIntegrityGCMAES256
	IpsecIntegrityMD5       IpsecIntegrity = original.IpsecIntegrityMD5
	IpsecIntegritySHA1      IpsecIntegrity = original.IpsecIntegritySHA1
	IpsecIntegritySHA256    IpsecIntegrity = original.IpsecIntegritySHA256
)

type IsGlobal = original.IsGlobal

const (
	IsGlobalFalse IsGlobal = original.IsGlobalFalse
	IsGlobalTrue  IsGlobal = original.IsGlobalTrue
)

type IsWorkloadProtected = original.IsWorkloadProtected

const (
	IsWorkloadProtectedFalse IsWorkloadProtected = original.IsWorkloadProtectedFalse
	IsWorkloadProtectedTrue  IsWorkloadProtected = original.IsWorkloadProtectedTrue
)

type IssueType = original.IssueType

const (
	IssueTypeAgentStopped        IssueType = original.IssueTypeAgentStopped
	IssueTypeDNSResolution       IssueType = original.IssueTypeDNSResolution
	IssueTypeGuestFirewall       IssueType = original.IssueTypeGuestFirewall
	IssueTypeNetworkSecurityRule IssueType = original.IssueTypeNetworkSecurityRule
	IssueTypePlatform            IssueType = original.IssueTypePlatform
	IssueTypePortThrottled       IssueType = original.IssueTypePortThrottled
	IssueTypeSocketBind          IssueType = original.IssueTypeSocketBind
	IssueTypeUnknown             IssueType = original.IssueTypeUnknown
	IssueTypeUserDefinedRoute    IssueType = original.IssueTypeUserDefinedRoute
)

type Kind = original.Kind

const (
	KindActiveBaseSecurityAdminRule Kind = original.KindActiveBaseSecurityAdminRule
	KindCustom                      Kind = original.KindCustom
	KindDefault                     Kind = original.KindDefault
)

type KindBasicBaseAdminRule = original.KindBasicBaseAdminRule

const (
	KindBasicBaseAdminRuleKindBaseAdminRule KindBasicBaseAdminRule = original.KindBasicBaseAdminRuleKindBaseAdminRule
	KindBasicBaseAdminRuleKindCustom        KindBasicBaseAdminRule = original.KindBasicBaseAdminRuleKindCustom
	KindBasicBaseAdminRuleKindDefault       KindBasicBaseAdminRule = original.KindBasicBaseAdminRuleKindDefault
)

type KindBasicEffectiveBaseSecurityAdminRule = original.KindBasicEffectiveBaseSecurityAdminRule

const (
	KindBasicEffectiveBaseSecurityAdminRuleKindCustom                         KindBasicEffectiveBaseSecurityAdminRule = original.KindBasicEffectiveBaseSecurityAdminRuleKindCustom
	KindBasicEffectiveBaseSecurityAdminRuleKindDefault                        KindBasicEffectiveBaseSecurityAdminRule = original.KindBasicEffectiveBaseSecurityAdminRuleKindDefault
	KindBasicEffectiveBaseSecurityAdminRuleKindEffectiveBaseSecurityAdminRule KindBasicEffectiveBaseSecurityAdminRule = original.KindBasicEffectiveBaseSecurityAdminRuleKindEffectiveBaseSecurityAdminRule
)

type LoadBalancerBackendAddressAdminState = original.LoadBalancerBackendAddressAdminState

const (
	LoadBalancerBackendAddressAdminStateDown  LoadBalancerBackendAddressAdminState = original.LoadBalancerBackendAddressAdminStateDown
	LoadBalancerBackendAddressAdminStateDrain LoadBalancerBackendAddressAdminState = original.LoadBalancerBackendAddressAdminStateDrain
	LoadBalancerBackendAddressAdminStateNone  LoadBalancerBackendAddressAdminState = original.LoadBalancerBackendAddressAdminStateNone
	LoadBalancerBackendAddressAdminStateUp    LoadBalancerBackendAddressAdminState = original.LoadBalancerBackendAddressAdminStateUp
)

type LoadBalancerOutboundRuleProtocol = original.LoadBalancerOutboundRuleProtocol

const (
	LoadBalancerOutboundRuleProtocolAll LoadBalancerOutboundRuleProtocol = original.LoadBalancerOutboundRuleProtocolAll
	LoadBalancerOutboundRuleProtocolTCP LoadBalancerOutboundRuleProtocol = original.LoadBalancerOutboundRuleProtocolTCP
	LoadBalancerOutboundRuleProtocolUDP LoadBalancerOutboundRuleProtocol = original.LoadBalancerOutboundRuleProtocolUDP
)

type LoadBalancerSkuName = original.LoadBalancerSkuName

const (
	LoadBalancerSkuNameBasic    LoadBalancerSkuName = original.LoadBalancerSkuNameBasic
	LoadBalancerSkuNameGateway  LoadBalancerSkuName = original.LoadBalancerSkuNameGateway
	LoadBalancerSkuNameStandard LoadBalancerSkuName = original.LoadBalancerSkuNameStandard
)

type LoadBalancerSkuTier = original.LoadBalancerSkuTier

const (
	Global   LoadBalancerSkuTier = original.Global
	Regional LoadBalancerSkuTier = original.Regional
)

type LoadDistribution = original.LoadDistribution

const (
	LoadDistributionDefault          LoadDistribution = original.LoadDistributionDefault
	LoadDistributionSourceIP         LoadDistribution = original.LoadDistributionSourceIP
	LoadDistributionSourceIPProtocol LoadDistribution = original.LoadDistributionSourceIPProtocol
)

type ManagedRuleEnabledState = original.ManagedRuleEnabledState

const (
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = original.ManagedRuleEnabledStateDisabled
	ManagedRuleEnabledStateEnabled  ManagedRuleEnabledState = original.ManagedRuleEnabledStateEnabled
)

type NatGatewaySkuName = original.NatGatewaySkuName

const (
	NatGatewaySkuNameStandard NatGatewaySkuName = original.NatGatewaySkuNameStandard
)

type NextHopType = original.NextHopType

const (
	NextHopTypeHyperNetGateway       NextHopType = original.NextHopTypeHyperNetGateway
	NextHopTypeInternet              NextHopType = original.NextHopTypeInternet
	NextHopTypeNone                  NextHopType = original.NextHopTypeNone
	NextHopTypeVirtualAppliance      NextHopType = original.NextHopTypeVirtualAppliance
	NextHopTypeVirtualNetworkGateway NextHopType = original.NextHopTypeVirtualNetworkGateway
	NextHopTypeVnetLocal             NextHopType = original.NextHopTypeVnetLocal
)

type NextStep = original.NextStep

const (
	NextStepContinue  NextStep = original.NextStepContinue
	NextStepTerminate NextStep = original.NextStepTerminate
	NextStepUnknown   NextStep = original.NextStepUnknown
)

type OfficeTrafficCategory = original.OfficeTrafficCategory

const (
	OfficeTrafficCategoryAll              OfficeTrafficCategory = original.OfficeTrafficCategoryAll
	OfficeTrafficCategoryNone             OfficeTrafficCategory = original.OfficeTrafficCategoryNone
	OfficeTrafficCategoryOptimize         OfficeTrafficCategory = original.OfficeTrafficCategoryOptimize
	OfficeTrafficCategoryOptimizeAndAllow OfficeTrafficCategory = original.OfficeTrafficCategoryOptimizeAndAllow
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
)

type Origin = original.Origin

const (
	OriginInbound  Origin = original.OriginInbound
	OriginLocal    Origin = original.OriginLocal
	OriginOutbound Origin = original.OriginOutbound
)

type OutputType = original.OutputType

const (
	Workspace OutputType = original.Workspace
)

type OwaspCrsExclusionEntryMatchVariable = original.OwaspCrsExclusionEntryMatchVariable

const (
	RequestArgKeys      OwaspCrsExclusionEntryMatchVariable = original.RequestArgKeys
	RequestArgNames     OwaspCrsExclusionEntryMatchVariable = original.RequestArgNames
	RequestArgValues    OwaspCrsExclusionEntryMatchVariable = original.RequestArgValues
	RequestCookieKeys   OwaspCrsExclusionEntryMatchVariable = original.RequestCookieKeys
	RequestCookieNames  OwaspCrsExclusionEntryMatchVariable = original.RequestCookieNames
	RequestCookieValues OwaspCrsExclusionEntryMatchVariable = original.RequestCookieValues
	RequestHeaderKeys   OwaspCrsExclusionEntryMatchVariable = original.RequestHeaderKeys
	RequestHeaderNames  OwaspCrsExclusionEntryMatchVariable = original.RequestHeaderNames
	RequestHeaderValues OwaspCrsExclusionEntryMatchVariable = original.RequestHeaderValues
)

type OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperator

const (
	OwaspCrsExclusionEntrySelectorMatchOperatorContains   OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorContains
	OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith   OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith
	OwaspCrsExclusionEntrySelectorMatchOperatorEquals     OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorEquals
	OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny  OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny
	OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith
)

type PacketCaptureTargetType = original.PacketCaptureTargetType

const (
	PacketCaptureTargetTypeAzureVM   PacketCaptureTargetType = original.PacketCaptureTargetTypeAzureVM
	PacketCaptureTargetTypeAzureVMSS PacketCaptureTargetType = original.PacketCaptureTargetTypeAzureVMSS
)

type PcError = original.PcError

const (
	AgentStopped    PcError = original.AgentStopped
	CaptureFailed   PcError = original.CaptureFailed
	InternalError   PcError = original.InternalError
	LocalFileFailed PcError = original.LocalFileFailed
	StorageFailed   PcError = original.StorageFailed
)

type PcProtocol = original.PcProtocol

const (
	PcProtocolAny PcProtocol = original.PcProtocolAny
	PcProtocolTCP PcProtocol = original.PcProtocolTCP
	PcProtocolUDP PcProtocol = original.PcProtocolUDP
)

type PcStatus = original.PcStatus

const (
	PcStatusError      PcStatus = original.PcStatusError
	PcStatusNotStarted PcStatus = original.PcStatusNotStarted
	PcStatusRunning    PcStatus = original.PcStatusRunning
	PcStatusStopped    PcStatus = original.PcStatusStopped
	PcStatusUnknown    PcStatus = original.PcStatusUnknown
)

type PfsGroup = original.PfsGroup

const (
	PfsGroupECP256  PfsGroup = original.PfsGroupECP256
	PfsGroupECP384  PfsGroup = original.PfsGroupECP384
	PfsGroupNone    PfsGroup = original.PfsGroupNone
	PfsGroupPFS1    PfsGroup = original.PfsGroupPFS1
	PfsGroupPFS14   PfsGroup = original.PfsGroupPFS14
	PfsGroupPFS2    PfsGroup = original.PfsGroupPFS2
	PfsGroupPFS2048 PfsGroup = original.PfsGroupPFS2048
	PfsGroupPFS24   PfsGroup = original.PfsGroupPFS24
	PfsGroupPFSMM   PfsGroup = original.PfsGroupPFSMM
)

type PreferredIPVersion = original.PreferredIPVersion

const (
	PreferredIPVersionIPv4 PreferredIPVersion = original.PreferredIPVersionIPv4
	PreferredIPVersionIPv6 PreferredIPVersion = original.PreferredIPVersionIPv6
)

type PreferredRoutingGateway = original.PreferredRoutingGateway

const (
	PreferredRoutingGatewayExpressRoute PreferredRoutingGateway = original.PreferredRoutingGatewayExpressRoute
	PreferredRoutingGatewayNone         PreferredRoutingGateway = original.PreferredRoutingGatewayNone
	PreferredRoutingGatewayVpnGateway   PreferredRoutingGateway = original.PreferredRoutingGatewayVpnGateway
)

type ProbeProtocol = original.ProbeProtocol

const (
	ProbeProtocolHTTP  ProbeProtocol = original.ProbeProtocolHTTP
	ProbeProtocolHTTPS ProbeProtocol = original.ProbeProtocolHTTPS
	ProbeProtocolTCP   ProbeProtocol = original.ProbeProtocolTCP
)

type ProcessorArchitecture = original.ProcessorArchitecture

const (
	Amd64 ProcessorArchitecture = original.Amd64
	X86   ProcessorArchitecture = original.X86
)

type Protocol = original.Protocol

const (
	ProtocolHTTP  Protocol = original.ProtocolHTTP
	ProtocolHTTPS Protocol = original.ProtocolHTTPS
	ProtocolIcmp  Protocol = original.ProtocolIcmp
	ProtocolTCP   Protocol = original.ProtocolTCP
)

type ProtocolType = original.ProtocolType

const (
	ProtocolTypeAh       ProtocolType = original.ProtocolTypeAh
	ProtocolTypeAll      ProtocolType = original.ProtocolTypeAll
	ProtocolTypeDoNotUse ProtocolType = original.ProtocolTypeDoNotUse
	ProtocolTypeEsp      ProtocolType = original.ProtocolTypeEsp
	ProtocolTypeGre      ProtocolType = original.ProtocolTypeGre
	ProtocolTypeIcmp     ProtocolType = original.ProtocolTypeIcmp
	ProtocolTypeTCP      ProtocolType = original.ProtocolTypeTCP
	ProtocolTypeUDP      ProtocolType = original.ProtocolTypeUDP
	ProtocolTypeVxlan    ProtocolType = original.ProtocolTypeVxlan
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateDeleting  ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
	ProvisioningStateUpdating  ProvisioningState = original.ProvisioningStateUpdating
)

type PublicIPAddressMigrationPhase = original.PublicIPAddressMigrationPhase

const (
	PublicIPAddressMigrationPhaseAbort     PublicIPAddressMigrationPhase = original.PublicIPAddressMigrationPhaseAbort
	PublicIPAddressMigrationPhaseCommit    PublicIPAddressMigrationPhase = original.PublicIPAddressMigrationPhaseCommit
	PublicIPAddressMigrationPhaseCommitted PublicIPAddressMigrationPhase = original.PublicIPAddressMigrationPhaseCommitted
	PublicIPAddressMigrationPhaseNone      PublicIPAddressMigrationPhase = original.PublicIPAddressMigrationPhaseNone
	PublicIPAddressMigrationPhasePrepare   PublicIPAddressMigrationPhase = original.PublicIPAddressMigrationPhasePrepare
)

type PublicIPAddressSkuName = original.PublicIPAddressSkuName

const (
	PublicIPAddressSkuNameBasic    PublicIPAddressSkuName = original.PublicIPAddressSkuNameBasic
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = original.PublicIPAddressSkuNameStandard
)

type PublicIPAddressSkuTier = original.PublicIPAddressSkuTier

const (
	PublicIPAddressSkuTierGlobal   PublicIPAddressSkuTier = original.PublicIPAddressSkuTierGlobal
	PublicIPAddressSkuTierRegional PublicIPAddressSkuTier = original.PublicIPAddressSkuTierRegional
)

type PublicIPPrefixSkuName = original.PublicIPPrefixSkuName

const (
	PublicIPPrefixSkuNameStandard PublicIPPrefixSkuName = original.PublicIPPrefixSkuNameStandard
)

type PublicIPPrefixSkuTier = original.PublicIPPrefixSkuTier

const (
	PublicIPPrefixSkuTierGlobal   PublicIPPrefixSkuTier = original.PublicIPPrefixSkuTierGlobal
	PublicIPPrefixSkuTierRegional PublicIPPrefixSkuTier = original.PublicIPPrefixSkuTierRegional
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone                       ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeSystemAssigned             ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssignedUserAssigned
	ResourceIdentityTypeUserAssigned               ResourceIdentityType = original.ResourceIdentityTypeUserAssigned
)

type RouteMapActionType = original.RouteMapActionType

const (
	RouteMapActionTypeAdd     RouteMapActionType = original.RouteMapActionTypeAdd
	RouteMapActionTypeDrop    RouteMapActionType = original.RouteMapActionTypeDrop
	RouteMapActionTypeRemove  RouteMapActionType = original.RouteMapActionTypeRemove
	RouteMapActionTypeReplace RouteMapActionType = original.RouteMapActionTypeReplace
	RouteMapActionTypeUnknown RouteMapActionType = original.RouteMapActionTypeUnknown
)

type RouteMapMatchCondition = original.RouteMapMatchCondition

const (
	RouteMapMatchConditionContains    RouteMapMatchCondition = original.RouteMapMatchConditionContains
	RouteMapMatchConditionEquals      RouteMapMatchCondition = original.RouteMapMatchConditionEquals
	RouteMapMatchConditionNotContains RouteMapMatchCondition = original.RouteMapMatchConditionNotContains
	RouteMapMatchConditionNotEquals   RouteMapMatchCondition = original.RouteMapMatchConditionNotEquals
	RouteMapMatchConditionUnknown     RouteMapMatchCondition = original.RouteMapMatchConditionUnknown
)

type RouteNextHopType = original.RouteNextHopType

const (
	RouteNextHopTypeInternet              RouteNextHopType = original.RouteNextHopTypeInternet
	RouteNextHopTypeNone                  RouteNextHopType = original.RouteNextHopTypeNone
	RouteNextHopTypeVirtualAppliance      RouteNextHopType = original.RouteNextHopTypeVirtualAppliance
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = original.RouteNextHopTypeVirtualNetworkGateway
	RouteNextHopTypeVnetLocal             RouteNextHopType = original.RouteNextHopTypeVnetLocal
)

type RoutingState = original.RoutingState

const (
	RoutingStateFailed       RoutingState = original.RoutingStateFailed
	RoutingStateNone         RoutingState = original.RoutingStateNone
	RoutingStateProvisioned  RoutingState = original.RoutingStateProvisioned
	RoutingStateProvisioning RoutingState = original.RoutingStateProvisioning
)

type RuleCollectionType = original.RuleCollectionType

const (
	RuleCollectionTypeFirewallPolicyFilterRuleCollection RuleCollectionType = original.RuleCollectionTypeFirewallPolicyFilterRuleCollection
	RuleCollectionTypeFirewallPolicyNatRuleCollection    RuleCollectionType = original.RuleCollectionTypeFirewallPolicyNatRuleCollection
	RuleCollectionTypeFirewallPolicyRuleCollection       RuleCollectionType = original.RuleCollectionTypeFirewallPolicyRuleCollection
)

type RuleType = original.RuleType

const (
	RuleTypeApplicationRule    RuleType = original.RuleTypeApplicationRule
	RuleTypeFirewallPolicyRule RuleType = original.RuleTypeFirewallPolicyRule
	RuleTypeNatRule            RuleType = original.RuleTypeNatRule
	RuleTypeNetworkRule        RuleType = original.RuleTypeNetworkRule
)

type ScopeConnectionState = original.ScopeConnectionState

const (
	ScopeConnectionStateConflict  ScopeConnectionState = original.ScopeConnectionStateConflict
	ScopeConnectionStateConnected ScopeConnectionState = original.ScopeConnectionStateConnected
	ScopeConnectionStatePending   ScopeConnectionState = original.ScopeConnectionStatePending
	ScopeConnectionStateRejected  ScopeConnectionState = original.ScopeConnectionStateRejected
	ScopeConnectionStateRevoked   ScopeConnectionState = original.ScopeConnectionStateRevoked
)

type SecurityConfigurationRuleAccess = original.SecurityConfigurationRuleAccess

const (
	SecurityConfigurationRuleAccessAllow       SecurityConfigurationRuleAccess = original.SecurityConfigurationRuleAccessAllow
	SecurityConfigurationRuleAccessAlwaysAllow SecurityConfigurationRuleAccess = original.SecurityConfigurationRuleAccessAlwaysAllow
	SecurityConfigurationRuleAccessDeny        SecurityConfigurationRuleAccess = original.SecurityConfigurationRuleAccessDeny
)

type SecurityConfigurationRuleDirection = original.SecurityConfigurationRuleDirection

const (
	SecurityConfigurationRuleDirectionInbound  SecurityConfigurationRuleDirection = original.SecurityConfigurationRuleDirectionInbound
	SecurityConfigurationRuleDirectionOutbound SecurityConfigurationRuleDirection = original.SecurityConfigurationRuleDirectionOutbound
)

type SecurityConfigurationRuleProtocol = original.SecurityConfigurationRuleProtocol

const (
	SecurityConfigurationRuleProtocolAh   SecurityConfigurationRuleProtocol = original.SecurityConfigurationRuleProtocolAh
	SecurityConfigurationRuleProtocolAny  SecurityConfigurationRuleProtocol = original.SecurityConfigurationRuleProtocolAny
	SecurityConfigurationRuleProtocolEsp  SecurityConfigurationRuleProtocol = original.SecurityConfigurationRuleProtocolEsp
	SecurityConfigurationRuleProtocolIcmp SecurityConfigurationRuleProtocol = original.SecurityConfigurationRuleProtocolIcmp
	SecurityConfigurationRuleProtocolTCP  SecurityConfigurationRuleProtocol = original.SecurityConfigurationRuleProtocolTCP
	SecurityConfigurationRuleProtocolUDP  SecurityConfigurationRuleProtocol = original.SecurityConfigurationRuleProtocolUDP
)

type SecurityPartnerProviderConnectionStatus = original.SecurityPartnerProviderConnectionStatus

const (
	SecurityPartnerProviderConnectionStatusConnected          SecurityPartnerProviderConnectionStatus = original.SecurityPartnerProviderConnectionStatusConnected
	SecurityPartnerProviderConnectionStatusNotConnected       SecurityPartnerProviderConnectionStatus = original.SecurityPartnerProviderConnectionStatusNotConnected
	SecurityPartnerProviderConnectionStatusPartiallyConnected SecurityPartnerProviderConnectionStatus = original.SecurityPartnerProviderConnectionStatusPartiallyConnected
	SecurityPartnerProviderConnectionStatusUnknown            SecurityPartnerProviderConnectionStatus = original.SecurityPartnerProviderConnectionStatusUnknown
)

type SecurityProviderName = original.SecurityProviderName

const (
	Checkpoint SecurityProviderName = original.Checkpoint
	IBoss      SecurityProviderName = original.IBoss
	ZScaler    SecurityProviderName = original.ZScaler
)

type SecurityRuleAccess = original.SecurityRuleAccess

const (
	SecurityRuleAccessAllow SecurityRuleAccess = original.SecurityRuleAccessAllow
	SecurityRuleAccessDeny  SecurityRuleAccess = original.SecurityRuleAccessDeny
)

type SecurityRuleDirection = original.SecurityRuleDirection

const (
	SecurityRuleDirectionInbound  SecurityRuleDirection = original.SecurityRuleDirectionInbound
	SecurityRuleDirectionOutbound SecurityRuleDirection = original.SecurityRuleDirectionOutbound
)

type SecurityRuleProtocol = original.SecurityRuleProtocol

const (
	SecurityRuleProtocolAh       SecurityRuleProtocol = original.SecurityRuleProtocolAh
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = original.SecurityRuleProtocolAsterisk
	SecurityRuleProtocolEsp      SecurityRuleProtocol = original.SecurityRuleProtocolEsp
	SecurityRuleProtocolIcmp     SecurityRuleProtocol = original.SecurityRuleProtocolIcmp
	SecurityRuleProtocolTCP      SecurityRuleProtocol = original.SecurityRuleProtocolTCP
	SecurityRuleProtocolUDP      SecurityRuleProtocol = original.SecurityRuleProtocolUDP
)

type ServiceProviderProvisioningState = original.ServiceProviderProvisioningState

const (
	ServiceProviderProvisioningStateDeprovisioning ServiceProviderProvisioningState = original.ServiceProviderProvisioningStateDeprovisioning
	ServiceProviderProvisioningStateNotProvisioned ServiceProviderProvisioningState = original.ServiceProviderProvisioningStateNotProvisioned
	ServiceProviderProvisioningStateProvisioned    ServiceProviderProvisioningState = original.ServiceProviderProvisioningStateProvisioned
	ServiceProviderProvisioningStateProvisioning   ServiceProviderProvisioningState = original.ServiceProviderProvisioningStateProvisioning
)

type Severity = original.Severity

const (
	SeverityError   Severity = original.SeverityError
	SeverityWarning Severity = original.SeverityWarning
)

type SlotType = original.SlotType

const (
	Production SlotType = original.Production
	Staging    SlotType = original.Staging
)

type SyncRemoteAddressSpace = original.SyncRemoteAddressSpace

const (
	SyncRemoteAddressSpaceTrue SyncRemoteAddressSpace = original.SyncRemoteAddressSpaceTrue
)

type TransportProtocol = original.TransportProtocol

const (
	TransportProtocolAll TransportProtocol = original.TransportProtocolAll
	TransportProtocolTCP TransportProtocol = original.TransportProtocolTCP
	TransportProtocolUDP TransportProtocol = original.TransportProtocolUDP
)

type TunnelConnectionStatus = original.TunnelConnectionStatus

const (
	TunnelConnectionStatusConnected    TunnelConnectionStatus = original.TunnelConnectionStatusConnected
	TunnelConnectionStatusConnecting   TunnelConnectionStatus = original.TunnelConnectionStatusConnecting
	TunnelConnectionStatusNotConnected TunnelConnectionStatus = original.TunnelConnectionStatusNotConnected
	TunnelConnectionStatusUnknown      TunnelConnectionStatus = original.TunnelConnectionStatusUnknown
)

type UseHubGateway = original.UseHubGateway

const (
	UseHubGatewayFalse UseHubGateway = original.UseHubGatewayFalse
	UseHubGatewayTrue  UseHubGateway = original.UseHubGatewayTrue
)

type VerbosityLevel = original.VerbosityLevel

const (
	VerbosityLevelFull    VerbosityLevel = original.VerbosityLevelFull
	VerbosityLevelMinimum VerbosityLevel = original.VerbosityLevelMinimum
	VerbosityLevelNormal  VerbosityLevel = original.VerbosityLevelNormal
)

type VirtualNetworkEncryptionEnforcement = original.VirtualNetworkEncryptionEnforcement

const (
	AllowUnencrypted VirtualNetworkEncryptionEnforcement = original.AllowUnencrypted
	DropUnencrypted  VirtualNetworkEncryptionEnforcement = original.DropUnencrypted
)

type VirtualNetworkGatewayConnectionMode = original.VirtualNetworkGatewayConnectionMode

const (
	VirtualNetworkGatewayConnectionModeDefault       VirtualNetworkGatewayConnectionMode = original.VirtualNetworkGatewayConnectionModeDefault
	VirtualNetworkGatewayConnectionModeInitiatorOnly VirtualNetworkGatewayConnectionMode = original.VirtualNetworkGatewayConnectionModeInitiatorOnly
	VirtualNetworkGatewayConnectionModeResponderOnly VirtualNetworkGatewayConnectionMode = original.VirtualNetworkGatewayConnectionModeResponderOnly
)

type VirtualNetworkGatewayConnectionProtocol = original.VirtualNetworkGatewayConnectionProtocol

const (
	IKEv1 VirtualNetworkGatewayConnectionProtocol = original.IKEv1
	IKEv2 VirtualNetworkGatewayConnectionProtocol = original.IKEv2
)

type VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatus

const (
	VirtualNetworkGatewayConnectionStatusConnected    VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusConnected
	VirtualNetworkGatewayConnectionStatusConnecting   VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusConnecting
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusNotConnected
	VirtualNetworkGatewayConnectionStatusUnknown      VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusUnknown
)

type VirtualNetworkGatewayConnectionType = original.VirtualNetworkGatewayConnectionType

const (
	ExpressRoute VirtualNetworkGatewayConnectionType = original.ExpressRoute
	IPsec        VirtualNetworkGatewayConnectionType = original.IPsec
	Vnet2Vnet    VirtualNetworkGatewayConnectionType = original.Vnet2Vnet
	VPNClient    VirtualNetworkGatewayConnectionType = original.VPNClient
)

type VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuName

const (
	VirtualNetworkGatewaySkuNameBasic            VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameBasic
	VirtualNetworkGatewaySkuNameErGw1AZ          VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameErGw1AZ
	VirtualNetworkGatewaySkuNameErGw2AZ          VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameErGw2AZ
	VirtualNetworkGatewaySkuNameErGw3AZ          VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameErGw3AZ
	VirtualNetworkGatewaySkuNameHighPerformance  VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameHighPerformance
	VirtualNetworkGatewaySkuNameStandard         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameStandard
	VirtualNetworkGatewaySkuNameUltraPerformance VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameUltraPerformance
	VirtualNetworkGatewaySkuNameVpnGw1           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw1
	VirtualNetworkGatewaySkuNameVpnGw1AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw1AZ
	VirtualNetworkGatewaySkuNameVpnGw2           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw2
	VirtualNetworkGatewaySkuNameVpnGw2AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw2AZ
	VirtualNetworkGatewaySkuNameVpnGw3           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw3
	VirtualNetworkGatewaySkuNameVpnGw3AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw3AZ
	VirtualNetworkGatewaySkuNameVpnGw4           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw4
	VirtualNetworkGatewaySkuNameVpnGw4AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw4AZ
	VirtualNetworkGatewaySkuNameVpnGw5           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw5
	VirtualNetworkGatewaySkuNameVpnGw5AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw5AZ
)

type VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTier

const (
	VirtualNetworkGatewaySkuTierBasic            VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierBasic
	VirtualNetworkGatewaySkuTierErGw1AZ          VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierErGw1AZ
	VirtualNetworkGatewaySkuTierErGw2AZ          VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierErGw2AZ
	VirtualNetworkGatewaySkuTierErGw3AZ          VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierErGw3AZ
	VirtualNetworkGatewaySkuTierHighPerformance  VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierHighPerformance
	VirtualNetworkGatewaySkuTierStandard         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierStandard
	VirtualNetworkGatewaySkuTierUltraPerformance VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierUltraPerformance
	VirtualNetworkGatewaySkuTierVpnGw1           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw1
	VirtualNetworkGatewaySkuTierVpnGw1AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw1AZ
	VirtualNetworkGatewaySkuTierVpnGw2           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw2
	VirtualNetworkGatewaySkuTierVpnGw2AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw2AZ
	VirtualNetworkGatewaySkuTierVpnGw3           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw3
	VirtualNetworkGatewaySkuTierVpnGw3AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw3AZ
	VirtualNetworkGatewaySkuTierVpnGw4           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw4
	VirtualNetworkGatewaySkuTierVpnGw4AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw4AZ
	VirtualNetworkGatewaySkuTierVpnGw5           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw5
	VirtualNetworkGatewaySkuTierVpnGw5AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw5AZ
)

type VirtualNetworkGatewayType = original.VirtualNetworkGatewayType

const (
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = original.VirtualNetworkGatewayTypeExpressRoute
	VirtualNetworkGatewayTypeLocalGateway VirtualNetworkGatewayType = original.VirtualNetworkGatewayTypeLocalGateway
	VirtualNetworkGatewayTypeVpn          VirtualNetworkGatewayType = original.VirtualNetworkGatewayTypeVpn
)

type VirtualNetworkPeeringLevel = original.VirtualNetworkPeeringLevel

const (
	FullyInSync             VirtualNetworkPeeringLevel = original.FullyInSync
	LocalAndRemoteNotInSync VirtualNetworkPeeringLevel = original.LocalAndRemoteNotInSync
	LocalNotInSync          VirtualNetworkPeeringLevel = original.LocalNotInSync
	RemoteNotInSync         VirtualNetworkPeeringLevel = original.RemoteNotInSync
)

type VirtualNetworkPeeringState = original.VirtualNetworkPeeringState

const (
	VirtualNetworkPeeringStateConnected    VirtualNetworkPeeringState = original.VirtualNetworkPeeringStateConnected
	VirtualNetworkPeeringStateDisconnected VirtualNetworkPeeringState = original.VirtualNetworkPeeringStateDisconnected
	VirtualNetworkPeeringStateInitiated    VirtualNetworkPeeringState = original.VirtualNetworkPeeringStateInitiated
)

type VirtualNetworkPrivateEndpointNetworkPolicies = original.VirtualNetworkPrivateEndpointNetworkPolicies

const (
	VirtualNetworkPrivateEndpointNetworkPoliciesDisabled VirtualNetworkPrivateEndpointNetworkPolicies = original.VirtualNetworkPrivateEndpointNetworkPoliciesDisabled
	VirtualNetworkPrivateEndpointNetworkPoliciesEnabled  VirtualNetworkPrivateEndpointNetworkPolicies = original.VirtualNetworkPrivateEndpointNetworkPoliciesEnabled
)

type VirtualNetworkPrivateLinkServiceNetworkPolicies = original.VirtualNetworkPrivateLinkServiceNetworkPolicies

const (
	VirtualNetworkPrivateLinkServiceNetworkPoliciesDisabled VirtualNetworkPrivateLinkServiceNetworkPolicies = original.VirtualNetworkPrivateLinkServiceNetworkPoliciesDisabled
	VirtualNetworkPrivateLinkServiceNetworkPoliciesEnabled  VirtualNetworkPrivateLinkServiceNetworkPolicies = original.VirtualNetworkPrivateLinkServiceNetworkPoliciesEnabled
)

type VirtualWanSecurityProviderType = original.VirtualWanSecurityProviderType

const (
	External VirtualWanSecurityProviderType = original.External
	Native   VirtualWanSecurityProviderType = original.Native
)

type VnetLocalRouteOverrideCriteria = original.VnetLocalRouteOverrideCriteria

const (
	VnetLocalRouteOverrideCriteriaContains VnetLocalRouteOverrideCriteria = original.VnetLocalRouteOverrideCriteriaContains
	VnetLocalRouteOverrideCriteriaEqual    VnetLocalRouteOverrideCriteria = original.VnetLocalRouteOverrideCriteriaEqual
)

type VpnAuthenticationType = original.VpnAuthenticationType

const (
	AAD         VpnAuthenticationType = original.AAD
	Certificate VpnAuthenticationType = original.Certificate
	Radius      VpnAuthenticationType = original.Radius
)

type VpnClientProtocol = original.VpnClientProtocol

const (
	IkeV2   VpnClientProtocol = original.IkeV2
	OpenVPN VpnClientProtocol = original.OpenVPN
	SSTP    VpnClientProtocol = original.SSTP
)

type VpnConnectionStatus = original.VpnConnectionStatus

const (
	VpnConnectionStatusConnected    VpnConnectionStatus = original.VpnConnectionStatusConnected
	VpnConnectionStatusConnecting   VpnConnectionStatus = original.VpnConnectionStatusConnecting
	VpnConnectionStatusNotConnected VpnConnectionStatus = original.VpnConnectionStatusNotConnected
	VpnConnectionStatusUnknown      VpnConnectionStatus = original.VpnConnectionStatusUnknown
)

type VpnGatewayGeneration = original.VpnGatewayGeneration

const (
	VpnGatewayGenerationGeneration1 VpnGatewayGeneration = original.VpnGatewayGenerationGeneration1
	VpnGatewayGenerationGeneration2 VpnGatewayGeneration = original.VpnGatewayGenerationGeneration2
	VpnGatewayGenerationNone        VpnGatewayGeneration = original.VpnGatewayGenerationNone
)

type VpnGatewayTunnelingProtocol = original.VpnGatewayTunnelingProtocol

const (
	VpnGatewayTunnelingProtocolIkeV2   VpnGatewayTunnelingProtocol = original.VpnGatewayTunnelingProtocolIkeV2
	VpnGatewayTunnelingProtocolOpenVPN VpnGatewayTunnelingProtocol = original.VpnGatewayTunnelingProtocolOpenVPN
)

type VpnLinkConnectionMode = original.VpnLinkConnectionMode

const (
	VpnLinkConnectionModeDefault       VpnLinkConnectionMode = original.VpnLinkConnectionModeDefault
	VpnLinkConnectionModeInitiatorOnly VpnLinkConnectionMode = original.VpnLinkConnectionModeInitiatorOnly
	VpnLinkConnectionModeResponderOnly VpnLinkConnectionMode = original.VpnLinkConnectionModeResponderOnly
)

type VpnNatRuleMode = original.VpnNatRuleMode

const (
	EgressSnat  VpnNatRuleMode = original.EgressSnat
	IngressSnat VpnNatRuleMode = original.IngressSnat
)

type VpnNatRuleType = original.VpnNatRuleType

const (
	VpnNatRuleTypeDynamic VpnNatRuleType = original.VpnNatRuleTypeDynamic
	VpnNatRuleTypeStatic  VpnNatRuleType = original.VpnNatRuleTypeStatic
)

type VpnPolicyMemberAttributeType = original.VpnPolicyMemberAttributeType

const (
	AADGroupID         VpnPolicyMemberAttributeType = original.AADGroupID
	CertificateGroupID VpnPolicyMemberAttributeType = original.CertificateGroupID
	RadiusAzureGroupID VpnPolicyMemberAttributeType = original.RadiusAzureGroupID
)

type VpnType = original.VpnType

const (
	PolicyBased VpnType = original.PolicyBased
	RouteBased  VpnType = original.RouteBased
)

type WebApplicationFirewallAction = original.WebApplicationFirewallAction

const (
	WebApplicationFirewallActionAllow WebApplicationFirewallAction = original.WebApplicationFirewallActionAllow
	WebApplicationFirewallActionBlock WebApplicationFirewallAction = original.WebApplicationFirewallActionBlock
	WebApplicationFirewallActionLog   WebApplicationFirewallAction = original.WebApplicationFirewallActionLog
)

type WebApplicationFirewallEnabledState = original.WebApplicationFirewallEnabledState

const (
	WebApplicationFirewallEnabledStateDisabled WebApplicationFirewallEnabledState = original.WebApplicationFirewallEnabledStateDisabled
	WebApplicationFirewallEnabledStateEnabled  WebApplicationFirewallEnabledState = original.WebApplicationFirewallEnabledStateEnabled
)

type WebApplicationFirewallMatchVariable = original.WebApplicationFirewallMatchVariable

const (
	PostArgs       WebApplicationFirewallMatchVariable = original.PostArgs
	QueryString    WebApplicationFirewallMatchVariable = original.QueryString
	RemoteAddr     WebApplicationFirewallMatchVariable = original.RemoteAddr
	RequestBody    WebApplicationFirewallMatchVariable = original.RequestBody
	RequestCookies WebApplicationFirewallMatchVariable = original.RequestCookies
	RequestHeaders WebApplicationFirewallMatchVariable = original.RequestHeaders
	RequestMethod  WebApplicationFirewallMatchVariable = original.RequestMethod
	RequestURI     WebApplicationFirewallMatchVariable = original.RequestURI
)

type WebApplicationFirewallMode = original.WebApplicationFirewallMode

const (
	WebApplicationFirewallModeDetection  WebApplicationFirewallMode = original.WebApplicationFirewallModeDetection
	WebApplicationFirewallModePrevention WebApplicationFirewallMode = original.WebApplicationFirewallModePrevention
)

type WebApplicationFirewallOperator = original.WebApplicationFirewallOperator

const (
	WebApplicationFirewallOperatorAny                WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorAny
	WebApplicationFirewallOperatorBeginsWith         WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorBeginsWith
	WebApplicationFirewallOperatorContains           WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorContains
	WebApplicationFirewallOperatorEndsWith           WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorEndsWith
	WebApplicationFirewallOperatorEqual              WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorEqual
	WebApplicationFirewallOperatorGeoMatch           WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorGeoMatch
	WebApplicationFirewallOperatorGreaterThan        WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorGreaterThan
	WebApplicationFirewallOperatorGreaterThanOrEqual WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorGreaterThanOrEqual
	WebApplicationFirewallOperatorIPMatch            WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorIPMatch
	WebApplicationFirewallOperatorLessThan           WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorLessThan
	WebApplicationFirewallOperatorLessThanOrEqual    WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorLessThanOrEqual
	WebApplicationFirewallOperatorRegex              WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorRegex
)

type WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceState

const (
	WebApplicationFirewallPolicyResourceStateCreating  WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateCreating
	WebApplicationFirewallPolicyResourceStateDeleting  WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateDeleting
	WebApplicationFirewallPolicyResourceStateDisabled  WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateDisabled
	WebApplicationFirewallPolicyResourceStateDisabling WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateDisabling
	WebApplicationFirewallPolicyResourceStateEnabled   WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateEnabled
	WebApplicationFirewallPolicyResourceStateEnabling  WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateEnabling
)

type WebApplicationFirewallRuleType = original.WebApplicationFirewallRuleType

const (
	WebApplicationFirewallRuleTypeInvalid   WebApplicationFirewallRuleType = original.WebApplicationFirewallRuleTypeInvalid
	WebApplicationFirewallRuleTypeMatchRule WebApplicationFirewallRuleType = original.WebApplicationFirewallRuleTypeMatchRule
)

type WebApplicationFirewallTransform = original.WebApplicationFirewallTransform

const (
	HTMLEntityDecode WebApplicationFirewallTransform = original.HTMLEntityDecode
	Lowercase        WebApplicationFirewallTransform = original.Lowercase
	RemoveNulls      WebApplicationFirewallTransform = original.RemoveNulls
	Trim             WebApplicationFirewallTransform = original.Trim
	Uppercase        WebApplicationFirewallTransform = original.Uppercase
	URLDecode        WebApplicationFirewallTransform = original.URLDecode
	URLEncode        WebApplicationFirewallTransform = original.URLEncode
)

type AadAuthenticationParameters = original.AadAuthenticationParameters
type Action = original.Action
type ActiveBaseSecurityAdminRule = original.ActiveBaseSecurityAdminRule
type ActiveConfigurationParameter = original.ActiveConfigurationParameter
type ActiveConnectivityConfiguration = original.ActiveConnectivityConfiguration
type ActiveConnectivityConfigurationsListResult = original.ActiveConnectivityConfigurationsListResult
type ActiveDefaultSecurityAdminRule = original.ActiveDefaultSecurityAdminRule
type ActiveSecurityAdminRule = original.ActiveSecurityAdminRule
type ActiveSecurityAdminRulesListResult = original.ActiveSecurityAdminRulesListResult
type AddressPrefixItem = original.AddressPrefixItem
type AddressSpace = original.AddressSpace
type AdminPropertiesFormat = original.AdminPropertiesFormat
type AdminRule = original.AdminRule
type AdminRuleCollection = original.AdminRuleCollection
type AdminRuleCollectionListResult = original.AdminRuleCollectionListResult
type AdminRuleCollectionListResultIterator = original.AdminRuleCollectionListResultIterator
type AdminRuleCollectionListResultPage = original.AdminRuleCollectionListResultPage
type AdminRuleCollectionPropertiesFormat = original.AdminRuleCollectionPropertiesFormat
type AdminRuleCollectionsClient = original.AdminRuleCollectionsClient
type AdminRuleCollectionsDeleteFuture = original.AdminRuleCollectionsDeleteFuture
type AdminRuleListResult = original.AdminRuleListResult
type AdminRuleListResultIterator = original.AdminRuleListResultIterator
type AdminRuleListResultPage = original.AdminRuleListResultPage
type AdminRulesClient = original.AdminRulesClient
type AdminRulesDeleteFuture = original.AdminRulesDeleteFuture
type ApplicationGateway = original.ApplicationGateway
type ApplicationGatewayAuthenticationCertificate = original.ApplicationGatewayAuthenticationCertificate
type ApplicationGatewayAuthenticationCertificatePropertiesFormat = original.ApplicationGatewayAuthenticationCertificatePropertiesFormat
type ApplicationGatewayAutoscaleConfiguration = original.ApplicationGatewayAutoscaleConfiguration
type ApplicationGatewayAvailableSslOptions = original.ApplicationGatewayAvailableSslOptions
type ApplicationGatewayAvailableSslOptionsPropertiesFormat = original.ApplicationGatewayAvailableSslOptionsPropertiesFormat
type ApplicationGatewayAvailableSslPredefinedPolicies = original.ApplicationGatewayAvailableSslPredefinedPolicies
type ApplicationGatewayAvailableSslPredefinedPoliciesIterator = original.ApplicationGatewayAvailableSslPredefinedPoliciesIterator
type ApplicationGatewayAvailableSslPredefinedPoliciesPage = original.ApplicationGatewayAvailableSslPredefinedPoliciesPage
type ApplicationGatewayAvailableWafRuleSetsResult = original.ApplicationGatewayAvailableWafRuleSetsResult
type ApplicationGatewayBackendAddress = original.ApplicationGatewayBackendAddress
type ApplicationGatewayBackendAddressPool = original.ApplicationGatewayBackendAddressPool
type ApplicationGatewayBackendAddressPoolPropertiesFormat = original.ApplicationGatewayBackendAddressPoolPropertiesFormat
type ApplicationGatewayBackendHTTPSettings = original.ApplicationGatewayBackendHTTPSettings
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat = original.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
type ApplicationGatewayBackendHealth = original.ApplicationGatewayBackendHealth
type ApplicationGatewayBackendHealthHTTPSettings = original.ApplicationGatewayBackendHealthHTTPSettings
type ApplicationGatewayBackendHealthOnDemand = original.ApplicationGatewayBackendHealthOnDemand
type ApplicationGatewayBackendHealthPool = original.ApplicationGatewayBackendHealthPool
type ApplicationGatewayBackendHealthServer = original.ApplicationGatewayBackendHealthServer
type ApplicationGatewayBackendSettings = original.ApplicationGatewayBackendSettings
type ApplicationGatewayBackendSettingsPropertiesFormat = original.ApplicationGatewayBackendSettingsPropertiesFormat
type ApplicationGatewayClientAuthConfiguration = original.ApplicationGatewayClientAuthConfiguration
type ApplicationGatewayConnectionDraining = original.ApplicationGatewayConnectionDraining
type ApplicationGatewayCustomError = original.ApplicationGatewayCustomError
type ApplicationGatewayFirewallDisabledRuleGroup = original.ApplicationGatewayFirewallDisabledRuleGroup
type ApplicationGatewayFirewallExclusion = original.ApplicationGatewayFirewallExclusion
type ApplicationGatewayFirewallManifestRuleSet = original.ApplicationGatewayFirewallManifestRuleSet
type ApplicationGatewayFirewallRule = original.ApplicationGatewayFirewallRule
type ApplicationGatewayFirewallRuleGroup = original.ApplicationGatewayFirewallRuleGroup
type ApplicationGatewayFirewallRuleSet = original.ApplicationGatewayFirewallRuleSet
type ApplicationGatewayFirewallRuleSetPropertiesFormat = original.ApplicationGatewayFirewallRuleSetPropertiesFormat
type ApplicationGatewayFrontendIPConfiguration = original.ApplicationGatewayFrontendIPConfiguration
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat = original.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
type ApplicationGatewayFrontendPort = original.ApplicationGatewayFrontendPort
type ApplicationGatewayFrontendPortPropertiesFormat = original.ApplicationGatewayFrontendPortPropertiesFormat
type ApplicationGatewayGlobalConfiguration = original.ApplicationGatewayGlobalConfiguration
type ApplicationGatewayHTTPListener = original.ApplicationGatewayHTTPListener
type ApplicationGatewayHTTPListenerPropertiesFormat = original.ApplicationGatewayHTTPListenerPropertiesFormat
type ApplicationGatewayHeaderConfiguration = original.ApplicationGatewayHeaderConfiguration
type ApplicationGatewayIPConfiguration = original.ApplicationGatewayIPConfiguration
type ApplicationGatewayIPConfigurationPropertiesFormat = original.ApplicationGatewayIPConfigurationPropertiesFormat
type ApplicationGatewayListResult = original.ApplicationGatewayListResult
type ApplicationGatewayListResultIterator = original.ApplicationGatewayListResultIterator
type ApplicationGatewayListResultPage = original.ApplicationGatewayListResultPage
type ApplicationGatewayListener = original.ApplicationGatewayListener
type ApplicationGatewayListenerPropertiesFormat = original.ApplicationGatewayListenerPropertiesFormat
type ApplicationGatewayLoadDistributionPolicy = original.ApplicationGatewayLoadDistributionPolicy
type ApplicationGatewayLoadDistributionPolicyPropertiesFormat = original.ApplicationGatewayLoadDistributionPolicyPropertiesFormat
type ApplicationGatewayLoadDistributionTarget = original.ApplicationGatewayLoadDistributionTarget
type ApplicationGatewayLoadDistributionTargetPropertiesFormat = original.ApplicationGatewayLoadDistributionTargetPropertiesFormat
type ApplicationGatewayOnDemandProbe = original.ApplicationGatewayOnDemandProbe
type ApplicationGatewayPathRule = original.ApplicationGatewayPathRule
type ApplicationGatewayPathRulePropertiesFormat = original.ApplicationGatewayPathRulePropertiesFormat
type ApplicationGatewayPrivateEndpointConnection = original.ApplicationGatewayPrivateEndpointConnection
type ApplicationGatewayPrivateEndpointConnectionListResult = original.ApplicationGatewayPrivateEndpointConnectionListResult
type ApplicationGatewayPrivateEndpointConnectionListResultIterator = original.ApplicationGatewayPrivateEndpointConnectionListResultIterator
type ApplicationGatewayPrivateEndpointConnectionListResultPage = original.ApplicationGatewayPrivateEndpointConnectionListResultPage
type ApplicationGatewayPrivateEndpointConnectionProperties = original.ApplicationGatewayPrivateEndpointConnectionProperties
type ApplicationGatewayPrivateEndpointConnectionsClient = original.ApplicationGatewayPrivateEndpointConnectionsClient
type ApplicationGatewayPrivateEndpointConnectionsDeleteFuture = original.ApplicationGatewayPrivateEndpointConnectionsDeleteFuture
type ApplicationGatewayPrivateEndpointConnectionsUpdateFuture = original.ApplicationGatewayPrivateEndpointConnectionsUpdateFuture
type ApplicationGatewayPrivateLinkConfiguration = original.ApplicationGatewayPrivateLinkConfiguration
type ApplicationGatewayPrivateLinkConfigurationProperties = original.ApplicationGatewayPrivateLinkConfigurationProperties
type ApplicationGatewayPrivateLinkIPConfiguration = original.ApplicationGatewayPrivateLinkIPConfiguration
type ApplicationGatewayPrivateLinkIPConfigurationProperties = original.ApplicationGatewayPrivateLinkIPConfigurationProperties
type ApplicationGatewayPrivateLinkResource = original.ApplicationGatewayPrivateLinkResource
type ApplicationGatewayPrivateLinkResourceListResult = original.ApplicationGatewayPrivateLinkResourceListResult
type ApplicationGatewayPrivateLinkResourceListResultIterator = original.ApplicationGatewayPrivateLinkResourceListResultIterator
type ApplicationGatewayPrivateLinkResourceListResultPage = original.ApplicationGatewayPrivateLinkResourceListResultPage
type ApplicationGatewayPrivateLinkResourceProperties = original.ApplicationGatewayPrivateLinkResourceProperties
type ApplicationGatewayPrivateLinkResourcesClient = original.ApplicationGatewayPrivateLinkResourcesClient
type ApplicationGatewayProbe = original.ApplicationGatewayProbe
type ApplicationGatewayProbeHealthResponseMatch = original.ApplicationGatewayProbeHealthResponseMatch
type ApplicationGatewayProbePropertiesFormat = original.ApplicationGatewayProbePropertiesFormat
type ApplicationGatewayPropertiesFormat = original.ApplicationGatewayPropertiesFormat
type ApplicationGatewayRedirectConfiguration = original.ApplicationGatewayRedirectConfiguration
type ApplicationGatewayRedirectConfigurationPropertiesFormat = original.ApplicationGatewayRedirectConfigurationPropertiesFormat
type ApplicationGatewayRequestRoutingRule = original.ApplicationGatewayRequestRoutingRule
type ApplicationGatewayRequestRoutingRulePropertiesFormat = original.ApplicationGatewayRequestRoutingRulePropertiesFormat
type ApplicationGatewayRewriteRule = original.ApplicationGatewayRewriteRule
type ApplicationGatewayRewriteRuleActionSet = original.ApplicationGatewayRewriteRuleActionSet
type ApplicationGatewayRewriteRuleCondition = original.ApplicationGatewayRewriteRuleCondition
type ApplicationGatewayRewriteRuleSet = original.ApplicationGatewayRewriteRuleSet
type ApplicationGatewayRewriteRuleSetPropertiesFormat = original.ApplicationGatewayRewriteRuleSetPropertiesFormat
type ApplicationGatewayRoutingRule = original.ApplicationGatewayRoutingRule
type ApplicationGatewayRoutingRulePropertiesFormat = original.ApplicationGatewayRoutingRulePropertiesFormat
type ApplicationGatewaySku = original.ApplicationGatewaySku
type ApplicationGatewaySslCertificate = original.ApplicationGatewaySslCertificate
type ApplicationGatewaySslCertificatePropertiesFormat = original.ApplicationGatewaySslCertificatePropertiesFormat
type ApplicationGatewaySslPolicy = original.ApplicationGatewaySslPolicy
type ApplicationGatewaySslPredefinedPolicy = original.ApplicationGatewaySslPredefinedPolicy
type ApplicationGatewaySslPredefinedPolicyPropertiesFormat = original.ApplicationGatewaySslPredefinedPolicyPropertiesFormat
type ApplicationGatewaySslProfile = original.ApplicationGatewaySslProfile
type ApplicationGatewaySslProfilePropertiesFormat = original.ApplicationGatewaySslProfilePropertiesFormat
type ApplicationGatewayTrustedClientCertificate = original.ApplicationGatewayTrustedClientCertificate
type ApplicationGatewayTrustedClientCertificatePropertiesFormat = original.ApplicationGatewayTrustedClientCertificatePropertiesFormat
type ApplicationGatewayTrustedRootCertificate = original.ApplicationGatewayTrustedRootCertificate
type ApplicationGatewayTrustedRootCertificatePropertiesFormat = original.ApplicationGatewayTrustedRootCertificatePropertiesFormat
type ApplicationGatewayURLConfiguration = original.ApplicationGatewayURLConfiguration
type ApplicationGatewayURLPathMap = original.ApplicationGatewayURLPathMap
type ApplicationGatewayURLPathMapPropertiesFormat = original.ApplicationGatewayURLPathMapPropertiesFormat
type ApplicationGatewayWafDynamicManifestPropertiesResult = original.ApplicationGatewayWafDynamicManifestPropertiesResult
type ApplicationGatewayWafDynamicManifestResult = original.ApplicationGatewayWafDynamicManifestResult
type ApplicationGatewayWafDynamicManifestResultList = original.ApplicationGatewayWafDynamicManifestResultList
type ApplicationGatewayWafDynamicManifestResultListIterator = original.ApplicationGatewayWafDynamicManifestResultListIterator
type ApplicationGatewayWafDynamicManifestResultListPage = original.ApplicationGatewayWafDynamicManifestResultListPage
type ApplicationGatewayWafDynamicManifestsClient = original.ApplicationGatewayWafDynamicManifestsClient
type ApplicationGatewayWafDynamicManifestsDefaultClient = original.ApplicationGatewayWafDynamicManifestsDefaultClient
type ApplicationGatewayWebApplicationFirewallConfiguration = original.ApplicationGatewayWebApplicationFirewallConfiguration
type ApplicationGatewaysBackendHealthFuture = original.ApplicationGatewaysBackendHealthFuture
type ApplicationGatewaysBackendHealthOnDemandFuture = original.ApplicationGatewaysBackendHealthOnDemandFuture
type ApplicationGatewaysClient = original.ApplicationGatewaysClient
type ApplicationGatewaysCreateOrUpdateFuture = original.ApplicationGatewaysCreateOrUpdateFuture
type ApplicationGatewaysDeleteFuture = original.ApplicationGatewaysDeleteFuture
type ApplicationGatewaysStartFuture = original.ApplicationGatewaysStartFuture
type ApplicationGatewaysStopFuture = original.ApplicationGatewaysStopFuture
type ApplicationRule = original.ApplicationRule
type ApplicationSecurityGroup = original.ApplicationSecurityGroup
type ApplicationSecurityGroupListResult = original.ApplicationSecurityGroupListResult
type ApplicationSecurityGroupListResultIterator = original.ApplicationSecurityGroupListResultIterator
type ApplicationSecurityGroupListResultPage = original.ApplicationSecurityGroupListResultPage
type ApplicationSecurityGroupPropertiesFormat = original.ApplicationSecurityGroupPropertiesFormat
type ApplicationSecurityGroupsClient = original.ApplicationSecurityGroupsClient
type ApplicationSecurityGroupsCreateOrUpdateFuture = original.ApplicationSecurityGroupsCreateOrUpdateFuture
type ApplicationSecurityGroupsDeleteFuture = original.ApplicationSecurityGroupsDeleteFuture
type AuthorizationListResult = original.AuthorizationListResult
type AuthorizationListResultIterator = original.AuthorizationListResultIterator
type AuthorizationListResultPage = original.AuthorizationListResultPage
type AuthorizationPropertiesFormat = original.AuthorizationPropertiesFormat
type AutoApprovedPrivateLinkService = original.AutoApprovedPrivateLinkService
type AutoApprovedPrivateLinkServicesResult = original.AutoApprovedPrivateLinkServicesResult
type AutoApprovedPrivateLinkServicesResultIterator = original.AutoApprovedPrivateLinkServicesResultIterator
type AutoApprovedPrivateLinkServicesResultPage = original.AutoApprovedPrivateLinkServicesResultPage
type Availability = original.Availability
type AvailableDelegation = original.AvailableDelegation
type AvailableDelegationsClient = original.AvailableDelegationsClient
type AvailableDelegationsResult = original.AvailableDelegationsResult
type AvailableDelegationsResultIterator = original.AvailableDelegationsResultIterator
type AvailableDelegationsResultPage = original.AvailableDelegationsResultPage
type AvailableEndpointServicesClient = original.AvailableEndpointServicesClient
type AvailablePrivateEndpointType = original.AvailablePrivateEndpointType
type AvailablePrivateEndpointTypesClient = original.AvailablePrivateEndpointTypesClient
type AvailablePrivateEndpointTypesResult = original.AvailablePrivateEndpointTypesResult
type AvailablePrivateEndpointTypesResultIterator = original.AvailablePrivateEndpointTypesResultIterator
type AvailablePrivateEndpointTypesResultPage = original.AvailablePrivateEndpointTypesResultPage
type AvailableProvidersList = original.AvailableProvidersList
type AvailableProvidersListCity = original.AvailableProvidersListCity
type AvailableProvidersListCountry = original.AvailableProvidersListCountry
type AvailableProvidersListParameters = original.AvailableProvidersListParameters
type AvailableProvidersListState = original.AvailableProvidersListState
type AvailableResourceGroupDelegationsClient = original.AvailableResourceGroupDelegationsClient
type AvailableServiceAlias = original.AvailableServiceAlias
type AvailableServiceAliasesClient = original.AvailableServiceAliasesClient
type AvailableServiceAliasesResult = original.AvailableServiceAliasesResult
type AvailableServiceAliasesResultIterator = original.AvailableServiceAliasesResultIterator
type AvailableServiceAliasesResultPage = original.AvailableServiceAliasesResultPage
type AzureAsyncOperationResult = original.AzureAsyncOperationResult
type AzureFirewall = original.AzureFirewall
type AzureFirewallApplicationRule = original.AzureFirewallApplicationRule
type AzureFirewallApplicationRuleCollection = original.AzureFirewallApplicationRuleCollection
type AzureFirewallApplicationRuleCollectionPropertiesFormat = original.AzureFirewallApplicationRuleCollectionPropertiesFormat
type AzureFirewallApplicationRuleProtocol = original.AzureFirewallApplicationRuleProtocol
type AzureFirewallFqdnTag = original.AzureFirewallFqdnTag
type AzureFirewallFqdnTagListResult = original.AzureFirewallFqdnTagListResult
type AzureFirewallFqdnTagListResultIterator = original.AzureFirewallFqdnTagListResultIterator
type AzureFirewallFqdnTagListResultPage = original.AzureFirewallFqdnTagListResultPage
type AzureFirewallFqdnTagPropertiesFormat = original.AzureFirewallFqdnTagPropertiesFormat
type AzureFirewallFqdnTagsClient = original.AzureFirewallFqdnTagsClient
type AzureFirewallIPConfiguration = original.AzureFirewallIPConfiguration
type AzureFirewallIPConfigurationPropertiesFormat = original.AzureFirewallIPConfigurationPropertiesFormat
type AzureFirewallIPGroups = original.AzureFirewallIPGroups
type AzureFirewallListResult = original.AzureFirewallListResult
type AzureFirewallListResultIterator = original.AzureFirewallListResultIterator
type AzureFirewallListResultPage = original.AzureFirewallListResultPage
type AzureFirewallNatRCAction = original.AzureFirewallNatRCAction
type AzureFirewallNatRule = original.AzureFirewallNatRule
type AzureFirewallNatRuleCollection = original.AzureFirewallNatRuleCollection
type AzureFirewallNatRuleCollectionProperties = original.AzureFirewallNatRuleCollectionProperties
type AzureFirewallNetworkRule = original.AzureFirewallNetworkRule
type AzureFirewallNetworkRuleCollection = original.AzureFirewallNetworkRuleCollection
type AzureFirewallNetworkRuleCollectionPropertiesFormat = original.AzureFirewallNetworkRuleCollectionPropertiesFormat
type AzureFirewallPropertiesFormat = original.AzureFirewallPropertiesFormat
type AzureFirewallPublicIPAddress = original.AzureFirewallPublicIPAddress
type AzureFirewallRCAction = original.AzureFirewallRCAction
type AzureFirewallSku = original.AzureFirewallSku
type AzureFirewallsClient = original.AzureFirewallsClient
type AzureFirewallsCreateOrUpdateFuture = original.AzureFirewallsCreateOrUpdateFuture
type AzureFirewallsDeleteFuture = original.AzureFirewallsDeleteFuture
type AzureFirewallsListLearnedPrefixesFuture = original.AzureFirewallsListLearnedPrefixesFuture
type AzureFirewallsUpdateTagsFuture = original.AzureFirewallsUpdateTagsFuture
type AzureReachabilityReport = original.AzureReachabilityReport
type AzureReachabilityReportItem = original.AzureReachabilityReportItem
type AzureReachabilityReportLatencyInfo = original.AzureReachabilityReportLatencyInfo
type AzureReachabilityReportLocation = original.AzureReachabilityReportLocation
type AzureReachabilityReportParameters = original.AzureReachabilityReportParameters
type AzureWebCategory = original.AzureWebCategory
type AzureWebCategoryListResult = original.AzureWebCategoryListResult
type AzureWebCategoryListResultIterator = original.AzureWebCategoryListResultIterator
type AzureWebCategoryListResultPage = original.AzureWebCategoryListResultPage
type AzureWebCategoryPropertiesFormat = original.AzureWebCategoryPropertiesFormat
type BGPCommunity = original.BGPCommunity
type BackendAddressInboundNatRulePortMappings = original.BackendAddressInboundNatRulePortMappings
type BackendAddressPool = original.BackendAddressPool
type BackendAddressPoolPropertiesFormat = original.BackendAddressPoolPropertiesFormat
type BaseAdminRule = original.BaseAdminRule
type BaseAdminRuleModel = original.BaseAdminRuleModel
type BaseClient = original.BaseClient
type BasicActiveBaseSecurityAdminRule = original.BasicActiveBaseSecurityAdminRule
type BasicBaseAdminRule = original.BasicBaseAdminRule
type BasicEffectiveBaseSecurityAdminRule = original.BasicEffectiveBaseSecurityAdminRule
type BasicFirewallPolicyRule = original.BasicFirewallPolicyRule
type BasicFirewallPolicyRuleCollection = original.BasicFirewallPolicyRuleCollection
type BastionActiveSession = original.BastionActiveSession
type BastionActiveSessionListResult = original.BastionActiveSessionListResult
type BastionActiveSessionListResultIterator = original.BastionActiveSessionListResultIterator
type BastionActiveSessionListResultPage = original.BastionActiveSessionListResultPage
type BastionHost = original.BastionHost
type BastionHostIPConfiguration = original.BastionHostIPConfiguration
type BastionHostIPConfigurationPropertiesFormat = original.BastionHostIPConfigurationPropertiesFormat
type BastionHostListResult = original.BastionHostListResult
type BastionHostListResultIterator = original.BastionHostListResultIterator
type BastionHostListResultPage = original.BastionHostListResultPage
type BastionHostPropertiesFormat = original.BastionHostPropertiesFormat
type BastionHostsClient = original.BastionHostsClient
type BastionHostsCreateOrUpdateFuture = original.BastionHostsCreateOrUpdateFuture
type BastionHostsDeleteFuture = original.BastionHostsDeleteFuture
type BastionHostsUpdateTagsFuture = original.BastionHostsUpdateTagsFuture
type BastionSessionDeleteResult = original.BastionSessionDeleteResult
type BastionSessionDeleteResultIterator = original.BastionSessionDeleteResultIterator
type BastionSessionDeleteResultPage = original.BastionSessionDeleteResultPage
type BastionSessionState = original.BastionSessionState
type BastionShareableLink = original.BastionShareableLink
type BastionShareableLinkListRequest = original.BastionShareableLinkListRequest
type BastionShareableLinkListResult = original.BastionShareableLinkListResult
type BastionShareableLinkListResultIterator = original.BastionShareableLinkListResultIterator
type BastionShareableLinkListResultPage = original.BastionShareableLinkListResultPage
type BgpConnection = original.BgpConnection
type BgpConnectionProperties = original.BgpConnectionProperties
type BgpPeerStatus = original.BgpPeerStatus
type BgpPeerStatusListResult = original.BgpPeerStatusListResult
type BgpServiceCommunitiesClient = original.BgpServiceCommunitiesClient
type BgpServiceCommunity = original.BgpServiceCommunity
type BgpServiceCommunityListResult = original.BgpServiceCommunityListResult
type BgpServiceCommunityListResultIterator = original.BgpServiceCommunityListResultIterator
type BgpServiceCommunityListResultPage = original.BgpServiceCommunityListResultPage
type BgpServiceCommunityPropertiesFormat = original.BgpServiceCommunityPropertiesFormat
type BgpSettings = original.BgpSettings
type BreakOutCategoryPolicies = original.BreakOutCategoryPolicies
type CheckPrivateLinkServiceVisibilityRequest = original.CheckPrivateLinkServiceVisibilityRequest
type ChildResource = original.ChildResource
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type ConfigurationDiagnosticParameters = original.ConfigurationDiagnosticParameters
type ConfigurationDiagnosticProfile = original.ConfigurationDiagnosticProfile
type ConfigurationDiagnosticResponse = original.ConfigurationDiagnosticResponse
type ConfigurationDiagnosticResult = original.ConfigurationDiagnosticResult
type ConfigurationGroup = original.ConfigurationGroup
type ConfigurationPolicyGroupsClient = original.ConfigurationPolicyGroupsClient
type ConfigurationPolicyGroupsCreateOrUpdateFuture = original.ConfigurationPolicyGroupsCreateOrUpdateFuture
type ConfigurationPolicyGroupsDeleteFuture = original.ConfigurationPolicyGroupsDeleteFuture
type ConnectionMonitor = original.ConnectionMonitor
type ConnectionMonitorDestination = original.ConnectionMonitorDestination
type ConnectionMonitorEndpoint = original.ConnectionMonitorEndpoint
type ConnectionMonitorEndpointFilter = original.ConnectionMonitorEndpointFilter
type ConnectionMonitorEndpointFilterItem = original.ConnectionMonitorEndpointFilterItem
type ConnectionMonitorEndpointScope = original.ConnectionMonitorEndpointScope
type ConnectionMonitorEndpointScopeItem = original.ConnectionMonitorEndpointScopeItem
type ConnectionMonitorHTTPConfiguration = original.ConnectionMonitorHTTPConfiguration
type ConnectionMonitorIcmpConfiguration = original.ConnectionMonitorIcmpConfiguration
type ConnectionMonitorListResult = original.ConnectionMonitorListResult
type ConnectionMonitorOutput = original.ConnectionMonitorOutput
type ConnectionMonitorParameters = original.ConnectionMonitorParameters
type ConnectionMonitorQueryResult = original.ConnectionMonitorQueryResult
type ConnectionMonitorResult = original.ConnectionMonitorResult
type ConnectionMonitorResultProperties = original.ConnectionMonitorResultProperties
type ConnectionMonitorSource = original.ConnectionMonitorSource
type ConnectionMonitorSuccessThreshold = original.ConnectionMonitorSuccessThreshold
type ConnectionMonitorTCPConfiguration = original.ConnectionMonitorTCPConfiguration
type ConnectionMonitorTestConfiguration = original.ConnectionMonitorTestConfiguration
type ConnectionMonitorTestGroup = original.ConnectionMonitorTestGroup
type ConnectionMonitorWorkspaceSettings = original.ConnectionMonitorWorkspaceSettings
type ConnectionMonitorsClient = original.ConnectionMonitorsClient
type ConnectionMonitorsCreateOrUpdateFuture = original.ConnectionMonitorsCreateOrUpdateFuture
type ConnectionMonitorsDeleteFuture = original.ConnectionMonitorsDeleteFuture
type ConnectionMonitorsQueryFuture = original.ConnectionMonitorsQueryFuture
type ConnectionMonitorsStartFuture = original.ConnectionMonitorsStartFuture
type ConnectionMonitorsStopFuture = original.ConnectionMonitorsStopFuture
type ConnectionResetSharedKey = original.ConnectionResetSharedKey
type ConnectionSharedKey = original.ConnectionSharedKey
type ConnectionStateSnapshot = original.ConnectionStateSnapshot
type ConnectivityConfiguration = original.ConnectivityConfiguration
type ConnectivityConfigurationListResult = original.ConnectivityConfigurationListResult
type ConnectivityConfigurationListResultIterator = original.ConnectivityConfigurationListResultIterator
type ConnectivityConfigurationListResultPage = original.ConnectivityConfigurationListResultPage
type ConnectivityConfigurationProperties = original.ConnectivityConfigurationProperties
type ConnectivityConfigurationsClient = original.ConnectivityConfigurationsClient
type ConnectivityConfigurationsDeleteFuture = original.ConnectivityConfigurationsDeleteFuture
type ConnectivityDestination = original.ConnectivityDestination
type ConnectivityGroupItem = original.ConnectivityGroupItem
type ConnectivityHop = original.ConnectivityHop
type ConnectivityInformation = original.ConnectivityInformation
type ConnectivityIssue = original.ConnectivityIssue
type ConnectivityParameters = original.ConnectivityParameters
type ConnectivitySource = original.ConnectivitySource
type Container = original.Container
type ContainerNetworkInterface = original.ContainerNetworkInterface
type ContainerNetworkInterfaceConfiguration = original.ContainerNetworkInterfaceConfiguration
type ContainerNetworkInterfaceConfigurationPropertiesFormat = original.ContainerNetworkInterfaceConfigurationPropertiesFormat
type ContainerNetworkInterfaceIPConfiguration = original.ContainerNetworkInterfaceIPConfiguration
type ContainerNetworkInterfaceIPConfigurationPropertiesFormat = original.ContainerNetworkInterfaceIPConfigurationPropertiesFormat
type ContainerNetworkInterfacePropertiesFormat = original.ContainerNetworkInterfacePropertiesFormat
type Criterion = original.Criterion
type CrossTenantScopes = original.CrossTenantScopes
type CustomDNSConfigPropertiesFormat = original.CustomDNSConfigPropertiesFormat
type CustomIPPrefix = original.CustomIPPrefix
type CustomIPPrefixListResult = original.CustomIPPrefixListResult
type CustomIPPrefixListResultIterator = original.CustomIPPrefixListResultIterator
type CustomIPPrefixListResultPage = original.CustomIPPrefixListResultPage
type CustomIPPrefixPropertiesFormat = original.CustomIPPrefixPropertiesFormat
type CustomIPPrefixesClient = original.CustomIPPrefixesClient
type CustomIPPrefixesCreateOrUpdateFuture = original.CustomIPPrefixesCreateOrUpdateFuture
type CustomIPPrefixesDeleteFuture = original.CustomIPPrefixesDeleteFuture
type DNSNameAvailabilityResult = original.DNSNameAvailabilityResult
type DNSSettings = original.DNSSettings
type DdosCustomPoliciesClient = original.DdosCustomPoliciesClient
type DdosCustomPoliciesCreateOrUpdateFuture = original.DdosCustomPoliciesCreateOrUpdateFuture
type DdosCustomPoliciesDeleteFuture = original.DdosCustomPoliciesDeleteFuture
type DdosCustomPolicy = original.DdosCustomPolicy
type DdosCustomPolicyPropertiesFormat = original.DdosCustomPolicyPropertiesFormat
type DdosProtectionPlan = original.DdosProtectionPlan
type DdosProtectionPlanListResult = original.DdosProtectionPlanListResult
type DdosProtectionPlanListResultIterator = original.DdosProtectionPlanListResultIterator
type DdosProtectionPlanListResultPage = original.DdosProtectionPlanListResultPage
type DdosProtectionPlanPropertiesFormat = original.DdosProtectionPlanPropertiesFormat
type DdosProtectionPlansClient = original.DdosProtectionPlansClient
type DdosProtectionPlansCreateOrUpdateFuture = original.DdosProtectionPlansCreateOrUpdateFuture
type DdosProtectionPlansDeleteFuture = original.DdosProtectionPlansDeleteFuture
type DdosSettings = original.DdosSettings
type DefaultAdminPropertiesFormat = original.DefaultAdminPropertiesFormat
type DefaultAdminRule = original.DefaultAdminRule
type DefaultRuleSetPropertyFormat = original.DefaultRuleSetPropertyFormat
type DefaultSecurityRulesClient = original.DefaultSecurityRulesClient
type Delegation = original.Delegation
type DelegationProperties = original.DelegationProperties
type DeleteBastionShareableLinkFuture = original.DeleteBastionShareableLinkFuture
type DeviceProperties = original.DeviceProperties
type DhcpOptions = original.DhcpOptions
type Dimension = original.Dimension
type DscpConfiguration = original.DscpConfiguration
type DscpConfigurationClient = original.DscpConfigurationClient
type DscpConfigurationCreateOrUpdateFuture = original.DscpConfigurationCreateOrUpdateFuture
type DscpConfigurationDeleteFuture = original.DscpConfigurationDeleteFuture
type DscpConfigurationListResult = original.DscpConfigurationListResult
type DscpConfigurationListResultIterator = original.DscpConfigurationListResultIterator
type DscpConfigurationListResultPage = original.DscpConfigurationListResultPage
type DscpConfigurationPropertiesFormat = original.DscpConfigurationPropertiesFormat
type EffectiveBaseSecurityAdminRule = original.EffectiveBaseSecurityAdminRule
type EffectiveConnectivityConfiguration = original.EffectiveConnectivityConfiguration
type EffectiveDefaultSecurityAdminRule = original.EffectiveDefaultSecurityAdminRule
type EffectiveNetworkSecurityGroup = original.EffectiveNetworkSecurityGroup
type EffectiveNetworkSecurityGroupAssociation = original.EffectiveNetworkSecurityGroupAssociation
type EffectiveNetworkSecurityGroupListResult = original.EffectiveNetworkSecurityGroupListResult
type EffectiveNetworkSecurityRule = original.EffectiveNetworkSecurityRule
type EffectiveRoute = original.EffectiveRoute
type EffectiveRouteListResult = original.EffectiveRouteListResult
type EffectiveRouteMapRoute = original.EffectiveRouteMapRoute
type EffectiveRoutesParameters = original.EffectiveRoutesParameters
type EffectiveSecurityAdminRule = original.EffectiveSecurityAdminRule
type EndpointServiceResult = original.EndpointServiceResult
type EndpointServicesListResult = original.EndpointServicesListResult
type EndpointServicesListResultIterator = original.EndpointServicesListResultIterator
type EndpointServicesListResultPage = original.EndpointServicesListResultPage
type Error = original.Error
type ErrorDetails = original.ErrorDetails
type ErrorResponse = original.ErrorResponse
type EvaluatedNetworkSecurityGroup = original.EvaluatedNetworkSecurityGroup
type ExclusionManagedRule = original.ExclusionManagedRule
type ExclusionManagedRuleGroup = original.ExclusionManagedRuleGroup
type ExclusionManagedRuleSet = original.ExclusionManagedRuleSet
type ExplicitProxy = original.ExplicitProxy
type ExpressRouteCircuit = original.ExpressRouteCircuit
type ExpressRouteCircuitArpTable = original.ExpressRouteCircuitArpTable
type ExpressRouteCircuitAuthorization = original.ExpressRouteCircuitAuthorization
type ExpressRouteCircuitAuthorizationsClient = original.ExpressRouteCircuitAuthorizationsClient
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture = original.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture
type ExpressRouteCircuitAuthorizationsDeleteFuture = original.ExpressRouteCircuitAuthorizationsDeleteFuture
type ExpressRouteCircuitConnection = original.ExpressRouteCircuitConnection
type ExpressRouteCircuitConnectionListResult = original.ExpressRouteCircuitConnectionListResult
type ExpressRouteCircuitConnectionListResultIterator = original.ExpressRouteCircuitConnectionListResultIterator
type ExpressRouteCircuitConnectionListResultPage = original.ExpressRouteCircuitConnectionListResultPage
type ExpressRouteCircuitConnectionPropertiesFormat = original.ExpressRouteCircuitConnectionPropertiesFormat
type ExpressRouteCircuitConnectionsClient = original.ExpressRouteCircuitConnectionsClient
type ExpressRouteCircuitConnectionsCreateOrUpdateFuture = original.ExpressRouteCircuitConnectionsCreateOrUpdateFuture
type ExpressRouteCircuitConnectionsDeleteFuture = original.ExpressRouteCircuitConnectionsDeleteFuture
type ExpressRouteCircuitListResult = original.ExpressRouteCircuitListResult
type ExpressRouteCircuitListResultIterator = original.ExpressRouteCircuitListResultIterator
type ExpressRouteCircuitListResultPage = original.ExpressRouteCircuitListResultPage
type ExpressRouteCircuitPeering = original.ExpressRouteCircuitPeering
type ExpressRouteCircuitPeeringConfig = original.ExpressRouteCircuitPeeringConfig
type ExpressRouteCircuitPeeringID = original.ExpressRouteCircuitPeeringID
type ExpressRouteCircuitPeeringListResult = original.ExpressRouteCircuitPeeringListResult
type ExpressRouteCircuitPeeringListResultIterator = original.ExpressRouteCircuitPeeringListResultIterator
type ExpressRouteCircuitPeeringListResultPage = original.ExpressRouteCircuitPeeringListResultPage
type ExpressRouteCircuitPeeringPropertiesFormat = original.ExpressRouteCircuitPeeringPropertiesFormat
type ExpressRouteCircuitPeeringsClient = original.ExpressRouteCircuitPeeringsClient
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture = original.ExpressRouteCircuitPeeringsCreateOrUpdateFuture
type ExpressRouteCircuitPeeringsDeleteFuture = original.ExpressRouteCircuitPeeringsDeleteFuture
type ExpressRouteCircuitPropertiesFormat = original.ExpressRouteCircuitPropertiesFormat
type ExpressRouteCircuitReference = original.ExpressRouteCircuitReference
type ExpressRouteCircuitRoutesTable = original.ExpressRouteCircuitRoutesTable
type ExpressRouteCircuitRoutesTableSummary = original.ExpressRouteCircuitRoutesTableSummary
type ExpressRouteCircuitServiceProviderProperties = original.ExpressRouteCircuitServiceProviderProperties
type ExpressRouteCircuitSku = original.ExpressRouteCircuitSku
type ExpressRouteCircuitStats = original.ExpressRouteCircuitStats
type ExpressRouteCircuitsArpTableListResult = original.ExpressRouteCircuitsArpTableListResult
type ExpressRouteCircuitsClient = original.ExpressRouteCircuitsClient
type ExpressRouteCircuitsCreateOrUpdateFuture = original.ExpressRouteCircuitsCreateOrUpdateFuture
type ExpressRouteCircuitsDeleteFuture = original.ExpressRouteCircuitsDeleteFuture
type ExpressRouteCircuitsListArpTableFuture = original.ExpressRouteCircuitsListArpTableFuture
type ExpressRouteCircuitsListRoutesTableFuture = original.ExpressRouteCircuitsListRoutesTableFuture
type ExpressRouteCircuitsListRoutesTableSummaryFuture = original.ExpressRouteCircuitsListRoutesTableSummaryFuture
type ExpressRouteCircuitsRoutesTableListResult = original.ExpressRouteCircuitsRoutesTableListResult
type ExpressRouteCircuitsRoutesTableSummaryListResult = original.ExpressRouteCircuitsRoutesTableSummaryListResult
type ExpressRouteConnection = original.ExpressRouteConnection
type ExpressRouteConnectionID = original.ExpressRouteConnectionID
type ExpressRouteConnectionList = original.ExpressRouteConnectionList
type ExpressRouteConnectionProperties = original.ExpressRouteConnectionProperties
type ExpressRouteConnectionsClient = original.ExpressRouteConnectionsClient
type ExpressRouteConnectionsCreateOrUpdateFuture = original.ExpressRouteConnectionsCreateOrUpdateFuture
type ExpressRouteConnectionsDeleteFuture = original.ExpressRouteConnectionsDeleteFuture
type ExpressRouteCrossConnection = original.ExpressRouteCrossConnection
type ExpressRouteCrossConnectionListResult = original.ExpressRouteCrossConnectionListResult
type ExpressRouteCrossConnectionListResultIterator = original.ExpressRouteCrossConnectionListResultIterator
type ExpressRouteCrossConnectionListResultPage = original.ExpressRouteCrossConnectionListResultPage
type ExpressRouteCrossConnectionPeering = original.ExpressRouteCrossConnectionPeering
type ExpressRouteCrossConnectionPeeringList = original.ExpressRouteCrossConnectionPeeringList
type ExpressRouteCrossConnectionPeeringListIterator = original.ExpressRouteCrossConnectionPeeringListIterator
type ExpressRouteCrossConnectionPeeringListPage = original.ExpressRouteCrossConnectionPeeringListPage
type ExpressRouteCrossConnectionPeeringProperties = original.ExpressRouteCrossConnectionPeeringProperties
type ExpressRouteCrossConnectionPeeringsClient = original.ExpressRouteCrossConnectionPeeringsClient
type ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture = original.ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture
type ExpressRouteCrossConnectionPeeringsDeleteFuture = original.ExpressRouteCrossConnectionPeeringsDeleteFuture
type ExpressRouteCrossConnectionProperties = original.ExpressRouteCrossConnectionProperties
type ExpressRouteCrossConnectionRoutesTableSummary = original.ExpressRouteCrossConnectionRoutesTableSummary
type ExpressRouteCrossConnectionsClient = original.ExpressRouteCrossConnectionsClient
type ExpressRouteCrossConnectionsCreateOrUpdateFuture = original.ExpressRouteCrossConnectionsCreateOrUpdateFuture
type ExpressRouteCrossConnectionsListArpTableFuture = original.ExpressRouteCrossConnectionsListArpTableFuture
type ExpressRouteCrossConnectionsListRoutesTableFuture = original.ExpressRouteCrossConnectionsListRoutesTableFuture
type ExpressRouteCrossConnectionsListRoutesTableSummaryFuture = original.ExpressRouteCrossConnectionsListRoutesTableSummaryFuture
type ExpressRouteCrossConnectionsRoutesTableSummaryListResult = original.ExpressRouteCrossConnectionsRoutesTableSummaryListResult
type ExpressRouteGateway = original.ExpressRouteGateway
type ExpressRouteGatewayList = original.ExpressRouteGatewayList
type ExpressRouteGatewayProperties = original.ExpressRouteGatewayProperties
type ExpressRouteGatewayPropertiesAutoScaleConfiguration = original.ExpressRouteGatewayPropertiesAutoScaleConfiguration
type ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds = original.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
type ExpressRouteGatewaysClient = original.ExpressRouteGatewaysClient
type ExpressRouteGatewaysCreateOrUpdateFuture = original.ExpressRouteGatewaysCreateOrUpdateFuture
type ExpressRouteGatewaysDeleteFuture = original.ExpressRouteGatewaysDeleteFuture
type ExpressRouteGatewaysUpdateTagsFuture = original.ExpressRouteGatewaysUpdateTagsFuture
type ExpressRouteLink = original.ExpressRouteLink
type ExpressRouteLinkListResult = original.ExpressRouteLinkListResult
type ExpressRouteLinkListResultIterator = original.ExpressRouteLinkListResultIterator
type ExpressRouteLinkListResultPage = original.ExpressRouteLinkListResultPage
type ExpressRouteLinkMacSecConfig = original.ExpressRouteLinkMacSecConfig
type ExpressRouteLinkPropertiesFormat = original.ExpressRouteLinkPropertiesFormat
type ExpressRouteLinksClient = original.ExpressRouteLinksClient
type ExpressRoutePort = original.ExpressRoutePort
type ExpressRoutePortAuthorization = original.ExpressRoutePortAuthorization
type ExpressRoutePortAuthorizationListResult = original.ExpressRoutePortAuthorizationListResult
type ExpressRoutePortAuthorizationListResultIterator = original.ExpressRoutePortAuthorizationListResultIterator
type ExpressRoutePortAuthorizationListResultPage = original.ExpressRoutePortAuthorizationListResultPage
type ExpressRoutePortAuthorizationPropertiesFormat = original.ExpressRoutePortAuthorizationPropertiesFormat
type ExpressRoutePortAuthorizationsClient = original.ExpressRoutePortAuthorizationsClient
type ExpressRoutePortAuthorizationsCreateOrUpdateFuture = original.ExpressRoutePortAuthorizationsCreateOrUpdateFuture
type ExpressRoutePortAuthorizationsDeleteFuture = original.ExpressRoutePortAuthorizationsDeleteFuture
type ExpressRoutePortListResult = original.ExpressRoutePortListResult
type ExpressRoutePortListResultIterator = original.ExpressRoutePortListResultIterator
type ExpressRoutePortListResultPage = original.ExpressRoutePortListResultPage
type ExpressRoutePortPropertiesFormat = original.ExpressRoutePortPropertiesFormat
type ExpressRoutePortsClient = original.ExpressRoutePortsClient
type ExpressRoutePortsCreateOrUpdateFuture = original.ExpressRoutePortsCreateOrUpdateFuture
type ExpressRoutePortsDeleteFuture = original.ExpressRoutePortsDeleteFuture
type ExpressRoutePortsLocation = original.ExpressRoutePortsLocation
type ExpressRoutePortsLocationBandwidths = original.ExpressRoutePortsLocationBandwidths
type ExpressRoutePortsLocationListResult = original.ExpressRoutePortsLocationListResult
type ExpressRoutePortsLocationListResultIterator = original.ExpressRoutePortsLocationListResultIterator
type ExpressRoutePortsLocationListResultPage = original.ExpressRoutePortsLocationListResultPage
type ExpressRoutePortsLocationPropertiesFormat = original.ExpressRoutePortsLocationPropertiesFormat
type ExpressRoutePortsLocationsClient = original.ExpressRoutePortsLocationsClient
type ExpressRouteProviderPort = original.ExpressRouteProviderPort
type ExpressRouteProviderPortListResult = original.ExpressRouteProviderPortListResult
type ExpressRouteProviderPortProperties = original.ExpressRouteProviderPortProperties
type ExpressRouteProviderPortsLocationClient = original.ExpressRouteProviderPortsLocationClient
type ExpressRouteServiceProvider = original.ExpressRouteServiceProvider
type ExpressRouteServiceProviderBandwidthsOffered = original.ExpressRouteServiceProviderBandwidthsOffered
type ExpressRouteServiceProviderListResult = original.ExpressRouteServiceProviderListResult
type ExpressRouteServiceProviderListResultIterator = original.ExpressRouteServiceProviderListResultIterator
type ExpressRouteServiceProviderListResultPage = original.ExpressRouteServiceProviderListResultPage
type ExpressRouteServiceProviderPropertiesFormat = original.ExpressRouteServiceProviderPropertiesFormat
type ExpressRouteServiceProvidersClient = original.ExpressRouteServiceProvidersClient
type ExtendedLocation = original.ExtendedLocation
type FilterItems = original.FilterItems
type FirewallPoliciesClient = original.FirewallPoliciesClient
type FirewallPoliciesCreateOrUpdateFuture = original.FirewallPoliciesCreateOrUpdateFuture
type FirewallPoliciesDeleteFuture = original.FirewallPoliciesDeleteFuture
type FirewallPolicy = original.FirewallPolicy
type FirewallPolicyCertificateAuthority = original.FirewallPolicyCertificateAuthority
type FirewallPolicyFilterRuleCollection = original.FirewallPolicyFilterRuleCollection
type FirewallPolicyFilterRuleCollectionAction = original.FirewallPolicyFilterRuleCollectionAction
type FirewallPolicyIdpsSignaturesClient = original.FirewallPolicyIdpsSignaturesClient
type FirewallPolicyIdpsSignaturesFilterValuesClient = original.FirewallPolicyIdpsSignaturesFilterValuesClient
type FirewallPolicyIdpsSignaturesOverridesClient = original.FirewallPolicyIdpsSignaturesOverridesClient
type FirewallPolicyInsights = original.FirewallPolicyInsights
type FirewallPolicyIntrusionDetection = original.FirewallPolicyIntrusionDetection
type FirewallPolicyIntrusionDetectionBypassTrafficSpecifications = original.FirewallPolicyIntrusionDetectionBypassTrafficSpecifications
type FirewallPolicyIntrusionDetectionConfiguration = original.FirewallPolicyIntrusionDetectionConfiguration
type FirewallPolicyIntrusionDetectionSignatureSpecification = original.FirewallPolicyIntrusionDetectionSignatureSpecification
type FirewallPolicyListResult = original.FirewallPolicyListResult
type FirewallPolicyListResultIterator = original.FirewallPolicyListResultIterator
type FirewallPolicyListResultPage = original.FirewallPolicyListResultPage
type FirewallPolicyLogAnalyticsResources = original.FirewallPolicyLogAnalyticsResources
type FirewallPolicyLogAnalyticsWorkspace = original.FirewallPolicyLogAnalyticsWorkspace
type FirewallPolicyNatRuleCollection = original.FirewallPolicyNatRuleCollection
type FirewallPolicyNatRuleCollectionAction = original.FirewallPolicyNatRuleCollectionAction
type FirewallPolicyPropertiesFormat = original.FirewallPolicyPropertiesFormat
type FirewallPolicyRule = original.FirewallPolicyRule
type FirewallPolicyRuleApplicationProtocol = original.FirewallPolicyRuleApplicationProtocol
type FirewallPolicyRuleCollection = original.FirewallPolicyRuleCollection
type FirewallPolicyRuleCollectionGroup = original.FirewallPolicyRuleCollectionGroup
type FirewallPolicyRuleCollectionGroupListResult = original.FirewallPolicyRuleCollectionGroupListResult
type FirewallPolicyRuleCollectionGroupListResultIterator = original.FirewallPolicyRuleCollectionGroupListResultIterator
type FirewallPolicyRuleCollectionGroupListResultPage = original.FirewallPolicyRuleCollectionGroupListResultPage
type FirewallPolicyRuleCollectionGroupProperties = original.FirewallPolicyRuleCollectionGroupProperties
type FirewallPolicyRuleCollectionGroupsClient = original.FirewallPolicyRuleCollectionGroupsClient
type FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture = original.FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture
type FirewallPolicyRuleCollectionGroupsDeleteFuture = original.FirewallPolicyRuleCollectionGroupsDeleteFuture
type FirewallPolicySNAT = original.FirewallPolicySNAT
type FirewallPolicySQL = original.FirewallPolicySQL
type FirewallPolicySku = original.FirewallPolicySku
type FirewallPolicyThreatIntelWhitelist = original.FirewallPolicyThreatIntelWhitelist
type FirewallPolicyTransportSecurity = original.FirewallPolicyTransportSecurity
type FlowLog = original.FlowLog
type FlowLogFormatParameters = original.FlowLogFormatParameters
type FlowLogInformation = original.FlowLogInformation
type FlowLogListResult = original.FlowLogListResult
type FlowLogListResultIterator = original.FlowLogListResultIterator
type FlowLogListResultPage = original.FlowLogListResultPage
type FlowLogProperties = original.FlowLogProperties
type FlowLogPropertiesFormat = original.FlowLogPropertiesFormat
type FlowLogStatusParameters = original.FlowLogStatusParameters
type FlowLogsClient = original.FlowLogsClient
type FlowLogsCreateOrUpdateFuture = original.FlowLogsCreateOrUpdateFuture
type FlowLogsDeleteFuture = original.FlowLogsDeleteFuture
type FrontendIPConfiguration = original.FrontendIPConfiguration
type FrontendIPConfigurationPropertiesFormat = original.FrontendIPConfigurationPropertiesFormat
type GatewayCustomBgpIPAddressIPConfiguration = original.GatewayCustomBgpIPAddressIPConfiguration
type GatewayLoadBalancerTunnelInterface = original.GatewayLoadBalancerTunnelInterface
type GatewayRoute = original.GatewayRoute
type GatewayRouteListResult = original.GatewayRouteListResult
type GenerateExpressRoutePortsLOARequest = original.GenerateExpressRoutePortsLOARequest
type GenerateExpressRoutePortsLOAResult = original.GenerateExpressRoutePortsLOAResult
type GeneratevirtualwanvpnserverconfigurationvpnprofileFuture = original.GeneratevirtualwanvpnserverconfigurationvpnprofileFuture
type GetActiveSessionsAllFuture = original.GetActiveSessionsAllFuture
type GetActiveSessionsFuture = original.GetActiveSessionsFuture
type GetInboundRoutesParameters = original.GetInboundRoutesParameters
type GetOutboundRoutesParameters = original.GetOutboundRoutesParameters
type GetVpnSitesConfigurationRequest = original.GetVpnSitesConfigurationRequest
type Group = original.Group
type GroupListResult = original.GroupListResult
type GroupListResultIterator = original.GroupListResultIterator
type GroupListResultPage = original.GroupListResultPage
type GroupProperties = original.GroupProperties
type GroupsClient = original.GroupsClient
type GroupsDeleteFuture = original.GroupsDeleteFuture
type HTTPConfiguration = original.HTTPConfiguration
type HTTPHeader = original.HTTPHeader
type HopLink = original.HopLink
type HopLinkProperties = original.HopLinkProperties
type Hub = original.Hub
type HubIPAddresses = original.HubIPAddresses
type HubIPConfiguration = original.HubIPConfiguration
type HubIPConfigurationPropertiesFormat = original.HubIPConfigurationPropertiesFormat
type HubPublicIPAddresses = original.HubPublicIPAddresses
type HubRoute = original.HubRoute
type HubRouteTable = original.HubRouteTable
type HubRouteTableProperties = original.HubRouteTableProperties
type HubRouteTablesClient = original.HubRouteTablesClient
type HubRouteTablesCreateOrUpdateFuture = original.HubRouteTablesCreateOrUpdateFuture
type HubRouteTablesDeleteFuture = original.HubRouteTablesDeleteFuture
type HubVirtualNetworkConnection = original.HubVirtualNetworkConnection
type HubVirtualNetworkConnectionProperties = original.HubVirtualNetworkConnectionProperties
type HubVirtualNetworkConnectionsClient = original.HubVirtualNetworkConnectionsClient
type HubVirtualNetworkConnectionsCreateOrUpdateFuture = original.HubVirtualNetworkConnectionsCreateOrUpdateFuture
type HubVirtualNetworkConnectionsDeleteFuture = original.HubVirtualNetworkConnectionsDeleteFuture
type IDPSQueryObject = original.IDPSQueryObject
type IPAddressAvailabilityResult = original.IPAddressAvailabilityResult
type IPAllocation = original.IPAllocation
type IPAllocationListResult = original.IPAllocationListResult
type IPAllocationListResultIterator = original.IPAllocationListResultIterator
type IPAllocationListResultPage = original.IPAllocationListResultPage
type IPAllocationPropertiesFormat = original.IPAllocationPropertiesFormat
type IPAllocationsClient = original.IPAllocationsClient
type IPAllocationsCreateOrUpdateFuture = original.IPAllocationsCreateOrUpdateFuture
type IPAllocationsDeleteFuture = original.IPAllocationsDeleteFuture
type IPConfiguration = original.IPConfiguration
type IPConfigurationBgpPeeringAddress = original.IPConfigurationBgpPeeringAddress
type IPConfigurationProfile = original.IPConfigurationProfile
type IPConfigurationProfilePropertiesFormat = original.IPConfigurationProfilePropertiesFormat
type IPConfigurationPropertiesFormat = original.IPConfigurationPropertiesFormat
type IPGroup = original.IPGroup
type IPGroupListResult = original.IPGroupListResult
type IPGroupListResultIterator = original.IPGroupListResultIterator
type IPGroupListResultPage = original.IPGroupListResultPage
type IPGroupPropertiesFormat = original.IPGroupPropertiesFormat
type IPGroupsClient = original.IPGroupsClient
type IPGroupsCreateOrUpdateFuture = original.IPGroupsCreateOrUpdateFuture
type IPGroupsDeleteFuture = original.IPGroupsDeleteFuture
type IPPrefixesList = original.IPPrefixesList
type IPTag = original.IPTag
type InboundNatPool = original.InboundNatPool
type InboundNatPoolPropertiesFormat = original.InboundNatPoolPropertiesFormat
type InboundNatRule = original.InboundNatRule
type InboundNatRuleListResult = original.InboundNatRuleListResult
type InboundNatRuleListResultIterator = original.InboundNatRuleListResultIterator
type InboundNatRuleListResultPage = original.InboundNatRuleListResultPage
type InboundNatRulePortMapping = original.InboundNatRulePortMapping
type InboundNatRulePropertiesFormat = original.InboundNatRulePropertiesFormat
type InboundNatRulesClient = original.InboundNatRulesClient
type InboundNatRulesCreateOrUpdateFuture = original.InboundNatRulesCreateOrUpdateFuture
type InboundNatRulesDeleteFuture = original.InboundNatRulesDeleteFuture
type InboundSecurityRule = original.InboundSecurityRule
type InboundSecurityRuleClient = original.InboundSecurityRuleClient
type InboundSecurityRuleCreateOrUpdateFuture = original.InboundSecurityRuleCreateOrUpdateFuture
type InboundSecurityRuleProperties = original.InboundSecurityRuleProperties
type InboundSecurityRules = original.InboundSecurityRules
type IntentPolicy = original.IntentPolicy
type IntentPolicyConfiguration = original.IntentPolicyConfiguration
type Interface = original.Interface
type InterfaceAssociation = original.InterfaceAssociation
type InterfaceDNSSettings = original.InterfaceDNSSettings
type InterfaceIPConfiguration = original.InterfaceIPConfiguration
type InterfaceIPConfigurationListResult = original.InterfaceIPConfigurationListResult
type InterfaceIPConfigurationListResultIterator = original.InterfaceIPConfigurationListResultIterator
type InterfaceIPConfigurationListResultPage = original.InterfaceIPConfigurationListResultPage
type InterfaceIPConfigurationPrivateLinkConnectionProperties = original.InterfaceIPConfigurationPrivateLinkConnectionProperties
type InterfaceIPConfigurationPropertiesFormat = original.InterfaceIPConfigurationPropertiesFormat
type InterfaceIPConfigurationsClient = original.InterfaceIPConfigurationsClient
type InterfaceListResult = original.InterfaceListResult
type InterfaceListResultIterator = original.InterfaceListResultIterator
type InterfaceListResultPage = original.InterfaceListResultPage
type InterfaceLoadBalancerListResult = original.InterfaceLoadBalancerListResult
type InterfaceLoadBalancerListResultIterator = original.InterfaceLoadBalancerListResultIterator
type InterfaceLoadBalancerListResultPage = original.InterfaceLoadBalancerListResultPage
type InterfaceLoadBalancersClient = original.InterfaceLoadBalancersClient
type InterfacePropertiesFormat = original.InterfacePropertiesFormat
type InterfaceTapConfiguration = original.InterfaceTapConfiguration
type InterfaceTapConfigurationListResult = original.InterfaceTapConfigurationListResult
type InterfaceTapConfigurationListResultIterator = original.InterfaceTapConfigurationListResultIterator
type InterfaceTapConfigurationListResultPage = original.InterfaceTapConfigurationListResultPage
type InterfaceTapConfigurationPropertiesFormat = original.InterfaceTapConfigurationPropertiesFormat
type InterfaceTapConfigurationsClient = original.InterfaceTapConfigurationsClient
type InterfaceTapConfigurationsCreateOrUpdateFuture = original.InterfaceTapConfigurationsCreateOrUpdateFuture
type InterfaceTapConfigurationsDeleteFuture = original.InterfaceTapConfigurationsDeleteFuture
type InterfacesClient = original.InterfacesClient
type InterfacesCreateOrUpdateFuture = original.InterfacesCreateOrUpdateFuture
type InterfacesDeleteFuture = original.InterfacesDeleteFuture
type InterfacesGetEffectiveRouteTableFuture = original.InterfacesGetEffectiveRouteTableFuture
type InterfacesListEffectiveNetworkSecurityGroupsFuture = original.InterfacesListEffectiveNetworkSecurityGroupsFuture
type IpsecPolicy = original.IpsecPolicy
type Ipv6CircuitConnectionConfig = original.Ipv6CircuitConnectionConfig
type Ipv6ExpressRouteCircuitPeeringConfig = original.Ipv6ExpressRouteCircuitPeeringConfig
type ListHubRouteTablesResult = original.ListHubRouteTablesResult
type ListHubRouteTablesResultIterator = original.ListHubRouteTablesResultIterator
type ListHubRouteTablesResultPage = original.ListHubRouteTablesResultPage
type ListHubVirtualNetworkConnectionsResult = original.ListHubVirtualNetworkConnectionsResult
type ListHubVirtualNetworkConnectionsResultIterator = original.ListHubVirtualNetworkConnectionsResultIterator
type ListHubVirtualNetworkConnectionsResultPage = original.ListHubVirtualNetworkConnectionsResultPage
type ListP2SVpnGatewaysResult = original.ListP2SVpnGatewaysResult
type ListP2SVpnGatewaysResultIterator = original.ListP2SVpnGatewaysResultIterator
type ListP2SVpnGatewaysResultPage = original.ListP2SVpnGatewaysResultPage
type ListRouteMapsResult = original.ListRouteMapsResult
type ListRouteMapsResultIterator = original.ListRouteMapsResultIterator
type ListRouteMapsResultPage = original.ListRouteMapsResultPage
type ListRoutingIntentResult = original.ListRoutingIntentResult
type ListRoutingIntentResultIterator = original.ListRoutingIntentResultIterator
type ListRoutingIntentResultPage = original.ListRoutingIntentResultPage
type ListString = original.ListString
type ListVirtualHubBgpConnectionResults = original.ListVirtualHubBgpConnectionResults
type ListVirtualHubBgpConnectionResultsIterator = original.ListVirtualHubBgpConnectionResultsIterator
type ListVirtualHubBgpConnectionResultsPage = original.ListVirtualHubBgpConnectionResultsPage
type ListVirtualHubIPConfigurationResults = original.ListVirtualHubIPConfigurationResults
type ListVirtualHubIPConfigurationResultsIterator = original.ListVirtualHubIPConfigurationResultsIterator
type ListVirtualHubIPConfigurationResultsPage = original.ListVirtualHubIPConfigurationResultsPage
type ListVirtualHubRouteTableV2sResult = original.ListVirtualHubRouteTableV2sResult
type ListVirtualHubRouteTableV2sResultIterator = original.ListVirtualHubRouteTableV2sResultIterator
type ListVirtualHubRouteTableV2sResultPage = original.ListVirtualHubRouteTableV2sResultPage
type ListVirtualHubsResult = original.ListVirtualHubsResult
type ListVirtualHubsResultIterator = original.ListVirtualHubsResultIterator
type ListVirtualHubsResultPage = original.ListVirtualHubsResultPage
type ListVirtualNetworkGatewayNatRulesResult = original.ListVirtualNetworkGatewayNatRulesResult
type ListVirtualNetworkGatewayNatRulesResultIterator = original.ListVirtualNetworkGatewayNatRulesResultIterator
type ListVirtualNetworkGatewayNatRulesResultPage = original.ListVirtualNetworkGatewayNatRulesResultPage
type ListVirtualWANsResult = original.ListVirtualWANsResult
type ListVirtualWANsResultIterator = original.ListVirtualWANsResultIterator
type ListVirtualWANsResultPage = original.ListVirtualWANsResultPage
type ListVpnConnectionsResult = original.ListVpnConnectionsResult
type ListVpnConnectionsResultIterator = original.ListVpnConnectionsResultIterator
type ListVpnConnectionsResultPage = original.ListVpnConnectionsResultPage
type ListVpnGatewayNatRulesResult = original.ListVpnGatewayNatRulesResult
type ListVpnGatewayNatRulesResultIterator = original.ListVpnGatewayNatRulesResultIterator
type ListVpnGatewayNatRulesResultPage = original.ListVpnGatewayNatRulesResultPage
type ListVpnGatewaysResult = original.ListVpnGatewaysResult
type ListVpnGatewaysResultIterator = original.ListVpnGatewaysResultIterator
type ListVpnGatewaysResultPage = original.ListVpnGatewaysResultPage
type ListVpnServerConfigurationPolicyGroupsResult = original.ListVpnServerConfigurationPolicyGroupsResult
type ListVpnServerConfigurationPolicyGroupsResultIterator = original.ListVpnServerConfigurationPolicyGroupsResultIterator
type ListVpnServerConfigurationPolicyGroupsResultPage = original.ListVpnServerConfigurationPolicyGroupsResultPage
type ListVpnServerConfigurationsResult = original.ListVpnServerConfigurationsResult
type ListVpnServerConfigurationsResultIterator = original.ListVpnServerConfigurationsResultIterator
type ListVpnServerConfigurationsResultPage = original.ListVpnServerConfigurationsResultPage
type ListVpnSiteLinkConnectionsResult = original.ListVpnSiteLinkConnectionsResult
type ListVpnSiteLinkConnectionsResultIterator = original.ListVpnSiteLinkConnectionsResultIterator
type ListVpnSiteLinkConnectionsResultPage = original.ListVpnSiteLinkConnectionsResultPage
type ListVpnSiteLinksResult = original.ListVpnSiteLinksResult
type ListVpnSiteLinksResultIterator = original.ListVpnSiteLinksResultIterator
type ListVpnSiteLinksResultPage = original.ListVpnSiteLinksResultPage
type ListVpnSitesResult = original.ListVpnSitesResult
type ListVpnSitesResultIterator = original.ListVpnSitesResultIterator
type ListVpnSitesResultPage = original.ListVpnSitesResultPage
type LoadBalancer = original.LoadBalancer
type LoadBalancerBackendAddress = original.LoadBalancerBackendAddress
type LoadBalancerBackendAddressPoolListResult = original.LoadBalancerBackendAddressPoolListResult
type LoadBalancerBackendAddressPoolListResultIterator = original.LoadBalancerBackendAddressPoolListResultIterator
type LoadBalancerBackendAddressPoolListResultPage = original.LoadBalancerBackendAddressPoolListResultPage
type LoadBalancerBackendAddressPoolsClient = original.LoadBalancerBackendAddressPoolsClient
type LoadBalancerBackendAddressPoolsCreateOrUpdateFuture = original.LoadBalancerBackendAddressPoolsCreateOrUpdateFuture
type LoadBalancerBackendAddressPoolsDeleteFuture = original.LoadBalancerBackendAddressPoolsDeleteFuture
type LoadBalancerBackendAddressPropertiesFormat = original.LoadBalancerBackendAddressPropertiesFormat
type LoadBalancerFrontendIPConfigurationListResult = original.LoadBalancerFrontendIPConfigurationListResult
type LoadBalancerFrontendIPConfigurationListResultIterator = original.LoadBalancerFrontendIPConfigurationListResultIterator
type LoadBalancerFrontendIPConfigurationListResultPage = original.LoadBalancerFrontendIPConfigurationListResultPage
type LoadBalancerFrontendIPConfigurationsClient = original.LoadBalancerFrontendIPConfigurationsClient
type LoadBalancerListResult = original.LoadBalancerListResult
type LoadBalancerListResultIterator = original.LoadBalancerListResultIterator
type LoadBalancerListResultPage = original.LoadBalancerListResultPage
type LoadBalancerLoadBalancingRuleListResult = original.LoadBalancerLoadBalancingRuleListResult
type LoadBalancerLoadBalancingRuleListResultIterator = original.LoadBalancerLoadBalancingRuleListResultIterator
type LoadBalancerLoadBalancingRuleListResultPage = original.LoadBalancerLoadBalancingRuleListResultPage
type LoadBalancerLoadBalancingRulesClient = original.LoadBalancerLoadBalancingRulesClient
type LoadBalancerNetworkInterfacesClient = original.LoadBalancerNetworkInterfacesClient
type LoadBalancerOutboundRuleListResult = original.LoadBalancerOutboundRuleListResult
type LoadBalancerOutboundRuleListResultIterator = original.LoadBalancerOutboundRuleListResultIterator
type LoadBalancerOutboundRuleListResultPage = original.LoadBalancerOutboundRuleListResultPage
type LoadBalancerOutboundRulesClient = original.LoadBalancerOutboundRulesClient
type LoadBalancerProbeListResult = original.LoadBalancerProbeListResult
type LoadBalancerProbeListResultIterator = original.LoadBalancerProbeListResultIterator
type LoadBalancerProbeListResultPage = original.LoadBalancerProbeListResultPage
type LoadBalancerProbesClient = original.LoadBalancerProbesClient
type LoadBalancerPropertiesFormat = original.LoadBalancerPropertiesFormat
type LoadBalancerSku = original.LoadBalancerSku
type LoadBalancerVipSwapRequest = original.LoadBalancerVipSwapRequest
type LoadBalancerVipSwapRequestFrontendIPConfiguration = original.LoadBalancerVipSwapRequestFrontendIPConfiguration
type LoadBalancerVipSwapRequestFrontendIPConfigurationProperties = original.LoadBalancerVipSwapRequestFrontendIPConfigurationProperties
type LoadBalancersClient = original.LoadBalancersClient
type LoadBalancersCreateOrUpdateFuture = original.LoadBalancersCreateOrUpdateFuture
type LoadBalancersDeleteFuture = original.LoadBalancersDeleteFuture
type LoadBalancersListInboundNatRulePortMappingsFuture = original.LoadBalancersListInboundNatRulePortMappingsFuture
type LoadBalancersSwapPublicIPAddressesFuture = original.LoadBalancersSwapPublicIPAddressesFuture
type LoadBalancingRule = original.LoadBalancingRule
type LoadBalancingRulePropertiesFormat = original.LoadBalancingRulePropertiesFormat
type LocalNetworkGateway = original.LocalNetworkGateway
type LocalNetworkGatewayListResult = original.LocalNetworkGatewayListResult
type LocalNetworkGatewayListResultIterator = original.LocalNetworkGatewayListResultIterator
type LocalNetworkGatewayListResultPage = original.LocalNetworkGatewayListResultPage
type LocalNetworkGatewayPropertiesFormat = original.LocalNetworkGatewayPropertiesFormat
type LocalNetworkGatewaysClient = original.LocalNetworkGatewaysClient
type LocalNetworkGatewaysCreateOrUpdateFuture = original.LocalNetworkGatewaysCreateOrUpdateFuture
type LocalNetworkGatewaysDeleteFuture = original.LocalNetworkGatewaysDeleteFuture
type LogSpecification = original.LogSpecification
type ManagedRuleGroupOverride = original.ManagedRuleGroupOverride
type ManagedRuleOverride = original.ManagedRuleOverride
type ManagedRuleSet = original.ManagedRuleSet
type ManagedRulesDefinition = original.ManagedRulesDefinition
type ManagedServiceIdentity = original.ManagedServiceIdentity
type ManagedServiceIdentityUserAssignedIdentitiesValue = original.ManagedServiceIdentityUserAssignedIdentitiesValue
type ManagementGroupNetworkManagerConnectionsClient = original.ManagementGroupNetworkManagerConnectionsClient
type Manager = original.Manager
type ManagerCommit = original.ManagerCommit
type ManagerCommitsClient = original.ManagerCommitsClient
type ManagerCommitsPostFuture = original.ManagerCommitsPostFuture
type ManagerConnection = original.ManagerConnection
type ManagerConnectionListResult = original.ManagerConnectionListResult
type ManagerConnectionListResultIterator = original.ManagerConnectionListResultIterator
type ManagerConnectionListResultPage = original.ManagerConnectionListResultPage
type ManagerConnectionProperties = original.ManagerConnectionProperties
type ManagerDeploymentStatus = original.ManagerDeploymentStatus
type ManagerDeploymentStatusClient = original.ManagerDeploymentStatusClient
type ManagerDeploymentStatusListResult = original.ManagerDeploymentStatusListResult
type ManagerDeploymentStatusParameter = original.ManagerDeploymentStatusParameter
type ManagerEffectiveConnectivityConfigurationListResult = original.ManagerEffectiveConnectivityConfigurationListResult
type ManagerEffectiveSecurityAdminRulesListResult = original.ManagerEffectiveSecurityAdminRulesListResult
type ManagerListResult = original.ManagerListResult
type ManagerListResultIterator = original.ManagerListResultIterator
type ManagerListResultPage = original.ManagerListResultPage
type ManagerProperties = original.ManagerProperties
type ManagerPropertiesNetworkManagerScopes = original.ManagerPropertiesNetworkManagerScopes
type ManagerSecurityGroupItem = original.ManagerSecurityGroupItem
type ManagersClient = original.ManagersClient
type ManagersDeleteFuture = original.ManagersDeleteFuture
type MatchCondition = original.MatchCondition
type MatchVariable = original.MatchVariable
type MatchedRule = original.MatchedRule
type MetricSpecification = original.MetricSpecification
type NatGateway = original.NatGateway
type NatGatewayListResult = original.NatGatewayListResult
type NatGatewayListResultIterator = original.NatGatewayListResultIterator
type NatGatewayListResultPage = original.NatGatewayListResultPage
type NatGatewayPropertiesFormat = original.NatGatewayPropertiesFormat
type NatGatewaySku = original.NatGatewaySku
type NatGatewaysClient = original.NatGatewaysClient
type NatGatewaysCreateOrUpdateFuture = original.NatGatewaysCreateOrUpdateFuture
type NatGatewaysDeleteFuture = original.NatGatewaysDeleteFuture
type NatRule = original.NatRule
type NatRulePortMapping = original.NatRulePortMapping
type NatRulesClient = original.NatRulesClient
type NatRulesCreateOrUpdateFuture = original.NatRulesCreateOrUpdateFuture
type NatRulesDeleteFuture = original.NatRulesDeleteFuture
type NextHopParameters = original.NextHopParameters
type NextHopResult = original.NextHopResult
type O365BreakOutCategoryPolicies = original.O365BreakOutCategoryPolicies
type O365PolicyProperties = original.O365PolicyProperties
type Office365PolicyProperties = original.Office365PolicyProperties
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationPropertiesFormat = original.OperationPropertiesFormat
type OperationPropertiesFormatServiceSpecification = original.OperationPropertiesFormatServiceSpecification
type OperationsClient = original.OperationsClient
type OrderBy = original.OrderBy
type OutboundRule = original.OutboundRule
type OutboundRulePropertiesFormat = original.OutboundRulePropertiesFormat
type OwaspCrsExclusionEntry = original.OwaspCrsExclusionEntry
type P2SConnectionConfiguration = original.P2SConnectionConfiguration
type P2SConnectionConfigurationProperties = original.P2SConnectionConfigurationProperties
type P2SVpnConnectionHealth = original.P2SVpnConnectionHealth
type P2SVpnConnectionHealthRequest = original.P2SVpnConnectionHealthRequest
type P2SVpnConnectionRequest = original.P2SVpnConnectionRequest
type P2SVpnGateway = original.P2SVpnGateway
type P2SVpnGatewayProperties = original.P2SVpnGatewayProperties
type P2SVpnGatewaysResetFuture = original.P2SVpnGatewaysResetFuture
type P2SVpnProfileParameters = original.P2SVpnProfileParameters
type P2sVpnGatewaysClient = original.P2sVpnGatewaysClient
type P2sVpnGatewaysCreateOrUpdateFuture = original.P2sVpnGatewaysCreateOrUpdateFuture
type P2sVpnGatewaysDeleteFuture = original.P2sVpnGatewaysDeleteFuture
type P2sVpnGatewaysDisconnectP2sVpnConnectionsFuture = original.P2sVpnGatewaysDisconnectP2sVpnConnectionsFuture
type P2sVpnGatewaysGenerateVpnProfileFuture = original.P2sVpnGatewaysGenerateVpnProfileFuture
type P2sVpnGatewaysGetP2sVpnConnectionHealthDetailedFuture = original.P2sVpnGatewaysGetP2sVpnConnectionHealthDetailedFuture
type P2sVpnGatewaysGetP2sVpnConnectionHealthFuture = original.P2sVpnGatewaysGetP2sVpnConnectionHealthFuture
type P2sVpnGatewaysUpdateTagsFuture = original.P2sVpnGatewaysUpdateTagsFuture
type PacketCapture = original.PacketCapture
type PacketCaptureFilter = original.PacketCaptureFilter
type PacketCaptureListResult = original.PacketCaptureListResult
type PacketCaptureMachineScope = original.PacketCaptureMachineScope
type PacketCaptureParameters = original.PacketCaptureParameters
type PacketCaptureQueryStatusResult = original.PacketCaptureQueryStatusResult
type PacketCaptureResult = original.PacketCaptureResult
type PacketCaptureResultProperties = original.PacketCaptureResultProperties
type PacketCaptureStorageLocation = original.PacketCaptureStorageLocation
type PacketCapturesClient = original.PacketCapturesClient
type PacketCapturesCreateFuture = original.PacketCapturesCreateFuture
type PacketCapturesDeleteFuture = original.PacketCapturesDeleteFuture
type PacketCapturesGetStatusFuture = original.PacketCapturesGetStatusFuture
type PacketCapturesStopFuture = original.PacketCapturesStopFuture
type Parameter = original.Parameter
type PartnerManagedResourceProperties = original.PartnerManagedResourceProperties
type PatchObject = original.PatchObject
type PatchRouteFilter = original.PatchRouteFilter
type PatchRouteFilterRule = original.PatchRouteFilterRule
type PeerExpressRouteCircuitConnection = original.PeerExpressRouteCircuitConnection
type PeerExpressRouteCircuitConnectionListResult = original.PeerExpressRouteCircuitConnectionListResult
type PeerExpressRouteCircuitConnectionListResultIterator = original.PeerExpressRouteCircuitConnectionListResultIterator
type PeerExpressRouteCircuitConnectionListResultPage = original.PeerExpressRouteCircuitConnectionListResultPage
type PeerExpressRouteCircuitConnectionPropertiesFormat = original.PeerExpressRouteCircuitConnectionPropertiesFormat
type PeerExpressRouteCircuitConnectionsClient = original.PeerExpressRouteCircuitConnectionsClient
type PeerRoute = original.PeerRoute
type PeerRouteList = original.PeerRouteList
type PolicySettings = original.PolicySettings
type PrepareNetworkPoliciesRequest = original.PrepareNetworkPoliciesRequest
type PrivateDNSZoneConfig = original.PrivateDNSZoneConfig
type PrivateDNSZoneGroup = original.PrivateDNSZoneGroup
type PrivateDNSZoneGroupListResult = original.PrivateDNSZoneGroupListResult
type PrivateDNSZoneGroupListResultIterator = original.PrivateDNSZoneGroupListResultIterator
type PrivateDNSZoneGroupListResultPage = original.PrivateDNSZoneGroupListResultPage
type PrivateDNSZoneGroupPropertiesFormat = original.PrivateDNSZoneGroupPropertiesFormat
type PrivateDNSZoneGroupsClient = original.PrivateDNSZoneGroupsClient
type PrivateDNSZoneGroupsCreateOrUpdateFuture = original.PrivateDNSZoneGroupsCreateOrUpdateFuture
type PrivateDNSZoneGroupsDeleteFuture = original.PrivateDNSZoneGroupsDeleteFuture
type PrivateDNSZonePropertiesFormat = original.PrivateDNSZonePropertiesFormat
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionListResultIterator = original.PrivateEndpointConnectionListResultIterator
type PrivateEndpointConnectionListResultPage = original.PrivateEndpointConnectionListResultPage
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointIPConfiguration = original.PrivateEndpointIPConfiguration
type PrivateEndpointIPConfigurationProperties = original.PrivateEndpointIPConfigurationProperties
type PrivateEndpointListResult = original.PrivateEndpointListResult
type PrivateEndpointListResultIterator = original.PrivateEndpointListResultIterator
type PrivateEndpointListResultPage = original.PrivateEndpointListResultPage
type PrivateEndpointProperties = original.PrivateEndpointProperties
type PrivateEndpointsClient = original.PrivateEndpointsClient
type PrivateEndpointsCreateOrUpdateFuture = original.PrivateEndpointsCreateOrUpdateFuture
type PrivateEndpointsDeleteFuture = original.PrivateEndpointsDeleteFuture
type PrivateLinkService = original.PrivateLinkService
type PrivateLinkServiceConnection = original.PrivateLinkServiceConnection
type PrivateLinkServiceConnectionProperties = original.PrivateLinkServiceConnectionProperties
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type PrivateLinkServiceIPConfiguration = original.PrivateLinkServiceIPConfiguration
type PrivateLinkServiceIPConfigurationProperties = original.PrivateLinkServiceIPConfigurationProperties
type PrivateLinkServiceListResult = original.PrivateLinkServiceListResult
type PrivateLinkServiceListResultIterator = original.PrivateLinkServiceListResultIterator
type PrivateLinkServiceListResultPage = original.PrivateLinkServiceListResultPage
type PrivateLinkServiceProperties = original.PrivateLinkServiceProperties
type PrivateLinkServicePropertiesAutoApproval = original.PrivateLinkServicePropertiesAutoApproval
type PrivateLinkServicePropertiesVisibility = original.PrivateLinkServicePropertiesVisibility
type PrivateLinkServiceVisibility = original.PrivateLinkServiceVisibility
type PrivateLinkServicesCheckPrivateLinkServiceVisibilityByResourceGroupFuture = original.PrivateLinkServicesCheckPrivateLinkServiceVisibilityByResourceGroupFuture
type PrivateLinkServicesCheckPrivateLinkServiceVisibilityFuture = original.PrivateLinkServicesCheckPrivateLinkServiceVisibilityFuture
type PrivateLinkServicesClient = original.PrivateLinkServicesClient
type PrivateLinkServicesCreateOrUpdateFuture = original.PrivateLinkServicesCreateOrUpdateFuture
type PrivateLinkServicesDeleteFuture = original.PrivateLinkServicesDeleteFuture
type PrivateLinkServicesDeletePrivateEndpointConnectionFuture = original.PrivateLinkServicesDeletePrivateEndpointConnectionFuture
type Probe = original.Probe
type ProbePropertiesFormat = original.ProbePropertiesFormat
type Profile = original.Profile
type ProfileListResult = original.ProfileListResult
type ProfileListResultIterator = original.ProfileListResultIterator
type ProfileListResultPage = original.ProfileListResultPage
type ProfilePropertiesFormat = original.ProfilePropertiesFormat
type ProfilesClient = original.ProfilesClient
type ProfilesDeleteFuture = original.ProfilesDeleteFuture
type PropagatedRouteTable = original.PropagatedRouteTable
type ProtocolConfiguration = original.ProtocolConfiguration
type PublicIPAddress = original.PublicIPAddress
type PublicIPAddressDNSSettings = original.PublicIPAddressDNSSettings
type PublicIPAddressListResult = original.PublicIPAddressListResult
type PublicIPAddressListResultIterator = original.PublicIPAddressListResultIterator
type PublicIPAddressListResultPage = original.PublicIPAddressListResultPage
type PublicIPAddressPropertiesFormat = original.PublicIPAddressPropertiesFormat
type PublicIPAddressSku = original.PublicIPAddressSku
type PublicIPAddressesClient = original.PublicIPAddressesClient
type PublicIPAddressesCreateOrUpdateFuture = original.PublicIPAddressesCreateOrUpdateFuture
type PublicIPAddressesDdosProtectionStatusFuture = original.PublicIPAddressesDdosProtectionStatusFuture
type PublicIPAddressesDeleteFuture = original.PublicIPAddressesDeleteFuture
type PublicIPDdosProtectionStatusResult = original.PublicIPDdosProtectionStatusResult
type PublicIPPrefix = original.PublicIPPrefix
type PublicIPPrefixListResult = original.PublicIPPrefixListResult
type PublicIPPrefixListResultIterator = original.PublicIPPrefixListResultIterator
type PublicIPPrefixListResultPage = original.PublicIPPrefixListResultPage
type PublicIPPrefixPropertiesFormat = original.PublicIPPrefixPropertiesFormat
type PublicIPPrefixSku = original.PublicIPPrefixSku
type PublicIPPrefixesClient = original.PublicIPPrefixesClient
type PublicIPPrefixesCreateOrUpdateFuture = original.PublicIPPrefixesCreateOrUpdateFuture
type PublicIPPrefixesDeleteFuture = original.PublicIPPrefixesDeleteFuture
type PutBastionShareableLinkAllFuture = original.PutBastionShareableLinkAllFuture
type PutBastionShareableLinkFuture = original.PutBastionShareableLinkFuture
type QosDefinition = original.QosDefinition
type QosIPRange = original.QosIPRange
type QosPortRange = original.QosPortRange
type QueryInboundNatRulePortMappingRequest = original.QueryInboundNatRulePortMappingRequest
type QueryRequestOptions = original.QueryRequestOptions
type QueryResults = original.QueryResults
type QueryTroubleshootingParameters = original.QueryTroubleshootingParameters
type RadiusServer = original.RadiusServer
type RecordSet = original.RecordSet
type ReferencedPublicIPAddress = original.ReferencedPublicIPAddress
type Resource = original.Resource
type ResourceNavigationLink = original.ResourceNavigationLink
type ResourceNavigationLinkFormat = original.ResourceNavigationLinkFormat
type ResourceNavigationLinksClient = original.ResourceNavigationLinksClient
type ResourceNavigationLinksListResult = original.ResourceNavigationLinksListResult
type ResourceSet = original.ResourceSet
type RetentionPolicyParameters = original.RetentionPolicyParameters
type Route = original.Route
type RouteFilter = original.RouteFilter
type RouteFilterListResult = original.RouteFilterListResult
type RouteFilterListResultIterator = original.RouteFilterListResultIterator
type RouteFilterListResultPage = original.RouteFilterListResultPage
type RouteFilterPropertiesFormat = original.RouteFilterPropertiesFormat
type RouteFilterRule = original.RouteFilterRule
type RouteFilterRuleListResult = original.RouteFilterRuleListResult
type RouteFilterRuleListResultIterator = original.RouteFilterRuleListResultIterator
type RouteFilterRuleListResultPage = original.RouteFilterRuleListResultPage
type RouteFilterRulePropertiesFormat = original.RouteFilterRulePropertiesFormat
type RouteFilterRulesClient = original.RouteFilterRulesClient
type RouteFilterRulesCreateOrUpdateFuture = original.RouteFilterRulesCreateOrUpdateFuture
type RouteFilterRulesDeleteFuture = original.RouteFilterRulesDeleteFuture
type RouteFiltersClient = original.RouteFiltersClient
type RouteFiltersCreateOrUpdateFuture = original.RouteFiltersCreateOrUpdateFuture
type RouteFiltersDeleteFuture = original.RouteFiltersDeleteFuture
type RouteListResult = original.RouteListResult
type RouteListResultIterator = original.RouteListResultIterator
type RouteListResultPage = original.RouteListResultPage
type RouteMap = original.RouteMap
type RouteMapProperties = original.RouteMapProperties
type RouteMapRule = original.RouteMapRule
type RouteMapsClient = original.RouteMapsClient
type RouteMapsCreateOrUpdateFuture = original.RouteMapsCreateOrUpdateFuture
type RouteMapsDeleteFuture = original.RouteMapsDeleteFuture
type RoutePropertiesFormat = original.RoutePropertiesFormat
type RouteTable = original.RouteTable
type RouteTableListResult = original.RouteTableListResult
type RouteTableListResultIterator = original.RouteTableListResultIterator
type RouteTableListResultPage = original.RouteTableListResultPage
type RouteTablePropertiesFormat = original.RouteTablePropertiesFormat
type RouteTablesClient = original.RouteTablesClient
type RouteTablesCreateOrUpdateFuture = original.RouteTablesCreateOrUpdateFuture
type RouteTablesDeleteFuture = original.RouteTablesDeleteFuture
type RoutesClient = original.RoutesClient
type RoutesCreateOrUpdateFuture = original.RoutesCreateOrUpdateFuture
type RoutesDeleteFuture = original.RoutesDeleteFuture
type RoutingConfiguration = original.RoutingConfiguration
type RoutingIntent = original.RoutingIntent
type RoutingIntentClient = original.RoutingIntentClient
type RoutingIntentCreateOrUpdateFuture = original.RoutingIntentCreateOrUpdateFuture
type RoutingIntentDeleteFuture = original.RoutingIntentDeleteFuture
type RoutingIntentProperties = original.RoutingIntentProperties
type RoutingPolicy = original.RoutingPolicy
type Rule = original.Rule
type ScopeConnection = original.ScopeConnection
type ScopeConnectionListResult = original.ScopeConnectionListResult
type ScopeConnectionListResultIterator = original.ScopeConnectionListResultIterator
type ScopeConnectionListResultPage = original.ScopeConnectionListResultPage
type ScopeConnectionProperties = original.ScopeConnectionProperties
type ScopeConnectionsClient = original.ScopeConnectionsClient
type SecurityAdminConfiguration = original.SecurityAdminConfiguration
type SecurityAdminConfigurationListResult = original.SecurityAdminConfigurationListResult
type SecurityAdminConfigurationListResultIterator = original.SecurityAdminConfigurationListResultIterator
type SecurityAdminConfigurationListResultPage = original.SecurityAdminConfigurationListResultPage
type SecurityAdminConfigurationPropertiesFormat = original.SecurityAdminConfigurationPropertiesFormat
type SecurityAdminConfigurationsClient = original.SecurityAdminConfigurationsClient
type SecurityAdminConfigurationsDeleteFuture = original.SecurityAdminConfigurationsDeleteFuture
type SecurityGroup = original.SecurityGroup
type SecurityGroupListResult = original.SecurityGroupListResult
type SecurityGroupListResultIterator = original.SecurityGroupListResultIterator
type SecurityGroupListResultPage = original.SecurityGroupListResultPage
type SecurityGroupNetworkInterface = original.SecurityGroupNetworkInterface
type SecurityGroupPropertiesFormat = original.SecurityGroupPropertiesFormat
type SecurityGroupResult = original.SecurityGroupResult
type SecurityGroupViewParameters = original.SecurityGroupViewParameters
type SecurityGroupViewResult = original.SecurityGroupViewResult
type SecurityGroupsClient = original.SecurityGroupsClient
type SecurityGroupsCreateOrUpdateFuture = original.SecurityGroupsCreateOrUpdateFuture
type SecurityGroupsDeleteFuture = original.SecurityGroupsDeleteFuture
type SecurityPartnerProvider = original.SecurityPartnerProvider
type SecurityPartnerProviderListResult = original.SecurityPartnerProviderListResult
type SecurityPartnerProviderListResultIterator = original.SecurityPartnerProviderListResultIterator
type SecurityPartnerProviderListResultPage = original.SecurityPartnerProviderListResultPage
type SecurityPartnerProviderPropertiesFormat = original.SecurityPartnerProviderPropertiesFormat
type SecurityPartnerProvidersClient = original.SecurityPartnerProvidersClient
type SecurityPartnerProvidersCreateOrUpdateFuture = original.SecurityPartnerProvidersCreateOrUpdateFuture
type SecurityPartnerProvidersDeleteFuture = original.SecurityPartnerProvidersDeleteFuture
type SecurityRule = original.SecurityRule
type SecurityRuleAssociations = original.SecurityRuleAssociations
type SecurityRuleListResult = original.SecurityRuleListResult
type SecurityRuleListResultIterator = original.SecurityRuleListResultIterator
type SecurityRuleListResultPage = original.SecurityRuleListResultPage
type SecurityRulePropertiesFormat = original.SecurityRulePropertiesFormat
type SecurityRulesClient = original.SecurityRulesClient
type SecurityRulesCreateOrUpdateFuture = original.SecurityRulesCreateOrUpdateFuture
type SecurityRulesDeleteFuture = original.SecurityRulesDeleteFuture
type SecurityRulesEvaluationResult = original.SecurityRulesEvaluationResult
type ServiceAssociationLink = original.ServiceAssociationLink
type ServiceAssociationLinkPropertiesFormat = original.ServiceAssociationLinkPropertiesFormat
type ServiceAssociationLinksClient = original.ServiceAssociationLinksClient
type ServiceAssociationLinksListResult = original.ServiceAssociationLinksListResult
type ServiceDelegationPropertiesFormat = original.ServiceDelegationPropertiesFormat
type ServiceEndpointPoliciesClient = original.ServiceEndpointPoliciesClient
type ServiceEndpointPoliciesCreateOrUpdateFuture = original.ServiceEndpointPoliciesCreateOrUpdateFuture
type ServiceEndpointPoliciesDeleteFuture = original.ServiceEndpointPoliciesDeleteFuture
type ServiceEndpointPolicy = original.ServiceEndpointPolicy
type ServiceEndpointPolicyDefinition = original.ServiceEndpointPolicyDefinition
type ServiceEndpointPolicyDefinitionListResult = original.ServiceEndpointPolicyDefinitionListResult
type ServiceEndpointPolicyDefinitionListResultIterator = original.ServiceEndpointPolicyDefinitionListResultIterator
type ServiceEndpointPolicyDefinitionListResultPage = original.ServiceEndpointPolicyDefinitionListResultPage
type ServiceEndpointPolicyDefinitionPropertiesFormat = original.ServiceEndpointPolicyDefinitionPropertiesFormat
type ServiceEndpointPolicyDefinitionsClient = original.ServiceEndpointPolicyDefinitionsClient
type ServiceEndpointPolicyDefinitionsCreateOrUpdateFuture = original.ServiceEndpointPolicyDefinitionsCreateOrUpdateFuture
type ServiceEndpointPolicyDefinitionsDeleteFuture = original.ServiceEndpointPolicyDefinitionsDeleteFuture
type ServiceEndpointPolicyListResult = original.ServiceEndpointPolicyListResult
type ServiceEndpointPolicyListResultIterator = original.ServiceEndpointPolicyListResultIterator
type ServiceEndpointPolicyListResultPage = original.ServiceEndpointPolicyListResultPage
type ServiceEndpointPolicyPropertiesFormat = original.ServiceEndpointPolicyPropertiesFormat
type ServiceEndpointPropertiesFormat = original.ServiceEndpointPropertiesFormat
type ServiceTagInformation = original.ServiceTagInformation
type ServiceTagInformationClient = original.ServiceTagInformationClient
type ServiceTagInformationListResult = original.ServiceTagInformationListResult
type ServiceTagInformationListResultIterator = original.ServiceTagInformationListResultIterator
type ServiceTagInformationListResultPage = original.ServiceTagInformationListResultPage
type ServiceTagInformationPropertiesFormat = original.ServiceTagInformationPropertiesFormat
type ServiceTagsClient = original.ServiceTagsClient
type ServiceTagsListResult = original.ServiceTagsListResult
type SessionIds = original.SessionIds
type SignatureOverridesFilterValuesQuery = original.SignatureOverridesFilterValuesQuery
type SignatureOverridesFilterValuesResponse = original.SignatureOverridesFilterValuesResponse
type SignaturesOverrides = original.SignaturesOverrides
type SignaturesOverridesList = original.SignaturesOverridesList
type SignaturesOverridesProperties = original.SignaturesOverridesProperties
type SingleQueryResult = original.SingleQueryResult
type Sku = original.Sku
type StaticMember = original.StaticMember
type StaticMemberListResult = original.StaticMemberListResult
type StaticMemberListResultIterator = original.StaticMemberListResultIterator
type StaticMemberListResultPage = original.StaticMemberListResultPage
type StaticMemberProperties = original.StaticMemberProperties
type StaticMembersClient = original.StaticMembersClient
type StaticRoute = original.StaticRoute
type StaticRoutesConfig = original.StaticRoutesConfig
type String = original.String
type SubResource = original.SubResource
type Subnet = original.Subnet
type SubnetAssociation = original.SubnetAssociation
type SubnetListResult = original.SubnetListResult
type SubnetListResultIterator = original.SubnetListResultIterator
type SubnetListResultPage = original.SubnetListResultPage
type SubnetPropertiesFormat = original.SubnetPropertiesFormat
type SubnetsClient = original.SubnetsClient
type SubnetsCreateOrUpdateFuture = original.SubnetsCreateOrUpdateFuture
type SubnetsDeleteFuture = original.SubnetsDeleteFuture
type SubnetsPrepareNetworkPoliciesFuture = original.SubnetsPrepareNetworkPoliciesFuture
type SubnetsUnprepareNetworkPoliciesFuture = original.SubnetsUnprepareNetworkPoliciesFuture
type SubscriptionNetworkManagerConnectionsClient = original.SubscriptionNetworkManagerConnectionsClient
type SwapResource = original.SwapResource
type SwapResourceListResult = original.SwapResourceListResult
type SwapResourceProperties = original.SwapResourceProperties
type SystemData = original.SystemData
type TagsObject = original.TagsObject
type Topology = original.Topology
type TopologyAssociation = original.TopologyAssociation
type TopologyParameters = original.TopologyParameters
type TopologyResource = original.TopologyResource
type TrafficAnalyticsConfigurationProperties = original.TrafficAnalyticsConfigurationProperties
type TrafficAnalyticsProperties = original.TrafficAnalyticsProperties
type TrafficSelectorPolicy = original.TrafficSelectorPolicy
type TroubleshootingDetails = original.TroubleshootingDetails
type TroubleshootingParameters = original.TroubleshootingParameters
type TroubleshootingProperties = original.TroubleshootingProperties
type TroubleshootingRecommendedActions = original.TroubleshootingRecommendedActions
type TroubleshootingResult = original.TroubleshootingResult
type TunnelConnectionHealth = original.TunnelConnectionHealth
type UnprepareNetworkPoliciesRequest = original.UnprepareNetworkPoliciesRequest
type Usage = original.Usage
type UsageName = original.UsageName
type UsagesClient = original.UsagesClient
type UsagesListResult = original.UsagesListResult
type UsagesListResultIterator = original.UsagesListResultIterator
type UsagesListResultPage = original.UsagesListResultPage
type VM = original.VM
type VerificationIPFlowParameters = original.VerificationIPFlowParameters
type VerificationIPFlowResult = original.VerificationIPFlowResult
type VipSwapClient = original.VipSwapClient
type VipSwapCreateFuture = original.VipSwapCreateFuture
type VirtualAppliance = original.VirtualAppliance
type VirtualApplianceListResult = original.VirtualApplianceListResult
type VirtualApplianceListResultIterator = original.VirtualApplianceListResultIterator
type VirtualApplianceListResultPage = original.VirtualApplianceListResultPage
type VirtualApplianceNicProperties = original.VirtualApplianceNicProperties
type VirtualAppliancePropertiesFormat = original.VirtualAppliancePropertiesFormat
type VirtualApplianceSite = original.VirtualApplianceSite
type VirtualApplianceSiteListResult = original.VirtualApplianceSiteListResult
type VirtualApplianceSiteListResultIterator = original.VirtualApplianceSiteListResultIterator
type VirtualApplianceSiteListResultPage = original.VirtualApplianceSiteListResultPage
type VirtualApplianceSiteProperties = original.VirtualApplianceSiteProperties
type VirtualApplianceSitesClient = original.VirtualApplianceSitesClient
type VirtualApplianceSitesCreateOrUpdateFuture = original.VirtualApplianceSitesCreateOrUpdateFuture
type VirtualApplianceSitesDeleteFuture = original.VirtualApplianceSitesDeleteFuture
type VirtualApplianceSku = original.VirtualApplianceSku
type VirtualApplianceSkuInstances = original.VirtualApplianceSkuInstances
type VirtualApplianceSkuListResult = original.VirtualApplianceSkuListResult
type VirtualApplianceSkuListResultIterator = original.VirtualApplianceSkuListResultIterator
type VirtualApplianceSkuListResultPage = original.VirtualApplianceSkuListResultPage
type VirtualApplianceSkuProperties = original.VirtualApplianceSkuProperties
type VirtualApplianceSkuPropertiesFormat = original.VirtualApplianceSkuPropertiesFormat
type VirtualApplianceSkusClient = original.VirtualApplianceSkusClient
type VirtualAppliancesClient = original.VirtualAppliancesClient
type VirtualAppliancesCreateOrUpdateFuture = original.VirtualAppliancesCreateOrUpdateFuture
type VirtualAppliancesDeleteFuture = original.VirtualAppliancesDeleteFuture
type VirtualHub = original.VirtualHub
type VirtualHubBgpConnectionClient = original.VirtualHubBgpConnectionClient
type VirtualHubBgpConnectionCreateOrUpdateFuture = original.VirtualHubBgpConnectionCreateOrUpdateFuture
type VirtualHubBgpConnectionDeleteFuture = original.VirtualHubBgpConnectionDeleteFuture
type VirtualHubBgpConnectionsClient = original.VirtualHubBgpConnectionsClient
type VirtualHubBgpConnectionsListAdvertisedRoutesFuture = original.VirtualHubBgpConnectionsListAdvertisedRoutesFuture
type VirtualHubBgpConnectionsListLearnedRoutesFuture = original.VirtualHubBgpConnectionsListLearnedRoutesFuture
type VirtualHubEffectiveRoute = original.VirtualHubEffectiveRoute
type VirtualHubEffectiveRouteList = original.VirtualHubEffectiveRouteList
type VirtualHubID = original.VirtualHubID
type VirtualHubIPConfigurationClient = original.VirtualHubIPConfigurationClient
type VirtualHubIPConfigurationCreateOrUpdateFuture = original.VirtualHubIPConfigurationCreateOrUpdateFuture
type VirtualHubIPConfigurationDeleteFuture = original.VirtualHubIPConfigurationDeleteFuture
type VirtualHubProperties = original.VirtualHubProperties
type VirtualHubRoute = original.VirtualHubRoute
type VirtualHubRouteTable = original.VirtualHubRouteTable
type VirtualHubRouteTableV2 = original.VirtualHubRouteTableV2
type VirtualHubRouteTableV2Properties = original.VirtualHubRouteTableV2Properties
type VirtualHubRouteTableV2sClient = original.VirtualHubRouteTableV2sClient
type VirtualHubRouteTableV2sCreateOrUpdateFuture = original.VirtualHubRouteTableV2sCreateOrUpdateFuture
type VirtualHubRouteTableV2sDeleteFuture = original.VirtualHubRouteTableV2sDeleteFuture
type VirtualHubRouteV2 = original.VirtualHubRouteV2
type VirtualHubsClient = original.VirtualHubsClient
type VirtualHubsCreateOrUpdateFuture = original.VirtualHubsCreateOrUpdateFuture
type VirtualHubsDeleteFuture = original.VirtualHubsDeleteFuture
type VirtualHubsGetEffectiveVirtualHubRoutesFuture = original.VirtualHubsGetEffectiveVirtualHubRoutesFuture
type VirtualHubsGetInboundRoutesFuture = original.VirtualHubsGetInboundRoutesFuture
type VirtualHubsGetOutboundRoutesFuture = original.VirtualHubsGetOutboundRoutesFuture
type VirtualNetwork = original.VirtualNetwork
type VirtualNetworkBgpCommunities = original.VirtualNetworkBgpCommunities
type VirtualNetworkConnectionGatewayReference = original.VirtualNetworkConnectionGatewayReference
type VirtualNetworkDdosProtectionStatusResult = original.VirtualNetworkDdosProtectionStatusResult
type VirtualNetworkDdosProtectionStatusResultIterator = original.VirtualNetworkDdosProtectionStatusResultIterator
type VirtualNetworkDdosProtectionStatusResultPage = original.VirtualNetworkDdosProtectionStatusResultPage
type VirtualNetworkEncryption = original.VirtualNetworkEncryption
type VirtualNetworkGateway = original.VirtualNetworkGateway
type VirtualNetworkGatewayConnection = original.VirtualNetworkGatewayConnection
type VirtualNetworkGatewayConnectionListEntity = original.VirtualNetworkGatewayConnectionListEntity
type VirtualNetworkGatewayConnectionListEntityPropertiesFormat = original.VirtualNetworkGatewayConnectionListEntityPropertiesFormat
type VirtualNetworkGatewayConnectionListResult = original.VirtualNetworkGatewayConnectionListResult
type VirtualNetworkGatewayConnectionListResultIterator = original.VirtualNetworkGatewayConnectionListResultIterator
type VirtualNetworkGatewayConnectionListResultPage = original.VirtualNetworkGatewayConnectionListResultPage
type VirtualNetworkGatewayConnectionPropertiesFormat = original.VirtualNetworkGatewayConnectionPropertiesFormat
type VirtualNetworkGatewayConnectionsClient = original.VirtualNetworkGatewayConnectionsClient
type VirtualNetworkGatewayConnectionsCreateOrUpdateFuture = original.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture
type VirtualNetworkGatewayConnectionsDeleteFuture = original.VirtualNetworkGatewayConnectionsDeleteFuture
type VirtualNetworkGatewayConnectionsGetIkeSasFuture = original.VirtualNetworkGatewayConnectionsGetIkeSasFuture
type VirtualNetworkGatewayConnectionsResetConnectionFuture = original.VirtualNetworkGatewayConnectionsResetConnectionFuture
type VirtualNetworkGatewayConnectionsResetSharedKeyFuture = original.VirtualNetworkGatewayConnectionsResetSharedKeyFuture
type VirtualNetworkGatewayConnectionsSetSharedKeyFuture = original.VirtualNetworkGatewayConnectionsSetSharedKeyFuture
type VirtualNetworkGatewayConnectionsStartPacketCaptureFuture = original.VirtualNetworkGatewayConnectionsStartPacketCaptureFuture
type VirtualNetworkGatewayConnectionsStopPacketCaptureFuture = original.VirtualNetworkGatewayConnectionsStopPacketCaptureFuture
type VirtualNetworkGatewayConnectionsUpdateTagsFuture = original.VirtualNetworkGatewayConnectionsUpdateTagsFuture
type VirtualNetworkGatewayIPConfiguration = original.VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat = original.VirtualNetworkGatewayIPConfigurationPropertiesFormat
type VirtualNetworkGatewayListConnectionsResult = original.VirtualNetworkGatewayListConnectionsResult
type VirtualNetworkGatewayListConnectionsResultIterator = original.VirtualNetworkGatewayListConnectionsResultIterator
type VirtualNetworkGatewayListConnectionsResultPage = original.VirtualNetworkGatewayListConnectionsResultPage
type VirtualNetworkGatewayListResult = original.VirtualNetworkGatewayListResult
type VirtualNetworkGatewayListResultIterator = original.VirtualNetworkGatewayListResultIterator
type VirtualNetworkGatewayListResultPage = original.VirtualNetworkGatewayListResultPage
type VirtualNetworkGatewayNatRule = original.VirtualNetworkGatewayNatRule
type VirtualNetworkGatewayNatRuleProperties = original.VirtualNetworkGatewayNatRuleProperties
type VirtualNetworkGatewayNatRulesClient = original.VirtualNetworkGatewayNatRulesClient
type VirtualNetworkGatewayNatRulesCreateOrUpdateFuture = original.VirtualNetworkGatewayNatRulesCreateOrUpdateFuture
type VirtualNetworkGatewayNatRulesDeleteFuture = original.VirtualNetworkGatewayNatRulesDeleteFuture
type VirtualNetworkGatewayPolicyGroup = original.VirtualNetworkGatewayPolicyGroup
type VirtualNetworkGatewayPolicyGroupMember = original.VirtualNetworkGatewayPolicyGroupMember
type VirtualNetworkGatewayPolicyGroupProperties = original.VirtualNetworkGatewayPolicyGroupProperties
type VirtualNetworkGatewayPropertiesFormat = original.VirtualNetworkGatewayPropertiesFormat
type VirtualNetworkGatewaySku = original.VirtualNetworkGatewaySku
type VirtualNetworkGatewaysClient = original.VirtualNetworkGatewaysClient
type VirtualNetworkGatewaysCreateOrUpdateFuture = original.VirtualNetworkGatewaysCreateOrUpdateFuture
type VirtualNetworkGatewaysDeleteFuture = original.VirtualNetworkGatewaysDeleteFuture
type VirtualNetworkGatewaysDisconnectVirtualNetworkGatewayVpnConnectionsFuture = original.VirtualNetworkGatewaysDisconnectVirtualNetworkGatewayVpnConnectionsFuture
type VirtualNetworkGatewaysGenerateVpnProfileFuture = original.VirtualNetworkGatewaysGenerateVpnProfileFuture
type VirtualNetworkGatewaysGeneratevpnclientpackageFuture = original.VirtualNetworkGatewaysGeneratevpnclientpackageFuture
type VirtualNetworkGatewaysGetAdvertisedRoutesFuture = original.VirtualNetworkGatewaysGetAdvertisedRoutesFuture
type VirtualNetworkGatewaysGetBgpPeerStatusFuture = original.VirtualNetworkGatewaysGetBgpPeerStatusFuture
type VirtualNetworkGatewaysGetLearnedRoutesFuture = original.VirtualNetworkGatewaysGetLearnedRoutesFuture
type VirtualNetworkGatewaysGetVpnProfilePackageURLFuture = original.VirtualNetworkGatewaysGetVpnProfilePackageURLFuture
type VirtualNetworkGatewaysGetVpnclientConnectionHealthFuture = original.VirtualNetworkGatewaysGetVpnclientConnectionHealthFuture
type VirtualNetworkGatewaysGetVpnclientIpsecParametersFuture = original.VirtualNetworkGatewaysGetVpnclientIpsecParametersFuture
type VirtualNetworkGatewaysResetFuture = original.VirtualNetworkGatewaysResetFuture
type VirtualNetworkGatewaysResetVpnClientSharedKeyFuture = original.VirtualNetworkGatewaysResetVpnClientSharedKeyFuture
type VirtualNetworkGatewaysSetVpnclientIpsecParametersFuture = original.VirtualNetworkGatewaysSetVpnclientIpsecParametersFuture
type VirtualNetworkGatewaysStartPacketCaptureFuture = original.VirtualNetworkGatewaysStartPacketCaptureFuture
type VirtualNetworkGatewaysStopPacketCaptureFuture = original.VirtualNetworkGatewaysStopPacketCaptureFuture
type VirtualNetworkGatewaysUpdateTagsFuture = original.VirtualNetworkGatewaysUpdateTagsFuture
type VirtualNetworkListResult = original.VirtualNetworkListResult
type VirtualNetworkListResultIterator = original.VirtualNetworkListResultIterator
type VirtualNetworkListResultPage = original.VirtualNetworkListResultPage
type VirtualNetworkListUsageResult = original.VirtualNetworkListUsageResult
type VirtualNetworkListUsageResultIterator = original.VirtualNetworkListUsageResultIterator
type VirtualNetworkListUsageResultPage = original.VirtualNetworkListUsageResultPage
type VirtualNetworkPeering = original.VirtualNetworkPeering
type VirtualNetworkPeeringListResult = original.VirtualNetworkPeeringListResult
type VirtualNetworkPeeringListResultIterator = original.VirtualNetworkPeeringListResultIterator
type VirtualNetworkPeeringListResultPage = original.VirtualNetworkPeeringListResultPage
type VirtualNetworkPeeringPropertiesFormat = original.VirtualNetworkPeeringPropertiesFormat
type VirtualNetworkPeeringsClient = original.VirtualNetworkPeeringsClient
type VirtualNetworkPeeringsCreateOrUpdateFuture = original.VirtualNetworkPeeringsCreateOrUpdateFuture
type VirtualNetworkPeeringsDeleteFuture = original.VirtualNetworkPeeringsDeleteFuture
type VirtualNetworkPropertiesFormat = original.VirtualNetworkPropertiesFormat
type VirtualNetworkTap = original.VirtualNetworkTap
type VirtualNetworkTapListResult = original.VirtualNetworkTapListResult
type VirtualNetworkTapListResultIterator = original.VirtualNetworkTapListResultIterator
type VirtualNetworkTapListResultPage = original.VirtualNetworkTapListResultPage
type VirtualNetworkTapPropertiesFormat = original.VirtualNetworkTapPropertiesFormat
type VirtualNetworkTapsClient = original.VirtualNetworkTapsClient
type VirtualNetworkTapsCreateOrUpdateFuture = original.VirtualNetworkTapsCreateOrUpdateFuture
type VirtualNetworkTapsDeleteFuture = original.VirtualNetworkTapsDeleteFuture
type VirtualNetworkUsage = original.VirtualNetworkUsage
type VirtualNetworkUsageName = original.VirtualNetworkUsageName
type VirtualNetworksClient = original.VirtualNetworksClient
type VirtualNetworksCreateOrUpdateFuture = original.VirtualNetworksCreateOrUpdateFuture
type VirtualNetworksDeleteFuture = original.VirtualNetworksDeleteFuture
type VirtualNetworksListDdosProtectionStatusAllFuture = original.VirtualNetworksListDdosProtectionStatusAllFuture
type VirtualNetworksListDdosProtectionStatusFuture = original.VirtualNetworksListDdosProtectionStatusFuture
type VirtualRouter = original.VirtualRouter
type VirtualRouterAutoScaleConfiguration = original.VirtualRouterAutoScaleConfiguration
type VirtualRouterListResult = original.VirtualRouterListResult
type VirtualRouterListResultIterator = original.VirtualRouterListResultIterator
type VirtualRouterListResultPage = original.VirtualRouterListResultPage
type VirtualRouterPeering = original.VirtualRouterPeering
type VirtualRouterPeeringListResult = original.VirtualRouterPeeringListResult
type VirtualRouterPeeringListResultIterator = original.VirtualRouterPeeringListResultIterator
type VirtualRouterPeeringListResultPage = original.VirtualRouterPeeringListResultPage
type VirtualRouterPeeringProperties = original.VirtualRouterPeeringProperties
type VirtualRouterPeeringsClient = original.VirtualRouterPeeringsClient
type VirtualRouterPeeringsCreateOrUpdateFuture = original.VirtualRouterPeeringsCreateOrUpdateFuture
type VirtualRouterPeeringsDeleteFuture = original.VirtualRouterPeeringsDeleteFuture
type VirtualRouterPropertiesFormat = original.VirtualRouterPropertiesFormat
type VirtualRoutersClient = original.VirtualRoutersClient
type VirtualRoutersCreateOrUpdateFuture = original.VirtualRoutersCreateOrUpdateFuture
type VirtualRoutersDeleteFuture = original.VirtualRoutersDeleteFuture
type VirtualWAN = original.VirtualWAN
type VirtualWanProperties = original.VirtualWanProperties
type VirtualWanSecurityProvider = original.VirtualWanSecurityProvider
type VirtualWanSecurityProviders = original.VirtualWanSecurityProviders
type VirtualWanVpnProfileParameters = original.VirtualWanVpnProfileParameters
type VirtualWansClient = original.VirtualWansClient
type VirtualWansCreateOrUpdateFuture = original.VirtualWansCreateOrUpdateFuture
type VirtualWansDeleteFuture = original.VirtualWansDeleteFuture
type VnetRoute = original.VnetRoute
type VngClientConnectionConfiguration = original.VngClientConnectionConfiguration
type VngClientConnectionConfigurationProperties = original.VngClientConnectionConfigurationProperties
type VpnClientConfiguration = original.VpnClientConfiguration
type VpnClientConnectionHealth = original.VpnClientConnectionHealth
type VpnClientConnectionHealthDetail = original.VpnClientConnectionHealthDetail
type VpnClientConnectionHealthDetailListResult = original.VpnClientConnectionHealthDetailListResult
type VpnClientIPsecParameters = original.VpnClientIPsecParameters
type VpnClientParameters = original.VpnClientParameters
type VpnClientRevokedCertificate = original.VpnClientRevokedCertificate
type VpnClientRevokedCertificatePropertiesFormat = original.VpnClientRevokedCertificatePropertiesFormat
type VpnClientRootCertificate = original.VpnClientRootCertificate
type VpnClientRootCertificatePropertiesFormat = original.VpnClientRootCertificatePropertiesFormat
type VpnConnection = original.VpnConnection
type VpnConnectionPacketCaptureStartParameters = original.VpnConnectionPacketCaptureStartParameters
type VpnConnectionPacketCaptureStopParameters = original.VpnConnectionPacketCaptureStopParameters
type VpnConnectionProperties = original.VpnConnectionProperties
type VpnConnectionsClient = original.VpnConnectionsClient
type VpnConnectionsCreateOrUpdateFuture = original.VpnConnectionsCreateOrUpdateFuture
type VpnConnectionsDeleteFuture = original.VpnConnectionsDeleteFuture
type VpnConnectionsStartPacketCaptureFuture = original.VpnConnectionsStartPacketCaptureFuture
type VpnConnectionsStopPacketCaptureFuture = original.VpnConnectionsStopPacketCaptureFuture
type VpnDeviceScriptParameters = original.VpnDeviceScriptParameters
type VpnGateway = original.VpnGateway
type VpnGatewayIPConfiguration = original.VpnGatewayIPConfiguration
type VpnGatewayNatRule = original.VpnGatewayNatRule
type VpnGatewayNatRuleProperties = original.VpnGatewayNatRuleProperties
type VpnGatewayPacketCaptureStartParameters = original.VpnGatewayPacketCaptureStartParameters
type VpnGatewayPacketCaptureStopParameters = original.VpnGatewayPacketCaptureStopParameters
type VpnGatewayProperties = original.VpnGatewayProperties
type VpnGatewaysClient = original.VpnGatewaysClient
type VpnGatewaysCreateOrUpdateFuture = original.VpnGatewaysCreateOrUpdateFuture
type VpnGatewaysDeleteFuture = original.VpnGatewaysDeleteFuture
type VpnGatewaysResetFuture = original.VpnGatewaysResetFuture
type VpnGatewaysStartPacketCaptureFuture = original.VpnGatewaysStartPacketCaptureFuture
type VpnGatewaysStopPacketCaptureFuture = original.VpnGatewaysStopPacketCaptureFuture
type VpnGatewaysUpdateTagsFuture = original.VpnGatewaysUpdateTagsFuture
type VpnLinkBgpSettings = original.VpnLinkBgpSettings
type VpnLinkConnectionsClient = original.VpnLinkConnectionsClient
type VpnLinkConnectionsGetIkeSasFuture = original.VpnLinkConnectionsGetIkeSasFuture
type VpnLinkConnectionsResetConnectionFuture = original.VpnLinkConnectionsResetConnectionFuture
type VpnLinkProviderProperties = original.VpnLinkProviderProperties
type VpnNatRuleMapping = original.VpnNatRuleMapping
type VpnPacketCaptureStartParameters = original.VpnPacketCaptureStartParameters
type VpnPacketCaptureStopParameters = original.VpnPacketCaptureStopParameters
type VpnProfileResponse = original.VpnProfileResponse
type VpnServerConfigRadiusClientRootCertificate = original.VpnServerConfigRadiusClientRootCertificate
type VpnServerConfigRadiusServerRootCertificate = original.VpnServerConfigRadiusServerRootCertificate
type VpnServerConfigVpnClientRevokedCertificate = original.VpnServerConfigVpnClientRevokedCertificate
type VpnServerConfigVpnClientRootCertificate = original.VpnServerConfigVpnClientRootCertificate
type VpnServerConfiguration = original.VpnServerConfiguration
type VpnServerConfigurationPolicyGroup = original.VpnServerConfigurationPolicyGroup
type VpnServerConfigurationPolicyGroupMember = original.VpnServerConfigurationPolicyGroupMember
type VpnServerConfigurationPolicyGroupProperties = original.VpnServerConfigurationPolicyGroupProperties
type VpnServerConfigurationProperties = original.VpnServerConfigurationProperties
type VpnServerConfigurationsAssociatedWithVirtualWanClient = original.VpnServerConfigurationsAssociatedWithVirtualWanClient
type VpnServerConfigurationsAssociatedWithVirtualWanListFuture = original.VpnServerConfigurationsAssociatedWithVirtualWanListFuture
type VpnServerConfigurationsClient = original.VpnServerConfigurationsClient
type VpnServerConfigurationsCreateOrUpdateFuture = original.VpnServerConfigurationsCreateOrUpdateFuture
type VpnServerConfigurationsDeleteFuture = original.VpnServerConfigurationsDeleteFuture
type VpnServerConfigurationsResponse = original.VpnServerConfigurationsResponse
type VpnSite = original.VpnSite
type VpnSiteID = original.VpnSiteID
type VpnSiteLink = original.VpnSiteLink
type VpnSiteLinkConnection = original.VpnSiteLinkConnection
type VpnSiteLinkConnectionProperties = original.VpnSiteLinkConnectionProperties
type VpnSiteLinkConnectionsClient = original.VpnSiteLinkConnectionsClient
type VpnSiteLinkProperties = original.VpnSiteLinkProperties
type VpnSiteLinksClient = original.VpnSiteLinksClient
type VpnSiteProperties = original.VpnSiteProperties
type VpnSitesClient = original.VpnSitesClient
type VpnSitesConfigurationClient = original.VpnSitesConfigurationClient
type VpnSitesConfigurationDownloadFuture = original.VpnSitesConfigurationDownloadFuture
type VpnSitesCreateOrUpdateFuture = original.VpnSitesCreateOrUpdateFuture
type VpnSitesDeleteFuture = original.VpnSitesDeleteFuture
type Watcher = original.Watcher
type WatcherListResult = original.WatcherListResult
type WatcherPropertiesFormat = original.WatcherPropertiesFormat
type WatchersCheckConnectivityFuture = original.WatchersCheckConnectivityFuture
type WatchersClient = original.WatchersClient
type WatchersDeleteFuture = original.WatchersDeleteFuture
type WatchersGetAzureReachabilityReportFuture = original.WatchersGetAzureReachabilityReportFuture
type WatchersGetFlowLogStatusFuture = original.WatchersGetFlowLogStatusFuture
type WatchersGetNetworkConfigurationDiagnosticFuture = original.WatchersGetNetworkConfigurationDiagnosticFuture
type WatchersGetNextHopFuture = original.WatchersGetNextHopFuture
type WatchersGetTroubleshootingFuture = original.WatchersGetTroubleshootingFuture
type WatchersGetTroubleshootingResultFuture = original.WatchersGetTroubleshootingResultFuture
type WatchersGetVMSecurityRulesFuture = original.WatchersGetVMSecurityRulesFuture
type WatchersListAvailableProvidersFuture = original.WatchersListAvailableProvidersFuture
type WatchersSetFlowLogConfigurationFuture = original.WatchersSetFlowLogConfigurationFuture
type WatchersVerifyIPFlowFuture = original.WatchersVerifyIPFlowFuture
type WebApplicationFirewallCustomRule = original.WebApplicationFirewallCustomRule
type WebApplicationFirewallPoliciesClient = original.WebApplicationFirewallPoliciesClient
type WebApplicationFirewallPoliciesDeleteFuture = original.WebApplicationFirewallPoliciesDeleteFuture
type WebApplicationFirewallPolicy = original.WebApplicationFirewallPolicy
type WebApplicationFirewallPolicyListResult = original.WebApplicationFirewallPolicyListResult
type WebApplicationFirewallPolicyListResultIterator = original.WebApplicationFirewallPolicyListResultIterator
type WebApplicationFirewallPolicyListResultPage = original.WebApplicationFirewallPolicyListResultPage
type WebApplicationFirewallPolicyPropertiesFormat = original.WebApplicationFirewallPolicyPropertiesFormat
type WebCategoriesClient = original.WebCategoriesClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAdminRuleCollectionListResultIterator(page AdminRuleCollectionListResultPage) AdminRuleCollectionListResultIterator {
	return original.NewAdminRuleCollectionListResultIterator(page)
}
func NewAdminRuleCollectionListResultPage(cur AdminRuleCollectionListResult, getNextPage func(context.Context, AdminRuleCollectionListResult) (AdminRuleCollectionListResult, error)) AdminRuleCollectionListResultPage {
	return original.NewAdminRuleCollectionListResultPage(cur, getNextPage)
}
func NewAdminRuleCollectionsClient(subscriptionID string) AdminRuleCollectionsClient {
	return original.NewAdminRuleCollectionsClient(subscriptionID)
}
func NewAdminRuleCollectionsClientWithBaseURI(baseURI string, subscriptionID string) AdminRuleCollectionsClient {
	return original.NewAdminRuleCollectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAdminRuleListResultIterator(page AdminRuleListResultPage) AdminRuleListResultIterator {
	return original.NewAdminRuleListResultIterator(page)
}
func NewAdminRuleListResultPage(cur AdminRuleListResult, getNextPage func(context.Context, AdminRuleListResult) (AdminRuleListResult, error)) AdminRuleListResultPage {
	return original.NewAdminRuleListResultPage(cur, getNextPage)
}
func NewAdminRulesClient(subscriptionID string) AdminRulesClient {
	return original.NewAdminRulesClient(subscriptionID)
}
func NewAdminRulesClientWithBaseURI(baseURI string, subscriptionID string) AdminRulesClient {
	return original.NewAdminRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationGatewayAvailableSslPredefinedPoliciesIterator(page ApplicationGatewayAvailableSslPredefinedPoliciesPage) ApplicationGatewayAvailableSslPredefinedPoliciesIterator {
	return original.NewApplicationGatewayAvailableSslPredefinedPoliciesIterator(page)
}
func NewApplicationGatewayAvailableSslPredefinedPoliciesPage(cur ApplicationGatewayAvailableSslPredefinedPolicies, getNextPage func(context.Context, ApplicationGatewayAvailableSslPredefinedPolicies) (ApplicationGatewayAvailableSslPredefinedPolicies, error)) ApplicationGatewayAvailableSslPredefinedPoliciesPage {
	return original.NewApplicationGatewayAvailableSslPredefinedPoliciesPage(cur, getNextPage)
}
func NewApplicationGatewayListResultIterator(page ApplicationGatewayListResultPage) ApplicationGatewayListResultIterator {
	return original.NewApplicationGatewayListResultIterator(page)
}
func NewApplicationGatewayListResultPage(cur ApplicationGatewayListResult, getNextPage func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)) ApplicationGatewayListResultPage {
	return original.NewApplicationGatewayListResultPage(cur, getNextPage)
}
func NewApplicationGatewayPrivateEndpointConnectionListResultIterator(page ApplicationGatewayPrivateEndpointConnectionListResultPage) ApplicationGatewayPrivateEndpointConnectionListResultIterator {
	return original.NewApplicationGatewayPrivateEndpointConnectionListResultIterator(page)
}
func NewApplicationGatewayPrivateEndpointConnectionListResultPage(cur ApplicationGatewayPrivateEndpointConnectionListResult, getNextPage func(context.Context, ApplicationGatewayPrivateEndpointConnectionListResult) (ApplicationGatewayPrivateEndpointConnectionListResult, error)) ApplicationGatewayPrivateEndpointConnectionListResultPage {
	return original.NewApplicationGatewayPrivateEndpointConnectionListResultPage(cur, getNextPage)
}
func NewApplicationGatewayPrivateEndpointConnectionsClient(subscriptionID string) ApplicationGatewayPrivateEndpointConnectionsClient {
	return original.NewApplicationGatewayPrivateEndpointConnectionsClient(subscriptionID)
}
func NewApplicationGatewayPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGatewayPrivateEndpointConnectionsClient {
	return original.NewApplicationGatewayPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationGatewayPrivateLinkResourceListResultIterator(page ApplicationGatewayPrivateLinkResourceListResultPage) ApplicationGatewayPrivateLinkResourceListResultIterator {
	return original.NewApplicationGatewayPrivateLinkResourceListResultIterator(page)
}
func NewApplicationGatewayPrivateLinkResourceListResultPage(cur ApplicationGatewayPrivateLinkResourceListResult, getNextPage func(context.Context, ApplicationGatewayPrivateLinkResourceListResult) (ApplicationGatewayPrivateLinkResourceListResult, error)) ApplicationGatewayPrivateLinkResourceListResultPage {
	return original.NewApplicationGatewayPrivateLinkResourceListResultPage(cur, getNextPage)
}
func NewApplicationGatewayPrivateLinkResourcesClient(subscriptionID string) ApplicationGatewayPrivateLinkResourcesClient {
	return original.NewApplicationGatewayPrivateLinkResourcesClient(subscriptionID)
}
func NewApplicationGatewayPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGatewayPrivateLinkResourcesClient {
	return original.NewApplicationGatewayPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationGatewayWafDynamicManifestResultListIterator(page ApplicationGatewayWafDynamicManifestResultListPage) ApplicationGatewayWafDynamicManifestResultListIterator {
	return original.NewApplicationGatewayWafDynamicManifestResultListIterator(page)
}
func NewApplicationGatewayWafDynamicManifestResultListPage(cur ApplicationGatewayWafDynamicManifestResultList, getNextPage func(context.Context, ApplicationGatewayWafDynamicManifestResultList) (ApplicationGatewayWafDynamicManifestResultList, error)) ApplicationGatewayWafDynamicManifestResultListPage {
	return original.NewApplicationGatewayWafDynamicManifestResultListPage(cur, getNextPage)
}
func NewApplicationGatewayWafDynamicManifestsClient(subscriptionID string) ApplicationGatewayWafDynamicManifestsClient {
	return original.NewApplicationGatewayWafDynamicManifestsClient(subscriptionID)
}
func NewApplicationGatewayWafDynamicManifestsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGatewayWafDynamicManifestsClient {
	return original.NewApplicationGatewayWafDynamicManifestsClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationGatewayWafDynamicManifestsDefaultClient(subscriptionID string) ApplicationGatewayWafDynamicManifestsDefaultClient {
	return original.NewApplicationGatewayWafDynamicManifestsDefaultClient(subscriptionID)
}
func NewApplicationGatewayWafDynamicManifestsDefaultClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGatewayWafDynamicManifestsDefaultClient {
	return original.NewApplicationGatewayWafDynamicManifestsDefaultClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationGatewaysClient(subscriptionID string) ApplicationGatewaysClient {
	return original.NewApplicationGatewaysClient(subscriptionID)
}
func NewApplicationGatewaysClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGatewaysClient {
	return original.NewApplicationGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationSecurityGroupListResultIterator(page ApplicationSecurityGroupListResultPage) ApplicationSecurityGroupListResultIterator {
	return original.NewApplicationSecurityGroupListResultIterator(page)
}
func NewApplicationSecurityGroupListResultPage(cur ApplicationSecurityGroupListResult, getNextPage func(context.Context, ApplicationSecurityGroupListResult) (ApplicationSecurityGroupListResult, error)) ApplicationSecurityGroupListResultPage {
	return original.NewApplicationSecurityGroupListResultPage(cur, getNextPage)
}
func NewApplicationSecurityGroupsClient(subscriptionID string) ApplicationSecurityGroupsClient {
	return original.NewApplicationSecurityGroupsClient(subscriptionID)
}
func NewApplicationSecurityGroupsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationSecurityGroupsClient {
	return original.NewApplicationSecurityGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAuthorizationListResultIterator(page AuthorizationListResultPage) AuthorizationListResultIterator {
	return original.NewAuthorizationListResultIterator(page)
}
func NewAuthorizationListResultPage(cur AuthorizationListResult, getNextPage func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)) AuthorizationListResultPage {
	return original.NewAuthorizationListResultPage(cur, getNextPage)
}
func NewAutoApprovedPrivateLinkServicesResultIterator(page AutoApprovedPrivateLinkServicesResultPage) AutoApprovedPrivateLinkServicesResultIterator {
	return original.NewAutoApprovedPrivateLinkServicesResultIterator(page)
}
func NewAutoApprovedPrivateLinkServicesResultPage(cur AutoApprovedPrivateLinkServicesResult, getNextPage func(context.Context, AutoApprovedPrivateLinkServicesResult) (AutoApprovedPrivateLinkServicesResult, error)) AutoApprovedPrivateLinkServicesResultPage {
	return original.NewAutoApprovedPrivateLinkServicesResultPage(cur, getNextPage)
}
func NewAvailableDelegationsClient(subscriptionID string) AvailableDelegationsClient {
	return original.NewAvailableDelegationsClient(subscriptionID)
}
func NewAvailableDelegationsClientWithBaseURI(baseURI string, subscriptionID string) AvailableDelegationsClient {
	return original.NewAvailableDelegationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailableDelegationsResultIterator(page AvailableDelegationsResultPage) AvailableDelegationsResultIterator {
	return original.NewAvailableDelegationsResultIterator(page)
}
func NewAvailableDelegationsResultPage(cur AvailableDelegationsResult, getNextPage func(context.Context, AvailableDelegationsResult) (AvailableDelegationsResult, error)) AvailableDelegationsResultPage {
	return original.NewAvailableDelegationsResultPage(cur, getNextPage)
}
func NewAvailableEndpointServicesClient(subscriptionID string) AvailableEndpointServicesClient {
	return original.NewAvailableEndpointServicesClient(subscriptionID)
}
func NewAvailableEndpointServicesClientWithBaseURI(baseURI string, subscriptionID string) AvailableEndpointServicesClient {
	return original.NewAvailableEndpointServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailablePrivateEndpointTypesClient(subscriptionID string) AvailablePrivateEndpointTypesClient {
	return original.NewAvailablePrivateEndpointTypesClient(subscriptionID)
}
func NewAvailablePrivateEndpointTypesClientWithBaseURI(baseURI string, subscriptionID string) AvailablePrivateEndpointTypesClient {
	return original.NewAvailablePrivateEndpointTypesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailablePrivateEndpointTypesResultIterator(page AvailablePrivateEndpointTypesResultPage) AvailablePrivateEndpointTypesResultIterator {
	return original.NewAvailablePrivateEndpointTypesResultIterator(page)
}
func NewAvailablePrivateEndpointTypesResultPage(cur AvailablePrivateEndpointTypesResult, getNextPage func(context.Context, AvailablePrivateEndpointTypesResult) (AvailablePrivateEndpointTypesResult, error)) AvailablePrivateEndpointTypesResultPage {
	return original.NewAvailablePrivateEndpointTypesResultPage(cur, getNextPage)
}
func NewAvailableResourceGroupDelegationsClient(subscriptionID string) AvailableResourceGroupDelegationsClient {
	return original.NewAvailableResourceGroupDelegationsClient(subscriptionID)
}
func NewAvailableResourceGroupDelegationsClientWithBaseURI(baseURI string, subscriptionID string) AvailableResourceGroupDelegationsClient {
	return original.NewAvailableResourceGroupDelegationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailableServiceAliasesClient(subscriptionID string) AvailableServiceAliasesClient {
	return original.NewAvailableServiceAliasesClient(subscriptionID)
}
func NewAvailableServiceAliasesClientWithBaseURI(baseURI string, subscriptionID string) AvailableServiceAliasesClient {
	return original.NewAvailableServiceAliasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailableServiceAliasesResultIterator(page AvailableServiceAliasesResultPage) AvailableServiceAliasesResultIterator {
	return original.NewAvailableServiceAliasesResultIterator(page)
}
func NewAvailableServiceAliasesResultPage(cur AvailableServiceAliasesResult, getNextPage func(context.Context, AvailableServiceAliasesResult) (AvailableServiceAliasesResult, error)) AvailableServiceAliasesResultPage {
	return original.NewAvailableServiceAliasesResultPage(cur, getNextPage)
}
func NewAzureFirewallFqdnTagListResultIterator(page AzureFirewallFqdnTagListResultPage) AzureFirewallFqdnTagListResultIterator {
	return original.NewAzureFirewallFqdnTagListResultIterator(page)
}
func NewAzureFirewallFqdnTagListResultPage(cur AzureFirewallFqdnTagListResult, getNextPage func(context.Context, AzureFirewallFqdnTagListResult) (AzureFirewallFqdnTagListResult, error)) AzureFirewallFqdnTagListResultPage {
	return original.NewAzureFirewallFqdnTagListResultPage(cur, getNextPage)
}
func NewAzureFirewallFqdnTagsClient(subscriptionID string) AzureFirewallFqdnTagsClient {
	return original.NewAzureFirewallFqdnTagsClient(subscriptionID)
}
func NewAzureFirewallFqdnTagsClientWithBaseURI(baseURI string, subscriptionID string) AzureFirewallFqdnTagsClient {
	return original.NewAzureFirewallFqdnTagsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAzureFirewallListResultIterator(page AzureFirewallListResultPage) AzureFirewallListResultIterator {
	return original.NewAzureFirewallListResultIterator(page)
}
func NewAzureFirewallListResultPage(cur AzureFirewallListResult, getNextPage func(context.Context, AzureFirewallListResult) (AzureFirewallListResult, error)) AzureFirewallListResultPage {
	return original.NewAzureFirewallListResultPage(cur, getNextPage)
}
func NewAzureFirewallsClient(subscriptionID string) AzureFirewallsClient {
	return original.NewAzureFirewallsClient(subscriptionID)
}
func NewAzureFirewallsClientWithBaseURI(baseURI string, subscriptionID string) AzureFirewallsClient {
	return original.NewAzureFirewallsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAzureWebCategoryListResultIterator(page AzureWebCategoryListResultPage) AzureWebCategoryListResultIterator {
	return original.NewAzureWebCategoryListResultIterator(page)
}
func NewAzureWebCategoryListResultPage(cur AzureWebCategoryListResult, getNextPage func(context.Context, AzureWebCategoryListResult) (AzureWebCategoryListResult, error)) AzureWebCategoryListResultPage {
	return original.NewAzureWebCategoryListResultPage(cur, getNextPage)
}
func NewBastionActiveSessionListResultIterator(page BastionActiveSessionListResultPage) BastionActiveSessionListResultIterator {
	return original.NewBastionActiveSessionListResultIterator(page)
}
func NewBastionActiveSessionListResultPage(cur BastionActiveSessionListResult, getNextPage func(context.Context, BastionActiveSessionListResult) (BastionActiveSessionListResult, error)) BastionActiveSessionListResultPage {
	return original.NewBastionActiveSessionListResultPage(cur, getNextPage)
}
func NewBastionHostListResultIterator(page BastionHostListResultPage) BastionHostListResultIterator {
	return original.NewBastionHostListResultIterator(page)
}
func NewBastionHostListResultPage(cur BastionHostListResult, getNextPage func(context.Context, BastionHostListResult) (BastionHostListResult, error)) BastionHostListResultPage {
	return original.NewBastionHostListResultPage(cur, getNextPage)
}
func NewBastionHostsClient(subscriptionID string) BastionHostsClient {
	return original.NewBastionHostsClient(subscriptionID)
}
func NewBastionHostsClientWithBaseURI(baseURI string, subscriptionID string) BastionHostsClient {
	return original.NewBastionHostsClientWithBaseURI(baseURI, subscriptionID)
}
func NewBastionSessionDeleteResultIterator(page BastionSessionDeleteResultPage) BastionSessionDeleteResultIterator {
	return original.NewBastionSessionDeleteResultIterator(page)
}
func NewBastionSessionDeleteResultPage(cur BastionSessionDeleteResult, getNextPage func(context.Context, BastionSessionDeleteResult) (BastionSessionDeleteResult, error)) BastionSessionDeleteResultPage {
	return original.NewBastionSessionDeleteResultPage(cur, getNextPage)
}
func NewBastionShareableLinkListResultIterator(page BastionShareableLinkListResultPage) BastionShareableLinkListResultIterator {
	return original.NewBastionShareableLinkListResultIterator(page)
}
func NewBastionShareableLinkListResultPage(cur BastionShareableLinkListResult, getNextPage func(context.Context, BastionShareableLinkListResult) (BastionShareableLinkListResult, error)) BastionShareableLinkListResultPage {
	return original.NewBastionShareableLinkListResultPage(cur, getNextPage)
}
func NewBgpServiceCommunitiesClient(subscriptionID string) BgpServiceCommunitiesClient {
	return original.NewBgpServiceCommunitiesClient(subscriptionID)
}
func NewBgpServiceCommunitiesClientWithBaseURI(baseURI string, subscriptionID string) BgpServiceCommunitiesClient {
	return original.NewBgpServiceCommunitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBgpServiceCommunityListResultIterator(page BgpServiceCommunityListResultPage) BgpServiceCommunityListResultIterator {
	return original.NewBgpServiceCommunityListResultIterator(page)
}
func NewBgpServiceCommunityListResultPage(cur BgpServiceCommunityListResult, getNextPage func(context.Context, BgpServiceCommunityListResult) (BgpServiceCommunityListResult, error)) BgpServiceCommunityListResultPage {
	return original.NewBgpServiceCommunityListResultPage(cur, getNextPage)
}
func NewConfigurationPolicyGroupsClient(subscriptionID string) ConfigurationPolicyGroupsClient {
	return original.NewConfigurationPolicyGroupsClient(subscriptionID)
}
func NewConfigurationPolicyGroupsClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationPolicyGroupsClient {
	return original.NewConfigurationPolicyGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectionMonitorsClient(subscriptionID string) ConnectionMonitorsClient {
	return original.NewConnectionMonitorsClient(subscriptionID)
}
func NewConnectionMonitorsClientWithBaseURI(baseURI string, subscriptionID string) ConnectionMonitorsClient {
	return original.NewConnectionMonitorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectivityConfigurationListResultIterator(page ConnectivityConfigurationListResultPage) ConnectivityConfigurationListResultIterator {
	return original.NewConnectivityConfigurationListResultIterator(page)
}
func NewConnectivityConfigurationListResultPage(cur ConnectivityConfigurationListResult, getNextPage func(context.Context, ConnectivityConfigurationListResult) (ConnectivityConfigurationListResult, error)) ConnectivityConfigurationListResultPage {
	return original.NewConnectivityConfigurationListResultPage(cur, getNextPage)
}
func NewConnectivityConfigurationsClient(subscriptionID string) ConnectivityConfigurationsClient {
	return original.NewConnectivityConfigurationsClient(subscriptionID)
}
func NewConnectivityConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) ConnectivityConfigurationsClient {
	return original.NewConnectivityConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCustomIPPrefixListResultIterator(page CustomIPPrefixListResultPage) CustomIPPrefixListResultIterator {
	return original.NewCustomIPPrefixListResultIterator(page)
}
func NewCustomIPPrefixListResultPage(cur CustomIPPrefixListResult, getNextPage func(context.Context, CustomIPPrefixListResult) (CustomIPPrefixListResult, error)) CustomIPPrefixListResultPage {
	return original.NewCustomIPPrefixListResultPage(cur, getNextPage)
}
func NewCustomIPPrefixesClient(subscriptionID string) CustomIPPrefixesClient {
	return original.NewCustomIPPrefixesClient(subscriptionID)
}
func NewCustomIPPrefixesClientWithBaseURI(baseURI string, subscriptionID string) CustomIPPrefixesClient {
	return original.NewCustomIPPrefixesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDdosCustomPoliciesClient(subscriptionID string) DdosCustomPoliciesClient {
	return original.NewDdosCustomPoliciesClient(subscriptionID)
}
func NewDdosCustomPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DdosCustomPoliciesClient {
	return original.NewDdosCustomPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDdosProtectionPlanListResultIterator(page DdosProtectionPlanListResultPage) DdosProtectionPlanListResultIterator {
	return original.NewDdosProtectionPlanListResultIterator(page)
}
func NewDdosProtectionPlanListResultPage(cur DdosProtectionPlanListResult, getNextPage func(context.Context, DdosProtectionPlanListResult) (DdosProtectionPlanListResult, error)) DdosProtectionPlanListResultPage {
	return original.NewDdosProtectionPlanListResultPage(cur, getNextPage)
}
func NewDdosProtectionPlansClient(subscriptionID string) DdosProtectionPlansClient {
	return original.NewDdosProtectionPlansClient(subscriptionID)
}
func NewDdosProtectionPlansClientWithBaseURI(baseURI string, subscriptionID string) DdosProtectionPlansClient {
	return original.NewDdosProtectionPlansClientWithBaseURI(baseURI, subscriptionID)
}
func NewDefaultSecurityRulesClient(subscriptionID string) DefaultSecurityRulesClient {
	return original.NewDefaultSecurityRulesClient(subscriptionID)
}
func NewDefaultSecurityRulesClientWithBaseURI(baseURI string, subscriptionID string) DefaultSecurityRulesClient {
	return original.NewDefaultSecurityRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscpConfigurationClient(subscriptionID string) DscpConfigurationClient {
	return original.NewDscpConfigurationClient(subscriptionID)
}
func NewDscpConfigurationClientWithBaseURI(baseURI string, subscriptionID string) DscpConfigurationClient {
	return original.NewDscpConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscpConfigurationListResultIterator(page DscpConfigurationListResultPage) DscpConfigurationListResultIterator {
	return original.NewDscpConfigurationListResultIterator(page)
}
func NewDscpConfigurationListResultPage(cur DscpConfigurationListResult, getNextPage func(context.Context, DscpConfigurationListResult) (DscpConfigurationListResult, error)) DscpConfigurationListResultPage {
	return original.NewDscpConfigurationListResultPage(cur, getNextPage)
}
func NewEndpointServicesListResultIterator(page EndpointServicesListResultPage) EndpointServicesListResultIterator {
	return original.NewEndpointServicesListResultIterator(page)
}
func NewEndpointServicesListResultPage(cur EndpointServicesListResult, getNextPage func(context.Context, EndpointServicesListResult) (EndpointServicesListResult, error)) EndpointServicesListResultPage {
	return original.NewEndpointServicesListResultPage(cur, getNextPage)
}
func NewExpressRouteCircuitAuthorizationsClient(subscriptionID string) ExpressRouteCircuitAuthorizationsClient {
	return original.NewExpressRouteCircuitAuthorizationsClient(subscriptionID)
}
func NewExpressRouteCircuitAuthorizationsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitAuthorizationsClient {
	return original.NewExpressRouteCircuitAuthorizationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitConnectionListResultIterator(page ExpressRouteCircuitConnectionListResultPage) ExpressRouteCircuitConnectionListResultIterator {
	return original.NewExpressRouteCircuitConnectionListResultIterator(page)
}
func NewExpressRouteCircuitConnectionListResultPage(cur ExpressRouteCircuitConnectionListResult, getNextPage func(context.Context, ExpressRouteCircuitConnectionListResult) (ExpressRouteCircuitConnectionListResult, error)) ExpressRouteCircuitConnectionListResultPage {
	return original.NewExpressRouteCircuitConnectionListResultPage(cur, getNextPage)
}
func NewExpressRouteCircuitConnectionsClient(subscriptionID string) ExpressRouteCircuitConnectionsClient {
	return original.NewExpressRouteCircuitConnectionsClient(subscriptionID)
}
func NewExpressRouteCircuitConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitConnectionsClient {
	return original.NewExpressRouteCircuitConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitListResultIterator(page ExpressRouteCircuitListResultPage) ExpressRouteCircuitListResultIterator {
	return original.NewExpressRouteCircuitListResultIterator(page)
}
func NewExpressRouteCircuitListResultPage(cur ExpressRouteCircuitListResult, getNextPage func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)) ExpressRouteCircuitListResultPage {
	return original.NewExpressRouteCircuitListResultPage(cur, getNextPage)
}
func NewExpressRouteCircuitPeeringListResultIterator(page ExpressRouteCircuitPeeringListResultPage) ExpressRouteCircuitPeeringListResultIterator {
	return original.NewExpressRouteCircuitPeeringListResultIterator(page)
}
func NewExpressRouteCircuitPeeringListResultPage(cur ExpressRouteCircuitPeeringListResult, getNextPage func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)) ExpressRouteCircuitPeeringListResultPage {
	return original.NewExpressRouteCircuitPeeringListResultPage(cur, getNextPage)
}
func NewExpressRouteCircuitPeeringsClient(subscriptionID string) ExpressRouteCircuitPeeringsClient {
	return original.NewExpressRouteCircuitPeeringsClient(subscriptionID)
}
func NewExpressRouteCircuitPeeringsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitPeeringsClient {
	return original.NewExpressRouteCircuitPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitsClient(subscriptionID string) ExpressRouteCircuitsClient {
	return original.NewExpressRouteCircuitsClient(subscriptionID)
}
func NewExpressRouteCircuitsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitsClient {
	return original.NewExpressRouteCircuitsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteConnectionsClient(subscriptionID string) ExpressRouteConnectionsClient {
	return original.NewExpressRouteConnectionsClient(subscriptionID)
}
func NewExpressRouteConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteConnectionsClient {
	return original.NewExpressRouteConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCrossConnectionListResultIterator(page ExpressRouteCrossConnectionListResultPage) ExpressRouteCrossConnectionListResultIterator {
	return original.NewExpressRouteCrossConnectionListResultIterator(page)
}
func NewExpressRouteCrossConnectionListResultPage(cur ExpressRouteCrossConnectionListResult, getNextPage func(context.Context, ExpressRouteCrossConnectionListResult) (ExpressRouteCrossConnectionListResult, error)) ExpressRouteCrossConnectionListResultPage {
	return original.NewExpressRouteCrossConnectionListResultPage(cur, getNextPage)
}
func NewExpressRouteCrossConnectionPeeringListIterator(page ExpressRouteCrossConnectionPeeringListPage) ExpressRouteCrossConnectionPeeringListIterator {
	return original.NewExpressRouteCrossConnectionPeeringListIterator(page)
}
func NewExpressRouteCrossConnectionPeeringListPage(cur ExpressRouteCrossConnectionPeeringList, getNextPage func(context.Context, ExpressRouteCrossConnectionPeeringList) (ExpressRouteCrossConnectionPeeringList, error)) ExpressRouteCrossConnectionPeeringListPage {
	return original.NewExpressRouteCrossConnectionPeeringListPage(cur, getNextPage)
}
func NewExpressRouteCrossConnectionPeeringsClient(subscriptionID string) ExpressRouteCrossConnectionPeeringsClient {
	return original.NewExpressRouteCrossConnectionPeeringsClient(subscriptionID)
}
func NewExpressRouteCrossConnectionPeeringsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCrossConnectionPeeringsClient {
	return original.NewExpressRouteCrossConnectionPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCrossConnectionsClient(subscriptionID string) ExpressRouteCrossConnectionsClient {
	return original.NewExpressRouteCrossConnectionsClient(subscriptionID)
}
func NewExpressRouteCrossConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCrossConnectionsClient {
	return original.NewExpressRouteCrossConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteGatewaysClient(subscriptionID string) ExpressRouteGatewaysClient {
	return original.NewExpressRouteGatewaysClient(subscriptionID)
}
func NewExpressRouteGatewaysClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteGatewaysClient {
	return original.NewExpressRouteGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteLinkListResultIterator(page ExpressRouteLinkListResultPage) ExpressRouteLinkListResultIterator {
	return original.NewExpressRouteLinkListResultIterator(page)
}
func NewExpressRouteLinkListResultPage(cur ExpressRouteLinkListResult, getNextPage func(context.Context, ExpressRouteLinkListResult) (ExpressRouteLinkListResult, error)) ExpressRouteLinkListResultPage {
	return original.NewExpressRouteLinkListResultPage(cur, getNextPage)
}
func NewExpressRouteLinksClient(subscriptionID string) ExpressRouteLinksClient {
	return original.NewExpressRouteLinksClient(subscriptionID)
}
func NewExpressRouteLinksClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteLinksClient {
	return original.NewExpressRouteLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRoutePortAuthorizationListResultIterator(page ExpressRoutePortAuthorizationListResultPage) ExpressRoutePortAuthorizationListResultIterator {
	return original.NewExpressRoutePortAuthorizationListResultIterator(page)
}
func NewExpressRoutePortAuthorizationListResultPage(cur ExpressRoutePortAuthorizationListResult, getNextPage func(context.Context, ExpressRoutePortAuthorizationListResult) (ExpressRoutePortAuthorizationListResult, error)) ExpressRoutePortAuthorizationListResultPage {
	return original.NewExpressRoutePortAuthorizationListResultPage(cur, getNextPage)
}
func NewExpressRoutePortAuthorizationsClient(subscriptionID string) ExpressRoutePortAuthorizationsClient {
	return original.NewExpressRoutePortAuthorizationsClient(subscriptionID)
}
func NewExpressRoutePortAuthorizationsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRoutePortAuthorizationsClient {
	return original.NewExpressRoutePortAuthorizationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRoutePortListResultIterator(page ExpressRoutePortListResultPage) ExpressRoutePortListResultIterator {
	return original.NewExpressRoutePortListResultIterator(page)
}
func NewExpressRoutePortListResultPage(cur ExpressRoutePortListResult, getNextPage func(context.Context, ExpressRoutePortListResult) (ExpressRoutePortListResult, error)) ExpressRoutePortListResultPage {
	return original.NewExpressRoutePortListResultPage(cur, getNextPage)
}
func NewExpressRoutePortsClient(subscriptionID string) ExpressRoutePortsClient {
	return original.NewExpressRoutePortsClient(subscriptionID)
}
func NewExpressRoutePortsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRoutePortsClient {
	return original.NewExpressRoutePortsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRoutePortsLocationListResultIterator(page ExpressRoutePortsLocationListResultPage) ExpressRoutePortsLocationListResultIterator {
	return original.NewExpressRoutePortsLocationListResultIterator(page)
}
func NewExpressRoutePortsLocationListResultPage(cur ExpressRoutePortsLocationListResult, getNextPage func(context.Context, ExpressRoutePortsLocationListResult) (ExpressRoutePortsLocationListResult, error)) ExpressRoutePortsLocationListResultPage {
	return original.NewExpressRoutePortsLocationListResultPage(cur, getNextPage)
}
func NewExpressRoutePortsLocationsClient(subscriptionID string) ExpressRoutePortsLocationsClient {
	return original.NewExpressRoutePortsLocationsClient(subscriptionID)
}
func NewExpressRoutePortsLocationsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRoutePortsLocationsClient {
	return original.NewExpressRoutePortsLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteProviderPortsLocationClient(subscriptionID string) ExpressRouteProviderPortsLocationClient {
	return original.NewExpressRouteProviderPortsLocationClient(subscriptionID)
}
func NewExpressRouteProviderPortsLocationClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteProviderPortsLocationClient {
	return original.NewExpressRouteProviderPortsLocationClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteServiceProviderListResultIterator(page ExpressRouteServiceProviderListResultPage) ExpressRouteServiceProviderListResultIterator {
	return original.NewExpressRouteServiceProviderListResultIterator(page)
}
func NewExpressRouteServiceProviderListResultPage(cur ExpressRouteServiceProviderListResult, getNextPage func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)) ExpressRouteServiceProviderListResultPage {
	return original.NewExpressRouteServiceProviderListResultPage(cur, getNextPage)
}
func NewExpressRouteServiceProvidersClient(subscriptionID string) ExpressRouteServiceProvidersClient {
	return original.NewExpressRouteServiceProvidersClient(subscriptionID)
}
func NewExpressRouteServiceProvidersClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteServiceProvidersClient {
	return original.NewExpressRouteServiceProvidersClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallPoliciesClient(subscriptionID string) FirewallPoliciesClient {
	return original.NewFirewallPoliciesClient(subscriptionID)
}
func NewFirewallPoliciesClientWithBaseURI(baseURI string, subscriptionID string) FirewallPoliciesClient {
	return original.NewFirewallPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallPolicyIdpsSignaturesClient(subscriptionID string) FirewallPolicyIdpsSignaturesClient {
	return original.NewFirewallPolicyIdpsSignaturesClient(subscriptionID)
}
func NewFirewallPolicyIdpsSignaturesClientWithBaseURI(baseURI string, subscriptionID string) FirewallPolicyIdpsSignaturesClient {
	return original.NewFirewallPolicyIdpsSignaturesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallPolicyIdpsSignaturesFilterValuesClient(subscriptionID string) FirewallPolicyIdpsSignaturesFilterValuesClient {
	return original.NewFirewallPolicyIdpsSignaturesFilterValuesClient(subscriptionID)
}
func NewFirewallPolicyIdpsSignaturesFilterValuesClientWithBaseURI(baseURI string, subscriptionID string) FirewallPolicyIdpsSignaturesFilterValuesClient {
	return original.NewFirewallPolicyIdpsSignaturesFilterValuesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallPolicyIdpsSignaturesOverridesClient(subscriptionID string) FirewallPolicyIdpsSignaturesOverridesClient {
	return original.NewFirewallPolicyIdpsSignaturesOverridesClient(subscriptionID)
}
func NewFirewallPolicyIdpsSignaturesOverridesClientWithBaseURI(baseURI string, subscriptionID string) FirewallPolicyIdpsSignaturesOverridesClient {
	return original.NewFirewallPolicyIdpsSignaturesOverridesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallPolicyListResultIterator(page FirewallPolicyListResultPage) FirewallPolicyListResultIterator {
	return original.NewFirewallPolicyListResultIterator(page)
}
func NewFirewallPolicyListResultPage(cur FirewallPolicyListResult, getNextPage func(context.Context, FirewallPolicyListResult) (FirewallPolicyListResult, error)) FirewallPolicyListResultPage {
	return original.NewFirewallPolicyListResultPage(cur, getNextPage)
}
func NewFirewallPolicyRuleCollectionGroupListResultIterator(page FirewallPolicyRuleCollectionGroupListResultPage) FirewallPolicyRuleCollectionGroupListResultIterator {
	return original.NewFirewallPolicyRuleCollectionGroupListResultIterator(page)
}
func NewFirewallPolicyRuleCollectionGroupListResultPage(cur FirewallPolicyRuleCollectionGroupListResult, getNextPage func(context.Context, FirewallPolicyRuleCollectionGroupListResult) (FirewallPolicyRuleCollectionGroupListResult, error)) FirewallPolicyRuleCollectionGroupListResultPage {
	return original.NewFirewallPolicyRuleCollectionGroupListResultPage(cur, getNextPage)
}
func NewFirewallPolicyRuleCollectionGroupsClient(subscriptionID string) FirewallPolicyRuleCollectionGroupsClient {
	return original.NewFirewallPolicyRuleCollectionGroupsClient(subscriptionID)
}
func NewFirewallPolicyRuleCollectionGroupsClientWithBaseURI(baseURI string, subscriptionID string) FirewallPolicyRuleCollectionGroupsClient {
	return original.NewFirewallPolicyRuleCollectionGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewFlowLogListResultIterator(page FlowLogListResultPage) FlowLogListResultIterator {
	return original.NewFlowLogListResultIterator(page)
}
func NewFlowLogListResultPage(cur FlowLogListResult, getNextPage func(context.Context, FlowLogListResult) (FlowLogListResult, error)) FlowLogListResultPage {
	return original.NewFlowLogListResultPage(cur, getNextPage)
}
func NewFlowLogsClient(subscriptionID string) FlowLogsClient {
	return original.NewFlowLogsClient(subscriptionID)
}
func NewFlowLogsClientWithBaseURI(baseURI string, subscriptionID string) FlowLogsClient {
	return original.NewFlowLogsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGroupListResultIterator(page GroupListResultPage) GroupListResultIterator {
	return original.NewGroupListResultIterator(page)
}
func NewGroupListResultPage(cur GroupListResult, getNextPage func(context.Context, GroupListResult) (GroupListResult, error)) GroupListResultPage {
	return original.NewGroupListResultPage(cur, getNextPage)
}
func NewGroupsClient(subscriptionID string) GroupsClient {
	return original.NewGroupsClient(subscriptionID)
}
func NewGroupsClientWithBaseURI(baseURI string, subscriptionID string) GroupsClient {
	return original.NewGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewHubRouteTablesClient(subscriptionID string) HubRouteTablesClient {
	return original.NewHubRouteTablesClient(subscriptionID)
}
func NewHubRouteTablesClientWithBaseURI(baseURI string, subscriptionID string) HubRouteTablesClient {
	return original.NewHubRouteTablesClientWithBaseURI(baseURI, subscriptionID)
}
func NewHubVirtualNetworkConnectionsClient(subscriptionID string) HubVirtualNetworkConnectionsClient {
	return original.NewHubVirtualNetworkConnectionsClient(subscriptionID)
}
func NewHubVirtualNetworkConnectionsClientWithBaseURI(baseURI string, subscriptionID string) HubVirtualNetworkConnectionsClient {
	return original.NewHubVirtualNetworkConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIPAllocationListResultIterator(page IPAllocationListResultPage) IPAllocationListResultIterator {
	return original.NewIPAllocationListResultIterator(page)
}
func NewIPAllocationListResultPage(cur IPAllocationListResult, getNextPage func(context.Context, IPAllocationListResult) (IPAllocationListResult, error)) IPAllocationListResultPage {
	return original.NewIPAllocationListResultPage(cur, getNextPage)
}
func NewIPAllocationsClient(subscriptionID string) IPAllocationsClient {
	return original.NewIPAllocationsClient(subscriptionID)
}
func NewIPAllocationsClientWithBaseURI(baseURI string, subscriptionID string) IPAllocationsClient {
	return original.NewIPAllocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIPGroupListResultIterator(page IPGroupListResultPage) IPGroupListResultIterator {
	return original.NewIPGroupListResultIterator(page)
}
func NewIPGroupListResultPage(cur IPGroupListResult, getNextPage func(context.Context, IPGroupListResult) (IPGroupListResult, error)) IPGroupListResultPage {
	return original.NewIPGroupListResultPage(cur, getNextPage)
}
func NewIPGroupsClient(subscriptionID string) IPGroupsClient {
	return original.NewIPGroupsClient(subscriptionID)
}
func NewIPGroupsClientWithBaseURI(baseURI string, subscriptionID string) IPGroupsClient {
	return original.NewIPGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewInboundNatRuleListResultIterator(page InboundNatRuleListResultPage) InboundNatRuleListResultIterator {
	return original.NewInboundNatRuleListResultIterator(page)
}
func NewInboundNatRuleListResultPage(cur InboundNatRuleListResult, getNextPage func(context.Context, InboundNatRuleListResult) (InboundNatRuleListResult, error)) InboundNatRuleListResultPage {
	return original.NewInboundNatRuleListResultPage(cur, getNextPage)
}
func NewInboundNatRulesClient(subscriptionID string) InboundNatRulesClient {
	return original.NewInboundNatRulesClient(subscriptionID)
}
func NewInboundNatRulesClientWithBaseURI(baseURI string, subscriptionID string) InboundNatRulesClient {
	return original.NewInboundNatRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewInboundSecurityRuleClient(subscriptionID string) InboundSecurityRuleClient {
	return original.NewInboundSecurityRuleClient(subscriptionID)
}
func NewInboundSecurityRuleClientWithBaseURI(baseURI string, subscriptionID string) InboundSecurityRuleClient {
	return original.NewInboundSecurityRuleClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceIPConfigurationListResultIterator(page InterfaceIPConfigurationListResultPage) InterfaceIPConfigurationListResultIterator {
	return original.NewInterfaceIPConfigurationListResultIterator(page)
}
func NewInterfaceIPConfigurationListResultPage(cur InterfaceIPConfigurationListResult, getNextPage func(context.Context, InterfaceIPConfigurationListResult) (InterfaceIPConfigurationListResult, error)) InterfaceIPConfigurationListResultPage {
	return original.NewInterfaceIPConfigurationListResultPage(cur, getNextPage)
}
func NewInterfaceIPConfigurationsClient(subscriptionID string) InterfaceIPConfigurationsClient {
	return original.NewInterfaceIPConfigurationsClient(subscriptionID)
}
func NewInterfaceIPConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) InterfaceIPConfigurationsClient {
	return original.NewInterfaceIPConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceListResultIterator(page InterfaceListResultPage) InterfaceListResultIterator {
	return original.NewInterfaceListResultIterator(page)
}
func NewInterfaceListResultPage(cur InterfaceListResult, getNextPage func(context.Context, InterfaceListResult) (InterfaceListResult, error)) InterfaceListResultPage {
	return original.NewInterfaceListResultPage(cur, getNextPage)
}
func NewInterfaceLoadBalancerListResultIterator(page InterfaceLoadBalancerListResultPage) InterfaceLoadBalancerListResultIterator {
	return original.NewInterfaceLoadBalancerListResultIterator(page)
}
func NewInterfaceLoadBalancerListResultPage(cur InterfaceLoadBalancerListResult, getNextPage func(context.Context, InterfaceLoadBalancerListResult) (InterfaceLoadBalancerListResult, error)) InterfaceLoadBalancerListResultPage {
	return original.NewInterfaceLoadBalancerListResultPage(cur, getNextPage)
}
func NewInterfaceLoadBalancersClient(subscriptionID string) InterfaceLoadBalancersClient {
	return original.NewInterfaceLoadBalancersClient(subscriptionID)
}
func NewInterfaceLoadBalancersClientWithBaseURI(baseURI string, subscriptionID string) InterfaceLoadBalancersClient {
	return original.NewInterfaceLoadBalancersClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceTapConfigurationListResultIterator(page InterfaceTapConfigurationListResultPage) InterfaceTapConfigurationListResultIterator {
	return original.NewInterfaceTapConfigurationListResultIterator(page)
}
func NewInterfaceTapConfigurationListResultPage(cur InterfaceTapConfigurationListResult, getNextPage func(context.Context, InterfaceTapConfigurationListResult) (InterfaceTapConfigurationListResult, error)) InterfaceTapConfigurationListResultPage {
	return original.NewInterfaceTapConfigurationListResultPage(cur, getNextPage)
}
func NewInterfaceTapConfigurationsClient(subscriptionID string) InterfaceTapConfigurationsClient {
	return original.NewInterfaceTapConfigurationsClient(subscriptionID)
}
func NewInterfaceTapConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) InterfaceTapConfigurationsClient {
	return original.NewInterfaceTapConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfacesClient(subscriptionID string) InterfacesClient {
	return original.NewInterfacesClient(subscriptionID)
}
func NewInterfacesClientWithBaseURI(baseURI string, subscriptionID string) InterfacesClient {
	return original.NewInterfacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewListHubRouteTablesResultIterator(page ListHubRouteTablesResultPage) ListHubRouteTablesResultIterator {
	return original.NewListHubRouteTablesResultIterator(page)
}
func NewListHubRouteTablesResultPage(cur ListHubRouteTablesResult, getNextPage func(context.Context, ListHubRouteTablesResult) (ListHubRouteTablesResult, error)) ListHubRouteTablesResultPage {
	return original.NewListHubRouteTablesResultPage(cur, getNextPage)
}
func NewListHubVirtualNetworkConnectionsResultIterator(page ListHubVirtualNetworkConnectionsResultPage) ListHubVirtualNetworkConnectionsResultIterator {
	return original.NewListHubVirtualNetworkConnectionsResultIterator(page)
}
func NewListHubVirtualNetworkConnectionsResultPage(cur ListHubVirtualNetworkConnectionsResult, getNextPage func(context.Context, ListHubVirtualNetworkConnectionsResult) (ListHubVirtualNetworkConnectionsResult, error)) ListHubVirtualNetworkConnectionsResultPage {
	return original.NewListHubVirtualNetworkConnectionsResultPage(cur, getNextPage)
}
func NewListP2SVpnGatewaysResultIterator(page ListP2SVpnGatewaysResultPage) ListP2SVpnGatewaysResultIterator {
	return original.NewListP2SVpnGatewaysResultIterator(page)
}
func NewListP2SVpnGatewaysResultPage(cur ListP2SVpnGatewaysResult, getNextPage func(context.Context, ListP2SVpnGatewaysResult) (ListP2SVpnGatewaysResult, error)) ListP2SVpnGatewaysResultPage {
	return original.NewListP2SVpnGatewaysResultPage(cur, getNextPage)
}
func NewListRouteMapsResultIterator(page ListRouteMapsResultPage) ListRouteMapsResultIterator {
	return original.NewListRouteMapsResultIterator(page)
}
func NewListRouteMapsResultPage(cur ListRouteMapsResult, getNextPage func(context.Context, ListRouteMapsResult) (ListRouteMapsResult, error)) ListRouteMapsResultPage {
	return original.NewListRouteMapsResultPage(cur, getNextPage)
}
func NewListRoutingIntentResultIterator(page ListRoutingIntentResultPage) ListRoutingIntentResultIterator {
	return original.NewListRoutingIntentResultIterator(page)
}
func NewListRoutingIntentResultPage(cur ListRoutingIntentResult, getNextPage func(context.Context, ListRoutingIntentResult) (ListRoutingIntentResult, error)) ListRoutingIntentResultPage {
	return original.NewListRoutingIntentResultPage(cur, getNextPage)
}
func NewListVirtualHubBgpConnectionResultsIterator(page ListVirtualHubBgpConnectionResultsPage) ListVirtualHubBgpConnectionResultsIterator {
	return original.NewListVirtualHubBgpConnectionResultsIterator(page)
}
func NewListVirtualHubBgpConnectionResultsPage(cur ListVirtualHubBgpConnectionResults, getNextPage func(context.Context, ListVirtualHubBgpConnectionResults) (ListVirtualHubBgpConnectionResults, error)) ListVirtualHubBgpConnectionResultsPage {
	return original.NewListVirtualHubBgpConnectionResultsPage(cur, getNextPage)
}
func NewListVirtualHubIPConfigurationResultsIterator(page ListVirtualHubIPConfigurationResultsPage) ListVirtualHubIPConfigurationResultsIterator {
	return original.NewListVirtualHubIPConfigurationResultsIterator(page)
}
func NewListVirtualHubIPConfigurationResultsPage(cur ListVirtualHubIPConfigurationResults, getNextPage func(context.Context, ListVirtualHubIPConfigurationResults) (ListVirtualHubIPConfigurationResults, error)) ListVirtualHubIPConfigurationResultsPage {
	return original.NewListVirtualHubIPConfigurationResultsPage(cur, getNextPage)
}
func NewListVirtualHubRouteTableV2sResultIterator(page ListVirtualHubRouteTableV2sResultPage) ListVirtualHubRouteTableV2sResultIterator {
	return original.NewListVirtualHubRouteTableV2sResultIterator(page)
}
func NewListVirtualHubRouteTableV2sResultPage(cur ListVirtualHubRouteTableV2sResult, getNextPage func(context.Context, ListVirtualHubRouteTableV2sResult) (ListVirtualHubRouteTableV2sResult, error)) ListVirtualHubRouteTableV2sResultPage {
	return original.NewListVirtualHubRouteTableV2sResultPage(cur, getNextPage)
}
func NewListVirtualHubsResultIterator(page ListVirtualHubsResultPage) ListVirtualHubsResultIterator {
	return original.NewListVirtualHubsResultIterator(page)
}
func NewListVirtualHubsResultPage(cur ListVirtualHubsResult, getNextPage func(context.Context, ListVirtualHubsResult) (ListVirtualHubsResult, error)) ListVirtualHubsResultPage {
	return original.NewListVirtualHubsResultPage(cur, getNextPage)
}
func NewListVirtualNetworkGatewayNatRulesResultIterator(page ListVirtualNetworkGatewayNatRulesResultPage) ListVirtualNetworkGatewayNatRulesResultIterator {
	return original.NewListVirtualNetworkGatewayNatRulesResultIterator(page)
}
func NewListVirtualNetworkGatewayNatRulesResultPage(cur ListVirtualNetworkGatewayNatRulesResult, getNextPage func(context.Context, ListVirtualNetworkGatewayNatRulesResult) (ListVirtualNetworkGatewayNatRulesResult, error)) ListVirtualNetworkGatewayNatRulesResultPage {
	return original.NewListVirtualNetworkGatewayNatRulesResultPage(cur, getNextPage)
}
func NewListVirtualWANsResultIterator(page ListVirtualWANsResultPage) ListVirtualWANsResultIterator {
	return original.NewListVirtualWANsResultIterator(page)
}
func NewListVirtualWANsResultPage(cur ListVirtualWANsResult, getNextPage func(context.Context, ListVirtualWANsResult) (ListVirtualWANsResult, error)) ListVirtualWANsResultPage {
	return original.NewListVirtualWANsResultPage(cur, getNextPage)
}
func NewListVpnConnectionsResultIterator(page ListVpnConnectionsResultPage) ListVpnConnectionsResultIterator {
	return original.NewListVpnConnectionsResultIterator(page)
}
func NewListVpnConnectionsResultPage(cur ListVpnConnectionsResult, getNextPage func(context.Context, ListVpnConnectionsResult) (ListVpnConnectionsResult, error)) ListVpnConnectionsResultPage {
	return original.NewListVpnConnectionsResultPage(cur, getNextPage)
}
func NewListVpnGatewayNatRulesResultIterator(page ListVpnGatewayNatRulesResultPage) ListVpnGatewayNatRulesResultIterator {
	return original.NewListVpnGatewayNatRulesResultIterator(page)
}
func NewListVpnGatewayNatRulesResultPage(cur ListVpnGatewayNatRulesResult, getNextPage func(context.Context, ListVpnGatewayNatRulesResult) (ListVpnGatewayNatRulesResult, error)) ListVpnGatewayNatRulesResultPage {
	return original.NewListVpnGatewayNatRulesResultPage(cur, getNextPage)
}
func NewListVpnGatewaysResultIterator(page ListVpnGatewaysResultPage) ListVpnGatewaysResultIterator {
	return original.NewListVpnGatewaysResultIterator(page)
}
func NewListVpnGatewaysResultPage(cur ListVpnGatewaysResult, getNextPage func(context.Context, ListVpnGatewaysResult) (ListVpnGatewaysResult, error)) ListVpnGatewaysResultPage {
	return original.NewListVpnGatewaysResultPage(cur, getNextPage)
}
func NewListVpnServerConfigurationPolicyGroupsResultIterator(page ListVpnServerConfigurationPolicyGroupsResultPage) ListVpnServerConfigurationPolicyGroupsResultIterator {
	return original.NewListVpnServerConfigurationPolicyGroupsResultIterator(page)
}
func NewListVpnServerConfigurationPolicyGroupsResultPage(cur ListVpnServerConfigurationPolicyGroupsResult, getNextPage func(context.Context, ListVpnServerConfigurationPolicyGroupsResult) (ListVpnServerConfigurationPolicyGroupsResult, error)) ListVpnServerConfigurationPolicyGroupsResultPage {
	return original.NewListVpnServerConfigurationPolicyGroupsResultPage(cur, getNextPage)
}
func NewListVpnServerConfigurationsResultIterator(page ListVpnServerConfigurationsResultPage) ListVpnServerConfigurationsResultIterator {
	return original.NewListVpnServerConfigurationsResultIterator(page)
}
func NewListVpnServerConfigurationsResultPage(cur ListVpnServerConfigurationsResult, getNextPage func(context.Context, ListVpnServerConfigurationsResult) (ListVpnServerConfigurationsResult, error)) ListVpnServerConfigurationsResultPage {
	return original.NewListVpnServerConfigurationsResultPage(cur, getNextPage)
}
func NewListVpnSiteLinkConnectionsResultIterator(page ListVpnSiteLinkConnectionsResultPage) ListVpnSiteLinkConnectionsResultIterator {
	return original.NewListVpnSiteLinkConnectionsResultIterator(page)
}
func NewListVpnSiteLinkConnectionsResultPage(cur ListVpnSiteLinkConnectionsResult, getNextPage func(context.Context, ListVpnSiteLinkConnectionsResult) (ListVpnSiteLinkConnectionsResult, error)) ListVpnSiteLinkConnectionsResultPage {
	return original.NewListVpnSiteLinkConnectionsResultPage(cur, getNextPage)
}
func NewListVpnSiteLinksResultIterator(page ListVpnSiteLinksResultPage) ListVpnSiteLinksResultIterator {
	return original.NewListVpnSiteLinksResultIterator(page)
}
func NewListVpnSiteLinksResultPage(cur ListVpnSiteLinksResult, getNextPage func(context.Context, ListVpnSiteLinksResult) (ListVpnSiteLinksResult, error)) ListVpnSiteLinksResultPage {
	return original.NewListVpnSiteLinksResultPage(cur, getNextPage)
}
func NewListVpnSitesResultIterator(page ListVpnSitesResultPage) ListVpnSitesResultIterator {
	return original.NewListVpnSitesResultIterator(page)
}
func NewListVpnSitesResultPage(cur ListVpnSitesResult, getNextPage func(context.Context, ListVpnSitesResult) (ListVpnSitesResult, error)) ListVpnSitesResultPage {
	return original.NewListVpnSitesResultPage(cur, getNextPage)
}
func NewLoadBalancerBackendAddressPoolListResultIterator(page LoadBalancerBackendAddressPoolListResultPage) LoadBalancerBackendAddressPoolListResultIterator {
	return original.NewLoadBalancerBackendAddressPoolListResultIterator(page)
}
func NewLoadBalancerBackendAddressPoolListResultPage(cur LoadBalancerBackendAddressPoolListResult, getNextPage func(context.Context, LoadBalancerBackendAddressPoolListResult) (LoadBalancerBackendAddressPoolListResult, error)) LoadBalancerBackendAddressPoolListResultPage {
	return original.NewLoadBalancerBackendAddressPoolListResultPage(cur, getNextPage)
}
func NewLoadBalancerBackendAddressPoolsClient(subscriptionID string) LoadBalancerBackendAddressPoolsClient {
	return original.NewLoadBalancerBackendAddressPoolsClient(subscriptionID)
}
func NewLoadBalancerBackendAddressPoolsClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerBackendAddressPoolsClient {
	return original.NewLoadBalancerBackendAddressPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerFrontendIPConfigurationListResultIterator(page LoadBalancerFrontendIPConfigurationListResultPage) LoadBalancerFrontendIPConfigurationListResultIterator {
	return original.NewLoadBalancerFrontendIPConfigurationListResultIterator(page)
}
func NewLoadBalancerFrontendIPConfigurationListResultPage(cur LoadBalancerFrontendIPConfigurationListResult, getNextPage func(context.Context, LoadBalancerFrontendIPConfigurationListResult) (LoadBalancerFrontendIPConfigurationListResult, error)) LoadBalancerFrontendIPConfigurationListResultPage {
	return original.NewLoadBalancerFrontendIPConfigurationListResultPage(cur, getNextPage)
}
func NewLoadBalancerFrontendIPConfigurationsClient(subscriptionID string) LoadBalancerFrontendIPConfigurationsClient {
	return original.NewLoadBalancerFrontendIPConfigurationsClient(subscriptionID)
}
func NewLoadBalancerFrontendIPConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerFrontendIPConfigurationsClient {
	return original.NewLoadBalancerFrontendIPConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerListResultIterator(page LoadBalancerListResultPage) LoadBalancerListResultIterator {
	return original.NewLoadBalancerListResultIterator(page)
}
func NewLoadBalancerListResultPage(cur LoadBalancerListResult, getNextPage func(context.Context, LoadBalancerListResult) (LoadBalancerListResult, error)) LoadBalancerListResultPage {
	return original.NewLoadBalancerListResultPage(cur, getNextPage)
}
func NewLoadBalancerLoadBalancingRuleListResultIterator(page LoadBalancerLoadBalancingRuleListResultPage) LoadBalancerLoadBalancingRuleListResultIterator {
	return original.NewLoadBalancerLoadBalancingRuleListResultIterator(page)
}
func NewLoadBalancerLoadBalancingRuleListResultPage(cur LoadBalancerLoadBalancingRuleListResult, getNextPage func(context.Context, LoadBalancerLoadBalancingRuleListResult) (LoadBalancerLoadBalancingRuleListResult, error)) LoadBalancerLoadBalancingRuleListResultPage {
	return original.NewLoadBalancerLoadBalancingRuleListResultPage(cur, getNextPage)
}
func NewLoadBalancerLoadBalancingRulesClient(subscriptionID string) LoadBalancerLoadBalancingRulesClient {
	return original.NewLoadBalancerLoadBalancingRulesClient(subscriptionID)
}
func NewLoadBalancerLoadBalancingRulesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerLoadBalancingRulesClient {
	return original.NewLoadBalancerLoadBalancingRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerNetworkInterfacesClient(subscriptionID string) LoadBalancerNetworkInterfacesClient {
	return original.NewLoadBalancerNetworkInterfacesClient(subscriptionID)
}
func NewLoadBalancerNetworkInterfacesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerNetworkInterfacesClient {
	return original.NewLoadBalancerNetworkInterfacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerOutboundRuleListResultIterator(page LoadBalancerOutboundRuleListResultPage) LoadBalancerOutboundRuleListResultIterator {
	return original.NewLoadBalancerOutboundRuleListResultIterator(page)
}
func NewLoadBalancerOutboundRuleListResultPage(cur LoadBalancerOutboundRuleListResult, getNextPage func(context.Context, LoadBalancerOutboundRuleListResult) (LoadBalancerOutboundRuleListResult, error)) LoadBalancerOutboundRuleListResultPage {
	return original.NewLoadBalancerOutboundRuleListResultPage(cur, getNextPage)
}
func NewLoadBalancerOutboundRulesClient(subscriptionID string) LoadBalancerOutboundRulesClient {
	return original.NewLoadBalancerOutboundRulesClient(subscriptionID)
}
func NewLoadBalancerOutboundRulesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerOutboundRulesClient {
	return original.NewLoadBalancerOutboundRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerProbeListResultIterator(page LoadBalancerProbeListResultPage) LoadBalancerProbeListResultIterator {
	return original.NewLoadBalancerProbeListResultIterator(page)
}
func NewLoadBalancerProbeListResultPage(cur LoadBalancerProbeListResult, getNextPage func(context.Context, LoadBalancerProbeListResult) (LoadBalancerProbeListResult, error)) LoadBalancerProbeListResultPage {
	return original.NewLoadBalancerProbeListResultPage(cur, getNextPage)
}
func NewLoadBalancerProbesClient(subscriptionID string) LoadBalancerProbesClient {
	return original.NewLoadBalancerProbesClient(subscriptionID)
}
func NewLoadBalancerProbesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerProbesClient {
	return original.NewLoadBalancerProbesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancersClient(subscriptionID string) LoadBalancersClient {
	return original.NewLoadBalancersClient(subscriptionID)
}
func NewLoadBalancersClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancersClient {
	return original.NewLoadBalancersClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocalNetworkGatewayListResultIterator(page LocalNetworkGatewayListResultPage) LocalNetworkGatewayListResultIterator {
	return original.NewLocalNetworkGatewayListResultIterator(page)
}
func NewLocalNetworkGatewayListResultPage(cur LocalNetworkGatewayListResult, getNextPage func(context.Context, LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)) LocalNetworkGatewayListResultPage {
	return original.NewLocalNetworkGatewayListResultPage(cur, getNextPage)
}
func NewLocalNetworkGatewaysClient(subscriptionID string) LocalNetworkGatewaysClient {
	return original.NewLocalNetworkGatewaysClient(subscriptionID)
}
func NewLocalNetworkGatewaysClientWithBaseURI(baseURI string, subscriptionID string) LocalNetworkGatewaysClient {
	return original.NewLocalNetworkGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagementGroupNetworkManagerConnectionsClient(subscriptionID string) ManagementGroupNetworkManagerConnectionsClient {
	return original.NewManagementGroupNetworkManagerConnectionsClient(subscriptionID)
}
func NewManagementGroupNetworkManagerConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ManagementGroupNetworkManagerConnectionsClient {
	return original.NewManagementGroupNetworkManagerConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagerCommitsClient(subscriptionID string) ManagerCommitsClient {
	return original.NewManagerCommitsClient(subscriptionID)
}
func NewManagerCommitsClientWithBaseURI(baseURI string, subscriptionID string) ManagerCommitsClient {
	return original.NewManagerCommitsClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagerConnectionListResultIterator(page ManagerConnectionListResultPage) ManagerConnectionListResultIterator {
	return original.NewManagerConnectionListResultIterator(page)
}
func NewManagerConnectionListResultPage(cur ManagerConnectionListResult, getNextPage func(context.Context, ManagerConnectionListResult) (ManagerConnectionListResult, error)) ManagerConnectionListResultPage {
	return original.NewManagerConnectionListResultPage(cur, getNextPage)
}
func NewManagerDeploymentStatusClient(subscriptionID string) ManagerDeploymentStatusClient {
	return original.NewManagerDeploymentStatusClient(subscriptionID)
}
func NewManagerDeploymentStatusClientWithBaseURI(baseURI string, subscriptionID string) ManagerDeploymentStatusClient {
	return original.NewManagerDeploymentStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagerListResultIterator(page ManagerListResultPage) ManagerListResultIterator {
	return original.NewManagerListResultIterator(page)
}
func NewManagerListResultPage(cur ManagerListResult, getNextPage func(context.Context, ManagerListResult) (ManagerListResult, error)) ManagerListResultPage {
	return original.NewManagerListResultPage(cur, getNextPage)
}
func NewManagersClient(subscriptionID string) ManagersClient {
	return original.NewManagersClient(subscriptionID)
}
func NewManagersClientWithBaseURI(baseURI string, subscriptionID string) ManagersClient {
	return original.NewManagersClientWithBaseURI(baseURI, subscriptionID)
}
func NewNatGatewayListResultIterator(page NatGatewayListResultPage) NatGatewayListResultIterator {
	return original.NewNatGatewayListResultIterator(page)
}
func NewNatGatewayListResultPage(cur NatGatewayListResult, getNextPage func(context.Context, NatGatewayListResult) (NatGatewayListResult, error)) NatGatewayListResultPage {
	return original.NewNatGatewayListResultPage(cur, getNextPage)
}
func NewNatGatewaysClient(subscriptionID string) NatGatewaysClient {
	return original.NewNatGatewaysClient(subscriptionID)
}
func NewNatGatewaysClientWithBaseURI(baseURI string, subscriptionID string) NatGatewaysClient {
	return original.NewNatGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewNatRulesClient(subscriptionID string) NatRulesClient {
	return original.NewNatRulesClient(subscriptionID)
}
func NewNatRulesClientWithBaseURI(baseURI string, subscriptionID string) NatRulesClient {
	return original.NewNatRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewP2sVpnGatewaysClient(subscriptionID string) P2sVpnGatewaysClient {
	return original.NewP2sVpnGatewaysClient(subscriptionID)
}
func NewP2sVpnGatewaysClientWithBaseURI(baseURI string, subscriptionID string) P2sVpnGatewaysClient {
	return original.NewP2sVpnGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewPacketCapturesClient(subscriptionID string) PacketCapturesClient {
	return original.NewPacketCapturesClient(subscriptionID)
}
func NewPacketCapturesClientWithBaseURI(baseURI string, subscriptionID string) PacketCapturesClient {
	return original.NewPacketCapturesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPeerExpressRouteCircuitConnectionListResultIterator(page PeerExpressRouteCircuitConnectionListResultPage) PeerExpressRouteCircuitConnectionListResultIterator {
	return original.NewPeerExpressRouteCircuitConnectionListResultIterator(page)
}
func NewPeerExpressRouteCircuitConnectionListResultPage(cur PeerExpressRouteCircuitConnectionListResult, getNextPage func(context.Context, PeerExpressRouteCircuitConnectionListResult) (PeerExpressRouteCircuitConnectionListResult, error)) PeerExpressRouteCircuitConnectionListResultPage {
	return original.NewPeerExpressRouteCircuitConnectionListResultPage(cur, getNextPage)
}
func NewPeerExpressRouteCircuitConnectionsClient(subscriptionID string) PeerExpressRouteCircuitConnectionsClient {
	return original.NewPeerExpressRouteCircuitConnectionsClient(subscriptionID)
}
func NewPeerExpressRouteCircuitConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PeerExpressRouteCircuitConnectionsClient {
	return original.NewPeerExpressRouteCircuitConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateDNSZoneGroupListResultIterator(page PrivateDNSZoneGroupListResultPage) PrivateDNSZoneGroupListResultIterator {
	return original.NewPrivateDNSZoneGroupListResultIterator(page)
}
func NewPrivateDNSZoneGroupListResultPage(cur PrivateDNSZoneGroupListResult, getNextPage func(context.Context, PrivateDNSZoneGroupListResult) (PrivateDNSZoneGroupListResult, error)) PrivateDNSZoneGroupListResultPage {
	return original.NewPrivateDNSZoneGroupListResultPage(cur, getNextPage)
}
func NewPrivateDNSZoneGroupsClient(subscriptionID string) PrivateDNSZoneGroupsClient {
	return original.NewPrivateDNSZoneGroupsClient(subscriptionID)
}
func NewPrivateDNSZoneGroupsClientWithBaseURI(baseURI string, subscriptionID string) PrivateDNSZoneGroupsClient {
	return original.NewPrivateDNSZoneGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return original.NewPrivateEndpointConnectionListResultIterator(page)
}
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return original.NewPrivateEndpointConnectionListResultPage(cur, getNextPage)
}
func NewPrivateEndpointListResultIterator(page PrivateEndpointListResultPage) PrivateEndpointListResultIterator {
	return original.NewPrivateEndpointListResultIterator(page)
}
func NewPrivateEndpointListResultPage(cur PrivateEndpointListResult, getNextPage func(context.Context, PrivateEndpointListResult) (PrivateEndpointListResult, error)) PrivateEndpointListResultPage {
	return original.NewPrivateEndpointListResultPage(cur, getNextPage)
}
func NewPrivateEndpointsClient(subscriptionID string) PrivateEndpointsClient {
	return original.NewPrivateEndpointsClient(subscriptionID)
}
func NewPrivateEndpointsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointsClient {
	return original.NewPrivateEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkServiceListResultIterator(page PrivateLinkServiceListResultPage) PrivateLinkServiceListResultIterator {
	return original.NewPrivateLinkServiceListResultIterator(page)
}
func NewPrivateLinkServiceListResultPage(cur PrivateLinkServiceListResult, getNextPage func(context.Context, PrivateLinkServiceListResult) (PrivateLinkServiceListResult, error)) PrivateLinkServiceListResultPage {
	return original.NewPrivateLinkServiceListResultPage(cur, getNextPage)
}
func NewPrivateLinkServicesClient(subscriptionID string) PrivateLinkServicesClient {
	return original.NewPrivateLinkServicesClient(subscriptionID)
}
func NewPrivateLinkServicesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkServicesClient {
	return original.NewPrivateLinkServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return original.NewProfileListResultIterator(page)
}
func NewProfileListResultPage(cur ProfileListResult, getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return original.NewProfileListResultPage(cur, getNextPage)
}
func NewProfilesClient(subscriptionID string) ProfilesClient {
	return original.NewProfilesClient(subscriptionID)
}
func NewProfilesClientWithBaseURI(baseURI string, subscriptionID string) ProfilesClient {
	return original.NewProfilesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPublicIPAddressListResultIterator(page PublicIPAddressListResultPage) PublicIPAddressListResultIterator {
	return original.NewPublicIPAddressListResultIterator(page)
}
func NewPublicIPAddressListResultPage(cur PublicIPAddressListResult, getNextPage func(context.Context, PublicIPAddressListResult) (PublicIPAddressListResult, error)) PublicIPAddressListResultPage {
	return original.NewPublicIPAddressListResultPage(cur, getNextPage)
}
func NewPublicIPAddressesClient(subscriptionID string) PublicIPAddressesClient {
	return original.NewPublicIPAddressesClient(subscriptionID)
}
func NewPublicIPAddressesClientWithBaseURI(baseURI string, subscriptionID string) PublicIPAddressesClient {
	return original.NewPublicIPAddressesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPublicIPPrefixListResultIterator(page PublicIPPrefixListResultPage) PublicIPPrefixListResultIterator {
	return original.NewPublicIPPrefixListResultIterator(page)
}
func NewPublicIPPrefixListResultPage(cur PublicIPPrefixListResult, getNextPage func(context.Context, PublicIPPrefixListResult) (PublicIPPrefixListResult, error)) PublicIPPrefixListResultPage {
	return original.NewPublicIPPrefixListResultPage(cur, getNextPage)
}
func NewPublicIPPrefixesClient(subscriptionID string) PublicIPPrefixesClient {
	return original.NewPublicIPPrefixesClient(subscriptionID)
}
func NewPublicIPPrefixesClientWithBaseURI(baseURI string, subscriptionID string) PublicIPPrefixesClient {
	return original.NewPublicIPPrefixesClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceNavigationLinksClient(subscriptionID string) ResourceNavigationLinksClient {
	return original.NewResourceNavigationLinksClient(subscriptionID)
}
func NewResourceNavigationLinksClientWithBaseURI(baseURI string, subscriptionID string) ResourceNavigationLinksClient {
	return original.NewResourceNavigationLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteFilterListResultIterator(page RouteFilterListResultPage) RouteFilterListResultIterator {
	return original.NewRouteFilterListResultIterator(page)
}
func NewRouteFilterListResultPage(cur RouteFilterListResult, getNextPage func(context.Context, RouteFilterListResult) (RouteFilterListResult, error)) RouteFilterListResultPage {
	return original.NewRouteFilterListResultPage(cur, getNextPage)
}
func NewRouteFilterRuleListResultIterator(page RouteFilterRuleListResultPage) RouteFilterRuleListResultIterator {
	return original.NewRouteFilterRuleListResultIterator(page)
}
func NewRouteFilterRuleListResultPage(cur RouteFilterRuleListResult, getNextPage func(context.Context, RouteFilterRuleListResult) (RouteFilterRuleListResult, error)) RouteFilterRuleListResultPage {
	return original.NewRouteFilterRuleListResultPage(cur, getNextPage)
}
func NewRouteFilterRulesClient(subscriptionID string) RouteFilterRulesClient {
	return original.NewRouteFilterRulesClient(subscriptionID)
}
func NewRouteFilterRulesClientWithBaseURI(baseURI string, subscriptionID string) RouteFilterRulesClient {
	return original.NewRouteFilterRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteFiltersClient(subscriptionID string) RouteFiltersClient {
	return original.NewRouteFiltersClient(subscriptionID)
}
func NewRouteFiltersClientWithBaseURI(baseURI string, subscriptionID string) RouteFiltersClient {
	return original.NewRouteFiltersClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteListResultIterator(page RouteListResultPage) RouteListResultIterator {
	return original.NewRouteListResultIterator(page)
}
func NewRouteListResultPage(cur RouteListResult, getNextPage func(context.Context, RouteListResult) (RouteListResult, error)) RouteListResultPage {
	return original.NewRouteListResultPage(cur, getNextPage)
}
func NewRouteMapsClient(subscriptionID string) RouteMapsClient {
	return original.NewRouteMapsClient(subscriptionID)
}
func NewRouteMapsClientWithBaseURI(baseURI string, subscriptionID string) RouteMapsClient {
	return original.NewRouteMapsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteTableListResultIterator(page RouteTableListResultPage) RouteTableListResultIterator {
	return original.NewRouteTableListResultIterator(page)
}
func NewRouteTableListResultPage(cur RouteTableListResult, getNextPage func(context.Context, RouteTableListResult) (RouteTableListResult, error)) RouteTableListResultPage {
	return original.NewRouteTableListResultPage(cur, getNextPage)
}
func NewRouteTablesClient(subscriptionID string) RouteTablesClient {
	return original.NewRouteTablesClient(subscriptionID)
}
func NewRouteTablesClientWithBaseURI(baseURI string, subscriptionID string) RouteTablesClient {
	return original.NewRouteTablesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRoutesClient(subscriptionID string) RoutesClient {
	return original.NewRoutesClient(subscriptionID)
}
func NewRoutesClientWithBaseURI(baseURI string, subscriptionID string) RoutesClient {
	return original.NewRoutesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRoutingIntentClient(subscriptionID string) RoutingIntentClient {
	return original.NewRoutingIntentClient(subscriptionID)
}
func NewRoutingIntentClientWithBaseURI(baseURI string, subscriptionID string) RoutingIntentClient {
	return original.NewRoutingIntentClientWithBaseURI(baseURI, subscriptionID)
}
func NewScopeConnectionListResultIterator(page ScopeConnectionListResultPage) ScopeConnectionListResultIterator {
	return original.NewScopeConnectionListResultIterator(page)
}
func NewScopeConnectionListResultPage(cur ScopeConnectionListResult, getNextPage func(context.Context, ScopeConnectionListResult) (ScopeConnectionListResult, error)) ScopeConnectionListResultPage {
	return original.NewScopeConnectionListResultPage(cur, getNextPage)
}
func NewScopeConnectionsClient(subscriptionID string) ScopeConnectionsClient {
	return original.NewScopeConnectionsClient(subscriptionID)
}
func NewScopeConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ScopeConnectionsClient {
	return original.NewScopeConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityAdminConfigurationListResultIterator(page SecurityAdminConfigurationListResultPage) SecurityAdminConfigurationListResultIterator {
	return original.NewSecurityAdminConfigurationListResultIterator(page)
}
func NewSecurityAdminConfigurationListResultPage(cur SecurityAdminConfigurationListResult, getNextPage func(context.Context, SecurityAdminConfigurationListResult) (SecurityAdminConfigurationListResult, error)) SecurityAdminConfigurationListResultPage {
	return original.NewSecurityAdminConfigurationListResultPage(cur, getNextPage)
}
func NewSecurityAdminConfigurationsClient(subscriptionID string) SecurityAdminConfigurationsClient {
	return original.NewSecurityAdminConfigurationsClient(subscriptionID)
}
func NewSecurityAdminConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) SecurityAdminConfigurationsClient {
	return original.NewSecurityAdminConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityGroupListResultIterator(page SecurityGroupListResultPage) SecurityGroupListResultIterator {
	return original.NewSecurityGroupListResultIterator(page)
}
func NewSecurityGroupListResultPage(cur SecurityGroupListResult, getNextPage func(context.Context, SecurityGroupListResult) (SecurityGroupListResult, error)) SecurityGroupListResultPage {
	return original.NewSecurityGroupListResultPage(cur, getNextPage)
}
func NewSecurityGroupsClient(subscriptionID string) SecurityGroupsClient {
	return original.NewSecurityGroupsClient(subscriptionID)
}
func NewSecurityGroupsClientWithBaseURI(baseURI string, subscriptionID string) SecurityGroupsClient {
	return original.NewSecurityGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityPartnerProviderListResultIterator(page SecurityPartnerProviderListResultPage) SecurityPartnerProviderListResultIterator {
	return original.NewSecurityPartnerProviderListResultIterator(page)
}
func NewSecurityPartnerProviderListResultPage(cur SecurityPartnerProviderListResult, getNextPage func(context.Context, SecurityPartnerProviderListResult) (SecurityPartnerProviderListResult, error)) SecurityPartnerProviderListResultPage {
	return original.NewSecurityPartnerProviderListResultPage(cur, getNextPage)
}
func NewSecurityPartnerProvidersClient(subscriptionID string) SecurityPartnerProvidersClient {
	return original.NewSecurityPartnerProvidersClient(subscriptionID)
}
func NewSecurityPartnerProvidersClientWithBaseURI(baseURI string, subscriptionID string) SecurityPartnerProvidersClient {
	return original.NewSecurityPartnerProvidersClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityRuleListResultIterator(page SecurityRuleListResultPage) SecurityRuleListResultIterator {
	return original.NewSecurityRuleListResultIterator(page)
}
func NewSecurityRuleListResultPage(cur SecurityRuleListResult, getNextPage func(context.Context, SecurityRuleListResult) (SecurityRuleListResult, error)) SecurityRuleListResultPage {
	return original.NewSecurityRuleListResultPage(cur, getNextPage)
}
func NewSecurityRulesClient(subscriptionID string) SecurityRulesClient {
	return original.NewSecurityRulesClient(subscriptionID)
}
func NewSecurityRulesClientWithBaseURI(baseURI string, subscriptionID string) SecurityRulesClient {
	return original.NewSecurityRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceAssociationLinksClient(subscriptionID string) ServiceAssociationLinksClient {
	return original.NewServiceAssociationLinksClient(subscriptionID)
}
func NewServiceAssociationLinksClientWithBaseURI(baseURI string, subscriptionID string) ServiceAssociationLinksClient {
	return original.NewServiceAssociationLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceEndpointPoliciesClient(subscriptionID string) ServiceEndpointPoliciesClient {
	return original.NewServiceEndpointPoliciesClient(subscriptionID)
}
func NewServiceEndpointPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ServiceEndpointPoliciesClient {
	return original.NewServiceEndpointPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceEndpointPolicyDefinitionListResultIterator(page ServiceEndpointPolicyDefinitionListResultPage) ServiceEndpointPolicyDefinitionListResultIterator {
	return original.NewServiceEndpointPolicyDefinitionListResultIterator(page)
}
func NewServiceEndpointPolicyDefinitionListResultPage(cur ServiceEndpointPolicyDefinitionListResult, getNextPage func(context.Context, ServiceEndpointPolicyDefinitionListResult) (ServiceEndpointPolicyDefinitionListResult, error)) ServiceEndpointPolicyDefinitionListResultPage {
	return original.NewServiceEndpointPolicyDefinitionListResultPage(cur, getNextPage)
}
func NewServiceEndpointPolicyDefinitionsClient(subscriptionID string) ServiceEndpointPolicyDefinitionsClient {
	return original.NewServiceEndpointPolicyDefinitionsClient(subscriptionID)
}
func NewServiceEndpointPolicyDefinitionsClientWithBaseURI(baseURI string, subscriptionID string) ServiceEndpointPolicyDefinitionsClient {
	return original.NewServiceEndpointPolicyDefinitionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceEndpointPolicyListResultIterator(page ServiceEndpointPolicyListResultPage) ServiceEndpointPolicyListResultIterator {
	return original.NewServiceEndpointPolicyListResultIterator(page)
}
func NewServiceEndpointPolicyListResultPage(cur ServiceEndpointPolicyListResult, getNextPage func(context.Context, ServiceEndpointPolicyListResult) (ServiceEndpointPolicyListResult, error)) ServiceEndpointPolicyListResultPage {
	return original.NewServiceEndpointPolicyListResultPage(cur, getNextPage)
}
func NewServiceTagInformationClient(subscriptionID string) ServiceTagInformationClient {
	return original.NewServiceTagInformationClient(subscriptionID)
}
func NewServiceTagInformationClientWithBaseURI(baseURI string, subscriptionID string) ServiceTagInformationClient {
	return original.NewServiceTagInformationClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceTagInformationListResultIterator(page ServiceTagInformationListResultPage) ServiceTagInformationListResultIterator {
	return original.NewServiceTagInformationListResultIterator(page)
}
func NewServiceTagInformationListResultPage(cur ServiceTagInformationListResult, getNextPage func(context.Context, ServiceTagInformationListResult) (ServiceTagInformationListResult, error)) ServiceTagInformationListResultPage {
	return original.NewServiceTagInformationListResultPage(cur, getNextPage)
}
func NewServiceTagsClient(subscriptionID string) ServiceTagsClient {
	return original.NewServiceTagsClient(subscriptionID)
}
func NewServiceTagsClientWithBaseURI(baseURI string, subscriptionID string) ServiceTagsClient {
	return original.NewServiceTagsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStaticMemberListResultIterator(page StaticMemberListResultPage) StaticMemberListResultIterator {
	return original.NewStaticMemberListResultIterator(page)
}
func NewStaticMemberListResultPage(cur StaticMemberListResult, getNextPage func(context.Context, StaticMemberListResult) (StaticMemberListResult, error)) StaticMemberListResultPage {
	return original.NewStaticMemberListResultPage(cur, getNextPage)
}
func NewStaticMembersClient(subscriptionID string) StaticMembersClient {
	return original.NewStaticMembersClient(subscriptionID)
}
func NewStaticMembersClientWithBaseURI(baseURI string, subscriptionID string) StaticMembersClient {
	return original.NewStaticMembersClientWithBaseURI(baseURI, subscriptionID)
}
func NewSubnetListResultIterator(page SubnetListResultPage) SubnetListResultIterator {
	return original.NewSubnetListResultIterator(page)
}
func NewSubnetListResultPage(cur SubnetListResult, getNextPage func(context.Context, SubnetListResult) (SubnetListResult, error)) SubnetListResultPage {
	return original.NewSubnetListResultPage(cur, getNextPage)
}
func NewSubnetsClient(subscriptionID string) SubnetsClient {
	return original.NewSubnetsClient(subscriptionID)
}
func NewSubnetsClientWithBaseURI(baseURI string, subscriptionID string) SubnetsClient {
	return original.NewSubnetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSubscriptionNetworkManagerConnectionsClient(subscriptionID string) SubscriptionNetworkManagerConnectionsClient {
	return original.NewSubscriptionNetworkManagerConnectionsClient(subscriptionID)
}
func NewSubscriptionNetworkManagerConnectionsClientWithBaseURI(baseURI string, subscriptionID string) SubscriptionNetworkManagerConnectionsClient {
	return original.NewSubscriptionNetworkManagerConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesClient(subscriptionID string) UsagesClient {
	return original.NewUsagesClient(subscriptionID)
}
func NewUsagesClientWithBaseURI(baseURI string, subscriptionID string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesListResultIterator(page UsagesListResultPage) UsagesListResultIterator {
	return original.NewUsagesListResultIterator(page)
}
func NewUsagesListResultPage(cur UsagesListResult, getNextPage func(context.Context, UsagesListResult) (UsagesListResult, error)) UsagesListResultPage {
	return original.NewUsagesListResultPage(cur, getNextPage)
}
func NewVipSwapClient(subscriptionID string) VipSwapClient {
	return original.NewVipSwapClient(subscriptionID)
}
func NewVipSwapClientWithBaseURI(baseURI string, subscriptionID string) VipSwapClient {
	return original.NewVipSwapClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualApplianceListResultIterator(page VirtualApplianceListResultPage) VirtualApplianceListResultIterator {
	return original.NewVirtualApplianceListResultIterator(page)
}
func NewVirtualApplianceListResultPage(cur VirtualApplianceListResult, getNextPage func(context.Context, VirtualApplianceListResult) (VirtualApplianceListResult, error)) VirtualApplianceListResultPage {
	return original.NewVirtualApplianceListResultPage(cur, getNextPage)
}
func NewVirtualApplianceSiteListResultIterator(page VirtualApplianceSiteListResultPage) VirtualApplianceSiteListResultIterator {
	return original.NewVirtualApplianceSiteListResultIterator(page)
}
func NewVirtualApplianceSiteListResultPage(cur VirtualApplianceSiteListResult, getNextPage func(context.Context, VirtualApplianceSiteListResult) (VirtualApplianceSiteListResult, error)) VirtualApplianceSiteListResultPage {
	return original.NewVirtualApplianceSiteListResultPage(cur, getNextPage)
}
func NewVirtualApplianceSitesClient(subscriptionID string) VirtualApplianceSitesClient {
	return original.NewVirtualApplianceSitesClient(subscriptionID)
}
func NewVirtualApplianceSitesClientWithBaseURI(baseURI string, subscriptionID string) VirtualApplianceSitesClient {
	return original.NewVirtualApplianceSitesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualApplianceSkuListResultIterator(page VirtualApplianceSkuListResultPage) VirtualApplianceSkuListResultIterator {
	return original.NewVirtualApplianceSkuListResultIterator(page)
}
func NewVirtualApplianceSkuListResultPage(cur VirtualApplianceSkuListResult, getNextPage func(context.Context, VirtualApplianceSkuListResult) (VirtualApplianceSkuListResult, error)) VirtualApplianceSkuListResultPage {
	return original.NewVirtualApplianceSkuListResultPage(cur, getNextPage)
}
func NewVirtualApplianceSkusClient(subscriptionID string) VirtualApplianceSkusClient {
	return original.NewVirtualApplianceSkusClient(subscriptionID)
}
func NewVirtualApplianceSkusClientWithBaseURI(baseURI string, subscriptionID string) VirtualApplianceSkusClient {
	return original.NewVirtualApplianceSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualAppliancesClient(subscriptionID string) VirtualAppliancesClient {
	return original.NewVirtualAppliancesClient(subscriptionID)
}
func NewVirtualAppliancesClientWithBaseURI(baseURI string, subscriptionID string) VirtualAppliancesClient {
	return original.NewVirtualAppliancesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualHubBgpConnectionClient(subscriptionID string) VirtualHubBgpConnectionClient {
	return original.NewVirtualHubBgpConnectionClient(subscriptionID)
}
func NewVirtualHubBgpConnectionClientWithBaseURI(baseURI string, subscriptionID string) VirtualHubBgpConnectionClient {
	return original.NewVirtualHubBgpConnectionClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualHubBgpConnectionsClient(subscriptionID string) VirtualHubBgpConnectionsClient {
	return original.NewVirtualHubBgpConnectionsClient(subscriptionID)
}
func NewVirtualHubBgpConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualHubBgpConnectionsClient {
	return original.NewVirtualHubBgpConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualHubIPConfigurationClient(subscriptionID string) VirtualHubIPConfigurationClient {
	return original.NewVirtualHubIPConfigurationClient(subscriptionID)
}
func NewVirtualHubIPConfigurationClientWithBaseURI(baseURI string, subscriptionID string) VirtualHubIPConfigurationClient {
	return original.NewVirtualHubIPConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualHubRouteTableV2sClient(subscriptionID string) VirtualHubRouteTableV2sClient {
	return original.NewVirtualHubRouteTableV2sClient(subscriptionID)
}
func NewVirtualHubRouteTableV2sClientWithBaseURI(baseURI string, subscriptionID string) VirtualHubRouteTableV2sClient {
	return original.NewVirtualHubRouteTableV2sClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualHubsClient(subscriptionID string) VirtualHubsClient {
	return original.NewVirtualHubsClient(subscriptionID)
}
func NewVirtualHubsClientWithBaseURI(baseURI string, subscriptionID string) VirtualHubsClient {
	return original.NewVirtualHubsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkDdosProtectionStatusResultIterator(page VirtualNetworkDdosProtectionStatusResultPage) VirtualNetworkDdosProtectionStatusResultIterator {
	return original.NewVirtualNetworkDdosProtectionStatusResultIterator(page)
}
func NewVirtualNetworkDdosProtectionStatusResultPage(cur VirtualNetworkDdosProtectionStatusResult, getNextPage func(context.Context, VirtualNetworkDdosProtectionStatusResult) (VirtualNetworkDdosProtectionStatusResult, error)) VirtualNetworkDdosProtectionStatusResultPage {
	return original.NewVirtualNetworkDdosProtectionStatusResultPage(cur, getNextPage)
}
func NewVirtualNetworkGatewayConnectionListResultIterator(page VirtualNetworkGatewayConnectionListResultPage) VirtualNetworkGatewayConnectionListResultIterator {
	return original.NewVirtualNetworkGatewayConnectionListResultIterator(page)
}
func NewVirtualNetworkGatewayConnectionListResultPage(cur VirtualNetworkGatewayConnectionListResult, getNextPage func(context.Context, VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)) VirtualNetworkGatewayConnectionListResultPage {
	return original.NewVirtualNetworkGatewayConnectionListResultPage(cur, getNextPage)
}
func NewVirtualNetworkGatewayConnectionsClient(subscriptionID string) VirtualNetworkGatewayConnectionsClient {
	return original.NewVirtualNetworkGatewayConnectionsClient(subscriptionID)
}
func NewVirtualNetworkGatewayConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkGatewayConnectionsClient {
	return original.NewVirtualNetworkGatewayConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkGatewayListConnectionsResultIterator(page VirtualNetworkGatewayListConnectionsResultPage) VirtualNetworkGatewayListConnectionsResultIterator {
	return original.NewVirtualNetworkGatewayListConnectionsResultIterator(page)
}
func NewVirtualNetworkGatewayListConnectionsResultPage(cur VirtualNetworkGatewayListConnectionsResult, getNextPage func(context.Context, VirtualNetworkGatewayListConnectionsResult) (VirtualNetworkGatewayListConnectionsResult, error)) VirtualNetworkGatewayListConnectionsResultPage {
	return original.NewVirtualNetworkGatewayListConnectionsResultPage(cur, getNextPage)
}
func NewVirtualNetworkGatewayListResultIterator(page VirtualNetworkGatewayListResultPage) VirtualNetworkGatewayListResultIterator {
	return original.NewVirtualNetworkGatewayListResultIterator(page)
}
func NewVirtualNetworkGatewayListResultPage(cur VirtualNetworkGatewayListResult, getNextPage func(context.Context, VirtualNetworkGatewayListResult) (VirtualNetworkGatewayListResult, error)) VirtualNetworkGatewayListResultPage {
	return original.NewVirtualNetworkGatewayListResultPage(cur, getNextPage)
}
func NewVirtualNetworkGatewayNatRulesClient(subscriptionID string) VirtualNetworkGatewayNatRulesClient {
	return original.NewVirtualNetworkGatewayNatRulesClient(subscriptionID)
}
func NewVirtualNetworkGatewayNatRulesClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkGatewayNatRulesClient {
	return original.NewVirtualNetworkGatewayNatRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkGatewaysClient(subscriptionID string) VirtualNetworkGatewaysClient {
	return original.NewVirtualNetworkGatewaysClient(subscriptionID)
}
func NewVirtualNetworkGatewaysClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkGatewaysClient {
	return original.NewVirtualNetworkGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkListResultIterator(page VirtualNetworkListResultPage) VirtualNetworkListResultIterator {
	return original.NewVirtualNetworkListResultIterator(page)
}
func NewVirtualNetworkListResultPage(cur VirtualNetworkListResult, getNextPage func(context.Context, VirtualNetworkListResult) (VirtualNetworkListResult, error)) VirtualNetworkListResultPage {
	return original.NewVirtualNetworkListResultPage(cur, getNextPage)
}
func NewVirtualNetworkListUsageResultIterator(page VirtualNetworkListUsageResultPage) VirtualNetworkListUsageResultIterator {
	return original.NewVirtualNetworkListUsageResultIterator(page)
}
func NewVirtualNetworkListUsageResultPage(cur VirtualNetworkListUsageResult, getNextPage func(context.Context, VirtualNetworkListUsageResult) (VirtualNetworkListUsageResult, error)) VirtualNetworkListUsageResultPage {
	return original.NewVirtualNetworkListUsageResultPage(cur, getNextPage)
}
func NewVirtualNetworkPeeringListResultIterator(page VirtualNetworkPeeringListResultPage) VirtualNetworkPeeringListResultIterator {
	return original.NewVirtualNetworkPeeringListResultIterator(page)
}
func NewVirtualNetworkPeeringListResultPage(cur VirtualNetworkPeeringListResult, getNextPage func(context.Context, VirtualNetworkPeeringListResult) (VirtualNetworkPeeringListResult, error)) VirtualNetworkPeeringListResultPage {
	return original.NewVirtualNetworkPeeringListResultPage(cur, getNextPage)
}
func NewVirtualNetworkPeeringsClient(subscriptionID string) VirtualNetworkPeeringsClient {
	return original.NewVirtualNetworkPeeringsClient(subscriptionID)
}
func NewVirtualNetworkPeeringsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkPeeringsClient {
	return original.NewVirtualNetworkPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkTapListResultIterator(page VirtualNetworkTapListResultPage) VirtualNetworkTapListResultIterator {
	return original.NewVirtualNetworkTapListResultIterator(page)
}
func NewVirtualNetworkTapListResultPage(cur VirtualNetworkTapListResult, getNextPage func(context.Context, VirtualNetworkTapListResult) (VirtualNetworkTapListResult, error)) VirtualNetworkTapListResultPage {
	return original.NewVirtualNetworkTapListResultPage(cur, getNextPage)
}
func NewVirtualNetworkTapsClient(subscriptionID string) VirtualNetworkTapsClient {
	return original.NewVirtualNetworkTapsClient(subscriptionID)
}
func NewVirtualNetworkTapsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkTapsClient {
	return original.NewVirtualNetworkTapsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworksClient(subscriptionID string) VirtualNetworksClient {
	return original.NewVirtualNetworksClient(subscriptionID)
}
func NewVirtualNetworksClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworksClient {
	return original.NewVirtualNetworksClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualRouterListResultIterator(page VirtualRouterListResultPage) VirtualRouterListResultIterator {
	return original.NewVirtualRouterListResultIterator(page)
}
func NewVirtualRouterListResultPage(cur VirtualRouterListResult, getNextPage func(context.Context, VirtualRouterListResult) (VirtualRouterListResult, error)) VirtualRouterListResultPage {
	return original.NewVirtualRouterListResultPage(cur, getNextPage)
}
func NewVirtualRouterPeeringListResultIterator(page VirtualRouterPeeringListResultPage) VirtualRouterPeeringListResultIterator {
	return original.NewVirtualRouterPeeringListResultIterator(page)
}
func NewVirtualRouterPeeringListResultPage(cur VirtualRouterPeeringListResult, getNextPage func(context.Context, VirtualRouterPeeringListResult) (VirtualRouterPeeringListResult, error)) VirtualRouterPeeringListResultPage {
	return original.NewVirtualRouterPeeringListResultPage(cur, getNextPage)
}
func NewVirtualRouterPeeringsClient(subscriptionID string) VirtualRouterPeeringsClient {
	return original.NewVirtualRouterPeeringsClient(subscriptionID)
}
func NewVirtualRouterPeeringsClientWithBaseURI(baseURI string, subscriptionID string) VirtualRouterPeeringsClient {
	return original.NewVirtualRouterPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualRoutersClient(subscriptionID string) VirtualRoutersClient {
	return original.NewVirtualRoutersClient(subscriptionID)
}
func NewVirtualRoutersClientWithBaseURI(baseURI string, subscriptionID string) VirtualRoutersClient {
	return original.NewVirtualRoutersClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualWansClient(subscriptionID string) VirtualWansClient {
	return original.NewVirtualWansClient(subscriptionID)
}
func NewVirtualWansClientWithBaseURI(baseURI string, subscriptionID string) VirtualWansClient {
	return original.NewVirtualWansClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnConnectionsClient(subscriptionID string) VpnConnectionsClient {
	return original.NewVpnConnectionsClient(subscriptionID)
}
func NewVpnConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VpnConnectionsClient {
	return original.NewVpnConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnGatewaysClient(subscriptionID string) VpnGatewaysClient {
	return original.NewVpnGatewaysClient(subscriptionID)
}
func NewVpnGatewaysClientWithBaseURI(baseURI string, subscriptionID string) VpnGatewaysClient {
	return original.NewVpnGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnLinkConnectionsClient(subscriptionID string) VpnLinkConnectionsClient {
	return original.NewVpnLinkConnectionsClient(subscriptionID)
}
func NewVpnLinkConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VpnLinkConnectionsClient {
	return original.NewVpnLinkConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnServerConfigurationsAssociatedWithVirtualWanClient(subscriptionID string) VpnServerConfigurationsAssociatedWithVirtualWanClient {
	return original.NewVpnServerConfigurationsAssociatedWithVirtualWanClient(subscriptionID)
}
func NewVpnServerConfigurationsAssociatedWithVirtualWanClientWithBaseURI(baseURI string, subscriptionID string) VpnServerConfigurationsAssociatedWithVirtualWanClient {
	return original.NewVpnServerConfigurationsAssociatedWithVirtualWanClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnServerConfigurationsClient(subscriptionID string) VpnServerConfigurationsClient {
	return original.NewVpnServerConfigurationsClient(subscriptionID)
}
func NewVpnServerConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) VpnServerConfigurationsClient {
	return original.NewVpnServerConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnSiteLinkConnectionsClient(subscriptionID string) VpnSiteLinkConnectionsClient {
	return original.NewVpnSiteLinkConnectionsClient(subscriptionID)
}
func NewVpnSiteLinkConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VpnSiteLinkConnectionsClient {
	return original.NewVpnSiteLinkConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnSiteLinksClient(subscriptionID string) VpnSiteLinksClient {
	return original.NewVpnSiteLinksClient(subscriptionID)
}
func NewVpnSiteLinksClientWithBaseURI(baseURI string, subscriptionID string) VpnSiteLinksClient {
	return original.NewVpnSiteLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnSitesClient(subscriptionID string) VpnSitesClient {
	return original.NewVpnSitesClient(subscriptionID)
}
func NewVpnSitesClientWithBaseURI(baseURI string, subscriptionID string) VpnSitesClient {
	return original.NewVpnSitesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnSitesConfigurationClient(subscriptionID string) VpnSitesConfigurationClient {
	return original.NewVpnSitesConfigurationClient(subscriptionID)
}
func NewVpnSitesConfigurationClientWithBaseURI(baseURI string, subscriptionID string) VpnSitesConfigurationClient {
	return original.NewVpnSitesConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewWatchersClient(subscriptionID string) WatchersClient {
	return original.NewWatchersClient(subscriptionID)
}
func NewWatchersClientWithBaseURI(baseURI string, subscriptionID string) WatchersClient {
	return original.NewWatchersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWebApplicationFirewallPoliciesClient(subscriptionID string) WebApplicationFirewallPoliciesClient {
	return original.NewWebApplicationFirewallPoliciesClient(subscriptionID)
}
func NewWebApplicationFirewallPoliciesClientWithBaseURI(baseURI string, subscriptionID string) WebApplicationFirewallPoliciesClient {
	return original.NewWebApplicationFirewallPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWebApplicationFirewallPolicyListResultIterator(page WebApplicationFirewallPolicyListResultPage) WebApplicationFirewallPolicyListResultIterator {
	return original.NewWebApplicationFirewallPolicyListResultIterator(page)
}
func NewWebApplicationFirewallPolicyListResultPage(cur WebApplicationFirewallPolicyListResult, getNextPage func(context.Context, WebApplicationFirewallPolicyListResult) (WebApplicationFirewallPolicyListResult, error)) WebApplicationFirewallPolicyListResultPage {
	return original.NewWebApplicationFirewallPolicyListResultPage(cur, getNextPage)
}
func NewWebCategoriesClient(subscriptionID string) WebCategoriesClient {
	return original.NewWebCategoriesClient(subscriptionID)
}
func NewWebCategoriesClientWithBaseURI(baseURI string, subscriptionID string) WebCategoriesClient {
	return original.NewWebCategoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessValues() []Access {
	return original.PossibleAccessValues()
}
func PossibleActionTypeValues() []ActionType {
	return original.PossibleActionTypeValues()
}
func PossibleAddressPrefixTypeValues() []AddressPrefixType {
	return original.PossibleAddressPrefixTypeValues()
}
func PossibleApplicationGatewayBackendHealthServerHealthValues() []ApplicationGatewayBackendHealthServerHealth {
	return original.PossibleApplicationGatewayBackendHealthServerHealthValues()
}
func PossibleApplicationGatewayClientRevocationOptionsValues() []ApplicationGatewayClientRevocationOptions {
	return original.PossibleApplicationGatewayClientRevocationOptionsValues()
}
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return original.PossibleApplicationGatewayCookieBasedAffinityValues()
}
func PossibleApplicationGatewayCustomErrorStatusCodeValues() []ApplicationGatewayCustomErrorStatusCode {
	return original.PossibleApplicationGatewayCustomErrorStatusCodeValues()
}
func PossibleApplicationGatewayFirewallModeValues() []ApplicationGatewayFirewallMode {
	return original.PossibleApplicationGatewayFirewallModeValues()
}
func PossibleApplicationGatewayLoadDistributionAlgorithmValues() []ApplicationGatewayLoadDistributionAlgorithm {
	return original.PossibleApplicationGatewayLoadDistributionAlgorithmValues()
}
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return original.PossibleApplicationGatewayOperationalStateValues()
}
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return original.PossibleApplicationGatewayProtocolValues()
}
func PossibleApplicationGatewayRedirectTypeValues() []ApplicationGatewayRedirectType {
	return original.PossibleApplicationGatewayRedirectTypeValues()
}
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return original.PossibleApplicationGatewayRequestRoutingRuleTypeValues()
}
func PossibleApplicationGatewayRuleSetStatusOptionsValues() []ApplicationGatewayRuleSetStatusOptions {
	return original.PossibleApplicationGatewayRuleSetStatusOptionsValues()
}
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return original.PossibleApplicationGatewaySkuNameValues()
}
func PossibleApplicationGatewaySslCipherSuiteValues() []ApplicationGatewaySslCipherSuite {
	return original.PossibleApplicationGatewaySslCipherSuiteValues()
}
func PossibleApplicationGatewaySslPolicyNameValues() []ApplicationGatewaySslPolicyName {
	return original.PossibleApplicationGatewaySslPolicyNameValues()
}
func PossibleApplicationGatewaySslPolicyTypeValues() []ApplicationGatewaySslPolicyType {
	return original.PossibleApplicationGatewaySslPolicyTypeValues()
}
func PossibleApplicationGatewaySslProtocolValues() []ApplicationGatewaySslProtocol {
	return original.PossibleApplicationGatewaySslProtocolValues()
}
func PossibleApplicationGatewayTierTypesValues() []ApplicationGatewayTierTypes {
	return original.PossibleApplicationGatewayTierTypesValues()
}
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return original.PossibleApplicationGatewayTierValues()
}
func PossibleApplicationGatewayWafRuleActionTypesValues() []ApplicationGatewayWafRuleActionTypes {
	return original.PossibleApplicationGatewayWafRuleActionTypesValues()
}
func PossibleApplicationGatewayWafRuleStateTypesValues() []ApplicationGatewayWafRuleStateTypes {
	return original.PossibleApplicationGatewayWafRuleStateTypesValues()
}
func PossibleAssociationTypeValues() []AssociationType {
	return original.PossibleAssociationTypeValues()
}
func PossibleAuthenticationMethodValues() []AuthenticationMethod {
	return original.PossibleAuthenticationMethodValues()
}
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return original.PossibleAuthorizationUseStatusValues()
}
func PossibleAutoLearnPrivateRangesModeValues() []AutoLearnPrivateRangesMode {
	return original.PossibleAutoLearnPrivateRangesModeValues()
}
func PossibleAzureFirewallApplicationRuleProtocolTypeValues() []AzureFirewallApplicationRuleProtocolType {
	return original.PossibleAzureFirewallApplicationRuleProtocolTypeValues()
}
func PossibleAzureFirewallNatRCActionTypeValues() []AzureFirewallNatRCActionType {
	return original.PossibleAzureFirewallNatRCActionTypeValues()
}
func PossibleAzureFirewallNetworkRuleProtocolValues() []AzureFirewallNetworkRuleProtocol {
	return original.PossibleAzureFirewallNetworkRuleProtocolValues()
}
func PossibleAzureFirewallRCActionTypeValues() []AzureFirewallRCActionType {
	return original.PossibleAzureFirewallRCActionTypeValues()
}
func PossibleAzureFirewallSkuNameValues() []AzureFirewallSkuName {
	return original.PossibleAzureFirewallSkuNameValues()
}
func PossibleAzureFirewallSkuTierValues() []AzureFirewallSkuTier {
	return original.PossibleAzureFirewallSkuTierValues()
}
func PossibleAzureFirewallThreatIntelModeValues() []AzureFirewallThreatIntelMode {
	return original.PossibleAzureFirewallThreatIntelModeValues()
}
func PossibleBastionConnectProtocolValues() []BastionConnectProtocol {
	return original.PossibleBastionConnectProtocolValues()
}
func PossibleBastionHostSkuNameValues() []BastionHostSkuName {
	return original.PossibleBastionHostSkuNameValues()
}
func PossibleBgpPeerStateValues() []BgpPeerState {
	return original.PossibleBgpPeerStateValues()
}
func PossibleCircuitConnectionStatusValues() []CircuitConnectionStatus {
	return original.PossibleCircuitConnectionStatusValues()
}
func PossibleCommissionedStateValues() []CommissionedState {
	return original.PossibleCommissionedStateValues()
}
func PossibleConfigurationTypeValues() []ConfigurationType {
	return original.PossibleConfigurationTypeValues()
}
func PossibleConnectionMonitorEndpointFilterItemTypeValues() []ConnectionMonitorEndpointFilterItemType {
	return original.PossibleConnectionMonitorEndpointFilterItemTypeValues()
}
func PossibleConnectionMonitorEndpointFilterTypeValues() []ConnectionMonitorEndpointFilterType {
	return original.PossibleConnectionMonitorEndpointFilterTypeValues()
}
func PossibleConnectionMonitorSourceStatusValues() []ConnectionMonitorSourceStatus {
	return original.PossibleConnectionMonitorSourceStatusValues()
}
func PossibleConnectionMonitorTestConfigurationProtocolValues() []ConnectionMonitorTestConfigurationProtocol {
	return original.PossibleConnectionMonitorTestConfigurationProtocolValues()
}
func PossibleConnectionMonitorTypeValues() []ConnectionMonitorType {
	return original.PossibleConnectionMonitorTypeValues()
}
func PossibleConnectionStateValues() []ConnectionState {
	return original.PossibleConnectionStateValues()
}
func PossibleConnectionStatusValues() []ConnectionStatus {
	return original.PossibleConnectionStatusValues()
}
func PossibleConnectivityTopologyValues() []ConnectivityTopology {
	return original.PossibleConnectivityTopologyValues()
}
func PossibleCoverageLevelValues() []CoverageLevel {
	return original.PossibleCoverageLevelValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleCustomIPPrefixTypeValues() []CustomIPPrefixType {
	return original.PossibleCustomIPPrefixTypeValues()
}
func PossibleDdosSettingsProtectionModeValues() []DdosSettingsProtectionMode {
	return original.PossibleDdosSettingsProtectionModeValues()
}
func PossibleDeleteExistingPeeringValues() []DeleteExistingPeering {
	return original.PossibleDeleteExistingPeeringValues()
}
func PossibleDeleteOptionsValues() []DeleteOptions {
	return original.PossibleDeleteOptionsValues()
}
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return original.PossibleDeploymentStatusValues()
}
func PossibleDestinationPortBehaviorValues() []DestinationPortBehavior {
	return original.PossibleDestinationPortBehaviorValues()
}
func PossibleDhGroupValues() []DhGroup {
	return original.PossibleDhGroupValues()
}
func PossibleDirectionValues() []Direction {
	return original.PossibleDirectionValues()
}
func PossibleEffectiveRouteSourceValues() []EffectiveRouteSource {
	return original.PossibleEffectiveRouteSourceValues()
}
func PossibleEffectiveRouteStateValues() []EffectiveRouteState {
	return original.PossibleEffectiveRouteStateValues()
}
func PossibleEffectiveSecurityRuleProtocolValues() []EffectiveSecurityRuleProtocol {
	return original.PossibleEffectiveSecurityRuleProtocolValues()
}
func PossibleEndpointTypeValues() []EndpointType {
	return original.PossibleEndpointTypeValues()
}
func PossibleEvaluationStateValues() []EvaluationState {
	return original.PossibleEvaluationStateValues()
}
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return original.PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues()
}
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return original.PossibleExpressRouteCircuitPeeringStateValues()
}
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return original.PossibleExpressRouteCircuitSkuFamilyValues()
}
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return original.PossibleExpressRouteCircuitSkuTierValues()
}
func PossibleExpressRouteLinkAdminStateValues() []ExpressRouteLinkAdminState {
	return original.PossibleExpressRouteLinkAdminStateValues()
}
func PossibleExpressRouteLinkConnectorTypeValues() []ExpressRouteLinkConnectorType {
	return original.PossibleExpressRouteLinkConnectorTypeValues()
}
func PossibleExpressRouteLinkMacSecCipherValues() []ExpressRouteLinkMacSecCipher {
	return original.PossibleExpressRouteLinkMacSecCipherValues()
}
func PossibleExpressRouteLinkMacSecSciStateValues() []ExpressRouteLinkMacSecSciState {
	return original.PossibleExpressRouteLinkMacSecSciStateValues()
}
func PossibleExpressRoutePeeringStateValues() []ExpressRoutePeeringState {
	return original.PossibleExpressRoutePeeringStateValues()
}
func PossibleExpressRoutePeeringTypeValues() []ExpressRoutePeeringType {
	return original.PossibleExpressRoutePeeringTypeValues()
}
func PossibleExpressRoutePortAuthorizationUseStatusValues() []ExpressRoutePortAuthorizationUseStatus {
	return original.PossibleExpressRoutePortAuthorizationUseStatusValues()
}
func PossibleExpressRoutePortsBillingTypeValues() []ExpressRoutePortsBillingType {
	return original.PossibleExpressRoutePortsBillingTypeValues()
}
func PossibleExpressRoutePortsEncapsulationValues() []ExpressRoutePortsEncapsulation {
	return original.PossibleExpressRoutePortsEncapsulationValues()
}
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return original.PossibleExtendedLocationTypesValues()
}
func PossibleFirewallPolicyFilterRuleCollectionActionTypeValues() []FirewallPolicyFilterRuleCollectionActionType {
	return original.PossibleFirewallPolicyFilterRuleCollectionActionTypeValues()
}
func PossibleFirewallPolicyIDPSQuerySortOrderValues() []FirewallPolicyIDPSQuerySortOrder {
	return original.PossibleFirewallPolicyIDPSQuerySortOrderValues()
}
func PossibleFirewallPolicyIntrusionDetectionProtocolValues() []FirewallPolicyIntrusionDetectionProtocol {
	return original.PossibleFirewallPolicyIntrusionDetectionProtocolValues()
}
func PossibleFirewallPolicyIntrusionDetectionStateTypeValues() []FirewallPolicyIntrusionDetectionStateType {
	return original.PossibleFirewallPolicyIntrusionDetectionStateTypeValues()
}
func PossibleFirewallPolicyNatRuleCollectionActionTypeValues() []FirewallPolicyNatRuleCollectionActionType {
	return original.PossibleFirewallPolicyNatRuleCollectionActionTypeValues()
}
func PossibleFirewallPolicyRuleApplicationProtocolTypeValues() []FirewallPolicyRuleApplicationProtocolType {
	return original.PossibleFirewallPolicyRuleApplicationProtocolTypeValues()
}
func PossibleFirewallPolicyRuleNetworkProtocolValues() []FirewallPolicyRuleNetworkProtocol {
	return original.PossibleFirewallPolicyRuleNetworkProtocolValues()
}
func PossibleFirewallPolicySkuTierValues() []FirewallPolicySkuTier {
	return original.PossibleFirewallPolicySkuTierValues()
}
func PossibleFlowLogFormatTypeValues() []FlowLogFormatType {
	return original.PossibleFlowLogFormatTypeValues()
}
func PossibleGatewayLoadBalancerTunnelInterfaceTypeValues() []GatewayLoadBalancerTunnelInterfaceType {
	return original.PossibleGatewayLoadBalancerTunnelInterfaceTypeValues()
}
func PossibleGatewayLoadBalancerTunnelProtocolValues() []GatewayLoadBalancerTunnelProtocol {
	return original.PossibleGatewayLoadBalancerTunnelProtocolValues()
}
func PossibleGeoValues() []Geo {
	return original.PossibleGeoValues()
}
func PossibleGroupConnectivityValues() []GroupConnectivity {
	return original.PossibleGroupConnectivityValues()
}
func PossibleHTTPConfigurationMethodValues() []HTTPConfigurationMethod {
	return original.PossibleHTTPConfigurationMethodValues()
}
func PossibleHTTPMethodValues() []HTTPMethod {
	return original.PossibleHTTPMethodValues()
}
func PossibleHubBgpConnectionStatusValues() []HubBgpConnectionStatus {
	return original.PossibleHubBgpConnectionStatusValues()
}
func PossibleHubRoutingPreferenceValues() []HubRoutingPreference {
	return original.PossibleHubRoutingPreferenceValues()
}
func PossibleHubVirtualNetworkConnectionStatusValues() []HubVirtualNetworkConnectionStatus {
	return original.PossibleHubVirtualNetworkConnectionStatusValues()
}
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return original.PossibleIPAllocationMethodValues()
}
func PossibleIPAllocationTypeValues() []IPAllocationType {
	return original.PossibleIPAllocationTypeValues()
}
func PossibleIPFlowProtocolValues() []IPFlowProtocol {
	return original.PossibleIPFlowProtocolValues()
}
func PossibleIPVersionValues() []IPVersion {
	return original.PossibleIPVersionValues()
}
func PossibleIkeEncryptionValues() []IkeEncryption {
	return original.PossibleIkeEncryptionValues()
}
func PossibleIkeIntegrityValues() []IkeIntegrity {
	return original.PossibleIkeIntegrityValues()
}
func PossibleInboundSecurityRulesProtocolValues() []InboundSecurityRulesProtocol {
	return original.PossibleInboundSecurityRulesProtocolValues()
}
func PossibleIntentPolicyBasedServiceValues() []IntentPolicyBasedService {
	return original.PossibleIntentPolicyBasedServiceValues()
}
func PossibleInterfaceAuxiliaryModeValues() []InterfaceAuxiliaryMode {
	return original.PossibleInterfaceAuxiliaryModeValues()
}
func PossibleInterfaceMigrationPhaseValues() []InterfaceMigrationPhase {
	return original.PossibleInterfaceMigrationPhaseValues()
}
func PossibleInterfaceNicTypeValues() []InterfaceNicType {
	return original.PossibleInterfaceNicTypeValues()
}
func PossibleIpsecEncryptionValues() []IpsecEncryption {
	return original.PossibleIpsecEncryptionValues()
}
func PossibleIpsecIntegrityValues() []IpsecIntegrity {
	return original.PossibleIpsecIntegrityValues()
}
func PossibleIsGlobalValues() []IsGlobal {
	return original.PossibleIsGlobalValues()
}
func PossibleIsWorkloadProtectedValues() []IsWorkloadProtected {
	return original.PossibleIsWorkloadProtectedValues()
}
func PossibleIssueTypeValues() []IssueType {
	return original.PossibleIssueTypeValues()
}
func PossibleKindBasicBaseAdminRuleValues() []KindBasicBaseAdminRule {
	return original.PossibleKindBasicBaseAdminRuleValues()
}
func PossibleKindBasicEffectiveBaseSecurityAdminRuleValues() []KindBasicEffectiveBaseSecurityAdminRule {
	return original.PossibleKindBasicEffectiveBaseSecurityAdminRuleValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleLoadBalancerBackendAddressAdminStateValues() []LoadBalancerBackendAddressAdminState {
	return original.PossibleLoadBalancerBackendAddressAdminStateValues()
}
func PossibleLoadBalancerOutboundRuleProtocolValues() []LoadBalancerOutboundRuleProtocol {
	return original.PossibleLoadBalancerOutboundRuleProtocolValues()
}
func PossibleLoadBalancerSkuNameValues() []LoadBalancerSkuName {
	return original.PossibleLoadBalancerSkuNameValues()
}
func PossibleLoadBalancerSkuTierValues() []LoadBalancerSkuTier {
	return original.PossibleLoadBalancerSkuTierValues()
}
func PossibleLoadDistributionValues() []LoadDistribution {
	return original.PossibleLoadDistributionValues()
}
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return original.PossibleManagedRuleEnabledStateValues()
}
func PossibleNatGatewaySkuNameValues() []NatGatewaySkuName {
	return original.PossibleNatGatewaySkuNameValues()
}
func PossibleNextHopTypeValues() []NextHopType {
	return original.PossibleNextHopTypeValues()
}
func PossibleNextStepValues() []NextStep {
	return original.PossibleNextStepValues()
}
func PossibleOfficeTrafficCategoryValues() []OfficeTrafficCategory {
	return original.PossibleOfficeTrafficCategoryValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossibleOriginValues() []Origin {
	return original.PossibleOriginValues()
}
func PossibleOutputTypeValues() []OutputType {
	return original.PossibleOutputTypeValues()
}
func PossibleOwaspCrsExclusionEntryMatchVariableValues() []OwaspCrsExclusionEntryMatchVariable {
	return original.PossibleOwaspCrsExclusionEntryMatchVariableValues()
}
func PossibleOwaspCrsExclusionEntrySelectorMatchOperatorValues() []OwaspCrsExclusionEntrySelectorMatchOperator {
	return original.PossibleOwaspCrsExclusionEntrySelectorMatchOperatorValues()
}
func PossiblePacketCaptureTargetTypeValues() []PacketCaptureTargetType {
	return original.PossiblePacketCaptureTargetTypeValues()
}
func PossiblePcErrorValues() []PcError {
	return original.PossiblePcErrorValues()
}
func PossiblePcProtocolValues() []PcProtocol {
	return original.PossiblePcProtocolValues()
}
func PossiblePcStatusValues() []PcStatus {
	return original.PossiblePcStatusValues()
}
func PossiblePfsGroupValues() []PfsGroup {
	return original.PossiblePfsGroupValues()
}
func PossiblePreferredIPVersionValues() []PreferredIPVersion {
	return original.PossiblePreferredIPVersionValues()
}
func PossiblePreferredRoutingGatewayValues() []PreferredRoutingGateway {
	return original.PossiblePreferredRoutingGatewayValues()
}
func PossibleProbeProtocolValues() []ProbeProtocol {
	return original.PossibleProbeProtocolValues()
}
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return original.PossibleProcessorArchitectureValues()
}
func PossibleProtocolTypeValues() []ProtocolType {
	return original.PossibleProtocolTypeValues()
}
func PossibleProtocolValues() []Protocol {
	return original.PossibleProtocolValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossiblePublicIPAddressMigrationPhaseValues() []PublicIPAddressMigrationPhase {
	return original.PossiblePublicIPAddressMigrationPhaseValues()
}
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return original.PossiblePublicIPAddressSkuNameValues()
}
func PossiblePublicIPAddressSkuTierValues() []PublicIPAddressSkuTier {
	return original.PossiblePublicIPAddressSkuTierValues()
}
func PossiblePublicIPPrefixSkuNameValues() []PublicIPPrefixSkuName {
	return original.PossiblePublicIPPrefixSkuNameValues()
}
func PossiblePublicIPPrefixSkuTierValues() []PublicIPPrefixSkuTier {
	return original.PossiblePublicIPPrefixSkuTierValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleRouteMapActionTypeValues() []RouteMapActionType {
	return original.PossibleRouteMapActionTypeValues()
}
func PossibleRouteMapMatchConditionValues() []RouteMapMatchCondition {
	return original.PossibleRouteMapMatchConditionValues()
}
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return original.PossibleRouteNextHopTypeValues()
}
func PossibleRoutingStateValues() []RoutingState {
	return original.PossibleRoutingStateValues()
}
func PossibleRuleCollectionTypeValues() []RuleCollectionType {
	return original.PossibleRuleCollectionTypeValues()
}
func PossibleRuleTypeValues() []RuleType {
	return original.PossibleRuleTypeValues()
}
func PossibleScopeConnectionStateValues() []ScopeConnectionState {
	return original.PossibleScopeConnectionStateValues()
}
func PossibleSecurityConfigurationRuleAccessValues() []SecurityConfigurationRuleAccess {
	return original.PossibleSecurityConfigurationRuleAccessValues()
}
func PossibleSecurityConfigurationRuleDirectionValues() []SecurityConfigurationRuleDirection {
	return original.PossibleSecurityConfigurationRuleDirectionValues()
}
func PossibleSecurityConfigurationRuleProtocolValues() []SecurityConfigurationRuleProtocol {
	return original.PossibleSecurityConfigurationRuleProtocolValues()
}
func PossibleSecurityPartnerProviderConnectionStatusValues() []SecurityPartnerProviderConnectionStatus {
	return original.PossibleSecurityPartnerProviderConnectionStatusValues()
}
func PossibleSecurityProviderNameValues() []SecurityProviderName {
	return original.PossibleSecurityProviderNameValues()
}
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return original.PossibleSecurityRuleAccessValues()
}
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return original.PossibleSecurityRuleDirectionValues()
}
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return original.PossibleSecurityRuleProtocolValues()
}
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return original.PossibleServiceProviderProvisioningStateValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleSlotTypeValues() []SlotType {
	return original.PossibleSlotTypeValues()
}
func PossibleSyncRemoteAddressSpaceValues() []SyncRemoteAddressSpace {
	return original.PossibleSyncRemoteAddressSpaceValues()
}
func PossibleTransportProtocolValues() []TransportProtocol {
	return original.PossibleTransportProtocolValues()
}
func PossibleTunnelConnectionStatusValues() []TunnelConnectionStatus {
	return original.PossibleTunnelConnectionStatusValues()
}
func PossibleUseHubGatewayValues() []UseHubGateway {
	return original.PossibleUseHubGatewayValues()
}
func PossibleVerbosityLevelValues() []VerbosityLevel {
	return original.PossibleVerbosityLevelValues()
}
func PossibleVirtualNetworkEncryptionEnforcementValues() []VirtualNetworkEncryptionEnforcement {
	return original.PossibleVirtualNetworkEncryptionEnforcementValues()
}
func PossibleVirtualNetworkGatewayConnectionModeValues() []VirtualNetworkGatewayConnectionMode {
	return original.PossibleVirtualNetworkGatewayConnectionModeValues()
}
func PossibleVirtualNetworkGatewayConnectionProtocolValues() []VirtualNetworkGatewayConnectionProtocol {
	return original.PossibleVirtualNetworkGatewayConnectionProtocolValues()
}
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return original.PossibleVirtualNetworkGatewayConnectionStatusValues()
}
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return original.PossibleVirtualNetworkGatewayConnectionTypeValues()
}
func PossibleVirtualNetworkGatewaySkuNameValues() []VirtualNetworkGatewaySkuName {
	return original.PossibleVirtualNetworkGatewaySkuNameValues()
}
func PossibleVirtualNetworkGatewaySkuTierValues() []VirtualNetworkGatewaySkuTier {
	return original.PossibleVirtualNetworkGatewaySkuTierValues()
}
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return original.PossibleVirtualNetworkGatewayTypeValues()
}
func PossibleVirtualNetworkPeeringLevelValues() []VirtualNetworkPeeringLevel {
	return original.PossibleVirtualNetworkPeeringLevelValues()
}
func PossibleVirtualNetworkPeeringStateValues() []VirtualNetworkPeeringState {
	return original.PossibleVirtualNetworkPeeringStateValues()
}
func PossibleVirtualNetworkPrivateEndpointNetworkPoliciesValues() []VirtualNetworkPrivateEndpointNetworkPolicies {
	return original.PossibleVirtualNetworkPrivateEndpointNetworkPoliciesValues()
}
func PossibleVirtualNetworkPrivateLinkServiceNetworkPoliciesValues() []VirtualNetworkPrivateLinkServiceNetworkPolicies {
	return original.PossibleVirtualNetworkPrivateLinkServiceNetworkPoliciesValues()
}
func PossibleVirtualWanSecurityProviderTypeValues() []VirtualWanSecurityProviderType {
	return original.PossibleVirtualWanSecurityProviderTypeValues()
}
func PossibleVnetLocalRouteOverrideCriteriaValues() []VnetLocalRouteOverrideCriteria {
	return original.PossibleVnetLocalRouteOverrideCriteriaValues()
}
func PossibleVpnAuthenticationTypeValues() []VpnAuthenticationType {
	return original.PossibleVpnAuthenticationTypeValues()
}
func PossibleVpnClientProtocolValues() []VpnClientProtocol {
	return original.PossibleVpnClientProtocolValues()
}
func PossibleVpnConnectionStatusValues() []VpnConnectionStatus {
	return original.PossibleVpnConnectionStatusValues()
}
func PossibleVpnGatewayGenerationValues() []VpnGatewayGeneration {
	return original.PossibleVpnGatewayGenerationValues()
}
func PossibleVpnGatewayTunnelingProtocolValues() []VpnGatewayTunnelingProtocol {
	return original.PossibleVpnGatewayTunnelingProtocolValues()
}
func PossibleVpnLinkConnectionModeValues() []VpnLinkConnectionMode {
	return original.PossibleVpnLinkConnectionModeValues()
}
func PossibleVpnNatRuleModeValues() []VpnNatRuleMode {
	return original.PossibleVpnNatRuleModeValues()
}
func PossibleVpnNatRuleTypeValues() []VpnNatRuleType {
	return original.PossibleVpnNatRuleTypeValues()
}
func PossibleVpnPolicyMemberAttributeTypeValues() []VpnPolicyMemberAttributeType {
	return original.PossibleVpnPolicyMemberAttributeTypeValues()
}
func PossibleVpnTypeValues() []VpnType {
	return original.PossibleVpnTypeValues()
}
func PossibleWebApplicationFirewallActionValues() []WebApplicationFirewallAction {
	return original.PossibleWebApplicationFirewallActionValues()
}
func PossibleWebApplicationFirewallEnabledStateValues() []WebApplicationFirewallEnabledState {
	return original.PossibleWebApplicationFirewallEnabledStateValues()
}
func PossibleWebApplicationFirewallMatchVariableValues() []WebApplicationFirewallMatchVariable {
	return original.PossibleWebApplicationFirewallMatchVariableValues()
}
func PossibleWebApplicationFirewallModeValues() []WebApplicationFirewallMode {
	return original.PossibleWebApplicationFirewallModeValues()
}
func PossibleWebApplicationFirewallOperatorValues() []WebApplicationFirewallOperator {
	return original.PossibleWebApplicationFirewallOperatorValues()
}
func PossibleWebApplicationFirewallPolicyResourceStateValues() []WebApplicationFirewallPolicyResourceState {
	return original.PossibleWebApplicationFirewallPolicyResourceStateValues()
}
func PossibleWebApplicationFirewallRuleTypeValues() []WebApplicationFirewallRuleType {
	return original.PossibleWebApplicationFirewallRuleTypeValues()
}
func PossibleWebApplicationFirewallTransformValues() []WebApplicationFirewallTransform {
	return original.PossibleWebApplicationFirewallTransformValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
