/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// NicProperties struct for NicProperties
type NicProperties struct {
	// The name of the  resource.
	Name *string `json:"name,omitempty"`
	// The MAC address of the NIC.
	Mac *string `json:"mac,omitempty"`
	// Collection of IP addresses, assigned to the NIC. Explicitly assigned public IPs need to come from reserved IP blocks. Passing value null or empty array will assign an IP address automatically.
	Ips *[]string `json:"ips,omitempty"`
	// Indicates if the NIC will reserve an IP using DHCP.
	Dhcp *bool `json:"dhcp,omitempty"`
	// The LAN ID the NIC will be on. If the LAN ID does not exist, it will be implicitly created.
	Lan *int32 `json:"lan"`
	// Activate or deactivate the firewall. By default, an active firewall without any defined rules will block all incoming network traffic except for the firewall rules that explicitly allows certain protocols, IP addresses and ports.
	FirewallActive *bool `json:"firewallActive,omitempty"`
	// The type of firewall rules that will be allowed on the NIC. If not specified, the default INGRESS value is used.
	FirewallType *string `json:"firewallType,omitempty"`
	// The Logical Unit Number (LUN) of the storage volume. Null if this NIC was created using Cloud API and no DCD changes were performed on the Datacenter.
	DeviceNumber *int32 `json:"deviceNumber,omitempty"`
	// The PCI slot number for the NIC.
	PciSlot *int32 `json:"pciSlot,omitempty"`
	// The vnet ID that belongs to this NIC; Requires system privileges
	Vnet *string `json:"vnet,omitempty"`
}

// NewNicProperties instantiates a new NicProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewNicProperties(lan int32) *NicProperties {
	this := NicProperties{}

	this.Lan = &lan

	return &this
}

// NewNicPropertiesWithDefaults instantiates a new NicProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewNicPropertiesWithDefaults() *NicProperties {
	this := NicProperties{}
	return &this
}

// GetName returns the Name field value
// If the value is explicit nil, the zero value for string will be returned
func (o *NicProperties) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name

}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Name, true
}

// SetName sets field value
func (o *NicProperties) SetName(v string) {

	o.Name = &v

}

// HasName returns a boolean if a field has been set.
func (o *NicProperties) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// GetMac returns the Mac field value
// If the value is explicit nil, the zero value for string will be returned
func (o *NicProperties) GetMac() *string {
	if o == nil {
		return nil
	}

	return o.Mac

}

// GetMacOk returns a tuple with the Mac field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetMacOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Mac, true
}

// SetMac sets field value
func (o *NicProperties) SetMac(v string) {

	o.Mac = &v

}

// HasMac returns a boolean if a field has been set.
func (o *NicProperties) HasMac() bool {
	if o != nil && o.Mac != nil {
		return true
	}

	return false
}

// GetIps returns the Ips field value
// If the value is explicit nil, the zero value for []string will be returned
func (o *NicProperties) GetIps() *[]string {
	if o == nil {
		return nil
	}

	return o.Ips

}

// GetIpsOk returns a tuple with the Ips field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetIpsOk() (*[]string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Ips, true
}

// SetIps sets field value
func (o *NicProperties) SetIps(v []string) {

	o.Ips = &v

}

// HasIps returns a boolean if a field has been set.
func (o *NicProperties) HasIps() bool {
	if o != nil && o.Ips != nil {
		return true
	}

	return false
}

// GetDhcp returns the Dhcp field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *NicProperties) GetDhcp() *bool {
	if o == nil {
		return nil
	}

	return o.Dhcp

}

// GetDhcpOk returns a tuple with the Dhcp field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetDhcpOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}

	return o.Dhcp, true
}

// SetDhcp sets field value
func (o *NicProperties) SetDhcp(v bool) {

	o.Dhcp = &v

}

// HasDhcp returns a boolean if a field has been set.
func (o *NicProperties) HasDhcp() bool {
	if o != nil && o.Dhcp != nil {
		return true
	}

	return false
}

// GetLan returns the Lan field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *NicProperties) GetLan() *int32 {
	if o == nil {
		return nil
	}

	return o.Lan

}

// GetLanOk returns a tuple with the Lan field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetLanOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.Lan, true
}

// SetLan sets field value
func (o *NicProperties) SetLan(v int32) {

	o.Lan = &v

}

// HasLan returns a boolean if a field has been set.
func (o *NicProperties) HasLan() bool {
	if o != nil && o.Lan != nil {
		return true
	}

	return false
}

// GetFirewallActive returns the FirewallActive field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *NicProperties) GetFirewallActive() *bool {
	if o == nil {
		return nil
	}

	return o.FirewallActive

}

// GetFirewallActiveOk returns a tuple with the FirewallActive field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetFirewallActiveOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}

	return o.FirewallActive, true
}

// SetFirewallActive sets field value
func (o *NicProperties) SetFirewallActive(v bool) {

	o.FirewallActive = &v

}

// HasFirewallActive returns a boolean if a field has been set.
func (o *NicProperties) HasFirewallActive() bool {
	if o != nil && o.FirewallActive != nil {
		return true
	}

	return false
}

// GetFirewallType returns the FirewallType field value
// If the value is explicit nil, the zero value for string will be returned
func (o *NicProperties) GetFirewallType() *string {
	if o == nil {
		return nil
	}

	return o.FirewallType

}

// GetFirewallTypeOk returns a tuple with the FirewallType field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetFirewallTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.FirewallType, true
}

// SetFirewallType sets field value
func (o *NicProperties) SetFirewallType(v string) {

	o.FirewallType = &v

}

// HasFirewallType returns a boolean if a field has been set.
func (o *NicProperties) HasFirewallType() bool {
	if o != nil && o.FirewallType != nil {
		return true
	}

	return false
}

// GetDeviceNumber returns the DeviceNumber field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *NicProperties) GetDeviceNumber() *int32 {
	if o == nil {
		return nil
	}

	return o.DeviceNumber

}

// GetDeviceNumberOk returns a tuple with the DeviceNumber field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetDeviceNumberOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.DeviceNumber, true
}

// SetDeviceNumber sets field value
func (o *NicProperties) SetDeviceNumber(v int32) {

	o.DeviceNumber = &v

}

// HasDeviceNumber returns a boolean if a field has been set.
func (o *NicProperties) HasDeviceNumber() bool {
	if o != nil && o.DeviceNumber != nil {
		return true
	}

	return false
}

// GetPciSlot returns the PciSlot field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *NicProperties) GetPciSlot() *int32 {
	if o == nil {
		return nil
	}

	return o.PciSlot

}

// GetPciSlotOk returns a tuple with the PciSlot field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetPciSlotOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.PciSlot, true
}

// SetPciSlot sets field value
func (o *NicProperties) SetPciSlot(v int32) {

	o.PciSlot = &v

}

// HasPciSlot returns a boolean if a field has been set.
func (o *NicProperties) HasPciSlot() bool {
	if o != nil && o.PciSlot != nil {
		return true
	}

	return false
}

// GetVnet returns the Vnet field value
// If the value is explicit nil, the zero value for string will be returned
func (o *NicProperties) GetVnet() *string {
	if o == nil {
		return nil
	}

	return o.Vnet

}

// GetVnetOk returns a tuple with the Vnet field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NicProperties) GetVnetOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Vnet, true
}

// SetVnet sets field value
func (o *NicProperties) SetVnet(v string) {

	o.Vnet = &v

}

// HasVnet returns a boolean if a field has been set.
func (o *NicProperties) HasVnet() bool {
	if o != nil && o.Vnet != nil {
		return true
	}

	return false
}

func (o NicProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	if o.Mac != nil {
		toSerialize["mac"] = o.Mac
	}
	toSerialize["ips"] = o.Ips
	if o.Dhcp != nil {
		toSerialize["dhcp"] = o.Dhcp
	}
	if o.Lan != nil {
		toSerialize["lan"] = o.Lan
	}
	if o.FirewallActive != nil {
		toSerialize["firewallActive"] = o.FirewallActive
	}
	if o.FirewallType != nil {
		toSerialize["firewallType"] = o.FirewallType
	}
	if o.DeviceNumber != nil {
		toSerialize["deviceNumber"] = o.DeviceNumber
	}
	if o.PciSlot != nil {
		toSerialize["pciSlot"] = o.PciSlot
	}
	if o.Vnet != nil {
		toSerialize["vnet"] = o.Vnet
	}
	return json.Marshal(toSerialize)
}

type NullableNicProperties struct {
	value *NicProperties
	isSet bool
}

func (v NullableNicProperties) Get() *NicProperties {
	return v.value
}

func (v *NullableNicProperties) Set(val *NicProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableNicProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableNicProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableNicProperties(val *NicProperties) *NullableNicProperties {
	return &NullableNicProperties{value: val, isSet: true}
}

func (v NullableNicProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableNicProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
