# Go Vulnerability Management

[![Go Reference](https://pkg.go.dev/badge/golang.org/x/vuln.svg)](https://pkg.go.dev/golang.org/x/vuln)

This repository contains packages for accessing and analyzing data from the
[Go Vulnerability Database](https://vuln.go.dev). It contains the following:

- Package client: a client for interacting with the Go vulnerability database
- Package vulncheck: an API for detecting vulnerabilities in Go packages
- Command govulncheck: a CLI for detecting vulnerabilities in Go packages

Check out [https://go.dev/security/vuln](https://go.dev/security/vuln) for more
information about the Go vulnerability management system.

## Privacy Policy

The privacy policy for `govulncheck` can be found at
[https://vuln.go.dev/privacy](https://vuln.go.dev/privacy.html).

## License

Unless otherwise noted, the Go source files are distributed under
the BSD-style license found in the LICENSE file.

Database entries available at https://vuln.go.dev are distributed under the
terms of the [CC-BY 4.0](https://creativecommons.org/licenses/by/4.0/) license.
