// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package chat

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	chatpb "cloud.google.com/go/chat/apiv1/chatpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	CreateMessage        []gax.CallOption
	ListMessages         []gax.CallOption
	ListMemberships      []gax.CallOption
	GetMembership        []gax.CallOption
	GetMessage           []gax.CallOption
	UpdateMessage        []gax.CallOption
	DeleteMessage        []gax.CallOption
	GetAttachment        []gax.CallOption
	UploadAttachment     []gax.CallOption
	ListSpaces           []gax.CallOption
	GetSpace             []gax.CallOption
	CreateSpace          []gax.CallOption
	SetUpSpace           []gax.CallOption
	UpdateSpace          []gax.CallOption
	DeleteSpace          []gax.CallOption
	CompleteImportSpace  []gax.CallOption
	FindDirectMessage    []gax.CallOption
	CreateMembership     []gax.CallOption
	UpdateMembership     []gax.CallOption
	DeleteMembership     []gax.CallOption
	CreateReaction       []gax.CallOption
	ListReactions        []gax.CallOption
	DeleteReaction       []gax.CallOption
	GetSpaceReadState    []gax.CallOption
	UpdateSpaceReadState []gax.CallOption
	GetThreadReadState   []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("chat.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("chat.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("chat.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://chat.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		CreateMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListMessages: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListMemberships: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetMembership: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetAttachment: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UploadAttachment: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListSpaces: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SetUpSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CompleteImportSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		FindDirectMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateMembership: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateMembership: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteMembership: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateReaction: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListReactions: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteReaction: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetSpaceReadState: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateSpaceReadState: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetThreadReadState: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		CreateMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListMessages: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListMemberships: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetMembership: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetAttachment: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UploadAttachment: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListSpaces: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		SetUpSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CompleteImportSpace: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		FindDirectMessage: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateMembership: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateMembership: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteMembership: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateReaction: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListReactions: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteReaction: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetSpaceReadState: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateSpaceReadState: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetThreadReadState: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalClient is an interface that defines the methods available from Google Chat API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateMessage(context.Context, *chatpb.CreateMessageRequest, ...gax.CallOption) (*chatpb.Message, error)
	ListMessages(context.Context, *chatpb.ListMessagesRequest, ...gax.CallOption) *MessageIterator
	ListMemberships(context.Context, *chatpb.ListMembershipsRequest, ...gax.CallOption) *MembershipIterator
	GetMembership(context.Context, *chatpb.GetMembershipRequest, ...gax.CallOption) (*chatpb.Membership, error)
	GetMessage(context.Context, *chatpb.GetMessageRequest, ...gax.CallOption) (*chatpb.Message, error)
	UpdateMessage(context.Context, *chatpb.UpdateMessageRequest, ...gax.CallOption) (*chatpb.Message, error)
	DeleteMessage(context.Context, *chatpb.DeleteMessageRequest, ...gax.CallOption) error
	GetAttachment(context.Context, *chatpb.GetAttachmentRequest, ...gax.CallOption) (*chatpb.Attachment, error)
	UploadAttachment(context.Context, *chatpb.UploadAttachmentRequest, ...gax.CallOption) (*chatpb.UploadAttachmentResponse, error)
	ListSpaces(context.Context, *chatpb.ListSpacesRequest, ...gax.CallOption) *SpaceIterator
	GetSpace(context.Context, *chatpb.GetSpaceRequest, ...gax.CallOption) (*chatpb.Space, error)
	CreateSpace(context.Context, *chatpb.CreateSpaceRequest, ...gax.CallOption) (*chatpb.Space, error)
	SetUpSpace(context.Context, *chatpb.SetUpSpaceRequest, ...gax.CallOption) (*chatpb.Space, error)
	UpdateSpace(context.Context, *chatpb.UpdateSpaceRequest, ...gax.CallOption) (*chatpb.Space, error)
	DeleteSpace(context.Context, *chatpb.DeleteSpaceRequest, ...gax.CallOption) error
	CompleteImportSpace(context.Context, *chatpb.CompleteImportSpaceRequest, ...gax.CallOption) (*chatpb.CompleteImportSpaceResponse, error)
	FindDirectMessage(context.Context, *chatpb.FindDirectMessageRequest, ...gax.CallOption) (*chatpb.Space, error)
	CreateMembership(context.Context, *chatpb.CreateMembershipRequest, ...gax.CallOption) (*chatpb.Membership, error)
	UpdateMembership(context.Context, *chatpb.UpdateMembershipRequest, ...gax.CallOption) (*chatpb.Membership, error)
	DeleteMembership(context.Context, *chatpb.DeleteMembershipRequest, ...gax.CallOption) (*chatpb.Membership, error)
	CreateReaction(context.Context, *chatpb.CreateReactionRequest, ...gax.CallOption) (*chatpb.Reaction, error)
	ListReactions(context.Context, *chatpb.ListReactionsRequest, ...gax.CallOption) *ReactionIterator
	DeleteReaction(context.Context, *chatpb.DeleteReactionRequest, ...gax.CallOption) error
	GetSpaceReadState(context.Context, *chatpb.GetSpaceReadStateRequest, ...gax.CallOption) (*chatpb.SpaceReadState, error)
	UpdateSpaceReadState(context.Context, *chatpb.UpdateSpaceReadStateRequest, ...gax.CallOption) (*chatpb.SpaceReadState, error)
	GetThreadReadState(context.Context, *chatpb.GetThreadReadStateRequest, ...gax.CallOption) (*chatpb.ThreadReadState, error)
}

// Client is a client for interacting with Google Chat API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Enables developers to build Chat apps and
// integrations on Google Chat Platform.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateMessage creates a message in a Google Chat space. The maximum message size,
// including text and cards, is 32,000 bytes. For an example, see Send a
// message (at https://developers.google.com/workspace/chat/create-messages).
//
// Calling this method requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize)
// and supports the following authentication types:
//
//	For text messages, user authentication or app authentication are
//	supported.
//
//	For card messages, only app authentication is supported. (Only Chat apps
//	can create card messages.)
func (c *Client) CreateMessage(ctx context.Context, req *chatpb.CreateMessageRequest, opts ...gax.CallOption) (*chatpb.Message, error) {
	return c.internalClient.CreateMessage(ctx, req, opts...)
}

// ListMessages lists messages in a space that the caller is a member of, including
// messages from blocked members and spaces. For an example, see
// List messages (at /chat/api/guides/v1/messages/list).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) ListMessages(ctx context.Context, req *chatpb.ListMessagesRequest, opts ...gax.CallOption) *MessageIterator {
	return c.internalClient.ListMessages(ctx, req, opts...)
}

// ListMemberships lists memberships in a space. For an example, see List users and Google
// Chat apps in a
// space (at https://developers.google.com/workspace/chat/list-members). Listing
// memberships with app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// lists memberships in spaces that the Chat app has
// access to, but excludes Chat app memberships,
// including its own. Listing memberships with
// User
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
// lists memberships in spaces that the authenticated user has access to.
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) ListMemberships(ctx context.Context, req *chatpb.ListMembershipsRequest, opts ...gax.CallOption) *MembershipIterator {
	return c.internalClient.ListMemberships(ctx, req, opts...)
}

// GetMembership returns details about a membership. For an example, see
// Get details about a user’s or Google Chat app’s
// membership (at https://developers.google.com/workspace/chat/get-members).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) GetMembership(ctx context.Context, req *chatpb.GetMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	return c.internalClient.GetMembership(ctx, req, opts...)
}

// GetMessage returns details about a message.
// For an example, see Get details about a
// message (at https://developers.google.com/workspace/chat/get-messages).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
//
// Note: Might return a message from a blocked member or space.
func (c *Client) GetMessage(ctx context.Context, req *chatpb.GetMessageRequest, opts ...gax.CallOption) (*chatpb.Message, error) {
	return c.internalClient.GetMessage(ctx, req, opts...)
}

// UpdateMessage updates a message. There’s a difference between the patch and update
// methods. The patch
// method uses a patch request while the update method uses a put
// request. We recommend using the patch method. For an example, see
// Update a
// message (at https://developers.google.com/workspace/chat/update-messages).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
// When using app authentication, requests can only update messages
// created by the calling Chat app.
func (c *Client) UpdateMessage(ctx context.Context, req *chatpb.UpdateMessageRequest, opts ...gax.CallOption) (*chatpb.Message, error) {
	return c.internalClient.UpdateMessage(ctx, req, opts...)
}

// DeleteMessage deletes a message.
// For an example, see Delete a
// message (at https://developers.google.com/workspace/chat/delete-messages).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
// When using app authentication, requests can only delete messages
// created by the calling Chat app.
func (c *Client) DeleteMessage(ctx context.Context, req *chatpb.DeleteMessageRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteMessage(ctx, req, opts...)
}

// GetAttachment gets the metadata of a message attachment. The attachment data is fetched
// using the media
// API (at https://developers.google.com/workspace/chat/api/reference/rest/v1/media/download).
// For an example, see
// Get metadata about a message
// attachment (at https://developers.google.com/workspace/chat/get-media-attachments).
// Requires app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
func (c *Client) GetAttachment(ctx context.Context, req *chatpb.GetAttachmentRequest, opts ...gax.CallOption) (*chatpb.Attachment, error) {
	return c.internalClient.GetAttachment(ctx, req, opts...)
}

// UploadAttachment uploads an attachment. For an example, see
// Upload media as a file
// attachment (at https://developers.google.com/workspace/chat/upload-media-attachments).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
//
// You can upload attachments up to 200 MB. Certain file types aren’t
// supported. For details, see File types blocked by Google
// Chat (at https://support.google.com/chat/answer/7651457?&co=GENIE.Platform%3DDesktop#File%20types%20blocked%20in%20Google%20Chat).
func (c *Client) UploadAttachment(ctx context.Context, req *chatpb.UploadAttachmentRequest, opts ...gax.CallOption) (*chatpb.UploadAttachmentResponse, error) {
	return c.internalClient.UploadAttachment(ctx, req, opts...)
}

// ListSpaces lists spaces the caller is a member of. Group chats and DMs aren’t listed
// until the first message is sent. For an example, see
// List
// spaces (at https://developers.google.com/workspace/chat/list-spaces).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
//
// Lists spaces visible to the caller or authenticated user. Group chats
// and DMs aren’t listed until the first message is sent.
func (c *Client) ListSpaces(ctx context.Context, req *chatpb.ListSpacesRequest, opts ...gax.CallOption) *SpaceIterator {
	return c.internalClient.ListSpaces(ctx, req, opts...)
}

// GetSpace returns details about a space. For an example, see
// Get details about a
// space (at https://developers.google.com/workspace/chat/get-spaces).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) GetSpace(ctx context.Context, req *chatpb.GetSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	return c.internalClient.GetSpace(ctx, req, opts...)
}

// CreateSpace creates a named space. Spaces grouped by topics aren’t supported. For an
// example, see Create a
// space (at https://developers.google.com/workspace/chat/create-spaces).
//
// If you receive the error message ALREADY_EXISTS when creating
// a space, try a different displayName. An existing space within
// the Google Workspace organization might already use this display name.
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) CreateSpace(ctx context.Context, req *chatpb.CreateSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	return c.internalClient.CreateSpace(ctx, req, opts...)
}

// SetUpSpace creates a space and adds specified users to it. The calling user is
// automatically added to the space, and shouldn’t be specified as a
// membership in the request. For an example, see
// Set up a space with initial
// members (at https://developers.google.com/workspace/chat/set-up-spaces).
//
// To specify the human members to add, add memberships with the appropriate
// membership.member.name. To add a human user, use users/{user}, where
// {user} can be the email address for the user. For users in the same
// Workspace organization {user} can also be the id for the person from
// the People API, or the id for the user in the Directory API. For example,
// if the People API Person profile ID for user@example.com is 123456789,
// you can add the user to the space by setting the membership.member.name
// to users/user@example.com or users/123456789.
//
// For a named space or group chat, if the caller blocks, or is blocked
// by some members, or doesn’t have permission to add some members, then
// those members aren’t added to the created space.
//
// To create a direct message (DM) between the calling user and another human
// user, specify exactly one membership to represent the human user. If
// one user blocks the other, the request fails and the DM isn’t created.
//
// To create a DM between the calling user and the calling app, set
// Space.singleUserBotDm to true and don’t specify any memberships. You
// can only use this method to set up a DM with the calling app. To add the
// calling app as a member of a space or an existing DM between two human
// users, see
// Invite or add a user or app to a
// space (at https://developers.google.com/workspace/chat/create-members).
//
// If a DM already exists between two users, even when one user blocks the
// other at the time a request is made, then the existing DM is returned.
//
// Spaces with threaded replies aren’t supported. If you receive the error
// message ALREADY_EXISTS when setting up a space, try a different
// displayName. An existing space within the Google Workspace organization
// might already use this display name.
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) SetUpSpace(ctx context.Context, req *chatpb.SetUpSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	return c.internalClient.SetUpSpace(ctx, req, opts...)
}

// UpdateSpace updates a space. For an example, see
// Update a
// space (at https://developers.google.com/workspace/chat/update-spaces).
//
// If you’re updating the displayName field and receive the error message
// ALREADY_EXISTS, try a different display name… An existing space within
// the Google Workspace organization might already use this display name.
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) UpdateSpace(ctx context.Context, req *chatpb.UpdateSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	return c.internalClient.UpdateSpace(ctx, req, opts...)
}

// DeleteSpace deletes a named space. Always performs a cascading delete, which means
// that the space’s child resources—like messages posted in the space and
// memberships in the space—are also deleted. For an example, see
// Delete a
// space (at https://developers.google.com/workspace/chat/delete-spaces).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
// from a user who has permission to delete the space.
func (c *Client) DeleteSpace(ctx context.Context, req *chatpb.DeleteSpaceRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteSpace(ctx, req, opts...)
}

// CompleteImportSpace completes the
// import process (at https://developers.google.com/workspace/chat/import-data)
// for the specified space and makes it visible to users.
// Requires app authentication and domain-wide delegation. For more
// information, see Authorize Google Chat apps to import
// data (at https://developers.google.com/workspace/chat/authorize-import).
func (c *Client) CompleteImportSpace(ctx context.Context, req *chatpb.CompleteImportSpaceRequest, opts ...gax.CallOption) (*chatpb.CompleteImportSpaceResponse, error) {
	return c.internalClient.CompleteImportSpace(ctx, req, opts...)
}

// FindDirectMessage returns the existing direct message with the specified user. If no direct
// message space is found, returns a 404 NOT_FOUND error. For an example,
// see
// Find a direct message (at /chat/api/guides/v1/spaces/find-direct-message).
//
// With user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
// returns the direct message space between the specified user and the
// authenticated user.
//
// With app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app),
// returns the direct message space between the specified user and the calling
// Chat app.
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
// or app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
func (c *Client) FindDirectMessage(ctx context.Context, req *chatpb.FindDirectMessageRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	return c.internalClient.FindDirectMessage(ctx, req, opts...)
}

// CreateMembership creates a human membership or app membership for the calling app. Creating
// memberships for other apps isn’t supported. For an example, see
// Invite or add a user or a Google Chat app to a
// space (at https://developers.google.com/workspace/chat/create-members).
// When creating a membership, if the specified member has their auto-accept
// policy turned off, then they’re invited, and must accept the space
// invitation before joining. Otherwise, creating a membership adds the member
// directly to the specified space. Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
//
// To specify the member to add, set the membership.member.name for the
// human or app member.
//
//	To add the calling app to a space or a direct message between two human
//	users, use users/app. Unable to add other
//	apps to the space.
//
//	To add a human user, use users/{user}, where {user} can be the email
//	address for the user. For users in the same Workspace organization {user}
//	can also be the id for the person from the People API, or the id for
//	the user in the Directory API. For example, if the People API Person
//	profile ID for user@example.com is 123456789, you can add the user to
//	the space by setting the membership.member.name to
//	users/user@example.com or users/123456789.
func (c *Client) CreateMembership(ctx context.Context, req *chatpb.CreateMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	return c.internalClient.CreateMembership(ctx, req, opts...)
}

// UpdateMembership updates a membership. For an example, see Update a user’s membership in
// a space (at https://developers.google.com/workspace/chat/update-members).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) UpdateMembership(ctx context.Context, req *chatpb.UpdateMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	return c.internalClient.UpdateMembership(ctx, req, opts...)
}

// DeleteMembership deletes a membership. For an example, see
// Remove a user or a Google Chat app from a
// space (at https://developers.google.com/workspace/chat/delete-members).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) DeleteMembership(ctx context.Context, req *chatpb.DeleteMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	return c.internalClient.DeleteMembership(ctx, req, opts...)
}

// CreateReaction creates a reaction and adds it to a message. Only unicode emojis are
// supported. For an example, see
// Add a reaction to a
// message (at https://developers.google.com/workspace/chat/create-reactions).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) CreateReaction(ctx context.Context, req *chatpb.CreateReactionRequest, opts ...gax.CallOption) (*chatpb.Reaction, error) {
	return c.internalClient.CreateReaction(ctx, req, opts...)
}

// ListReactions lists reactions to a message. For an example, see
// List reactions for a
// message (at https://developers.google.com/workspace/chat/list-reactions).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) ListReactions(ctx context.Context, req *chatpb.ListReactionsRequest, opts ...gax.CallOption) *ReactionIterator {
	return c.internalClient.ListReactions(ctx, req, opts...)
}

// DeleteReaction deletes a reaction to a message. Only unicode emojis are supported.
// For an example, see
// Delete a
// reaction (at https://developers.google.com/workspace/chat/delete-reactions).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) DeleteReaction(ctx context.Context, req *chatpb.DeleteReactionRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteReaction(ctx, req, opts...)
}

// GetSpaceReadState returns details about a user’s read state within a space, used to identify
// read and unread messages. For an example, see Get details about a user’s
// space read
// state (at https://developers.google.com/workspace/chat/get-space-read-state).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) GetSpaceReadState(ctx context.Context, req *chatpb.GetSpaceReadStateRequest, opts ...gax.CallOption) (*chatpb.SpaceReadState, error) {
	return c.internalClient.GetSpaceReadState(ctx, req, opts...)
}

// UpdateSpaceReadState updates a user’s read state within a space, used to identify read and
// unread messages. For an example, see Update a user’s space read
// state (at https://developers.google.com/workspace/chat/update-space-read-state).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) UpdateSpaceReadState(ctx context.Context, req *chatpb.UpdateSpaceReadStateRequest, opts ...gax.CallOption) (*chatpb.SpaceReadState, error) {
	return c.internalClient.UpdateSpaceReadState(ctx, req, opts...)
}

// GetThreadReadState returns details about a user’s read state within a thread, used to identify
// read and unread messages. For an example, see Get details about a user’s
// thread read
// state (at https://developers.google.com/workspace/chat/get-thread-read-state).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *Client) GetThreadReadState(ctx context.Context, req *chatpb.GetThreadReadStateRequest, opts ...gax.CallOption) (*chatpb.ThreadReadState, error) {
	return c.internalClient.GetThreadReadState(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Google Chat API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client chatpb.ChatServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewClient creates a new chat service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Enables developers to build Chat apps and
// integrations on Google Chat Platform.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:    connPool,
		client:      chatpb.NewChatServiceClient(connPool),
		CallOptions: &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions
}

// NewRESTClient creates a new chat service rest client.
//
// Enables developers to build Chat apps and
// integrations on Google Chat Platform.
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://chat.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://chat.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://chat.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://chat.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) CreateMessage(ctx context.Context, req *chatpb.CreateMessageRequest, opts ...gax.CallOption) (*chatpb.Message, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateMessage[0:len((*c.CallOptions).CreateMessage):len((*c.CallOptions).CreateMessage)], opts...)
	var resp *chatpb.Message
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateMessage(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListMessages(ctx context.Context, req *chatpb.ListMessagesRequest, opts ...gax.CallOption) *MessageIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListMessages[0:len((*c.CallOptions).ListMessages):len((*c.CallOptions).ListMessages)], opts...)
	it := &MessageIterator{}
	req = proto.Clone(req).(*chatpb.ListMessagesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*chatpb.Message, string, error) {
		resp := &chatpb.ListMessagesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListMessages(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetMessages(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) ListMemberships(ctx context.Context, req *chatpb.ListMembershipsRequest, opts ...gax.CallOption) *MembershipIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListMemberships[0:len((*c.CallOptions).ListMemberships):len((*c.CallOptions).ListMemberships)], opts...)
	it := &MembershipIterator{}
	req = proto.Clone(req).(*chatpb.ListMembershipsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*chatpb.Membership, string, error) {
		resp := &chatpb.ListMembershipsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListMemberships(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetMemberships(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetMembership(ctx context.Context, req *chatpb.GetMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetMembership[0:len((*c.CallOptions).GetMembership):len((*c.CallOptions).GetMembership)], opts...)
	var resp *chatpb.Membership
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetMembership(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetMessage(ctx context.Context, req *chatpb.GetMessageRequest, opts ...gax.CallOption) (*chatpb.Message, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetMessage[0:len((*c.CallOptions).GetMessage):len((*c.CallOptions).GetMessage)], opts...)
	var resp *chatpb.Message
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetMessage(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateMessage(ctx context.Context, req *chatpb.UpdateMessageRequest, opts ...gax.CallOption) (*chatpb.Message, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "message.name", url.QueryEscape(req.GetMessage().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateMessage[0:len((*c.CallOptions).UpdateMessage):len((*c.CallOptions).UpdateMessage)], opts...)
	var resp *chatpb.Message
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateMessage(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteMessage(ctx context.Context, req *chatpb.DeleteMessageRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteMessage[0:len((*c.CallOptions).DeleteMessage):len((*c.CallOptions).DeleteMessage)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteMessage(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetAttachment(ctx context.Context, req *chatpb.GetAttachmentRequest, opts ...gax.CallOption) (*chatpb.Attachment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAttachment[0:len((*c.CallOptions).GetAttachment):len((*c.CallOptions).GetAttachment)], opts...)
	var resp *chatpb.Attachment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetAttachment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UploadAttachment(ctx context.Context, req *chatpb.UploadAttachmentRequest, opts ...gax.CallOption) (*chatpb.UploadAttachmentResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UploadAttachment[0:len((*c.CallOptions).UploadAttachment):len((*c.CallOptions).UploadAttachment)], opts...)
	var resp *chatpb.UploadAttachmentResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UploadAttachment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListSpaces(ctx context.Context, req *chatpb.ListSpacesRequest, opts ...gax.CallOption) *SpaceIterator {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).ListSpaces[0:len((*c.CallOptions).ListSpaces):len((*c.CallOptions).ListSpaces)], opts...)
	it := &SpaceIterator{}
	req = proto.Clone(req).(*chatpb.ListSpacesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*chatpb.Space, string, error) {
		resp := &chatpb.ListSpacesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListSpaces(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSpaces(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetSpace(ctx context.Context, req *chatpb.GetSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSpace[0:len((*c.CallOptions).GetSpace):len((*c.CallOptions).GetSpace)], opts...)
	var resp *chatpb.Space
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetSpace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateSpace(ctx context.Context, req *chatpb.CreateSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).CreateSpace[0:len((*c.CallOptions).CreateSpace):len((*c.CallOptions).CreateSpace)], opts...)
	var resp *chatpb.Space
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateSpace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) SetUpSpace(ctx context.Context, req *chatpb.SetUpSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).SetUpSpace[0:len((*c.CallOptions).SetUpSpace):len((*c.CallOptions).SetUpSpace)], opts...)
	var resp *chatpb.Space
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.SetUpSpace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateSpace(ctx context.Context, req *chatpb.UpdateSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "space.name", url.QueryEscape(req.GetSpace().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSpace[0:len((*c.CallOptions).UpdateSpace):len((*c.CallOptions).UpdateSpace)], opts...)
	var resp *chatpb.Space
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateSpace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteSpace(ctx context.Context, req *chatpb.DeleteSpaceRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSpace[0:len((*c.CallOptions).DeleteSpace):len((*c.CallOptions).DeleteSpace)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteSpace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) CompleteImportSpace(ctx context.Context, req *chatpb.CompleteImportSpaceRequest, opts ...gax.CallOption) (*chatpb.CompleteImportSpaceResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CompleteImportSpace[0:len((*c.CallOptions).CompleteImportSpace):len((*c.CallOptions).CompleteImportSpace)], opts...)
	var resp *chatpb.CompleteImportSpaceResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CompleteImportSpace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) FindDirectMessage(ctx context.Context, req *chatpb.FindDirectMessageRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).FindDirectMessage[0:len((*c.CallOptions).FindDirectMessage):len((*c.CallOptions).FindDirectMessage)], opts...)
	var resp *chatpb.Space
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.FindDirectMessage(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateMembership(ctx context.Context, req *chatpb.CreateMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateMembership[0:len((*c.CallOptions).CreateMembership):len((*c.CallOptions).CreateMembership)], opts...)
	var resp *chatpb.Membership
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateMembership(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateMembership(ctx context.Context, req *chatpb.UpdateMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "membership.name", url.QueryEscape(req.GetMembership().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateMembership[0:len((*c.CallOptions).UpdateMembership):len((*c.CallOptions).UpdateMembership)], opts...)
	var resp *chatpb.Membership
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateMembership(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteMembership(ctx context.Context, req *chatpb.DeleteMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteMembership[0:len((*c.CallOptions).DeleteMembership):len((*c.CallOptions).DeleteMembership)], opts...)
	var resp *chatpb.Membership
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteMembership(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateReaction(ctx context.Context, req *chatpb.CreateReactionRequest, opts ...gax.CallOption) (*chatpb.Reaction, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateReaction[0:len((*c.CallOptions).CreateReaction):len((*c.CallOptions).CreateReaction)], opts...)
	var resp *chatpb.Reaction
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateReaction(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListReactions(ctx context.Context, req *chatpb.ListReactionsRequest, opts ...gax.CallOption) *ReactionIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListReactions[0:len((*c.CallOptions).ListReactions):len((*c.CallOptions).ListReactions)], opts...)
	it := &ReactionIterator{}
	req = proto.Clone(req).(*chatpb.ListReactionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*chatpb.Reaction, string, error) {
		resp := &chatpb.ListReactionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListReactions(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetReactions(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) DeleteReaction(ctx context.Context, req *chatpb.DeleteReactionRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteReaction[0:len((*c.CallOptions).DeleteReaction):len((*c.CallOptions).DeleteReaction)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteReaction(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetSpaceReadState(ctx context.Context, req *chatpb.GetSpaceReadStateRequest, opts ...gax.CallOption) (*chatpb.SpaceReadState, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSpaceReadState[0:len((*c.CallOptions).GetSpaceReadState):len((*c.CallOptions).GetSpaceReadState)], opts...)
	var resp *chatpb.SpaceReadState
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetSpaceReadState(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateSpaceReadState(ctx context.Context, req *chatpb.UpdateSpaceReadStateRequest, opts ...gax.CallOption) (*chatpb.SpaceReadState, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "space_read_state.name", url.QueryEscape(req.GetSpaceReadState().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSpaceReadState[0:len((*c.CallOptions).UpdateSpaceReadState):len((*c.CallOptions).UpdateSpaceReadState)], opts...)
	var resp *chatpb.SpaceReadState
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateSpaceReadState(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetThreadReadState(ctx context.Context, req *chatpb.GetThreadReadStateRequest, opts ...gax.CallOption) (*chatpb.ThreadReadState, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetThreadReadState[0:len((*c.CallOptions).GetThreadReadState):len((*c.CallOptions).GetThreadReadState)], opts...)
	var resp *chatpb.ThreadReadState
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetThreadReadState(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateMessage creates a message in a Google Chat space. The maximum message size,
// including text and cards, is 32,000 bytes. For an example, see Send a
// message (at https://developers.google.com/workspace/chat/create-messages).
//
// Calling this method requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize)
// and supports the following authentication types:
//
//	For text messages, user authentication or app authentication are
//	supported.
//
//	For card messages, only app authentication is supported. (Only Chat apps
//	can create card messages.)
func (c *restClient) CreateMessage(ctx context.Context, req *chatpb.CreateMessageRequest, opts ...gax.CallOption) (*chatpb.Message, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMessage()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/messages", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetMessageId() != "" {
		params.Add("messageId", fmt.Sprintf("%v", req.GetMessageId()))
	}
	if req.GetMessageReplyOption() != 0 {
		params.Add("messageReplyOption", fmt.Sprintf("%v", req.GetMessageReplyOption()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetThreadKey() != "" {
		params.Add("threadKey", fmt.Sprintf("%v", req.GetThreadKey()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateMessage[0:len((*c.CallOptions).CreateMessage):len((*c.CallOptions).CreateMessage)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Message{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListMessages lists messages in a space that the caller is a member of, including
// messages from blocked members and spaces. For an example, see
// List messages (at /chat/api/guides/v1/messages/list).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) ListMessages(ctx context.Context, req *chatpb.ListMessagesRequest, opts ...gax.CallOption) *MessageIterator {
	it := &MessageIterator{}
	req = proto.Clone(req).(*chatpb.ListMessagesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*chatpb.Message, string, error) {
		resp := &chatpb.ListMessagesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/messages", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetShowDeleted() {
			params.Add("showDeleted", fmt.Sprintf("%v", req.GetShowDeleted()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetMessages(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListMemberships lists memberships in a space. For an example, see List users and Google
// Chat apps in a
// space (at https://developers.google.com/workspace/chat/list-members). Listing
// memberships with app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// lists memberships in spaces that the Chat app has
// access to, but excludes Chat app memberships,
// including its own. Listing memberships with
// User
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
// lists memberships in spaces that the authenticated user has access to.
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) ListMemberships(ctx context.Context, req *chatpb.ListMembershipsRequest, opts ...gax.CallOption) *MembershipIterator {
	it := &MembershipIterator{}
	req = proto.Clone(req).(*chatpb.ListMembershipsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*chatpb.Membership, string, error) {
		resp := &chatpb.ListMembershipsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/members", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetShowGroups() {
			params.Add("showGroups", fmt.Sprintf("%v", req.GetShowGroups()))
		}
		if req.GetShowInvited() {
			params.Add("showInvited", fmt.Sprintf("%v", req.GetShowInvited()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetMemberships(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetMembership returns details about a membership. For an example, see
// Get details about a user’s or Google Chat app’s
// membership (at https://developers.google.com/workspace/chat/get-members).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) GetMembership(ctx context.Context, req *chatpb.GetMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetMembership[0:len((*c.CallOptions).GetMembership):len((*c.CallOptions).GetMembership)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Membership{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetMessage returns details about a message.
// For an example, see Get details about a
// message (at https://developers.google.com/workspace/chat/get-messages).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
//
// Note: Might return a message from a blocked member or space.
func (c *restClient) GetMessage(ctx context.Context, req *chatpb.GetMessageRequest, opts ...gax.CallOption) (*chatpb.Message, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetMessage[0:len((*c.CallOptions).GetMessage):len((*c.CallOptions).GetMessage)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Message{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateMessage updates a message. There’s a difference between the patch and update
// methods. The patch
// method uses a patch request while the update method uses a put
// request. We recommend using the patch method. For an example, see
// Update a
// message (at https://developers.google.com/workspace/chat/update-messages).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
// When using app authentication, requests can only update messages
// created by the calling Chat app.
func (c *restClient) UpdateMessage(ctx context.Context, req *chatpb.UpdateMessageRequest, opts ...gax.CallOption) (*chatpb.Message, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMessage()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetMessage().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetAllowMissing() {
		params.Add("allowMissing", fmt.Sprintf("%v", req.GetAllowMissing()))
	}
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "message.name", url.QueryEscape(req.GetMessage().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateMessage[0:len((*c.CallOptions).UpdateMessage):len((*c.CallOptions).UpdateMessage)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Message{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PUT", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteMessage deletes a message.
// For an example, see Delete a
// message (at https://developers.google.com/workspace/chat/delete-messages).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
// When using app authentication, requests can only delete messages
// created by the calling Chat app.
func (c *restClient) DeleteMessage(ctx context.Context, req *chatpb.DeleteMessageRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// GetAttachment gets the metadata of a message attachment. The attachment data is fetched
// using the media
// API (at https://developers.google.com/workspace/chat/api/reference/rest/v1/media/download).
// For an example, see
// Get metadata about a message
// attachment (at https://developers.google.com/workspace/chat/get-media-attachments).
// Requires app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
func (c *restClient) GetAttachment(ctx context.Context, req *chatpb.GetAttachmentRequest, opts ...gax.CallOption) (*chatpb.Attachment, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetAttachment[0:len((*c.CallOptions).GetAttachment):len((*c.CallOptions).GetAttachment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Attachment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UploadAttachment uploads an attachment. For an example, see
// Upload media as a file
// attachment (at https://developers.google.com/workspace/chat/upload-media-attachments).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
//
// You can upload attachments up to 200 MB. Certain file types aren’t
// supported. For details, see File types blocked by Google
// Chat (at https://support.google.com/chat/answer/7651457?&co=GENIE.Platform%3DDesktop#File%20types%20blocked%20in%20Google%20Chat).
func (c *restClient) UploadAttachment(ctx context.Context, req *chatpb.UploadAttachmentRequest, opts ...gax.CallOption) (*chatpb.UploadAttachmentResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/attachments:upload", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UploadAttachment[0:len((*c.CallOptions).UploadAttachment):len((*c.CallOptions).UploadAttachment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.UploadAttachmentResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListSpaces lists spaces the caller is a member of. Group chats and DMs aren’t listed
// until the first message is sent. For an example, see
// List
// spaces (at https://developers.google.com/workspace/chat/list-spaces).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
//
// Lists spaces visible to the caller or authenticated user. Group chats
// and DMs aren’t listed until the first message is sent.
func (c *restClient) ListSpaces(ctx context.Context, req *chatpb.ListSpacesRequest, opts ...gax.CallOption) *SpaceIterator {
	it := &SpaceIterator{}
	req = proto.Clone(req).(*chatpb.ListSpacesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*chatpb.Space, string, error) {
		resp := &chatpb.ListSpacesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/spaces")

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSpaces(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetSpace returns details about a space. For an example, see
// Get details about a
// space (at https://developers.google.com/workspace/chat/get-spaces).
//
// Requires
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize).
// Supports
// app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
// and user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) GetSpace(ctx context.Context, req *chatpb.GetSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSpace[0:len((*c.CallOptions).GetSpace):len((*c.CallOptions).GetSpace)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Space{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateSpace creates a named space. Spaces grouped by topics aren’t supported. For an
// example, see Create a
// space (at https://developers.google.com/workspace/chat/create-spaces).
//
// If you receive the error message ALREADY_EXISTS when creating
// a space, try a different displayName. An existing space within
// the Google Workspace organization might already use this display name.
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) CreateSpace(ctx context.Context, req *chatpb.CreateSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSpace()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/spaces")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateSpace[0:len((*c.CallOptions).CreateSpace):len((*c.CallOptions).CreateSpace)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Space{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// SetUpSpace creates a space and adds specified users to it. The calling user is
// automatically added to the space, and shouldn’t be specified as a
// membership in the request. For an example, see
// Set up a space with initial
// members (at https://developers.google.com/workspace/chat/set-up-spaces).
//
// To specify the human members to add, add memberships with the appropriate
// membership.member.name. To add a human user, use users/{user}, where
// {user} can be the email address for the user. For users in the same
// Workspace organization {user} can also be the id for the person from
// the People API, or the id for the user in the Directory API. For example,
// if the People API Person profile ID for user@example.com is 123456789,
// you can add the user to the space by setting the membership.member.name
// to users/user@example.com or users/123456789.
//
// For a named space or group chat, if the caller blocks, or is blocked
// by some members, or doesn’t have permission to add some members, then
// those members aren’t added to the created space.
//
// To create a direct message (DM) between the calling user and another human
// user, specify exactly one membership to represent the human user. If
// one user blocks the other, the request fails and the DM isn’t created.
//
// To create a DM between the calling user and the calling app, set
// Space.singleUserBotDm to true and don’t specify any memberships. You
// can only use this method to set up a DM with the calling app. To add the
// calling app as a member of a space or an existing DM between two human
// users, see
// Invite or add a user or app to a
// space (at https://developers.google.com/workspace/chat/create-members).
//
// If a DM already exists between two users, even when one user blocks the
// other at the time a request is made, then the existing DM is returned.
//
// Spaces with threaded replies aren’t supported. If you receive the error
// message ALREADY_EXISTS when setting up a space, try a different
// displayName. An existing space within the Google Workspace organization
// might already use this display name.
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) SetUpSpace(ctx context.Context, req *chatpb.SetUpSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/spaces:setup")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).SetUpSpace[0:len((*c.CallOptions).SetUpSpace):len((*c.CallOptions).SetUpSpace)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Space{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateSpace updates a space. For an example, see
// Update a
// space (at https://developers.google.com/workspace/chat/update-spaces).
//
// If you’re updating the displayName field and receive the error message
// ALREADY_EXISTS, try a different display name… An existing space within
// the Google Workspace organization might already use this display name.
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) UpdateSpace(ctx context.Context, req *chatpb.UpdateSpaceRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSpace()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSpace().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "space.name", url.QueryEscape(req.GetSpace().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSpace[0:len((*c.CallOptions).UpdateSpace):len((*c.CallOptions).UpdateSpace)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Space{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteSpace deletes a named space. Always performs a cascading delete, which means
// that the space’s child resources—like messages posted in the space and
// memberships in the space—are also deleted. For an example, see
// Delete a
// space (at https://developers.google.com/workspace/chat/delete-spaces).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
// from a user who has permission to delete the space.
func (c *restClient) DeleteSpace(ctx context.Context, req *chatpb.DeleteSpaceRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// CompleteImportSpace completes the
// import process (at https://developers.google.com/workspace/chat/import-data)
// for the specified space and makes it visible to users.
// Requires app authentication and domain-wide delegation. For more
// information, see Authorize Google Chat apps to import
// data (at https://developers.google.com/workspace/chat/authorize-import).
func (c *restClient) CompleteImportSpace(ctx context.Context, req *chatpb.CompleteImportSpaceRequest, opts ...gax.CallOption) (*chatpb.CompleteImportSpaceResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:completeImport", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CompleteImportSpace[0:len((*c.CallOptions).CompleteImportSpace):len((*c.CallOptions).CompleteImportSpace)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.CompleteImportSpaceResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// FindDirectMessage returns the existing direct message with the specified user. If no direct
// message space is found, returns a 404 NOT_FOUND error. For an example,
// see
// Find a direct message (at /chat/api/guides/v1/spaces/find-direct-message).
//
// With user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
// returns the direct message space between the specified user and the
// authenticated user.
//
// With app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app),
// returns the direct message space between the specified user and the calling
// Chat app.
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
// or app
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
func (c *restClient) FindDirectMessage(ctx context.Context, req *chatpb.FindDirectMessageRequest, opts ...gax.CallOption) (*chatpb.Space, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/spaces:findDirectMessage")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("name", fmt.Sprintf("%v", req.GetName()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).FindDirectMessage[0:len((*c.CallOptions).FindDirectMessage):len((*c.CallOptions).FindDirectMessage)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Space{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateMembership creates a human membership or app membership for the calling app. Creating
// memberships for other apps isn’t supported. For an example, see
// Invite or add a user or a Google Chat app to a
// space (at https://developers.google.com/workspace/chat/create-members).
// When creating a membership, if the specified member has their auto-accept
// policy turned off, then they’re invited, and must accept the space
// invitation before joining. Otherwise, creating a membership adds the member
// directly to the specified space. Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
//
// To specify the member to add, set the membership.member.name for the
// human or app member.
//
//	To add the calling app to a space or a direct message between two human
//	users, use users/app. Unable to add other
//	apps to the space.
//
//	To add a human user, use users/{user}, where {user} can be the email
//	address for the user. For users in the same Workspace organization {user}
//	can also be the id for the person from the People API, or the id for
//	the user in the Directory API. For example, if the People API Person
//	profile ID for user@example.com is 123456789, you can add the user to
//	the space by setting the membership.member.name to
//	users/user@example.com or users/123456789.
func (c *restClient) CreateMembership(ctx context.Context, req *chatpb.CreateMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMembership()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/members", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateMembership[0:len((*c.CallOptions).CreateMembership):len((*c.CallOptions).CreateMembership)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Membership{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateMembership updates a membership. For an example, see Update a user’s membership in
// a space (at https://developers.google.com/workspace/chat/update-members).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) UpdateMembership(ctx context.Context, req *chatpb.UpdateMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMembership()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetMembership().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "membership.name", url.QueryEscape(req.GetMembership().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateMembership[0:len((*c.CallOptions).UpdateMembership):len((*c.CallOptions).UpdateMembership)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Membership{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteMembership deletes a membership. For an example, see
// Remove a user or a Google Chat app from a
// space (at https://developers.google.com/workspace/chat/delete-members).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) DeleteMembership(ctx context.Context, req *chatpb.DeleteMembershipRequest, opts ...gax.CallOption) (*chatpb.Membership, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).DeleteMembership[0:len((*c.CallOptions).DeleteMembership):len((*c.CallOptions).DeleteMembership)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Membership{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateReaction creates a reaction and adds it to a message. Only unicode emojis are
// supported. For an example, see
// Add a reaction to a
// message (at https://developers.google.com/workspace/chat/create-reactions).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) CreateReaction(ctx context.Context, req *chatpb.CreateReactionRequest, opts ...gax.CallOption) (*chatpb.Reaction, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetReaction()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/reactions", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateReaction[0:len((*c.CallOptions).CreateReaction):len((*c.CallOptions).CreateReaction)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.Reaction{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListReactions lists reactions to a message. For an example, see
// List reactions for a
// message (at https://developers.google.com/workspace/chat/list-reactions).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) ListReactions(ctx context.Context, req *chatpb.ListReactionsRequest, opts ...gax.CallOption) *ReactionIterator {
	it := &ReactionIterator{}
	req = proto.Clone(req).(*chatpb.ListReactionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*chatpb.Reaction, string, error) {
		resp := &chatpb.ListReactionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/reactions", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetReactions(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteReaction deletes a reaction to a message. Only unicode emojis are supported.
// For an example, see
// Delete a
// reaction (at https://developers.google.com/workspace/chat/delete-reactions).
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) DeleteReaction(ctx context.Context, req *chatpb.DeleteReactionRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// GetSpaceReadState returns details about a user’s read state within a space, used to identify
// read and unread messages. For an example, see Get details about a user’s
// space read
// state (at https://developers.google.com/workspace/chat/get-space-read-state).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) GetSpaceReadState(ctx context.Context, req *chatpb.GetSpaceReadStateRequest, opts ...gax.CallOption) (*chatpb.SpaceReadState, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSpaceReadState[0:len((*c.CallOptions).GetSpaceReadState):len((*c.CallOptions).GetSpaceReadState)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.SpaceReadState{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateSpaceReadState updates a user’s read state within a space, used to identify read and
// unread messages. For an example, see Update a user’s space read
// state (at https://developers.google.com/workspace/chat/update-space-read-state).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) UpdateSpaceReadState(ctx context.Context, req *chatpb.UpdateSpaceReadStateRequest, opts ...gax.CallOption) (*chatpb.SpaceReadState, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSpaceReadState()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSpaceReadState().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "space_read_state.name", url.QueryEscape(req.GetSpaceReadState().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSpaceReadState[0:len((*c.CallOptions).UpdateSpaceReadState):len((*c.CallOptions).UpdateSpaceReadState)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.SpaceReadState{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetThreadReadState returns details about a user’s read state within a thread, used to identify
// read and unread messages. For an example, see Get details about a user’s
// thread read
// state (at https://developers.google.com/workspace/chat/get-thread-read-state).
//
// Requires user
// authentication (at https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
func (c *restClient) GetThreadReadState(ctx context.Context, req *chatpb.GetThreadReadStateRequest, opts ...gax.CallOption) (*chatpb.ThreadReadState, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetThreadReadState[0:len((*c.CallOptions).GetThreadReadState):len((*c.CallOptions).GetThreadReadState)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &chatpb.ThreadReadState{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
