// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/osconfig/agentendpoint/v1/patch_jobs.proto

package agentendpointpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Post-patch reboot settings.
type PatchConfig_RebootConfig int32

const (
	// The default behavior is DEFAULT.
	PatchConfig_REBOOT_CONFIG_UNSPECIFIED PatchConfig_RebootConfig = 0
	// The agent decides if a reboot is necessary by checking
	// signals such as registry keys on Windows or `/var/run/reboot-required` on
	// APT based systems. On RPM based systems, a set of core system package
	// install times are compared with system boot time.
	PatchConfig_DEFAULT PatchConfig_RebootConfig = 1
	// Always reboot the machine after the update completes.
	PatchConfig_ALWAYS PatchConfig_RebootConfig = 2
	// Never reboot the machine after the update completes.
	PatchConfig_NEVER PatchConfig_RebootConfig = 3
)

// Enum value maps for PatchConfig_RebootConfig.
var (
	PatchConfig_RebootConfig_name = map[int32]string{
		0: "REBOOT_CONFIG_UNSPECIFIED",
		1: "DEFAULT",
		2: "ALWAYS",
		3: "NEVER",
	}
	PatchConfig_RebootConfig_value = map[string]int32{
		"REBOOT_CONFIG_UNSPECIFIED": 0,
		"DEFAULT":                   1,
		"ALWAYS":                    2,
		"NEVER":                     3,
	}
)

func (x PatchConfig_RebootConfig) Enum() *PatchConfig_RebootConfig {
	p := new(PatchConfig_RebootConfig)
	*p = x
	return p
}

func (x PatchConfig_RebootConfig) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PatchConfig_RebootConfig) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes[0].Descriptor()
}

func (PatchConfig_RebootConfig) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes[0]
}

func (x PatchConfig_RebootConfig) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PatchConfig_RebootConfig.Descriptor instead.
func (PatchConfig_RebootConfig) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{0, 0}
}

// Apt patch type.
type AptSettings_Type int32

const (
	// By default, upgrade will be performed.
	AptSettings_TYPE_UNSPECIFIED AptSettings_Type = 0
	// Runs `apt-get dist-upgrade`.
	AptSettings_DIST AptSettings_Type = 1
	// Runs `apt-get upgrade`.
	AptSettings_UPGRADE AptSettings_Type = 2
)

// Enum value maps for AptSettings_Type.
var (
	AptSettings_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "DIST",
		2: "UPGRADE",
	}
	AptSettings_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"DIST":             1,
		"UPGRADE":          2,
	}
)

func (x AptSettings_Type) Enum() *AptSettings_Type {
	p := new(AptSettings_Type)
	*p = x
	return p
}

func (x AptSettings_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AptSettings_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes[1].Descriptor()
}

func (AptSettings_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes[1]
}

func (x AptSettings_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AptSettings_Type.Descriptor instead.
func (AptSettings_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{1, 0}
}

// Microsoft Windows update classifications as defined in
// [1]
// https://support.microsoft.com/en-us/help/824684/description-of-the-standard-terminology-that-is-used-to-describe-micro
type WindowsUpdateSettings_Classification int32

const (
	// Invalid. If classifications are included, they must be specified.
	WindowsUpdateSettings_CLASSIFICATION_UNSPECIFIED WindowsUpdateSettings_Classification = 0
	// "A widely released fix for a specific problem that addresses a critical,
	// non-security-related bug." [1]
	WindowsUpdateSettings_CRITICAL WindowsUpdateSettings_Classification = 1
	// "A widely released fix for a product-specific, security-related
	// vulnerability. Security vulnerabilities are rated by their severity. The
	// severity rating is indicated in the Microsoft security bulletin as
	// critical, important, moderate, or low." [1]
	WindowsUpdateSettings_SECURITY WindowsUpdateSettings_Classification = 2
	// "A widely released and frequent software update that contains additions
	// to a product’s definition database. Definition databases are often used
	// to detect objects that have specific attributes, such as malicious code,
	// phishing websites, or junk mail." [1]
	WindowsUpdateSettings_DEFINITION WindowsUpdateSettings_Classification = 3
	// "Software that controls the input and output of a device." [1]
	WindowsUpdateSettings_DRIVER WindowsUpdateSettings_Classification = 4
	// "New product functionality that is first distributed outside the context
	// of a product release and that is typically included in the next full
	// product release." [1]
	WindowsUpdateSettings_FEATURE_PACK WindowsUpdateSettings_Classification = 5
	// "A tested, cumulative set of all hotfixes, security updates, critical
	// updates, and updates. Additionally, service packs may contain additional
	// fixes for problems that are found internally since the release of the
	// product. Service packs my also contain a limited number of
	// customer-requested design changes or features." [1]
	WindowsUpdateSettings_SERVICE_PACK WindowsUpdateSettings_Classification = 6
	// "A utility or feature that helps complete a task or set of tasks." [1]
	WindowsUpdateSettings_TOOL WindowsUpdateSettings_Classification = 7
	// "A tested, cumulative set of hotfixes, security updates, critical
	// updates, and updates that are packaged together for easy deployment. A
	// rollup generally targets a specific area, such as security, or a
	// component of a product, such as Internet Information Services (IIS)." [1]
	WindowsUpdateSettings_UPDATE_ROLLUP WindowsUpdateSettings_Classification = 8
	// "A widely released fix for a specific problem. An update addresses a
	// noncritical, non-security-related bug." [1]
	WindowsUpdateSettings_UPDATE WindowsUpdateSettings_Classification = 9
)

// Enum value maps for WindowsUpdateSettings_Classification.
var (
	WindowsUpdateSettings_Classification_name = map[int32]string{
		0: "CLASSIFICATION_UNSPECIFIED",
		1: "CRITICAL",
		2: "SECURITY",
		3: "DEFINITION",
		4: "DRIVER",
		5: "FEATURE_PACK",
		6: "SERVICE_PACK",
		7: "TOOL",
		8: "UPDATE_ROLLUP",
		9: "UPDATE",
	}
	WindowsUpdateSettings_Classification_value = map[string]int32{
		"CLASSIFICATION_UNSPECIFIED": 0,
		"CRITICAL":                   1,
		"SECURITY":                   2,
		"DEFINITION":                 3,
		"DRIVER":                     4,
		"FEATURE_PACK":               5,
		"SERVICE_PACK":               6,
		"TOOL":                       7,
		"UPDATE_ROLLUP":              8,
		"UPDATE":                     9,
	}
)

func (x WindowsUpdateSettings_Classification) Enum() *WindowsUpdateSettings_Classification {
	p := new(WindowsUpdateSettings_Classification)
	*p = x
	return p
}

func (x WindowsUpdateSettings_Classification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WindowsUpdateSettings_Classification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes[2].Descriptor()
}

func (WindowsUpdateSettings_Classification) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes[2]
}

func (x WindowsUpdateSettings_Classification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WindowsUpdateSettings_Classification.Descriptor instead.
func (WindowsUpdateSettings_Classification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{5, 0}
}

// The interpreter used to execute the a file.
type ExecStepConfig_Interpreter int32

const (
	// Deprecated, defaults to NONE for compatibility reasons.
	ExecStepConfig_INTERPRETER_UNSPECIFIED ExecStepConfig_Interpreter = 0
	// Invalid for a Windows ExecStepConfig. For a Linux ExecStepConfig, the
	// interpreter will be parsed from the shebang line of the script if
	// unspecified.
	ExecStepConfig_NONE ExecStepConfig_Interpreter = 3
	// Indicates that the script will be run with /bin/sh on Linux and cmd
	// on windows.
	ExecStepConfig_SHELL ExecStepConfig_Interpreter = 1
	// Indicates that the file will be run with PowerShell.
	ExecStepConfig_POWERSHELL ExecStepConfig_Interpreter = 2
)

// Enum value maps for ExecStepConfig_Interpreter.
var (
	ExecStepConfig_Interpreter_name = map[int32]string{
		0: "INTERPRETER_UNSPECIFIED",
		3: "NONE",
		1: "SHELL",
		2: "POWERSHELL",
	}
	ExecStepConfig_Interpreter_value = map[string]int32{
		"INTERPRETER_UNSPECIFIED": 0,
		"NONE":                    3,
		"SHELL":                   1,
		"POWERSHELL":              2,
	}
)

func (x ExecStepConfig_Interpreter) Enum() *ExecStepConfig_Interpreter {
	p := new(ExecStepConfig_Interpreter)
	*p = x
	return p
}

func (x ExecStepConfig_Interpreter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecStepConfig_Interpreter) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes[3].Descriptor()
}

func (ExecStepConfig_Interpreter) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes[3]
}

func (x ExecStepConfig_Interpreter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecStepConfig_Interpreter.Descriptor instead.
func (ExecStepConfig_Interpreter) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{8, 0}
}

// Patch configuration specifications. Contains details on how to
// apply patches to a VM instance.
type PatchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Post-patch reboot settings.
	RebootConfig PatchConfig_RebootConfig `protobuf:"varint,1,opt,name=reboot_config,json=rebootConfig,proto3,enum=google.cloud.osconfig.agentendpoint.v1.PatchConfig_RebootConfig" json:"reboot_config,omitempty"`
	// Retry strategy can be defined to have the agent retry patching
	// during the window if patching fails. If omitted, the agent will use its
	// default retry strategy.
	RetryStrategy *RetryStrategy `protobuf:"bytes,2,opt,name=retry_strategy,json=retryStrategy,proto3" json:"retry_strategy,omitempty"`
	// Apt update settings. Use this override the default apt patch rules.
	Apt *AptSettings `protobuf:"bytes,3,opt,name=apt,proto3" json:"apt,omitempty"`
	// Yum update settings. Use this override the default yum patch rules.
	Yum *YumSettings `protobuf:"bytes,4,opt,name=yum,proto3" json:"yum,omitempty"`
	// Goo update settings. Use this override the default goo patch rules.
	Goo *GooSettings `protobuf:"bytes,5,opt,name=goo,proto3" json:"goo,omitempty"`
	// Zypper update settings. Use this override the default zypper patch rules.
	Zypper *ZypperSettings `protobuf:"bytes,6,opt,name=zypper,proto3" json:"zypper,omitempty"`
	// Windows update settings. Use this override the default windows patch rules.
	WindowsUpdate *WindowsUpdateSettings `protobuf:"bytes,7,opt,name=windows_update,json=windowsUpdate,proto3" json:"windows_update,omitempty"`
	// The ExecStep to run before the patch update.
	PreStep *ExecStep `protobuf:"bytes,8,opt,name=pre_step,json=preStep,proto3" json:"pre_step,omitempty"`
	// The ExecStep to run after the patch update.
	PostStep *ExecStep `protobuf:"bytes,9,opt,name=post_step,json=postStep,proto3" json:"post_step,omitempty"`
	// Allows the patch job to run on Managed instance groups (MIGs).
	MigInstancesAllowed bool `protobuf:"varint,10,opt,name=mig_instances_allowed,json=migInstancesAllowed,proto3" json:"mig_instances_allowed,omitempty"`
}

func (x *PatchConfig) Reset() {
	*x = PatchConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchConfig) ProtoMessage() {}

func (x *PatchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchConfig.ProtoReflect.Descriptor instead.
func (*PatchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{0}
}

func (x *PatchConfig) GetRebootConfig() PatchConfig_RebootConfig {
	if x != nil {
		return x.RebootConfig
	}
	return PatchConfig_REBOOT_CONFIG_UNSPECIFIED
}

func (x *PatchConfig) GetRetryStrategy() *RetryStrategy {
	if x != nil {
		return x.RetryStrategy
	}
	return nil
}

func (x *PatchConfig) GetApt() *AptSettings {
	if x != nil {
		return x.Apt
	}
	return nil
}

func (x *PatchConfig) GetYum() *YumSettings {
	if x != nil {
		return x.Yum
	}
	return nil
}

func (x *PatchConfig) GetGoo() *GooSettings {
	if x != nil {
		return x.Goo
	}
	return nil
}

func (x *PatchConfig) GetZypper() *ZypperSettings {
	if x != nil {
		return x.Zypper
	}
	return nil
}

func (x *PatchConfig) GetWindowsUpdate() *WindowsUpdateSettings {
	if x != nil {
		return x.WindowsUpdate
	}
	return nil
}

func (x *PatchConfig) GetPreStep() *ExecStep {
	if x != nil {
		return x.PreStep
	}
	return nil
}

func (x *PatchConfig) GetPostStep() *ExecStep {
	if x != nil {
		return x.PostStep
	}
	return nil
}

func (x *PatchConfig) GetMigInstancesAllowed() bool {
	if x != nil {
		return x.MigInstancesAllowed
	}
	return false
}

// Apt patching will be performed by executing `apt-get update && apt-get
// upgrade`. Additional options can be set to control how this is executed.
type AptSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// By changing the type to DIST, the patching will be performed
	// using `apt-get dist-upgrade` instead.
	Type AptSettings_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.osconfig.agentendpoint.v1.AptSettings_Type" json:"type,omitempty"`
	// List of packages to exclude from update.
	Excludes []string `protobuf:"bytes,2,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of packages to be updated. These are the only packages
	// that will be updated. If these packages are not installed, they will be
	// ignored. This field cannot be specified with any other patch configuration
	// fields.
	ExclusivePackages []string `protobuf:"bytes,3,rep,name=exclusive_packages,json=exclusivePackages,proto3" json:"exclusive_packages,omitempty"`
}

func (x *AptSettings) Reset() {
	*x = AptSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AptSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AptSettings) ProtoMessage() {}

func (x *AptSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AptSettings.ProtoReflect.Descriptor instead.
func (*AptSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{1}
}

func (x *AptSettings) GetType() AptSettings_Type {
	if x != nil {
		return x.Type
	}
	return AptSettings_TYPE_UNSPECIFIED
}

func (x *AptSettings) GetExcludes() []string {
	if x != nil {
		return x.Excludes
	}
	return nil
}

func (x *AptSettings) GetExclusivePackages() []string {
	if x != nil {
		return x.ExclusivePackages
	}
	return nil
}

// Yum patching will be performed by executing `yum update`. Additional options
// can be set to control how this is executed.
//
// Note that not all settings are supported on all platforms.
type YumSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Adds the `--security` flag to `yum update`. Not supported on
	// all platforms.
	Security bool `protobuf:"varint,1,opt,name=security,proto3" json:"security,omitempty"`
	// Will cause patch to run `yum update-minimal` instead.
	Minimal bool `protobuf:"varint,2,opt,name=minimal,proto3" json:"minimal,omitempty"`
	// List of packages to exclude from update. These packages will be excluded by
	// using the yum `--exclude` flag.
	Excludes []string `protobuf:"bytes,3,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of packages to be updated. These are the only packages
	// that will be updated. If these packages are not installed, they will be
	// ignored. This field must not be specified with any other patch
	// configuration fields.
	ExclusivePackages []string `protobuf:"bytes,4,rep,name=exclusive_packages,json=exclusivePackages,proto3" json:"exclusive_packages,omitempty"`
}

func (x *YumSettings) Reset() {
	*x = YumSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *YumSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*YumSettings) ProtoMessage() {}

func (x *YumSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use YumSettings.ProtoReflect.Descriptor instead.
func (*YumSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{2}
}

func (x *YumSettings) GetSecurity() bool {
	if x != nil {
		return x.Security
	}
	return false
}

func (x *YumSettings) GetMinimal() bool {
	if x != nil {
		return x.Minimal
	}
	return false
}

func (x *YumSettings) GetExcludes() []string {
	if x != nil {
		return x.Excludes
	}
	return nil
}

func (x *YumSettings) GetExclusivePackages() []string {
	if x != nil {
		return x.ExclusivePackages
	}
	return nil
}

// Googet patching is performed by running `googet update`.
type GooSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GooSettings) Reset() {
	*x = GooSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GooSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GooSettings) ProtoMessage() {}

func (x *GooSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GooSettings.ProtoReflect.Descriptor instead.
func (*GooSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{3}
}

// Zypper patching is performed by running `zypper patch`.
// See also https://en.opensuse.org/SDB:Zypper_manual.
type ZypperSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Adds the `--with-optional` flag to `zypper patch`.
	WithOptional bool `protobuf:"varint,1,opt,name=with_optional,json=withOptional,proto3" json:"with_optional,omitempty"`
	// Adds the `--with-update` flag, to `zypper patch`.
	WithUpdate bool `protobuf:"varint,2,opt,name=with_update,json=withUpdate,proto3" json:"with_update,omitempty"`
	// Install only patches with these categories.
	// Common categories include security, recommended, and feature.
	Categories []string `protobuf:"bytes,3,rep,name=categories,proto3" json:"categories,omitempty"`
	// Install only patches with these severities.
	// Common severities include critical, important, moderate, and low.
	Severities []string `protobuf:"bytes,4,rep,name=severities,proto3" json:"severities,omitempty"`
	// List of patches to exclude from update.
	Excludes []string `protobuf:"bytes,5,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of patches to be updated. These are the only patches
	// that will be installed using 'zypper patch patch:<patch_name>' command.
	// This field must not be used with any other patch configuration fields.
	ExclusivePatches []string `protobuf:"bytes,6,rep,name=exclusive_patches,json=exclusivePatches,proto3" json:"exclusive_patches,omitempty"`
}

func (x *ZypperSettings) Reset() {
	*x = ZypperSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZypperSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZypperSettings) ProtoMessage() {}

func (x *ZypperSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZypperSettings.ProtoReflect.Descriptor instead.
func (*ZypperSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{4}
}

func (x *ZypperSettings) GetWithOptional() bool {
	if x != nil {
		return x.WithOptional
	}
	return false
}

func (x *ZypperSettings) GetWithUpdate() bool {
	if x != nil {
		return x.WithUpdate
	}
	return false
}

func (x *ZypperSettings) GetCategories() []string {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *ZypperSettings) GetSeverities() []string {
	if x != nil {
		return x.Severities
	}
	return nil
}

func (x *ZypperSettings) GetExcludes() []string {
	if x != nil {
		return x.Excludes
	}
	return nil
}

func (x *ZypperSettings) GetExclusivePatches() []string {
	if x != nil {
		return x.ExclusivePatches
	}
	return nil
}

// Windows patching is performed using the Windows Update Agent.
type WindowsUpdateSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only apply updates of these windows update classifications. If empty, all
	// updates will be applied.
	Classifications []WindowsUpdateSettings_Classification `protobuf:"varint,1,rep,packed,name=classifications,proto3,enum=google.cloud.osconfig.agentendpoint.v1.WindowsUpdateSettings_Classification" json:"classifications,omitempty"`
	// List of KBs to exclude from update.
	Excludes []string `protobuf:"bytes,2,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of kbs to be updated. These are the only patches
	// that will be updated. This field must not be used with other
	// patch configurations.
	ExclusivePatches []string `protobuf:"bytes,3,rep,name=exclusive_patches,json=exclusivePatches,proto3" json:"exclusive_patches,omitempty"`
}

func (x *WindowsUpdateSettings) Reset() {
	*x = WindowsUpdateSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsUpdateSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsUpdateSettings) ProtoMessage() {}

func (x *WindowsUpdateSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsUpdateSettings.ProtoReflect.Descriptor instead.
func (*WindowsUpdateSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{5}
}

func (x *WindowsUpdateSettings) GetClassifications() []WindowsUpdateSettings_Classification {
	if x != nil {
		return x.Classifications
	}
	return nil
}

func (x *WindowsUpdateSettings) GetExcludes() []string {
	if x != nil {
		return x.Excludes
	}
	return nil
}

func (x *WindowsUpdateSettings) GetExclusivePatches() []string {
	if x != nil {
		return x.ExclusivePatches
	}
	return nil
}

// The strategy for retrying failed patches during the patch window.
type RetryStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, the agent will continue to try and patch until the window has
	// ended.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *RetryStrategy) Reset() {
	*x = RetryStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryStrategy) ProtoMessage() {}

func (x *RetryStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryStrategy.ProtoReflect.Descriptor instead.
func (*RetryStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{6}
}

func (x *RetryStrategy) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// A step that runs an executable for a PatchJob.
type ExecStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ExecStepConfig for all Linux VMs targeted by the PatchJob.
	LinuxExecStepConfig *ExecStepConfig `protobuf:"bytes,1,opt,name=linux_exec_step_config,json=linuxExecStepConfig,proto3" json:"linux_exec_step_config,omitempty"`
	// The ExecStepConfig for all Windows VMs targeted by the PatchJob.
	WindowsExecStepConfig *ExecStepConfig `protobuf:"bytes,2,opt,name=windows_exec_step_config,json=windowsExecStepConfig,proto3" json:"windows_exec_step_config,omitempty"`
}

func (x *ExecStep) Reset() {
	*x = ExecStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecStep) ProtoMessage() {}

func (x *ExecStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecStep.ProtoReflect.Descriptor instead.
func (*ExecStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{7}
}

func (x *ExecStep) GetLinuxExecStepConfig() *ExecStepConfig {
	if x != nil {
		return x.LinuxExecStepConfig
	}
	return nil
}

func (x *ExecStep) GetWindowsExecStepConfig() *ExecStepConfig {
	if x != nil {
		return x.WindowsExecStepConfig
	}
	return nil
}

// Common configurations for an ExecStep.
type ExecStepConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of the executable.
	//
	// Types that are assignable to Executable:
	//
	//	*ExecStepConfig_LocalPath
	//	*ExecStepConfig_GcsObject
	Executable isExecStepConfig_Executable `protobuf_oneof:"executable"`
	// Defaults to [0]. A list of possible return values that the
	// execution can return to indicate a success.
	AllowedSuccessCodes []int32 `protobuf:"varint,3,rep,packed,name=allowed_success_codes,json=allowedSuccessCodes,proto3" json:"allowed_success_codes,omitempty"`
	// The script interpreter to use to run the script. If no interpreter is
	// specified the script will be executed directly, which will likely
	// only succeed for scripts with shebang lines.
	// [Wikipedia shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)).
	Interpreter ExecStepConfig_Interpreter `protobuf:"varint,4,opt,name=interpreter,proto3,enum=google.cloud.osconfig.agentendpoint.v1.ExecStepConfig_Interpreter" json:"interpreter,omitempty"`
}

func (x *ExecStepConfig) Reset() {
	*x = ExecStepConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecStepConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecStepConfig) ProtoMessage() {}

func (x *ExecStepConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecStepConfig.ProtoReflect.Descriptor instead.
func (*ExecStepConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{8}
}

func (m *ExecStepConfig) GetExecutable() isExecStepConfig_Executable {
	if m != nil {
		return m.Executable
	}
	return nil
}

func (x *ExecStepConfig) GetLocalPath() string {
	if x, ok := x.GetExecutable().(*ExecStepConfig_LocalPath); ok {
		return x.LocalPath
	}
	return ""
}

func (x *ExecStepConfig) GetGcsObject() *GcsObject {
	if x, ok := x.GetExecutable().(*ExecStepConfig_GcsObject); ok {
		return x.GcsObject
	}
	return nil
}

func (x *ExecStepConfig) GetAllowedSuccessCodes() []int32 {
	if x != nil {
		return x.AllowedSuccessCodes
	}
	return nil
}

func (x *ExecStepConfig) GetInterpreter() ExecStepConfig_Interpreter {
	if x != nil {
		return x.Interpreter
	}
	return ExecStepConfig_INTERPRETER_UNSPECIFIED
}

type isExecStepConfig_Executable interface {
	isExecStepConfig_Executable()
}

type ExecStepConfig_LocalPath struct {
	// An absolute path to the executable on the VM.
	LocalPath string `protobuf:"bytes,1,opt,name=local_path,json=localPath,proto3,oneof"`
}

type ExecStepConfig_GcsObject struct {
	// A GCS object containing the executable.
	GcsObject *GcsObject `protobuf:"bytes,2,opt,name=gcs_object,json=gcsObject,proto3,oneof"`
}

func (*ExecStepConfig_LocalPath) isExecStepConfig_Executable() {}

func (*ExecStepConfig_GcsObject) isExecStepConfig_Executable() {}

// GCS object representation.
type GcsObject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bucket of the GCS object.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Name of the GCS object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Generation number of the GCS object. This is used to ensure that the
	// ExecStep specified by this PatchJob does not change.
	GenerationNumber int64 `protobuf:"varint,3,opt,name=generation_number,json=generationNumber,proto3" json:"generation_number,omitempty"`
}

func (x *GcsObject) Reset() {
	*x = GcsObject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsObject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsObject) ProtoMessage() {}

func (x *GcsObject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsObject.ProtoReflect.Descriptor instead.
func (*GcsObject) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP(), []int{9}
}

func (x *GcsObject) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GcsObject) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *GcsObject) GetGenerationNumber() int64 {
	if x != nil {
		return x.GenerationNumber
	}
	return 0
}

var File_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a,
	0x6f, 0x62, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x22, 0x80, 0x07, 0x0a, 0x0b, 0x50, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x65, 0x0a, 0x0d, 0x72, 0x65, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65,
	0x62, 0x6f, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x72, 0x65, 0x62, 0x6f,
	0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x0e, 0x72, 0x65, 0x74, 0x72,
	0x79, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x53,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x0d, 0x72, 0x65, 0x74, 0x72, 0x79, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x45, 0x0a, 0x03, 0x61, 0x70, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x03, 0x61, 0x70, 0x74, 0x12, 0x45, 0x0a,
	0x03, 0x79, 0x75, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x59, 0x75, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x03, 0x79, 0x75, 0x6d, 0x12, 0x45, 0x0a, 0x03, 0x67, 0x6f, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x03, 0x67, 0x6f, 0x6f, 0x12, 0x4e, 0x0a, 0x06, 0x7a,
	0x79, 0x70, 0x70, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x06, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x12, 0x64, 0x0a, 0x0e, 0x77,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x0d, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x4b, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65,
	0x63, 0x53, 0x74, 0x65, 0x70, 0x52, 0x07, 0x70, 0x72, 0x65, 0x53, 0x74, 0x65, 0x70, 0x12, 0x4d,
	0x0a, 0x09, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53,
	0x74, 0x65, 0x70, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x74, 0x65, 0x70, 0x12, 0x32, 0x0a,
	0x15, 0x6d, 0x69, 0x67, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x6d, 0x69,
	0x67, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x22, 0x51, 0x0a, 0x0c, 0x52, 0x65, 0x62, 0x6f, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46,
	0x49, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x45, 0x56,
	0x45, 0x52, 0x10, 0x03, 0x22, 0xdb, 0x01, 0x0a, 0x0b, 0x41, 0x70, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x4c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x12, 0x2d,
	0x0a, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x22, 0x33, 0x0a,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x44,
	0x49, 0x53, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45,
	0x10, 0x02, 0x22, 0x8e, 0x01, 0x0a, 0x0b, 0x59, 0x75, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76,
	0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x73, 0x22, 0x0d, 0x0a, 0x0b, 0x47, 0x6f, 0x6f, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0xdf, 0x01, 0x0a, 0x0e, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x77, 0x69,
	0x74, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x69,
	0x74, 0x68, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x77, 0x69, 0x74, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x73,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x22, 0x90, 0x03, 0x0a, 0x15, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x76,
	0x0a, 0x0f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x5f,
	0x70, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x22,
	0xb5, 0x01, 0x0a, 0x0e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x46, 0x49, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x49, 0x54, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x10, 0x02, 0x12, 0x0e,
	0x0a, 0x0a, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x0a,
	0x0a, 0x06, 0x44, 0x52, 0x49, 0x56, 0x45, 0x52, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x46, 0x45,
	0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x10, 0x06, 0x12, 0x08,
	0x0a, 0x04, 0x54, 0x4f, 0x4f, 0x4c, 0x10, 0x07, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x55, 0x50, 0x10, 0x08, 0x12, 0x0a, 0x0a, 0x06, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x09, 0x22, 0x29, 0x0a, 0x0d, 0x52, 0x65, 0x74, 0x72, 0x79,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x22, 0xe8, 0x01, 0x0a, 0x08, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x12,
	0x6b, 0x0a, 0x16, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x73, 0x74,
	0x65, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65,
	0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x45, 0x78,
	0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x18,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x73, 0x74, 0x65,
	0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x45,
	0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xfe, 0x02,
	0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x1f, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x52, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x63, 0x73, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x05, 0x52, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x53, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x0b, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74,
	0x65, 0x72, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x22,
	0x4f, 0x0a, 0x0b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x12, 0x1b,
	0x0a, 0x17, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e,
	0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x01,
	0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x02,
	0x42, 0x0c, 0x0a, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x68,
	0x0a, 0x09, 0x47, 0x63, 0x73, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x89, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x09, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f,
	0x62, 0x73, 0x5a, 0x50, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x70, 0x62, 0x3b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescData = file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDesc
)

func file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescData)
	})
	return file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDescData
}

var file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_goTypes = []interface{}{
	(PatchConfig_RebootConfig)(0),             // 0: google.cloud.osconfig.agentendpoint.v1.PatchConfig.RebootConfig
	(AptSettings_Type)(0),                     // 1: google.cloud.osconfig.agentendpoint.v1.AptSettings.Type
	(WindowsUpdateSettings_Classification)(0), // 2: google.cloud.osconfig.agentendpoint.v1.WindowsUpdateSettings.Classification
	(ExecStepConfig_Interpreter)(0),           // 3: google.cloud.osconfig.agentendpoint.v1.ExecStepConfig.Interpreter
	(*PatchConfig)(nil),                       // 4: google.cloud.osconfig.agentendpoint.v1.PatchConfig
	(*AptSettings)(nil),                       // 5: google.cloud.osconfig.agentendpoint.v1.AptSettings
	(*YumSettings)(nil),                       // 6: google.cloud.osconfig.agentendpoint.v1.YumSettings
	(*GooSettings)(nil),                       // 7: google.cloud.osconfig.agentendpoint.v1.GooSettings
	(*ZypperSettings)(nil),                    // 8: google.cloud.osconfig.agentendpoint.v1.ZypperSettings
	(*WindowsUpdateSettings)(nil),             // 9: google.cloud.osconfig.agentendpoint.v1.WindowsUpdateSettings
	(*RetryStrategy)(nil),                     // 10: google.cloud.osconfig.agentendpoint.v1.RetryStrategy
	(*ExecStep)(nil),                          // 11: google.cloud.osconfig.agentendpoint.v1.ExecStep
	(*ExecStepConfig)(nil),                    // 12: google.cloud.osconfig.agentendpoint.v1.ExecStepConfig
	(*GcsObject)(nil),                         // 13: google.cloud.osconfig.agentendpoint.v1.GcsObject
}
var file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_depIdxs = []int32{
	0,  // 0: google.cloud.osconfig.agentendpoint.v1.PatchConfig.reboot_config:type_name -> google.cloud.osconfig.agentendpoint.v1.PatchConfig.RebootConfig
	10, // 1: google.cloud.osconfig.agentendpoint.v1.PatchConfig.retry_strategy:type_name -> google.cloud.osconfig.agentendpoint.v1.RetryStrategy
	5,  // 2: google.cloud.osconfig.agentendpoint.v1.PatchConfig.apt:type_name -> google.cloud.osconfig.agentendpoint.v1.AptSettings
	6,  // 3: google.cloud.osconfig.agentendpoint.v1.PatchConfig.yum:type_name -> google.cloud.osconfig.agentendpoint.v1.YumSettings
	7,  // 4: google.cloud.osconfig.agentendpoint.v1.PatchConfig.goo:type_name -> google.cloud.osconfig.agentendpoint.v1.GooSettings
	8,  // 5: google.cloud.osconfig.agentendpoint.v1.PatchConfig.zypper:type_name -> google.cloud.osconfig.agentendpoint.v1.ZypperSettings
	9,  // 6: google.cloud.osconfig.agentendpoint.v1.PatchConfig.windows_update:type_name -> google.cloud.osconfig.agentendpoint.v1.WindowsUpdateSettings
	11, // 7: google.cloud.osconfig.agentendpoint.v1.PatchConfig.pre_step:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStep
	11, // 8: google.cloud.osconfig.agentendpoint.v1.PatchConfig.post_step:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStep
	1,  // 9: google.cloud.osconfig.agentendpoint.v1.AptSettings.type:type_name -> google.cloud.osconfig.agentendpoint.v1.AptSettings.Type
	2,  // 10: google.cloud.osconfig.agentendpoint.v1.WindowsUpdateSettings.classifications:type_name -> google.cloud.osconfig.agentendpoint.v1.WindowsUpdateSettings.Classification
	12, // 11: google.cloud.osconfig.agentendpoint.v1.ExecStep.linux_exec_step_config:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStepConfig
	12, // 12: google.cloud.osconfig.agentendpoint.v1.ExecStep.windows_exec_step_config:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStepConfig
	13, // 13: google.cloud.osconfig.agentendpoint.v1.ExecStepConfig.gcs_object:type_name -> google.cloud.osconfig.agentendpoint.v1.GcsObject
	3,  // 14: google.cloud.osconfig.agentendpoint.v1.ExecStepConfig.interpreter:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStepConfig.Interpreter
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_init() }
func file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_init() {
	if File_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AptSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*YumSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GooSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ZypperSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsUpdateSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecStepConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsObject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*ExecStepConfig_LocalPath)(nil),
		(*ExecStepConfig_GcsObject)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto = out.File
	file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_rawDesc = nil
	file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_goTypes = nil
	file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_depIdxs = nil
}
