// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/documentai/v1beta2/document.proto

package documentai

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	color "google.golang.org/genproto/googleapis/type/color"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Detected human reading orientation.
type Document_Page_Layout_Orientation int32

const (
	// Unspecified orientation.
	Document_Page_Layout_ORIENTATION_UNSPECIFIED Document_Page_Layout_Orientation = 0
	// Orientation is aligned with page up.
	Document_Page_Layout_PAGE_UP Document_Page_Layout_Orientation = 1
	// Orientation is aligned with page right.
	// Turn the head 90 degrees clockwise from upright to read.
	Document_Page_Layout_PAGE_RIGHT Document_Page_Layout_Orientation = 2
	// Orientation is aligned with page down.
	// Turn the head 180 degrees from upright to read.
	Document_Page_Layout_PAGE_DOWN Document_Page_Layout_Orientation = 3
	// Orientation is aligned with page left.
	// Turn the head 90 degrees counterclockwise from upright to read.
	Document_Page_Layout_PAGE_LEFT Document_Page_Layout_Orientation = 4
)

var Document_Page_Layout_Orientation_name = map[int32]string{
	0: "ORIENTATION_UNSPECIFIED",
	1: "PAGE_UP",
	2: "PAGE_RIGHT",
	3: "PAGE_DOWN",
	4: "PAGE_LEFT",
}

var Document_Page_Layout_Orientation_value = map[string]int32{
	"ORIENTATION_UNSPECIFIED": 0,
	"PAGE_UP":                 1,
	"PAGE_RIGHT":              2,
	"PAGE_DOWN":               3,
	"PAGE_LEFT":               4,
}

func (x Document_Page_Layout_Orientation) String() string {
	return proto.EnumName(Document_Page_Layout_Orientation_name, int32(x))
}

func (Document_Page_Layout_Orientation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 1, 0}
}

// Enum to denote the type of break found.
type Document_Page_Token_DetectedBreak_Type int32

const (
	// Unspecified break type.
	Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED Document_Page_Token_DetectedBreak_Type = 0
	// A single whitespace.
	Document_Page_Token_DetectedBreak_SPACE Document_Page_Token_DetectedBreak_Type = 1
	// A wider whitespace.
	Document_Page_Token_DetectedBreak_WIDE_SPACE Document_Page_Token_DetectedBreak_Type = 2
	// A hyphen that indicates that a token has been split across lines.
	Document_Page_Token_DetectedBreak_HYPHEN Document_Page_Token_DetectedBreak_Type = 3
)

var Document_Page_Token_DetectedBreak_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "SPACE",
	2: "WIDE_SPACE",
	3: "HYPHEN",
}

var Document_Page_Token_DetectedBreak_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"SPACE":            1,
	"WIDE_SPACE":       2,
	"HYPHEN":           3,
}

func (x Document_Page_Token_DetectedBreak_Type) String() string {
	return proto.EnumName(Document_Page_Token_DetectedBreak_Type_name, int32(x))
}

func (Document_Page_Token_DetectedBreak_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 5, 0, 0}
}

// The type of layout that is being referenced.
type Document_PageAnchor_PageRef_LayoutType int32

const (
	// Layout Unspecified.
	Document_PageAnchor_PageRef_LAYOUT_TYPE_UNSPECIFIED Document_PageAnchor_PageRef_LayoutType = 0
	// References a [Page.blocks][google.cloud.documentai.v1beta2.Document.Page.blocks] element.
	Document_PageAnchor_PageRef_BLOCK Document_PageAnchor_PageRef_LayoutType = 1
	// References a [Page.paragraphs][google.cloud.documentai.v1beta2.Document.Page.paragraphs] element.
	Document_PageAnchor_PageRef_PARAGRAPH Document_PageAnchor_PageRef_LayoutType = 2
	// References a [Page.lines][google.cloud.documentai.v1beta2.Document.Page.lines] element.
	Document_PageAnchor_PageRef_LINE Document_PageAnchor_PageRef_LayoutType = 3
	// References a [Page.tokens][google.cloud.documentai.v1beta2.Document.Page.tokens] element.
	Document_PageAnchor_PageRef_TOKEN Document_PageAnchor_PageRef_LayoutType = 4
	// References a [Page.visual_elements][google.cloud.documentai.v1beta2.Document.Page.visual_elements] element.
	Document_PageAnchor_PageRef_VISUAL_ELEMENT Document_PageAnchor_PageRef_LayoutType = 5
	// Refrrences a [Page.tables][google.cloud.documentai.v1beta2.Document.Page.tables] element.
	Document_PageAnchor_PageRef_TABLE Document_PageAnchor_PageRef_LayoutType = 6
	// References a [Page.form_fields][google.cloud.documentai.v1beta2.Document.Page.form_fields] element.
	Document_PageAnchor_PageRef_FORM_FIELD Document_PageAnchor_PageRef_LayoutType = 7
)

var Document_PageAnchor_PageRef_LayoutType_name = map[int32]string{
	0: "LAYOUT_TYPE_UNSPECIFIED",
	1: "BLOCK",
	2: "PARAGRAPH",
	3: "LINE",
	4: "TOKEN",
	5: "VISUAL_ELEMENT",
	6: "TABLE",
	7: "FORM_FIELD",
}

var Document_PageAnchor_PageRef_LayoutType_value = map[string]int32{
	"LAYOUT_TYPE_UNSPECIFIED": 0,
	"BLOCK":                   1,
	"PARAGRAPH":               2,
	"LINE":                    3,
	"TOKEN":                   4,
	"VISUAL_ELEMENT":          5,
	"TABLE":                   6,
	"FORM_FIELD":              7,
}

func (x Document_PageAnchor_PageRef_LayoutType) String() string {
	return proto.EnumName(Document_PageAnchor_PageRef_LayoutType_name, int32(x))
}

func (Document_PageAnchor_PageRef_LayoutType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 7, 0, 0}
}

// Document represents the canonical document resource in Document Understanding
// AI.
// It is an interchange format that provides insights into documents and allows
// for collaboration between users and Document Understanding AI to iterate and
// optimize for quality.
type Document struct {
	// Original source document from the user.
	//
	// Types that are valid to be assigned to Source:
	//	*Document_Uri
	//	*Document_Content
	Source isDocument_Source `protobuf_oneof:"source"`
	// An IANA published MIME type (also referred to as media type). For more
	// information, see
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// UTF-8 encoded text in reading order from the document.
	Text string `protobuf:"bytes,4,opt,name=text,proto3" json:"text,omitempty"`
	// Styles for the [Document.text][google.cloud.documentai.v1beta2.Document.text].
	TextStyles []*Document_Style `protobuf:"bytes,5,rep,name=text_styles,json=textStyles,proto3" json:"text_styles,omitempty"`
	// Visual page layout for the [Document][google.cloud.documentai.v1beta2.Document].
	Pages []*Document_Page `protobuf:"bytes,6,rep,name=pages,proto3" json:"pages,omitempty"`
	// A list of entities detected on [Document.text][google.cloud.documentai.v1beta2.Document.text]. For document shards,
	// entities in this list may cross shard boundaries.
	Entities []*Document_Entity `protobuf:"bytes,7,rep,name=entities,proto3" json:"entities,omitempty"`
	// Relationship among [Document.entities][google.cloud.documentai.v1beta2.Document.entities].
	EntityRelations []*Document_EntityRelation `protobuf:"bytes,8,rep,name=entity_relations,json=entityRelations,proto3" json:"entity_relations,omitempty"`
	// Information about the sharding if this document is sharded part of a larger
	// document. If the document is not sharded, this message is not specified.
	ShardInfo *Document_ShardInfo `protobuf:"bytes,9,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
	// [Label][google.cloud.documentai.v1beta2.Document.Label]s for this document.
	Labels []*Document_Label `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty"`
	// Any error that occurred while processing this document.
	Error                *status.Status `protobuf:"bytes,10,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Document) Reset()         { *m = Document{} }
func (m *Document) String() string { return proto.CompactTextString(m) }
func (*Document) ProtoMessage()    {}
func (*Document) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0}
}

func (m *Document) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document.Unmarshal(m, b)
}
func (m *Document) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document.Marshal(b, m, deterministic)
}
func (m *Document) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document.Merge(m, src)
}
func (m *Document) XXX_Size() int {
	return xxx_messageInfo_Document.Size(m)
}
func (m *Document) XXX_DiscardUnknown() {
	xxx_messageInfo_Document.DiscardUnknown(m)
}

var xxx_messageInfo_Document proto.InternalMessageInfo

type isDocument_Source interface {
	isDocument_Source()
}

type Document_Uri struct {
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type Document_Content struct {
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

func (*Document_Uri) isDocument_Source() {}

func (*Document_Content) isDocument_Source() {}

func (m *Document) GetSource() isDocument_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Document) GetUri() string {
	if x, ok := m.GetSource().(*Document_Uri); ok {
		return x.Uri
	}
	return ""
}

func (m *Document) GetContent() []byte {
	if x, ok := m.GetSource().(*Document_Content); ok {
		return x.Content
	}
	return nil
}

func (m *Document) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

func (m *Document) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Document) GetTextStyles() []*Document_Style {
	if m != nil {
		return m.TextStyles
	}
	return nil
}

func (m *Document) GetPages() []*Document_Page {
	if m != nil {
		return m.Pages
	}
	return nil
}

func (m *Document) GetEntities() []*Document_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

func (m *Document) GetEntityRelations() []*Document_EntityRelation {
	if m != nil {
		return m.EntityRelations
	}
	return nil
}

func (m *Document) GetShardInfo() *Document_ShardInfo {
	if m != nil {
		return m.ShardInfo
	}
	return nil
}

func (m *Document) GetLabels() []*Document_Label {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Document) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Document) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Document_Uri)(nil),
		(*Document_Content)(nil),
	}
}

// For a large document, sharding may be performed to produce several
// document shards. Each document shard contains this field to detail which
// shard it is.
type Document_ShardInfo struct {
	// The 0-based index of this shard.
	ShardIndex int64 `protobuf:"varint,1,opt,name=shard_index,json=shardIndex,proto3" json:"shard_index,omitempty"`
	// Total number of shards.
	ShardCount int64 `protobuf:"varint,2,opt,name=shard_count,json=shardCount,proto3" json:"shard_count,omitempty"`
	// The index of the first character in [Document.text][google.cloud.documentai.v1beta2.Document.text] in the overall
	// document global text.
	TextOffset           int64    `protobuf:"varint,3,opt,name=text_offset,json=textOffset,proto3" json:"text_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_ShardInfo) Reset()         { *m = Document_ShardInfo{} }
func (m *Document_ShardInfo) String() string { return proto.CompactTextString(m) }
func (*Document_ShardInfo) ProtoMessage()    {}
func (*Document_ShardInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 0}
}

func (m *Document_ShardInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_ShardInfo.Unmarshal(m, b)
}
func (m *Document_ShardInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_ShardInfo.Marshal(b, m, deterministic)
}
func (m *Document_ShardInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_ShardInfo.Merge(m, src)
}
func (m *Document_ShardInfo) XXX_Size() int {
	return xxx_messageInfo_Document_ShardInfo.Size(m)
}
func (m *Document_ShardInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_ShardInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Document_ShardInfo proto.InternalMessageInfo

func (m *Document_ShardInfo) GetShardIndex() int64 {
	if m != nil {
		return m.ShardIndex
	}
	return 0
}

func (m *Document_ShardInfo) GetShardCount() int64 {
	if m != nil {
		return m.ShardCount
	}
	return 0
}

func (m *Document_ShardInfo) GetTextOffset() int64 {
	if m != nil {
		return m.TextOffset
	}
	return 0
}

// Label attaches schema information and/or other metadata to segments within
// a [Document][google.cloud.documentai.v1beta2.Document]. Multiple [Label][google.cloud.documentai.v1beta2.Document.Label]s on a single field can denote either
// different labels, different instances of the same label created at
// different times, or some combination of both.
type Document_Label struct {
	// Provenance of the label.
	//
	// Types that are valid to be assigned to Source:
	//	*Document_Label_AutomlModel
	Source isDocument_Label_Source `protobuf_oneof:"source"`
	// Name of the label.
	//
	// When the label is generated from AutoML Text Classification model, this
	// field represents the name of the category.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Confidence score between 0 and 1 for label assignment.
	Confidence           float32  `protobuf:"fixed32,3,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Label) Reset()         { *m = Document_Label{} }
func (m *Document_Label) String() string { return proto.CompactTextString(m) }
func (*Document_Label) ProtoMessage()    {}
func (*Document_Label) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 1}
}

func (m *Document_Label) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Label.Unmarshal(m, b)
}
func (m *Document_Label) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Label.Marshal(b, m, deterministic)
}
func (m *Document_Label) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Label.Merge(m, src)
}
func (m *Document_Label) XXX_Size() int {
	return xxx_messageInfo_Document_Label.Size(m)
}
func (m *Document_Label) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Label.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Label proto.InternalMessageInfo

type isDocument_Label_Source interface {
	isDocument_Label_Source()
}

type Document_Label_AutomlModel struct {
	AutomlModel string `protobuf:"bytes,2,opt,name=automl_model,json=automlModel,proto3,oneof"`
}

func (*Document_Label_AutomlModel) isDocument_Label_Source() {}

func (m *Document_Label) GetSource() isDocument_Label_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Document_Label) GetAutomlModel() string {
	if x, ok := m.GetSource().(*Document_Label_AutomlModel); ok {
		return x.AutomlModel
	}
	return ""
}

func (m *Document_Label) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Document_Label) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Document_Label) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Document_Label_AutomlModel)(nil),
	}
}

// Annotation for common text style attributes. This adheres to CSS
// conventions as much as possible.
type Document_Style struct {
	// Text anchor indexing into the [Document.text][google.cloud.documentai.v1beta2.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Text color.
	Color *color.Color `protobuf:"bytes,2,opt,name=color,proto3" json:"color,omitempty"`
	// Text background color.
	BackgroundColor *color.Color `protobuf:"bytes,3,opt,name=background_color,json=backgroundColor,proto3" json:"background_color,omitempty"`
	// Font weight. Possible values are normal, bold, bolder, and lighter.
	// https://www.w3schools.com/cssref/pr_font_weight.asp
	FontWeight string `protobuf:"bytes,4,opt,name=font_weight,json=fontWeight,proto3" json:"font_weight,omitempty"`
	// Text style. Possible values are normal, italic, and oblique.
	// https://www.w3schools.com/cssref/pr_font_font-style.asp
	TextStyle string `protobuf:"bytes,5,opt,name=text_style,json=textStyle,proto3" json:"text_style,omitempty"`
	// Text decoration. Follows CSS standard.
	// <text-decoration-line> <text-decoration-color> <text-decoration-style>
	// https://www.w3schools.com/cssref/pr_text_text-decoration.asp
	TextDecoration string `protobuf:"bytes,6,opt,name=text_decoration,json=textDecoration,proto3" json:"text_decoration,omitempty"`
	// Font size.
	FontSize             *Document_Style_FontSize `protobuf:"bytes,7,opt,name=font_size,json=fontSize,proto3" json:"font_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Document_Style) Reset()         { *m = Document_Style{} }
func (m *Document_Style) String() string { return proto.CompactTextString(m) }
func (*Document_Style) ProtoMessage()    {}
func (*Document_Style) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 2}
}

func (m *Document_Style) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Style.Unmarshal(m, b)
}
func (m *Document_Style) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Style.Marshal(b, m, deterministic)
}
func (m *Document_Style) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Style.Merge(m, src)
}
func (m *Document_Style) XXX_Size() int {
	return xxx_messageInfo_Document_Style.Size(m)
}
func (m *Document_Style) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Style.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Style proto.InternalMessageInfo

func (m *Document_Style) GetTextAnchor() *Document_TextAnchor {
	if m != nil {
		return m.TextAnchor
	}
	return nil
}

func (m *Document_Style) GetColor() *color.Color {
	if m != nil {
		return m.Color
	}
	return nil
}

func (m *Document_Style) GetBackgroundColor() *color.Color {
	if m != nil {
		return m.BackgroundColor
	}
	return nil
}

func (m *Document_Style) GetFontWeight() string {
	if m != nil {
		return m.FontWeight
	}
	return ""
}

func (m *Document_Style) GetTextStyle() string {
	if m != nil {
		return m.TextStyle
	}
	return ""
}

func (m *Document_Style) GetTextDecoration() string {
	if m != nil {
		return m.TextDecoration
	}
	return ""
}

func (m *Document_Style) GetFontSize() *Document_Style_FontSize {
	if m != nil {
		return m.FontSize
	}
	return nil
}

// Font size with unit.
type Document_Style_FontSize struct {
	// Font size for the text.
	Size float32 `protobuf:"fixed32,1,opt,name=size,proto3" json:"size,omitempty"`
	// Unit for the font size. Follows CSS naming (in, px, pt, etc.).
	Unit                 string   `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Style_FontSize) Reset()         { *m = Document_Style_FontSize{} }
func (m *Document_Style_FontSize) String() string { return proto.CompactTextString(m) }
func (*Document_Style_FontSize) ProtoMessage()    {}
func (*Document_Style_FontSize) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 2, 0}
}

func (m *Document_Style_FontSize) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Style_FontSize.Unmarshal(m, b)
}
func (m *Document_Style_FontSize) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Style_FontSize.Marshal(b, m, deterministic)
}
func (m *Document_Style_FontSize) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Style_FontSize.Merge(m, src)
}
func (m *Document_Style_FontSize) XXX_Size() int {
	return xxx_messageInfo_Document_Style_FontSize.Size(m)
}
func (m *Document_Style_FontSize) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Style_FontSize.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Style_FontSize proto.InternalMessageInfo

func (m *Document_Style_FontSize) GetSize() float32 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *Document_Style_FontSize) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

// A page in a [Document][google.cloud.documentai.v1beta2.Document].
type Document_Page struct {
	// 1-based index for current [Page][google.cloud.documentai.v1beta2.Document.Page] in a parent [Document][google.cloud.documentai.v1beta2.Document].
	// Useful when a page is taken out of a [Document][google.cloud.documentai.v1beta2.Document] for individual
	// processing.
	PageNumber int32 `protobuf:"varint,1,opt,name=page_number,json=pageNumber,proto3" json:"page_number,omitempty"`
	// Physical dimension of the page.
	Dimension *Document_Page_Dimension `protobuf:"bytes,2,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for the page.
	Layout *Document_Page_Layout `protobuf:"bytes,3,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	// A list of visually detected text blocks on the page.
	// A block has a set of lines (collected into paragraphs) that have a common
	// line-spacing and orientation.
	Blocks []*Document_Page_Block `protobuf:"bytes,5,rep,name=blocks,proto3" json:"blocks,omitempty"`
	// A list of visually detected text paragraphs on the page.
	// A collection of lines that a human would perceive as a paragraph.
	Paragraphs []*Document_Page_Paragraph `protobuf:"bytes,6,rep,name=paragraphs,proto3" json:"paragraphs,omitempty"`
	// A list of visually detected text lines on the page.
	// A collection of tokens that a human would perceive as a line.
	Lines []*Document_Page_Line `protobuf:"bytes,7,rep,name=lines,proto3" json:"lines,omitempty"`
	// A list of visually detected tokens on the page.
	Tokens []*Document_Page_Token `protobuf:"bytes,8,rep,name=tokens,proto3" json:"tokens,omitempty"`
	// A list of detected non-text visual elements e.g. checkbox,
	// signature etc. on the page.
	VisualElements []*Document_Page_VisualElement `protobuf:"bytes,9,rep,name=visual_elements,json=visualElements,proto3" json:"visual_elements,omitempty"`
	// A list of visually detected tables on the page.
	Tables []*Document_Page_Table `protobuf:"bytes,10,rep,name=tables,proto3" json:"tables,omitempty"`
	// A list of visually detected form fields on the page.
	FormFields           []*Document_Page_FormField `protobuf:"bytes,11,rep,name=form_fields,json=formFields,proto3" json:"form_fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *Document_Page) Reset()         { *m = Document_Page{} }
func (m *Document_Page) String() string { return proto.CompactTextString(m) }
func (*Document_Page) ProtoMessage()    {}
func (*Document_Page) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3}
}

func (m *Document_Page) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page.Unmarshal(m, b)
}
func (m *Document_Page) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page.Marshal(b, m, deterministic)
}
func (m *Document_Page) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page.Merge(m, src)
}
func (m *Document_Page) XXX_Size() int {
	return xxx_messageInfo_Document_Page.Size(m)
}
func (m *Document_Page) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page proto.InternalMessageInfo

func (m *Document_Page) GetPageNumber() int32 {
	if m != nil {
		return m.PageNumber
	}
	return 0
}

func (m *Document_Page) GetDimension() *Document_Page_Dimension {
	if m != nil {
		return m.Dimension
	}
	return nil
}

func (m *Document_Page) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

func (m *Document_Page) GetBlocks() []*Document_Page_Block {
	if m != nil {
		return m.Blocks
	}
	return nil
}

func (m *Document_Page) GetParagraphs() []*Document_Page_Paragraph {
	if m != nil {
		return m.Paragraphs
	}
	return nil
}

func (m *Document_Page) GetLines() []*Document_Page_Line {
	if m != nil {
		return m.Lines
	}
	return nil
}

func (m *Document_Page) GetTokens() []*Document_Page_Token {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *Document_Page) GetVisualElements() []*Document_Page_VisualElement {
	if m != nil {
		return m.VisualElements
	}
	return nil
}

func (m *Document_Page) GetTables() []*Document_Page_Table {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *Document_Page) GetFormFields() []*Document_Page_FormField {
	if m != nil {
		return m.FormFields
	}
	return nil
}

// Dimension for the page.
type Document_Page_Dimension struct {
	// Page width.
	Width float32 `protobuf:"fixed32,1,opt,name=width,proto3" json:"width,omitempty"`
	// Page height.
	Height float32 `protobuf:"fixed32,2,opt,name=height,proto3" json:"height,omitempty"`
	// Dimension unit.
	Unit                 string   `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Page_Dimension) Reset()         { *m = Document_Page_Dimension{} }
func (m *Document_Page_Dimension) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Dimension) ProtoMessage()    {}
func (*Document_Page_Dimension) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 0}
}

func (m *Document_Page_Dimension) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Dimension.Unmarshal(m, b)
}
func (m *Document_Page_Dimension) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Dimension.Marshal(b, m, deterministic)
}
func (m *Document_Page_Dimension) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Dimension.Merge(m, src)
}
func (m *Document_Page_Dimension) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Dimension.Size(m)
}
func (m *Document_Page_Dimension) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Dimension.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Dimension proto.InternalMessageInfo

func (m *Document_Page_Dimension) GetWidth() float32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *Document_Page_Dimension) GetHeight() float32 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *Document_Page_Dimension) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

// Visual element describing a layout unit on a page.
type Document_Page_Layout struct {
	// Text anchor indexing into the [Document.text][google.cloud.documentai.v1beta2.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Confidence of the current [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] within context of the object this
	// layout is for. e.g. confidence can be for a single token, a table,
	// a visual element, etc. depending on context. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The bounding polygon for the [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout].
	BoundingPoly *BoundingPoly `protobuf:"bytes,3,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// Detected orientation for the [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout].
	Orientation Document_Page_Layout_Orientation `protobuf:"varint,4,opt,name=orientation,proto3,enum=google.cloud.documentai.v1beta2.Document_Page_Layout_Orientation" json:"orientation,omitempty"`
	// Optional. This is the identifier used by referencing [PageAnchor][google.cloud.documentai.v1beta2.Document.PageAnchor]s.
	Id                   string   `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Page_Layout) Reset()         { *m = Document_Page_Layout{} }
func (m *Document_Page_Layout) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Layout) ProtoMessage()    {}
func (*Document_Page_Layout) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 1}
}

func (m *Document_Page_Layout) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Layout.Unmarshal(m, b)
}
func (m *Document_Page_Layout) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Layout.Marshal(b, m, deterministic)
}
func (m *Document_Page_Layout) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Layout.Merge(m, src)
}
func (m *Document_Page_Layout) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Layout.Size(m)
}
func (m *Document_Page_Layout) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Layout.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Layout proto.InternalMessageInfo

func (m *Document_Page_Layout) GetTextAnchor() *Document_TextAnchor {
	if m != nil {
		return m.TextAnchor
	}
	return nil
}

func (m *Document_Page_Layout) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *Document_Page_Layout) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *Document_Page_Layout) GetOrientation() Document_Page_Layout_Orientation {
	if m != nil {
		return m.Orientation
	}
	return Document_Page_Layout_ORIENTATION_UNSPECIFIED
}

func (m *Document_Page_Layout) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// A block has a set of lines (collected into paragraphs) that have a
// common line-spacing and orientation.
type Document_Page_Block struct {
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for [Block][google.cloud.documentai.v1beta2.Document.Page.Block].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Block) Reset()         { *m = Document_Page_Block{} }
func (m *Document_Page_Block) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Block) ProtoMessage()    {}
func (*Document_Page_Block) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 2}
}

func (m *Document_Page_Block) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Block.Unmarshal(m, b)
}
func (m *Document_Page_Block) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Block.Marshal(b, m, deterministic)
}
func (m *Document_Page_Block) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Block.Merge(m, src)
}
func (m *Document_Page_Block) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Block.Size(m)
}
func (m *Document_Page_Block) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Block.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Block proto.InternalMessageInfo

func (m *Document_Page_Block) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Block) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A collection of lines that a human would perceive as a paragraph.
type Document_Page_Paragraph struct {
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for [Paragraph][google.cloud.documentai.v1beta2.Document.Page.Paragraph].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Paragraph) Reset()         { *m = Document_Page_Paragraph{} }
func (m *Document_Page_Paragraph) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Paragraph) ProtoMessage()    {}
func (*Document_Page_Paragraph) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 3}
}

func (m *Document_Page_Paragraph) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Paragraph.Unmarshal(m, b)
}
func (m *Document_Page_Paragraph) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Paragraph.Marshal(b, m, deterministic)
}
func (m *Document_Page_Paragraph) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Paragraph.Merge(m, src)
}
func (m *Document_Page_Paragraph) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Paragraph.Size(m)
}
func (m *Document_Page_Paragraph) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Paragraph.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Paragraph proto.InternalMessageInfo

func (m *Document_Page_Paragraph) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Paragraph) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A collection of tokens that a human would perceive as a line.
// Does not cross column boundaries, can be horizontal, vertical, etc.
type Document_Page_Line struct {
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for [Line][google.cloud.documentai.v1beta2.Document.Page.Line].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Line) Reset()         { *m = Document_Page_Line{} }
func (m *Document_Page_Line) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Line) ProtoMessage()    {}
func (*Document_Page_Line) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 4}
}

func (m *Document_Page_Line) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Line.Unmarshal(m, b)
}
func (m *Document_Page_Line) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Line.Marshal(b, m, deterministic)
}
func (m *Document_Page_Line) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Line.Merge(m, src)
}
func (m *Document_Page_Line) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Line.Size(m)
}
func (m *Document_Page_Line) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Line.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Line proto.InternalMessageInfo

func (m *Document_Page_Line) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Line) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A detected token.
type Document_Page_Token struct {
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for [Token][google.cloud.documentai.v1beta2.Document.Page.Token].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Detected break at the end of a [Token][google.cloud.documentai.v1beta2.Document.Page.Token].
	DetectedBreak *Document_Page_Token_DetectedBreak `protobuf:"bytes,2,opt,name=detected_break,json=detectedBreak,proto3" json:"detected_break,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Token) Reset()         { *m = Document_Page_Token{} }
func (m *Document_Page_Token) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Token) ProtoMessage()    {}
func (*Document_Page_Token) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 5}
}

func (m *Document_Page_Token) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Token.Unmarshal(m, b)
}
func (m *Document_Page_Token) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Token.Marshal(b, m, deterministic)
}
func (m *Document_Page_Token) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Token.Merge(m, src)
}
func (m *Document_Page_Token) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Token.Size(m)
}
func (m *Document_Page_Token) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Token.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Token proto.InternalMessageInfo

func (m *Document_Page_Token) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Token) GetDetectedBreak() *Document_Page_Token_DetectedBreak {
	if m != nil {
		return m.DetectedBreak
	}
	return nil
}

func (m *Document_Page_Token) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// Detected break at the end of a [Token][google.cloud.documentai.v1beta2.Document.Page.Token].
type Document_Page_Token_DetectedBreak struct {
	// Detected break type.
	Type                 Document_Page_Token_DetectedBreak_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.documentai.v1beta2.Document_Page_Token_DetectedBreak_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *Document_Page_Token_DetectedBreak) Reset()         { *m = Document_Page_Token_DetectedBreak{} }
func (m *Document_Page_Token_DetectedBreak) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Token_DetectedBreak) ProtoMessage()    {}
func (*Document_Page_Token_DetectedBreak) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 5, 0}
}

func (m *Document_Page_Token_DetectedBreak) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Token_DetectedBreak.Unmarshal(m, b)
}
func (m *Document_Page_Token_DetectedBreak) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Token_DetectedBreak.Marshal(b, m, deterministic)
}
func (m *Document_Page_Token_DetectedBreak) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Token_DetectedBreak.Merge(m, src)
}
func (m *Document_Page_Token_DetectedBreak) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Token_DetectedBreak.Size(m)
}
func (m *Document_Page_Token_DetectedBreak) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Token_DetectedBreak.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Token_DetectedBreak proto.InternalMessageInfo

func (m *Document_Page_Token_DetectedBreak) GetType() Document_Page_Token_DetectedBreak_Type {
	if m != nil {
		return m.Type
	}
	return Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED
}

// Detected non-text visual elements e.g. checkbox, signature etc. on the
// page.
type Document_Page_VisualElement struct {
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for [VisualElement][google.cloud.documentai.v1beta2.Document.Page.VisualElement].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Type of the [VisualElement][google.cloud.documentai.v1beta2.Document.Page.VisualElement].
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_VisualElement) Reset()         { *m = Document_Page_VisualElement{} }
func (m *Document_Page_VisualElement) String() string { return proto.CompactTextString(m) }
func (*Document_Page_VisualElement) ProtoMessage()    {}
func (*Document_Page_VisualElement) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 6}
}

func (m *Document_Page_VisualElement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_VisualElement.Unmarshal(m, b)
}
func (m *Document_Page_VisualElement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_VisualElement.Marshal(b, m, deterministic)
}
func (m *Document_Page_VisualElement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_VisualElement.Merge(m, src)
}
func (m *Document_Page_VisualElement) XXX_Size() int {
	return xxx_messageInfo_Document_Page_VisualElement.Size(m)
}
func (m *Document_Page_VisualElement) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_VisualElement.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_VisualElement proto.InternalMessageInfo

func (m *Document_Page_VisualElement) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_VisualElement) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Document_Page_VisualElement) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A table representation similar to HTML table structure.
type Document_Page_Table struct {
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for [Table][google.cloud.documentai.v1beta2.Document.Page.Table].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Header rows of the table.
	HeaderRows []*Document_Page_Table_TableRow `protobuf:"bytes,2,rep,name=header_rows,json=headerRows,proto3" json:"header_rows,omitempty"`
	// Body rows of the table.
	BodyRows []*Document_Page_Table_TableRow `protobuf:"bytes,3,rep,name=body_rows,json=bodyRows,proto3" json:"body_rows,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Table) Reset()         { *m = Document_Page_Table{} }
func (m *Document_Page_Table) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Table) ProtoMessage()    {}
func (*Document_Page_Table) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 7}
}

func (m *Document_Page_Table) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Table.Unmarshal(m, b)
}
func (m *Document_Page_Table) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Table.Marshal(b, m, deterministic)
}
func (m *Document_Page_Table) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Table.Merge(m, src)
}
func (m *Document_Page_Table) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Table.Size(m)
}
func (m *Document_Page_Table) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Table.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Table proto.InternalMessageInfo

func (m *Document_Page_Table) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Table) GetHeaderRows() []*Document_Page_Table_TableRow {
	if m != nil {
		return m.HeaderRows
	}
	return nil
}

func (m *Document_Page_Table) GetBodyRows() []*Document_Page_Table_TableRow {
	if m != nil {
		return m.BodyRows
	}
	return nil
}

func (m *Document_Page_Table) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A row of table cells.
type Document_Page_Table_TableRow struct {
	// Cells that make up this row.
	Cells                []*Document_Page_Table_TableCell `protobuf:"bytes,1,rep,name=cells,proto3" json:"cells,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *Document_Page_Table_TableRow) Reset()         { *m = Document_Page_Table_TableRow{} }
func (m *Document_Page_Table_TableRow) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Table_TableRow) ProtoMessage()    {}
func (*Document_Page_Table_TableRow) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 7, 0}
}

func (m *Document_Page_Table_TableRow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Table_TableRow.Unmarshal(m, b)
}
func (m *Document_Page_Table_TableRow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Table_TableRow.Marshal(b, m, deterministic)
}
func (m *Document_Page_Table_TableRow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Table_TableRow.Merge(m, src)
}
func (m *Document_Page_Table_TableRow) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Table_TableRow.Size(m)
}
func (m *Document_Page_Table_TableRow) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Table_TableRow.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Table_TableRow proto.InternalMessageInfo

func (m *Document_Page_Table_TableRow) GetCells() []*Document_Page_Table_TableCell {
	if m != nil {
		return m.Cells
	}
	return nil
}

// A cell representation inside the table.
type Document_Page_Table_TableCell struct {
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for [TableCell][google.cloud.documentai.v1beta2.Document.Page.Table.TableCell].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// How many rows this cell spans.
	RowSpan int32 `protobuf:"varint,2,opt,name=row_span,json=rowSpan,proto3" json:"row_span,omitempty"`
	// How many columns this cell spans.
	ColSpan int32 `protobuf:"varint,3,opt,name=col_span,json=colSpan,proto3" json:"col_span,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Table_TableCell) Reset()         { *m = Document_Page_Table_TableCell{} }
func (m *Document_Page_Table_TableCell) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Table_TableCell) ProtoMessage()    {}
func (*Document_Page_Table_TableCell) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 7, 1}
}

func (m *Document_Page_Table_TableCell) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Table_TableCell.Unmarshal(m, b)
}
func (m *Document_Page_Table_TableCell) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Table_TableCell.Marshal(b, m, deterministic)
}
func (m *Document_Page_Table_TableCell) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Table_TableCell.Merge(m, src)
}
func (m *Document_Page_Table_TableCell) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Table_TableCell.Size(m)
}
func (m *Document_Page_Table_TableCell) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Table_TableCell.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Table_TableCell proto.InternalMessageInfo

func (m *Document_Page_Table_TableCell) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Table_TableCell) GetRowSpan() int32 {
	if m != nil {
		return m.RowSpan
	}
	return 0
}

func (m *Document_Page_Table_TableCell) GetColSpan() int32 {
	if m != nil {
		return m.ColSpan
	}
	return 0
}

func (m *Document_Page_Table_TableCell) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A form field detected on the page.
type Document_Page_FormField struct {
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for the [FormField][google.cloud.documentai.v1beta2.Document.Page.FormField] name. e.g. `Address`, `Email`,
	// `Grand total`, `Phone number`, etc.
	FieldName *Document_Page_Layout `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// [Layout][google.cloud.documentai.v1beta2.Document.Page.Layout] for the [FormField][google.cloud.documentai.v1beta2.Document.Page.FormField] value.
	FieldValue *Document_Page_Layout `protobuf:"bytes,2,opt,name=field_value,json=fieldValue,proto3" json:"field_value,omitempty"`
	// A list of detected languages for name together with confidence.
	NameDetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=name_detected_languages,json=nameDetectedLanguages,proto3" json:"name_detected_languages,omitempty"`
	// A list of detected languages for value together with confidence.
	ValueDetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=value_detected_languages,json=valueDetectedLanguages,proto3" json:"value_detected_languages,omitempty"`
	// If the value is non-textual, this field represents the type. Current
	// valid values are:
	// - blank (this indicates the field_value is normal text)
	// - "unfilled_checkbox"
	// - "filled_checkbox"
	ValueType string `protobuf:"bytes,5,opt,name=value_type,json=valueType,proto3" json:"value_type,omitempty"`
	// An internal field, created for Labeling UI to export key text.
	CorrectedKeyText string `protobuf:"bytes,6,opt,name=corrected_key_text,json=correctedKeyText,proto3" json:"corrected_key_text,omitempty"`
	// An internal field, created for Labeling UI to export value text.
	CorrectedValueText   string   `protobuf:"bytes,7,opt,name=corrected_value_text,json=correctedValueText,proto3" json:"corrected_value_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Page_FormField) Reset()         { *m = Document_Page_FormField{} }
func (m *Document_Page_FormField) String() string { return proto.CompactTextString(m) }
func (*Document_Page_FormField) ProtoMessage()    {}
func (*Document_Page_FormField) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 8}
}

func (m *Document_Page_FormField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_FormField.Unmarshal(m, b)
}
func (m *Document_Page_FormField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_FormField.Marshal(b, m, deterministic)
}
func (m *Document_Page_FormField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_FormField.Merge(m, src)
}
func (m *Document_Page_FormField) XXX_Size() int {
	return xxx_messageInfo_Document_Page_FormField.Size(m)
}
func (m *Document_Page_FormField) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_FormField.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_FormField proto.InternalMessageInfo

func (m *Document_Page_FormField) GetFieldName() *Document_Page_Layout {
	if m != nil {
		return m.FieldName
	}
	return nil
}

func (m *Document_Page_FormField) GetFieldValue() *Document_Page_Layout {
	if m != nil {
		return m.FieldValue
	}
	return nil
}

func (m *Document_Page_FormField) GetNameDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.NameDetectedLanguages
	}
	return nil
}

func (m *Document_Page_FormField) GetValueDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.ValueDetectedLanguages
	}
	return nil
}

func (m *Document_Page_FormField) GetValueType() string {
	if m != nil {
		return m.ValueType
	}
	return ""
}

func (m *Document_Page_FormField) GetCorrectedKeyText() string {
	if m != nil {
		return m.CorrectedKeyText
	}
	return ""
}

func (m *Document_Page_FormField) GetCorrectedValueText() string {
	if m != nil {
		return m.CorrectedValueText
	}
	return ""
}

// Detected language for a structural component.
type Document_Page_DetectedLanguage struct {
	// The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Confidence of detected language. Range [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Page_DetectedLanguage) Reset()         { *m = Document_Page_DetectedLanguage{} }
func (m *Document_Page_DetectedLanguage) String() string { return proto.CompactTextString(m) }
func (*Document_Page_DetectedLanguage) ProtoMessage()    {}
func (*Document_Page_DetectedLanguage) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 3, 9}
}

func (m *Document_Page_DetectedLanguage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_DetectedLanguage.Unmarshal(m, b)
}
func (m *Document_Page_DetectedLanguage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_DetectedLanguage.Marshal(b, m, deterministic)
}
func (m *Document_Page_DetectedLanguage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_DetectedLanguage.Merge(m, src)
}
func (m *Document_Page_DetectedLanguage) XXX_Size() int {
	return xxx_messageInfo_Document_Page_DetectedLanguage.Size(m)
}
func (m *Document_Page_DetectedLanguage) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_DetectedLanguage.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_DetectedLanguage proto.InternalMessageInfo

func (m *Document_Page_DetectedLanguage) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *Document_Page_DetectedLanguage) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// A phrase in the text that is a known entity type, such as a person, an
// organization, or location.
type Document_Entity struct {
	// Provenance of the entity.
	// Text anchor indexing into the [Document.text][google.cloud.documentai.v1beta2.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Entity type from a schema e.g. `Address`.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Text value in the document e.g. `1600 Amphitheatre Pkwy`.
	MentionText string `protobuf:"bytes,3,opt,name=mention_text,json=mentionText,proto3" json:"mention_text,omitempty"`
	// Deprecated.  Use `id` field instead.
	MentionId string `protobuf:"bytes,4,opt,name=mention_id,json=mentionId,proto3" json:"mention_id,omitempty"`
	// Optional. Confidence of detected Schema entity. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Optional. Represents the provenance of this entity wrt. the location on the
	// page where it was found.
	PageAnchor *Document_PageAnchor `protobuf:"bytes,6,opt,name=page_anchor,json=pageAnchor,proto3" json:"page_anchor,omitempty"`
	// Optional. Canonical id. This will be a unique value in the entity list
	// for this document.
	Id string `protobuf:"bytes,7,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. Temporary field to store the bounding poly for short-term POCs. Used by
	// the frontend only. Do not use before you talk to ybo@ and lukasr@.
	BoundingPolyForDemoFrontend *BoundingPoly `protobuf:"bytes,8,opt,name=bounding_poly_for_demo_frontend,json=boundingPolyForDemoFrontend,proto3" json:"bounding_poly_for_demo_frontend,omitempty"`
	XXX_NoUnkeyedLiteral        struct{}      `json:"-"`
	XXX_unrecognized            []byte        `json:"-"`
	XXX_sizecache               int32         `json:"-"`
}

func (m *Document_Entity) Reset()         { *m = Document_Entity{} }
func (m *Document_Entity) String() string { return proto.CompactTextString(m) }
func (*Document_Entity) ProtoMessage()    {}
func (*Document_Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 4}
}

func (m *Document_Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Entity.Unmarshal(m, b)
}
func (m *Document_Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Entity.Marshal(b, m, deterministic)
}
func (m *Document_Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Entity.Merge(m, src)
}
func (m *Document_Entity) XXX_Size() int {
	return xxx_messageInfo_Document_Entity.Size(m)
}
func (m *Document_Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Entity proto.InternalMessageInfo

func (m *Document_Entity) GetTextAnchor() *Document_TextAnchor {
	if m != nil {
		return m.TextAnchor
	}
	return nil
}

func (m *Document_Entity) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Document_Entity) GetMentionText() string {
	if m != nil {
		return m.MentionText
	}
	return ""
}

func (m *Document_Entity) GetMentionId() string {
	if m != nil {
		return m.MentionId
	}
	return ""
}

func (m *Document_Entity) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *Document_Entity) GetPageAnchor() *Document_PageAnchor {
	if m != nil {
		return m.PageAnchor
	}
	return nil
}

func (m *Document_Entity) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Document_Entity) GetBoundingPolyForDemoFrontend() *BoundingPoly {
	if m != nil {
		return m.BoundingPolyForDemoFrontend
	}
	return nil
}

// Relationship between [Entities][google.cloud.documentai.v1beta2.Document.Entity].
type Document_EntityRelation struct {
	// Subject entity id.
	SubjectId string `protobuf:"bytes,1,opt,name=subject_id,json=subjectId,proto3" json:"subject_id,omitempty"`
	// Object entity id.
	ObjectId string `protobuf:"bytes,2,opt,name=object_id,json=objectId,proto3" json:"object_id,omitempty"`
	// Relationship description.
	Relation             string   `protobuf:"bytes,3,opt,name=relation,proto3" json:"relation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_EntityRelation) Reset()         { *m = Document_EntityRelation{} }
func (m *Document_EntityRelation) String() string { return proto.CompactTextString(m) }
func (*Document_EntityRelation) ProtoMessage()    {}
func (*Document_EntityRelation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 5}
}

func (m *Document_EntityRelation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_EntityRelation.Unmarshal(m, b)
}
func (m *Document_EntityRelation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_EntityRelation.Marshal(b, m, deterministic)
}
func (m *Document_EntityRelation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_EntityRelation.Merge(m, src)
}
func (m *Document_EntityRelation) XXX_Size() int {
	return xxx_messageInfo_Document_EntityRelation.Size(m)
}
func (m *Document_EntityRelation) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_EntityRelation.DiscardUnknown(m)
}

var xxx_messageInfo_Document_EntityRelation proto.InternalMessageInfo

func (m *Document_EntityRelation) GetSubjectId() string {
	if m != nil {
		return m.SubjectId
	}
	return ""
}

func (m *Document_EntityRelation) GetObjectId() string {
	if m != nil {
		return m.ObjectId
	}
	return ""
}

func (m *Document_EntityRelation) GetRelation() string {
	if m != nil {
		return m.Relation
	}
	return ""
}

// Text reference indexing into the [Document.text][google.cloud.documentai.v1beta2.Document.text].
type Document_TextAnchor struct {
	// The text segments from the [Document.text][google.cloud.documentai.v1beta2.Document.text].
	TextSegments         []*Document_TextAnchor_TextSegment `protobuf:"bytes,1,rep,name=text_segments,json=textSegments,proto3" json:"text_segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *Document_TextAnchor) Reset()         { *m = Document_TextAnchor{} }
func (m *Document_TextAnchor) String() string { return proto.CompactTextString(m) }
func (*Document_TextAnchor) ProtoMessage()    {}
func (*Document_TextAnchor) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 6}
}

func (m *Document_TextAnchor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_TextAnchor.Unmarshal(m, b)
}
func (m *Document_TextAnchor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_TextAnchor.Marshal(b, m, deterministic)
}
func (m *Document_TextAnchor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_TextAnchor.Merge(m, src)
}
func (m *Document_TextAnchor) XXX_Size() int {
	return xxx_messageInfo_Document_TextAnchor.Size(m)
}
func (m *Document_TextAnchor) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_TextAnchor.DiscardUnknown(m)
}

var xxx_messageInfo_Document_TextAnchor proto.InternalMessageInfo

func (m *Document_TextAnchor) GetTextSegments() []*Document_TextAnchor_TextSegment {
	if m != nil {
		return m.TextSegments
	}
	return nil
}

// A text segment in the [Document.text][google.cloud.documentai.v1beta2.Document.text]. The indices may be out of bounds
// which indicate that the text extends into another document shard for
// large sharded documents. See [ShardInfo.text_offset][google.cloud.documentai.v1beta2.Document.ShardInfo.text_offset]
type Document_TextAnchor_TextSegment struct {
	// [TextSegment][google.cloud.documentai.v1beta2.Document.TextAnchor.TextSegment] start UTF-8 char index in the [Document.text][google.cloud.documentai.v1beta2.Document.text].
	StartIndex int64 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// [TextSegment][google.cloud.documentai.v1beta2.Document.TextAnchor.TextSegment] half open end UTF-8 char index in the
	// [Document.text][google.cloud.documentai.v1beta2.Document.text].
	EndIndex             int64    `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_TextAnchor_TextSegment) Reset()         { *m = Document_TextAnchor_TextSegment{} }
func (m *Document_TextAnchor_TextSegment) String() string { return proto.CompactTextString(m) }
func (*Document_TextAnchor_TextSegment) ProtoMessage()    {}
func (*Document_TextAnchor_TextSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 6, 0}
}

func (m *Document_TextAnchor_TextSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_TextAnchor_TextSegment.Unmarshal(m, b)
}
func (m *Document_TextAnchor_TextSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_TextAnchor_TextSegment.Marshal(b, m, deterministic)
}
func (m *Document_TextAnchor_TextSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_TextAnchor_TextSegment.Merge(m, src)
}
func (m *Document_TextAnchor_TextSegment) XXX_Size() int {
	return xxx_messageInfo_Document_TextAnchor_TextSegment.Size(m)
}
func (m *Document_TextAnchor_TextSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_TextAnchor_TextSegment.DiscardUnknown(m)
}

var xxx_messageInfo_Document_TextAnchor_TextSegment proto.InternalMessageInfo

func (m *Document_TextAnchor_TextSegment) GetStartIndex() int64 {
	if m != nil {
		return m.StartIndex
	}
	return 0
}

func (m *Document_TextAnchor_TextSegment) GetEndIndex() int64 {
	if m != nil {
		return m.EndIndex
	}
	return 0
}

// Referencing elements in [Document.pages][google.cloud.documentai.v1beta2.Document.pages].
type Document_PageAnchor struct {
	// One or more references to visual page elements
	PageRefs             []*Document_PageAnchor_PageRef `protobuf:"bytes,1,rep,name=page_refs,json=pageRefs,proto3" json:"page_refs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *Document_PageAnchor) Reset()         { *m = Document_PageAnchor{} }
func (m *Document_PageAnchor) String() string { return proto.CompactTextString(m) }
func (*Document_PageAnchor) ProtoMessage()    {}
func (*Document_PageAnchor) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 7}
}

func (m *Document_PageAnchor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_PageAnchor.Unmarshal(m, b)
}
func (m *Document_PageAnchor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_PageAnchor.Marshal(b, m, deterministic)
}
func (m *Document_PageAnchor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_PageAnchor.Merge(m, src)
}
func (m *Document_PageAnchor) XXX_Size() int {
	return xxx_messageInfo_Document_PageAnchor.Size(m)
}
func (m *Document_PageAnchor) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_PageAnchor.DiscardUnknown(m)
}

var xxx_messageInfo_Document_PageAnchor proto.InternalMessageInfo

func (m *Document_PageAnchor) GetPageRefs() []*Document_PageAnchor_PageRef {
	if m != nil {
		return m.PageRefs
	}
	return nil
}

// Represents a weak reference to a page element within a document.
type Document_PageAnchor_PageRef struct {
	// Required. Index into the [Document.pages][google.cloud.documentai.v1beta2.Document.pages] element
	Page int64 `protobuf:"varint,1,opt,name=page,proto3" json:"page,omitempty"`
	// Optional. The type of the layout element that is being referenced.  If not
	// specified the whole page is assumed to be referenced.
	LayoutType Document_PageAnchor_PageRef_LayoutType `protobuf:"varint,2,opt,name=layout_type,json=layoutType,proto3,enum=google.cloud.documentai.v1beta2.Document_PageAnchor_PageRef_LayoutType" json:"layout_type,omitempty"`
	// Optional. The [Page.Layout.id][google.cloud.documentai.v1beta2.Document.Page.Layout.id] on the page that this element
	// references.  If [LayoutRef.type][] is specified this id must also be
	// specified.
	LayoutId             string   `protobuf:"bytes,3,opt,name=layout_id,json=layoutId,proto3" json:"layout_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_PageAnchor_PageRef) Reset()         { *m = Document_PageAnchor_PageRef{} }
func (m *Document_PageAnchor_PageRef) String() string { return proto.CompactTextString(m) }
func (*Document_PageAnchor_PageRef) ProtoMessage()    {}
func (*Document_PageAnchor_PageRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea6f118aeb595182, []int{0, 7, 0}
}

func (m *Document_PageAnchor_PageRef) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_PageAnchor_PageRef.Unmarshal(m, b)
}
func (m *Document_PageAnchor_PageRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_PageAnchor_PageRef.Marshal(b, m, deterministic)
}
func (m *Document_PageAnchor_PageRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_PageAnchor_PageRef.Merge(m, src)
}
func (m *Document_PageAnchor_PageRef) XXX_Size() int {
	return xxx_messageInfo_Document_PageAnchor_PageRef.Size(m)
}
func (m *Document_PageAnchor_PageRef) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_PageAnchor_PageRef.DiscardUnknown(m)
}

var xxx_messageInfo_Document_PageAnchor_PageRef proto.InternalMessageInfo

func (m *Document_PageAnchor_PageRef) GetPage() int64 {
	if m != nil {
		return m.Page
	}
	return 0
}

func (m *Document_PageAnchor_PageRef) GetLayoutType() Document_PageAnchor_PageRef_LayoutType {
	if m != nil {
		return m.LayoutType
	}
	return Document_PageAnchor_PageRef_LAYOUT_TYPE_UNSPECIFIED
}

func (m *Document_PageAnchor_PageRef) GetLayoutId() string {
	if m != nil {
		return m.LayoutId
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.documentai.v1beta2.Document_Page_Layout_Orientation", Document_Page_Layout_Orientation_name, Document_Page_Layout_Orientation_value)
	proto.RegisterEnum("google.cloud.documentai.v1beta2.Document_Page_Token_DetectedBreak_Type", Document_Page_Token_DetectedBreak_Type_name, Document_Page_Token_DetectedBreak_Type_value)
	proto.RegisterEnum("google.cloud.documentai.v1beta2.Document_PageAnchor_PageRef_LayoutType", Document_PageAnchor_PageRef_LayoutType_name, Document_PageAnchor_PageRef_LayoutType_value)
	proto.RegisterType((*Document)(nil), "google.cloud.documentai.v1beta2.Document")
	proto.RegisterType((*Document_ShardInfo)(nil), "google.cloud.documentai.v1beta2.Document.ShardInfo")
	proto.RegisterType((*Document_Label)(nil), "google.cloud.documentai.v1beta2.Document.Label")
	proto.RegisterType((*Document_Style)(nil), "google.cloud.documentai.v1beta2.Document.Style")
	proto.RegisterType((*Document_Style_FontSize)(nil), "google.cloud.documentai.v1beta2.Document.Style.FontSize")
	proto.RegisterType((*Document_Page)(nil), "google.cloud.documentai.v1beta2.Document.Page")
	proto.RegisterType((*Document_Page_Dimension)(nil), "google.cloud.documentai.v1beta2.Document.Page.Dimension")
	proto.RegisterType((*Document_Page_Layout)(nil), "google.cloud.documentai.v1beta2.Document.Page.Layout")
	proto.RegisterType((*Document_Page_Block)(nil), "google.cloud.documentai.v1beta2.Document.Page.Block")
	proto.RegisterType((*Document_Page_Paragraph)(nil), "google.cloud.documentai.v1beta2.Document.Page.Paragraph")
	proto.RegisterType((*Document_Page_Line)(nil), "google.cloud.documentai.v1beta2.Document.Page.Line")
	proto.RegisterType((*Document_Page_Token)(nil), "google.cloud.documentai.v1beta2.Document.Page.Token")
	proto.RegisterType((*Document_Page_Token_DetectedBreak)(nil), "google.cloud.documentai.v1beta2.Document.Page.Token.DetectedBreak")
	proto.RegisterType((*Document_Page_VisualElement)(nil), "google.cloud.documentai.v1beta2.Document.Page.VisualElement")
	proto.RegisterType((*Document_Page_Table)(nil), "google.cloud.documentai.v1beta2.Document.Page.Table")
	proto.RegisterType((*Document_Page_Table_TableRow)(nil), "google.cloud.documentai.v1beta2.Document.Page.Table.TableRow")
	proto.RegisterType((*Document_Page_Table_TableCell)(nil), "google.cloud.documentai.v1beta2.Document.Page.Table.TableCell")
	proto.RegisterType((*Document_Page_FormField)(nil), "google.cloud.documentai.v1beta2.Document.Page.FormField")
	proto.RegisterType((*Document_Page_DetectedLanguage)(nil), "google.cloud.documentai.v1beta2.Document.Page.DetectedLanguage")
	proto.RegisterType((*Document_Entity)(nil), "google.cloud.documentai.v1beta2.Document.Entity")
	proto.RegisterType((*Document_EntityRelation)(nil), "google.cloud.documentai.v1beta2.Document.EntityRelation")
	proto.RegisterType((*Document_TextAnchor)(nil), "google.cloud.documentai.v1beta2.Document.TextAnchor")
	proto.RegisterType((*Document_TextAnchor_TextSegment)(nil), "google.cloud.documentai.v1beta2.Document.TextAnchor.TextSegment")
	proto.RegisterType((*Document_PageAnchor)(nil), "google.cloud.documentai.v1beta2.Document.PageAnchor")
	proto.RegisterType((*Document_PageAnchor_PageRef)(nil), "google.cloud.documentai.v1beta2.Document.PageAnchor.PageRef")
}

func init() {
	proto.RegisterFile("google/cloud/documentai/v1beta2/document.proto", fileDescriptor_ea6f118aeb595182)
}

var fileDescriptor_ea6f118aeb595182 = []byte{
	// 2003 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x59, 0x51, 0x6f, 0x23, 0x49,
	0x11, 0xde, 0xf1, 0xd8, 0x8e, 0xa7, 0x9c, 0x64, 0x4d, 0xb3, 0xdc, 0x9a, 0x59, 0x96, 0x0d, 0xbb,
	0x0f, 0xe4, 0x01, 0xec, 0x23, 0x7b, 0x48, 0x27, 0x71, 0x07, 0xd8, 0xb1, 0x93, 0x58, 0xeb, 0x38,
	0x56, 0xc7, 0xc9, 0x92, 0x45, 0x62, 0x18, 0xcf, 0xb4, 0x9d, 0xb9, 0x8c, 0xa7, 0xad, 0x99, 0x71,
	0x12, 0xdf, 0x13, 0x3c, 0xf1, 0x53, 0x78, 0xe1, 0x05, 0xc4, 0x1b, 0x42, 0xe2, 0xe5, 0x78, 0xe0,
	0x57, 0x20, 0x24, 0xc4, 0x2f, 0xe0, 0x1d, 0x75, 0x75, 0xcf, 0xd8, 0xce, 0xdd, 0x2a, 0x6b, 0x93,
	0xac, 0x74, 0x4f, 0xee, 0xae, 0xae, 0xfa, 0xba, 0xaa, 0xba, 0xba, 0xa6, 0xab, 0x0c, 0x95, 0x21,
	0xe7, 0x43, 0x9f, 0x55, 0x1d, 0x9f, 0x4f, 0xdc, 0xaa, 0xcb, 0x9d, 0xc9, 0x88, 0x05, 0xb1, 0xed,
	0x55, 0x2f, 0x7f, 0xd4, 0x67, 0xb1, 0xbd, 0x93, 0x92, 0x2a, 0xe3, 0x90, 0xc7, 0x9c, 0x3c, 0x93,
	0xfc, 0x15, 0xe4, 0xaf, 0xcc, 0xf8, 0x2b, 0x8a, 0xdf, 0x54, 0x0c, 0x55, 0x7b, 0xec, 0x55, 0x07,
	0x1e, 0xf3, 0x5d, 0xab, 0xcf, 0xce, 0xed, 0x4b, 0x8f, 0x87, 0x12, 0xc1, 0xbc, 0x75, 0xc7, 0x21,
	0xe3, 0x23, 0x16, 0x87, 0x53, 0xc5, 0xff, 0x58, 0xf1, 0x87, 0x63, 0xa7, 0x1a, 0xc5, 0x76, 0x3c,
	0x89, 0x6e, 0x2c, 0xc4, 0xd3, 0x31, 0xab, 0x3a, 0xdc, 0x4f, 0x77, 0xf8, 0xce, 0x9c, 0x0a, 0x76,
	0x10, 0xf0, 0xd8, 0x8e, 0x3d, 0x1e, 0x28, 0xb1, 0xe7, 0xff, 0x7d, 0x09, 0x85, 0x86, 0xda, 0x95,
	0x10, 0xd0, 0x27, 0xa1, 0x57, 0xd6, 0xb6, 0xb4, 0x6d, 0xe3, 0xe0, 0x01, 0x15, 0x13, 0x62, 0xc2,
	0x9a, 0xc3, 0x83, 0x98, 0x05, 0x71, 0x39, 0xb3, 0xa5, 0x6d, 0xaf, 0x1f, 0x3c, 0xa0, 0x09, 0x81,
	0x3c, 0x01, 0x63, 0xe4, 0x8d, 0x98, 0x25, 0xf6, 0x2c, 0xeb, 0x42, 0x8a, 0x16, 0x04, 0xa1, 0x37,
	0x1d, 0x33, 0x42, 0x20, 0x1b, 0xb3, 0xeb, 0xb8, 0x9c, 0x45, 0x3a, 0x8e, 0x49, 0x17, 0x8a, 0xe2,
	0xd7, 0x8a, 0xe2, 0xa9, 0xcf, 0xa2, 0x72, 0x6e, 0x4b, 0xdf, 0x2e, 0xee, 0x54, 0x2b, 0xb7, 0x78,
	0xb1, 0x92, 0x28, 0x58, 0x39, 0x16, 0x72, 0x14, 0x04, 0x06, 0x0e, 0x23, 0xd2, 0x80, 0xdc, 0xd8,
	0x1e, 0xb2, 0xa8, 0x9c, 0x47, 0xac, 0xca, 0xbb, 0x63, 0x75, 0xed, 0x21, 0xa3, 0x52, 0x98, 0xb4,
	0xa1, 0xc0, 0x82, 0xd8, 0x8b, 0x3d, 0x16, 0x95, 0xd7, 0x10, 0xe8, 0xc3, 0x77, 0x07, 0x6a, 0x0a,
	0xc9, 0x29, 0x4d, 0x11, 0x88, 0x03, 0x25, 0x1c, 0x4f, 0xad, 0x90, 0xf9, 0xd2, 0xdb, 0xe5, 0x02,
	0xa2, 0x7e, 0xbc, 0x34, 0xaa, 0x02, 0xa0, 0x0f, 0xd9, 0xc2, 0x3c, 0x22, 0x14, 0x20, 0x3a, 0xb7,
	0x43, 0xd7, 0xf2, 0x82, 0x01, 0x2f, 0x1b, 0x5b, 0xda, 0x76, 0x71, 0xe7, 0xe5, 0x12, 0x9e, 0x14,
	0xb2, 0xad, 0x60, 0xc0, 0xa9, 0x11, 0x25, 0x43, 0xb2, 0x0f, 0x79, 0xdf, 0xee, 0x33, 0x3f, 0x2a,
	0x17, 0x97, 0x3d, 0x99, 0xb6, 0x90, 0xa3, 0x4a, 0x9c, 0x6c, 0x43, 0x8e, 0x85, 0x21, 0x0f, 0xcb,
	0x80, 0x7a, 0x91, 0x04, 0x27, 0x1c, 0x3b, 0x95, 0x63, 0x8c, 0x5a, 0x2a, 0x19, 0xcc, 0x00, 0x8c,
	0x54, 0x15, 0xf2, 0x0c, 0x8a, 0x89, 0x4d, 0x2e, 0xbb, 0xc6, 0x38, 0xd4, 0x29, 0x28, 0xfd, 0x5c,
	0x76, 0x3d, 0x63, 0x70, 0xf8, 0x44, 0x05, 0x64, 0xc2, 0xb0, 0x2b, 0x28, 0x82, 0x01, 0x03, 0x8c,
	0x0f, 0x06, 0x11, 0x8b, 0x31, 0x26, 0x75, 0x19, 0x2f, 0x47, 0x48, 0x31, 0x3f, 0x83, 0x1c, 0xaa,
	0x4a, 0x5e, 0xc0, 0xba, 0x3d, 0x89, 0xf9, 0xc8, 0xb7, 0x46, 0xdc, 0x65, 0x3e, 0x62, 0x89, 0xa0,
	0x2f, 0x4a, 0xea, 0xa1, 0x20, 0x8a, 0x18, 0x0e, 0xec, 0x11, 0x93, 0x37, 0x82, 0xe2, 0x98, 0x7c,
	0x17, 0xc0, 0xe1, 0xc1, 0xc0, 0x73, 0x59, 0xe0, 0xc8, 0xa8, 0xcf, 0xd0, 0x39, 0x4a, 0xbd, 0x00,
	0xf9, 0x88, 0x4f, 0x42, 0x87, 0x99, 0x7f, 0xd1, 0x21, 0x87, 0x61, 0x4a, 0x4e, 0x94, 0x5a, 0x76,
	0xe0, 0x9c, 0xf3, 0x10, 0xe1, 0x8a, 0x3b, 0x1f, 0xbd, 0xbb, 0x77, 0x7b, 0xec, 0x3a, 0xae, 0xa1,
	0xac, 0x34, 0x46, 0x8e, 0x85, 0x9b, 0xf1, 0xa6, 0xa3, 0xf2, 0x73, 0x6e, 0x16, 0xf7, 0xb1, 0xb2,
	0x2b, 0x56, 0xa8, 0x64, 0x20, 0x9f, 0x42, 0xa9, 0x6f, 0x3b, 0x17, 0xc3, 0x90, 0x4f, 0x02, 0xe1,
	0x3d, 0x21, 0xa4, 0xbf, 0x55, 0xe8, 0xe1, 0x8c, 0x17, 0x09, 0xc2, 0xad, 0x03, 0x1e, 0xc4, 0xd6,
	0x15, 0xf3, 0x86, 0xe7, 0xc9, 0x95, 0x06, 0x41, 0x7a, 0x8d, 0x14, 0xf2, 0x14, 0x60, 0x76, 0xb1,
	0xcb, 0x39, 0x5c, 0x37, 0xd2, 0x6b, 0x4a, 0xbe, 0x0f, 0x0f, 0x71, 0xd9, 0x65, 0x0e, 0x0f, 0x31,
	0x80, 0xcb, 0x79, 0xe4, 0xd9, 0x14, 0xe4, 0x46, 0x4a, 0x25, 0x27, 0x60, 0xe0, 0x46, 0x91, 0xf7,
	0x39, 0x2b, 0xaf, 0xa1, 0x82, 0x1f, 0x2f, 0x99, 0x1e, 0x2a, 0x7b, 0x3c, 0x88, 0x8f, 0xbd, 0xcf,
	0x19, 0x2d, 0x0c, 0xd4, 0xc8, 0xdc, 0x81, 0x42, 0x42, 0x15, 0x67, 0x8a, 0xe8, 0x1a, 0x9e, 0x1c,
	0x8e, 0x05, 0x6d, 0x12, 0x78, 0x32, 0xa0, 0x0c, 0x8a, 0x63, 0xf3, 0x4f, 0x5b, 0x90, 0x15, 0x39,
	0x42, 0x18, 0x2f, 0xb2, 0x84, 0x15, 0x4c, 0x46, 0x7d, 0x26, 0x0f, 0x2f, 0x47, 0x41, 0x90, 0x3a,
	0x48, 0x21, 0xa7, 0x60, 0xb8, 0xde, 0x88, 0x05, 0x91, 0xb0, 0x2b, 0xb3, 0xac, 0xd2, 0x62, 0x8f,
	0x4a, 0x23, 0x91, 0xa7, 0x33, 0x28, 0x72, 0x28, 0xae, 0xe3, 0x94, 0x4f, 0x62, 0x75, 0x54, 0x3f,
	0x5e, 0x12, 0xb4, 0x8d, 0xc2, 0x54, 0x81, 0x90, 0x00, 0x88, 0xcb, 0x62, 0xe6, 0xc4, 0xcc, 0xb5,
	0x7c, 0x3b, 0x18, 0x4e, 0x30, 0x6f, 0x66, 0xf1, 0xa6, 0xff, 0x6c, 0x59, 0x7d, 0x15, 0x50, 0x5b,
	0xe1, 0xd0, 0x6f, 0xb8, 0x37, 0x28, 0x22, 0xa9, 0xe6, 0xfb, 0x3e, 0x77, 0x2e, 0x92, 0x3c, 0xff,
	0xd1, 0x92, 0x7b, 0xd4, 0x85, 0x30, 0x55, 0x18, 0xe4, 0x17, 0x00, 0x63, 0x3b, 0xb4, 0x87, 0xa1,
	0x3d, 0x3e, 0x4f, 0xb2, 0xfd, 0xb2, 0x5e, 0xee, 0x26, 0x00, 0x74, 0x0e, 0x8b, 0xb4, 0x20, 0xe7,
	0x7b, 0x41, 0x9a, 0xf9, 0x5f, 0x2e, 0xeb, 0x65, 0x2f, 0x60, 0x54, 0x22, 0x08, 0x93, 0x63, 0x7e,
	0xc1, 0xd2, 0x7c, 0xbf, 0xac, 0xc9, 0x3d, 0x21, 0x4c, 0x15, 0x06, 0x61, 0xf0, 0xf0, 0xd2, 0x8b,
	0x26, 0xb6, 0x6f, 0x31, 0x9f, 0x09, 0xa6, 0xa8, 0x6c, 0x20, 0xec, 0x27, 0x4b, 0xc2, 0x9e, 0x22,
	0x4a, 0x53, 0x82, 0xd0, 0xcd, 0xcb, 0xf9, 0xa9, 0x54, 0xda, 0xee, 0x8b, 0xef, 0x31, 0xac, 0xa6,
	0xb4, 0x10, 0xa6, 0x0a, 0x83, 0x9c, 0x89, 0x54, 0x11, 0x8e, 0x2c, 0x7c, 0xed, 0x24, 0x1f, 0x92,
	0x65, 0x0f, 0x6a, 0x8f, 0x87, 0xa3, 0x3d, 0x01, 0x20, 0x92, 0x8c, 0x1a, 0x46, 0xe6, 0x21, 0x18,
	0xe9, 0x3d, 0x21, 0x8f, 0x20, 0x77, 0xe5, 0xb9, 0xf1, 0xb9, 0xba, 0xc7, 0x72, 0x42, 0x3e, 0x80,
	0xfc, 0xb9, 0xcc, 0x51, 0x19, 0x24, 0xab, 0x59, 0x7a, 0xc1, 0xf5, 0xb9, 0x0b, 0xfe, 0x67, 0x1d,
	0xf2, 0xf2, 0x8a, 0xdc, 0x57, 0x7e, 0x5e, 0xfc, 0x54, 0x64, 0x6e, 0x7e, 0x2a, 0x08, 0x85, 0x8d,
	0xbe, 0x48, 0xb2, 0x5e, 0x30, 0xb4, 0xc6, 0xdc, 0x9f, 0xaa, 0x7b, 0xfe, 0xc3, 0x5b, 0x37, 0xae,
	0x2b, 0xa9, 0x2e, 0xf7, 0xa7, 0x74, 0xbd, 0x3f, 0x37, 0x23, 0x0e, 0x14, 0x79, 0xe8, 0x09, 0x76,
	0x4c, 0xb3, 0x22, 0x55, 0x6f, 0xee, 0xd4, 0x56, 0xca, 0x1c, 0x95, 0xa3, 0x19, 0x10, 0x9d, 0x47,
	0x25, 0xdf, 0x84, 0x8c, 0xe7, 0xca, 0x34, 0x5f, 0xd7, 0xff, 0x59, 0xd3, 0x68, 0xc6, 0x73, 0x9f,
	0x33, 0x28, 0xce, 0x09, 0x90, 0x27, 0xf0, 0xf8, 0x88, 0xb6, 0x9a, 0x9d, 0x5e, 0xad, 0xd7, 0x3a,
	0xea, 0x58, 0x27, 0x9d, 0xe3, 0x6e, 0x73, 0xb7, 0xb5, 0xd7, 0x6a, 0x36, 0x4a, 0x0f, 0x48, 0x11,
	0xd6, 0xba, 0xb5, 0xfd, 0xa6, 0x75, 0xd2, 0x2d, 0x69, 0x64, 0x13, 0x00, 0x27, 0xb4, 0xb5, 0x7f,
	0xd0, 0x2b, 0x65, 0xc8, 0x06, 0x18, 0x38, 0x6f, 0x1c, 0xbd, 0xee, 0x94, 0xf4, 0x74, 0xda, 0x6e,
	0xee, 0xf5, 0x4a, 0x59, 0xf3, 0xef, 0x1a, 0xe4, 0x30, 0x35, 0xcc, 0xe5, 0x47, 0xed, 0xfe, 0xf2,
	0x63, 0xe6, 0xbe, 0xf2, 0xa3, 0xf9, 0x0f, 0x0d, 0x8c, 0x34, 0x23, 0x7d, 0xdd, 0x8d, 0xf9, 0x42,
	0x83, 0xac, 0xc8, 0x84, 0x5f, 0x77, 0x3b, 0xfe, 0xad, 0x43, 0x0e, 0xb3, 0xf0, 0x5d, 0x1b, 0xe2,
	0xc1, 0x66, 0x6a, 0x48, 0x3f, 0x64, 0xf6, 0x85, 0x7a, 0x29, 0xd4, 0x57, 0xf9, 0x44, 0xa4, 0xa6,
	0xd4, 0x05, 0x12, 0xdd, 0x70, 0xe7, 0xa7, 0x6f, 0xf1, 0x99, 0x7e, 0x6f, 0x3e, 0xfb, 0xa3, 0x06,
	0x1b, 0x0b, 0x0a, 0x91, 0x5f, 0x42, 0x16, 0x6b, 0x42, 0x0d, 0xb3, 0xcf, 0xfe, 0xff, 0x6f, 0x62,
	0x45, 0x94, 0x94, 0x14, 0x41, 0x9f, 0xef, 0x42, 0x16, 0x0b, 0xcc, 0x47, 0x50, 0xea, 0x9d, 0x75,
	0x9b, 0x37, 0x32, 0x8b, 0x01, 0xb9, 0xe3, 0x6e, 0x6d, 0xb7, 0x29, 0xf3, 0xca, 0xeb, 0x56, 0xa3,
	0x69, 0xc9, 0x79, 0x86, 0x00, 0xe4, 0x0f, 0xce, 0xba, 0x07, 0xcd, 0x4e, 0x49, 0x37, 0xff, 0xa5,
	0xc1, 0xc6, 0xc2, 0x67, 0xf1, 0xae, 0xcf, 0x9b, 0x28, 0x17, 0xa8, 0x27, 0xa5, 0x18, 0xbf, 0xf7,
	0x83, 0xf9, 0x4f, 0x0e, 0x72, 0xf8, 0x75, 0xbe, 0x6b, 0xe3, 0x7e, 0x05, 0xc5, 0x73, 0x66, 0xbb,
	0x2c, 0xb4, 0x42, 0x7e, 0x95, 0x5c, 0xc7, 0x4f, 0x57, 0x79, 0x37, 0xa8, 0xd7, 0x03, 0xbf, 0xa2,
	0x20, 0x11, 0x29, 0xbf, 0x8a, 0xc8, 0x1b, 0x30, 0xfa, 0xdc, 0x9d, 0x4a, 0x74, 0xfd, 0x2e, 0xd0,
	0x0b, 0x02, 0x0f, 0xb1, 0xdf, 0xf3, 0x33, 0xd8, 0xfc, 0x35, 0x14, 0x12, 0x2d, 0x48, 0x0f, 0x72,
	0x0e, 0xf3, 0xfd, 0xa8, 0xac, 0xe1, 0x76, 0x3f, 0x5d, 0xdd, 0xa6, 0x5d, 0xe6, 0xfb, 0x54, 0x82,
	0x99, 0xbf, 0xc9, 0x80, 0x91, 0x12, 0xef, 0xfa, 0xa8, 0xbf, 0x0d, 0x85, 0x90, 0x5f, 0x59, 0xd1,
	0xd8, 0x96, 0xb5, 0x4d, 0x8e, 0xae, 0x85, 0xfc, 0xea, 0x78, 0x6c, 0x07, 0x62, 0xc9, 0xe1, 0xbe,
	0x5c, 0xd2, 0xe5, 0x92, 0xc3, 0x7d, 0x5c, 0x7a, 0xdf, 0x4e, 0xfe, 0x43, 0x16, 0x8c, 0xf4, 0xd1,
	0x48, 0x7a, 0x00, 0xb2, 0xd9, 0x96, 0x16, 0xef, 0x2b, 0xbb, 0xc1, 0x40, 0xa0, 0x8e, 0x28, 0xfc,
	0x4f, 0xa1, 0x28, 0x51, 0x2f, 0x6d, 0x7f, 0xc2, 0x54, 0xfa, 0x5e, 0x11, 0x56, 0xea, 0x77, 0x2a,
	0x80, 0xc8, 0x15, 0x3c, 0x16, 0x7a, 0x5a, 0xf7, 0x97, 0x1a, 0xbe, 0x25, 0xf0, 0x1b, 0x5f, 0x2a,
	0xd0, 0xa6, 0x50, 0x46, 0x53, 0xac, 0xfb, 0x3b, 0xaa, 0x0f, 0x70, 0x83, 0x2f, 0x6f, 0xfd, 0x14,
	0x40, 0x6e, 0x8d, 0x39, 0x52, 0xf5, 0x0b, 0x90, 0x82, 0xa9, 0xfd, 0x07, 0x40, 0x1c, 0x1e, 0x86,
	0x52, 0xa9, 0x0b, 0x36, 0xb5, 0xb0, 0x93, 0x28, 0x5b, 0x06, 0xa5, 0x74, 0xe5, 0x15, 0x9b, 0x8a,
	0x87, 0x37, 0xf9, 0x10, 0x1e, 0xcd, 0xb8, 0x15, 0xac, 0xe0, 0x5f, 0x43, 0xfe, 0x19, 0x12, 0xba,
	0x5b, 0x48, 0x98, 0xaf, 0xa1, 0x74, 0x53, 0x27, 0xf2, 0x02, 0x36, 0x12, 0xf3, 0x2d, 0x87, 0xbb,
	0x49, 0xd3, 0x67, 0x3d, 0x21, 0xee, 0x72, 0x97, 0xdd, 0xf6, 0xa2, 0x37, 0xbf, 0xd0, 0x21, 0x2f,
	0x3b, 0x77, 0xf7, 0x55, 0x53, 0x7c, 0xd5, 0x77, 0xe5, 0x7b, 0xb0, 0x2e, 0x44, 0x3c, 0x1e, 0x48,
	0xc3, 0x65, 0x95, 0x53, 0x54, 0x34, 0xf4, 0xd1, 0x53, 0x80, 0x84, 0xc5, 0x73, 0x55, 0x03, 0xc7,
	0x50, 0x94, 0x96, 0x4b, 0x5e, 0x2c, 0xd8, 0x25, 0xce, 0x23, 0x23, 0x1f, 0xf6, 0xf3, 0xe5, 0xca,
	0x1b, 0xd5, 0x08, 0x51, 0x16, 0xe5, 0x97, 0xb5, 0x48, 0x84, 0x88, 0xb4, 0x42, 0x61, 0x8f, 0x53,
	0x82, 0xaa, 0x28, 0xd6, 0x16, 0x2a, 0x0a, 0x72, 0x0d, 0xcf, 0x16, 0xea, 0x23, 0x6b, 0xc0, 0x43,
	0xcb, 0x65, 0x23, 0x6e, 0x0d, 0x42, 0x6c, 0x41, 0xbb, 0xe5, 0xc2, 0x0a, 0x15, 0x93, 0xdc, 0xe0,
	0xc9, 0x7c, 0xd9, 0xb4, 0xc7, 0xc3, 0x06, 0x1b, 0xf1, 0x3d, 0x05, 0x6b, 0x9e, 0xc3, 0xe6, 0x62,
	0x03, 0x56, 0x38, 0x30, 0x9a, 0xf4, 0x3f, 0x63, 0x4e, 0x2c, 0x1c, 0x28, 0x63, 0xc3, 0x50, 0x94,
	0x96, 0x4b, 0x9e, 0x80, 0xc1, 0xd3, 0x55, 0x79, 0x36, 0x05, 0x9e, 0x2c, 0x9a, 0x50, 0x48, 0x3a,
	0xc1, 0x49, 0x9b, 0x3c, 0x99, 0x9b, 0x7f, 0xd3, 0x00, 0x66, 0x47, 0x4d, 0x18, 0x6c, 0xc8, 0x46,
	0x1a, 0x1b, 0xca, 0x8a, 0x5f, 0x7e, 0x29, 0x7e, 0xbe, 0x4a, 0xdc, 0xe0, 0xf0, 0x58, 0x02, 0xd1,
	0xf5, 0x78, 0x36, 0x89, 0xcc, 0x57, 0x50, 0x9c, 0x5b, 0xc4, 0xbe, 0x6a, 0x6c, 0x87, 0xf1, 0x8d,
	0xc6, 0xab, 0x20, 0xc9, 0xc6, 0xeb, 0x13, 0x30, 0x58, 0x90, 0xf4, 0x65, 0x65, 0xdb, 0xb5, 0xc0,
	0x02, 0xd9, 0x95, 0x35, 0x7f, 0xaf, 0x03, 0xcc, 0xce, 0x96, 0x9c, 0x81, 0x81, 0x61, 0x12, 0xb2,
	0x41, 0xa2, 0xfe, 0x27, 0xab, 0x04, 0x89, 0xec, 0xd0, 0xb3, 0x01, 0x2d, 0x8c, 0xe5, 0x20, 0x32,
	0xff, 0x9a, 0x81, 0x35, 0x45, 0x25, 0x8f, 0x21, 0x2b, 0xe8, 0x52, 0x59, 0x71, 0xa4, 0x19, 0x8a,
	0x04, 0x32, 0x82, 0xa2, 0xfc, 0x76, 0x59, 0xe9, 0x45, 0x59, 0xfa, 0x0d, 0xba, 0xa8, 0x81, 0xca,
	0xda, 0x22, 0x35, 0xa9, 0xc8, 0xf5, 0x53, 0x02, 0xd9, 0x02, 0x43, 0x6d, 0xe7, 0xb9, 0xf2, 0x74,
	0x25, 0x4f, 0x41, 0x52, 0x5b, 0xee, 0xf3, 0xdf, 0x69, 0x00, 0x33, 0x04, 0x51, 0x18, 0xb7, 0x6b,
	0x67, 0x47, 0x27, 0x3d, 0xeb, 0xab, 0x9f, 0xaf, 0xf5, 0xf6, 0xd1, 0xee, 0xab, 0x92, 0x26, 0xeb,
	0x5e, 0x5a, 0xdb, 0xa7, 0xb5, 0xee, 0x41, 0x29, 0x43, 0x0a, 0x90, 0x6d, 0xb7, 0x3a, 0xcd, 0x92,
	0x2e, 0x78, 0x7a, 0x47, 0xaf, 0x9a, 0x9d, 0x52, 0x96, 0x10, 0xd8, 0x3c, 0x6d, 0x1d, 0x9f, 0xd4,
	0xda, 0x56, 0xb3, 0xdd, 0x3c, 0x6c, 0x76, 0x7a, 0xa5, 0x1c, 0x2e, 0xd7, 0xea, 0xed, 0x66, 0x29,
	0x2f, 0x5e, 0xc0, 0x7b, 0x47, 0xf4, 0xd0, 0xda, 0x6b, 0x35, 0xdb, 0x8d, 0xd2, 0xda, 0xac, 0x37,
	0x5d, 0xff, 0xad, 0x06, 0x2f, 0x1c, 0x3e, 0xba, 0xcd, 0x2b, 0xf5, 0x8d, 0xc4, 0x2d, 0xdd, 0x90,
	0xc7, 0xbc, 0xab, 0xbd, 0x69, 0x29, 0x89, 0x21, 0x17, 0x89, 0xb1, 0xc2, 0xc3, 0x61, 0x75, 0xc8,
	0x02, 0xfc, 0x33, 0xa9, 0x2a, 0x97, 0xec, 0xb1, 0x17, 0xbd, 0xf5, 0xff, 0xac, 0x9f, 0xcc, 0x48,
	0xfd, 0x3c, 0x4a, 0xbd, 0xfc, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x8b, 0xdc, 0x9c, 0xe3, 0x76,
	0x1b, 0x00, 0x00,
}
