// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto

package agentendpoint

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A request message to receive task notifications.
type ReceiveTaskNotificationRequest struct {
	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. The version of the agent making the request.
	AgentVersion         string   `protobuf:"bytes,2,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiveTaskNotificationRequest) Reset()         { *m = ReceiveTaskNotificationRequest{} }
func (m *ReceiveTaskNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*ReceiveTaskNotificationRequest) ProtoMessage()    {}
func (*ReceiveTaskNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{0}
}

func (m *ReceiveTaskNotificationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiveTaskNotificationRequest.Unmarshal(m, b)
}
func (m *ReceiveTaskNotificationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiveTaskNotificationRequest.Marshal(b, m, deterministic)
}
func (m *ReceiveTaskNotificationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiveTaskNotificationRequest.Merge(m, src)
}
func (m *ReceiveTaskNotificationRequest) XXX_Size() int {
	return xxx_messageInfo_ReceiveTaskNotificationRequest.Size(m)
}
func (m *ReceiveTaskNotificationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiveTaskNotificationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiveTaskNotificationRequest proto.InternalMessageInfo

func (m *ReceiveTaskNotificationRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *ReceiveTaskNotificationRequest) GetAgentVersion() string {
	if m != nil {
		return m.AgentVersion
	}
	return ""
}

// The streaming rpc message that notifies the agent when it has a task
// that it needs to perform on the VM instance.
type ReceiveTaskNotificationResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiveTaskNotificationResponse) Reset()         { *m = ReceiveTaskNotificationResponse{} }
func (m *ReceiveTaskNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*ReceiveTaskNotificationResponse) ProtoMessage()    {}
func (*ReceiveTaskNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{1}
}

func (m *ReceiveTaskNotificationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiveTaskNotificationResponse.Unmarshal(m, b)
}
func (m *ReceiveTaskNotificationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiveTaskNotificationResponse.Marshal(b, m, deterministic)
}
func (m *ReceiveTaskNotificationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiveTaskNotificationResponse.Merge(m, src)
}
func (m *ReceiveTaskNotificationResponse) XXX_Size() int {
	return xxx_messageInfo_ReceiveTaskNotificationResponse.Size(m)
}
func (m *ReceiveTaskNotificationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiveTaskNotificationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiveTaskNotificationResponse proto.InternalMessageInfo

// A request message for signaling the start of a task execution.
type StartNextTaskRequest struct {
	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken      string   `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartNextTaskRequest) Reset()         { *m = StartNextTaskRequest{} }
func (m *StartNextTaskRequest) String() string { return proto.CompactTextString(m) }
func (*StartNextTaskRequest) ProtoMessage()    {}
func (*StartNextTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{2}
}

func (m *StartNextTaskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartNextTaskRequest.Unmarshal(m, b)
}
func (m *StartNextTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartNextTaskRequest.Marshal(b, m, deterministic)
}
func (m *StartNextTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartNextTaskRequest.Merge(m, src)
}
func (m *StartNextTaskRequest) XXX_Size() int {
	return xxx_messageInfo_StartNextTaskRequest.Size(m)
}
func (m *StartNextTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartNextTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartNextTaskRequest proto.InternalMessageInfo

func (m *StartNextTaskRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

// A response message that contains the details of the task to work on.
type StartNextTaskResponse struct {
	// The details of the task that should be worked on.  Can be empty if there
	// is no new task to work on.
	Task                 *Task    `protobuf:"bytes,1,opt,name=task,proto3" json:"task,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartNextTaskResponse) Reset()         { *m = StartNextTaskResponse{} }
func (m *StartNextTaskResponse) String() string { return proto.CompactTextString(m) }
func (*StartNextTaskResponse) ProtoMessage()    {}
func (*StartNextTaskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{3}
}

func (m *StartNextTaskResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartNextTaskResponse.Unmarshal(m, b)
}
func (m *StartNextTaskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartNextTaskResponse.Marshal(b, m, deterministic)
}
func (m *StartNextTaskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartNextTaskResponse.Merge(m, src)
}
func (m *StartNextTaskResponse) XXX_Size() int {
	return xxx_messageInfo_StartNextTaskResponse.Size(m)
}
func (m *StartNextTaskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartNextTaskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartNextTaskResponse proto.InternalMessageInfo

func (m *StartNextTaskResponse) GetTask() *Task {
	if m != nil {
		return m.Task
	}
	return nil
}

// A request message for reporting the progress of current task.
type ReportTaskProgressRequest struct {
	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. Unique identifier of the task this applies to.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Required. The type of task to report progress on.
	//
	// Progress must include the appropriate message based on this enum as
	// specified below:
	// APPLY_PATCHES = ApplyPatchesTaskProgress
	// EXEC_STEP = Progress not supported for this type.
	TaskType TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.cloud.osconfig.agentendpoint.v1.TaskType" json:"task_type,omitempty"`
	// Intermediate progress of the current task.
	//
	// Types that are valid to be assigned to Progress:
	//	*ReportTaskProgressRequest_ApplyPatchesTaskProgress
	//	*ReportTaskProgressRequest_ExecStepTaskProgress
	Progress             isReportTaskProgressRequest_Progress `protobuf_oneof:"progress"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ReportTaskProgressRequest) Reset()         { *m = ReportTaskProgressRequest{} }
func (m *ReportTaskProgressRequest) String() string { return proto.CompactTextString(m) }
func (*ReportTaskProgressRequest) ProtoMessage()    {}
func (*ReportTaskProgressRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{4}
}

func (m *ReportTaskProgressRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskProgressRequest.Unmarshal(m, b)
}
func (m *ReportTaskProgressRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskProgressRequest.Marshal(b, m, deterministic)
}
func (m *ReportTaskProgressRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskProgressRequest.Merge(m, src)
}
func (m *ReportTaskProgressRequest) XXX_Size() int {
	return xxx_messageInfo_ReportTaskProgressRequest.Size(m)
}
func (m *ReportTaskProgressRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskProgressRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskProgressRequest proto.InternalMessageInfo

func (m *ReportTaskProgressRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *ReportTaskProgressRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *ReportTaskProgressRequest) GetTaskType() TaskType {
	if m != nil {
		return m.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

type isReportTaskProgressRequest_Progress interface {
	isReportTaskProgressRequest_Progress()
}

type ReportTaskProgressRequest_ApplyPatchesTaskProgress struct {
	ApplyPatchesTaskProgress *ApplyPatchesTaskProgress `protobuf:"bytes,4,opt,name=apply_patches_task_progress,json=applyPatchesTaskProgress,proto3,oneof"`
}

type ReportTaskProgressRequest_ExecStepTaskProgress struct {
	ExecStepTaskProgress *ExecStepTaskProgress `protobuf:"bytes,5,opt,name=exec_step_task_progress,json=execStepTaskProgress,proto3,oneof"`
}

func (*ReportTaskProgressRequest_ApplyPatchesTaskProgress) isReportTaskProgressRequest_Progress() {}

func (*ReportTaskProgressRequest_ExecStepTaskProgress) isReportTaskProgressRequest_Progress() {}

func (m *ReportTaskProgressRequest) GetProgress() isReportTaskProgressRequest_Progress {
	if m != nil {
		return m.Progress
	}
	return nil
}

func (m *ReportTaskProgressRequest) GetApplyPatchesTaskProgress() *ApplyPatchesTaskProgress {
	if x, ok := m.GetProgress().(*ReportTaskProgressRequest_ApplyPatchesTaskProgress); ok {
		return x.ApplyPatchesTaskProgress
	}
	return nil
}

func (m *ReportTaskProgressRequest) GetExecStepTaskProgress() *ExecStepTaskProgress {
	if x, ok := m.GetProgress().(*ReportTaskProgressRequest_ExecStepTaskProgress); ok {
		return x.ExecStepTaskProgress
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReportTaskProgressRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReportTaskProgressRequest_ApplyPatchesTaskProgress)(nil),
		(*ReportTaskProgressRequest_ExecStepTaskProgress)(nil),
	}
}

// The response message after the agent reported the current task progress.
type ReportTaskProgressResponse struct {
	// Instructs agent to continue or not.
	TaskDirective        TaskDirective `protobuf:"varint,1,opt,name=task_directive,json=taskDirective,proto3,enum=google.cloud.osconfig.agentendpoint.v1.TaskDirective" json:"task_directive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ReportTaskProgressResponse) Reset()         { *m = ReportTaskProgressResponse{} }
func (m *ReportTaskProgressResponse) String() string { return proto.CompactTextString(m) }
func (*ReportTaskProgressResponse) ProtoMessage()    {}
func (*ReportTaskProgressResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{5}
}

func (m *ReportTaskProgressResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskProgressResponse.Unmarshal(m, b)
}
func (m *ReportTaskProgressResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskProgressResponse.Marshal(b, m, deterministic)
}
func (m *ReportTaskProgressResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskProgressResponse.Merge(m, src)
}
func (m *ReportTaskProgressResponse) XXX_Size() int {
	return xxx_messageInfo_ReportTaskProgressResponse.Size(m)
}
func (m *ReportTaskProgressResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskProgressResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskProgressResponse proto.InternalMessageInfo

func (m *ReportTaskProgressResponse) GetTaskDirective() TaskDirective {
	if m != nil {
		return m.TaskDirective
	}
	return TaskDirective_TASK_DIRECTIVE_UNSPECIFIED
}

// A request message for signaling the completion of a task execution.
type ReportTaskCompleteRequest struct {
	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. Unique identifier of the task this applies to.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Required. The type of task to report completed.
	//
	// The output must include the appropriate message based on the following
	// enum values:
	// APPLY_PATCHES = ApplyPatchesTaskOutput
	// EXEC_STEP = ExecStepTaskOutput
	TaskType TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.cloud.osconfig.agentendpoint.v1.TaskType" json:"task_type,omitempty"`
	// Descriptive error message if the task execution ended in error.
	ErrorMessage string `protobuf:"bytes,4,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Final output details of the current task.
	//
	// Types that are valid to be assigned to Output:
	//	*ReportTaskCompleteRequest_ApplyPatchesTaskOutput
	//	*ReportTaskCompleteRequest_ExecStepTaskOutput
	Output               isReportTaskCompleteRequest_Output `protobuf_oneof:"output"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ReportTaskCompleteRequest) Reset()         { *m = ReportTaskCompleteRequest{} }
func (m *ReportTaskCompleteRequest) String() string { return proto.CompactTextString(m) }
func (*ReportTaskCompleteRequest) ProtoMessage()    {}
func (*ReportTaskCompleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{6}
}

func (m *ReportTaskCompleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskCompleteRequest.Unmarshal(m, b)
}
func (m *ReportTaskCompleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskCompleteRequest.Marshal(b, m, deterministic)
}
func (m *ReportTaskCompleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskCompleteRequest.Merge(m, src)
}
func (m *ReportTaskCompleteRequest) XXX_Size() int {
	return xxx_messageInfo_ReportTaskCompleteRequest.Size(m)
}
func (m *ReportTaskCompleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskCompleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskCompleteRequest proto.InternalMessageInfo

func (m *ReportTaskCompleteRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *ReportTaskCompleteRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *ReportTaskCompleteRequest) GetTaskType() TaskType {
	if m != nil {
		return m.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

func (m *ReportTaskCompleteRequest) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

type isReportTaskCompleteRequest_Output interface {
	isReportTaskCompleteRequest_Output()
}

type ReportTaskCompleteRequest_ApplyPatchesTaskOutput struct {
	ApplyPatchesTaskOutput *ApplyPatchesTaskOutput `protobuf:"bytes,5,opt,name=apply_patches_task_output,json=applyPatchesTaskOutput,proto3,oneof"`
}

type ReportTaskCompleteRequest_ExecStepTaskOutput struct {
	ExecStepTaskOutput *ExecStepTaskOutput `protobuf:"bytes,6,opt,name=exec_step_task_output,json=execStepTaskOutput,proto3,oneof"`
}

func (*ReportTaskCompleteRequest_ApplyPatchesTaskOutput) isReportTaskCompleteRequest_Output() {}

func (*ReportTaskCompleteRequest_ExecStepTaskOutput) isReportTaskCompleteRequest_Output() {}

func (m *ReportTaskCompleteRequest) GetOutput() isReportTaskCompleteRequest_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (m *ReportTaskCompleteRequest) GetApplyPatchesTaskOutput() *ApplyPatchesTaskOutput {
	if x, ok := m.GetOutput().(*ReportTaskCompleteRequest_ApplyPatchesTaskOutput); ok {
		return x.ApplyPatchesTaskOutput
	}
	return nil
}

func (m *ReportTaskCompleteRequest) GetExecStepTaskOutput() *ExecStepTaskOutput {
	if x, ok := m.GetOutput().(*ReportTaskCompleteRequest_ExecStepTaskOutput); ok {
		return x.ExecStepTaskOutput
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReportTaskCompleteRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReportTaskCompleteRequest_ApplyPatchesTaskOutput)(nil),
		(*ReportTaskCompleteRequest_ExecStepTaskOutput)(nil),
	}
}

// The response message after the agent signaled the current task complete.
type ReportTaskCompleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportTaskCompleteResponse) Reset()         { *m = ReportTaskCompleteResponse{} }
func (m *ReportTaskCompleteResponse) String() string { return proto.CompactTextString(m) }
func (*ReportTaskCompleteResponse) ProtoMessage()    {}
func (*ReportTaskCompleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{7}
}

func (m *ReportTaskCompleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskCompleteResponse.Unmarshal(m, b)
}
func (m *ReportTaskCompleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskCompleteResponse.Marshal(b, m, deterministic)
}
func (m *ReportTaskCompleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskCompleteResponse.Merge(m, src)
}
func (m *ReportTaskCompleteResponse) XXX_Size() int {
	return xxx_messageInfo_ReportTaskCompleteResponse.Size(m)
}
func (m *ReportTaskCompleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskCompleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskCompleteResponse proto.InternalMessageInfo

// The request message for registering the agent.
type RegisterAgentRequest struct {
	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. The version of the agent.
	AgentVersion string `protobuf:"bytes,2,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	// Required. The capabilities supported by the agent. Supported values are:
	// PATCH_GA
	// GUEST_POLICY_BETA
	SupportedCapabilities []string `protobuf:"bytes,3,rep,name=supported_capabilities,json=supportedCapabilities,proto3" json:"supported_capabilities,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *RegisterAgentRequest) Reset()         { *m = RegisterAgentRequest{} }
func (m *RegisterAgentRequest) String() string { return proto.CompactTextString(m) }
func (*RegisterAgentRequest) ProtoMessage()    {}
func (*RegisterAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{8}
}

func (m *RegisterAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterAgentRequest.Unmarshal(m, b)
}
func (m *RegisterAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterAgentRequest.Marshal(b, m, deterministic)
}
func (m *RegisterAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterAgentRequest.Merge(m, src)
}
func (m *RegisterAgentRequest) XXX_Size() int {
	return xxx_messageInfo_RegisterAgentRequest.Size(m)
}
func (m *RegisterAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterAgentRequest proto.InternalMessageInfo

func (m *RegisterAgentRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *RegisterAgentRequest) GetAgentVersion() string {
	if m != nil {
		return m.AgentVersion
	}
	return ""
}

func (m *RegisterAgentRequest) GetSupportedCapabilities() []string {
	if m != nil {
		return m.SupportedCapabilities
	}
	return nil
}

// The response message after the agent registered.
type RegisterAgentResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterAgentResponse) Reset()         { *m = RegisterAgentResponse{} }
func (m *RegisterAgentResponse) String() string { return proto.CompactTextString(m) }
func (*RegisterAgentResponse) ProtoMessage()    {}
func (*RegisterAgentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f93e46ac0eb725c7, []int{9}
}

func (m *RegisterAgentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterAgentResponse.Unmarshal(m, b)
}
func (m *RegisterAgentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterAgentResponse.Marshal(b, m, deterministic)
}
func (m *RegisterAgentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterAgentResponse.Merge(m, src)
}
func (m *RegisterAgentResponse) XXX_Size() int {
	return xxx_messageInfo_RegisterAgentResponse.Size(m)
}
func (m *RegisterAgentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterAgentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterAgentResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ReceiveTaskNotificationRequest)(nil), "google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationRequest")
	proto.RegisterType((*ReceiveTaskNotificationResponse)(nil), "google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationResponse")
	proto.RegisterType((*StartNextTaskRequest)(nil), "google.cloud.osconfig.agentendpoint.v1.StartNextTaskRequest")
	proto.RegisterType((*StartNextTaskResponse)(nil), "google.cloud.osconfig.agentendpoint.v1.StartNextTaskResponse")
	proto.RegisterType((*ReportTaskProgressRequest)(nil), "google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressRequest")
	proto.RegisterType((*ReportTaskProgressResponse)(nil), "google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressResponse")
	proto.RegisterType((*ReportTaskCompleteRequest)(nil), "google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteRequest")
	proto.RegisterType((*ReportTaskCompleteResponse)(nil), "google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteResponse")
	proto.RegisterType((*RegisterAgentRequest)(nil), "google.cloud.osconfig.agentendpoint.v1.RegisterAgentRequest")
	proto.RegisterType((*RegisterAgentResponse)(nil), "google.cloud.osconfig.agentendpoint.v1.RegisterAgentResponse")
}

func init() {
	proto.RegisterFile("google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto", fileDescriptor_f93e46ac0eb725c7)
}

var fileDescriptor_f93e46ac0eb725c7 = []byte{
	// 847 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x56, 0xcf, 0x6f, 0xe3, 0x44,
	0x14, 0x5e, 0x6f, 0x96, 0x90, 0x0e, 0x9b, 0x22, 0x46, 0xc9, 0x26, 0x6b, 0x56, 0xb4, 0x78, 0xa5,
	0x55, 0x85, 0x22, 0x7b, 0x1b, 0x7e, 0x48, 0x94, 0x1f, 0x5a, 0x67, 0x59, 0x76, 0x7b, 0xa0, 0x44,
	0x4e, 0x85, 0x04, 0x42, 0xb2, 0xa6, 0xf6, 0xab, 0x3b, 0xaa, 0xe3, 0x19, 0x3c, 0x93, 0xa8, 0xa5,
	0x27, 0xfe, 0x01, 0xae, 0xdc, 0xb9, 0xf3, 0x57, 0x20, 0x84, 0xc4, 0x09, 0xae, 0xe1, 0xc2, 0x9f,
	0x82, 0x3c, 0x76, 0xd2, 0x38, 0x71, 0xa8, 0x9b, 0x8a, 0xc3, 0x1e, 0xfd, 0xde, 0xbc, 0xf7, 0xbd,
	0xf9, 0xe6, 0x9b, 0x6f, 0x8c, 0xf6, 0x02, 0xc6, 0x82, 0x10, 0x2c, 0x2f, 0x64, 0x23, 0xdf, 0x62,
	0xc2, 0x63, 0xd1, 0x31, 0x0d, 0x2c, 0x12, 0x40, 0x24, 0x21, 0xf2, 0x39, 0xa3, 0x91, 0xb4, 0xc6,
	0xbb, 0xf9, 0x80, 0xc9, 0x63, 0x26, 0x19, 0x7e, 0x94, 0xd6, 0x9a, 0xaa, 0xd6, 0x9c, 0xd6, 0x9a,
	0xf9, 0xa5, 0xe3, 0x5d, 0xbd, 0x95, 0x61, 0x10, 0x4e, 0x2d, 0x2f, 0xa4, 0x30, 0x6d, 0xa0, 0x6f,
	0xcd, 0x25, 0x8e, 0x29, 0x84, 0xbe, 0x7b, 0x04, 0x27, 0x64, 0x4c, 0x59, 0x9c, 0x2d, 0xe8, 0x96,
	0x9c, 0x4e, 0x12, 0x71, 0x2a, 0xd2, 0x1a, 0xe3, 0x02, 0xbd, 0xe5, 0x80, 0x07, 0x74, 0x0c, 0x87,
	0x44, 0x9c, 0x1e, 0x30, 0x49, 0x8f, 0xa9, 0x47, 0x24, 0x65, 0x91, 0x03, 0xdf, 0x8d, 0x40, 0x48,
	0x6c, 0xa1, 0x37, 0x68, 0x24, 0x24, 0x89, 0x3c, 0x70, 0xa9, 0xef, 0x4a, 0x76, 0x0a, 0x51, 0x5b,
	0xdb, 0xd6, 0x76, 0x36, 0x7a, 0x95, 0x7f, 0xec, 0xdb, 0xce, 0xeb, 0xd3, 0xec, 0xbe, 0x7f, 0x98,
	0xe4, 0xf0, 0x0e, 0xaa, 0x2b, 0x48, 0x77, 0x0c, 0xb1, 0xa0, 0x2c, 0x6a, 0xdf, 0xbe, 0x5c, 0x7c,
	0x57, 0x65, 0xbe, 0x4a, 0x13, 0xc6, 0xdb, 0x68, 0x6b, 0x25, 0xb8, 0xe0, 0x2c, 0x12, 0x60, 0x3c,
	0x47, 0x8d, 0x81, 0x24, 0xb1, 0x3c, 0x80, 0x33, 0x99, 0x2c, 0x5a, 0x77, 0x2a, 0xe3, 0x6b, 0xd4,
	0x5c, 0x68, 0x94, 0x22, 0xe0, 0x27, 0xe8, 0x4e, 0x42, 0x88, 0x2a, 0x7e, 0xad, 0xdb, 0x31, 0xcb,
	0x1d, 0x93, 0xa9, 0x7a, 0xa8, 0x4a, 0xe3, 0xb7, 0x0a, 0xba, 0xef, 0x00, 0x67, 0xb1, 0x6a, 0xdc,
	0x8f, 0x59, 0x10, 0x83, 0x10, 0x6b, 0xf3, 0xf7, 0x00, 0xbd, 0x9a, 0xb4, 0x75, 0xa9, 0x3f, 0xcf,
	0x5c, 0x35, 0x89, 0xed, 0xfb, 0xd8, 0x41, 0x1b, 0x2a, 0x2b, 0xcf, 0x39, 0xb4, 0x2b, 0xdb, 0xda,
	0xce, 0x66, 0xf7, 0xf1, 0x75, 0x66, 0x3e, 0x3c, 0xe7, 0x90, 0x76, 0xac, 0xc9, 0xec, 0x13, 0xff,
	0xa0, 0xa1, 0x37, 0x09, 0xe7, 0xe1, 0xb9, 0xcb, 0x89, 0xf4, 0x4e, 0x40, 0xb8, 0x0a, 0x82, 0x67,
	0x3b, 0x69, 0xdf, 0x51, 0xd4, 0x3c, 0x29, 0x0b, 0x63, 0x27, 0xad, 0xfa, 0x69, 0xa7, 0x79, 0x46,
	0x5e, 0xdc, 0x72, 0xda, 0x64, 0x45, 0x0e, 0x8f, 0x50, 0x0b, 0xce, 0xc0, 0x73, 0x85, 0x04, 0xbe,
	0x00, 0xff, 0x8a, 0x82, 0xff, 0xb8, 0x2c, 0xfc, 0xb3, 0x33, 0xf0, 0x06, 0x12, 0xf8, 0x02, 0x74,
	0x03, 0x0a, 0xe2, 0x3d, 0x84, 0x6a, 0x53, 0x1c, 0xe3, 0x7b, 0xa4, 0x17, 0x1d, 0x63, 0xa6, 0x93,
	0x6f, 0xd1, 0xa6, 0x1a, 0xcb, 0xa7, 0x31, 0x78, 0x92, 0x8e, 0x41, 0x1d, 0xe2, 0x66, 0xf7, 0xfd,
	0xeb, 0xb0, 0xff, 0xd9, 0xb4, 0xd8, 0xa9, 0xcb, 0xf9, 0x4f, 0xe3, 0xef, 0x9c, 0x86, 0x9e, 0xb2,
	0x21, 0x0f, 0x41, 0xc2, 0x4b, 0xa4, 0xa1, 0x87, 0xa8, 0x0e, 0x71, 0xcc, 0x62, 0x77, 0x08, 0x42,
	0x90, 0x00, 0x94, 0x68, 0x36, 0x9c, 0xbb, 0x2a, 0xf8, 0x45, 0x1a, 0xc3, 0x17, 0xe8, 0x7e, 0x81,
	0xce, 0xd8, 0x48, 0xf2, 0x91, 0xcc, 0x8e, 0xf9, 0xd3, 0x75, 0x55, 0xf6, 0xa5, 0xea, 0xf2, 0xe2,
	0x96, 0x73, 0x8f, 0x14, 0x66, 0x30, 0x43, 0xcd, 0x05, 0x85, 0x65, 0xc0, 0x55, 0x05, 0xbc, 0xb7,
	0x8e, 0xbe, 0x66, 0xa0, 0x18, 0x96, 0xa2, 0xbd, 0x1a, 0xaa, 0xa6, 0x08, 0xc6, 0x83, 0x79, 0x65,
	0x5d, 0x1e, 0x6e, 0xe6, 0x71, 0xbf, 0x68, 0xa8, 0xe1, 0x40, 0x40, 0x85, 0x84, 0xd8, 0x4e, 0xd0,
	0xfe, 0x7f, 0xeb, 0xc5, 0x7b, 0xe8, 0x9e, 0x18, 0xf1, 0x64, 0x24, 0xf0, 0x5d, 0x8f, 0x70, 0x72,
	0x44, 0x43, 0x2a, 0x29, 0x88, 0x76, 0x65, 0xbb, 0x32, 0x2d, 0x69, 0xce, 0x96, 0x3c, 0x9d, 0x5b,
	0x61, 0xb4, 0x50, 0x73, 0x61, 0xdc, 0x74, 0x23, 0xdd, 0x1f, 0x6b, 0xa8, 0xa1, 0x22, 0xcf, 0x32,
	0xba, 0x06, 0x10, 0x8f, 0xa9, 0x07, 0xf8, 0x4f, 0x0d, 0xb5, 0x56, 0x38, 0x3d, 0xfe, 0xbc, 0x2c,
	0xef, 0xff, 0xfd, 0x4e, 0xe9, 0xcf, 0x6f, 0xdc, 0x27, 0x3b, 0x0e, 0x63, 0x62, 0x6f, 0x2d, 0xd1,
	0xde, 0xc9, 0xf1, 0xfa, 0x58, 0xc3, 0x3f, 0x6b, 0xa8, 0x9e, 0x7b, 0x50, 0x70, 0x69, 0x83, 0x2a,
	0x7a, 0xd0, 0xf4, 0x4f, 0xd6, 0xac, 0xce, 0x86, 0x6e, 0x4c, 0xec, 0x65, 0xad, 0xe0, 0x5f, 0x35,
	0x84, 0x97, 0x2d, 0x0d, 0xdb, 0xe5, 0xa9, 0x5a, 0xf1, 0xaa, 0xe9, 0xbd, 0x9b, 0xb4, 0xc8, 0x66,
	0x7e, 0x34, 0xb1, 0x1f, 0x2e, 0x13, 0x9d, 0xf9, 0x56, 0x67, 0xe6, 0x50, 0xf8, 0xaf, 0xdc, 0x2e,
	0xa6, 0xd7, 0x67, 0x9d, 0x5d, 0x2c, 0xf8, 0xea, 0x3a, 0xbb, 0x58, 0xba, 0xbd, 0xef, 0x4d, 0xec,
	0xdd, 0x12, 0xbb, 0xe8, 0xe4, 0xdc, 0x11, 0xff, 0xae, 0xa1, 0x7a, 0xee, 0x12, 0x95, 0x97, 0x4f,
	0x91, 0x55, 0x94, 0x97, 0x4f, 0xe1, 0xcd, 0x35, 0x3e, 0x9c, 0xd8, 0x1f, 0x5c, 0xa1, 0xf9, 0x4e,
	0xb1, 0x5f, 0xe8, 0xfa, 0x1f, 0x76, 0x6b, 0x06, 0x97, 0x0e, 0x41, 0x38, 0x15, 0xa6, 0xc7, 0x86,
	0xbd, 0x9f, 0x34, 0xf4, 0x8e, 0xc7, 0x86, 0x25, 0x67, 0xeb, 0xe1, 0x9c, 0x79, 0xf4, 0x93, 0x1f,
	0xd4, 0xbe, 0xf6, 0xcd, 0x20, 0xab, 0x0e, 0x58, 0x48, 0xa2, 0xc0, 0x64, 0x71, 0x60, 0x05, 0x10,
	0xa9, 0xdf, 0x57, 0xeb, 0x12, 0xef, 0xaa, 0xbf, 0xde, 0x8f, 0x72, 0x81, 0xa3, 0xaa, 0xaa, 0x7f,
	0xf7, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb1, 0x6b, 0x89, 0xfc, 0xd2, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AgentEndpointServiceClient is the client API for AgentEndpointService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentEndpointServiceClient interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error)
	// Signals the start of a task execution and returns the task info.
	StartNextTask(ctx context.Context, in *StartNextTaskRequest, opts ...grpc.CallOption) (*StartNextTaskResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error)
	// Registers the agent running on the VM.
	RegisterAgent(ctx context.Context, in *RegisterAgentRequest, opts ...grpc.CallOption) (*RegisterAgentResponse, error)
}

type agentEndpointServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAgentEndpointServiceClient(cc grpc.ClientConnInterface) AgentEndpointServiceClient {
	return &agentEndpointServiceClient{cc}
}

func (c *agentEndpointServiceClient) ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AgentEndpointService_serviceDesc.Streams[0], "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReceiveTaskNotification", opts...)
	if err != nil {
		return nil, err
	}
	x := &agentEndpointServiceReceiveTaskNotificationClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AgentEndpointService_ReceiveTaskNotificationClient interface {
	Recv() (*ReceiveTaskNotificationResponse, error)
	grpc.ClientStream
}

type agentEndpointServiceReceiveTaskNotificationClient struct {
	grpc.ClientStream
}

func (x *agentEndpointServiceReceiveTaskNotificationClient) Recv() (*ReceiveTaskNotificationResponse, error) {
	m := new(ReceiveTaskNotificationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *agentEndpointServiceClient) StartNextTask(ctx context.Context, in *StartNextTaskRequest, opts ...grpc.CallOption) (*StartNextTaskResponse, error) {
	out := new(StartNextTaskResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/StartNextTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error) {
	out := new(ReportTaskProgressResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskProgress", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error) {
	out := new(ReportTaskCompleteResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskComplete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) RegisterAgent(ctx context.Context, in *RegisterAgentRequest, opts ...grpc.CallOption) (*RegisterAgentResponse, error) {
	out := new(RegisterAgentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/RegisterAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentEndpointServiceServer is the server API for AgentEndpointService service.
type AgentEndpointServiceServer interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(*ReceiveTaskNotificationRequest, AgentEndpointService_ReceiveTaskNotificationServer) error
	// Signals the start of a task execution and returns the task info.
	StartNextTask(context.Context, *StartNextTaskRequest) (*StartNextTaskResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(context.Context, *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(context.Context, *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error)
	// Registers the agent running on the VM.
	RegisterAgent(context.Context, *RegisterAgentRequest) (*RegisterAgentResponse, error)
}

// UnimplementedAgentEndpointServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAgentEndpointServiceServer struct {
}

func (*UnimplementedAgentEndpointServiceServer) ReceiveTaskNotification(req *ReceiveTaskNotificationRequest, srv AgentEndpointService_ReceiveTaskNotificationServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceiveTaskNotification not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) StartNextTask(ctx context.Context, req *StartNextTaskRequest) (*StartNextTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartNextTask not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportTaskProgress(ctx context.Context, req *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskProgress not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportTaskComplete(ctx context.Context, req *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskComplete not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) RegisterAgent(ctx context.Context, req *RegisterAgentRequest) (*RegisterAgentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterAgent not implemented")
}

func RegisterAgentEndpointServiceServer(s *grpc.Server, srv AgentEndpointServiceServer) {
	s.RegisterService(&_AgentEndpointService_serviceDesc, srv)
}

func _AgentEndpointService_ReceiveTaskNotification_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReceiveTaskNotificationRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AgentEndpointServiceServer).ReceiveTaskNotification(m, &agentEndpointServiceReceiveTaskNotificationServer{stream})
}

type AgentEndpointService_ReceiveTaskNotificationServer interface {
	Send(*ReceiveTaskNotificationResponse) error
	grpc.ServerStream
}

type agentEndpointServiceReceiveTaskNotificationServer struct {
	grpc.ServerStream
}

func (x *agentEndpointServiceReceiveTaskNotificationServer) Send(m *ReceiveTaskNotificationResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _AgentEndpointService_StartNextTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartNextTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).StartNextTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/StartNextTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).StartNextTask(ctx, req.(*StartNextTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskProgress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskProgressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskProgress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, req.(*ReportTaskProgressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskComplete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskCompleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskComplete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, req.(*ReportTaskCompleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_RegisterAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).RegisterAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/RegisterAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).RegisterAgent(ctx, req.(*RegisterAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AgentEndpointService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.osconfig.agentendpoint.v1.AgentEndpointService",
	HandlerType: (*AgentEndpointServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartNextTask",
			Handler:    _AgentEndpointService_StartNextTask_Handler,
		},
		{
			MethodName: "ReportTaskProgress",
			Handler:    _AgentEndpointService_ReportTaskProgress_Handler,
		},
		{
			MethodName: "ReportTaskComplete",
			Handler:    _AgentEndpointService_ReportTaskComplete_Handler,
		},
		{
			MethodName: "RegisterAgent",
			Handler:    _AgentEndpointService_RegisterAgent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReceiveTaskNotification",
			Handler:       _AgentEndpointService_ReceiveTaskNotification_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto",
}
