# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki

UBUNTU_CORE_RELEASES = 16 18 20 22 24
GARDEN_SYSTEMS += $(foreach r,$(UBUNTU_CORE_RELEASES),$(foreach a,x86_64 aarch64,ubuntu-core-$r.$a))

$(foreach R,$(UBUNTU_CORE_RELEASES),ubuntu-core-$R.x86_64.run): ubuntu-core-%.x86_64.run: $(MAKEFILE_LIST) | ubuntu-core-%.x86_64.qcow2 ubuntu-core-%.x86_64.efi-code.img ubuntu-core-%.x86_64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/ubuntu-core" >>$@
	echo '$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(UBUNTU_CORE_RELEASES),ubuntu-core-$R.aarch64.run): ubuntu-core-%.aarch64.run: $(MAKEFILE_LIST) | ubuntu-core-%.aarch64.qcow2 ubuntu-core-%.aarch64.efi-code.img ubuntu-core-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/ubuntu-core" >>$@
	echo '$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(UBUNTU_CORE_RELEASES),ubuntu-core-$R.x86_64.qcow2): ubuntu-core-%.x86_64.qcow2: $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-%.x86_64.qcow2 ubuntu-core-%.x86_64.seed.iso ubuntu-core-%.x86_64.efi-code.img ubuntu-core-%.x86_64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-scsi-pci,id=scsi1 \
		-device scsi-cd,drive=drive1,bus=scsi1.0 \
		| tee $@.log)

$(foreach R,$(UBUNTU_CORE_RELEASES),ubuntu-core-$R.aarch64.qcow2): ubuntu-core-%.aarch64.qcow2: $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-%.aarch64.qcow2 ubuntu-core-%.aarch64.seed.iso ubuntu-core-%.aarch64.efi-code.img ubuntu-core-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-scsi-pci,id=scsi1 \
		-device scsi-cd,drive=drive1,bus=scsi1.0 \
		| tee $@.log)

$(GARDEN_DL_DIR)/ubuntu-core: | $(GARDEN_DL_DIR)
	mkdir -p $@

ubuntu-core-%.x86_64.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,ubuntu-core-$*)
$(foreach R,$(UBUNTU_CORE_RELEASES),ubuntu-core-$R.x86_64.meta-data): ubuntu-core-%.x86_64.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

ubuntu-core-%.x86_64.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,UBUNTU_CORE,$*),ubuntu-core-$*,ubuntu)
$(foreach R,$(UBUNTU_CORE_RELEASES),ubuntu-core-$R.x86_64.user-data): ubuntu-core-%.x86_64.user-data: $(MAKEFILE_LIST) $(wildcard $(GARDEN_PROJECT_DIR)/.image-garden.mk)
	echo "$${USER_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

ubuntu-core-%.aarch64.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,ubuntu-core-$*)
$(foreach R,$(filter-out 16 18 20,$(UBUNTU_CORE_RELEASES)),ubuntu-core-$R.aarch64.meta-data): ubuntu-core-%.aarch64.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

ubuntu-core-%.aarch64.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,UBUNTU_CORE,$*),ubuntu-core-$*,ubuntu)
$(foreach R,$(filter-out 16 18 20,$(UBUNTU_CORE_RELEASES)),ubuntu-core-$R.aarch64.user-data): ubuntu-core-%.aarch64.user-data: $(MAKEFILE_LIST) $(wildcard $(GARDEN_PROJECT_DIR)/.image-garden.mk)
	echo "$${USER_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

define BASE_UBUNTU_CORE_CLOUD_INIT_USER_DATA_TEMPLATE
#cloud-config
datasource_list: [NoCloud]
timezone: Europe/Warsaw
power_state:
  delay: now
  mode: poweroff
  message: Powering off
  timeout: 0
  condition: true
hostname: $(subst .,-,$1)
manage_etc_hosts: true
ssh_pwauth: true
runcmd:
# Postpone refreshes for a day.
- snap set system refresh.hold="$$(date --date=tomorrow +%Y-%m-%dT%H:%M:%S%:z)"
# Bring the network down so that ongoing refresh can fail.
- ip link set dev eth0 down || true
# Create the user account.
- useradd --comment "$2 User" --create-home --shell /bin/bash --extrausers $2
- echo "$2:$2" | chpasswd $2
- echo image-garden >/writable/system-data/var/lib/console-conf/complete
# Wait for snapd to finish seeding.
- snap wait system seed.loaded
# Abort the change to refresh core and kernel snaps that may have started.
- snap abort 3 || true
# Applicable to Ubuntu Core 24+ where console-conf is a snap.
- snap remove --purge console-conf || true
# Restore network connectivity.
- ip link set dev eth0 up || true
endef

UBUNTU_CORE_CLOUD_INIT_USER_DATA_TEMPLATE=$(BASE_UBUNTU_CORE_CLOUD_INIT_USER_DATA_TEMPLATE)

ubuntu-core-16.x86_64.qcow2 ubuntu-core-16.x86_64.run ubuntu-core-18.x86_64.qcow2 ubuntu-core-18.x86_64.run: QEMU_ENV_QUIRKS=export QEMU_STORAGE_OPTION="$(strip \
	-drive file=$(1),if=none,format=qcow2,id=drive0,media=disk,cache=writeback,discard=unmap \
	-device virtio-scsi-pci,id=scsi0 \
	-device scsi-hd,drive=drive0,bus=scsi0.0,bootindex=0)";

.PHONY: all
all:: $(foreach R,$(filter-out 16 18 20,$(UBUNTU_CORE_RELEASES)),ubuntu-core-$R.$(GARDEN_ARCH).qcow2 ubuntu-core-$R.$(GARDEN_ARCH).run)
ifeq ($(GARDEN_ARCH),x86_64)
all:: $(foreach R,$(filter 16 18 20,$(UBUNTU_CORE_RELEASES)),ubuntu-core-$R.$(GARDEN_ARCH).qcow2 ubuntu-core-$R.$(GARDEN_ARCH).run)
fetch: $(foreach R,$(filter 16 18 20,$(UBUNTU_CORE_RELEASES)),$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-$R-$(call map_to_debian_arch,$(GARDEN_ARCH)).img.xz)
endif

.PHONY: fetch
fetch: $(foreach R,$(filter-out 16 18 20,$(UBUNTU_CORE_RELEASES)),$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-$R-$(call map_to_debian_arch,$(GARDEN_ARCH)).img.xz)

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-16-amd64.img.xz: | $(GARDEN_DL_DIR)/ubuntu-core
	$(strip $(GARDEN_ITSELF) download-with-sha256sums \
		http://cdimage.ubuntu.com/ubuntu-core/16/stable/current/ubuntu-core-16-amd64.img.xz \
		https://cdimage.ubuntu.com/ubuntu-core/16/stable/current/SHA256SUMS \
		$(GARDEN_DL_DIR)/ubuntu-core $(notdir $@))

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-18-amd64.img.xz: | $(GARDEN_DL_DIR)/ubuntu-core
	$(strip $(GARDEN_ITSELF) download-with-sha256sums \
		http://cdimage.ubuntu.com/ubuntu-core/18/stable/current/ubuntu-core-18-amd64.img.xz \
		https://cdimage.ubuntu.com/ubuntu-core/18/stable/current/SHA256SUMS \
		$(GARDEN_DL_DIR)/ubuntu-core $(notdir $@))

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-20-amd64.img.xz: | $(GARDEN_DL_DIR)/ubuntu-core
	$(strip $(GARDEN_ITSELF) download-with-sha256sums \
		http://cdimage.ubuntu.com/ubuntu-core/20/stable/current/ubuntu-core-20-amd64.img.xz \
		https://cdimage.ubuntu.com/ubuntu-core/20/stable/current/SHA256SUMS \
		$(GARDEN_DL_DIR)/ubuntu-core $(notdir $@))

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-22-amd64.img.xz $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-22-arm64.img.xz: $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-22-%.img.xz: | $(GARDEN_DL_DIR)/ubuntu-core
	$(strip $(GARDEN_ITSELF) download-with-sha256sums \
		http://cdimage.ubuntu.com/ubuntu-core/22/stable/current/ubuntu-core-22-$*.img.xz \
		https://cdimage.ubuntu.com/ubuntu-core/22/stable/current/SHA256SUMS \
		$(GARDEN_DL_DIR)/ubuntu-core $(notdir $@))

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-24-amd64.img.xz $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-24-arm64.img.xz: $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-24-%.img.xz: | $(GARDEN_DL_DIR)/ubuntu-core
	$(strip $(GARDEN_ITSELF) download-with-sha256sums \
		http://cdimage.ubuntu.com/ubuntu-core/24/stable/current/ubuntu-core-24-$*.img.xz \
		https://cdimage.ubuntu.com/ubuntu-core/24/stable/current/SHA256SUMS \
		$(GARDEN_DL_DIR)/ubuntu-core $(notdir $@))

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-16.x86_64.qcow2: | $(GARDEN_DL_DIR)/ubuntu-core $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-16-amd64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-18.x86_64.qcow2: | $(GARDEN_DL_DIR)/ubuntu-core $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-18-amd64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-20.x86_64.qcow2: | $(GARDEN_DL_DIR)/ubuntu-core $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-20-amd64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-22.x86_64.qcow2: | $(GARDEN_DL_DIR)/ubuntu-core $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-22-amd64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-22.aarch64.qcow2: | $(GARDEN_DL_DIR)/ubuntu-core $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-22-arm64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-24.x86_64.qcow2: | $(GARDEN_DL_DIR)/ubuntu-core $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-24-amd64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-24.aarch64.qcow2: | $(GARDEN_DL_DIR)/ubuntu-core $(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-24-arm64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(UBUNTU_CORE_RELEASES),$(foreach A,x86_64 aarch64,ubuntu-core-$R.$A.qcow2 ubuntu-core-$R.$A.run))

.PHONY: clean
clean::
	rm -f $(foreach R,$(UBUNTU_CORE_RELEASES),$(GARDEN_DL_DIR)/ubuntu-core/ubuntu-core-$R.*.qcow2)

.PHONY: distclean
distclean::
	rm -f $(foreach R,$(UBUNTU_CORE_RELEASES),$(GARDEN_DL_DIR)/ubuntu/ubuntu-core-$R-*.img.xz)
