package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.XmlTestBase;

public class XsiNilBasicTest extends XmlTestBase
{
    private final static String XSI_NS_DECL = "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'";

    protected static class DoubleWrapper {
        public Double d;

        public DoubleWrapper() { }
        public DoubleWrapper(Double value) {
            d = value;
        }
    }

    protected static class DoubleWrapper2 {
        public Double a = 100.0; // init to ensure it gets overwritten
        public Double b = 200.0;

        public DoubleWrapper2() { }
    }

    private final XmlMapper MAPPER = newMapper();

    public void testWithDoubleAsNull() throws Exception
    {
        DoubleWrapper bean = MAPPER.readValue(
"<DoubleWrapper "+XSI_NS_DECL+"><d xsi:nil='true' /></DoubleWrapper>",
                DoubleWrapper.class);
        assertNotNull(bean);
        assertNull(bean.d);

        bean = MAPPER.readValue(
"<DoubleWrapper "+XSI_NS_DECL+"><d xsi:nil='true'>  </d></DoubleWrapper>",
                DoubleWrapper.class);
        assertNotNull(bean);
        assertNull(bean.d);

        // actually we should perhaps also verify there is no content but... for now, let's leave it.
    }

    public void testWithDoubleAsNonNull() throws Exception
    {
        DoubleWrapper bean = MAPPER.readValue(
"<DoubleWrapper "+XSI_NS_DECL+"><d xsi:nil='false'>0.25</d></DoubleWrapper>",
                DoubleWrapper.class);
        assertNotNull(bean);
        assertEquals(Double.valueOf(0.25), bean.d);
    }

    public void testWithDoubleAsMixed() throws Exception
    {
        DoubleWrapper2 bean = MAPPER.readValue(
"<DoubleWrapper "+XSI_NS_DECL+">\n"
+"<a xsi:nil='true'></a>\n"
+"<b xsi:nil='false'>0.25</b>\n"
+"</DoubleWrapper>",
            DoubleWrapper2.class);
        assertNotNull(bean);
        assertNull(bean.a);
        assertEquals(Double.valueOf(0.25), bean.b);

        bean = MAPPER.readValue(
"<DoubleWrapper "+XSI_NS_DECL+">\n"
+"<a xsi:nil='false'>0.25</a>\n"
+"<b xsi:nil='true'></b>\n"
+"</DoubleWrapper>",
            DoubleWrapper2.class);
        assertNotNull(bean);
        assertEquals(Double.valueOf(0.25), bean.a);
        assertNull(bean.b);

        // and last one just for ... funsies
        DoubleWrapper2 defaultValue = new DoubleWrapper2();
        bean = MAPPER.readValue(
"<DoubleWrapper "+XSI_NS_DECL+">\n"
+"</DoubleWrapper>",
            DoubleWrapper2.class);
        assertNotNull(bean.a);
        assertNotNull(bean.b);
        assertEquals(defaultValue.a, bean.a);
        assertEquals(defaultValue.b, bean.b);
    }

    public void testRootPojoAsNull() throws Exception
    {
        Point bean = MAPPER.readValue(
"<Point "+XSI_NS_DECL+" xsi:nil='true' />",
                Point.class);
        assertNull(bean);
    }

    public void testRootPojoAsNonNull() throws Exception
    {
        Point bean = MAPPER.readValue(
"<Point "+XSI_NS_DECL+" xsi:nil='false'></Point>",
                Point.class);
        assertNotNull(bean);
    }
}
