/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.commands;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.DefaultMdacContextualCommand;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObMessageSortEnum;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.modelingwizard.i18n.Messages;
import com.modeliosoft.modelio.modelingwizard.impl.engine.InstanceUpdater;
import com.modeliosoft.modelio.modelingwizard.impl.engine.ModelingWizardException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CreateOperation
extends DefaultMdacContextualCommand {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ObList<IElement> selectedElements, IMdac mdac) {
        IModelingSession session = mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("CreateOperation");
        try {
            try {
                InstanceUpdater p = new InstanceUpdater();
                p.createOperation(session, (IMessage)selectedElements.get(0));
                session.commit(transaction);
                transaction = null;
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return;
                session.rollback(transaction);
                return;
            }
            catch (ModelingWizardException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("Ui.Error.Title"), (String)Messages.getString(e.getMessage()));
                if (transaction == null) return;
                session.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    public boolean accept(ObList<IElement> selectedElements, IMdac mdac) {
        if (selectedElements.size() <= 0) {
            return false;
        }
        ObMessageSortEnum sort = ((IMessage)selectedElements.get(0)).getSortOfMessage();
        return sort != ObMessageSortEnum.RETURN_MESSAGE && sort != ObMessageSortEnum.A_SYNC_CALL && sort != ObMessageSortEnum.A_SYNC_SIGNAL;
    }

    public boolean isActiveFor(ObList<IElement> selectedElements, IMdac mdac) {
        return true;
    }
}

