/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.lisaac.ldt.launch.LisaacCompiler;
import org.lisaac.ldt.outline.OutlineImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LisaacPath {
    private HashMap<String, String> prototypesPath = new HashMap();
    private LisaacCompiler compiler;
    private String lipFile;

    public LisaacPath(IProject project, String lipFile) {
        this.lipFile = lipFile;
        this.refreshPath(project);
    }

    public void refreshPath(IProject project) {
        try {
            this.compiler = new LisaacCompiler(this.lipFile);
            this.compiler.addOption("--p");
            System.out.println("===> " + this.compiler.toCommandLine());
            try {
                String line;
                Process process = this.compiler.launch(project, (IProgressMonitor)new NullProgressMonitor());
                if (process != null) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BufferedReader bufferIn = new BufferedReader(new InputStreamReader(new FileInputStream(project.getLocation() + "/current_path.txt")));
                while ((line = bufferIn.readLine()) != null) {
                    this.createPath(line);
                }
                bufferIn.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFullPath(String prototypeName) {
        if (this.prototypesPath.containsKey(prototypeName)) {
            return this.prototypesPath.get(prototypeName);
        }
        return null;
    }

    private void createPath(String fullPath) {
        int index = fullPath.lastIndexOf("/");
        String prototypeName = fullPath.substring(index + 1);
        index = prototypeName.lastIndexOf(".");
        prototypeName = prototypeName.substring(0, index).toUpperCase();
        this.prototypesPath.put(prototypeName, fullPath);
    }

    public void getPathMatch(String prefix, ArrayList<ICompletionProposal> proposals, int baseOffset) {
        Set<String> values = this.prototypesPath.keySet();
        for (String name : values) {
            if (!name.startsWith(prefix)) continue;
            int lenPrefix = prefix.length();
            int lenName = name.length();
            proposals.add((ICompletionProposal)new CompletionProposal(name, baseOffset - lenPrefix, lenPrefix, lenName, OutlineImages.PROTOTYPE, name, null, null));
        }
    }

    public void addPath(String prototypeName, IPath location) {
        this.prototypesPath.put(prototypeName, location.toString());
    }

    public int getSize() {
        return this.prototypesPath.size();
    }

    public Iterator<String> getPathIterator() {
        return this.prototypesPath.values().iterator();
    }
}

