; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=m68k-linux -verify-machineinstrs | FileCheck %s

declare i32 @printf(i8*, ...) nounwind
declare {i32, i1} @llvm.ssub.with.overflow.i32(i32, i32)
declare {i32, i1} @llvm.usub.with.overflow.i32(i32, i32)

@ok = internal constant [4 x i8] c"%d\0A\00"
@no = internal constant [4 x i8] c"no\0A\00"

define i1 @func1(i32 %v1, i32 %v2) nounwind {
; CHECK-LABEL: func1:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    suba.l #12, %sp
; CHECK-NEXT:    move.l (16,%sp), %d0
; CHECK-NEXT:    sub.l (20,%sp), %d0
; CHECK-NEXT:    bvc .LBB0_1
; CHECK-NEXT:  ; %bb.2: ; %overflow
; CHECK-NEXT:    lea (no,%pc), %a0
; CHECK-NEXT:    move.l %a0, (%sp)
; CHECK-NEXT:    jsr printf@PLT
; CHECK-NEXT:    move.b #0, %d0
; CHECK-NEXT:    adda.l #12, %sp
; CHECK-NEXT:    rts
; CHECK-NEXT:  .LBB0_1: ; %normal
; CHECK-NEXT:    move.l %d0, (4,%sp)
; CHECK-NEXT:    lea (ok,%pc), %a0
; CHECK-NEXT:    move.l %a0, (%sp)
; CHECK-NEXT:    jsr printf@PLT
; CHECK-NEXT:    move.b #1, %d0
; CHECK-NEXT:    adda.l #12, %sp
; CHECK-NEXT:    rts
entry:
  %t = call {i32, i1} @llvm.ssub.with.overflow.i32(i32 %v1, i32 %v2)
  %sum = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %overflow, label %normal

normal:
  %t1 = tail call i32 (i8*, ...) @printf( i8* getelementptr ([4 x i8], [4 x i8]* @ok, i32 0, i32 0), i32 %sum ) nounwind
  ret i1 true

overflow:
  %t2 = tail call i32 (i8*, ...) @printf( i8* getelementptr ([4 x i8], [4 x i8]* @no, i32 0, i32 0) ) nounwind
  ret i1 false
}

define i1 @func2(i32 %v1, i32 %v2) nounwind {
; CHECK-LABEL: func2:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    suba.l #12, %sp
; CHECK-NEXT:    move.l (16,%sp), %d0
; CHECK-NEXT:    sub.l (20,%sp), %d0
; CHECK-NEXT:    bcc .LBB1_1
; CHECK-NEXT:  ; %bb.2: ; %carry
; CHECK-NEXT:    lea (no,%pc), %a0
; CHECK-NEXT:    move.l %a0, (%sp)
; CHECK-NEXT:    jsr printf@PLT
; CHECK-NEXT:    move.b #0, %d0
; CHECK-NEXT:    adda.l #12, %sp
; CHECK-NEXT:    rts
; CHECK-NEXT:  .LBB1_1: ; %normal
; CHECK-NEXT:    move.l %d0, (4,%sp)
; CHECK-NEXT:    lea (ok,%pc), %a0
; CHECK-NEXT:    move.l %a0, (%sp)
; CHECK-NEXT:    jsr printf@PLT
; CHECK-NEXT:    move.b #1, %d0
; CHECK-NEXT:    adda.l #12, %sp
; CHECK-NEXT:    rts
entry:
  %t = call {i32, i1} @llvm.usub.with.overflow.i32(i32 %v1, i32 %v2)
  %sum = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %carry, label %normal

normal:
  %t1 = tail call i32 (i8*, ...) @printf( i8* getelementptr ([4 x i8], [4 x i8]* @ok, i32 0, i32 0), i32 %sum ) nounwind
  ret i1 true

carry:
  %t2 = tail call i32 (i8*, ...) @printf( i8* getelementptr ([4 x i8], [4 x i8]* @no, i32 0, i32 0) ) nounwind
  ret i1 false
}

define i1 @func3(i32 %x) nounwind {
; CHECK-LABEL: func3:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l #-1, %d0
; CHECK-NEXT:    add.l (4,%sp), %d0
; CHECK-NEXT:    svs %d0
; CHECK-NEXT:    rts
entry:
  %t = call {i32, i1} @llvm.ssub.with.overflow.i32(i32 %x, i32 1)
  %obit = extractvalue {i32, i1} %t, 1
  ret i1 %obit
}
