; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=ipsccp -S | FileCheck %s

declare void @use(i1)
declare i32 @get_i32()

define void @range_attribute(i32 range(i32 0, 10) %v) {
; CHECK-LABEL: @range_attribute(
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[C2:%.*]] = icmp ult i32 [[V:%.*]], 9
; CHECK-NEXT:    call void @use(i1 [[C2]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[C4:%.*]] = icmp ugt i32 [[V]], 8
; CHECK-NEXT:    call void @use(i1 [[C4]])
; CHECK-NEXT:    ret void
;
  %c1 = icmp ult i32 %v, 10
  call void @use(i1 %c1)
  %c2 = icmp ult i32 %v, 9
  call void @use(i1 %c2)
  %c3 = icmp ugt i32 %v, 9
  call void @use(i1 %c3)
  %c4 = icmp ugt i32 %v, 8
  call void @use(i1 %c4)
  ret void
}

define i32 @range_attribute_single(i32 range(i32 0, 1) %v) {
; CHECK-LABEL: @range_attribute_single(
; CHECK-NEXT:    ret i32 0
;
  ret i32 %v
}

define void @call_range_attribute() {
; CHECK-LABEL: @call_range_attribute(
; CHECK-NEXT:    [[V:%.*]] = call range(i32 0, 10) i32 @get_i32()
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[C2:%.*]] = icmp ult i32 [[V]], 9
; CHECK-NEXT:    call void @use(i1 [[C2]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[C4:%.*]] = icmp ugt i32 [[V]], 8
; CHECK-NEXT:    call void @use(i1 [[C4]])
; CHECK-NEXT:    ret void
;
  %v = call range(i32 0, 10) i32 @get_i32()
  %c1 = icmp ult i32 %v, 10
  call void @use(i1 %c1)
  %c2 = icmp ult i32 %v, 9
  call void @use(i1 %c2)
  %c3 = icmp ugt i32 %v, 9
  call void @use(i1 %c3)
  %c4 = icmp ugt i32 %v, 8
  call void @use(i1 %c4)
  ret void
}


declare range(i32 0, 10) i32 @get_i32_in_range()

define void @call_range_result() {
; CHECK-LABEL: @call_range_result(
; CHECK-NEXT:    [[V:%.*]] = call i32 @get_i32_in_range()
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[C2:%.*]] = icmp ult i32 [[V]], 9
; CHECK-NEXT:    call void @use(i1 [[C2]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[C4:%.*]] = icmp ugt i32 [[V]], 8
; CHECK-NEXT:    call void @use(i1 [[C4]])
; CHECK-NEXT:    ret void
;
  %v = call i32 @get_i32_in_range()
  %c1 = icmp ult i32 %v, 10
  call void @use(i1 %c1)
  %c2 = icmp ult i32 %v, 9
  call void @use(i1 %c2)
  %c3 = icmp ugt i32 %v, 9
  call void @use(i1 %c3)
  %c4 = icmp ugt i32 %v, 8
  call void @use(i1 %c4)
  ret void
}

define internal i1 @ip_cmp_range_attribute(i32 %v) {
; CHECK-LABEL: @ip_cmp_range_attribute(
; CHECK-NEXT:    ret i1 poison
;
  %c = icmp ult i32 %v, 10
  ret i1 %c
}

define i1 @ip_range_attribute(i32 range(i32 0, 10) %v) {
; CHECK-LABEL: @ip_range_attribute(
; CHECK-NEXT:    [[C:%.*]] = call i1 @ip_cmp_range_attribute(i32 [[V:%.*]])
; CHECK-NEXT:    ret i1 true
;
  %c = call i1 @ip_cmp_range_attribute(i32 %v)
  ret i1 %c
}

define internal i1 @ip_cmp_range_call(i32 %v) {
; CHECK-LABEL: @ip_cmp_range_call(
; CHECK-NEXT:    ret i1 poison
;
  %c = icmp ult i32 %v, 10
  ret i1 %c
}

define i1 @ip_range_call() {
; CHECK-LABEL: @ip_range_call(
; CHECK-NEXT:    [[V:%.*]] = call range(i32 0, 10) i32 @get_i32()
; CHECK-NEXT:    [[C:%.*]] = call i1 @ip_cmp_range_call(i32 [[V]])
; CHECK-NEXT:    ret i1 true
;
  %v = call range(i32 0, 10) i32 @get_i32()
  %c = call i1 @ip_cmp_range_call(i32 %v)
  ret i1 %c
}

define internal i1 @ip_cmp_range_result(i32 %v) {
; CHECK-LABEL: @ip_cmp_range_result(
; CHECK-NEXT:    ret i1 poison
;
  %c = icmp ult i32 %v, 10
  ret i1 %c
}

define i1 @ip_range_result() {
; CHECK-LABEL: @ip_range_result(
; CHECK-NEXT:    [[V:%.*]] = call range(i32 0, 10) i32 @get_i32()
; CHECK-NEXT:    [[C:%.*]] = call i1 @ip_cmp_range_result(i32 [[V]])
; CHECK-NEXT:    ret i1 true
;
  %v = call range(i32 0, 10) i32 @get_i32()
  %c = call i1 @ip_cmp_range_result(i32 %v)
  ret i1 %c
}

define internal i1 @ip_cmp_with_range_attribute(i32 range(i32 0, 10) %v) {
; CHECK-LABEL: @ip_cmp_with_range_attribute(
; CHECK-NEXT:    ret i1 poison
;
  %c = icmp eq i32 %v, 5
  ret i1 %c
}

define i1 @ip_range_attribute_constant() {
; CHECK-LABEL: @ip_range_attribute_constant(
; CHECK-NEXT:    [[C:%.*]] = call i1 @ip_cmp_with_range_attribute(i32 5)
; CHECK-NEXT:    ret i1 true
;
  %c = call i1 @ip_cmp_with_range_attribute(i32 5)
  ret i1 %c
}
