; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -mtriple=mipsel -mcpu=mips32r6 -mips-compact-branches=never < %s | FileCheck %s --check-prefix=MIPS32R6
; RUN: llc -mtriple=mips64el -mcpu=mips64r6 -mips-compact-branches=never < %s | FileCheck %s --check-prefix=MIPS64R6

;; Test checking we respect mips-compact-branches=never
;; The patterns set + branch should be disabled and not emit compact branches

define void @test_slt_never(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_slt_never:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    slt $1, $4, $5
; MIPS32R6-NEXT:    beqz $1, $BB0_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  $BB0_2: # %f
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    nop
;
; MIPS64R6-LABEL: test_slt_never:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $5, 0
; MIPS64R6-NEXT:    sll $2, $4, 0
; MIPS64R6-NEXT:    slt $1, $2, $1
; MIPS64R6-NEXT:    beqz $1, .LBB0_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  .LBB0_2: # %f
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    nop
  %c = icmp slt i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

define void @test_ult_never(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_ult_never:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    sltu $1, $4, $5
; MIPS32R6-NEXT:    beqz $1, $BB1_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  $BB1_2: # %f
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    nop
;
; MIPS64R6-LABEL: test_ult_never:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $5, 0
; MIPS64R6-NEXT:    sll $2, $4, 0
; MIPS64R6-NEXT:    sltu $1, $2, $1
; MIPS64R6-NEXT:    beqz $1, .LBB1_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  .LBB1_2: # %f
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    nop
  %c = icmp ult i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

