; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -mtriple=mipsel -mcpu=mips32r6 < %s | FileCheck %s --check-prefix=MIPS32R6
; RUN: llc -mtriple=mips64el -mcpu=mips64r6 < %s | FileCheck %s --check-prefix=MIPS64R6

;; Each function is a single compare + branch
;; Checking each pattern for compact branch is selected


;; br + slt -> bgec
define void @test_slt(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_slt:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bgec $4, $5, $BB0_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB0_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_slt:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $5, 0
; MIPS64R6-NEXT:    sll $2, $4, 0
; MIPS64R6-NEXT:    bgec $2, $1, .LBB0_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB0_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp slt i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + sgt -> bgec
define void @test_sgt(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_sgt:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bgec $5, $4, $BB1_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB1_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_sgt:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    sll $2, $5, 0
; MIPS64R6-NEXT:    bgec $2, $1, .LBB1_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB1_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp sgt i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + sge -> bltc
define void @test_sge(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_sge:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bltc $4, $5, $BB2_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB2_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_sge:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $5, 0
; MIPS64R6-NEXT:    sll $2, $4, 0
; MIPS64R6-NEXT:    bltc $2, $1, .LBB2_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB2_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp sge i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + sle -> bltc
define void @test_sle(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_sle:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bltc $5, $4, $BB3_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB3_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_sle:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    sll $2, $5, 0
; MIPS64R6-NEXT:    bltc $2, $1, .LBB3_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB3_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp sle i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + ult -> bgeuc
define void @test_ult(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_ult:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bgeuc $4, $5, $BB4_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB4_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_ult:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $5, 0
; MIPS64R6-NEXT:    sll $2, $4, 0
; MIPS64R6-NEXT:    bgeuc $2, $1, .LBB4_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB4_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp ult i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + ugt -> bgeuc
define void @test_ugt(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_ugt:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bgeuc $5, $4, $BB5_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB5_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_ugt:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    sll $2, $5, 0
; MIPS64R6-NEXT:    bgeuc $2, $1, .LBB5_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB5_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp ugt i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + uge -> bltuc
define void @test_uge(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_uge:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bltuc $4, $5, $BB6_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB6_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_uge:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $5, 0
; MIPS64R6-NEXT:    sll $2, $4, 0
; MIPS64R6-NEXT:    bltuc $2, $1, .LBB6_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB6_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp uge i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + ule -> bltuc
define void @test_ule(i32 %a, i32 %b) {
; MIPS32R6-LABEL: test_ule:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bltuc $5, $4, $BB7_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB7_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_ule:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    sll $2, $5, 0
; MIPS64R6-NEXT:    bltuc $2, $1, .LBB7_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB7_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp ule i32 %a, %b
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + slt rs,0 -> bltzc
define void @test_lt_zero(i32 %a) {
; MIPS32R6-LABEL: test_lt_zero:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bltzc $4, $BB8_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %f
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB8_2: # %t
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_lt_zero:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    bltzc $1, .LBB8_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %f
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB8_2: # %t
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp slt i32 %a, 0
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + sgt rs,0 -> blezc
define void @test_gt_zero(i32 %a) {
; MIPS32R6-LABEL: test_gt_zero:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    blezc $4, $BB9_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB9_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_gt_zero:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    blezc $1, .LBB9_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB9_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp sgt i32 %a, 0
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + sle rs,0 -> bgtzc
define void @test_le_zero(i32 %a) {
; MIPS32R6-LABEL: test_le_zero:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bgtzc $4, $BB10_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB10_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_le_zero:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    bgtzc $1, .LBB10_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB10_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp sle i32 %a, 0
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + sge rs,0 -> bltzc
define void @test_ge_zero(i32 %a) {
; MIPS32R6-LABEL: test_ge_zero:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bltzc $4, $BB11_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB11_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_ge_zero:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    bltzc $1, .LBB11_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB11_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp sge i32 %a, 0
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + slt rs,1 -> blezc
define void @test_lt_one(i32 %a) {
; MIPS32R6-LABEL: test_lt_one:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    blezc $4, $BB12_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %f
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB12_2: # %t
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_lt_one:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    blezc $1, .LBB12_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %f
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB12_2: # %t
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp slt i32 %a, 1
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + sge rs,1 -> blezc
define void @test_ge_one(i32 %a) {
; MIPS32R6-LABEL: test_ge_one:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    blezc $4, $BB13_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB13_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_ge_one:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    blezc $1, .LBB13_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB13_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp sge i32 %a, 1
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + sgt rs,-1 -> bltzc
define void @test_gt_minus1(i32 %a) {
; MIPS32R6-LABEL: test_gt_minus1:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bltzc $4, $BB14_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB14_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_gt_minus1:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    bltzc $1, .LBB14_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB14_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp sgt i32 %a, -1
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}

;; br + sle rs,-1 -> bgezc
define void @test_le_minus1(i32 %a) {
; MIPS32R6-LABEL: test_le_minus1:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    bgezc $4, $BB15_2
; MIPS32R6-NEXT:    nop
; MIPS32R6-NEXT:  # %bb.1: # %t
; MIPS32R6-NEXT:    jrc $ra
; MIPS32R6-NEXT:  $BB15_2: # %f
; MIPS32R6-NEXT:    jrc $ra
;
; MIPS64R6-LABEL: test_le_minus1:
; MIPS64R6:       # %bb.0:
; MIPS64R6-NEXT:    sll $1, $4, 0
; MIPS64R6-NEXT:    bgezc $1, .LBB15_2
; MIPS64R6-NEXT:    nop
; MIPS64R6-NEXT:  # %bb.1: # %t
; MIPS64R6-NEXT:    jrc $ra
; MIPS64R6-NEXT:  .LBB15_2: # %f
; MIPS64R6-NEXT:    jrc $ra
  %c = icmp sle i32 %a, -1
  br i1 %c, label %t, label %f
t:
  ret void
f:
  ret void
}
