; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -verify-machineinstrs -O3 -mcpu=pwr9 -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s

; RUN: llc -verify-machineinstrs -O3 -mcpu=pwr9 -mtriple=powerpc64-ibm-aix \
; RUN:     -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s

; RUN: llc -verify-machineinstrs -O3 -mcpu=pwr9 -mtriple=powerpc-ibm-aix \
; RUN:     -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s

; Optimized version which `xxleqv` and `vsubu` to generate vector of -1s to leverage the identity A - (-1) = A + 1.

; Function for the vector type v2i64 `a + {1, 1}`
define <2 x i64> @test_v2i64(<2 x i64> %a) {
; CHECK-LABEL: test_v2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v3, v3, v3
; CHECK-NEXT:    vsubudm v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %add = add <2 x i64> %a, splat (i64 1)
  ret <2 x i64> %add
}

; Function for the vector type v4i32 `a + {1, 1, 1, 1}`
define <4 x i32> @test_v4i32(<4 x i32> %a) {
; CHECK-LABEL: test_v4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v3, v3, v3
; CHECK-NEXT:    vsubuwm v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %add = add <4 x i32> %a, splat (i32 1)
  ret <4 x i32> %add
}

; Function for the vector type v8i16 `a + {1, 1, 1, 1, 1, 1, 1, 1}`
define <8 x i16> @test_v8i16(<8 x i16> %a) {
; CHECK-LABEL: test_v8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v3, v3, v3
; CHECK-NEXT:    vsubuhm v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %add = add <8 x i16> %a, splat (i16 1)
  ret <8 x i16> %add
}

; Function for the vector type v16i8 `a + {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}`
define <16 x i8> @test_16i8(<16 x i8> %a) {
; CHECK-LABEL: test_16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v3, v3, v3
; CHECK-NEXT:    vsububm v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %add = add <16 x i8> %a, splat (i8 1)
  ret <16 x i8> %add
}
