; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -verify-machineinstrs -mcpu=pwr10 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=POWERPC64-LE-10

; RUN: llc -verify-machineinstrs -mcpu=pwr10 -mtriple=powerpc64-unknown-unknown \
; RUN:   -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=POWERPC64-BE-10

; Test LXVKQ instruction generation for special vector constants matching 128 bit patterns:
; 0x8000_0000_0000_0000_0000_0000_0000_0000 (MSB set pattern)
; 0x0000_0000_0000_0000_0000_0000_0000_0001 (LSB set pattern)

; =============================================================================
; v2i64 tests - MSB set pattern (0x8000_0000_0000_0000_0000_0000_0000_0000)
; =============================================================================

; Big-Endian: 0x8000_0000_0000_0000_0000_0000_0000_0000 represents <-9223372036854775808, 0>
define dso_local noundef <2 x i64> @test_v2i64_msb_set_bigendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v2i64_msb_set_bigendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    plxv v2, .LCPI0_0@PCREL(0), 1
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v2i64_msb_set_bigendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    lxvkq v2, 16
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <2 x i64> <i64 -9223372036854775808, i64 0>
}

; Little-Endian: 0x8000_0000_0000_0000_0000_0000_0000_0000 represents <0, -9223372036854775808>
define dso_local noundef <2 x i64> @test_v2i64_msb_set_littleendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v2i64_msb_set_littleendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    lxvkq v2, 16
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v2i64_msb_set_littleendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    addis r3, r2, .LCPI1_0@toc@ha
; POWERPC64-BE-10-NEXT:    addi r3, r3, .LCPI1_0@toc@l
; POWERPC64-BE-10-NEXT:    lxv v2, 0(r3)
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <2 x i64> <i64 0, i64 -9223372036854775808>
}

; =============================================================================
; v4i32 tests - MSB set pattern (0x8000_0000_0000_0000_0000_0000_0000_0000)
; =============================================================================

; Big-Endian: 0x8000_0000_0000_0000_0000_0000_0000_0000 represents <-2147483648, 0, 0, 0>
define dso_local noundef <4 x i32> @test_v4i32_msb_set_bigendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v4i32_msb_set_bigendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    plxv v2, .LCPI2_0@PCREL(0), 1
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v4i32_msb_set_bigendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    lxvkq v2, 16
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <4 x i32> <i32 -2147483648, i32 0, i32 0, i32 0>
}

; Little-Endian: 0x8000_0000_0000_0000_0000_0000_0000_0000 represents <0, 0, 0, -2147483648>
define dso_local noundef <4 x i32> @test_v4i32_msb_set_littleendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v4i32_msb_set_littleendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    lxvkq v2, 16
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v4i32_msb_set_littleendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    addis r3, r2, .LCPI3_0@toc@ha
; POWERPC64-BE-10-NEXT:    addi r3, r3, .LCPI3_0@toc@l
; POWERPC64-BE-10-NEXT:    lxv v2, 0(r3)
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <4 x i32> <i32 0, i32 0, i32 0, i32 -2147483648>
}

; =============================================================================
; v8i16 tests - MSB set pattern (0x8000_0000_0000_0000_0000_0000_0000_0000)
; =============================================================================

; Big-Endian: 0x8000_0000_0000_0000_0000_0000_0000_0000 represents <-32768, 0, 0, 0, 0, 0, 0, 0>
define dso_local noundef <8 x i16> @test_v8i16_msb_set_bigendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v8i16_msb_set_bigendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    plxv v2, .LCPI4_0@PCREL(0), 1
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v8i16_msb_set_bigendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    lxvkq v2, 16
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <8 x i16> <i16 -32768, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0>
}

; Little-Endian: 0x8000_0000_0000_0000_0000_0000_0000_0000 represents <0, 0, 0, 0, 0, 0, 0, -32768>
define dso_local noundef <8 x i16> @test_v8i16_msb_set_littleendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v8i16_msb_set_littleendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    lxvkq v2, 16
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v8i16_msb_set_littleendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; POWERPC64-BE-10-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; POWERPC64-BE-10-NEXT:    lxv v2, 0(r3)
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <8 x i16> <i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 -32768>
}

; =============================================================================
; v16i8 tests - MSB set pattern (0x8000_0000_0000_0000_0000_0000_0000_0000)
; =============================================================================

; Big-Endian: 0x8000_0000_0000_0000_0000_0000_0000_0000 represents <-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0>
define dso_local noundef <16 x i8> @test_v16i8_msb_set_bigendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v16i8_msb_set_bigendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    plxv v2, .LCPI6_0@PCREL(0), 1
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v16i8_msb_set_bigendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    lxvkq v2, 16
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <16 x i8> <i8 -128, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>
}

; Little-Endian: 0x8000_0000_0000_0000_0000_0000_0000_0000 represents <0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128>
define dso_local noundef <16 x i8> @test_v16i8_msb_set_littleendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v16i8_msb_set_littleendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    lxvkq v2, 16
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v16i8_msb_set_littleendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; POWERPC64-BE-10-NEXT:    addi r3, r3, .LCPI7_0@toc@l
; POWERPC64-BE-10-NEXT:    lxv v2, 0(r3)
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <16 x i8> <i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 -128>
}

; =============================================================================
; v2i64 tests - LSB set pattern (0x0000_0000_0000_0000_0000_0000_0000_0001)
; =============================================================================

; Big-Endian: 0x0000_0000_0000_0000_0000_0000_0000_0001 represents <0, 1>
define dso_local noundef <2 x i64> @test_v2i64_lsb_set_bigendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v2i64_lsb_set_bigendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    plxv v2, .LCPI8_0@PCREL(0), 1
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v2i64_lsb_set_bigendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    xxspltib v2, 255
; POWERPC64-BE-10-NEXT:    vsrq v2, v2, v2
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <2 x i64> <i64 0, i64 1>
}

; Little-Endian: 0x0000_0000_0000_0000_0000_0000_0000_0001 represents <1, 0>
define dso_local noundef <2 x i64> @test_v2i64_lsb_set_littleendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v2i64_lsb_set_littleendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    xxspltib v2, 255
; POWERPC64-LE-10-NEXT:    vsrq v2, v2, v2
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v2i64_lsb_set_littleendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    addis r3, r2, .LCPI9_0@toc@ha
; POWERPC64-BE-10-NEXT:    addi r3, r3, .LCPI9_0@toc@l
; POWERPC64-BE-10-NEXT:    lxv v2, 0(r3)
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <2 x i64> <i64 1, i64 0>
}

; =============================================================================
; v4i32 tests - LSB set pattern (0x0000_0000_0000_0000_0000_0000_0000_0001)
; =============================================================================

; Big-Endian: 0x0000_0000_0000_0000_0000_0000_0000_0001 represents <0, 0, 0, 1>
define dso_local noundef <4 x i32> @test_v4i32_lsb_set_bigendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v4i32_lsb_set_bigendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    plxv v2, .LCPI10_0@PCREL(0), 1
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v4i32_lsb_set_bigendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    xxspltib v2, 255
; POWERPC64-BE-10-NEXT:    vsrq v2, v2, v2
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <4 x i32> <i32 0, i32 0, i32 0, i32 1>
}

; Little-Endian: 0x0000_0000_0000_0000_0000_0000_0000_0001 represents <1, 0, 0, 0>
define dso_local noundef <4 x i32> @test_v4i32_lsb_set_littleendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v4i32_lsb_set_littleendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    xxspltib v2, 255
; POWERPC64-LE-10-NEXT:    vsrq v2, v2, v2
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v4i32_lsb_set_littleendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    addis r3, r2, .LCPI11_0@toc@ha
; POWERPC64-BE-10-NEXT:    addi r3, r3, .LCPI11_0@toc@l
; POWERPC64-BE-10-NEXT:    lxv v2, 0(r3)
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <4 x i32> <i32 1, i32 0, i32 0, i32 0>
}

; =============================================================================
; v8i16 tests - LSB set pattern (0x0000_0000_0000_0000_0000_0000_0000_0001)
; =============================================================================

; Big-Endian: 0x0000_0000_0000_0000_0000_0000_0000_0001 represents <0, 0, 0, 0, 0, 0, 0, 1>
define dso_local noundef <8 x i16> @test_v8i16_lsb_set_bigendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v8i16_lsb_set_bigendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    plxv v2, .LCPI12_0@PCREL(0), 1
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v8i16_lsb_set_bigendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    xxspltib v2, 255
; POWERPC64-BE-10-NEXT:    vsrq v2, v2, v2
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <8 x i16> <i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 1>
}

; Little-Endian: 0x0000_0000_0000_0000_0000_0000_0000_0001 represents <1, 0, 0, 0, 0, 0, 0, 0>
define dso_local noundef <8 x i16> @test_v8i16_lsb_set_littleendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v8i16_lsb_set_littleendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    xxspltib v2, 255
; POWERPC64-LE-10-NEXT:    vsrq v2, v2, v2
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v8i16_lsb_set_littleendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    addis r3, r2, .LCPI13_0@toc@ha
; POWERPC64-BE-10-NEXT:    addi r3, r3, .LCPI13_0@toc@l
; POWERPC64-BE-10-NEXT:    lxv v2, 0(r3)
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <8 x i16> <i16 1, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0>
}

; =============================================================================
; v16i8 tests - LSB set pattern (0x0000_0000_0000_0000_0000_0000_0000_0001)
; =============================================================================

; Big-Endian: 0x0000_0000_0000_0000_0000_0000_0000_0001 represents <0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1>
define dso_local noundef <16 x i8> @test_v16i8_lsb_set_bigendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v16i8_lsb_set_bigendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    plxv v2, .LCPI14_0@PCREL(0), 1
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v16i8_lsb_set_bigendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    xxspltib v2, 255
; POWERPC64-BE-10-NEXT:    vsrq v2, v2, v2
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <16 x i8> <i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 1>
}

; Little-Endian: 0x0000_0000_0000_0000_0000_0000_0000_0001 represents <1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0>
define dso_local noundef <16 x i8> @test_v16i8_lsb_set_littleendian() local_unnamed_addr {
; POWERPC64-LE-10-LABEL: test_v16i8_lsb_set_littleendian:
; POWERPC64-LE-10:       # %bb.0: # %entry
; POWERPC64-LE-10-NEXT:    xxspltib v2, 255
; POWERPC64-LE-10-NEXT:    vsrq v2, v2, v2
; POWERPC64-LE-10-NEXT:    blr
;
; POWERPC64-BE-10-LABEL: test_v16i8_lsb_set_littleendian:
; POWERPC64-BE-10:       # %bb.0: # %entry
; POWERPC64-BE-10-NEXT:    addis r3, r2, .LCPI15_0@toc@ha
; POWERPC64-BE-10-NEXT:    addi r3, r3, .LCPI15_0@toc@l
; POWERPC64-BE-10-NEXT:    lxv v2, 0(r3)
; POWERPC64-BE-10-NEXT:    blr
entry:
  ret <16 x i8> <i8 1, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>
}