; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr -mcpu=future < %s | \
; RUN:   FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-ibm-aix-xcoff \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr -mcpu=future < %s | \
; RUN:   FileCheck %s --check-prefix=AIX

; Test for load/store to/from v4i32.

define <4 x i32> @testLXVRL(ptr %a, i64 %b) {
; CHECK-LABEL: testLXVRL:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxvrl v2, r3, r4
; CHECK-NEXT:    blr
;
; AIX-LABEL: testLXVRL:
; AIX:       # %bb.0: # %entry
; AIX-NEXT:    lxvrl v2, r3, r4
; AIX-NEXT:    blr
entry:
  %0 = tail call <4 x i32> @llvm.ppc.vsx.lxvrl(ptr %a, i64 %b)
  ret <4 x i32> %0
}
declare <4 x i32> @llvm.ppc.vsx.lxvrl(ptr, i64)

define <4 x i32> @testLXVRLL(ptr %a, i64 %b) {
; CHECK-LABEL: testLXVRLL:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxvrll v2, r3, r4
; CHECK-NEXT:    blr
;
; AIX-LABEL: testLXVRLL:
; AIX:       # %bb.0: # %entry
; AIX-NEXT:    lxvrll v2, r3, r4
; AIX-NEXT:    blr
entry:
  %0 = tail call <4 x i32> @llvm.ppc.vsx.lxvrll(ptr %a, i64 %b)
  ret <4 x i32> %0
}
declare <4 x i32> @llvm.ppc.vsx.lxvrll(ptr, i64)

define void @testSTXVRL(<4 x i32> %a, ptr %b, i64 %c) {
; CHECK-LABEL: testSTXVRL:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stxvrl v2, r5, r6
; CHECK-NEXT:    blr
;
; AIX-LABEL: testSTXVRL:
; AIX:       # %bb.0: # %entry
; AIX-NEXT:    stxvrl v2, r3, r4
; AIX-NEXT:    blr
entry:
  tail call void @llvm.ppc.vsx.stxvrl(<4 x i32> %a, ptr %b, i64 %c)
  ret void
}
declare void @llvm.ppc.vsx.stxvrl(<4 x i32>, ptr, i64)

define void @testSTXVRLL(<4 x i32> %a, ptr %b, i64 %c) {
; CHECK-LABEL: testSTXVRLL:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stxvrll v2, r5, r6
; CHECK-NEXT:    blr
;
; AIX-LABEL: testSTXVRLL:
; AIX:       # %bb.0: # %entry
; AIX-NEXT:    stxvrll v2, r3, r4
; AIX-NEXT:    blr
entry:
  tail call void @llvm.ppc.vsx.stxvrll(<4 x i32> %a, ptr %b, i64 %c)
  ret void
}
declare void @llvm.ppc.vsx.stxvrll(<4 x i32>, ptr, i64)

; Test for load/store vectore pair.

define <256 x i1> @testLXVPRL(ptr %vpp, i64 %b) {
; CHECK-LABEL: testLXVPRL:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxvprl vsp34, r4, r5
; CHECK-NEXT:    stxv v2, 16(r3)
; CHECK-NEXT:    stxv v3, 0(r3)
; CHECK-NEXT:    blr
;
; AIX-LABEL: testLXVPRL:
; AIX:       # %bb.0: # %entry
; AIX-NEXT:    lxvprl vsp34, r4, r5
; AIX-NEXT:    stxv v3, 16(r3)
; AIX-NEXT:    stxv v2, 0(r3)
; AIX-NEXT:    blr
entry:
  %0 = tail call <256 x i1> @llvm.ppc.vsx.lxvprl(ptr %vpp, i64 %b)
  ret <256 x i1> %0
}
declare <256 x i1> @llvm.ppc.vsx.lxvprl(ptr, i64)

define <256 x i1> @testLXVPRLL(ptr %vpp, i64 %b) {
; CHECK-LABEL: testLXVPRLL:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxvprll vsp34, r4, r5
; CHECK-NEXT:    stxv v2, 16(r3)
; CHECK-NEXT:    stxv v3, 0(r3)
; CHECK-NEXT:    blr
;
; AIX-LABEL: testLXVPRLL:
; AIX:       # %bb.0: # %entry
; AIX-NEXT:    lxvprll vsp34, r4, r5
; AIX-NEXT:    stxv v3, 16(r3)
; AIX-NEXT:    stxv v2, 0(r3)
; AIX-NEXT:    blr
entry:
  %0 = tail call <256 x i1> @llvm.ppc.vsx.lxvprll(ptr %vpp, i64 %b)
  ret <256 x i1> %0
}
declare <256 x i1> @llvm.ppc.vsx.lxvprll(ptr, i64)

define void @testSTXVPRL(ptr %v, ptr %vp, i64 %len) {
; CHECK-LABEL: testSTXVPRL:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxv v2, 16(r3)
; CHECK-NEXT:    lxv v3, 0(r3)
; CHECK-NEXT:    stxvprl vsp34, r4, r5
; CHECK-NEXT:    blr
;
; AIX-LABEL: testSTXVPRL:
; AIX:       # %bb.0: # %entry
; AIX-NEXT:    lxv v2, 0(r3)
; AIX-NEXT:    lxv v3, 16(r3)
; AIX-NEXT:    stxvprl vsp34, r4, r5
; AIX-NEXT:    blr
entry:
  %0 = load <256 x i1>, ptr %v, align 32
  tail call void @llvm.ppc.vsx.stxvprl(<256 x i1> %0, ptr %vp, i64 %len)
  ret void
}
declare void @llvm.ppc.vsx.stxvprl(<256 x i1>, ptr, i64)

define void @testSTXVPRLL(ptr %v, ptr %vp, i64 %len) {
; CHECK-LABEL: testSTXVPRLL:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxv v2, 16(r3)
; CHECK-NEXT:    lxv v3, 0(r3)
; CHECK-NEXT:    stxvprll vsp34, r4, r5
; CHECK-NEXT:    blr
;
; AIX-LABEL: testSTXVPRLL:
; AIX:       # %bb.0: # %entry
; AIX-NEXT:    lxv v2, 0(r3)
; AIX-NEXT:    lxv v3, 16(r3)
; AIX-NEXT:    stxvprll vsp34, r4, r5
; AIX-NEXT:    blr
entry:
  %0 = load <256 x i1>, ptr %v, align 32
  tail call void @llvm.ppc.vsx.stxvprll(<256 x i1> %0, ptr %vp, i64 %len)
  ret void
}
declare void @llvm.ppc.vsx.stxvprll(<256 x i1>, ptr, i64)
