; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test file to verify the emission of Vector Evaluate instructions when ternary operators are used.

; RUN: llc -verify-machineinstrs -mcpu=pwr10 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s

; RUN: llc -verify-machineinstrs -mcpu=pwr10 -mtriple=powerpc-ibm-aix-xcoff \
; RUN:   -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s

; RUN: llc -verify-machineinstrs -mcpu=pwr10 -mtriple=powerpc64-ibm-aix-xcoff \
; RUN:   -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s

; Function to test ternary(A, and(B, C), xor(B, C)) for <4 x i32>
define <4 x i32> @ternary_A_and_BC_xor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_and_BC_xor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 97
; CHECK-NEXT:    blr
entry:
  %and = and <4 x i32> %B, %C
  %xor = xor <4 x i32> %B, %C
  %res = select <4 x i1> %A, <4 x i32> %and, <4 x i32> %xor
  ret <4 x i32> %res
}

; Function to test ternary(A, and(B, C), xor(B, C)) for <2 x i64>
define <2 x i64> @ternary_A_and_BC_xor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_and_BC_xor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 97
; CHECK-NEXT:    blr
entry:
  %and = and <2 x i64> %B, %C
  %xor = xor <2 x i64> %B, %C
  %res = select <2 x i1> %A, <2 x i64> %and, <2 x i64> %xor
  ret <2 x i64> %res
}

; Function to test ternary(A, and(B, C), xor(B, C)) for <16 x i8>
define <16 x i8> @ternary_A_and_BC_xor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_and_BC_xor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 97
; CHECK-NEXT:    blr
entry:
  %and = and <16 x i8> %B, %C
  %xor = xor <16 x i8> %B, %C
  %res = select <16 x i1> %A, <16 x i8> %and, <16 x i8> %xor
  ret <16 x i8> %res
}

; Function to test ternary(A, and(B, C), xor(B, C)) for <8 x i16>
define <8 x i16> @ternary_A_and_BC_xor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_and_BC_xor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 97
; CHECK-NEXT:    blr
entry:
  %and = and <8 x i16> %B, %C
  %xor = xor <8 x i16> %B, %C
  %res = select <8 x i1> %A, <8 x i16> %and, <8 x i16> %xor
  ret <8 x i16> %res
}

; Function to test ternary(A, B, xor(B, C)) for <4 x i32>
define <4 x i32> @ternary_A_B_xor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_B_xor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 99
; CHECK-NEXT:    blr
entry:
  %xor = xor <4 x i32> %B, %C
  %res = select <4 x i1> %A, <4 x i32> %B, <4 x i32> %xor
  ret <4 x i32> %res
}

; Function to test ternary(A, B, xor(B, C)) for <2 x i64>
define <2 x i64> @ternary_A_B_xor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_B_xor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 99
; CHECK-NEXT:    blr
entry:
  %xor = xor <2 x i64> %B, %C
  %res = select <2 x i1> %A, <2 x i64> %B, <2 x i64> %xor
  ret <2 x i64> %res
}

; Function to test ternary(A, B, xor(B, C)) for <16 x i8>
define <16 x i8> @ternary_A_B_xor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_B_xor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 99
; CHECK-NEXT:    blr
entry:
  %xor = xor <16 x i8> %B, %C
  %res = select <16 x i1> %A, <16 x i8> %B, <16 x i8> %xor
  ret <16 x i8> %res
}

; Function to test ternary(A, B, xor(B, C)) for <8 x i16>
define <8 x i16> @ternary_A_B_xor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_B_xor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 99
; CHECK-NEXT:    blr
entry:
  %xor = xor <8 x i16> %B, %C
  %res = select <8 x i1> %A, <8 x i16> %B, <8 x i16> %xor
  ret <8 x i16> %res
}

; Function to test ternary(A, C, xor(B, C)) for <4 x i32>
define <4 x i32> @ternary_A_C_xor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_C_xor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 101
; CHECK-NEXT:    blr
entry:
  %xor = xor <4 x i32> %B, %C
  %res = select <4 x i1> %A, <4 x i32> %C, <4 x i32> %xor
  ret <4 x i32> %res
}

; Function to test ternary(A, C, xor(B, C)) for <2 x i64>
define <2 x i64> @ternary_A_C_xor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_C_xor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 101
; CHECK-NEXT:    blr
entry:
  %xor = xor <2 x i64> %B, %C
  %res = select <2 x i1> %A, <2 x i64> %C, <2 x i64> %xor
  ret <2 x i64> %res
}

; Function to test ternary(A, C, xor(B, C)) for <16 x i8>
define <16 x i8> @ternary_A_C_xor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_C_xor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 101
; CHECK-NEXT:    blr
entry:
  %xor = xor <16 x i8> %B, %C
  %res = select <16 x i1> %A, <16 x i8> %C, <16 x i8> %xor
  ret <16 x i8> %res
}

; Function to test ternary(A, C, xor(B, C)) for <8 x i16>
define <8 x i16> @ternary_A_C_xor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_C_xor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 101
; CHECK-NEXT:    blr
entry:
  %xor = xor <8 x i16> %B, %C
  %res = select <8 x i1> %A, <8 x i16> %C, <8 x i16> %xor
  ret <8 x i16> %res
}

; Function to test ternary(A, or(B, C), xor(B, C)) for <4 x i32>
define <4 x i32> @ternary_A_or_BC_xor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_or_BC_xor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 103
; CHECK-NEXT:    blr
entry:
  %or = or <4 x i32> %B, %C
  %xor = xor <4 x i32> %B, %C
  %res = select <4 x i1> %A, <4 x i32> %or, <4 x i32> %xor
  ret <4 x i32> %res
}

; Function to test ternary(A, or(B, C), xor(B, C)) for <2 x i64>
define <2 x i64> @ternary_A_or_BC_xor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_or_BC_xor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 103
; CHECK-NEXT:    blr
entry:
  %or = or <2 x i64> %B, %C
  %xor = xor <2 x i64> %B, %C
  %res = select <2 x i1> %A, <2 x i64> %or, <2 x i64> %xor
  ret <2 x i64> %res
}

; Function to test ternary(A, or(B, C), xor(B, C)) for <16 x i8>
define <16 x i8> @ternary_A_or_BC_xor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_or_BC_xor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 103
; CHECK-NEXT:    blr
entry:
  %or = or <16 x i8> %B, %C
  %xor = xor <16 x i8> %B, %C
  %res = select <16 x i1> %A, <16 x i8> %or, <16 x i8> %xor
  ret <16 x i8> %res
}

; Function to test ternary(A, or(B, C), xor(B, C)) for <8 x i16>
define <8 x i16> @ternary_A_or_BC_xor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_or_BC_xor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 103
; CHECK-NEXT:    blr
entry:
  %or = or <8 x i16> %B, %C
  %xor = xor <8 x i16> %B, %C
  %res = select <8 x i1> %A, <8 x i16> %or, <8 x i16> %xor
  ret <8 x i16> %res
}

; Function to test ternary(A, nor(B, C), xor(B, C)) for <4 x i32>
define <4 x i32> @ternary_A_nor_BC_xor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_nor_BC_xor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 104
; CHECK-NEXT:    blr
entry:
  %or = or <4 x i32> %B, %C
  %nor = xor <4 x i32> %or, <i32 -1, i32 -1, i32 -1, i32 -1>    ; vector nor operation
  %xor = xor <4 x i32> %B, %C
  %res = select <4 x i1> %A, <4 x i32> %nor, <4 x i32> %xor
  ret <4 x i32> %res
}

; Function to test ternary(A, nor(B, C), xor(B, C)) for <2 x i64>
define <2 x i64> @ternary_A_nor_BC_xor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_nor_BC_xor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 104
; CHECK-NEXT:    blr
entry:
  %or = or <2 x i64> %B, %C
  %nor = xor <2 x i64> %or, <i64 -1, i64 -1>    ; vector nor operation
  %xor = xor <2 x i64> %B, %C
  %res = select <2 x i1> %A, <2 x i64> %nor, <2 x i64> %xor
  ret <2 x i64> %res
}

; Function to test ternary(A, nor(B, C), xor(B, C)) for <16 x i8>
define <16 x i8> @ternary_A_nor_BC_xor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_nor_BC_xor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 104
; CHECK-NEXT:    blr
entry:
  %or = or <16 x i8> %B, %C
  %nor = xor <16 x i8> %or, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>    ; vector nor operation
  %xor = xor <16 x i8> %B, %C
  %res = select <16 x i1> %A, <16 x i8> %nor, <16 x i8> %xor
  ret <16 x i8> %res
}

; Function to test ternary(A, nor(B, C), xor(B, C)) for <8 x i16>
define <8 x i16> @ternary_A_nor_BC_xor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_nor_BC_xor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 104
; CHECK-NEXT:    blr
entry:
  %or = or <8 x i16> %B, %C
  %nor = xor <8 x i16> %or, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>    ; vector nor operation
  %xor = xor <8 x i16> %B, %C
  %res = select <8 x i1> %A, <8 x i16> %nor, <8 x i16> %xor
  ret <8 x i16> %res
}
