#########################################################################################
# Package        HiPi::Graphics::BitmapFont::SerifEPD33
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::SerifEPD33;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 33;
my $line_spacing = 0;
my $name = 'Serif 33';
my $space_width = 9;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 3, 
        'xoffset'  => 4, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 7, 
        'xoffset'  => 3, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 18, 
        'xoffset'  => 2, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0x87, 0x00, ##         00    000  
            0x01, 0x86, 0x00, ##         00    00   
            0x01, 0x86, 0x00, ##         00    00   
            0x03, 0x86, 0x00, ##        000    00   
            0x03, 0x8E, 0x00, ##        000   000   
            0x03, 0x0C, 0x00, ##        00    00    
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x7F, 0xFF, 0xC0, ##   00000000000000000
            0x07, 0x1C, 0x00, ##       000   000    
            0x06, 0x1C, 0x00, ##       00    000    
            0x06, 0x18, 0x00, ##       00    00     
            0x06, 0x18, 0x00, ##       00    00     
            0x0E, 0x18, 0x00, ##      000    00     
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0x0C, 0x30, 0x00, ##      00    00      
            0x1C, 0x30, 0x00, ##     000    00      
            0x18, 0x70, 0x00, ##     00    000      
            0x18, 0x60, 0x00, ##     00    00       
            0x18, 0x60, 0x00, ##     00    00       
            0x38, 0x60, 0x00, ##    000    00       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x02, 0x00, ##        0      
            0x02, 0x00, ##        0      
            0x02, 0x00, ##        0      
            0x1F, 0xE0, ##     00000000  
            0x72, 0x70, ##   000  0  000 
            0x62, 0x30, ##   00   0   00 
            0xE2, 0x30, ##  000   0   00 
            0xE2, 0x30, ##  000   0   00 
            0xF2, 0x00, ##  0000  0      
            0xFA, 0x00, ##  00000 0      
            0x7E, 0x00, ##   000000      
            0x3F, 0xC0, ##    00000000   
            0x0F, 0xF0, ##      00000000 
            0x03, 0xF0, ##        000000 
            0x02, 0x78, ##        0  0000
            0x02, 0x38, ##        0   000
            0x82, 0x38, ##  0     0   000
            0x82, 0x38, ##  0     0   000
            0xC2, 0x30, ##  00    0   00 
            0xE2, 0x70, ##  000   0  000 
            0x3F, 0xC0, ##    00000000   
            0x02, 0x00, ##        0      
            0x02, 0x00, ##        0      
            0x02, 0x00, ##        0      
            0x02, 0x00, ##        0      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x3E, 0x00, 0x60, ##    00000          00    
            0x63, 0x00, 0xC0, ##   00   00        00     
            0x63, 0x01, 0x80, ##   00   00       00      
            0xC1, 0x81, 0x80, ##  00     00      00      
            0xC1, 0x83, 0x00, ##  00     00     00       
            0xC1, 0x87, 0x00, ##  00     00    000       
            0xC1, 0x86, 0x00, ##  00     00    00        
            0xC1, 0x8C, 0x00, ##  00     00   00         
            0x63, 0x0C, 0x00, ##   00   00    00         
            0x63, 0x18, 0x00, ##   00   00   00          
            0x3E, 0x38, 0xF8, ##    00000   000   00000  
            0x00, 0x31, 0x8C, ##            00   00   00 
            0x00, 0x61, 0x8C, ##           00    00   00 
            0x00, 0x63, 0x06, ##           00   00     00
            0x00, 0xC3, 0x06, ##          00    00     00
            0x01, 0xC3, 0x06, ##         000    00     00
            0x01, 0x83, 0x06, ##         00     00     00
            0x03, 0x03, 0x06, ##        00      00     00
            0x03, 0x01, 0x0C, ##        00       0    00 
            0x06, 0x01, 0x8C, ##       00        00   00 
            0x0C, 0x00, 0xF8, ##      00          00000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, ##        000000         
            0x0E, 0x38, 0x00, ##      000   000        
            0x1C, 0x18, 0x00, ##     000     00        
            0x1C, 0x08, 0x00, ##     000      0        
            0x1C, 0x00, 0x00, ##     000               
            0x1C, 0x00, 0x00, ##     000               
            0x1E, 0x00, 0x00, ##     0000              
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x80, 0x00, ##      00000            
            0x3B, 0x83, 0xF0, ##    000 000     000000 
            0x71, 0xC0, 0xC0, ##   000   000      00   
            0x70, 0xE0, 0xC0, ##   000    000     00   
            0xE0, 0x70, 0x80, ##  000      000    0    
            0xE0, 0x79, 0x80, ##  000      0000  00    
            0xE0, 0x39, 0x80, ##  000       000  00    
            0xE0, 0x1F, 0x00, ##  000        00000     
            0xE0, 0x0F, 0x00, ##  000         0000     
            0x70, 0x07, 0x00, ##   000         000     
            0x78, 0x07, 0x00, ##   0000        000     
            0x3C, 0x1B, 0x80, ##    0000     00 000    
            0x0F, 0xE1, 0xF8, ##      0000000    000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x06, ##       00
            0x0C, ##      00 
            0x18, ##     00  
            0x30, ##    00   
            0x30, ##    00   
            0x70, ##   000   
            0x60, ##   00    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0x60, ##   00    
            0x70, ##   000   
            0x30, ##    00   
            0x30, ##    00   
            0x18, ##     00  
            0x0C, ##      00 
            0x06, ##       00
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00     
            0x60, ##   00    
            0x30, ##    00   
            0x38, ##    000  
            0x18, ##     00  
            0x1C, ##     000 
            0x1C, ##     000 
            0x0C, ##      00 
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0C, ##      00 
            0x1C, ##     000 
            0x1C, ##     000 
            0x18, ##     00  
            0x38, ##    000  
            0x30, ##    00   
            0x60, ##   00    
            0xC0, ##  00     
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x86, 0x10, ##  0    00    0 
            0xC6, 0x30, ##  00   00   00 
            0x76, 0xE0, ##   000 00 000  
            0x1F, 0x80, ##     000000    
            0x06, 0x00, ##       00      
            0x1F, 0x80, ##     000000    
            0x76, 0xE0, ##   000 00 000  
            0xC6, 0x30, ##  00   00   00 
            0x86, 0x10, ##  0    00    0 
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x38, ##    000
            0x38, ##    000
            0x38, ##    000
            0x70, ##   000 
            0x70, ##   000 
            0xE0, ##  000  
            0x80, ##  0    
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 3, 
        'xoffset'  => 3, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x03, 0x00, ##        00 
            0x03, 0x00, ##        00 
            0x03, 0x00, ##        00 
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x0E, 0x00, ##      000  
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x1C, 0x00, ##     000   
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0xE0, 0x00, ##  000      
            0xC0, 0x00, ##  00       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000     
            0x18, 0x60, ##     00    00   
            0x30, 0x30, ##    00      00  
            0x70, 0x38, ##   000      000 
            0x70, 0x38, ##   000      000 
            0x60, 0x18, ##   00        00 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x60, 0x18, ##   00        00 
            0x70, 0x38, ##   000      000 
            0x70, 0x38, ##   000      000 
            0x30, 0x30, ##    00      00  
            0x18, 0x60, ##     00    00   
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 10, 
        'xoffset'  => 4, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1C, 0x00, ##     000    
            0x3C, 0x00, ##    0000    
            0x7C, 0x00, ##   00000    
            0xDC, 0x00, ##  00 000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0x1C, 0x00, ##     000    
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000    
            0xE1, 0xC0, ##  000    000  
            0xC0, 0xE0, ##  00      000 
            0x80, 0x70, ##  0        000
            0x80, 0x70, ##  0        000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0xE0, ##          000 
            0x00, 0xE0, ##          000 
            0x00, 0xC0, ##          00  
            0x01, 0x80, ##         00   
            0x03, 0x80, ##        000   
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x1C, 0x00, ##     000      
            0x38, 0x30, ##    000     00
            0x70, 0x30, ##   000      00
            0x60, 0x30, ##   00       00
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x80, ##    0000000    
            0x70, 0xE0, ##   000    000  
            0x60, 0xE0, ##   00     000  
            0x60, 0x70, ##   00      000 
            0x40, 0x70, ##   0       000 
            0x00, 0x70, ##           000 
            0x00, 0x70, ##           000 
            0x00, 0xE0, ##          000  
            0x01, 0xC0, ##         000   
            0x0F, 0x00, ##      0000     
            0x00, 0xE0, ##          000  
            0x00, 0x70, ##           000 
            0x00, 0x30, ##            00 
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0xC0, 0x38, ##  00        000
            0xC0, 0x38, ##  00        000
            0xE0, 0x70, ##  000      000 
            0xF0, 0xE0, ##  0000    000  
            0x3F, 0x80, ##    0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xE0, ##          000    
            0x01, 0xE0, ##         0000    
            0x01, 0xE0, ##         0000    
            0x03, 0xE0, ##        00000    
            0x06, 0xE0, ##       00 000    
            0x06, 0xE0, ##       00 000    
            0x0C, 0xE0, ##      00  000    
            0x08, 0xE0, ##      0   000    
            0x18, 0xE0, ##     00   000    
            0x10, 0xE0, ##     0    000    
            0x30, 0xE0, ##    00    000    
            0x60, 0xE0, ##   00     000    
            0x60, 0xE0, ##   00     000    
            0xC0, 0xE0, ##  00      000    
            0xFF, 0xFE, ##  000000000000000
            0x00, 0xE0, ##          000    
            0x00, 0xE0, ##          000    
            0x00, 0xE0, ##          000    
            0x00, 0xE0, ##          000    
            0x00, 0xE0, ##          000    
            0x07, 0xFC, ##       000000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7F, 0xE0, ##   0000000000  
            0x7F, 0xE0, ##   0000000000  
            0x40, 0x00, ##   0           
            0x40, 0x00, ##   0           
            0x40, 0x00, ##   0           
            0x40, 0x00, ##   0           
            0x40, 0x00, ##   0           
            0x5F, 0x80, ##   0 000000    
            0x70, 0xE0, ##   000    000  
            0x40, 0x70, ##   0       000 
            0x00, 0x70, ##           000 
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0xC0, 0x38, ##  00        000
            0xC0, 0x70, ##  00       000 
            0xE0, 0x70, ##  000      000 
            0xF0, 0xE0, ##  0000    000  
            0x3F, 0x80, ##    0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xF0, ##       0000000  
            0x08, 0x38, ##      0     000 
            0x30, 0x18, ##    00       00 
            0x30, 0x18, ##    00       00 
            0x60, 0x00, ##   00           
            0x60, 0x00, ##   00           
            0x60, 0x00, ##   00           
            0xE7, 0xC0, ##  000  00000    
            0xF8, 0x70, ##  00000    000  
            0xF0, 0x38, ##  0000      000 
            0xF0, 0x38, ##  0000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x60, 0x1C, ##   00        000
            0x70, 0x38, ##   000      000 
            0x30, 0x38, ##    00      000 
            0x18, 0x70, ##     00    000  
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xC0, 0x18, ##  00         00
            0xC0, 0x30, ##  00        00 
            0xC0, 0x30, ##  00        00 
            0x00, 0x60, ##           00  
            0x00, 0x60, ##           00  
            0x00, 0x60, ##           00  
            0x00, 0xC0, ##          00   
            0x00, 0xC0, ##          00   
            0x00, 0xC0, ##          00   
            0x01, 0x80, ##         00    
            0x01, 0x80, ##         00    
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x0C, 0x00, ##      00       
            0x0C, 0x00, ##      00       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xC0, ##     0000000    
            0x38, 0xE0, ##    000   000   
            0x70, 0x70, ##   000     000  
            0xE0, 0x38, ##  000       000 
            0xE0, 0x38, ##  000       000 
            0xE0, 0x38, ##  000       000 
            0xE0, 0x38, ##  000       000 
            0x70, 0x70, ##   000     000  
            0x38, 0xF0, ##    000   0000  
            0x0F, 0xC0, ##      000000    
            0x38, 0x60, ##    000    00   
            0x70, 0x38, ##   000      000 
            0xE0, 0x18, ##  000        00 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x38, ##   000      000 
            0x38, 0x70, ##    000    000  
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000    
            0x38, 0x60, ##    000    00   
            0x70, 0x30, ##   000      00  
            0x60, 0x38, ##   00       000 
            0xE0, 0x38, ##  000       000 
            0xE0, 0x18, ##  000        00 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x3C, ##  000       0000
            0x60, 0x3C, ##   00       0000
            0x70, 0x3C, ##   000      0000
            0x38, 0x7C, ##    000    00000
            0x0F, 0x9C, ##      00000  000
            0x00, 0x1C, ##             000
            0x00, 0x18, ##             00 
            0x00, 0x18, ##             00 
            0x00, 0x38, ##            000 
            0x60, 0x30, ##   00       00  
            0x60, 0x70, ##   00      000  
            0x70, 0xC0, ##   000    00    
            0x3F, 0x80, ##    0000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 3, 
        'xoffset'  => 3, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x38, ##    000
            0x38, ##    000
            0x38, ##    000
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x38, ##    000
            0x38, ##    000
            0x38, ##    000
            0x38, ##    000
            0x70, ##   000 
            0x60, ##   00  
            0xC0, ##  00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0x80, ##                 00
            0x00, 0x0F, 0x80, ##              00000
            0x00, 0x7F, 0x00, ##           0000000 
            0x01, 0xF8, 0x00, ##         000000    
            0x0F, 0xC0, 0x00, ##      000000       
            0x7F, 0x00, 0x00, ##   0000000         
            0xF8, 0x00, 0x00, ##  00000            
            0xF0, 0x00, 0x00, ##  0000             
            0xFE, 0x00, 0x00, ##  0000000          
            0x1F, 0x80, 0x00, ##     000000        
            0x03, 0xF0, 0x00, ##        000000     
            0x00, 0xFE, 0x00, ##          0000000  
            0x00, 0x1F, 0x80, ##             000000
            0x00, 0x03, 0x80, ##                000
            0x00, 0x00, 0x80, ##                  0
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xC0, 0x00, 0x00, ##  00               
            0xF8, 0x00, 0x00, ##  00000            
            0x7F, 0x00, 0x00, ##   0000000         
            0x0F, 0xC0, 0x00, ##      000000       
            0x01, 0xF8, 0x00, ##         000000    
            0x00, 0x7F, 0x00, ##           0000000 
            0x00, 0x0F, 0x80, ##              00000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x3F, 0x80, ##            0000000
            0x00, 0xFC, 0x00, ##          000000   
            0x07, 0xE0, 0x00, ##       000000      
            0x3F, 0x80, 0x00, ##    0000000        
            0xFC, 0x00, 0x00, ##  000000           
            0xE0, 0x00, 0x00, ##  000              
            0x80, 0x00, 0x00, ##  0                
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000    
            0xE1, 0xC0, ##  000    000  
            0xC0, 0xE0, ##  00      000 
            0xC0, 0x70, ##  00       000
            0x80, 0x70, ##  0        000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0xE0, ##          000 
            0x01, 0xE0, ##         0000 
            0x07, 0xC0, ##       00000  
            0x0F, 0x00, ##      0000    
            0x0C, 0x00, ##      00      
            0x0C, 0x00, ##      00      
            0x0C, 0x00, ##      00      
            0x0C, 0x00, ##      00      
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x1C, 0x00, ##     000      
            0x1C, 0x00, ##     000      
            0x1C, 0x00, ##     000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 23, 
        'xoffset'  => 2, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xFE, 0x00, ##          0000000        
            0x03, 0x81, 0xC0, ##        000      000     
            0x06, 0x00, 0x20, ##       00           0    
            0x1C, 0x00, 0x10, ##     000             0   
            0x38, 0x00, 0x08, ##    000               0  
            0x30, 0x00, 0x04, ##    00                 0 
            0x60, 0x79, 0x84, ##   00      0000  00    0 
            0x60, 0xE7, 0x82, ##   00     000  0000     0
            0xC1, 0xC3, 0x82, ##  00     000    000     0
            0xC3, 0x81, 0x82, ##  00    000      00     0
            0xC3, 0x81, 0x82, ##  00    000      00     0
            0xC3, 0x81, 0x82, ##  00    000      00     0
            0xC3, 0x81, 0x82, ##  00    000      00     0
            0xC3, 0x81, 0x84, ##  00    000      00    0 
            0xC3, 0x81, 0x84, ##  00    000      00    0 
            0xC1, 0xC3, 0x88, ##  00     000    000   0  
            0x60, 0xC7, 0x90, ##   00     00   0000  0   
            0x60, 0x79, 0xE0, ##   00      0000  0000    
            0x30, 0x00, 0x00, ##    00                   
            0x30, 0x00, 0x00, ##    00                   
            0x18, 0x00, 0x00, ##     00                  
            0x0E, 0x00, 0x60, ##      000          00    
            0x03, 0x81, 0xC0, ##        000      000     
            0x00, 0xFE, 0x00, ##          0000000        
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x70, 0x00, ##           000        
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0x98, 0x00, ##         00  00       
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x0E, 0x00, ##        00    000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x07, 0x00, ##       00      000    
            0x0C, 0x07, 0x00, ##      00       000    
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x30, 0x01, 0xC0, ##    00           000  
            0x30, 0x01, 0xC0, ##    00           000  
            0xFC, 0x07, 0xF0, ##  000000       0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000    
            0x38, 0x3C, ##    000     0000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x0E, ##    000       000 
            0x38, 0x0E, ##    000       000 
            0x38, 0x0E, ##    000       000 
            0x38, 0x0E, ##    000       000 
            0x38, 0x1C, ##    000      000  
            0x38, 0x3C, ##    000     0000  
            0x3F, 0xE0, ##    000000000     
            0x38, 0x1C, ##    000      000  
            0x38, 0x0E, ##    000       000 
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x0E, ##    000       000 
            0x38, 0x1C, ##    000      000  
            0xFF, 0xF0, ##  000000000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 18, 
        'xoffset'  => 2, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFC, 0x00, ##        00000000    
            0x0E, 0x0F, 0x80, ##      000     00000 
            0x18, 0x03, 0x80, ##     00         000 
            0x38, 0x01, 0x80, ##    000          00 
            0x70, 0x01, 0x80, ##   000           00 
            0x70, 0x01, 0x80, ##   000           00 
            0x60, 0x00, 0x00, ##   00               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0x60, 0x00, 0x00, ##   00               
            0x70, 0x01, 0xC0, ##   000           000
            0x70, 0x01, 0x80, ##   000           00 
            0x38, 0x03, 0x80, ##    000         000 
            0x18, 0x07, 0x00, ##     00        000  
            0x0E, 0x0E, 0x00, ##      000     000   
            0x03, 0xF8, 0x00, ##        0000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 18, 
        'xoffset'  => 2, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, ##  00000000000       
            0x38, 0x38, 0x00, ##    000     000     
            0x38, 0x0E, 0x00, ##    000       000   
            0x38, 0x07, 0x00, ##    000        000  
            0x38, 0x03, 0x80, ##    000         000 
            0x38, 0x03, 0x80, ##    000         000 
            0x38, 0x01, 0x80, ##    000          00 
            0x38, 0x01, 0xC0, ##    000          000
            0x38, 0x01, 0xC0, ##    000          000
            0x38, 0x01, 0xC0, ##    000          000
            0x38, 0x01, 0xC0, ##    000          000
            0x38, 0x01, 0xC0, ##    000          000
            0x38, 0x01, 0xC0, ##    000          000
            0x38, 0x01, 0xC0, ##    000          000
            0x38, 0x03, 0x80, ##    000         000 
            0x38, 0x03, 0x80, ##    000         000 
            0x38, 0x03, 0x80, ##    000         000 
            0x38, 0x07, 0x00, ##    000        000  
            0x38, 0x0E, 0x00, ##    000       000   
            0x38, 0x3C, 0x00, ##    000     0000    
            0xFF, 0xE0, 0x00, ##  00000000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1F, 0xFC, 0x00, ##     00000000000   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFF, ##  0000000000000000
            0x38, 0x03, ##    000         00
            0x38, 0x03, ##    000         00
            0x38, 0x03, ##    000         00
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x0C, ##    000       00  
            0x38, 0x0C, ##    000       00  
            0x38, 0x0C, ##    000       00  
            0x3F, 0xFC, ##    000000000000  
            0x38, 0x0C, ##    000       00  
            0x38, 0x0C, ##    000       00  
            0x38, 0x0C, ##    000       00  
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0xFF, 0x00, ##  00000000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 18, 
        'xoffset'  => 2, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFC, 0x00, ##        00000000    
            0x0E, 0x0F, 0x80, ##      000     00000 
            0x18, 0x03, 0x80, ##     00         000 
            0x38, 0x01, 0x80, ##    000          00 
            0x70, 0x01, 0x80, ##   000           00 
            0x70, 0x01, 0x80, ##   000           00 
            0x60, 0x00, 0x00, ##   00               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x1F, 0xC0, ##  000        0000000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0x60, 0x01, 0xC0, ##   00            000
            0x70, 0x01, 0xC0, ##   000           000
            0x70, 0x01, 0xC0, ##   000           000
            0x38, 0x01, 0xC0, ##    000          000
            0x18, 0x01, 0xC0, ##     00          000
            0x0E, 0x07, 0x80, ##      000      0000 
            0x03, 0xFC, 0x00, ##        00000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 21, 
        'xoffset'  => 1, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0x07, 0xF8, ##  00000000     00000000
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0x38, 0x01, 0xC0, ##    000          000   
            0xFF, 0x07, 0xF8, ##  00000000     00000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 12, 
        'xoffset'  => -2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xF0, ##      00000000
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0xC3, 0x80, ##  00    000   
            0xC3, 0x00, ##  00    00    
            0xE7, 0x00, ##  000  000    
            0x7C, 0x00, ##   00000      
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 19, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0x1F, 0xC0, ##  00000000   0000000 
            0x38, 0x06, 0x00, ##    000        00    
            0x38, 0x0C, 0x00, ##    000       00     
            0x38, 0x18, 0x00, ##    000      00      
            0x38, 0x30, 0x00, ##    000     00       
            0x38, 0x60, 0x00, ##    000    00        
            0x38, 0xC0, 0x00, ##    000   00         
            0x39, 0x80, 0x00, ##    000  00          
            0x3B, 0x00, 0x00, ##    000 00           
            0x3F, 0x00, 0x00, ##    000000           
            0x3F, 0x80, 0x00, ##    0000000          
            0x3F, 0x80, 0x00, ##    0000000          
            0x3B, 0xC0, 0x00, ##    000 0000         
            0x39, 0xE0, 0x00, ##    000  0000        
            0x38, 0xF0, 0x00, ##    000   0000       
            0x38, 0x78, 0x00, ##    000    0000      
            0x38, 0x3C, 0x00, ##    000     0000     
            0x38, 0x1E, 0x00, ##    000      0000    
            0x38, 0x0E, 0x00, ##    000       000    
            0x38, 0x07, 0x00, ##    000        000   
            0xFF, 0x03, 0xE0, ##  00000000      00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000        
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x03, ##    000         00
            0x38, 0x03, ##    000         00
            0x38, 0x03, ##    000         00
            0x38, 0x03, ##    000         00
            0xFF, 0xFF, ##  0000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 25, 
        'xoffset'  => 1, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x1F, 0x80, ##  000000             000000
            0x3C, 0x00, 0x3C, 0x00, ##    0000            0000   
            0x3E, 0x00, 0x3C, 0x00, ##    00000           0000   
            0x3E, 0x00, 0x7C, 0x00, ##    00000          00000   
            0x37, 0x00, 0x5C, 0x00, ##    00 000         0 000   
            0x37, 0x00, 0x5C, 0x00, ##    00 000         0 000   
            0x33, 0x80, 0xDC, 0x00, ##    00  000       00 000   
            0x33, 0x80, 0x9C, 0x00, ##    00  000       0  000   
            0x31, 0xC1, 0x9C, 0x00, ##    00   000     00  000   
            0x31, 0xC1, 0x1C, 0x00, ##    00   000     0   000   
            0x30, 0xE1, 0x1C, 0x00, ##    00    000    0   000   
            0x30, 0xE3, 0x1C, 0x00, ##    00    000   00   000   
            0x30, 0xE2, 0x1C, 0x00, ##    00    000   0    000   
            0x30, 0x76, 0x1C, 0x00, ##    00     000 00    000   
            0x30, 0x74, 0x1C, 0x00, ##    00     000 0     000   
            0x30, 0x3C, 0x1C, 0x00, ##    00      0000     000   
            0x30, 0x3C, 0x1C, 0x00, ##    00      0000     000   
            0x30, 0x18, 0x1C, 0x00, ##    00       00      000   
            0x30, 0x00, 0x1C, 0x00, ##    00               000   
            0x30, 0x00, 0x1C, 0x00, ##    00               000   
            0xFE, 0x00, 0x7F, 0x80, ##  0000000          00000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 21, 
        'xoffset'  => 1, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x03, 0xF8, ##  00000         0000000
            0x3C, 0x00, 0x60, ##    0000           00  
            0x3E, 0x00, 0x60, ##    00000          00  
            0x3E, 0x00, 0x60, ##    00000          00  
            0x37, 0x00, 0x60, ##    00 000         00  
            0x33, 0x80, 0x60, ##    00  000        00  
            0x33, 0xC0, 0x60, ##    00  0000       00  
            0x31, 0xC0, 0x60, ##    00   000       00  
            0x30, 0xE0, 0x60, ##    00    000      00  
            0x30, 0x70, 0x60, ##    00     000     00  
            0x30, 0x70, 0x60, ##    00     000     00  
            0x30, 0x38, 0x60, ##    00      000    00  
            0x30, 0x1C, 0x60, ##    00       000   00  
            0x30, 0x1E, 0x60, ##    00       0000  00  
            0x30, 0x0E, 0x60, ##    00        000  00  
            0x30, 0x07, 0x60, ##    00         000 00  
            0x30, 0x03, 0xE0, ##    00          00000  
            0x30, 0x03, 0xE0, ##    00          00000  
            0x30, 0x01, 0xE0, ##    00           0000  
            0x30, 0x00, 0xE0, ##    00            000  
            0xFE, 0x00, 0x60, ##  0000000          00  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF8, 0x00, ##        0000000      
            0x0E, 0x0E, 0x00, ##      000     000    
            0x18, 0x03, 0x00, ##     00         00   
            0x38, 0x03, 0x80, ##    000         000  
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x60, 0x00, 0xC0, ##   00             00 
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0x60, 0x00, 0xC0, ##   00             00 
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x38, 0x03, 0x80, ##    000         000  
            0x18, 0x03, 0x00, ##     00         00   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x03, 0xF8, 0x00, ##        0000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000    
            0x38, 0x1C, ##    000      000  
            0x38, 0x0E, ##    000       000 
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x0E, ##    000       000 
            0x38, 0x1C, ##    000      000  
            0x3F, 0xF0, ##    0000000000    
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0xFF, 0x00, ##  00000000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF8, 0x00, ##        0000000      
            0x0E, 0x0E, 0x00, ##      000     000    
            0x18, 0x03, 0x00, ##     00         00   
            0x38, 0x03, 0x80, ##    000         000  
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x60, 0x00, 0xC0, ##   00             00 
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0x60, 0x00, 0xC0, ##   00             00 
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x38, 0x03, 0x80, ##    000         000  
            0x18, 0x03, 0x00, ##     00         00   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x03, 0xF8, 0x00, ##        0000000      
            0x00, 0x30, 0x00, ##            00       
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x0F, 0x00, ##              0000   
            0x00, 0x07, 0x00, ##               000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 20, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xF8, 0x00, ##  0000000000000       
            0x38, 0x1C, 0x00, ##    000      000      
            0x38, 0x0E, 0x00, ##    000       000     
            0x38, 0x07, 0x00, ##    000        000    
            0x38, 0x07, 0x00, ##    000        000    
            0x38, 0x07, 0x00, ##    000        000    
            0x38, 0x07, 0x00, ##    000        000    
            0x38, 0x07, 0x00, ##    000        000    
            0x38, 0x0E, 0x00, ##    000       000     
            0x38, 0x1E, 0x00, ##    000      0000     
            0x3F, 0xF8, 0x00, ##    00000000000       
            0x38, 0x38, 0x00, ##    000     000       
            0x38, 0x1C, 0x00, ##    000      000      
            0x38, 0x1C, 0x00, ##    000      000      
            0x38, 0x0E, 0x00, ##    000       000     
            0x38, 0x0E, 0x00, ##    000       000     
            0x38, 0x07, 0x00, ##    000        000    
            0x38, 0x07, 0x00, ##    000        000    
            0x38, 0x03, 0x00, ##    000         00    
            0x38, 0x03, 0x80, ##    000         000   
            0xFF, 0x01, 0xF0, ##  00000000       00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xE0, ##     00000000   
            0x38, 0x78, ##    000    0000 
            0x70, 0x38, ##   000      000 
            0xE0, 0x18, ##  000        00 
            0xE0, 0x18, ##  000        00 
            0xE0, 0x00, ##  000           
            0xF0, 0x00, ##  0000          
            0xF8, 0x00, ##  00000         
            0x7E, 0x00, ##   000000       
            0x7F, 0xC0, ##   000000000    
            0x1F, 0xF0, ##     000000000  
            0x07, 0xF8, ##       00000000 
            0x00, 0xFC, ##          000000
            0x00, 0x3C, ##            0000
            0x00, 0x1C, ##             000
            0xC0, 0x1C, ##  00         000
            0xC0, 0x1C, ##  00         000
            0xC0, 0x1C, ##  00         000
            0xE0, 0x38, ##  000       000 
            0xF0, 0x70, ##  0000     000  
            0x3F, 0xC0, ##    00000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xC1, 0xC0, 0xC0, ##  00     000      00
            0xC1, 0xC0, 0xC0, ##  00     000      00
            0xC1, 0xC0, 0xC0, ##  00     000      00
            0xC1, 0xC0, 0xC0, ##  00     000      00
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x07, 0xF8, 0x00, ##       00000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 20, 
        'xoffset'  => 1, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0x07, 0xF0, ##  00000000     0000000
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x1C, 0x01, 0x80, ##     000         00   
            0x1C, 0x01, 0x80, ##     000         00   
            0x1F, 0x07, 0x80, ##     00000     0000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x03, 0xFC, 0x00, ##        00000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFE, 0x03, 0xF0, ##  0000000       000000
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x1C, 0x01, 0x80, ##     000         00   
            0x1C, 0x01, 0x80, ##     000         00   
            0x1C, 0x01, 0x00, ##     000         0    
            0x0E, 0x03, 0x00, ##      000       00    
            0x0E, 0x03, 0x00, ##      000       00    
            0x0E, 0x02, 0x00, ##      000       0     
            0x07, 0x06, 0x00, ##       000     00     
            0x07, 0x06, 0x00, ##       000     00     
            0x07, 0x04, 0x00, ##       000     0      
            0x03, 0x8C, 0x00, ##        000   00      
            0x03, 0x8C, 0x00, ##        000   00      
            0x01, 0x88, 0x00, ##         00   0       
            0x01, 0xD8, 0x00, ##         000 00       
            0x01, 0xD8, 0x00, ##         000 00       
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 28, 
        'xoffset'  => 1, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFE, 0x07, 0x03, 0xF0, ##  0000000      000      000000
            0x38, 0x07, 0x00, 0xC0, ##    000        000        00  
            0x38, 0x07, 0x00, 0xC0, ##    000        000        00  
            0x18, 0x0F, 0x00, 0x80, ##     00       0000        0   
            0x1C, 0x0B, 0x81, 0x80, ##     000      0 000      00   
            0x1C, 0x0B, 0x81, 0x80, ##     000      0 000      00   
            0x1C, 0x19, 0x81, 0x00, ##     000     00  00      0    
            0x0C, 0x19, 0x81, 0x00, ##      00     00  00      0    
            0x0E, 0x11, 0xC3, 0x00, ##      000    0   000    00    
            0x0E, 0x11, 0xC3, 0x00, ##      000    0   000    00    
            0x0E, 0x30, 0xC2, 0x00, ##      000   00    00    0     
            0x06, 0x30, 0xE2, 0x00, ##       00   00    000   0     
            0x07, 0x20, 0xE6, 0x00, ##       000  0     000  00     
            0x07, 0x20, 0xE6, 0x00, ##       000  0     000  00     
            0x07, 0x60, 0x64, 0x00, ##       000 00      00  0      
            0x03, 0x60, 0x74, 0x00, ##        00 00      000 0      
            0x03, 0xC0, 0x7C, 0x00, ##        0000       00000      
            0x03, 0xC0, 0x7C, 0x00, ##        0000       00000      
            0x03, 0xC0, 0x38, 0x00, ##        0000        000       
            0x01, 0xC0, 0x38, 0x00, ##         000        000       
            0x01, 0x80, 0x38, 0x00, ##         00         000       
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 19, 
        'xoffset'  => 1, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0x0F, 0xC0, ##  00000000    000000 
            0x1C, 0x03, 0x00, ##     000        00   
            0x1E, 0x06, 0x00, ##     0000      00    
            0x0E, 0x04, 0x00, ##      000      0     
            0x0F, 0x0C, 0x00, ##      0000    00     
            0x07, 0x18, 0x00, ##       000   00      
            0x03, 0x90, 0x00, ##        000  0       
            0x03, 0xB0, 0x00, ##        000 00       
            0x01, 0xE0, 0x00, ##         0000        
            0x01, 0xE0, 0x00, ##         0000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xF0, 0x00, ##          0000       
            0x01, 0xF0, 0x00, ##         00000       
            0x03, 0xB8, 0x00, ##        000 000      
            0x03, 0x3C, 0x00, ##        00  0000     
            0x06, 0x1C, 0x00, ##       00    000     
            0x06, 0x0E, 0x00, ##       00     000    
            0x0C, 0x0E, 0x00, ##      00      000    
            0x18, 0x07, 0x00, ##     00        000   
            0x18, 0x07, 0x80, ##     00        0000  
            0xFE, 0x1F, 0xE0, ##  0000000    00000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 18, 
        'xoffset'  => 0, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFE, 0x0F, 0xC0, ##  0000000     000000
            0x38, 0x03, 0x00, ##    000         00  
            0x1C, 0x03, 0x00, ##     000        00  
            0x1C, 0x06, 0x00, ##     000       00   
            0x0E, 0x06, 0x00, ##      000      00   
            0x0E, 0x0C, 0x00, ##      000     00    
            0x07, 0x0C, 0x00, ##       000    00    
            0x07, 0x98, 0x00, ##       0000  00     
            0x03, 0x98, 0x00, ##        000  00     
            0x01, 0xF0, 0x00, ##         00000      
            0x01, 0xF0, 0x00, ##         00000      
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x07, 0xF8, 0x00, ##       00000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFE, ##  000000000000000 
            0xC0, 0x1E, ##  00         0000 
            0xC0, 0x1C, ##  00         000  
            0xC0, 0x3C, ##  00        0000  
            0x00, 0x78, ##           0000   
            0x00, 0x70, ##           000    
            0x00, 0xF0, ##          0000    
            0x00, 0xE0, ##          000     
            0x01, 0xE0, ##         0000     
            0x03, 0xC0, ##        0000      
            0x03, 0x80, ##        000       
            0x07, 0x80, ##       0000       
            0x0F, 0x00, ##      0000        
            0x0F, 0x00, ##      0000        
            0x1E, 0x00, ##     0000         
            0x1C, 0x00, ##     000          
            0x3C, 0x00, ##    0000          
            0x78, 0x03, ##   0000         00
            0x70, 0x03, ##   000          00
            0xF0, 0x03, ##  0000          00
            0xFF, 0xFF, ##  0000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00       
            0xE0, 0x00, ##  000      
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x1C, 0x00, ##     000   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0E, 0x00, ##      000  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x03, 0x00, ##        00 
            0x03, 0x00, ##        00 
            0x03, 0x00, ##        00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xC0, 0x00, ##         000       
            0x03, 0xE0, 0x00, ##        00000      
            0x07, 0xF0, 0x00, ##       0000000     
            0x0F, 0x70, 0x00, ##      0000 000     
            0x1C, 0x38, 0x00, ##     000    000    
            0x38, 0x0C, 0x00, ##    000       00   
            0x70, 0x06, 0x00, ##   000         00  
            0xE0, 0x03, 0x00, ##  000           00 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00   
            0x30, ##    00  
            0x38, ##    000 
            0x18, ##     00 
            0x0C, ##      00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x80, ##    0000000     
            0x71, 0xC0, ##   000   000    
            0x60, 0xE0, ##   00     000   
            0x60, 0x70, ##   00      000  
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x1F, 0xF0, ##     000000000  
            0x70, 0x70, ##   000     000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0xF0, ##  000     0000  
            0x70, 0xF0, ##   000    0000  
            0x3F, 0x7C, ##    000000 00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0x00, ##  00000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x39, 0xF0, ##    000  00000   
            0x3A, 0x38, ##    000 0   000  
            0x3C, 0x1C, ##    0000     000 
            0x38, 0x1C, ##    000      000 
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x1C, ##    000      000 
            0x3C, 0x1C, ##    0000     000 
            0x3E, 0x38, ##    00000   000  
            0xF9, 0xF0, ##  00000  00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000  
            0x38, 0x70, ##    000    000
            0x70, 0x30, ##   000      00
            0x70, 0x30, ##   000      00
            0xE0, 0x10, ##  000        0
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x10, ##  000        0
            0x70, 0x30, ##   000      00
            0x70, 0x30, ##   000      00
            0x38, 0x60, ##    000    00 
            0x0F, 0x80, ##      00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xF8, ##          00000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x1F, 0x38, ##     00000  000  
            0x38, 0xB8, ##    000   0 000  
            0x70, 0x78, ##   000     0000  
            0x70, 0x38, ##   000      000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0x70, 0x38, ##   000      000  
            0x70, 0x78, ##   000     0000  
            0x38, 0xF8, ##    000   00000  
            0x1F, 0x3E, ##     00000  00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000    
            0x38, 0xE0, ##    000   000  
            0x70, 0x70, ##   000     000 
            0x60, 0x30, ##   00       00 
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xFF, 0xF8, ##  0000000000000
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x18, ##  000        00
            0x70, 0x30, ##   000      00 
            0x70, 0x30, ##   000      00 
            0x38, 0x60, ##    000    00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xE0, ##      0000000
            0x1C, 0x60, ##     000   00
            0x38, 0x20, ##    000     0
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0xFF, 0x80, ##  000000000  
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0xFF, 0x00, ##  00000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x3E, ##     00000  00000
            0x38, 0xF8, ##    000   00000  
            0x70, 0x78, ##   000     0000  
            0x70, 0x38, ##   000      000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0x70, 0x38, ##   000      000  
            0x70, 0x78, ##   000     0000  
            0x38, 0xB8, ##    000   0 000  
            0x1F, 0x38, ##     00000  000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x60, 0x30, ##   00       00   
            0x60, 0x70, ##   00      000   
            0x70, 0xE0, ##   000    000    
            0x3F, 0x80, ##    0000000      
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0x00, ##  00000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x39, 0xF0, ##    000  00000    
            0x3B, 0xF8, ##    000 0000000   
            0x3E, 0x38, ##    00000   000   
            0x3C, 0x1C, ##    0000     000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0xFE, 0x7F, ##  0000000  0000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0xF8, ##  00000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 8, 
        'xoffset'  => -2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x1F, ##     00000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x87, ##  0    000
            0x87, ##  0    000
            0xCE, ##  00  000 
            0xFC, ##  000000  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0x00, ##  00000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x7E, ##    000    000000 
            0x38, 0x30, ##    000     00    
            0x38, 0x60, ##    000    00     
            0x38, 0x60, ##    000    00     
            0x38, 0xC0, ##    000   00      
            0x39, 0x80, ##    000  00       
            0x3B, 0x80, ##    000 000       
            0x3F, 0xC0, ##    00000000      
            0x3C, 0xE0, ##    0000  000     
            0x38, 0xE0, ##    000   000     
            0x38, 0x70, ##    000    000    
            0x38, 0x70, ##    000    000    
            0x38, 0x38, ##    000     000   
            0x38, 0x1C, ##    000      000  
            0xFE, 0x7F, ##  0000000  0000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0x38, ##    000  
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF9, 0xE1, 0xE0, ##  00000  0000    0000    
            0xFB, 0xF3, 0xF0, ##  00000 000000  000000   
            0x3C, 0x7C, 0x70, ##    0000   00000   000   
            0x3C, 0x3C, 0x38, ##    0000    0000    000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0x38, 0x38, 0x38, ##    000     000     000  
            0xFE, 0xFE, 0xFE, ##  0000000 0000000 0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF9, 0xF0, ##  00000  00000    
            0xFB, 0xF8, ##  00000 0000000   
            0x3E, 0x38, ##    00000   000   
            0x3C, 0x1C, ##    0000     000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0xFE, 0x7F, ##  0000000  0000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000    
            0x38, 0x60, ##    000    00   
            0x70, 0x30, ##   000      00  
            0x70, 0x38, ##   000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x38, ##   000      000 
            0x30, 0x30, ##    00      00  
            0x38, 0x70, ##    000    000  
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF9, 0xF0, ##  00000  00000   
            0x3E, 0x38, ##    00000   000  
            0x3C, 0x1C, ##    0000     000 
            0x38, 0x1C, ##    000      000 
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x1C, ##    000      000 
            0x3C, 0x1C, ##    0000     000 
            0x3A, 0x38, ##    000 0   000  
            0x39, 0xF0, ##    000  00000   
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0xFE, 0x00, ##  0000000        
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x3E, ##     00000  00000
            0x38, 0xF8, ##    000   00000  
            0x70, 0x78, ##   000     0000  
            0x70, 0x38, ##   000      000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x38, ##  000       000  
            0x70, 0x38, ##   000      000  
            0x70, 0x78, ##   000     0000  
            0x38, 0xB8, ##    000   0 000  
            0x1F, 0x38, ##     00000  000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0xFE, ##          0000000
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF9, 0xF0, ##  00000  00000
            0xFB, 0xF0, ##  00000 000000
            0x3E, 0x30, ##    00000   00
            0x3C, 0x10, ##    0000     0
            0x38, 0x00, ##    000       
            0x38, 0x00, ##    000       
            0x38, 0x00, ##    000       
            0x38, 0x00, ##    000       
            0x38, 0x00, ##    000       
            0x38, 0x00, ##    000       
            0x38, 0x00, ##    000       
            0x38, 0x00, ##    000       
            0x38, 0x00, ##    000       
            0x38, 0x00, ##    000       
            0xFE, 0x00, ##  0000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x80, ##    0000000  
            0x70, 0xC0, ##   000    00 
            0xE0, 0x40, ##  000      0 
            0xE0, 0x40, ##  000      0 
            0xE0, 0x00, ##  000        
            0xF8, 0x00, ##  00000      
            0x7F, 0x00, ##   0000000   
            0x3F, 0xC0, ##    00000000 
            0x0F, 0xC0, ##      000000 
            0x01, 0xE0, ##         0000
            0x00, 0xE0, ##          000
            0x80, 0xE0, ##  0       000
            0x80, 0xE0, ##  0       000
            0xC1, 0xC0, ##  00     000 
            0x7F, 0x00, ##   0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0xFF, 0x80, ##  000000000
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x70, 0x00, ##   000     
            0x71, 0x80, ##   000   00
            0x71, 0x80, ##   000   00
            0x33, 0x80, ##    00  000
            0x1E, 0x00, ##     0000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0xF8, ##  00000   00000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x78, ##    000    0000  
            0x1C, 0xB8, ##     000  0 000  
            0x0F, 0x3E, ##      0000  00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 15, 
        'xoffset'  => 0, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x3E, ##  000000    00000
            0x30, 0x08, ##    00        0  
            0x30, 0x18, ##    00       00  
            0x38, 0x18, ##    000      00  
            0x18, 0x10, ##     00      0   
            0x1C, 0x30, ##     000    00   
            0x1C, 0x20, ##     000    0    
            0x0C, 0x20, ##      00    0    
            0x0E, 0x60, ##      000  00    
            0x0E, 0x40, ##      000  0     
            0x06, 0xC0, ##       00 00     
            0x07, 0xC0, ##       00000     
            0x07, 0x80, ##       0000      
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 22, 
        'xoffset'  => 1, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x30, 0x7C, ##  000000    00     00000
            0x30, 0x38, 0x10, ##    00      000      0  
            0x30, 0x38, 0x10, ##    00      000      0  
            0x38, 0x78, 0x30, ##    000    0000     00  
            0x38, 0x5C, 0x20, ##    000    0 000    0   
            0x18, 0x5C, 0x20, ##     00    0 000    0   
            0x18, 0xCC, 0x60, ##     00   00  00   00   
            0x1C, 0xCE, 0x60, ##     000  00  000  00   
            0x0C, 0x8E, 0x40, ##      00  0   000  0    
            0x0C, 0x86, 0xC0, ##      00  0    00 00    
            0x0F, 0x87, 0xC0, ##      00000    00000    
            0x0F, 0x07, 0x80, ##      0000     0000     
            0x07, 0x03, 0x80, ##       000      000     
            0x07, 0x03, 0x80, ##       000      000     
            0x06, 0x03, 0x80, ##       00       000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x7C, ##  000000   00000
            0x30, 0x30, ##    00      00  
            0x38, 0x20, ##    000     0   
            0x1C, 0x60, ##     000   00   
            0x0E, 0xC0, ##      000 00    
            0x0F, 0xC0, ##      000000    
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x05, 0xC0, ##       0 000    
            0x0C, 0xE0, ##      00  000   
            0x18, 0xE0, ##     00   000   
            0x10, 0x70, ##     0     000  
            0x30, 0x38, ##    00      000 
            0xF8, 0xFC, ##  00000   000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 15, 
        'xoffset'  => 0, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x3E, ##  000000    00000
            0x30, 0x08, ##    00        0  
            0x30, 0x18, ##    00       00  
            0x38, 0x18, ##    000      00  
            0x18, 0x10, ##     00      0   
            0x1C, 0x30, ##     000    00   
            0x0C, 0x20, ##      00    0    
            0x0C, 0x60, ##      00   00    
            0x0E, 0x60, ##      000  00    
            0x06, 0x40, ##       00  0     
            0x06, 0xC0, ##       00 00     
            0x07, 0xC0, ##       00000     
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x03, 0x00, ##        00       
            0x01, 0x00, ##         0       
            0x03, 0x00, ##        00       
            0x02, 0x00, ##        0        
            0x46, 0x00, ##   0   00        
            0x44, 0x00, ##   0   0         
            0x78, 0x00, ##   0000          
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
            0x80, 0xE0, ##  0       000 
            0x80, 0xE0, ##  0       000 
            0x81, 0xC0, ##  0      000  
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x1C, 0x00, ##     000      
            0x1C, 0x00, ##     000      
            0x38, 0x00, ##    000       
            0x70, 0x10, ##   000       0
            0x70, 0x10, ##   000       0
            0xE0, 0x10, ##  000        0
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 11, 
        'xoffset'  => 3, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xE0, ##        00000
            0x07, 0x00, ##       000   
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x1C, 0x00, ##     000     
            0xE0, 0x00, ##  000        
            0x1C, 0x00, ##     000     
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x07, 0x00, ##       000   
            0x03, 0xE0, ##        00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 11, 
        'xoffset'  => 3, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0x00, ##  00000      
            0x1C, 0x00, ##     000     
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x07, 0x00, ##       000   
            0x01, 0xE0, ##         0000
            0x07, 0x00, ##       000   
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x1C, 0x00, ##     000     
            0xF8, 0x00, ##  00000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x3E, 0x00, 0x80, ##    00000         0
            0x7F, 0xC1, 0x80, ##   000000000     00
            0xC1, 0xFF, 0x00, ##  00     000000000 
            0x80, 0x3C, 0x00, ##  0         0000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 3, 
        'xoffset'  => 4, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x02, 0x00, ##        0     
            0x02, 0x00, ##        0     
            0x02, 0x00, ##        0     
            0x02, 0x00, ##        0     
            0x0F, 0xC0, ##      000000  
            0x3F, 0xF0, ##    0000000000
            0x72, 0x70, ##   000  0  000
            0x72, 0x30, ##   000  0   00
            0xE2, 0x30, ##  000   0   00
            0xE2, 0x00, ##  000   0     
            0xE2, 0x00, ##  000   0     
            0xE2, 0x00, ##  000   0     
            0xE2, 0x00, ##  000   0     
            0xE2, 0x00, ##  000   0     
            0xE2, 0x30, ##  000   0   00
            0x62, 0x30, ##   00   0   00
            0x72, 0x70, ##   000  0  000
            0x3A, 0xE0, ##    000 0 000 
            0x1F, 0xC0, ##     0000000  
            0x02, 0x00, ##        0     
            0x02, 0x00, ##        0     
            0x02, 0x00, ##        0     
            0x02, 0x00, ##        0     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xF8, ##       00000000
            0x0C, 0x38, ##      00    000
            0x1C, 0x18, ##     000     00
            0x38, 0x18, ##    000      00
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0xFF, 0xE0, ##  00000000000  
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0x38, 0x18, ##    000      00
            0x38, 0x18, ##    000      00
            0x38, 0x18, ##    000      00
            0x38, 0x18, ##    000      00
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x40, 0x04, ##   0           0 
            0x60, 0x0E, ##   00         000
            0x77, 0xDC, ##   000 00000 000 
            0x3F, 0xF8, ##    00000000000  
            0x1C, 0x70, ##     000   000   
            0x38, 0x38, ##    000     000  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x38, 0x38, ##    000     000  
            0x1C, 0x70, ##     000   000   
            0x3F, 0xF8, ##    00000000000  
            0x77, 0xDC, ##   000 00000 000 
            0xE0, 0x0C, ##  000         00 
            0x40, 0x00, ##   0             
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 18, 
        'xoffset'  => 0, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFE, 0x0F, 0xC0, ##  0000000     000000
            0x38, 0x02, 0x00, ##    000         0   
            0x3C, 0x06, 0x00, ##    0000       00   
            0x1C, 0x04, 0x00, ##     000       0    
            0x1E, 0x0C, 0x00, ##     0000     00    
            0x0E, 0x08, 0x00, ##      000     0     
            0x0F, 0x18, 0x00, ##      0000   00     
            0x07, 0x18, 0x00, ##       000   00     
            0x07, 0xB0, 0x00, ##       0000 00      
            0x3F, 0xBE, 0x00, ##    0000000 00000   
            0x03, 0xE0, 0x00, ##        00000       
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x3F, 0xFE, 0x00, ##    0000000000000   
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x07, 0xF8, 0x00, ##       00000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xC0, ##     0000000 
            0x30, 0xC0, ##    00    00 
            0x60, 0x40, ##   00      0 
            0x60, 0x00, ##   00        
            0x60, 0x00, ##   00        
            0x70, 0x00, ##   000       
            0x3C, 0x00, ##    0000     
            0x3E, 0x00, ##    00000    
            0x67, 0x80, ##   00  0000  
            0xC1, 0xC0, ##  00     000 
            0xC0, 0xE0, ##  00      000
            0xC0, 0x60, ##  00       00
            0xE0, 0x60, ##  000      00
            0x78, 0x60, ##   0000    00
            0x3C, 0xC0, ##    0000  00 
            0x0F, 0x80, ##      00000  
            0x03, 0x80, ##        000  
            0x01, 0xC0, ##         000 
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x40, 0xC0, ##   0      00 
            0x61, 0x80, ##   00    00  
            0x7F, 0x00, ##   0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 8, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE7, ##  000  000
            0xE7, ##  000  000
            0xE7, ##  000  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, ##        000000       
            0x0E, 0x0C, 0x00, ##      000     00     
            0x18, 0x03, 0x00, ##     00         00   
            0x30, 0x01, 0x80, ##    00           00  
            0x21, 0xF8, 0x80, ##    0    000000   0  
            0x43, 0x0C, 0x40, ##   0    00    00   0 
            0x47, 0x04, 0x40, ##   0   000     0   0 
            0x8E, 0x04, 0x20, ##  0   000      0    0
            0x8E, 0x00, 0x20, ##  0   000           0
            0x8E, 0x00, 0x20, ##  0   000           0
            0x8E, 0x00, 0x20, ##  0   000           0
            0x8E, 0x00, 0x20, ##  0   000           0
            0x8E, 0x04, 0x20, ##  0   000      0    0
            0x47, 0x0C, 0x40, ##   0   000    00   0 
            0x43, 0x08, 0x40, ##   0    00    0    0 
            0x21, 0xF0, 0x80, ##    0    00000    0  
            0x30, 0x01, 0x80, ##    00           00  
            0x18, 0x03, 0x00, ##     00         00   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x01, 0xF0, 0x00, ##         00000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000   
            0x63, 0x00, ##   00   00  
            0x41, 0x80, ##   0     00 
            0x01, 0x80, ##         00 
            0x3F, 0x80, ##    0000000 
            0xE1, 0x80, ##  000    00 
            0xC1, 0x80, ##  00     00 
            0xC1, 0x80, ##  00     00 
            0xE3, 0x80, ##  000   000 
            0x7D, 0xC0, ##   00000 000
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x7F, 0xC0, ##   000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##              
            0x04, 0x10, ##       0     0
            0x0C, 0x30, ##      00    00
            0x18, 0x60, ##     00    00 
            0x31, 0xC0, ##    00   000  
            0x63, 0x80, ##   00   000   
            0xC7, 0x00, ##  00   000    
            0xE3, 0x80, ##  000   000   
            0x71, 0x80, ##   000   00   
            0x30, 0xC0, ##    00    00  
            0x18, 0x60, ##     00    00 
            0x0C, 0x30, ##      00    00
            0x04, 0x10, ##       0     0
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x01, 0x80, ##                 00
            0x00, 0x01, 0x80, ##                 00
            0x00, 0x01, 0x80, ##                 00
            0x00, 0x01, 0x80, ##                 00
            0x00, 0x01, 0x80, ##                 00
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, ##        000000       
            0x0E, 0x0C, 0x00, ##      000     00     
            0x18, 0x03, 0x00, ##     00         00   
            0x30, 0x01, 0x80, ##    00           00  
            0x27, 0xF8, 0x80, ##    0  00000000   0  
            0x43, 0x1C, 0x40, ##   0    00   000   0 
            0x43, 0x0C, 0x40, ##   0    00    00   0 
            0x83, 0x0C, 0x20, ##  0     00    00    0
            0x83, 0x1C, 0x20, ##  0     00   000    0
            0x83, 0xE0, 0x20, ##  0     00000       0
            0x83, 0x18, 0x20, ##  0     00   00     0
            0x83, 0x18, 0x20, ##  0     00   00     0
            0x83, 0x0C, 0x20, ##  0     00    00    0
            0x43, 0x0C, 0x40, ##   0    00    00   0 
            0x47, 0x86, 0x40, ##   0   0000    00  0 
            0x20, 0x00, 0x80, ##    0             0  
            0x30, 0x01, 0x80, ##    00           00  
            0x18, 0x03, 0x00, ##     00         00   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x01, 0xF0, 0x00, ##         00000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 8, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 8, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x7E, ##   000000 
            0xE7, ##  000  000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xE7, ##  000  000
            0x7E, ##   000000 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x01, 0x80, 0x00, ##         00        
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000  
            0xC6, ##  00   00 
            0x83, ##  0     00
            0x03, ##        00
            0x03, ##        00
            0x06, ##       00 
            0x0C, ##      00  
            0x18, ##     00   
            0x30, ##    00    
            0x61, ##   00    0
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7E, ##   000000 
            0xC3, ##  00    00
            0x03, ##        00
            0x06, ##       00 
            0x18, ##     00   
            0x06, ##       00 
            0x03, ##        00
            0x03, ##        00
            0x83, ##  0     00
            0xC7, ##  00   000
            0x7C, ##   00000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 6, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x1C, ##     000
            0x18, ##     00 
            0x30, ##    00  
            0x60, ##   00   
            0x40, ##   0    
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0x7C, ##  00000    00000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x3C, ##    000     0000  
            0x3C, 0x5C, ##    0000   0 000  
            0x3F, 0x9F, ##    0000000  00000
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0xFE, 0x00, ##  0000000         
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xFC, ##     00000000000
            0x3E, 0x10, ##    00000    0  
            0x7E, 0x10, ##   000000    0  
            0xFE, 0x10, ##  0000000    0  
            0xFE, 0x10, ##  0000000    0  
            0xFE, 0x10, ##  0000000    0  
            0xFE, 0x10, ##  0000000    0  
            0xFE, 0x10, ##  0000000    0  
            0x7E, 0x10, ##   000000    0  
            0x3E, 0x10, ##    00000    0  
            0x1E, 0x10, ##     0000    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x02, 0x10, ##        0    0  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 3, 
        'xoffset'  => 2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 5, 
        'xoffset'  => 4, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0x30, ##    00 
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0xF0, ##  0000 
            0x00, ##  
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x30, ##    00  
            0xF0, ##  0000  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x61, 0x80, ##   00    00 
            0x40, 0x80, ##   0      0 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x40, 0x80, ##   0      0 
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x7F, 0xC0, ##   000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 12, 
        'xoffset'  => 3, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x04, 0x00, ##       0      
            0x86, 0x00, ##  0    00     
            0xC3, 0x00, ##  00    00    
            0x61, 0x80, ##   00    00   
            0x30, 0xC0, ##    00    00  
            0x18, 0x60, ##     00    00 
            0x0C, 0x70, ##      00   000
            0x1C, 0x70, ##     000   000
            0x38, 0xE0, ##    000   000 
            0x31, 0xC0, ##    00   000  
            0x63, 0x00, ##   00   00    
            0xC6, 0x00, ##  00   00     
            0x84, 0x00, ##  0    0      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 23, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x10, 0x00, 0xC0, ##     0            00     
            0x70, 0x01, 0x80, ##   000           00      
            0xB0, 0x01, 0x80, ##  0 00           00      
            0x30, 0x03, 0x00, ##    00          00       
            0x30, 0x03, 0x00, ##    00          00       
            0x30, 0x06, 0x00, ##    00         00        
            0x30, 0x0C, 0x00, ##    00        00         
            0x30, 0x0C, 0x00, ##    00        00         
            0x30, 0x18, 0x00, ##    00       00          
            0x30, 0x18, 0x18, ##    00       00      00  
            0x30, 0x30, 0x38, ##    00      00      000  
            0xFC, 0x60, 0x38, ##  000000   00       000  
            0x00, 0x60, 0x58, ##           00      0 00  
            0x00, 0xC0, 0xD8, ##          00      00 00  
            0x00, 0x80, 0x98, ##          0       0  00  
            0x01, 0x81, 0x18, ##         00      0   00  
            0x03, 0x02, 0x18, ##        00      0    00  
            0x03, 0x03, 0xFE, ##        00      000000000
            0x06, 0x00, 0x18, ##       00            00  
            0x04, 0x00, 0x18, ##       0             00  
            0x0C, 0x00, 0x7E, ##      00           000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x10, 0x00, 0xC0, ##     0            00    
            0x70, 0x01, 0x80, ##   000           00     
            0xB0, 0x01, 0x80, ##  0 00           00     
            0x30, 0x03, 0x00, ##    00          00      
            0x30, 0x06, 0x00, ##    00         00       
            0x30, 0x06, 0x00, ##    00         00       
            0x30, 0x0C, 0x00, ##    00        00        
            0x30, 0x0C, 0x00, ##    00        00        
            0x30, 0x18, 0x00, ##    00       00         
            0x30, 0x31, 0xF0, ##    00      00   00000  
            0x30, 0x33, 0x18, ##    00      00  00   00 
            0xFC, 0x62, 0x0C, ##  000000   00   0     00
            0x00, 0x62, 0x0C, ##           00   0     00
            0x00, 0xC0, 0x0C, ##          00          00
            0x00, 0x80, 0x18, ##          0          00 
            0x01, 0x80, 0x10, ##         00          0  
            0x03, 0x00, 0x30, ##        00          00  
            0x03, 0x00, 0x60, ##        00         00   
            0x06, 0x00, 0x80, ##       00         0     
            0x04, 0x01, 0x04, ##       0         0     0
            0x0C, 0x03, 0xFC, ##      00        00000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7E, 0x00, 0x60, ##   000000          00     
            0xC7, 0x00, 0xC0, ##  00   000        00      
            0x83, 0x00, 0xC0, ##  0     00        00      
            0x03, 0x01, 0x80, ##        00       00       
            0x06, 0x03, 0x00, ##       00       00        
            0x18, 0x03, 0x00, ##     00         00        
            0x06, 0x06, 0x00, ##       00      00         
            0x03, 0x06, 0x00, ##        00     00         
            0x03, 0x0C, 0x00, ##        00    00          
            0x83, 0x0C, 0x0C, ##  0     00    00      00  
            0xC7, 0x18, 0x1C, ##  00   000   00      000  
            0x7C, 0x30, 0x1C, ##   00000    00       000  
            0x00, 0x30, 0x2C, ##            00      0 00  
            0x00, 0x60, 0x4C, ##           00      0  00  
            0x00, 0x60, 0x4C, ##           00      0  00  
            0x00, 0xC0, 0x8C, ##          00      0   00  
            0x00, 0x81, 0x0C, ##          0      0    00  
            0x01, 0x81, 0xFF, ##         00      000000000
            0x01, 0x00, 0x0C, ##         0            00  
            0x03, 0x00, 0x0C, ##        00            00  
            0x06, 0x00, 0x3F, ##       00           000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x00, ##       000    
            0x07, 0x00, ##       000    
            0x07, 0x00, ##       000    
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x03, 0x00, ##        00    
            0x03, 0x00, ##        00    
            0x03, 0x00, ##        00    
            0x03, 0x00, ##        00    
            0x1F, 0x00, ##     00000    
            0x38, 0x00, ##    000       
            0x70, 0x00, ##   000        
            0xF0, 0x00, ##  0000        
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x30, ##  000       00
            0x70, 0x70, ##   000     000
            0x38, 0xF0, ##    000   0000
            0x1F, 0xC0, ##     0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x01, 0xC0, 0x00, ##         000          
            0x00, 0xC0, 0x00, ##          00          
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x00, 0x00, ##                      
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x70, 0x00, ##           000        
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0x98, 0x00, ##         00  00       
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x0E, 0x00, ##        00    000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x07, 0x00, ##       00      000    
            0x0C, 0x07, 0x00, ##      00       000    
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x30, 0x01, 0xC0, ##    00           000  
            0x30, 0x01, 0xC0, ##    00           000  
            0xFC, 0x07, 0xF0, ##  000000       0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x18, 0x00, ##             00       
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x40, 0x00, ##           0          
            0x00, 0x00, 0x00, ##                      
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x70, 0x00, ##           000        
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0x98, 0x00, ##         00  00       
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x0E, 0x00, ##        00    000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x07, 0x00, ##       00      000    
            0x0C, 0x07, 0x00, ##      00       000    
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x30, 0x01, 0xC0, ##    00           000  
            0x30, 0x01, 0xC0, ##    00           000  
            0xFC, 0x07, 0xF0, ##  000000       0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x70, 0x00, ##           000        
            0x00, 0xF8, 0x00, ##          00000       
            0x01, 0x88, 0x00, ##         00   0       
            0x03, 0x04, 0x00, ##        00     0      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x70, 0x00, ##           000        
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0x98, 0x00, ##         00  00       
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x0E, 0x00, ##        00    000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x07, 0x00, ##       00      000    
            0x0C, 0x07, 0x00, ##      00       000    
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x30, 0x01, 0xC0, ##    00           000  
            0x30, 0x01, 0xC0, ##    00           000  
            0xFC, 0x07, 0xF0, ##  000000       0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x01, 0xC4, 0x00, ##         000   0      
            0x03, 0x64, 0x00, ##        00 00  0      
            0x02, 0x38, 0x00, ##        0   000       
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x70, 0x00, ##           000        
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0x98, 0x00, ##         00  00       
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x0C, 0x00, ##        00    00      
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x06, 0x00, ##       00      00     
            0x0C, 0x07, 0x00, ##      00       000    
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x18, 0x07, 0x00, ##     00        000    
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x30, 0x03, 0x80, ##    00          000   
            0x30, 0x01, 0xC0, ##    00           000  
            0xFC, 0x07, 0xF0, ##  000000       0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x03, 0x9C, 0x00, ##        000  000      
            0x03, 0x9C, 0x00, ##        000  000      
            0x03, 0x9C, 0x00, ##        000  000      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x60, 0x00, ##           00         
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0x38, 0x00, ##         0  000       
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x1C, 0x00, ##        00   000      
            0x02, 0x1C, 0x00, ##        0    000      
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x0C, 0x0E, 0x00, ##      00      000     
            0x0C, 0x07, 0x00, ##      00       000    
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x18, 0x03, 0x00, ##     00         00    
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x30, 0x01, 0xC0, ##    00           000  
            0x30, 0x01, 0xC0, ##    00           000  
            0xFC, 0x07, 0xF0, ##  000000       0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0x98, 0x00, ##         00  00       
            0x03, 0x0C, 0x00, ##        00    00      
            0x03, 0x0C, 0x00, ##        00    00      
            0x03, 0x9C, 0x00, ##        000  000      
            0x01, 0xF8, 0x00, ##         000000       
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0xB8, 0x00, ##         00 000       
            0x01, 0x38, 0x00, ##         0  000       
            0x03, 0x1C, 0x00, ##        00   000      
            0x03, 0x1C, 0x00, ##        00   000      
            0x06, 0x1E, 0x00, ##       00    0000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x06, 0x0E, 0x00, ##       00     000     
            0x0C, 0x0F, 0x00, ##      00      0000    
            0x0C, 0x07, 0x00, ##      00       000    
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x03, 0x80, ##     00         000   
            0x18, 0x01, 0x80, ##     00          00   
            0x30, 0x01, 0xC0, ##    00           000  
            0x30, 0x01, 0xC0, ##    00           000  
            0xFC, 0x07, 0xF0, ##  000000       0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 26, 
        'xoffset'  => 0, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x01, 0xFF, 0xFF, 0xC0, ##         0000000000000000000
            0x00, 0x6E, 0x00, 0xC0, ##           00 000         00
            0x00, 0x4E, 0x00, 0xC0, ##           0  000         00
            0x00, 0xCE, 0x00, 0xC0, ##          00  000         00
            0x00, 0xCE, 0x00, 0x00, ##          00  000           
            0x00, 0x8E, 0x00, 0x00, ##          0   000           
            0x01, 0x8E, 0x06, 0x00, ##         00   000      00   
            0x01, 0x8E, 0x06, 0x00, ##         00   000      00   
            0x03, 0x0E, 0x06, 0x00, ##        00    000      00   
            0x03, 0x0F, 0xFE, 0x00, ##        00    00000000000   
            0x03, 0x0E, 0x06, 0x00, ##        00    000      00   
            0x06, 0x0E, 0x06, 0x00, ##       00     000      00   
            0x06, 0x0E, 0x06, 0x00, ##       00     000      00   
            0x0E, 0x0E, 0x00, 0x00, ##      000     000           
            0x0F, 0xFE, 0x00, 0x00, ##      00000000000           
            0x0C, 0x0E, 0x00, 0x00, ##      00      000           
            0x18, 0x0E, 0x00, 0x00, ##     00       000           
            0x18, 0x0E, 0x00, 0xC0, ##     00       000         00
            0x30, 0x0E, 0x00, 0xC0, ##    00        000         00
            0x30, 0x0E, 0x00, 0xC0, ##    00        000         00
            0xFC, 0x3F, 0xFF, 0xC0, ##  000000    0000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 18, 
        'xoffset'  => 2, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFC, 0x00, ##        00000000    
            0x0E, 0x0F, 0x80, ##      000     00000 
            0x18, 0x03, 0x80, ##     00         000 
            0x38, 0x03, 0x80, ##    000         000 
            0x70, 0x01, 0x80, ##   000           00 
            0x70, 0x01, 0x80, ##   000           00 
            0x60, 0x00, 0x00, ##   00               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0xE0, 0x00, 0x00, ##  000               
            0x60, 0x00, 0x00, ##   00               
            0x70, 0x01, 0xC0, ##   000           000
            0x70, 0x01, 0x80, ##   000           00 
            0x38, 0x03, 0x80, ##    000         000 
            0x18, 0x07, 0x00, ##     00        000  
            0x0E, 0x0E, 0x00, ##      000     000   
            0x03, 0xF8, 0x00, ##        0000000     
            0x00, 0x60, 0x00, ##           00       
            0x00, 0x20, 0x00, ##            0       
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x30, 0x00, ##            00      
            0x01, 0xE0, 0x00, ##         0000       
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x03, 0x00, 0x00, ##        00         
            0x01, 0x80, 0x00, ##         00        
            0x00, 0xC0, 0x00, ##          00       
            0x00, 0x40, 0x00, ##           0       
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1F, 0xFC, 0x00, ##     00000000000   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x70, 0x00, ##           000     
            0x00, 0x60, 0x00, ##           00      
            0x00, 0xC0, 0x00, ##          00       
            0x00, 0x80, 0x00, ##          0        
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1F, 0xFC, 0x00, ##     00000000000   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x03, 0x30, 0x00, ##        00  00     
            0x06, 0x18, 0x00, ##       00    00    
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1F, 0xFC, 0x00, ##     00000000000   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x07, 0x38, 0x00, ##       000  000    
            0x07, 0x38, 0x00, ##       000  000    
            0x07, 0x38, 0x00, ##       000  000    
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1F, 0xFC, 0x00, ##     00000000000   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x0C, 0x00, ##     000      00   
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x00, 0x00, ##     000           
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0x1C, 0x01, 0x80, ##     000         00
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x60, ##   00     
            0x30, ##    00    
            0x10, ##     0    
            0x18, ##     00   
            0x00, ##          
            0xFF, ##  00000000
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x0E, ##      000 
            0x1C, ##     000  
            0x18, ##     00   
            0x30, ##    00    
            0x00, ##          
            0xFF, ##  00000000
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '206' => {    # 'Î'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x38, ##    000   
            0x6C, ##   00 00  
            0xC6, ##  00   00 
            0x81, ##  0      0
            0x00, ##          
            0xFF, ##  00000000
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '207' => {    # 'Ï'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0xE7, ##  000  000
            0xE7, ##  000  000
            0xE7, ##  000  000
            0x00, ##          
            0x00, ##          
            0xFF, ##  00000000
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '208' => {    # 'Ð'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xF0, 0x00, ##  000000000000       
            0x38, 0x1C, 0x00, ##    000      000     
            0x38, 0x07, 0x00, ##    000        000   
            0x38, 0x03, 0x80, ##    000         000  
            0x38, 0x01, 0x80, ##    000          00  
            0x38, 0x01, 0xC0, ##    000          000 
            0x38, 0x01, 0xC0, ##    000          000 
            0x38, 0x00, 0xE0, ##    000           000
            0x38, 0x00, 0xE0, ##    000           000
            0x38, 0x00, 0xE0, ##    000           000
            0xFF, 0xC0, 0xE0, ##  0000000000      000
            0x38, 0x00, 0xE0, ##    000           000
            0x38, 0x00, 0xE0, ##    000           000
            0x38, 0x00, 0xE0, ##    000           000
            0x38, 0x01, 0xC0, ##    000          000 
            0x38, 0x01, 0xC0, ##    000          000 
            0x38, 0x01, 0x80, ##    000          00  
            0x38, 0x03, 0x80, ##    000         000  
            0x38, 0x07, 0x00, ##    000        000   
            0x38, 0x1C, 0x00, ##    000      000     
            0xFF, 0xF0, 0x00, ##  000000000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '209' => {    # 'Ñ'
        'width'    => 21, 
        'xoffset'  => 1, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x01, 0xE2, 0x00, ##         0000   0      
            0x03, 0x3C, 0x00, ##        00  0000       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0xF8, 0x03, 0xF8, ##  00000         0000000
            0x3C, 0x00, 0x60, ##    0000           00  
            0x3E, 0x00, 0x60, ##    00000          00  
            0x3E, 0x00, 0x60, ##    00000          00  
            0x37, 0x00, 0x60, ##    00 000         00  
            0x33, 0x80, 0x60, ##    00  000        00  
            0x33, 0xC0, 0x60, ##    00  0000       00  
            0x31, 0xC0, 0x60, ##    00   000       00  
            0x30, 0xE0, 0x60, ##    00    000      00  
            0x30, 0x70, 0x60, ##    00     000     00  
            0x30, 0x70, 0x60, ##    00     000     00  
            0x30, 0x38, 0x60, ##    00      000    00  
            0x30, 0x1C, 0x60, ##    00       000   00  
            0x30, 0x1E, 0x60, ##    00       0000  00  
            0x30, 0x0E, 0x60, ##    00        000  00  
            0x30, 0x07, 0x60, ##    00         000 00  
            0x30, 0x03, 0xE0, ##    00          00000  
            0x30, 0x03, 0xE0, ##    00          00000  
            0x30, 0x01, 0xE0, ##    00           0000  
            0x30, 0x00, 0xE0, ##    00            000  
            0xFE, 0x00, 0x60, ##  0000000          00  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '210' => {    # 'Ò'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x03, 0x80, 0x00, ##        000          
            0x01, 0x80, 0x00, ##         00          
            0x00, 0xC0, 0x00, ##          00         
            0x00, 0x60, 0x00, ##           00        
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x03, 0xF8, 0x00, ##        0000000      
            0x0E, 0x0E, 0x00, ##      000     000    
            0x18, 0x03, 0x00, ##     00         00   
            0x38, 0x03, 0x80, ##    000         000  
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x60, 0x00, 0xC0, ##   00             00 
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0x60, 0x00, 0xC0, ##   00             00 
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x38, 0x03, 0x80, ##    000         000  
            0x18, 0x03, 0x00, ##     00         00   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x03, 0xF8, 0x00, ##        0000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '211' => {    # 'Ó'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x38, 0x00, ##            000      
            0x00, 0x30, 0x00, ##            00       
            0x00, 0x60, 0x00, ##           00        
            0x00, 0xC0, 0x00, ##          00         
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x03, 0xF8, 0x00, ##        0000000      
            0x0E, 0x0E, 0x00, ##      000     000    
            0x18, 0x03, 0x00, ##     00         00   
            0x38, 0x03, 0x80, ##    000         000  
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x60, 0x00, 0xC0, ##   00             00 
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0x60, 0x00, 0xC0, ##   00             00 
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x38, 0x03, 0x80, ##    000         000  
            0x18, 0x03, 0x00, ##     00         00   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x03, 0xF8, 0x00, ##        0000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '212' => {    # 'Ô'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0xE0, 0x00, ##          000        
            0x01, 0xF0, 0x00, ##         00000       
            0x01, 0xB0, 0x00, ##         00 00       
            0x02, 0x08, 0x00, ##        0     0      
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x03, 0xF8, 0x00, ##        0000000      
            0x0E, 0x0E, 0x00, ##      000     000    
            0x18, 0x03, 0x00, ##     00         00   
            0x38, 0x03, 0x80, ##    000         000  
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x60, 0x00, 0xC0, ##   00             00 
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0x60, 0x00, 0xC0, ##   00             00 
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x38, 0x03, 0x80, ##    000         000  
            0x18, 0x03, 0x00, ##     00         00   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x03, 0xF8, 0x00, ##        0000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '213' => {    # 'Õ'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x03, 0xC4, 0x00, ##        0000   0     
            0x06, 0x78, 0x00, ##       00  0000      
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x03, 0xF8, 0x00, ##        0000000      
            0x0E, 0x0E, 0x00, ##      000     000    
            0x18, 0x03, 0x00, ##     00         00   
            0x38, 0x03, 0x80, ##    000         000  
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x60, 0x00, 0xC0, ##   00             00 
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0x60, 0x00, 0xC0, ##   00             00 
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x38, 0x03, 0x80, ##    000         000  
            0x18, 0x03, 0x00, ##     00         00   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x03, 0xF8, 0x00, ##        0000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '214' => {    # 'Ö'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x07, 0x1C, 0x00, ##       000   000     
            0x07, 0x1C, 0x00, ##       000   000     
            0x07, 0x1C, 0x00, ##       000   000     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x03, 0xF8, 0x00, ##        0000000      
            0x0E, 0x0E, 0x00, ##      000     000    
            0x18, 0x03, 0x00, ##     00         00   
            0x38, 0x03, 0x80, ##    000         000  
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x60, 0x00, 0xC0, ##   00             00 
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0x60, 0x00, 0xC0, ##   00             00 
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0x01, 0xC0, ##   000           000 
            0x38, 0x03, 0x80, ##    000         000  
            0x18, 0x03, 0x00, ##     00         00   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x03, 0xF8, 0x00, ##        0000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '215' => {    # '×'
        'width'    => 15, 
        'xoffset'  => 4, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x04, ##               0 
            0xC0, 0x0E, ##  00          000
            0xE0, 0x1C, ##  000        000 
            0x70, 0x38, ##   000      000  
            0x38, 0x70, ##    000    000   
            0x1C, 0xE0, ##     000  000    
            0x0F, 0xC0, ##      000000     
            0x07, 0x80, ##       0000      
            0x07, 0x80, ##       0000      
            0x07, 0xC0, ##       00000     
            0x0E, 0xE0, ##      000 000    
            0x1C, 0x70, ##     000   000   
            0x38, 0x38, ##    000     000  
            0x70, 0x1C, ##   000       000 
            0xE0, 0x0E, ##  000         000
            0x40, 0x04, ##   0           0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '216' => {    # 'Ø'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF8, 0x60, ##        0000000    00
            0x0E, 0x0E, 0xC0, ##      000     000 00 
            0x18, 0x03, 0x80, ##     00         000  
            0x38, 0x03, 0x80, ##    000         000  
            0x30, 0x03, 0xC0, ##    00          0000 
            0x70, 0x07, 0xC0, ##   000         00000 
            0x60, 0x0C, 0xC0, ##   00         00  00 
            0xE0, 0x18, 0xE0, ##  000        00   000
            0xE0, 0x30, 0xE0, ##  000       00    000
            0xE0, 0x60, 0xE0, ##  000      00     000
            0xE0, 0x40, 0xE0, ##  000      0      000
            0xE0, 0xC0, 0xE0, ##  000     00      000
            0xE1, 0x80, 0xE0, ##  000    00       000
            0xE3, 0x00, 0xE0, ##  000   00        000
            0xE6, 0x00, 0xC0, ##  000  00         00 
            0x7C, 0x01, 0xC0, ##   00000         000 
            0x78, 0x01, 0xC0, ##   0000          000 
            0x38, 0x03, 0x80, ##    000         000  
            0x38, 0x03, 0x00, ##    000         00   
            0x6E, 0x0E, 0x00, ##   00 000     000    
            0xC3, 0xF8, 0x00, ##  00    0000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '217' => {    # 'Ù'
        'width'    => 20, 
        'xoffset'  => 1, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x01, 0xC0, 0x00, ##         000          
            0x00, 0xC0, 0x00, ##          00          
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x20, 0x00, ##            0         
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFF, 0x07, 0xF0, ##  00000000     0000000
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x1C, 0x01, 0x80, ##     000         00   
            0x1C, 0x01, 0x80, ##     000         00   
            0x1F, 0x07, 0x80, ##     00000     0000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x03, 0xFC, 0x00, ##        00000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '218' => {    # 'Ú'
        'width'    => 20, 
        'xoffset'  => 1, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x1C, 0x00, ##             000      
            0x00, 0x18, 0x00, ##             00       
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFF, 0x07, 0xF0, ##  00000000     0000000
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x1C, 0x01, 0x80, ##     000         00   
            0x1C, 0x01, 0x80, ##     000         00   
            0x1F, 0x07, 0x80, ##     00000     0000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x03, 0xFC, 0x00, ##        00000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '219' => {    # 'Û'
        'width'    => 20, 
        'xoffset'  => 1, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x70, 0x00, ##           000        
            0x00, 0xD8, 0x00, ##          00 00       
            0x01, 0x8C, 0x00, ##         00   00      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFF, 0x07, 0xF0, ##  00000000     0000000
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x1C, 0x01, 0x80, ##     000         00   
            0x1C, 0x01, 0x80, ##     000         00   
            0x1F, 0x07, 0x80, ##     00000     0000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x03, 0xFC, 0x00, ##        00000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '220' => {    # 'Ü'
        'width'    => 20, 
        'xoffset'  => 1, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x01, 0xCE, 0x00, ##         000  000     
            0x01, 0xCE, 0x00, ##         000  000     
            0x01, 0xCE, 0x00, ##         000  000     
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFF, 0x07, 0xF0, ##  00000000     0000000
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x38, 0x00, 0xC0, ##    000           00  
            0x1C, 0x01, 0x80, ##     000         00   
            0x1C, 0x01, 0x80, ##     000         00   
            0x1F, 0x07, 0x80, ##     00000     0000   
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x03, 0xFC, 0x00, ##        00000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '221' => {    # 'Ý'
        'width'    => 18, 
        'xoffset'  => 0, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x30, 0x00, ##            00      
            0x00, 0x60, 0x00, ##           00       
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0x80, 0x00, ##          0         
            0x00, 0x00, 0x00, ##                    
            0xFE, 0x0F, 0xC0, ##  0000000     000000
            0x38, 0x03, 0x00, ##    000         00  
            0x1C, 0x03, 0x00, ##     000        00  
            0x1C, 0x06, 0x00, ##     000       00   
            0x0E, 0x06, 0x00, ##      000      00   
            0x0E, 0x0C, 0x00, ##      000     00    
            0x07, 0x0C, 0x00, ##       000    00    
            0x07, 0x98, 0x00, ##       0000  00     
            0x03, 0x98, 0x00, ##        000  00     
            0x01, 0xF0, 0x00, ##         00000      
            0x01, 0xF0, 0x00, ##         00000      
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x00, 0xE0, 0x00, ##          000       
            0x07, 0xF8, 0x00, ##       00000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '222' => {    # 'Þ'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000        
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x3F, 0xF0, ##    0000000000    
            0x38, 0x1C, ##    000      000  
            0x38, 0x0E, ##    000       000 
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x0E, ##    000       000 
            0x38, 0x1C, ##    000      000  
            0x3F, 0xF0, ##    0000000000    
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0xFF, 0x00, ##  00000000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '223' => {    # 'ß'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1C, 0x38, ##     000    000   
            0x18, 0x18, ##     00      00   
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x7C, ##    000    00000  
            0x38, 0xC0, ##    000   00      
            0x39, 0x80, ##    000  00       
            0x39, 0x80, ##    000  00       
            0x39, 0x80, ##    000  00       
            0x39, 0xE0, ##    000  0000     
            0x38, 0xF0, ##    000   0000    
            0x38, 0x7C, ##    000    00000  
            0x38, 0x1E, ##    000      0000 
            0x38, 0x0F, ##    000       0000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x38, 0x07, ##    000        000
            0x3A, 0x06, ##    000 0      00 
            0x3B, 0x0E, ##    000 00    000 
            0xF9, 0xF8, ##  00000  000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '224' => {    # 'à'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x38, 0x00, ##    000         
            0x18, 0x00, ##     00         
            0x0C, 0x00, ##      00        
            0x04, 0x00, ##       0        
            0x06, 0x00, ##       00       
            0x02, 0x00, ##        0       
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x3F, 0x80, ##    0000000     
            0x71, 0xC0, ##   000   000    
            0x60, 0xE0, ##   00     000   
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x1F, 0xF0, ##     000000000  
            0x70, 0x70, ##   000     000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0xF0, ##  000     0000  
            0x70, 0xF0, ##   000    0000  
            0x3F, 0x7C, ##    000000 00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '225' => {    # 'á'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x01, 0xC0, ##         000    
            0x01, 0x80, ##         00     
            0x03, 0x00, ##        00      
            0x02, 0x00, ##        0       
            0x06, 0x00, ##       00       
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x3F, 0x80, ##    0000000     
            0x71, 0xC0, ##   000   000    
            0x60, 0xE0, ##   00     000   
            0x60, 0x70, ##   00      000  
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x1F, 0xF0, ##     000000000  
            0x70, 0x70, ##   000     000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0xF0, ##  000     0000  
            0x70, 0xF0, ##   000    0000  
            0x3F, 0x7C, ##    000000 00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '226' => {    # 'â'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00       
            0x0F, 0x00, ##      0000      
            0x09, 0x80, ##      0  00     
            0x19, 0x80, ##     00  00     
            0x30, 0xC0, ##    00    00    
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x3F, 0x80, ##    0000000     
            0x71, 0xC0, ##   000   000    
            0x60, 0xE0, ##   00     000   
            0x60, 0x70, ##   00      000  
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x1F, 0xF0, ##     000000000  
            0x70, 0x70, ##   000     000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0xF0, ##  000     0000  
            0x70, 0xF0, ##   000    0000  
            0x3F, 0x7C, ##    000000 00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '227' => {    # 'ã'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1C, 0x40, ##     000   0    
            0x26, 0x40, ##    0  00  0    
            0x23, 0xC0, ##    0   0000    
            0x23, 0x80, ##    0   000     
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x3F, 0x80, ##    0000000     
            0x71, 0xC0, ##   000   000    
            0x60, 0xE0, ##   00     000   
            0x60, 0x70, ##   00      000  
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x1F, 0xF0, ##     000000000  
            0x70, 0x70, ##   000     000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0xF0, ##  000     0000  
            0x70, 0xF0, ##   000    0000  
            0x3F, 0x7C, ##    000000 00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '228' => {    # 'ä'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x39, 0xC0, ##    000  000    
            0x39, 0xC0, ##    000  000    
            0x39, 0xC0, ##    000  000    
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x3F, 0x80, ##    0000000     
            0x71, 0xC0, ##   000   000    
            0x60, 0xE0, ##   00     000   
            0x60, 0x70, ##   00      000  
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x1F, 0xF0, ##     000000000  
            0x70, 0x70, ##   000     000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0xF0, ##  000     0000  
            0x70, 0xF0, ##   000    0000  
            0x3F, 0x7C, ##    000000 00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '229' => {    # 'å'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x00, ##      0000      
            0x19, 0x80, ##     00  00     
            0x30, 0xC0, ##    00    00    
            0x30, 0xC0, ##    00    00    
            0x30, 0xC0, ##    00    00    
            0x19, 0x80, ##     00  00     
            0x0F, 0x00, ##      0000      
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x3F, 0x80, ##    0000000     
            0x61, 0xC0, ##   00    000    
            0x40, 0xE0, ##   0      000   
            0x40, 0x70, ##   0       000  
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x1F, 0xF0, ##     000000000  
            0x70, 0x70, ##   000     000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0x70, ##  000      000  
            0xE0, 0xF0, ##  000     0000  
            0x70, 0xF0, ##   000    0000  
            0x3F, 0x7C, ##    000000 00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '230' => {    # 'æ'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x3F, 0x87, 0xE0, ##    0000000    000000    
            0x71, 0xDC, 0x38, ##   000   000 000    000  
            0x60, 0xF8, 0x1C, ##   00     00000      000 
            0x60, 0x78, 0x0C, ##   00      0000       00 
            0x00, 0x70, 0x0E, ##           000        000
            0x00, 0x70, 0x0E, ##           000        000
            0x1F, 0xFF, 0xFE, ##     00000000000000000000
            0x70, 0x70, 0x00, ##   000     000           
            0xE0, 0x70, 0x00, ##  000      000           
            0xE0, 0x70, 0x00, ##  000      000           
            0xE0, 0x70, 0x06, ##  000      000         00
            0xE0, 0x78, 0x0C, ##  000      0000       00 
            0xE0, 0xF8, 0x0C, ##  000     00000       00 
            0x70, 0xCC, 0x18, ##   000    00  00     00  
            0x1F, 0x03, 0xE0, ##     00000      00000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '231' => {    # 'ç'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000  
            0x38, 0x70, ##    000    000
            0x70, 0x30, ##   000      00
            0x70, 0x30, ##   000      00
            0xE0, 0x30, ##  000       00
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x00, ##  000         
            0xE0, 0x30, ##  000       00
            0x70, 0x30, ##   000      00
            0x70, 0x30, ##   000      00
            0x38, 0x60, ##    000    00 
            0x0F, 0x80, ##      00000   
            0x03, 0x00, ##        00    
            0x01, 0x00, ##         0    
            0x01, 0x80, ##         00   
            0x01, 0x80, ##         00   
            0x01, 0x80, ##         00   
            0x0F, 0x00, ##      0000    
        ], 
    }, 
    '232' => {    # 'è'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x18, 0x00, ##     00        
            0x1C, 0x00, ##     000       
            0x0C, 0x00, ##      00       
            0x06, 0x00, ##       00      
            0x02, 0x00, ##        0      
            0x03, 0x00, ##        00     
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0F, 0x80, ##      00000    
            0x38, 0xE0, ##    000   000  
            0x70, 0x70, ##   000     000 
            0x60, 0x30, ##   00       00 
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xFF, 0xF8, ##  0000000000000
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x18, ##  000        00
            0x70, 0x30, ##   000      00 
            0x70, 0x30, ##   000      00 
            0x38, 0x60, ##    000    00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '233' => {    # 'é'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xC0, ##          00   
            0x01, 0x80, ##         00    
            0x01, 0x80, ##         00    
            0x03, 0x00, ##        00     
            0x06, 0x00, ##       00      
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0F, 0x80, ##      00000    
            0x38, 0xE0, ##    000   000  
            0x70, 0x70, ##   000     000 
            0x60, 0x30, ##   00       00 
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xFF, 0xF8, ##  0000000000000
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x18, ##  000        00
            0x70, 0x30, ##   000      00 
            0x70, 0x30, ##   000      00 
            0x38, 0x60, ##    000    00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '234' => {    # 'ê'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x0D, 0x80, ##      00 00    
            0x18, 0xC0, ##     00   00   
            0x10, 0x40, ##     0     0   
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0F, 0x80, ##      00000    
            0x38, 0xE0, ##    000   000  
            0x70, 0x70, ##   000     000 
            0x60, 0x30, ##   00       00 
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xFF, 0xF8, ##  0000000000000
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x18, ##  000        00
            0x70, 0x30, ##   000      00 
            0x70, 0x30, ##   000      00 
            0x38, 0x60, ##    000    00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '235' => {    # 'ë'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1C, 0xE0, ##     000  000  
            0x1C, 0xE0, ##     000  000  
            0x1C, 0xE0, ##     000  000  
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0F, 0x80, ##      00000    
            0x38, 0xE0, ##    000   000  
            0x70, 0x70, ##   000     000 
            0x60, 0x30, ##   00       00 
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xFF, 0xF8, ##  0000000000000
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x18, ##  000        00
            0x70, 0x10, ##   000       0 
            0x70, 0x30, ##   000      00 
            0x38, 0x60, ##    000    00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '236' => {    # 'ì'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00      
            0x60, ##   00     
            0x30, ##    00    
            0x38, ##    000   
            0x18, ##     00   
            0x0C, ##      00  
            0x00, ##          
            0x00, ##          
            0x7C, ##   00000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x7F, ##   0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '237' => {    # 'í'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x07, ##       000
            0x06, ##       00 
            0x0C, ##      00  
            0x18, ##     00   
            0x30, ##    00    
            0x20, ##    0     
            0x00, ##          
            0x00, ##          
            0xF8, ##  00000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0x38, ##    000   
            0xFE, ##  0000000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '238' => {    # 'î'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1C, 0x00, ##     000   
            0x3C, 0x00, ##    0000   
            0x36, 0x00, ##    00 00  
            0x66, 0x00, ##   00  00  
            0x43, 0x00, ##   0    00 
            0xC1, 0x80, ##  00     00
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x7C, 0x00, ##   00000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x1C, 0x00, ##     000   
            0x7F, 0x00, ##   0000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '239' => {    # 'ï'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE7, ##  000  000
            0xE7, ##  000  000
            0xE7, ##  000  000
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x7C, ##   00000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x1C, ##     000  
            0x7F, ##   0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '240' => {    # 'ð'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x30, 0x00, ##    00          
            0x1C, 0x38, ##     000    000 
            0x07, 0xE0, ##       000000   
            0x03, 0x80, ##        000     
            0x0F, 0xC0, ##      000000    
            0x38, 0xE0, ##    000   000   
            0x00, 0x70, ##           000  
            0x0F, 0xF0, ##      00000000  
            0x38, 0x38, ##    000     000 
            0x70, 0x38, ##   000      000 
            0x70, 0x38, ##   000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x60, 0x18, ##   00        00 
            0x70, 0x38, ##   000      000 
            0x30, 0x30, ##    00      00  
            0x18, 0x60, ##     00    00   
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '241' => {    # 'ñ'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x10, ##       000   0    
            0x09, 0xF0, ##      0  00000    
            0x08, 0xE0, ##      0   000     
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0xF9, 0xF0, ##  00000  00000    
            0xFB, 0xF8, ##  00000 0000000   
            0x3E, 0x38, ##    00000   000   
            0x3C, 0x1C, ##    0000     000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0xFE, 0x7F, ##  0000000  0000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '242' => {    # 'ò'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x18, 0x00, ##     00         
            0x0C, 0x00, ##      00        
            0x0E, 0x00, ##      000       
            0x06, 0x00, ##       00       
            0x03, 0x00, ##        00      
            0x01, 0x80, ##         00     
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x0F, 0xC0, ##      000000    
            0x38, 0x60, ##    000    00   
            0x70, 0x30, ##   000      00  
            0x70, 0x38, ##   000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x38, ##   000      000 
            0x30, 0x30, ##    00      00  
            0x38, 0x70, ##    000    000  
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '243' => {    # 'ó'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xE0, ##          000   
            0x00, 0xC0, ##          00    
            0x01, 0x80, ##         00     
            0x03, 0x00, ##        00      
            0x02, 0x00, ##        0       
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x0F, 0xC0, ##      000000    
            0x38, 0x60, ##    000    00   
            0x70, 0x30, ##   000      00  
            0x70, 0x38, ##   000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x38, ##   000      000 
            0x30, 0x30, ##    00      00  
            0x38, 0x70, ##    000    000  
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '244' => {    # 'ô'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00      
            0x07, 0x80, ##       0000     
            0x0C, 0xC0, ##      00  00    
            0x08, 0x40, ##      0    0    
            0x18, 0x60, ##     00    00   
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x0F, 0xC0, ##      000000    
            0x38, 0x60, ##    000    00   
            0x70, 0x30, ##   000      00  
            0x70, 0x38, ##   000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x38, ##   000      000 
            0x30, 0x30, ##    00      00  
            0x38, 0x70, ##    000    000  
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '245' => {    # 'õ'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0E, 0x20, ##      000   0   
            0x13, 0x20, ##     0  00  0   
            0x11, 0xE0, ##     0   0000   
            0x11, 0xC0, ##     0   000    
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x0F, 0xC0, ##      000000    
            0x38, 0x60, ##    000    00   
            0x70, 0x30, ##   000      00  
            0x70, 0x38, ##   000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x38, ##   000      000 
            0x30, 0x30, ##    00      00  
            0x38, 0x70, ##    000    000  
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '246' => {    # 'ö'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1C, 0xE0, ##     000  000   
            0x1C, 0xE0, ##     000  000   
            0x1C, 0xE0, ##     000  000   
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x0F, 0xC0, ##      000000    
            0x38, 0x60, ##    000    00   
            0x70, 0x30, ##   000      00  
            0x70, 0x38, ##   000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x38, ##   000      000 
            0x30, 0x30, ##    00      00  
            0x38, 0x70, ##    000    000  
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '247' => {    # '÷'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '248' => {    # 'ø'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x04, ##               0
            0x0F, 0xCC, ##      000000  00
            0x18, 0x78, ##     00    0000 
            0x30, 0x38, ##    00      000 
            0x70, 0x78, ##   000     0000 
            0xE0, 0xDC, ##  000     00 000
            0xE0, 0x9C, ##  000     0  000
            0xE1, 0x9C, ##  000    00  000
            0xE3, 0x1C, ##  000   00   000
            0xE6, 0x1C, ##  000  00    000
            0xEC, 0x1C, ##  000 00     000
            0xEC, 0x1C, ##  000 00     000
            0x78, 0x38, ##   0000     000 
            0x70, 0x30, ##   000      00  
            0x78, 0x70, ##   0000    000  
            0xCF, 0xC0, ##  00  000000    
            0x80, 0x00, ##  0             
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '249' => {    # 'ù'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1C, 0x00, ##     000         
            0x0C, 0x00, ##      00         
            0x0E, 0x00, ##      000        
            0x06, 0x00, ##       00        
            0x03, 0x00, ##        00       
            0x01, 0x00, ##         0       
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0xF8, 0xF8, ##  00000   00000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x78, ##    000    0000  
            0x1C, 0xB8, ##     000  0 000  
            0x0F, 0x3E, ##      0000  00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '250' => {    # 'ú'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xC0, ##          00     
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x03, 0x00, ##        00       
            0x02, 0x00, ##        0        
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0xF8, 0xF8, ##  00000   00000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x78, ##    000    0000  
            0x1C, 0xB8, ##     000  0 000  
            0x0F, 0x3E, ##      0000  00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '251' => {    # 'û'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00       
            0x07, 0x00, ##       000       
            0x0D, 0x80, ##      00 00      
            0x0C, 0xC0, ##      00  00     
            0x18, 0x40, ##     00    0     
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0xF8, 0xF8, ##  00000   00000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x78, ##    000    0000  
            0x1C, 0xB8, ##     000  0 000  
            0x0F, 0x3E, ##      0000  00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '252' => {    # 'ü'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1C, 0xE0, ##     000  000    
            0x1C, 0xE0, ##     000  000    
            0x1C, 0xE0, ##     000  000    
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0xF8, 0x78, ##  00000    0000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x38, ##    000     000  
            0x38, 0x78, ##    000    0000  
            0x1C, 0xB8, ##     000  0 000  
            0x0F, 0x3E, ##      0000  00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '253' => {    # 'ý'
        'width'    => 15, 
        'xoffset'  => 0, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x70, ##           000   
            0x00, 0xE0, ##          000    
            0x00, 0xC0, ##          00     
            0x01, 0x80, ##         00      
            0x03, 0x00, ##        00       
            0x02, 0x00, ##        0        
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0xFC, 0x3E, ##  000000    00000
            0x30, 0x08, ##    00        0  
            0x30, 0x18, ##    00       00  
            0x38, 0x18, ##    000      00  
            0x18, 0x10, ##     00      0   
            0x1C, 0x30, ##     000    00   
            0x0C, 0x20, ##      00    0    
            0x0C, 0x60, ##      00   00    
            0x0E, 0x60, ##      000  00    
            0x06, 0x40, ##       00  0     
            0x06, 0xC0, ##       00 00     
            0x07, 0xC0, ##       00000     
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x03, 0x00, ##        00       
            0x01, 0x00, ##         0       
            0x03, 0x00, ##        00       
            0x02, 0x00, ##        0        
            0x46, 0x00, ##   0   00        
            0x44, 0x00, ##   0   0         
            0x78, 0x00, ##   0000          
        ], 
    }, 
    '254' => {    # 'þ'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0x00, ##  00000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x39, 0xF0, ##    000  00000   
            0x3E, 0x38, ##    00000   000  
            0x3C, 0x1C, ##    0000     000 
            0x38, 0x1C, ##    000      000 
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x0E, ##    000       000
            0x38, 0x1C, ##    000      000 
            0x3C, 0x1C, ##    0000     000 
            0x3E, 0x38, ##    00000   000  
            0x39, 0xF0, ##    000  00000   
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0xFE, 0x00, ##  0000000        
        ], 
    }, 
    '255' => {    # 'ÿ'
        'width'    => 15, 
        'xoffset'  => 0, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0E, 0x70, ##      000  000   
            0x0E, 0x70, ##      000  000   
            0x0E, 0x70, ##      000  000   
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0xFC, 0x3E, ##  000000    00000
            0x38, 0x08, ##    000       0  
            0x38, 0x08, ##    000       0  
            0x18, 0x18, ##     00      00  
            0x1C, 0x10, ##     000     0   
            0x1C, 0x10, ##     000     0   
            0x0C, 0x30, ##      00    00   
            0x0E, 0x20, ##      000   0    
            0x06, 0x20, ##       00   0    
            0x07, 0x40, ##       000 0     
            0x07, 0x40, ##       000 0     
            0x03, 0xC0, ##        0000     
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x01, 0x80, ##         00      
            0x01, 0x00, ##         0       
            0x01, 0x00, ##         0       
            0x02, 0x00, ##        0        
            0x42, 0x00, ##   0    0        
            0x66, 0x00, ##   00  00        
            0x7C, 0x00, ##   00000         
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '84' => -1, '86' => -2, '87' => -1, '88' => -1, '89' => -3, '221' => -3, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '118' => -1, '119' => -1, '121' => -1, '221' => -1, '253' => -1, '255' => -1, },  # A
    '66' => { '45' => 1, '67' => 1, '71' => 1, '79' => 1, '199' => 1, '210' => 1, '211' => 1, '212' => 1, '213' => 1, '214' => 1, '216' => 1, },  # B
    '67' => { '44' => -1, '46' => -1, },  # C
    '68' => { '44' => -1, '45' => 1, '46' => -1, },  # D
    '69' => { '45' => 1, },  # E
    '70' => { '44' => -4, '45' => -1, '46' => -4, '58' => -1, '59' => -1, '65' => -2, '97' => -2, '101' => -1, '111' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '230' => -2, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '248' => -1, },  # F
    '71' => { '44' => -1, '45' => 1, '46' => -1, },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { '44' => -2, '46' => -2, '58' => -1, '59' => -1, },  # J
    '75' => { '45' => -2, '65' => -1, '67' => -1, '79' => -1, '85' => -1, '87' => -1, '89' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -2, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '216' => -1, '217' => -1, '218' => -1, '219' => -1, '220' => -1, '221' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -2, '255' => -2, },  # K
    '76' => { '84' => -2, '85' => -1, '86' => -3, '87' => -2, '89' => -2, '217' => -1, '218' => -1, '219' => -1, '220' => -1, '221' => -2, },  # L
    '77' => { },  # M
    '78' => { '44' => -2, '46' => -2, '58' => -1, '59' => -1, },  # N
    '79' => { '44' => -2, '45' => 1, '46' => -2, },  # O
    '80' => { '44' => -5, '45' => -1, '46' => -5, '58' => -1, '59' => -1, '65' => -2, '97' => -1, '101' => -1, '111' => -1, '115' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '230' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '248' => -1, },  # P
    '81' => { '44' => -1, '45' => 1, '46' => -1, },  # Q
    '82' => { '86' => -1, '87' => -1, '89' => -1, '97' => 1, '221' => -1, '224' => 1, '225' => 1, '226' => 1, '227' => 1, '228' => 1, '229' => 1, '230' => 1, '248' => 1, },  # R
    '83' => { '44' => -1, '45' => 1, '46' => -1, },  # S
    '84' => { '44' => -4, '45' => -3, '46' => -4, '58' => -1, '59' => -1, '65' => -1, '97' => -2, '99' => -2, '101' => -2, '111' => -2, '115' => -2, '119' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '230' => -2, '231' => -2, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '248' => -2, },  # T
    '85' => { '44' => -2, '46' => -2, '58' => -1, '59' => -1, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # U
    '86' => { '44' => -5, '45' => -2, '46' => -5, '58' => -3, '59' => -3, '65' => -2, '97' => -2, '101' => -2, '111' => -2, '117' => -2, '121' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '230' => -2, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '248' => -2, '249' => -2, '250' => -2, '251' => -2, '252' => -2, '253' => -1, '255' => -1, },  # V
    '87' => { '44' => -5, '45' => -2, '46' => -5, '58' => -2, '59' => -2, '65' => -1, '97' => -2, '101' => -2, '111' => -2, '114' => -1, '117' => -1, '121' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '230' => -2, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '248' => -2, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -1, '255' => -1, },  # W
    '88' => { '45' => -1, '65' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # X
    '89' => { '44' => -3, '45' => -3, '46' => -3, '58' => -3, '59' => -3, '65' => -2, '97' => -2, '101' => -2, '111' => -2, '117' => -2, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '230' => -3, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '248' => -2, '249' => -2, '250' => -2, '251' => -2, '252' => -2, },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { '44' => -1, '45' => -1, '46' => -1, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '44' => -3, '46' => -3, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '44' => -3, '46' => -3, },  # v
    '119' => { '44' => -3, '46' => -3, },  # w
    '120' => { },  # x
    '121' => { '44' => -4, '46' => -4, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '160' => { },  #  
    '161' => { },  # ¡
    '162' => { },  # ¢
    '163' => { },  # £
    '164' => { },  # ¤
    '165' => { },  # ¥
    '166' => { },  # ¦
    '167' => { },  # §
    '168' => { },  # ¨
    '169' => { },  # ©
    '170' => { },  # ª
    '171' => { },  # «
    '172' => { },  # ¬
    '173' => { },  # ­
    '174' => { },  # ®
    '175' => { },  # ¯
    '176' => { },  # °
    '177' => { },  # ±
    '178' => { },  # ²
    '179' => { },  # ³
    '180' => { },  # ´
    '181' => { },  # µ
    '182' => { },  # ¶
    '183' => { },  # ·
    '184' => { },  # ¸
    '185' => { },  # ¹
    '186' => { },  # º
    '187' => { },  # »
    '188' => { },  # ¼
    '189' => { },  # ½
    '190' => { },  # ¾
    '191' => { },  # ¿
    '192' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '118' => -1, '119' => -1, '121' => -1, '221' => -1, '253' => -1, '255' => -1, },  # À
    '193' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '118' => -1, '119' => -1, '121' => -1, '221' => -1, '253' => -1, '255' => -1, },  # Á
    '194' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '118' => -1, '119' => -1, '121' => -1, '221' => -1, '253' => -1, '255' => -1, },  # Â
    '195' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '118' => -1, '119' => -1, '121' => -1, '221' => -1, '253' => -1, '255' => -1, },  # Ã
    '196' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '118' => -1, '119' => -1, '121' => -1, '221' => -1, '253' => -1, '255' => -1, },  # Ä
    '197' => { },  # Å
    '198' => { '45' => 1, },  # Æ
    '199' => { '44' => -1, '46' => -1, },  # Ç
    '200' => { '45' => 1, },  # È
    '201' => { '45' => 1, },  # É
    '202' => { '45' => 1, },  # Ê
    '203' => { '45' => 1, },  # Ë
    '204' => { },  # Ì
    '205' => { },  # Í
    '206' => { },  # Î
    '207' => { },  # Ï
    '208' => { '44' => -1, '45' => 1, '46' => -1, },  # Ð
    '209' => { '44' => -2, '46' => -2, '58' => -1, '59' => -1, },  # Ñ
    '210' => { '44' => -2, '45' => 1, '46' => -2, },  # Ò
    '211' => { '44' => -2, '45' => 1, '46' => -2, },  # Ó
    '212' => { '44' => -2, '45' => 1, '46' => -2, },  # Ô
    '213' => { '44' => -2, '45' => 1, '46' => -2, },  # Õ
    '214' => { '44' => -2, '45' => 1, '46' => -2, },  # Ö
    '215' => { },  # ×
    '216' => { '44' => -2, '45' => 1, '46' => -2, },  # Ø
    '217' => { '44' => -2, '46' => -2, '58' => -1, '59' => -1, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # Ù
    '218' => { '44' => -2, '46' => -2, '58' => -1, '59' => -1, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # Ú
    '219' => { '44' => -2, '46' => -2, '58' => -1, '59' => -1, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # Û
    '220' => { '44' => -2, '46' => -2, '58' => -1, '59' => -1, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # Ü
    '221' => { '44' => -3, '45' => -3, '46' => -3, '58' => -3, '59' => -3, '65' => -2, '97' => -2, '101' => -2, '111' => -2, '117' => -2, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '230' => -3, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '248' => -2, '249' => -2, '250' => -2, '251' => -2, '252' => -2, },  # Ý
    '222' => { '44' => -4, '45' => 1, '46' => -4, },  # Þ
    '223' => { },  # ß
    '224' => { },  # à
    '225' => { },  # á
    '226' => { },  # â
    '227' => { },  # ã
    '228' => { },  # ä
    '229' => { },  # å
    '230' => { },  # æ
    '231' => { },  # ç
    '232' => { },  # è
    '233' => { },  # é
    '234' => { },  # ê
    '235' => { },  # ë
    '236' => { },  # ì
    '237' => { },  # í
    '238' => { },  # î
    '239' => { },  # ï
    '240' => { },  # ð
    '241' => { },  # ñ
    '242' => { },  # ò
    '243' => { },  # ó
    '244' => { },  # ô
    '245' => { },  # õ
    '246' => { },  # ö
    '247' => { },  # ÷
    '248' => { },  # ø
    '249' => { },  # ù
    '250' => { },  # ú
    '251' => { },  # û
    '252' => { },  # ü
    '253' => { '44' => -4, '46' => -4, },  # ý
    '254' => { '46' => -1, },  # þ
    '255' => { '44' => -4, '46' => -4, },  # ÿ
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
