/*
  libnzb

  Copyright (C) 2004 Mattias Nordstrom <matta at ftlight net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


  Authors:
    Mattias Nordstrom <matta at ftlight net>

  $Id: nzb.h,v 1.3 2005/02/27 20:35:53 mnordstr Exp $
    This file provides exported libnzb function headers.

*/

#ifndef NZB_H
#define NZB_H

#include <iostream>
#include <vector>

using namespace std;

#define NZB_OK			0	// Ok
#define NZB_ERROR		1	// General/Unknown error

struct nzb_group {
	string group;
};

struct nzb_segment {
	unsigned long bytes;
	unsigned int number;
	string msgid;
};

struct nzb_file {
	int status;
	string poster;
	unsigned int date;
	string subject;

	unsigned int c_groups;
	unsigned int c_segments;
	
	vector<nzb_group> groups;
	vector<nzb_segment> segments;
};

struct nzb_return {
	unsigned int count;
	vector<nzb_file> files;
};

extern "C" nzb_return parse_nzb(string data);

class NNTP {
	public:
		NNTP();
		~NNTP();
		
		int initialize(string host, int port, string user, string pass);
		int terminate();
		string get_article(string msgid);
		unsigned long get_bytes() { return bytes; }
				
	private:
		int net_send(string data);
		string net_recv();
		
		int sockfd;
		unsigned long bytes;
};

#define YRES_OK			0	// Ok
#define YRES_ERRSIZE		1	// Part size mismatch
#define YRES_ERRTOTSIZE		2	// Total filesize mismatch
#define YRES_ERRPCRC32		3	// Part CRC32 error
#define YRES_ERROR		4	// General/Unknown error
#define YRES_ERRPART		5	// Part number mismatch

struct ydata {
	int status;
	string filename;
	unsigned int part;
	unsigned long size;
	unsigned int total;
	unsigned long total_size;
	string crc32;
	unsigned long block_begin;
	unsigned long block_end;
	string data;
};

extern "C" ydata ydecode(string data);

#define URES_OK			0	// Ok
#define URES_ERROR		1	// General/Unknown error

struct udata {
	int status;
	string filename;
	string data;
};

extern "C" udata nzb_udecode(string data, bool multi = false, int type = 0);

#endif
