//
// File: test_cborpsm.cpp
// Created by: Olivier Langella
// Created on: 8/7/2025
//
/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

// ./tests/pappsotree/catch2-only-pappsotree [cbor2json] -s

#include <catch2/catch_test_macros.hpp>
#include <pappsomspp/core/processing/cbor/psm/psmcbor2json.h>
#include <pappsomspp/core/processing/uimonitor/uimonitorvoid.h>
#include <QDebug>


TEST_CASE("cbor psm map test suite.", "[cbor2json]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));


  SECTION("..:: PSM cbor json output ::..", "[cbor2json]")
  {
    pappso::UiMonitorVoid monitor;

    QFile cbor_file(
      "/gorgone/pappso/moulon/users/Olivier/20250402_RD_mais_deepprot/specoms/"
      "specoms_1_F2_vs_B73.cbor");
    REQUIRE(cbor_file.open(QIODevice::ReadOnly));


    QFile filejson("test.json");
    REQUIRE(filejson.open(QIODevice::WriteOnly));
    pappso::cbor::JsonStreamWriter output_json(&filejson);

    pappso::cbor::psm::PsmCbor2Json cbor2json(&output_json);

    cbor2json.readCbor(&cbor_file, monitor);
    // xic_writer.write(xic);
    filejson.close();
    cbor_file.close();
  }
}
