/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.util;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.table.TableColumn;

public final class GUIUtils {
    public static void invokeAndWait(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    public static void centerOnScreen(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension splashSize = w.getPreferredSize();
        w.setLocation(screenSize.width / 2 - splashSize.width / 2, screenSize.height / 2 - splashSize.height / 2);
    }

    public static void maximizeJFrame(JFrame f) {
        f.setExtendedState(6);
    }

    public static void lockJTableColumnWidth(TableColumn tc, int pixels) {
        if (tc != null) {
            tc.setMinWidth(pixels);
            tc.setMaxWidth(pixels);
            tc.setPreferredWidth(pixels);
            tc.setResizable(false);
        }
    }

    public static void hideJTableColumn(TableColumn tc) {
        GUIUtils.lockJTableColumnWidth(tc, 0);
    }
}

