INCLUDE(CheckIncludeFiles)
OPTION(WITH_PMEM "Enable persistent memory features" OFF)
IF(WITH_PMEM)
  FIND_LIBRARY(LIBPMEM pmem)
  CHECK_INCLUDE_FILES(libpmem.h HAVE_LIBPMEM_H)
  IF (NOT LIBPMEM)
    MESSAGE(FATAL_ERROR "Can't find libpmem")
  ELSEIF(NOT HAVE_LIBPMEM_H)
    MESSAGE(FATAL_ERROR "Can't find libpmem.h")
  ELSE()
    ADD_DEFINITIONS(-DHAVE_PMEM)
  ENDIF()
ENDIF()
