# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class Xdmf3Writer(DataObjectAlgorithm):
    r"""
    Xdmf3Writer - write eXtensible Data Model and Format files
    
    Superclass: DataObjectAlgorithm
    
    Xdmf3Writer converts DataObjects to XDMF format. This is
    intended to replace XdmfWriter, which is not up to date with the
    capabilities of the newer XDMF3 library. This writer understands
    VTK's composite data types and produces full trees in the output XDMF
    files.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXdmf3Writer, obj, update, **traits)
    
    write_all_time_steps = tvtk_base.false_bool_trait(desc=\
        r"""
        Controls whether writer automatically writes all input time
        steps, or just the timestep that is currently on the input.
        Default is OFF.
        """
    )

    def _write_all_time_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteAllTimeSteps,
                        self.write_all_time_steps_)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Set or get the file name of the xdmf file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    ghost_level = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        We never write out ghost cells.  This variable is here to satisfy
        the behavior of para_view on invoking a parallel writer.
        """
    )

    def _ghost_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGhostLevel,
                        self.ghost_level)

    light_data_limit = traits.Int(100, enter_set=True, auto_set=False, desc=\
        r"""
        Topology Geometry and Attribute arrays smaller than this are
        written in line into the XML. Default is 100.
        """
    )

    def _light_data_limit_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLightDataLimit,
                        self.light_data_limit)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def write(self):
        """
        write(self) -> int
        C++: virtual int write()
        Write data to output. Method executes subclasses write_data()
        method, as well as start_method() and end_method() methods. Returns
        1 on success and 0 on failure.
        """
        ret = self._vtk_obj.Write()
        return ret
        

    _updateable_traits_ = \
    (('write_all_time_steps', 'GetWriteAllTimeSteps'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('file_name', 'GetFileName'),
    ('ghost_level', 'GetGhostLevel'), ('light_data_limit',
    'GetLightDataLimit'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'write_all_time_steps', 'file_name',
    'ghost_level', 'light_data_limit', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Xdmf3Writer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Xdmf3Writer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['write_all_time_steps'], [], ['file_name', 'ghost_level',
            'light_data_limit']),
            title='Edit Xdmf3Writer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Xdmf3Writer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

