/*
 *
 * US National Weather Service - NCEP (WMC)
 *
 * Center: 7
 * Subcenter: 0
 * Parameter table version: 141
 */

TBLE2 ncep_141_params[] = {
{1, "Pressure", "Pa", "PRES"},
{2, "Pressure reduced to MSL", "Pa", "PRMSL"},
{3, "Pressure tendency", "Pa/s", "PTEND"},
{4, "Potential vorticity", "km^2/kg/s", "PVORT"},
{5, "ICAO Standard Atmosphere Reference Height", "M", "ICAHT"},
{6, "Geopotential", "m^2/s^2", "GP"},
{7, "Geopotential height", "gpm", "HGT"},
{8, "Geometric height", "m", "DIST"},
{9, "Std dev of height", "m", "HSTDV"},
{10, "Total ozone", "Dobson", "TOZONE"},
{11, "Temperature", "K", "TMP"},
{12, "Virtual temperature", "K", "VTMP"},
{13, "Potential temperature", "K", "POT"},
{14, "Pseudo-adiabatic potential temperature", "K", "EPOT"},
{15, "Maximum temperature", "K", "T_MAX"},
{16, "Minimum temperature", "K", "T_MIN"},
{17, "Dew point temperature", "K", "DPT"},
{18, "Dew point depression", "K", "DEPR"},
{19, "Lapse rate", "K/m", "LAPR"},
{20, "Visibility", "m", "VIS"},
{21, "Radar spectra (1)", "non-dim", "RDSP1"},
{22, "Radar spectra (2)", "non-dim", "RDSP2"},
{23, "Radar spectra (3)", "non-dim", "RDSP3"},
{24, "Parcel lifted index (to 500 hPa)", "K", "PLI"},
{25, "Temperature anomaly", "K", "TMP_A"},
{26, "Pressure anomaly", "Pa", "PRESA"},
{27, "Geopotential height anomaly", "gpm", "GPA"},
{28, "Wave spectra (1)", "non-dim", "WVSP1"},
{29, "Wave spectra (2)", "non-dim", "WVSP2"},
{30, "Wave spectra (3)", "non-dim", "WVSP3"},
{31, "Wind direction", "deg", "WDIR"},
{32, "Wind speed", "m/s", "WIND"},
{33, "u-component of wind", "m/s", "U_GRD"},
{34, "v-component of wind", "m/s", "V_GRD"},
{35, "Stream function", "m^2/s", "STRM"},
{36, "Velocity potential", "m^2/s", "V_POT"},
{37, "Montgomery stream function", "m^2/s^2", "MNTSF"},
{38, "Sigma coord. vertical velocity", "/s", "SGCVV"},
{39, "Pressure vertical velocity", "Pa/s", "V_VEL"},
{40, "Geometric vertical velocity", "m/s", "DZDT"},
{41, "Absolute vorticity", "/s", "ABS_V"},
{42, "Absolute divergence", "/s", "ABS_D"},
{43, "Relative vorticity", "/s", "REL_V"},
{44, "Relative divergence", "/s", "REL_D"},
{45, "Vertical u-component shear", "/s", "VUCSH"},
{46, "Vertical v-component shear", "/s", "VVCSH"},
{47, "Direction of current", "deg", "DIR_C"},
{48, "Speed of current", "m/s", "SP_C"},
{49, "u-component of current", "m/s", "UOGRD"},
{50, "v-component of current", "m/s", "VOGRD"},
{51, "Specific humidity", "kg/kg", "SPF_H"},
{52, "Relative humidity", "%", "R_H"},
{53, "Humidity mixing ratio", "kg/kg", "MIXR"},
{54, "Precipitable water", "kg/m^2", "P_WAT"},
{55, "Vapor pressure", "Pa", "VAPP"},
{56, "Saturation deficit", "Pa", "SAT_D"},
{57, "Evaporation", "kg/m^2", "EVP"},
{58, "Cloud Ice", "kg/m^2", "C_ICE"},
{59, "Precipitation rate", "kg/m^2/s", "PRATE"},
{60, "Thunderstorm probability", "%", "TSTM"},
{61, "Total precipitation", "kg/m^2", "A_PCP"},
{62, "Large scale precipitation", "kg/m^2", "NCPCP"},
{63, "Convective precipitation", "kg/m^2", "ACPCP"},
{64, "Snowfall rate water equivalent", "kg/m^2/s", "SRWEQ"},
{65, "Water equivalent of accumulated snow depth", "kg/m^2", "WEASD"},
{66, "Snow depth", "m", "SNO_D"},
{67, "Mixed layer depth", "m", "MIXHT"},
{68, "Transient thermocline depth", "m", "TTHDP"},
{69, "Main thermocline depth", "m", "MTHD"},
{70, "Main thermocline anomaly", "m", "MTH_A"},
{71, "Total cloud cover", "%", "T_CDC"},
{72, "Convective cloud cover", "%", "CDCON"},
{73, "Low level cloud cover", "%", "L_CDC"},
{74, "Mid level cloud cover", "%", "M_CDC"},
{75, "High level cloud cover", "%", "H_CDC"},
{76, "Cloud water", "kg/m^2", "C_WAT"},
{77, "Best lifted index (to 500 hPa)", "K", "BLI"},
{78, "Convective snow", "kg/m^2", "SNO_C"},
{79, "Large scale snow", "kg/m^2", "SNO_L"},
{80, "Water temperature", "K", "WTMP"},
{81, "Land-sea mask (land=1;sea=0)", "fraction", "LAND"},
{82, "Deviation of sea level from mean", "m", "DSL_M"},
{83, "Surface roughness", "m", "SFC_R"},
{84, "Albedo", "%", "ALBDO"},
{85, "Soil temperature", "K", "TSOIL"},
{86, "Soil moisture content", "kg/m^2", "SOIL_M"},
{87, "Vegetation", "%", "VEG"},
{88, "Salinity", "kg/kg", "SALTY"},
{89, "Density", "kg/m^3", "DEN"},
{90, "Water runoff", "kg/m^2", "WATR"},
{91, "Ice concentration (ice=1;no ice=0)", "fraction", "ICE_C"},
{92, "Ice thickness", "m", "ICETK"},
{93, "Direction of ice drift", "deg", "DICED"},
{94, "Speed of ice drift", "m/s", "SICED"},
{95, "u-component of ice drift", "m/s", "U_ICE"},
{96, "v-component of ice drift", "m/s", "V_ICE"},
{97, "Ice growth rate", "m/s", "ICE_G"},
{98, "Ice divergence", "/s", "ICE_D"},
{99, "Snow melt", "kg/m^2", "SNO_M"},
{100, "Sig height of wind waves and swell", "m", "HTSGW"},
{101, "Direction of wind waves", "deg", "WVDIR"},
{102, "Significant height of wind waves", "m", "WVHGT"},
{103, "Mean period of wind waves", "s", "WVPER"},
{104, "Direction of swell waves", "deg", "SWDIR"},
{105, "Significant height of swell waves", "m", "SWELL"},
{106, "Mean period of swell waves", "s", "SWPER"},
{107, "Primary wave direction", "deg", "DIRPW"},
{108, "Primary wave mean period", "s", "PERPW"},
{109, "Secondary wave direction", "deg", "DIRSW"},
{110, "Secondary wave mean period", "s", "PERSW"},
{111, "Net short wave radiation (surface)", "W/m^2", "NSWRS"},
{112, "Net long wave radiation(surface)", "W/m^2", "NLWRS"},
{113, "Net short wave radiation (top)", "W/m^2", "NSWRT"},
{114, "Net long wave radiation (top)", "W/m^2", "NLWRT"},
{115, "Long wave radiation", "W/m^2", "LWAVR"},
{116, "Short wave radiation", "W/m^2", "SWAVR"},
{117, "Global radiation", "W/m^2", "G_RAD"},
{118, "Brightness temperature", "K", "BRTMP"},
{119, "Radiance with respect to wave no.", "W/m/sr", "LWRAD"},
{120, "Radiance with respect ot wave len.", "W/m^3/sr", "SWRAD"},
{121, "Latent heat flux", "W/m^2", "LHTFL"},
{122, "Sensible heat flux", "W/m^2", "SHTFL"},
{123, "Boundary layer dissipation", "W/m^2", "BLYDP"},
{124, "Momentum flux, u component", "N/m^2", "U_FLX"},
{125, "Momentum flux, v component", "N/m^2", "V_FLX"},
{126, "Wind mixing energy", "J", "WMIXE"},
{127, "Image data", "none", "IMG_D"},
{128, "Aerosol extinction coefficient", "km-1", "EXTNC"},
{129, "Aerosol optical depth", "non-dim", "AOD"},
{130, "Aerosol asymmetry factor", "non-dim", "ASFTR"},
{131, "Aerosol single scatter albedo", "non-dim", "SSALBD"},
{132, "Aerosol back scattering", "non-dim", "BSCTRS"},
{140, "Total inorganic and organic nitrates", "ppbV", "NOY"},
{141, "Nitrogen oxide", "ppbV", "NO"},
{142, "Nitrogen dioxide", "ppbV", "NO2"},
{143, "Nitrogen pentoxide", "ppbV", "N2O5"},
{144, "Nitric acid", "ppbV", "HNO3"},
{145, "Nitrogen trioxide", "ppbV", "NO3"},
{146, "Peroxynitric acid", "ppbV", "PNA"},
{147, "Nitrous acid", "ppbV", "HONO"},
{148, "Carbon monoxide", "ppbV", "CO"},
{149, "Ammonia", "ppbV", "NH3"},
{150, "Hydrogen chloride", "ppbV", "HCL"},
{159, "Lumped single-bond carbon species", "ppbV", "PAR"},
{160, "Ethene", "ppbV", "ETHE"},
{161, "Lumped double-bond carbon species less ethene", "ppbV", "OLE"},
{162, "Toluene", "ppbV", "TOL"},
{163, "Xylene", "ppbV", "XYL"},
{164, "Isoprene", "ppbV", "ISOP"},
{166, "Formaldehyde", "ppbV", "FORM"},
{167, "Acetaldehyde & higher aldehydes", "ppbV", "ALD2"},
{168, "Methyl glyoxal", "ppbV", "MGLY"},
{169, "Cresol and higher molecular weight phenols", "ppbV", "CRES"},
{172, "Peroxyacyl nitrate", "ppbV", "PAN"},
{173, "Lumped gaseous organic nitrate", "ppbV", "NTR"},
{177, "Esters", "ppbV", "ROOH"},
{178, "Ethanol", "ppbV", "ETHOH"},
{179, "Methanol", "ppbV", "METHOH"},
{186, "Hydrogen peroxide", "ppbV", "H2O2"},
{187, "Hydroxyl radical", "ppbV", "OH"},
{188, "Hydroperoxyl radical", "ppbV", "HO2"},
{200, "Sulfate (SO4) particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "ASO4"},
{201, "Ammonia (NH4) particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "ANH4"},
{202, "Nitrate (NO3) particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "ANO3"},
{203, "Organic particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "AORGA"},
{204, "Primarily organic particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "AORGPA"},
{205, "Biogenically originated particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "AORGB"},
{206, "Elemental carbon particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "AEC"},
{207, "Unspecified anthropogenic particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "A25"},
{208, "Water particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "AH2O"},
{209, "Sodium particulates   <=2.5 m*10-6 diameter", "mcg/m^3", "ANA"},
{210, "Chloride particulates <=2.5 m*10-6 diameter", "mcg/m^3", "ACL"},
{216, "Sulfate (SO4) particulates between 2.5 and 10 m*10-6 diameter", "mcg/m^3", "ASO4K"},
{217, "Sodium (NA) particulates between 2.5 and 10 m*10-6 diameter", "mcg/m^3", "ANAK"},
{218, "Chloride (CL) particulates between 2.5 and 10 m*10-6 diameter", "mcg/m^3", "ACLK"},
{219, "Sea salt originated particulates between 2.5 and 10 m*10-6 diameter", "mcg/m^3", "ASEAS"},
{220, "Crustal material orginated particulates between 2.5 and 10 m*10-6 diameter", "mcg/m^3", "ASOIL"},
{221, "Particulates between 2.5 and 10 m*10-6 diameter", "mcg/m^3", "ACORS"},
{222, "Number concentration particulates between 2.5 and 0.1 m*10-6 diameter", "number/m^3", "NUMATKN"},
{223, "Number concentration particulates between 2.5 and 2.5 m*10-6 diameter", "number/m^3", "NUMACC"},
{224, "Number concentration particulates between 2.5 and 10 m*10-6 diameter", "number/m^3", "NUMCOR"},
{228, "Surface area contributed by particulates   <= 0.1 m*10-6 diameter", "m^2/m^3", "SRFATKN"},
{229, "Surface area contributed by particulates between 0.1 and 2.5 m*10-6 diameter", "m^2/m^3", "SRFACC"},
{232, "Sulfur dioxide", "ppbV", "SO2"},
{233, "Methanesulfonic acid", "Kg/Kg", "MSA"},
{234, "Total sulfate particulates (fine ands coarse)", "mcg/m^3", "TSO4"},
{235, "Dimethylsulfide", "Kg/Kg", "DMS"},
{240, "Dust particulates between 0.2 - 2.0 m*10-6 diameter", "Kg/Kg", "DU1"},
{241, "Dust particulates between 2.0 - 3.6 m*10-6 diameter", "Kg/Kg", "DU2"},
{242, "Dust particulates between 3.6 - 6.0 m*10-6 diameter", "Kg/Kg", "DU3"},
{243, "Dust particulates between 6.0 - 12.0 m*10-6 diameter", "Kg/Kg", "DU4"},
{244, "Dust particulates between 12.0 - 20.0 m*10-6 diameter", "Kg/Kg", "DU5"},
{245, "Sea salt particulates between 0.2 - 1.0 m*10-6 diameter", "Kg/Kg", "SS1"},
{246, "Sea salt particulates between 1.0 - 3.0 m*10-6 diameter", "Kg/Kg", "SS2"},
{247, "Sea salt particulates between 3.0 - 10.0 m*10-6 diameter", "Kg/Kg", "SS3"},
{248, "Sea salt particulates between 10.0 - 20.0 m*10-6 diameter", "Kg/Kg", "SS4"},
{249, "Hydrophobic organic carbon", "Kg/Kg", "OCDRY"},
{250, "Hydrophilic organic carbon", "Kg/Kg", "OCWET"},
{251, "Hydrophobic black carbon", "Kg/Kg", "BCDRY"},
{252, "Hydrophilic black carbon", "Kg/Kg", "BCWET"}
};
