QUnit.test('Reflect.hasOwnMetadata', assert => {
  const { defineMetadata, hasOwnMetadata } = Reflect;
  const { create } = Object;
  assert.isFunction(hasOwnMetadata);
  assert.arity(hasOwnMetadata, 2);
  assert.name(hasOwnMetadata, 'hasOwnMetadata');
  assert.looksNative(hasOwnMetadata);
  assert.nonEnumerable(Reflect, 'hasOwnMetadata');
  assert.throws(() => hasOwnMetadata('key', undefined, undefined), TypeError);
  assert.false(hasOwnMetadata('key', {}, undefined));
  let object = {};
  defineMetadata('key', 'value', object, undefined);
  assert.true(hasOwnMetadata('key', object, undefined));
  let prototype = {};
  object = create(prototype);
  defineMetadata('key', 'value', prototype, undefined);
  assert.false(hasOwnMetadata('key', object, undefined));
  assert.false(hasOwnMetadata('key', {}, 'name'));
  object = {};
  defineMetadata('key', 'value', object, 'name');
  assert.true(hasOwnMetadata('key', object, 'name'));
  prototype = {};
  object = create(prototype);
  defineMetadata('key', 'value', prototype, 'name');
  assert.false(hasOwnMetadata('key', object, 'name'));
});
