## API Report File for "web-streams-polyfill"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export interface AbortSignal {
    readonly aborted: boolean;
    addEventListener(type: 'abort', listener: () => void): void;
    removeEventListener(type: 'abort', listener: () => void): void;
}

// @public
export class ByteLengthQueuingStrategy implements QueuingStrategy<ArrayBufferView> {
    constructor(options: QueuingStrategyInit);
    get highWaterMark(): number;
    get size(): (chunk: ArrayBufferView) => number;
}

// @public
export class CountQueuingStrategy implements QueuingStrategy<any> {
    constructor(options: QueuingStrategyInit);
    get highWaterMark(): number;
    get size(): (chunk: any) => 1;
}

// @public
export interface QueuingStrategy<T = any> {
    highWaterMark?: number;
    // Warning: (ae-forgotten-export) The symbol "QueuingStrategySizeCallback" needs to be exported by the entry point polyfill.d.ts
    size?: QueuingStrategySizeCallback<T>;
}

// @public (undocumented)
export interface QueuingStrategyInit {
    highWaterMark: number;
}

// @public
export class ReadableByteStreamController {
    get byobRequest(): ReadableStreamBYOBRequest | null;
    close(): void;
    get desiredSize(): number | null;
    enqueue(chunk: ArrayBufferView): void;
    error(e?: any): void;
}

// @public
export class ReadableStream<R = any> {
    [Symbol.asyncIterator]: (options?: ReadableStreamIteratorOptions) => ReadableStreamAsyncIterator<R>;
    constructor(underlyingSource: UnderlyingByteSource, strategy?: {
        highWaterMark?: number;
        size?: undefined;
    });
    constructor(underlyingSource?: UnderlyingSource<R>, strategy?: QueuingStrategy<R>);
    cancel(reason?: any): Promise<void>;
    getReader({ mode }: {
        mode: 'byob';
    }): ReadableStreamBYOBReader;
    getReader(): ReadableStreamDefaultReader<R>;
    get locked(): boolean;
    pipeThrough<RS extends ReadableStream>(transform: {
        readable: RS;
        writable: WritableStream<R>;
    }, options?: StreamPipeOptions): RS;
    pipeTo(destination: WritableStream<R>, options?: StreamPipeOptions): Promise<void>;
    tee(): [ReadableStream<R>, ReadableStream<R>];
    values(options?: ReadableStreamIteratorOptions): ReadableStreamAsyncIterator<R>;
}

// @public
export interface ReadableStreamAsyncIterator<R> extends AsyncIterator<R> {
    // (undocumented)
    next(): Promise<IteratorResult<R, undefined>>;
    // (undocumented)
    return(value?: any): Promise<IteratorResult<any>>;
}

// @public
export class ReadableStreamBYOBReader {
    // Warning: (ae-forgotten-export) The symbol "ReadableByteStream" needs to be exported by the entry point polyfill.d.ts
    constructor(stream: ReadableByteStream);
    cancel(reason?: any): Promise<void>;
    get closed(): Promise<undefined>;
    read<T extends ArrayBufferView>(view: T): Promise<ReadableStreamBYOBReadResult<T>>;
    releaseLock(): void;
}

// @public
export type ReadableStreamBYOBReadResult<T extends ArrayBufferView> = {
    done: false;
    value: T;
} | {
    done: true;
    value: T | undefined;
};

// @public
export class ReadableStreamBYOBRequest {
    respond(bytesWritten: number): void;
    respondWithNewView(view: ArrayBufferView): void;
    get view(): ArrayBufferView | null;
}

// @public
export class ReadableStreamDefaultController<R> {
    close(): void;
    get desiredSize(): number | null;
    enqueue(chunk: R): void;
    error(e?: any): void;
}

// @public
export class ReadableStreamDefaultReader<R = any> {
    constructor(stream: ReadableStream<R>);
    cancel(reason?: any): Promise<void>;
    get closed(): Promise<undefined>;
    read(): Promise<ReadableStreamDefaultReadResult<R>>;
    releaseLock(): void;
}

// @public
export type ReadableStreamDefaultReadResult<T> = {
    done: false;
    value: T;
} | {
    done: true;
    value?: undefined;
};

// @public
export interface ReadableStreamIteratorOptions {
    // (undocumented)
    preventCancel?: boolean;
}

// @public
export interface ReadableWritablePair<R, W> {
    // (undocumented)
    readable: ReadableStream<R>;
    // (undocumented)
    writable: WritableStream<W>;
}

// @public
export interface StreamPipeOptions {
    preventAbort?: boolean;
    preventCancel?: boolean;
    preventClose?: boolean;
    signal?: AbortSignal;
}

// @public
export interface Transformer<I = any, O = any> {
    flush?: TransformerFlushCallback<O>;
    // (undocumented)
    readableType?: undefined;
    start?: TransformerStartCallback<O>;
    transform?: TransformerTransformCallback<I, O>;
    // (undocumented)
    writableType?: undefined;
}

// @public (undocumented)
export type TransformerFlushCallback<O> = (controller: TransformStreamDefaultController<O>) => void | PromiseLike<void>;

// @public (undocumented)
export type TransformerStartCallback<O> = (controller: TransformStreamDefaultController<O>) => void | PromiseLike<void>;

// @public (undocumented)
export type TransformerTransformCallback<I, O> = (chunk: I, controller: TransformStreamDefaultController<O>) => void | PromiseLike<void>;

// @public
export class TransformStream<I = any, O = any> {
    constructor(transformer?: Transformer<I, O>, writableStrategy?: QueuingStrategy<I>, readableStrategy?: QueuingStrategy<O>);
    get readable(): ReadableStream<O>;
    get writable(): WritableStream<I>;
}

// @public
export class TransformStreamDefaultController<O> {
    get desiredSize(): number | null;
    enqueue(chunk: O): void;
    error(reason?: any): void;
    terminate(): void;
}

// @public
export interface UnderlyingByteSource {
    autoAllocateChunkSize?: number;
    cancel?: UnderlyingSourceCancelCallback;
    pull?: UnderlyingByteSourcePullCallback;
    start?: UnderlyingByteSourceStartCallback;
    type: 'bytes';
}

// @public (undocumented)
export type UnderlyingByteSourcePullCallback = (controller: ReadableByteStreamController) => void | PromiseLike<void>;

// @public (undocumented)
export type UnderlyingByteSourceStartCallback = (controller: ReadableByteStreamController) => void | PromiseLike<void>;

// @public
export interface UnderlyingSink<W = any> {
    abort?: UnderlyingSinkAbortCallback;
    close?: UnderlyingSinkCloseCallback;
    start?: UnderlyingSinkStartCallback;
    // (undocumented)
    type?: undefined;
    write?: UnderlyingSinkWriteCallback<W>;
}

// @public (undocumented)
export type UnderlyingSinkAbortCallback = (reason: any) => void | PromiseLike<void>;

// @public (undocumented)
export type UnderlyingSinkCloseCallback = () => void | PromiseLike<void>;

// @public (undocumented)
export type UnderlyingSinkStartCallback = (controller: WritableStreamDefaultController) => void | PromiseLike<void>;

// @public (undocumented)
export type UnderlyingSinkWriteCallback<W> = (chunk: W, controller: WritableStreamDefaultController) => void | PromiseLike<void>;

// @public
export interface UnderlyingSource<R = any> {
    cancel?: UnderlyingSourceCancelCallback;
    pull?: UnderlyingSourcePullCallback<R>;
    start?: UnderlyingSourceStartCallback<R>;
    // (undocumented)
    type?: undefined;
}

// @public (undocumented)
export type UnderlyingSourceCancelCallback = (reason: any) => void | PromiseLike<void>;

// @public (undocumented)
export type UnderlyingSourcePullCallback<R> = (controller: ReadableStreamDefaultController<R>) => void | PromiseLike<void>;

// @public (undocumented)
export type UnderlyingSourceStartCallback<R> = (controller: ReadableStreamDefaultController<R>) => void | PromiseLike<void>;

// @public
export class WritableStream<W = any> {
    constructor(underlyingSink?: UnderlyingSink<W>, strategy?: QueuingStrategy<W>);
    abort(reason?: any): Promise<void>;
    close(): Promise<undefined>;
    getWriter(): WritableStreamDefaultWriter<W>;
    get locked(): boolean;
}

// @public
export class WritableStreamDefaultController<W = any> {
    // @deprecated
    get abortReason(): any;
    error(e?: any): void;
    get signal(): AbortSignal;
}

// @public
export class WritableStreamDefaultWriter<W = any> {
    constructor(stream: WritableStream<W>);
    abort(reason?: any): Promise<void>;
    close(): Promise<void>;
    get closed(): Promise<undefined>;
    get desiredSize(): number | null;
    get ready(): Promise<undefined>;
    releaseLock(): void;
    write(chunk: W): Promise<void>;
}


// (No @packageDocumentation comment for this package)

```
