## Redis Command Support

### Keys Command

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |        DEL        |    Yes     | DEL key [key …]                                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       DUMP        |    Yes     | DUMP key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      EXISTS       |    Yes     | EXISTS key                                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      EXPIRE       |    Yes     | EXPIRE key seconds                                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     EXPIREAT      |    Yes     | EXPIREAT key timestamp                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       KEYS        |    No      | KEYS pattern                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      MIGRATE      |    No      | MIGRATE host port key destination-db timeout                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       MOVE        |    No      | MOVE key db                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      OBJECT       |    No      | OBJECT subcommand [arguments [arguments …]]                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PERSIST      |    Yes     | PERSIST key                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PEXPIRE      |    Yes     | PEXPIRE key milliseconds                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     PEXPIREAT     |    Yes     | PEXPIREAT key milliseconds-timestamp                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PTTL         |    Yes     | PTTL key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     RANDOMKEY     |    No      | RANDOMKEY                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      RENAME       |    No      | RENAME key newkey                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     RENAMENX      |    No      | RENAMENX key newkey                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      RESTORE      |    Yes     | RESTORE key ttl serialized-value                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SORT         |    Yes     | SORT key [BY pattern] [LIMIT offset count] [GET pattern [GET pattern ...]] [ASC|DESC] [ALPHA] [STORE destination]   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       TTL         |    Yes     | TTL key                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      TYPE         |    Yes     | TYPE key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SCAN         |    No      | SCAN cursor [MATCH pattern] [COUNT count]                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Strings Command

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      APPEND       |    Yes     | APPEND key value                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     BITCOUNT      |    Yes     | BITCOUNT key [start end]                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     BITFIELD      |    Yes     | BITFIELD key [GET] [SET] [INCRBY] [WRAP|SAT|FAIL]                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       BITOP       |    No      | BITOP operation destkey key [key …]                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      BITPOS       |    Yes     | BITPOS key bit [start] [end]                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       DECR        |    Yes     | DECR key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      DECRBY       |    Yes     | DECRBY key decrement                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |        GET        |    Yes     | GET key                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      GETBIT       |    Yes     | GETBIT key offset                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      GETDEL       |    Yes     | GETDEL key                                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       GETEX       |    Yes     | GETEX key [EX seconds|PX milliseconds|EXAT timestamp|PXAT milliseconds-timestamp|PERSIST]                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     GETRANGE      |    Yes     | GETRANGE key start end                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      GETSET       |    Yes     | GETSET key value                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       INCR        |    Yes     | INCR key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      INCRBY       |    Yes     | INCRBY key increment                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    INCRBYFLOAT    |    Yes     | INCRBYFLOAT key increment                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       MGET        |    Yes     | MGET key [key …]                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       MSET        |    Yes     | MSET key value [key value …]                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      MSETNX       |    No      | MSETNX key value [key value …]                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PSETEX       |    Yes     | PSETEX key milliseconds value                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |        SET        |    Yes     | SET key value [EX seconds|PX milliseconds|EXAT timestamp|PXAT milliseconds-timestamp|KEEPTTL] [NX|XX] [GET]         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SETBIT       |    Yes     | SETBIT key offset value                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       SETEX       |    Yes     | SETEX key seconds value                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       SETNX       |    Yes     | SETNX key value                                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SETRANGE      |    Yes     | SETRANGE key offset value                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      STRALGO      |    No      | STRALGO LCS algo-specific-argument [algo-specific-argument …]                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      STRLEN       |    Yes     | STRLEN key                                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* MSET support is not Atomic

### Hashes

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       HDEL        |    Yes     | HDEL key field [field ...]                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HEXISTS      |    Yes     | HEXISTS key field                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       HGET        |    Yes     | HGET key field                                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HGETALL      |    Yes     | HGETALL key                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HINCRBY      |    Yes     | HINCRBY key field increment                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    HINCRBYFLOAT   |    Yes     | HINCRBYFLOAT key field increment                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HKEYS        |    Yes     | HKEYS key                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HLEN         |    Yes     | HLEN key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HMGET        |    Yes     | HMGET key field [field ...]                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HMSET        |    Yes     | HMSET key field value [field value ...]                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HSET         |    Yes     | HSET key field value                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HSETNX       |    Yes     | HSETNX key field value                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HVALS        |    Yes     | HVALS key                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HSCAN        |    Yes     | HSCAN key cursor [MATCH pattern] [COUNT count]                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Lists

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      BLMOVE       |    No      | BLMOVE source destination LEFT|RIGHT LEFT|RIGHT timeout                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       BLPOP       |    No      | BLPOP key [key …] timeout                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       BRPOP       |    No      | BRPOP key [key …] timeout                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    BRPOPLPUSH     |    No      | BRPOPLPUSH source destination timeout                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LINDEX       |    Yes     | LINDEX key index                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LINSERT      |    Yes     | LINSERT key BEFORE|AFTER pivot element                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       LLEN        |    Yes     | LLEN key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       LMOVE       |    Yes     | LMOVE source destination LEFT|RIGHT LEFT|RIGHT                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       LPOP        |    Yes     | LPOP key [count]                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       LPOS        |    Yes     | LPOS key element [RANK] [COUNT] [MAXLEN]                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       LPUSH       |    Yes     | LPUSH key element [element …]                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LPUSHX       |    Yes     | LPUSHX key element [element …]                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LRANGE       |    Yes     | LRANGE key start stop                                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       LREM        |    Yes     | LREM key count element                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       LSET        |    Yes     | LSET key index element                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       LTRIM       |    Yes     | LTRIM key start stop                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       RPOP        |    Yes     | RPOP key [count]                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     RPOPLPUSH     |    Yes*    | RPOPLPUSH source destination                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       RPUSH       |    Yes     | RPUSH key element [element …]                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      RPUSHX       |    Yes     | RPUSHX key element [element …]                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* RPOPLPUSH support requires that source and destination keys hash to the same server. You can ensure this by using the same [hashtag](recommendation.md#hash-tags) for source and destination key. Twemproxy does no checking on its end to verify that source and destination key hash to the same server, and the RPOPLPUSH command is forwarded to the server that the source key hashes to

### Sets

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       SADD        |    Yes     | SADD key member [member …]                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       SCARD       |    Yes     | SCARD key                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       SDIFF       |    Yes*    | SDIFF key [key …]                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SDIFFSTORE     |    Yes*    | SDIFFSTORE destination key [key …]                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SINTER       |    Yes*    | SINTER key [key …]                                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SINTERSTORE    |    Yes*    | SINTERSTORE destination key [key …]                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SISMEMBER     |    Yes     | SISMEMBER key member                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SMEMBERS      |    Yes     | SMEMBERS key                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SMISMEMBER     |    Yes     | SMISMEMBER key member [member …]                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       SMOVE       |    Yes*    | SMOVE source destination member                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       SPOP        |    Yes     | SPOP key [count]                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SRANDMEMBER    |    Yes     | SRANDMEMBER key [count]                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       SREM        |    Yes     | SREM key member [member …]                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       SSCAN       |    Yes     | SSCAN key cursor [MATCH] [COUNT]                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SUNION       |    Yes*    | SUNION key [key …]                                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SUNIONSTORE    |    Yes*    | SUNIONSTORE destination key [key …]                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* SIDFF, SDIFFSTORE, SINTER, SINTERSTORE, SMOVE, SUNION and SUNIONSTORE support requires that the supplied keys hash to the same server. You can ensure this by using the same [hashtag](recommendation.md#hash-tags) for all keys in the command. Twemproxy does no checking on its end to verify that all the keys hash to the same server, and the given command is forwarded to the server that the first key hashes to.


### Sorted Sets

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     BZPOPMAX      |    No      | BZPOPMAX key [key …] timeout                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     BZPOPMIN      |    No      | BZPOPMIN key [key …] timeout                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       ZADD        |    Yes     | ZADD key [NX|XX] [GT|LT] [CH] [INCR] score member [score member …]                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       ZCARD       |    Yes     | ZCARD key                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZCOUNT       |    Yes     | ZCOUNT key min max                                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       ZDIFF       |    Yes*    | ZDIFF numkeys key [key …] [WITHSCORES]                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZDIFFSTORE     |    Yes*    | ZDIFFSTORE destination numkeys key [key …]                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZINCRBY      |    Yes     | ZINCRBY key increment member                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZINTER       |    Yes*    | ZINTER numkeys key [key …] [WEIGHTS] [SUM|MIN|MAX] [WITHSCORES]                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZINTERSTORE    |    Yes*    | ZINTERSTORE destination numkeys key [key …] [WEIGHTS] [SUM|MIN|MAX]                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     ZLEXCOUNT     |    Yes     | ZLEXCOUNT key min max                                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZMSCORE      |    Yes     | ZMSCORE key member [member …]                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZPOPMAX      |    Yes     | ZPOPMAX key [count]                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZPOPMIN      |    Yes     | ZPOPMIN key [count]                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZRANDMEMBER    |    Yes     | ZRANDMEMBER key [options]                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZRANGE       |    Yes     | ZRANGE key min max [BYSCORE|BYLEX] [REV] [LIMIT] [WITHSCORES]                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZRANGEBYLEX    |    Yes     | ZRANGEBYLEX key min max [LIMIT]                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |   ZRANGEBYSCORE   |    Yes     | ZRANGEBYSCORE key min max [WITHSCORES] [LIMIT]                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZRANGESTORE    |    Yes     | ZRANGESTORE dst src min max [BYSCORE|BYLEX] [REV] [LIMIT]                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       ZRANK       |    Yes     | ZRANK key member                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       ZREM        |    Yes     | ZREM key member [member …]                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |  ZREMRANGEBYLEX   |    Yes     | ZREMRANGEBYLEX key min max                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |  ZREMRANGEBYRANK  |    Yes     | ZREMRANGEBYRANK key start stop                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    | ZREMRANGEBYSCORE  |    Yes     | ZREMRANGEBYSCORE key min max                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     ZREVRANGE     |    Yes     | ZREVRANGE key start stop [WITHSCORES]                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |  ZREVRANGEBYLEX   |    Yes     | ZREVRANGEBYLEX key max min [LIMIT]                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    | ZREVRANGEBYSCORE  |    Yes     | ZREVRANGEBYSCORE key max min [WITHSCORES] [LIMIT]                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     ZREVRANK      |    Yes     | ZREVRANK key member                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       ZSCAN       |    Yes     | ZSCAN key cursor [MATCH] [COUNT]                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZSCORE       |    Yes     | ZSCORE key member                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZUNION       |    Yes*    | ZUNION numkeys key [key …] [WEIGHTS] [SUM|MIN|MAX] [WITHSCORES]                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZUNIONSTORE    |    Yes*    | ZUNIONSTORE destination numkeys key [key …] [WEIGHTS] [SUM|MIN|MAX]                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* ZINTERSTORE and ZUNIONSTORE support requires that the supplied keys hash to the same server. You can ensure this by using the same [hashtag](recommendation.md#hash-tags) for all keys in the command. Twemproxy does no checking on its end to verify that all the keys hash to the same server, and the given command is forwarded to the server that the first key hashes to.

### HyperLogLog

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       PFADD       |    Yes     | PFADD key element [element …]                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PFCOUNT      |    Yes     | PFCOUNT key [key …]                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PFMERGE      |    Yes*    | PFMERGE destkey sourcekey [sourcekey …]                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* PFMERGE support requires that the supplied keys hash to the same server. You can ensure this by using the same [hashtag](recommendation.md#hash-tags) for all keys in the command. Twemproxy does no checking on its end to verify that all the keys hash to the same server, and the given command is forwarded to the server that the first key hashes to.

### Geo Command

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      GEOADD       |    Yes     | GEOADD key [NX|XX] [CH] longitude latitude member [longitude latitude member …]                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      GEODIST      |    Yes     | GEODIST key member1 member2 [m|km|ft|mi]                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      GEOHASH      |    Yes     | GEOHASH key member [member …]                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      GEOPOS       |    Yes     | GEOPOS key member [member …]                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     GEORADIUS     |    Yes     | GEORADIUS key longitude latitude radius m|km|ft|mi [WITHCOORD] [WITHDIST] [WITHHASH] [count] [ASC|DESC] [STORE] [STOREDIST]|
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    | GEORADIUSBYMEMBER |    Yes     | GEORADIUSBYMEMBER key member radius m|km|ft|mi [WITHCOORD] [WITHDIST] [WITHHASH] [count] [ASC|DESC] [STORE] [STOREDIST]|
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     GEOSEARCH     |    Yes     | GEOSEARCH key [FROMMEMBER] [FROMLONLAT] [circle] [box] [ASC|DESC] [count] [WITHCOORD] [WITHDIST] [WITHHASH]         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |  GEOSEARCHSTORE   |    Yes     | GEOSEARCHSTORE destination source [FROMMEMBER] [FROMLONLAT] [circle] [box] [ASC|DESC] [count] [WITHCOORD] [WITHDIST] [WITHHASH] [STOREDIST]|
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Pub/Sub

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    PSUBSCRIBE     |    No      | PSUBSCRIBE pattern [pattern …]                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PUBLISH      |    No      | PUBLISH channel message                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PUBSUB       |    No      | PUBSUB subcommand [argument [argument …]]                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |   PUNSUBSCRIBE    |    No      | PUNSUBSCRIBE [pattern [pattern …]]                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SUBSCRIBE     |    No      | SUBSCRIBE channel [channel …]                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    UNSUBSCRIBE    |    No      | UNSUBSCRIBE [channel [channel …]]                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Transactions

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      DISCARD      |    No      | DISCARD                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       EXEC        |    No      | EXEC                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       MULTI       |    No      | MULTI                                                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      UNWATCH      |    No      | UNWATCH                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       WATCH       |    No      | WATCH key [key …]                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Scripting

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       EVAL        |    Yes*    | EVAL script numkeys key [key …] arg [arg …]                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      EVALSHA      |    Yes*    | EVALSHA sha1 numkeys key [key …] arg [arg …]                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |   SCRIPT DEBUG    |    No      | SCRIPT DEBUG YES|SYNC|NO                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |   SCRIPT EXISTS   |    No      | SCRIPT EXISTS sha1 [sha1 …]                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |   SCRIPT FLUSH    |    No      | SCRIPT FLUSH [ASYNC|SYNC]                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SCRIPT KILL    |    No      | SCRIPT KILL                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SCRIPT LOAD    |    No      | SCRIPT LOAD script                                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

 * EVAL and EVALSHA support is limited to scripts that take at least 1 key. If multiple keys are used, all keys must hash to the same server. You can ensure this by using the same [hashtag](recommendation.md#hash-tags) for all keys. If you use more than 1 key, the proxy does no checking to verify that all keys hash to the same server, and the entire command is forwarded to the server that the first key hashes to

### Connection

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       AUTH        |    No      | AUTH password                                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       ECHO        |    No      | ECHO message                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       PING        |    Yes     | PING                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       QUIT        |    Yes     | QUIT                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SELECT       |    No      | SELECT index                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Server

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    BGREWRITEAOF   |    No      | BGREWRITEAOF                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      BGSAVE       |    No      | BGSAVE                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    CLIENT KILL    |    No      | CLIENT KILL ip:port                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    CLIENT LIST    |    No      | CLIENT LIST                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    CONFIG GET     |    No      | CONFIG GET parameter                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    CONFIG SET     |    No      | CONFIG SET parameter value                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |  CONFIG RESETSTAT |    No      | CONFIG RESETSTAT                                                                                                    |
    +-------------------+-------------+--------------------------------------------------------------------------------------------------------------------+
    |     DBSIZE        |    No      | DBSIZE                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    DEBUG OBJECT   |    No      | DEBUG OBJECT key                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    DEBUG SEGFAULT |    No      | DEBUG SEGFAULT                                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     FLUSHALL      |    No      | FLUSHALL                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     FLUSHDB       |    No      | FLUSHDB                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      INFO         |    No      | INFO                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     LASTSAVE      |    No      | LASTSAVE                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     MONITOR       |    No      | MONITOR                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SAVE         |    No      | SAVE                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SHUTDOWN      |    No      | SHUTDOWN [NOSAVE] [SAVE]                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SLAVEOF       |    No      | SLAVEOF host port                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SLOWLOG       |    No      | SLOWLOG subcommand [argument]                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SYNC         |    No      | SYNC                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      TIME         |    No      | TIME                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     COMMAND       |    Yes     | COMMAND                                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     LOLWUT        |    Yes     | LOLWUT [ argument ...]                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* COMMAND is forwarded to an arbitrarily chosen redis backend for the benefit of tools such as `redis-cli`.
  It assumes that all proxied redis servers support the same backend.
  There is no post-processing; Commands that are not supported by twemproxy are not filtered out.
* LOLWUT is also forwarded to an arbitrarily chosen redis backend because it does not depend on the state of the database and the presence of the command would not affect production applications.
  It can be used as a reference for adding future commands with no keys and a variable-length argument list.
  Other commands such as `TIME` continue to be unsupported. They may vary based on state of the database (e.g. out of sync clocks). Using EVAL with a key known to be on the specific backend server can be done instead.

## Note

- redis commands are not case sensitive
- only vectored commands 'MGET key [key ...]', 'MSET key value [key value ...]', 'DEL key [key ...]', 'UNLINK key [key ...]', 'EXISTS key [key ...]'  needs to be fragmented

## Performance

### Setup

+ redis-server running on machine A.
+ nutcracker running on machine A as a local proxy to redis-server.
+ redis-benchmark running on machine B.
+ machine A != machine B.
+ nutcracker built with --enable-debug=no
+ nutcracker running with mbuf-size of 512 (-m 512)
+ redis-server built from redis 2.6 branch

### redis-benchmark against redis-server

    $ redis-benchmark -h <machine-A> -q -t set,get,incr,lpush,lpop,sadd,spop,lpush,lrange -c 100 -p 6379
    SET: 89285.71 requests per second
    GET: 92592.59 requests per second
    INCR: 89285.71 requests per second
    LPUSH: 90090.09 requests per second
    LPOP: 90090.09 requests per second
    SADD: 90090.09 requests per second
    SPOP: 93457.95 requests per second
    LPUSH (needed to benchmark LRANGE): 89285.71 requests per second
    LRANGE_100 (first 100 elements): 36496.35 requests per second
    LRANGE_300 (first 300 elements): 15748.03 requests per second
    LRANGE_500 (first 450 elements): 11135.86 requests per second
    LRANGE_600 (first 600 elements): 8650.52 requests per second

### redis-benchmark against nutcracker proxing redis-server

    $ redis-benchmark -h <machine-A> -q -t set,get,incr,lpush,lpop,sadd,spop,lpush,lrange -c 100 -p 22121
    SET: 85470.09 requests per second
    GET: 86956.52 requests per second
    INCR: 85470.09 requests per second
    LPUSH: 84745.77 requests per second
    LPOP: 86206.90 requests per second
    SADD: 84745.77 requests per second
    SPOP: 86956.52 requests per second
    LPUSH (needed to benchmark LRANGE): 84745.77 requests per second
    LRANGE_100 (first 100 elements): 29761.90 requests per second
    LRANGE_300 (first 300 elements): 12376.24 requests per second
    LRANGE_500 (first 450 elements): 8605.85 requests per second
    LRANGE_600 (first 600 elements): 6587.62 requests per second

## redis-auth feature

+ you can enable redis-auth for a pool with 'redis_auth':

        alpha:
          listen: 127.0.0.1:22121
          hash: fnv1a_64
          distribution: ketama
          redis: true
          redis_auth: testpass

+ notice:
    + *MUST* set all redis with a same passwd, and all twemproxy with the same passwd
    + Length of password should be less than 256

## redis-sentinel feature

+ You can configure sentinel for a pool with 'sentinels' to let twemproxy works with sentinel:

        sigma:
          listen: 127.0.0.1:22125
          hash: fnv1a_64
          distribution: ketama
          auto_eject_hosts: false
          redis: true
          server_retry_timeout: 2000
          server_failure_limit: 1
          servers:
            - 127.0.0.1:6379:1 server1
            - 127.0.0.1:6380:1 server2
          sentinels:
            - 127.0.0.1:26379:1
            - 127.0.0.1:26380:1
            - 127.0.0.1:26381:1

+ notice:
    + You should configure all the sentinels you used. Twemproxy will connect to the alive sentinels when some are down
    + Weight of sentinel is not used. Twemproxy keeps it because of the server load code reuse

See [sentinel.md](./sentinel.md) for more details.
