        PROGRAM MJY01B
C
C       =========================================================
C       Purpose: This program computes Bessel functions Jn(x) 
C                and Yn(x) ( n=0,1 ) and their derivatives 
C                using subroutine JY01B
C       Input :  x   --- Argument of Jn(x) & Yn(x) ( x  0 )
C       Output:  BJ0 --- J0(x)
C                DJ0 --- J0'(x)
C                BJ1 --- J1(x)
C                DJ1 --- J1'(x)
C                BY0 --- Y0(x)
C                DY0 --- Y0'(x)
C                BY1 --- Y1(x)
C                DY1 --- Y1'(x)
C       Example:
C
C        x       J0(x)        J0'(x)       J1(x)        J1'(x)
C       ---------------------------------------------------------
C        1     .76519769   -.44005059    .44005059    .32514710
C        5    -.17759677    .32757914   -.32757914   -.11208094
C       10    -.24593576   -.04347275    .04347275   -.25028304
C       20     .16702466   -.06683312    .06683312    .16368301
C       30    -.08636798    .11875106   -.11875106   -.08240961
C       40     .00736689   -.12603832    .12603832    .00421593
C       50     .05581233    .09751183   -.09751183    .05776256
C
C        x       Y0(x)        Y0'(x)       Y1(x)        Y1'(x)
C      ---------------------------------------------------------
C        1     .08825696    .78121282   -.78121282    .86946979
C        5    -.30851763   -.14786314    .14786314   -.33809025
C       10     .05567117   -.24901542    .24901542    .03076962
C       20     .06264060    .16551161   -.16551161    .07091618
C       30    -.11729573   -.08442557    .08442557   -.12010992
C       40     .12593642    .00579351   -.00579351    .12608125
C       50    -.09806500    .05679567   -.05679567   -.09692908
C       =========================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        WRITE(*,*)'Please enter x'
        READ(*,*)X
        WRITE(*,20)X
        WRITE(*,*)'  x          J0(x)          J0''(x)         J1(x)',
     &            '          J1''(x)'
        WRITE(*,*)'------------------------------------------',
     &            '----------------------------'
        CALL JY01B(X,BJ0,DJ0,BJ1,DJ1,BY0,DY0,BY1,DY1)
        WRITE(*,10)X,BJ0,DJ0,BJ1,DJ1
        WRITE(*,*)
        WRITE(*,*)'  x          Y0(x)          Y0''(x)         Y1(x)',
     &            '          Y1''(x)'
        WRITE(*,*)'------------------------------------------',
     &            '----------------------------'
        WRITE(*,10)X,BY0,DY0,BY1,DY1
10      FORMAT(1X,F5.1,4E16.8)
20      FORMAT(3X,'x =',F5.1)
        END


        SUBROUTINE JY01B(X,BJ0,DJ0,BJ1,DJ1,BY0,DY0,BY1,DY1)
C
C       =======================================================
C       Purpose: Compute Bessel functions J0(x), J1(x), Y0(x),
C                Y1(x), and their derivatives
C       Input :  x   --- Argument of Jn(x) & Yn(x) ( x  0 )
C       Output:  BJ0 --- J0(x)
C                DJ0 --- J0'(x)
C                BJ1 --- J1(x)
C                DJ1 --- J1'(x)
C                BY0 --- Y0(x)
C                DY0 --- Y0'(x)
C                BY1 --- Y1(x)
C                DY1 --- Y1'(x)
C       =======================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        PI=3.141592653589793D0
        IF (X.EQ.0.0D0) THEN
           BJ0=1.0D0
           BJ1=0.0D0
           DJ0=0.0D0
           DJ1=0.5D0
           BY0=-1.0D+300
           BY1=-1.0D+300
           DY0=1.0D+300
           DY1=1.0D+300
           RETURN
        ELSE IF (X.LE.4.0D0) THEN
           T=X/4.0D0
           T2=T*T
           BJ0=((((((-.5014415D-3*T2+.76771853D-2)*T2
     &         -.0709253492D0)*T2+.4443584263D0)*T2
     &         -1.7777560599D0)*T2+3.9999973021D0)
     &         *T2-3.9999998721D0)*T2+1.0D0
           BJ1=T*(((((((-.1289769D-3*T2+.22069155D-2)
     &         *T2-.0236616773D0)*T2+.1777582922D0)*T2
     &         -.8888839649D0)*T2+2.6666660544D0)*T2
     &         -3.9999999710D0)*T2+1.9999999998D0)
           BY0=(((((((-.567433D-4*T2+.859977D-3)*T2
     &         -.94855882D-2)*T2+.0772975809D0)*T2
     &         -.4261737419D0)*T2+1.4216421221D0)*T2
     &         -2.3498519931D0)*T2+1.0766115157)*T2
     &         +.3674669052D0
           BY0=2.0D0/PI*DLOG(X/2.0D0)*BJ0+BY0
           BY1=((((((((.6535773D-3*T2-.0108175626D0)*T2
     &         +.107657606D0)*T2-.7268945577D0)*T2
     &         +3.1261399273D0)*T2-7.3980241381D0)*T2
     &         +6.8529236342D0)*T2+.3932562018D0)*T2
     &         -.6366197726D0)/X
           BY1=2.0D0/PI*DLOG(X/2.0D0)*BJ1+BY1
        ELSE
           T=4.0D0/X
           T2=T*T
           A0=DSQRT(2.0D0/(PI*X))
           P0=((((-.9285D-5*T2+.43506D-4)*T2-.122226D-3)*T2
     &        +.434725D-3)*T2-.4394275D-2)*T2+.999999997D0
           Q0=T*(((((.8099D-5*T2-.35614D-4)*T2+.85844D-4)*T2
     &        -.218024D-3)*T2+.1144106D-2)*T2-.031249995D0)
           TA0=X-.25D0*PI
           BJ0=A0*(P0*DCOS(TA0)-Q0*DSIN(TA0))
           BY0=A0*(P0*DSIN(TA0)+Q0*DCOS(TA0))
           P1=((((.10632D-4*T2-.50363D-4)*T2+.145575D-3)*T2
     &        -.559487D-3)*T2+.7323931D-2)*T2+1.000000004D0
           Q1=T*(((((-.9173D-5*T2+.40658D-4)*T2-.99941D-4)*T2
     &        +.266891D-3)*T2-.1601836D-2)*T2+.093749994D0)
           TA1=X-.75D0*PI
           BJ1=A0*(P1*DCOS(TA1)-Q1*DSIN(TA1))
           BY1=A0*(P1*DSIN(TA1)+Q1*DCOS(TA1))
        ENDIF
        DJ0=-BJ1
        DJ1=BJ0-BJ1/X
        DY0=-BY1
        DY1=BY0-BY1/X
        RETURN
        END
