# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Iterable, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_workflows_list_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflows"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_workflow_get_request(workflow_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflows/{workflowId}"
    path_format_arguments = {
        "workflowId": _SERIALIZER.url("workflow_id", workflow_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_workflow_create_or_replace_request(workflow_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflows/{workflowId}"
    path_format_arguments = {
        "workflowId": _SERIALIZER.url("workflow_id", workflow_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_workflow_delete_request(workflow_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflows/{workflowId}"
    path_format_arguments = {
        "workflowId": _SERIALIZER.url("workflow_id", workflow_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_workflow_validate_request(workflow_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflows/{workflowId}/validate"
    path_format_arguments = {
        "workflowId": _SERIALIZER.url("workflow_id", workflow_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_user_requests_submit_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/userrequests"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_workflow_runs_list_request(
    *,
    view_mode: Optional[str] = None,
    time_window: Optional[str] = None,
    orderby: Optional[str] = None,
    run_statuses: Optional[List[str]] = None,
    workflow_ids: Optional[List[str]] = None,
    requestors: Optional[List[str]] = None,
    maxpagesize: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflowruns"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if view_mode is not None:
        _params["viewMode"] = _SERIALIZER.query("view_mode", view_mode, "str")
    if time_window is not None:
        _params["timeWindow"] = _SERIALIZER.query("time_window", time_window, "str")
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "str")
    if run_statuses is not None:
        _params["runStatuses"] = _SERIALIZER.query("run_statuses", run_statuses, "[str]", div=",")
    if workflow_ids is not None:
        _params["workflowIds"] = _SERIALIZER.query("workflow_ids", workflow_ids, "[str]", div=",")
    if requestors is not None:
        _params["requestors"] = _SERIALIZER.query("requestors", requestors, "[str]", div=",")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_workflow_run_get_request(workflow_run_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflowruns/{workflowRunId}"
    path_format_arguments = {
        "workflowRunId": _SERIALIZER.url("workflow_run_id", workflow_run_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_workflow_run_cancel_request(workflow_run_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflowruns/{workflowRunId}/cancel"
    path_format_arguments = {
        "workflowRunId": _SERIALIZER.url("workflow_run_id", workflow_run_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_workflow_tasks_list_request(
    *,
    view_mode: Optional[str] = None,
    workflow_ids: Optional[List[str]] = None,
    time_window: Optional[str] = None,
    maxpagesize: Optional[int] = None,
    orderby: Optional[str] = None,
    task_types: Optional[List[str]] = None,
    task_statuses: Optional[List[str]] = None,
    requestors: Optional[List[str]] = None,
    assignees: Optional[List[str]] = None,
    workflow_name_keyword: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflowtasks"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if view_mode is not None:
        _params["viewMode"] = _SERIALIZER.query("view_mode", view_mode, "str")
    if workflow_ids is not None:
        _params["workflowIds"] = _SERIALIZER.query("workflow_ids", workflow_ids, "[str]", div=",")
    if time_window is not None:
        _params["timeWindow"] = _SERIALIZER.query("time_window", time_window, "str")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "str")
    if task_types is not None:
        _params["taskTypes"] = _SERIALIZER.query("task_types", task_types, "[str]", div=",")
    if task_statuses is not None:
        _params["taskStatuses"] = _SERIALIZER.query("task_statuses", task_statuses, "[str]", div=",")
    if requestors is not None:
        _params["requestors"] = _SERIALIZER.query("requestors", requestors, "[str]", div=",")
    if assignees is not None:
        _params["assignees"] = _SERIALIZER.query("assignees", assignees, "[str]", div=",")
    if workflow_name_keyword is not None:
        _params["workflowNameKeyword"] = _SERIALIZER.query("workflow_name_keyword", workflow_name_keyword, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_workflow_task_get_request(task_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflowtasks/{taskId}"
    path_format_arguments = {
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_workflow_task_reassign_request(task_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflowtasks/{taskId}/reassign"
    path_format_arguments = {
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_approval_approve_request(task_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflowtasks/{taskId}/approve-approval"
    path_format_arguments = {
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_approval_reject_request(task_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflowtasks/{taskId}/reject-approval"
    path_format_arguments = {
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_task_status_update_request(task_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workflowtasks/{taskId}/change-task-status"
    path_format_arguments = {
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class WorkflowsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.workflow.PurviewWorkflowClient`'s
        :attr:`workflows` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> Iterable[JSON]:
        """List all workflows.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "description": "str",
                    "id": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "triggers": [
                        {
                            "type": "str",
                            "underCollection": "str",
                            "underGlossary": "str",
                            "underGlossaryHierarchy": "str"
                        }
                    ],
                    "createdBy": "str",
                    "createdTime": "2020-02-20 00:00:00",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "updatedBy": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_workflows_list_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class WorkflowOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.workflow.PurviewWorkflowClient`'s
        :attr:`workflow` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, workflow_id: str, **kwargs: Any) -> JSON:
        """Get a specific workflow.

        :param workflow_id: The workflow id. Required.
        :type workflow_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actionDag": {},
                    "description": "str",
                    "id": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "triggers": [
                        {
                            "type": "str",
                            "underCollection": "str",
                            "underGlossary": "str",
                            "underGlossaryHierarchy": "str"
                        }
                    ],
                    "createdBy": "str",
                    "createdTime": "2020-02-20 00:00:00",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "updatedBy": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_workflow_get_request(
            workflow_id=workflow_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def create_or_replace(
        self,
        workflow_id: str,
        workflow_create_or_update_command: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Create or replace a workflow.

        :param workflow_id: The workflow id. Required.
        :type workflow_id: str
        :param workflow_create_or_update_command: Create or update workflow payload. Required.
        :type workflow_create_or_update_command: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                workflow_create_or_update_command = {
                    "description": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "triggers": [
                        {
                            "type": "str",
                            "underCollection": "str",
                            "underGlossary": "str",
                            "underGlossaryHierarchy": "str"
                        }
                    ],
                    "actionDag": {}
                }

                # response body for status code(s): 200
                response == {
                    "actionDag": {},
                    "description": "str",
                    "id": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "triggers": [
                        {
                            "type": "str",
                            "underCollection": "str",
                            "underGlossary": "str",
                            "underGlossaryHierarchy": "str"
                        }
                    ],
                    "createdBy": "str",
                    "createdTime": "2020-02-20 00:00:00",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "updatedBy": "str"
                }
        """

    @overload
    def create_or_replace(
        self,
        workflow_id: str,
        workflow_create_or_update_command: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Create or replace a workflow.

        :param workflow_id: The workflow id. Required.
        :type workflow_id: str
        :param workflow_create_or_update_command: Create or update workflow payload. Required.
        :type workflow_create_or_update_command: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actionDag": {},
                    "description": "str",
                    "id": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "triggers": [
                        {
                            "type": "str",
                            "underCollection": "str",
                            "underGlossary": "str",
                            "underGlossaryHierarchy": "str"
                        }
                    ],
                    "createdBy": "str",
                    "createdTime": "2020-02-20 00:00:00",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "updatedBy": "str"
                }
        """

    @distributed_trace
    def create_or_replace(
        self, workflow_id: str, workflow_create_or_update_command: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        """Create or replace a workflow.

        :param workflow_id: The workflow id. Required.
        :type workflow_id: str
        :param workflow_create_or_update_command: Create or update workflow payload. Is either a JSON
         type or a IO[bytes] type. Required.
        :type workflow_create_or_update_command: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                workflow_create_or_update_command = {
                    "description": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "triggers": [
                        {
                            "type": "str",
                            "underCollection": "str",
                            "underGlossary": "str",
                            "underGlossaryHierarchy": "str"
                        }
                    ],
                    "actionDag": {}
                }

                # response body for status code(s): 200
                response == {
                    "actionDag": {},
                    "description": "str",
                    "id": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "triggers": [
                        {
                            "type": "str",
                            "underCollection": "str",
                            "underGlossary": "str",
                            "underGlossaryHierarchy": "str"
                        }
                    ],
                    "createdBy": "str",
                    "createdTime": "2020-02-20 00:00:00",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "updatedBy": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(workflow_create_or_update_command, (IOBase, bytes)):
            _content = workflow_create_or_update_command
        else:
            _json = workflow_create_or_update_command

        _request = build_workflow_create_or_replace_request(
            workflow_id=workflow_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delete(self, workflow_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Delete a workflow.

        :param workflow_id: The workflow id. Required.
        :type workflow_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_workflow_delete_request(
            workflow_id=workflow_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def validate(
        self, workflow_id: str, workflow_validate_query: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Validate a workflow.

        :param workflow_id: The workflow id. Required.
        :type workflow_id: str
        :param workflow_validate_query: Check workflow payload. Required.
        :type workflow_validate_query: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                workflow_validate_query = {
                    "description": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "triggers": [
                        {
                            "type": "str",
                            "underCollection": "str",
                            "underGlossary": "str",
                            "underGlossaryHierarchy": "str"
                        }
                    ],
                    "actionDag": {}
                }

                # response body for status code(s): 200
                response == {
                    "value": [
                        {
                            "location": {
                                "type": "str",
                                "actionName": "str",
                                "parameterKey": "str"
                            },
                            "message": "str",
                            "severity": "str"
                        }
                    ]
                }
        """

    @overload
    def validate(
        self,
        workflow_id: str,
        workflow_validate_query: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Validate a workflow.

        :param workflow_id: The workflow id. Required.
        :type workflow_id: str
        :param workflow_validate_query: Check workflow payload. Required.
        :type workflow_validate_query: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "value": [
                        {
                            "location": {
                                "type": "str",
                                "actionName": "str",
                                "parameterKey": "str"
                            },
                            "message": "str",
                            "severity": "str"
                        }
                    ]
                }
        """

    @distributed_trace
    def validate(self, workflow_id: str, workflow_validate_query: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Validate a workflow.

        :param workflow_id: The workflow id. Required.
        :type workflow_id: str
        :param workflow_validate_query: Check workflow payload. Is either a JSON type or a IO[bytes]
         type. Required.
        :type workflow_validate_query: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                workflow_validate_query = {
                    "description": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "triggers": [
                        {
                            "type": "str",
                            "underCollection": "str",
                            "underGlossary": "str",
                            "underGlossaryHierarchy": "str"
                        }
                    ],
                    "actionDag": {}
                }

                # response body for status code(s): 200
                response == {
                    "value": [
                        {
                            "location": {
                                "type": "str",
                                "actionName": "str",
                                "parameterKey": "str"
                            },
                            "message": "str",
                            "severity": "str"
                        }
                    ]
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(workflow_validate_query, (IOBase, bytes)):
            _content = workflow_validate_query
        else:
            _json = workflow_validate_query

        _request = build_workflow_validate_request(
            workflow_id=workflow_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class UserRequestsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.workflow.PurviewWorkflowClient`'s
        :attr:`user_requests` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def submit(self, user_requests_payload: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Submit a user request for requestor, a user  request describes user ask to do operation(s) on
        Purview. If any workflow's trigger matches with an operation in request, a run of the workflow
        is created.

        :param user_requests_payload: The payload of submitting a user request. Required.
        :type user_requests_payload: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_requests_payload = {
                    "operations": [
                        {
                            "payload": {},
                            "type": "str"
                        }
                    ],
                    "comment": "str"
                }

                # response body for status code(s): 200
                response == {
                    "operations": [
                        {
                            "payload": {},
                            "type": "str",
                            "workflowRunIds": [
                                "str"
                            ]
                        }
                    ],
                    "requestId": "str",
                    "requestor": "str",
                    "status": "str",
                    "comment": "str"
                }
        """

    @overload
    def submit(
        self, user_requests_payload: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Submit a user request for requestor, a user  request describes user ask to do operation(s) on
        Purview. If any workflow's trigger matches with an operation in request, a run of the workflow
        is created.

        :param user_requests_payload: The payload of submitting a user request. Required.
        :type user_requests_payload: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "operations": [
                        {
                            "payload": {},
                            "type": "str",
                            "workflowRunIds": [
                                "str"
                            ]
                        }
                    ],
                    "requestId": "str",
                    "requestor": "str",
                    "status": "str",
                    "comment": "str"
                }
        """

    @distributed_trace
    def submit(self, user_requests_payload: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Submit a user request for requestor, a user  request describes user ask to do operation(s) on
        Purview. If any workflow's trigger matches with an operation in request, a run of the workflow
        is created.

        :param user_requests_payload: The payload of submitting a user request. Is either a JSON type
         or a IO[bytes] type. Required.
        :type user_requests_payload: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_requests_payload = {
                    "operations": [
                        {
                            "payload": {},
                            "type": "str"
                        }
                    ],
                    "comment": "str"
                }

                # response body for status code(s): 200
                response == {
                    "operations": [
                        {
                            "payload": {},
                            "type": "str",
                            "workflowRunIds": [
                                "str"
                            ]
                        }
                    ],
                    "requestId": "str",
                    "requestor": "str",
                    "status": "str",
                    "comment": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(user_requests_payload, (IOBase, bytes)):
            _content = user_requests_payload
        else:
            _json = user_requests_payload

        _request = build_user_requests_submit_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class WorkflowRunsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.workflow.PurviewWorkflowClient`'s
        :attr:`workflow_runs` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        view_mode: Optional[str] = None,
        time_window: Optional[str] = None,
        orderby: Optional[str] = None,
        run_statuses: Optional[List[str]] = None,
        workflow_ids: Optional[List[str]] = None,
        requestors: Optional[List[str]] = None,
        **kwargs: Any
    ) -> Iterable[JSON]:
        """List workflow runs.

        :keyword view_mode: To filter user's workflow runs or view as admin. Default value is None.
        :paramtype view_mode: str
        :keyword time_window: Time window of filtering items. Known values are: "1d", "7d", "30d", and
         "90d". Default value is None.
        :paramtype time_window: str
        :keyword orderby: The key word which used to sort the results. Known values are: "status desc",
         "status asc", "requestor desc", "requestor asc", "startTime desc", "startTime asc",
         "createdTime desc", and "createdTime asc". Default value is None.
        :paramtype orderby: str
        :keyword run_statuses: Filter workflow runs by workflow run status. Default value is None.
        :paramtype run_statuses: list[str]
        :keyword workflow_ids: Filter items by workflow id list. Default value is None.
        :paramtype workflow_ids: list[str]
        :keyword requestors: Requestors' ids to filter. Default value is None.
        :paramtype requestors: list[str]
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",
                    "requestor": "str",
                    "runPayload": {
                        "targetValue": "str",
                        "type": "str"
                    },
                    "startTime": "2020-02-20 00:00:00",
                    "status": "str",
                    "workflowId": "str",
                    "cancelComment": "str",
                    "cancelTime": "2020-02-20 00:00:00",
                    "endTime": "2020-02-20 00:00:00",
                    "userRequestId": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_workflow_runs_list_request(
                    view_mode=view_mode,
                    time_window=time_window,
                    orderby=orderby,
                    run_statuses=run_statuses,
                    workflow_ids=workflow_ids,
                    requestors=requestors,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class WorkflowRunOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.workflow.PurviewWorkflowClient`'s
        :attr:`workflow_run` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, workflow_run_id: str, **kwargs: Any) -> JSON:
        """Get a workflow run.

        :param workflow_run_id: The workflow run id. Required.
        :type workflow_run_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actionDag": {},
                    "detail": {
                        "actions": {},
                        "runInput": {}
                    },
                    "cancelComment": "str",
                    "cancelTime": "2020-02-20 00:00:00",
                    "endTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "requestor": "str",
                    "runPayload": {
                        "payload": {},
                        "targetValue": "str",
                        "type": "str"
                    },
                    "startTime": "2020-02-20 00:00:00",
                    "status": "str",
                    "userRequestId": "str",
                    "workflowId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_workflow_run_get_request(
            workflow_run_id=workflow_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def cancel(
        self, workflow_run_id: str, run_cancel_reply: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Cancel a workflow run.

        :param workflow_run_id: The workflow run id. Required.
        :type workflow_run_id: str
        :param run_cancel_reply: Reply of canceling a workflow run. Required.
        :type run_cancel_reply: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                run_cancel_reply = {
                    "comment": "str"
                }
        """

    @overload
    def cancel(
        self,
        workflow_run_id: str,
        run_cancel_reply: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Cancel a workflow run.

        :param workflow_run_id: The workflow run id. Required.
        :type workflow_run_id: str
        :param run_cancel_reply: Reply of canceling a workflow run. Required.
        :type run_cancel_reply: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def cancel(  # pylint: disable=inconsistent-return-statements
        self, workflow_run_id: str, run_cancel_reply: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Cancel a workflow run.

        :param workflow_run_id: The workflow run id. Required.
        :type workflow_run_id: str
        :param run_cancel_reply: Reply of canceling a workflow run. Is either a JSON type or a
         IO[bytes] type. Required.
        :type run_cancel_reply: JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                run_cancel_reply = {
                    "comment": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(run_cancel_reply, (IOBase, bytes)):
            _content = run_cancel_reply
        else:
            _json = run_cancel_reply

        _request = build_workflow_run_cancel_request(
            workflow_run_id=workflow_run_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore


class WorkflowTasksOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.workflow.PurviewWorkflowClient`'s
        :attr:`workflow_tasks` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        view_mode: Optional[str] = None,
        workflow_ids: Optional[List[str]] = None,
        time_window: Optional[str] = None,
        orderby: Optional[str] = None,
        task_types: Optional[List[str]] = None,
        task_statuses: Optional[List[str]] = None,
        requestors: Optional[List[str]] = None,
        assignees: Optional[List[str]] = None,
        workflow_name_keyword: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable[JSON]:
        """Get all workflow tasks.

        :keyword view_mode: To filter user's sent, received or history workflow tasks. Default value is
         None.
        :paramtype view_mode: str
        :keyword workflow_ids: Filter items by workflow id list. Default value is None.
        :paramtype workflow_ids: list[str]
        :keyword time_window: Time window of filtering items. Known values are: "1d", "7d", "30d", and
         "90d". Default value is None.
        :paramtype time_window: str
        :keyword orderby: The key word which used to sort the results. Known values are: "status desc",
         "status asc", "requestor desc", "requestor asc", "startTime desc", "startTime asc",
         "createdTime desc", and "createdTime asc". Default value is None.
        :paramtype orderby: str
        :keyword task_types: Filter items by workflow task type. Default value is None.
        :paramtype task_types: list[str]
        :keyword task_statuses: Filter workflow tasks by status. Default value is None.
        :paramtype task_statuses: list[str]
        :keyword requestors: Requestors' ids to filter. Default value is None.
        :paramtype requestors: list[str]
        :keyword assignees: Assignees' ids to filter. Default value is None.
        :paramtype assignees: list[str]
        :keyword workflow_name_keyword: The key word which could used to filter workflow item with
         related workflow. Default value is None.
        :paramtype workflow_name_keyword: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "type":

                # JSON input template for discriminator value "Approval":
                workflow_task = {
                    "createdTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "payload": {
                        "targetValue": "str",
                        "type": "str",
                        "payload": {}
                    },
                    "requestor": "str",
                    "type": "Approval",
                    "workflowId": "str",
                    "workflowRunId": "str",
                    "approvalDetail": {
                        "approvalType": "str",
                        "approvers": {
                            "str": {
                                "reply": "str",
                                "comment": "str",
                                "responseTime": "2020-02-20 00:00:00"
                            }
                        },
                        "status": "str"
                    },
                    "expiryInfo": {
                        "expirySettings": {
                            "expireAfter": {},
                            "notifyOnExpiration": [
                                "str"
                            ]
                        },
                        "expiryTime": "2020-02-20 00:00:00",
                        "nextExpiryNotificationTime": "2020-02-20 00:00:00",
                        "lastExpiryNotificationTime": "2020-02-20 00:00:00"
                    },
                    "reminderInfo": {
                        "nextRemindTime": "2020-02-20 00:00:00",
                        "reminderSettings": {},
                        "lastRemindTime": "2020-02-20 00:00:00"
                    },
                    "title": "str"
                }

                # JSON input template for discriminator value "SimpleTask":
                workflow_task = {
                    "createdTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "payload": {
                        "targetValue": "str",
                        "type": "str",
                        "payload": {}
                    },
                    "requestor": "str",
                    "type": "SimpleTask",
                    "workflowId": "str",
                    "workflowRunId": "str",
                    "expiryInfo": {
                        "expirySettings": {
                            "expireAfter": {},
                            "notifyOnExpiration": [
                                "str"
                            ]
                        },
                        "expiryTime": "2020-02-20 00:00:00",
                        "nextExpiryNotificationTime": "2020-02-20 00:00:00",
                        "lastExpiryNotificationTime": "2020-02-20 00:00:00"
                    },
                    "reminderInfo": {
                        "nextRemindTime": "2020-02-20 00:00:00",
                        "reminderSettings": {},
                        "lastRemindTime": "2020-02-20 00:00:00"
                    },
                    "taskDetail": {
                        "assignedTo": [
                            "str"
                        ],
                        "changeHistory": [
                            {}
                        ],
                        "status": "str",
                        "taskBody": "str"
                    },
                    "title": "str"
                }

                # response body for status code(s): 200
                response == workflow_task
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_workflow_tasks_list_request(
                    view_mode=view_mode,
                    workflow_ids=workflow_ids,
                    time_window=time_window,
                    maxpagesize=maxpagesize,
                    orderby=orderby,
                    task_types=task_types,
                    task_statuses=task_statuses,
                    requestors=requestors,
                    assignees=assignees,
                    workflow_name_keyword=workflow_name_keyword,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class WorkflowTaskOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.workflow.PurviewWorkflowClient`'s
        :attr:`workflow_task` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, task_id: str, **kwargs: Any) -> JSON:
        """Get a workflow task.

        :param task_id: The task id. Required.
        :type task_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "type":

                # JSON input template for discriminator value "Approval":
                workflow_task = {
                    "createdTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "payload": {
                        "targetValue": "str",
                        "type": "str",
                        "payload": {}
                    },
                    "requestor": "str",
                    "type": "Approval",
                    "workflowId": "str",
                    "workflowRunId": "str",
                    "approvalDetail": {
                        "approvalType": "str",
                        "approvers": {
                            "str": {
                                "reply": "str",
                                "comment": "str",
                                "responseTime": "2020-02-20 00:00:00"
                            }
                        },
                        "status": "str"
                    },
                    "expiryInfo": {
                        "expirySettings": {
                            "expireAfter": {},
                            "notifyOnExpiration": [
                                "str"
                            ]
                        },
                        "expiryTime": "2020-02-20 00:00:00",
                        "nextExpiryNotificationTime": "2020-02-20 00:00:00",
                        "lastExpiryNotificationTime": "2020-02-20 00:00:00"
                    },
                    "reminderInfo": {
                        "nextRemindTime": "2020-02-20 00:00:00",
                        "reminderSettings": {},
                        "lastRemindTime": "2020-02-20 00:00:00"
                    },
                    "title": "str"
                }

                # JSON input template for discriminator value "SimpleTask":
                workflow_task = {
                    "createdTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "payload": {
                        "targetValue": "str",
                        "type": "str",
                        "payload": {}
                    },
                    "requestor": "str",
                    "type": "SimpleTask",
                    "workflowId": "str",
                    "workflowRunId": "str",
                    "expiryInfo": {
                        "expirySettings": {
                            "expireAfter": {},
                            "notifyOnExpiration": [
                                "str"
                            ]
                        },
                        "expiryTime": "2020-02-20 00:00:00",
                        "nextExpiryNotificationTime": "2020-02-20 00:00:00",
                        "lastExpiryNotificationTime": "2020-02-20 00:00:00"
                    },
                    "reminderInfo": {
                        "nextRemindTime": "2020-02-20 00:00:00",
                        "reminderSettings": {},
                        "lastRemindTime": "2020-02-20 00:00:00"
                    },
                    "taskDetail": {
                        "assignedTo": [
                            "str"
                        ],
                        "changeHistory": [
                            {}
                        ],
                        "status": "str",
                        "taskBody": "str"
                    },
                    "title": "str"
                }

                # response body for status code(s): 200
                response == workflow_task
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_workflow_task_get_request(
            task_id=task_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def reassign(
        self, task_id: str, reassign_command: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Reassign a workflow task.

        :param task_id: The task id. Required.
        :type task_id: str
        :param reassign_command: The request body of reassigning a workflow task. Required.
        :type reassign_command: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                reassign_command = {
                    "reassignments": [
                        {
                            "reassignFrom": "str",
                            "reassignTo": "str"
                        }
                    ]
                }
        """

    @overload
    def reassign(
        self, task_id: str, reassign_command: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Reassign a workflow task.

        :param task_id: The task id. Required.
        :type task_id: str
        :param reassign_command: The request body of reassigning a workflow task. Required.
        :type reassign_command: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def reassign(  # pylint: disable=inconsistent-return-statements
        self, task_id: str, reassign_command: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Reassign a workflow task.

        :param task_id: The task id. Required.
        :type task_id: str
        :param reassign_command: The request body of reassigning a workflow task. Is either a JSON type
         or a IO[bytes] type. Required.
        :type reassign_command: JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                reassign_command = {
                    "reassignments": [
                        {
                            "reassignFrom": "str",
                            "reassignTo": "str"
                        }
                    ]
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(reassign_command, (IOBase, bytes)):
            _content = reassign_command
        else:
            _json = reassign_command

        _request = build_workflow_task_reassign_request(
            task_id=task_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore


class ApprovalOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.workflow.PurviewWorkflowClient`'s
        :attr:`approval` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def approve(
        self, task_id: str, approval_response_comment: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Approve an approval.

        :param task_id: The task id. Required.
        :type task_id: str
        :param approval_response_comment: The request body of approving an approval type of workflow
         task. Required.
        :type approval_response_comment: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                approval_response_comment = {
                    "comment": "str"
                }
        """

    @overload
    def approve(
        self,
        task_id: str,
        approval_response_comment: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Approve an approval.

        :param task_id: The task id. Required.
        :type task_id: str
        :param approval_response_comment: The request body of approving an approval type of workflow
         task. Required.
        :type approval_response_comment: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def approve(  # pylint: disable=inconsistent-return-statements
        self, task_id: str, approval_response_comment: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Approve an approval.

        :param task_id: The task id. Required.
        :type task_id: str
        :param approval_response_comment: The request body of approving an approval type of workflow
         task. Is either a JSON type or a IO[bytes] type. Required.
        :type approval_response_comment: JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                approval_response_comment = {
                    "comment": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(approval_response_comment, (IOBase, bytes)):
            _content = approval_response_comment
        else:
            _json = approval_response_comment

        _request = build_approval_approve_request(
            task_id=task_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def reject(
        self, task_id: str, approval_response_comment: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Reject an approval.

        :param task_id: The task id. Required.
        :type task_id: str
        :param approval_response_comment: The request body of rejecting an approval type of workflow
         task. Required.
        :type approval_response_comment: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                approval_response_comment = {
                    "comment": "str"
                }
        """

    @overload
    def reject(
        self,
        task_id: str,
        approval_response_comment: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Reject an approval.

        :param task_id: The task id. Required.
        :type task_id: str
        :param approval_response_comment: The request body of rejecting an approval type of workflow
         task. Required.
        :type approval_response_comment: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def reject(  # pylint: disable=inconsistent-return-statements
        self, task_id: str, approval_response_comment: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Reject an approval.

        :param task_id: The task id. Required.
        :type task_id: str
        :param approval_response_comment: The request body of rejecting an approval type of workflow
         task. Is either a JSON type or a IO[bytes] type. Required.
        :type approval_response_comment: JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                approval_response_comment = {
                    "comment": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(approval_response_comment, (IOBase, bytes)):
            _content = approval_response_comment
        else:
            _json = approval_response_comment

        _request = build_approval_reject_request(
            task_id=task_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore


class TaskStatusOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.workflow.PurviewWorkflowClient`'s
        :attr:`task_status` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def update(
        self, task_id: str, task_update_command: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update the status of a workflow task request.

        :param task_id: The task id. Required.
        :type task_id: str
        :param task_update_command: Request body of updating workflow task request. Required.
        :type task_update_command: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                task_update_command = {
                    "newStatus": "str",
                    "comment": "str"
                }
        """

    @overload
    def update(
        self, task_id: str, task_update_command: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update the status of a workflow task request.

        :param task_id: The task id. Required.
        :type task_id: str
        :param task_update_command: Request body of updating workflow task request. Required.
        :type task_update_command: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update(  # pylint: disable=inconsistent-return-statements
        self, task_id: str, task_update_command: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Update the status of a workflow task request.

        :param task_id: The task id. Required.
        :type task_id: str
        :param task_update_command: Request body of updating workflow task request. Is either a JSON
         type or a IO[bytes] type. Required.
        :type task_update_command: JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                task_update_command = {
                    "newStatus": "str",
                    "comment": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(task_update_command, (IOBase, bytes)):
            _content = task_update_command
        else:
            _json = task_update_command

        _request = build_task_status_update_request(
            task_id=task_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
