# PySNMP SMI module. Autogenerated from smidump -f python DISMAN-SCRIPT-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:49 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, DisplayString, RowStatus, StorageType, TimeInterval, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "DisplayString", "RowStatus", "StorageType", "TimeInterval")

# Objects

scriptMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 64)).setRevisions(("2001-08-21 00:00","1999-02-22 18:00",))
if mibBuilder.loadTexts: scriptMIB.setOrganization("IETF Distributed Management Working Group")
if mibBuilder.loadTexts: scriptMIB.setContactInfo("WG EMail:  disman@dorothy.bmc.com\nSubscribe: disman-request@dorothy.bmc.com\n\nChair:     Randy Presuhn\n           BMC Software, Inc.\n\n\nPostal:    Office 1-3141\n           2141 North First Street\n           San Jose,  California 95131\n           USA\nEMail:     rpresuhn@bmc.com\nPhone:     +1 408 546-1006\n\nEditor:    David B. Levi\n           Nortel Networks\nPostal:    4401 Great America Parkway\n           Santa Clara, CA 95052-8185\n           USA\nEMail:     dlevi@nortelnetworks.com\nPhone:     +1 423 686 0432\n\nEditor:    Juergen Schoenwaelder\n           TU Braunschweig\nPostal:    Bueltenweg 74/75\n           38106 Braunschweig\n           Germany\nEMail:     schoenw@ibr.cs.tu-bs.de\nPhone:     +49 531 391-3283")
if mibBuilder.loadTexts: scriptMIB.setDescription("This MIB module defines a set of objects that allow to\ndelegate management scripts to distributed managers.")
smObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 64, 1))
smLangTable = MibTable((1, 3, 6, 1, 2, 1, 64, 1, 1))
if mibBuilder.loadTexts: smLangTable.setDescription("This table lists supported script languages.")
smLangEntry = MibTableRow((1, 3, 6, 1, 2, 1, 64, 1, 1, 1)).setIndexNames((0, "DISMAN-SCRIPT-MIB", "smLangIndex"))
if mibBuilder.loadTexts: smLangEntry.setDescription("An entry describing a particular language.")
smLangIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smLangIndex.setDescription("The locally arbitrary, but unique identifier associated\nwith this language entry.\n\nThe value is expected to remain constant at least from one\nre-initialization of the entity's network management system\nto the next re-initialization.\n\nNote that the data type and the range of this object must\nbe consistent with the definition of smScriptLanguage.")
smLangLanguage = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smLangLanguage.setDescription("The globally unique identification of the language.")
smLangVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 1, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: smLangVersion.setDescription("The version number of the language. The zero-length string\nshall be used if the language does not have a version\nnumber.\n\nIt is suggested that the version number consist of one or\nmore decimal numbers separated by dots, where the first\nnumber is called the major version number.")
smLangVendor = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 1, 1, 4), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smLangVendor.setDescription("An object identifier which identifies the vendor who\nprovides the implementation of the language. This object\nidentifier SHALL point to the object identifier directly\nbelow the enterprise object identifier {1 3 6 1 4 1}\nallocated for the vendor. The value must be the object\nidentifier {0 0} if the vendor is not known.")
smLangRevision = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 1, 1, 5), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: smLangRevision.setDescription("The version number of the language implementation.\nThe value of this object must be an empty string if\nversion number of the implementation is unknown.\n\nIt is suggested that the value consist of one or more\ndecimal numbers separated by dots, where the first\nnumber is called the major version number.")
smLangDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 1, 1, 6), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smLangDescr.setDescription("A textual description of the language.")
smExtsnTable = MibTable((1, 3, 6, 1, 2, 1, 64, 1, 2))
if mibBuilder.loadTexts: smExtsnTable.setDescription("This table lists supported language extensions.")
smExtsnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 64, 1, 2, 1)).setIndexNames((0, "DISMAN-SCRIPT-MIB", "smLangIndex"), (0, "DISMAN-SCRIPT-MIB", "smExtsnIndex"))
if mibBuilder.loadTexts: smExtsnEntry.setDescription("An entry describing a particular language extension.")
smExtsnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smExtsnIndex.setDescription("The locally arbitrary, but unique identifier associated\nwith this language extension entry.\n\nThe value is expected to remain constant at least from one\nre-initialization of the entity's network management system\nto the next re-initialization.")
smExtsnExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 2, 1, 2), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smExtsnExtension.setDescription("The globally unique identification of the language\nextension.")
smExtsnVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 2, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: smExtsnVersion.setDescription("The version number of the language extension.\nIt is suggested that the version number consist of one or\nmore decimal numbers separated by dots, where the first\nnumber is called the major version number.")
smExtsnVendor = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 2, 1, 4), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smExtsnVendor.setDescription("An object identifier which identifies the vendor who\nprovides the implementation of the extension. The\nobject identifier value should point to the OID node\ndirectly below the enterprise OID {1 3 6 1 4 1}\nallocated for the vendor. The value must by the object\nidentifier {0 0} if the vendor is not known.")
smExtsnRevision = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 2, 1, 5), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: smExtsnRevision.setDescription("The version number of the extension implementation.\nThe value of this object must be an empty string if\nversion number of the implementation is unknown.\n\nIt is suggested that the value consist of one or more\ndecimal numbers separated by dots, where the first\nnumber is called the major version number.")
smExtsnDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 2, 1, 6), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smExtsnDescr.setDescription("A textual description of the language extension.")
smScriptObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 64, 1, 3))
smScriptTable = MibTable((1, 3, 6, 1, 2, 1, 64, 1, 3, 1))
if mibBuilder.loadTexts: smScriptTable.setDescription("This table lists and describes locally known scripts.")
smScriptEntry = MibTableRow((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1)).setIndexNames((0, "DISMAN-SCRIPT-MIB", "smScriptOwner"), (0, "DISMAN-SCRIPT-MIB", "smScriptName"))
if mibBuilder.loadTexts: smScriptEntry.setDescription("An entry describing a particular script. Every script that\nis stored in non-volatile memory is required to appear in\nthis script table.")
smScriptOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smScriptOwner.setDescription("The manager who owns this row in the smScriptTable.")
smScriptName = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smScriptName.setDescription("The locally-unique, administratively assigned name for this\nscript. This object allows an smScriptOwner to have multiple\nentries in the smScriptTable.\n\nThis value of this object may be used to derive the name\n(e.g. a file name) which is used by the Script MIB\nimplementation to access the script in non-volatile\nstorage. The details of this mapping are implementation\nspecific. However, the mapping needs to ensure that scripts\ncreated by different owners with the same script name do not\nmap to the same name in non-volatile storage.")
smScriptDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 3), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smScriptDescr.setDescription("A description of the purpose of the script.")
smScriptLanguage = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smScriptLanguage.setDescription("The value of this object type identifies an entry in the\nsmLangTable which is used to execute this script.\nThe special value 0 may be used by hard-wired scripts\nthat can not be modified and that are executed by\ninternal functions.\n\nSet requests to change this object are invalid if the\nvalue of smScriptOperStatus is `enabled' or `compiling'\nand will result in an inconsistentValue error.\n\nNote that the data type and the range of this object must\nbe consistent with the definition of smLangIndex.")
smScriptSource = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 5), DisplayString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smScriptSource.setDescription("This object either contains a reference to the script\nsource or an empty string. A reference must be given\nin the form of a Uniform Resource Locator (URL) as\ndefined in RFC 2396. The allowed character sets and the\nencoding rules defined in RFC 2396 section 2 apply.\n\nWhen the smScriptAdminStatus object is set to `enabled',\nthe Script MIB implementation will `pull' the script\nsource from the URL contained in this object if the URL\nis not empty.\n\nAn empty URL indicates that the script source is loaded\nfrom local storage. The script is read from the smCodeTable\nif the value of smScriptStorageType is volatile. Otherwise,\nthe script is read from non-volatile storage.\n\nNote: This document does not mandate implementation of any\nspecific URL scheme. An attempt to load a script from a\nnonsupported URL scheme will cause the smScriptOperStatus\nto report an `unknownProtocol' error.\n\n\n\nSet requests to change this object are invalid if the\nvalue of smScriptOperStatus is `enabled', `editing',\n`retrieving' or `compiling' and will result in an\ninconsistentValue error.")
smScriptAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ("editing", 3), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smScriptAdminStatus.setDescription("The value of this object indicates the desired status of\nthe script. See the definition of smScriptOperStatus for\na description of the values.\n\nWhen the smScriptAdminStatus object is set to `enabled' and\nthe smScriptOperStatus is `disabled' or one of the error\nstates, the Script MIB implementation will `pull' the script\nsource from the URL contained in the smScriptSource object\nif the URL is not empty.")
smScriptOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(10,2,9,3,14,8,13,4,1,12,5,6,11,7,)).subtype(namedValues=NamedValues(("enabled", 1), ("compilationFailed", 10), ("noResourcesLeft", 11), ("unknownProtocol", 12), ("protocolFailure", 13), ("genericError", 14), ("disabled", 2), ("editing", 3), ("retrieving", 4), ("compiling", 5), ("noSuchScript", 6), ("accessDenied", 7), ("wrongLanguage", 8), ("wrongVersion", 9), )).clone(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: smScriptOperStatus.setDescription("The actual status of the script in the runtime system. The\nvalue of this object is only meaningful when the value of\nthe smScriptRowStatus object is `active'.\n\nThe smScriptOperStatus object may have the following values:\n\n- `enabled' indicates that the script is available and can\n   be started by a launch table entry.\n\n- `disabled' indicates that the script can not be used.\n\n- `editing' indicates that the script can be modified in the\n  smCodeTable.\n\n- `retrieving' indicates that the script is currently being\n  loaded from non-volatile storage or a remote system.\n\n- `compiling' indicates that the script is currently being\n  compiled by the runtime system.\n\n- `noSuchScript' indicates that the script does not exist\n  at the smScriptSource.\n\n- `accessDenied' indicates that the script can not be loaded\n  from the smScriptSource due to a lack of permissions.\n\n- `wrongLanguage' indicates that the script can not be\n   loaded from the smScriptSource because of a language\n   mismatch.\n\n- `wrongVersion' indicates that the script can not be loaded\n  from the smScriptSource because of a language version\n  mismatch.\n\n- `compilationFailed' indicates that the compilation failed.\n\n- `noResourcesLeft' indicates that the runtime system does\n  not have enough resources to load the script.\n\n- `unknownProtocol' indicates that the script could not be\n  loaded from the smScriptSource because the requested\n  protocol is not supported.\n\n- `protocolFailure' indicates that the script could not be\n  loaded from the smScriptSource because of a protocol\n  failure.\n\n- `genericError' indicates that the script could not be\n\n\n  loaded due to an error condition not listed above.\n\nThe `retrieving' and `compiling' states are transient states\nwhich will either lead to one of the error states or the\n`enabled' state. The `disabled' and `editing' states are\nadministrative states which are only reached by explicit\nmanagement operations.\n\nAll launch table entries that refer to this script table\nentry shall have an smLaunchOperStatus value of `disabled'\nwhen the value of this object is not `enabled'.")
smScriptStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 8), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smScriptStorageType.setDescription("This object defines whether this row and the script\ncontrolled by this row are kept in volatile storage and\nlost upon reboot or if this row is backed up by\nnon-volatile or permanent storage.\n\nThe storage type of this row always complies with the value\nof this entry if the value of the corresponding RowStatus\nobject is `active'.\n\nHowever, the storage type of the script controlled by this\nrow may be different, if the value of this entry is\n`non-volatile'. The script controlled by this row is written\ninto local non-volatile storage if the following condition\nbecomes true:\n\n(a) the URL contained in the smScriptSource object is empty\n    and\n(b) the smScriptStorageType is `nonVolatile'\n    and\n(c) the smScriptOperStatus is `enabled'\n\nSetting this object to `volatile' removes a script from\nnon-volatile storage if the script controlled by this row\nhas been in non-volatile storage before. Attempts to set\nthis object to permanent will always fail with an\ninconsistentValue error.\n\nThe value of smScriptStorageType is only meaningful if the\nvalue of the corresponding RowStatus object is `active'.\n\n\nIf smScriptStorageType has the value permanent(4), then all\nobjects whose MAX-ACCESS value is read-create must be\nwritable, with the exception of the smScriptStorageType and\nsmScriptRowStatus objects, which shall be read-only.")
smScriptRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smScriptRowStatus.setDescription("A control that allows entries to be added and removed from\nthis table.\n\nChanging the smScriptRowStatus from `active' to\n`notInService' will remove the associated script from the\nruntime system.\n\nDeleting conceptual rows from this table may affect the\ndeletion of other resources associated with this row. For\nexample, a script stored in non-volatile storage may be\nremoved from non-volatile storage.\n\nAn entry may not exist in the `active' state unless all\nrequired objects in the entry have appropriate values. Rows\nthat are not complete or not in service are not known by the\nscript runtime system.\n\nAttempts to `destroy' a row or to set a row `notInService'\nwhile the smScriptOperStatus is `enabled' will result in an\ninconsistentValue error.\n\nAttempts to `destroy' a row or to set a row `notInService'\nwhere the value of the smScriptStorageType object is\n`permanent' or `readOnly' will result in an\ninconsistentValue error.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.")
smScriptError = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 10), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smScriptError.setDescription("This object contains a descriptive error message if the\n\n\ntransition into the operational status `enabled' failed.\nImplementations must reset the error message to a\nzero-length string when a new attempt to change the\nscript status to `enabled' is started.")
smScriptLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 11), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smScriptLastChange.setDescription("The date and time when this script table entry was last\nmodified. The value '0000000000000000'H is returned if\nthe script table entry has not yet been modified.\n\nNote that the resetting of smScriptError is not considered\na change of the script table entry.")
smCodeTable = MibTable((1, 3, 6, 1, 2, 1, 64, 1, 3, 2))
if mibBuilder.loadTexts: smCodeTable.setDescription("This table contains the script code for scripts that are\nwritten via SNMP write operations.")
smCodeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 64, 1, 3, 2, 1)).setIndexNames((0, "DISMAN-SCRIPT-MIB", "smScriptOwner"), (0, "DISMAN-SCRIPT-MIB", "smScriptName"), (0, "DISMAN-SCRIPT-MIB", "smCodeIndex"))
if mibBuilder.loadTexts: smCodeEntry.setDescription("An entry describing a particular fragment of a script.")
smCodeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smCodeIndex.setDescription("The index value identifying this code fragment.")
smCodeText = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 2, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 1024))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smCodeText.setDescription("The code that makes up a fragment of a script. The format\nof this code fragment depends on the script language which\nis identified by the associated smScriptLanguage object.")
smCodeRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 3, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smCodeRowStatus.setDescription("A control that allows entries to be added and removed from\nthis table.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.")
smRunObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 64, 1, 4))
smLaunchTable = MibTable((1, 3, 6, 1, 2, 1, 64, 1, 4, 1))
if mibBuilder.loadTexts: smLaunchTable.setDescription("This table lists and describes scripts that are ready\nto be executed together with their parameters.")
smLaunchEntry = MibTableRow((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1)).setIndexNames((0, "DISMAN-SCRIPT-MIB", "smLaunchOwner"), (0, "DISMAN-SCRIPT-MIB", "smLaunchName"))
if mibBuilder.loadTexts: smLaunchEntry.setDescription("An entry describing a particular executable script.")
smLaunchOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smLaunchOwner.setDescription("The manager who owns this row in the smLaunchTable. Every\ninstance of a running script started from a particular entry\nin the smLaunchTable (i.e. entries in the smRunTable) will\nbe owned by the same smLaunchOwner used to index the entry\nin the smLaunchTable. This owner is not necessarily the same\nas the owner of the script itself (smLaunchScriptOwner).")
smLaunchName = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smLaunchName.setDescription("The locally-unique, administratively assigned name for this\nlaunch table entry. This object allows an smLaunchOwner to\nhave multiple entries in the smLaunchTable. The smLaunchName\nis an arbitrary name that must be different from any other\nsmLaunchTable entries with the same smLaunchOwner but can be\nthe same as other entries in the smLaunchTable with\ndifferent smLaunchOwner values. Note that the value of\nsmLaunchName is not related in any way to the name of the\nscript being launched.")
smLaunchScriptOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchScriptOwner.setDescription("The value of this object in combination with the value of\nsmLaunchScriptName identifies the script that can be\nlaunched from this smLaunchTable entry. Attempts to write\nthis object will fail with an inconsistentValue error if\nthe value of smLaunchOperStatus is `enabled'.")
smLaunchScriptName = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 4), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32)).clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchScriptName.setDescription("The value of this object in combination with the value of\nthe smLaunchScriptOwner identifies the script that can be\nlaunched from this smLaunchTable entry. The zero-length\nstring may be used to point to a non-existing script.\n\nAttempts to write this object will fail with an\ninconsistentValue error if the value of smLaunchOperStatus\nis `enabled'.")
smLaunchArgument = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 5), OctetString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchArgument.setDescription("The argument supplied to the script. When a script is\ninvoked, the value of this object is used to initialize\nthe smRunArgument object.")
smLaunchMaxRunning = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchMaxRunning.setDescription("The maximum number of concurrently running scripts that may\nbe invoked from this entry in the smLaunchTable. Lowering\nthe current value of this object does not affect any scripts\nthat are already executing.")
smLaunchMaxCompleted = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchMaxCompleted.setDescription("The maximum number of finished scripts invoked from this\nentry in the smLaunchTable allowed to be retained in the\nsmRunTable. Whenever the value of this object is changed\nand whenever a script terminates, entries in the smRunTable\nare deleted if necessary until the number of completed\nscripts is smaller than the value of this object. Scripts\nwhose smRunEndTime value indicates the oldest completion\ntime are deleted first.")
smLaunchLifeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 8), TimeInterval().clone('360000')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchLifeTime.setDescription("The default maximum amount of time a script launched\nfrom this entry may run. The value of this object is used\nto initialize the smRunLifeTime object when a script is\nlaunched. Changing the value of an smLaunchLifeTime\ninstance does not affect scripts previously launched from\n\n\nthis entry.")
smLaunchExpireTime = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 9), TimeInterval().clone('360000')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchExpireTime.setDescription("The default maximum amount of time information about a\nscript launched from this entry is kept in the smRunTable\nafter the script has completed execution.  The value of\nthis object is used to initialize the smRunExpireTime\nobject when a script is launched. Changing the value of an\nsmLaunchExpireTime instance does not affect scripts\npreviously launched from this entry.")
smLaunchStart = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchStart.setDescription("This object is used to start the execution of scripts.\nWhen retrieved, the value will be the value of smRunIndex\nfor the last script that started execution by manipulating\nthis object. The value will be zero if no script started\nexecution yet.\n\nA script is started by setting this object to an unused\nsmRunIndex value. A new row in the smRunTable will be\ncreated which is indexed by the value supplied by the\nset-request in addition to the value of smLaunchOwner and\nsmLaunchName. An unused value can be obtained by reading\nthe smLaunchRunIndexNext object.\n\nSetting this object to the special value 0 will start\nthe script with a self-generated smRunIndex value. The\nconsequence is that the script invoker has no reliable\nway to determine the smRunIndex value for this script\ninvocation and that the invoker has therefore no way\nto obtain the results from this script invocation. The\nspecial value 0 is however useful for scheduled script\ninvocations.\n\nIf this object is set, the following checks must be\n\n\nperformed:\n\n1) The value of the smLaunchOperStatus object in this\n   entry of the smLaunchTable must be `enabled'.\n2) The values of smLaunchScriptOwner and\n   smLaunchScriptName of this row must identify an\n   existing entry in the smScriptTable.\n3) The value of smScriptOperStatus of this entry must\n   be `enabled'.\n4) The principal performing the set operation must have\n   read access to the script. This must be checked by\n   calling the isAccessAllowed abstract service interface\n   defined in RFC 2271 on the row in the smScriptTable\n   identified by smLaunchScriptOwner and smLaunchScriptName.\n   The isAccessAllowed abstract service interface must be\n   called on all columnar objects in the smScriptTable with\n   a MAX-ACCESS value different than `not-accessible'. The\n   test fails as soon as a call indicates that access is\n   not allowed.\n5) If the value provided by the set operation is not 0,\n   a check must be made that the value is currently not\n   in use. Otherwise, if the value provided by the set\n   operation is 0, a suitable unused value must be\n   generated.\n6) The number of currently executing scripts invoked\n   from this smLaunchTable entry must be less than\n   smLaunchMaxRunning.\n\nAttempts to start a script will fail with an\ninconsistentValue error if one of the checks described\nabove fails.\n\nOtherwise, if all checks have been passed, a new entry\nin the smRunTable will be created indexed by smLaunchOwner,\nsmLaunchName and the new value for smRunIndex. The value\nof smLaunchArgument will be copied into smRunArgument,\nthe value of smLaunchLifeTime will be copied to\nsmRunLifeTime, and the value of smLaunchExpireTime\nwill be copied to smRunExpireTime.\n\nThe smRunStartTime will be set to the current time and\nthe smRunState will be set to `initializing' before the\nscript execution is initiated in the appropriate runtime\nsystem.\n\nNote that the data type and the range of this object must\nbe consistent with the smRunIndex object. Since this\nobject might be written from the scheduling MIB, the\n\n\ndata type Integer32 rather than Unsigned32 is used.")
smLaunchControl = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,4,3,)).subtype(namedValues=NamedValues(("abort", 1), ("suspend", 2), ("resume", 3), ("nop", 4), )).clone(4)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchControl.setDescription("This object is used to request a state change for all\nrunning scripts in the smRunTable that were started from\nthis row in the smLaunchTable.\n\nSetting this object to abort(1), suspend(2) or resume(3)\nwill set the smRunControl object of all applicable rows\nin the smRunTable to abort(1), suspend(2) or resume(3)\nrespectively. The phrase `applicable rows' means the set of\nrows which were created from this entry in the smLaunchTable\nand whose value of smRunState allows the corresponding\nstate change as described in the definition of the\nsmRunControl object. Setting this object to nop(4) has no\neffect.\n\nAttempts to set this object lead to an inconsistentValue\nerror only if all implicated sets on all the applicable\nrows lead to inconsistentValue errors. It is not allowed\nto return an inconsistentValue error if at least one state\nchange on one of the applicable rows was successful.")
smLaunchAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ("autostart", 3), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchAdminStatus.setDescription("The value of this object indicates the desired status of\nthis launch table entry. The values enabled(1) and\nautostart(3) both indicate that the launch table entry\n\n\nshould transition into the operational enabled(1) state as\nsoon as the associated script table entry is enabled(1).\n\nThe value autostart(3) further indicates that the script\nis started automatically by conceptually writing the\nvalue 0 into the associated smLaunchStart object during\nthe transition from the `disabled' into the `enabled'\noperational state. This is useful for scripts that are\nto be launched on system start-up.")
smLaunchOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 13), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ("expired", 3), )).clone(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: smLaunchOperStatus.setDescription("The value of this object indicates the actual status of\nthis launch table entry.  The smLaunchOperStatus object\nmay have the following values:\n\n- `enabled' indicates that the launch table entry is\n  available and can be used to start scripts.\n\n- `disabled' indicates that the launch table entry can\n  not be used to start scripts.\n\n- `expired' indicates that the launch table entry can\n  not be used to start scripts and will disappear as\n  soon as all smRunTable entries associated with this\n  launch table entry have disappeared.\n\nThe value `enabled' requires that the smLaunchRowStatus\nobject is active. The value `disabled' requires that there\nare no entries in the smRunTable associated with this\nsmLaunchTable entry.")
smLaunchRunIndexNext = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: smLaunchRunIndexNext.setDescription("This variable is used for creating rows in the smRunTable.\nThe value of this variable is a currently unused value\nfor smRunIndex, which can be written into the smLaunchStart\nobject associated with this row to launch a script.\n\nThe value returned when reading this variable must be unique\nfor the smLaunchOwner and smLaunchName associated with this\nrow. Subsequent attempts to read this variable must return\ndifferent values.\n\nThis variable will return the special value 0 if no new rows\ncan be created.\n\nNote that the data type and the range of this object must be\nconsistent with the definition of smRunIndex.")
smLaunchStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 15), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchStorageType.setDescription("This object defines if this row is kept in volatile storage\nand lost upon reboot or if this row is backed up by stable\nstorage.\n\nThe value of smLaunchStorageType is only meaningful if the\nvalue of the corresponding RowStatus object is active.\n\nIf smLaunchStorageType has the value permanent(4), then all\nobjects whose MAX-ACCESS value is read-create must be\nwritable, with the exception of the smLaunchStorageType and\nsmLaunchRowStatus objects, which shall be read-only.")
smLaunchRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 16), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchRowStatus.setDescription("A control that allows entries to be added and removed from\nthis table.\n\nAttempts to `destroy' a row or to set a row `notInService'\nwhile the smLaunchOperStatus is `enabled' will result in\nan inconsistentValue error.\n\n\n\nAttempts to `destroy' a row or to set a row `notInService'\nwhere the value of the smLaunchStorageType object is\n`permanent' or `readOnly' will result in an\ninconsistentValue error.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.")
smLaunchError = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 17), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smLaunchError.setDescription("This object contains a descriptive error message if an\nattempt to launch a script fails. Implementations must reset\nthe error message to a zero-length string when a new attempt\nto launch a script is started.")
smLaunchLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 18), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smLaunchLastChange.setDescription("The date and time when this launch table entry was last\nmodified. The value '0000000000000000'H is returned if\nthe launch table entry has not yet been modified.\n\nNote that a change of smLaunchStart, smLaunchControl,\nsmLaunchRunIndexNext, smLaunchRowExpireTime, or the\nresetting of smLaunchError is not considered a change\nof this launch table entry.")
smLaunchRowExpireTime = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 19), TimeInterval().clone('2147483647')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smLaunchRowExpireTime.setDescription("The value of this object specifies how long this row remains\nin the `enabled' or `disabled' operational state. The value\nreported by this object ticks backwards. When the value\nreaches 0, it stops ticking backward and the row is\ndeleted if there are no smRunTable entries associated with\n\n\nthis smLaunchTable entry. Otherwise, the smLaunchOperStatus\nchanges to `expired' and the row deletion is deferred\nuntil there are no smRunTable entries associated with this\nsmLaunchTable entry.\n\nThe smLaunchRowExpireTime will not tick backwards if it is\nset to its maximum value (2147483647). In other words,\nsetting this object to its maximum value turns the timer\noff.\n\nThe value of this object may be set in order to increase\nor reduce the remaining time that the launch table entry\nmay be used. Setting the value to 0 will cause an immediate\nrow deletion or transition into the `expired' operational\nstate.\n\nIt is not possible to set this object while the operational\nstatus is `expired'. Attempts to modify this object while\nthe operational status is `expired' leads to an\ninconsistentValue error.\n\nNote that the timer ticks backwards independent of the\noperational state of the launch table entry.")
smRunTable = MibTable((1, 3, 6, 1, 2, 1, 64, 1, 4, 2))
if mibBuilder.loadTexts: smRunTable.setDescription("This table lists and describes scripts that are currently\nrunning or have been running in the past.")
smRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1)).setIndexNames((0, "DISMAN-SCRIPT-MIB", "smLaunchOwner"), (0, "DISMAN-SCRIPT-MIB", "smLaunchName"), (0, "DISMAN-SCRIPT-MIB", "smRunIndex"))
if mibBuilder.loadTexts: smRunEntry.setDescription("An entry describing a particular running or finished\nscript.")
smRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smRunIndex.setDescription("The locally arbitrary, but unique identifier associated\nwith this running or finished script. This value must be\nunique for all rows in the smRunTable with the same\nsmLaunchOwner and smLaunchName.\n\nNote that the data type and the range of this object must\nbe consistent with the definition of smLaunchRunIndexNext\nand smLaunchStart.")
smRunArgument = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 2), OctetString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smRunArgument.setDescription("The argument supplied to the script when it started.")
smRunStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 3), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smRunStartTime.setDescription("The date and time when the execution started. The value\n'0000000000000000'H is returned if the script has not\nstarted yet.")
smRunEndTime = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 4), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smRunEndTime.setDescription("The date and time when the execution terminated. The value\n'0000000000000000'H is returned if the script has not\nterminated yet.")
smRunLifeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 5), TimeInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: smRunLifeTime.setDescription("This object specifies how long the script can execute.\nThis object returns the remaining time that the script\nmay run. The object is initialized with the value of the\nassociated smLaunchLifeTime object and ticks backwards.\nThe script is aborted immediately when the value reaches 0.\n\nThe value of this object may be set in order to increase or\nreduce the remaining time that the script may run. Setting\nthis value to 0 will abort script execution immediately,\nand, if the value of smRunExpireTime is also 0, will remove\nthis entry from the smRunTable once it has terminated.\n\nIf smRunLifeTime is set to its maximum value (2147483647),\neither by a set operation or by its initialization from the\nsmLaunchLifeTime object, then it will not tick backwards.\nA running script with a maximum smRunLifeTime value will\nthus never be terminated with a `lifeTimeExceeded' exit\ncode.\n\nThe value of smRunLifeTime reflects the real-time execution\ntime as seen by the outside world. The value of this object\nwill always be 0 for a script that finished execution, that\nis smRunState has the value `terminated'.\n\nThe value of smRunLifeTime does not change while a script\nis suspended, that is smRunState has the value `suspended'.\nNote that this does not affect set operations. It is legal\nto modify smRunLifeTime via set operations while a script\nis suspended.")
smRunExpireTime = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 6), TimeInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: smRunExpireTime.setDescription("The value of this object specifies how long this row can\nexist in the smRunTable after the script has terminated.\nThis object returns the remaining time that the row may\nexist before it is aged out. The object is initialized with\nthe value of the associated smLaunchExpireTime object and\nticks backwards. The entry in the smRunTable is destroyed\nwhen the value reaches 0 and the smRunState has the value\n`terminated'.\n\nThe value of this object may be set in order to increase or\nreduce the remaining time that the row may exist.  Setting\nthe value to 0 will destroy this entry as soon as the\nsmRunState has the value `terminated'.")
smRunExitCode = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,5,6,7,4,3,8,9,)).subtype(namedValues=NamedValues(("noError", 1), ("halted", 2), ("lifeTimeExceeded", 3), ("noResourcesLeft", 4), ("languageError", 5), ("runtimeError", 6), ("invalidArgument", 7), ("securityViolation", 8), ("genericError", 9), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: smRunExitCode.setDescription("The value of this object indicates the reason why a\nscript finished execution. The smRunExitCode code may have\none of the following values:\n\n- `noError', which indicates that the script completed\n   successfully without errors;\n\n- `halted', which indicates that the script was halted\n   by a request from an authorized manager;\n\n- `lifeTimeExceeded', which indicates that the script\n   exited because a time limit was exceeded;\n\n\n- `noResourcesLeft', which indicates that the script\n   exited because it ran out of resources (e.g. memory);\n\n- `languageError', which indicates that the script exited\n   because of a language error (e.g. a syntax error in an\n   interpreted language);\n\n- `runtimeError', which indicates that the script exited\n   due to a runtime error (e.g. a division by zero);\n\n- `invalidArgument', which indicates that the script could\n   not be run because of invalid script arguments;\n\n- `securityViolation', which indicates that the script\n   exited due to a security violation;\n\n- `genericError', which indicates that the script exited\n   for an unspecified reason.\n\nIf the script has not yet begun running, or is currently\nrunning, the value will be `noError'.")
smRunResult = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 8), OctetString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smRunResult.setDescription("The result value produced by the running script. Note that\nthe result may change while the script is executing.")
smRunControl = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,4,3,)).subtype(namedValues=NamedValues(("abort", 1), ("suspend", 2), ("resume", 3), ("nop", 4), )).clone(4)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: smRunControl.setDescription("The value of this object indicates the desired status of the\nscript execution defined by this row.\n\nSetting this object to `abort' will abort execution if the\n\n\nvalue of smRunState is `initializing', `executing',\n`suspending', `suspended' or `resuming'. Setting this object\nto `abort' when the value of smRunState is `aborting' or\n`terminated', or if the implementation can determine that\nthe attempt to abort the execution would fail, will result\nin an inconsistentValue error.\n\nSetting this object to `suspend' will suspend execution\nif the value of smRunState is `executing'. Setting this\nobject to `suspend' will cause an inconsistentValue error\nif the value of smRunState is not `executing' or if the\nimplementation can determine that the attempt to suspend\nthe execution would fail.\n\nSetting this object to `resume' will resume execution\nif the value of smRunState is `suspending' or\n`suspended'. Setting this object to `resume' will cause an\ninconsistentValue error if the value of smRunState is\nnot `suspended' or if the implementation can determine\nthat the attempt to resume the execution would fail.\n\nSetting this object to nop(4) has no effect.")
smRunState = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(2,6,5,4,1,7,3,)).subtype(namedValues=NamedValues(("initializing", 1), ("executing", 2), ("suspending", 3), ("suspended", 4), ("resuming", 5), ("aborting", 6), ("terminated", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: smRunState.setDescription("The value of this object indicates the script's execution\nstate. If the script has been invoked but has not yet\nbegun execution, the value will be `initializing'. If the\nscript is running, the value will be `executing'.\n\nA running script which received a request to suspend\nexecution first transitions into a temporary `suspending'\nstate.  The temporary `suspending' state changes to\n`suspended' when the script has actually been suspended. The\ntemporary `suspending' state changes back to `executing' if\n\n\nthe attempt to suspend the running script fails.\n\nA suspended script which received a request to resume\nexecution first transitions into a temporary `resuming'\nstate. The temporary `resuming' state changes to `running'\nwhen the script has actually been resumed. The temporary\n`resuming' state changes back to `suspended' if the attempt\nto resume the suspended script fails.\n\nA script which received a request to abort execution but\nwhich is still running first transitions into a temporary\n`aborting' state.\n\nA script which has finished its execution is `terminated'.")
smRunError = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 11), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smRunError.setDescription("This object contains a descriptive error message if the\nscript startup or execution raised an abnormal condition.\nAn implementation must store a descriptive error message\nin this object if the script exits with the smRunExitCode\n`genericError'.")
smRunResultTime = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 12), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smRunResultTime.setDescription("The date and time when the smRunResult was last updated.\nThe value '0000000000000000'H is returned if smRunResult\nhas not yet been updated after the creation of this\nsmRunTable entry.")
smRunErrorTime = MibTableColumn((1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 13), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: smRunErrorTime.setDescription("The date and time when the smRunError was last updated.\nThe value '0000000000000000'H is returned if smRunError\n\n\nhas not yet been updated after the creation of this\nsmRunTable entry.")
smNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 64, 2))
smTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 64, 2, 0))
smConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 64, 3))
smCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 64, 3, 1))
smGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 64, 3, 2))

# Augmentions

# Notifications

smScriptAbort = NotificationType((1, 3, 6, 1, 2, 1, 64, 2, 0, 1)).setObjects(*(("DISMAN-SCRIPT-MIB", "smRunEndTime"), ("DISMAN-SCRIPT-MIB", "smRunExitCode"), ("DISMAN-SCRIPT-MIB", "smRunError"), ) )
if mibBuilder.loadTexts: smScriptAbort.setDescription("This notification is generated whenever a running script\nterminates with an smRunExitCode unequal to `noError'.")
smScriptResult = NotificationType((1, 3, 6, 1, 2, 1, 64, 2, 0, 2)).setObjects(*(("DISMAN-SCRIPT-MIB", "smRunResult"), ) )
if mibBuilder.loadTexts: smScriptResult.setDescription("This notification can be used by scripts to notify other\nmanagement applications about results produced by the\nscript.\n\nThis notification is not automatically generated by the\nScript MIB implementation. It is the responsibility of\nthe executing script to emit this notification where it\nis appropriate to do so.")
smScriptException = NotificationType((1, 3, 6, 1, 2, 1, 64, 2, 0, 3)).setObjects(*(("DISMAN-SCRIPT-MIB", "smRunError"), ) )
if mibBuilder.loadTexts: smScriptException.setDescription("This notification can be used by scripts to notify other\nmanagement applications about script errors.\n\nThis notification is not automatically generated by the\nScript MIB implementation. It is the responsibility of\nthe executing script or the runtime system to emit this\nnotification where it is appropriate to do so.")

# Groups

smLanguageGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 1)).setObjects(*(("DISMAN-SCRIPT-MIB", "smLangLanguage"), ("DISMAN-SCRIPT-MIB", "smExtsnVersion"), ("DISMAN-SCRIPT-MIB", "smExtsnDescr"), ("DISMAN-SCRIPT-MIB", "smExtsnVendor"), ("DISMAN-SCRIPT-MIB", "smExtsnExtension"), ("DISMAN-SCRIPT-MIB", "smLangRevision"), ("DISMAN-SCRIPT-MIB", "smLangDescr"), ("DISMAN-SCRIPT-MIB", "smLangVersion"), ("DISMAN-SCRIPT-MIB", "smExtsnRevision"), ("DISMAN-SCRIPT-MIB", "smLangVendor"), ) )
if mibBuilder.loadTexts: smLanguageGroup.setDescription("A collection of objects providing information about the\ncapabilities of the scripting engine.")
smScriptGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 2)).setObjects(*(("DISMAN-SCRIPT-MIB", "smScriptSource"), ("DISMAN-SCRIPT-MIB", "smScriptDescr"), ("DISMAN-SCRIPT-MIB", "smScriptOperStatus"), ("DISMAN-SCRIPT-MIB", "smScriptLanguage"), ("DISMAN-SCRIPT-MIB", "smScriptRowStatus"), ("DISMAN-SCRIPT-MIB", "smScriptAdminStatus"), ("DISMAN-SCRIPT-MIB", "smScriptStorageType"), ) )
if mibBuilder.loadTexts: smScriptGroup.setDescription("A collection of objects providing information about\ninstalled scripts.")
smCodeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 3)).setObjects(*(("DISMAN-SCRIPT-MIB", "smCodeRowStatus"), ("DISMAN-SCRIPT-MIB", "smCodeText"), ) )
if mibBuilder.loadTexts: smCodeGroup.setDescription("A collection of objects used to download or modify scripts\nby using SNMP set requests.")
smLaunchGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 4)).setObjects(*(("DISMAN-SCRIPT-MIB", "smLaunchLifeTime"), ("DISMAN-SCRIPT-MIB", "smLaunchScriptOwner"), ("DISMAN-SCRIPT-MIB", "smLaunchRowStatus"), ("DISMAN-SCRIPT-MIB", "smLaunchMaxRunning"), ("DISMAN-SCRIPT-MIB", "smLaunchArgument"), ("DISMAN-SCRIPT-MIB", "smLaunchStorageType"), ("DISMAN-SCRIPT-MIB", "smLaunchExpireTime"), ("DISMAN-SCRIPT-MIB", "smLaunchRunIndexNext"), ("DISMAN-SCRIPT-MIB", "smLaunchOperStatus"), ("DISMAN-SCRIPT-MIB", "smLaunchStart"), ("DISMAN-SCRIPT-MIB", "smLaunchScriptName"), ("DISMAN-SCRIPT-MIB", "smLaunchControl"), ("DISMAN-SCRIPT-MIB", "smLaunchAdminStatus"), ("DISMAN-SCRIPT-MIB", "smLaunchMaxCompleted"), ) )
if mibBuilder.loadTexts: smLaunchGroup.setDescription("A collection of objects providing information about scripts\nthat can be launched.")
smRunGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 5)).setObjects(*(("DISMAN-SCRIPT-MIB", "smRunEndTime"), ("DISMAN-SCRIPT-MIB", "smRunArgument"), ("DISMAN-SCRIPT-MIB", "smRunResult"), ("DISMAN-SCRIPT-MIB", "smRunError"), ("DISMAN-SCRIPT-MIB", "smRunStartTime"), ("DISMAN-SCRIPT-MIB", "smRunState"), ("DISMAN-SCRIPT-MIB", "smRunExpireTime"), ("DISMAN-SCRIPT-MIB", "smRunLifeTime"), ("DISMAN-SCRIPT-MIB", "smRunExitCode"), ("DISMAN-SCRIPT-MIB", "smRunControl"), ) )
if mibBuilder.loadTexts: smRunGroup.setDescription("A collection of objects providing information about running\nscripts.")
smNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 6)).setObjects(*(("DISMAN-SCRIPT-MIB", "smScriptResult"), ("DISMAN-SCRIPT-MIB", "smScriptAbort"), ) )
if mibBuilder.loadTexts: smNotificationsGroup.setDescription("The notifications emitted by the Script MIB.")
smScriptGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 7)).setObjects(*(("DISMAN-SCRIPT-MIB", "smScriptError"), ("DISMAN-SCRIPT-MIB", "smScriptOperStatus"), ("DISMAN-SCRIPT-MIB", "smScriptLanguage"), ("DISMAN-SCRIPT-MIB", "smScriptRowStatus"), ("DISMAN-SCRIPT-MIB", "smScriptSource"), ("DISMAN-SCRIPT-MIB", "smScriptAdminStatus"), ("DISMAN-SCRIPT-MIB", "smScriptLastChange"), ("DISMAN-SCRIPT-MIB", "smScriptDescr"), ("DISMAN-SCRIPT-MIB", "smScriptStorageType"), ) )
if mibBuilder.loadTexts: smScriptGroup2.setDescription("A collection of objects providing information about\ninstalled scripts.")
smLaunchGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 8)).setObjects(*(("DISMAN-SCRIPT-MIB", "smLaunchExpireTime"), ("DISMAN-SCRIPT-MIB", "smLaunchRunIndexNext"), ("DISMAN-SCRIPT-MIB", "smLaunchLifeTime"), ("DISMAN-SCRIPT-MIB", "smLaunchMaxCompleted"), ("DISMAN-SCRIPT-MIB", "smLaunchScriptOwner"), ("DISMAN-SCRIPT-MIB", "smLaunchError"), ("DISMAN-SCRIPT-MIB", "smLaunchOperStatus"), ("DISMAN-SCRIPT-MIB", "smLaunchStart"), ("DISMAN-SCRIPT-MIB", "smLaunchScriptName"), ("DISMAN-SCRIPT-MIB", "smLaunchRowStatus"), ("DISMAN-SCRIPT-MIB", "smLaunchControl"), ("DISMAN-SCRIPT-MIB", "smLaunchMaxRunning"), ("DISMAN-SCRIPT-MIB", "smLaunchRowExpireTime"), ("DISMAN-SCRIPT-MIB", "smLaunchLastChange"), ("DISMAN-SCRIPT-MIB", "smLaunchAdminStatus"), ("DISMAN-SCRIPT-MIB", "smLaunchArgument"), ("DISMAN-SCRIPT-MIB", "smLaunchStorageType"), ) )
if mibBuilder.loadTexts: smLaunchGroup2.setDescription("A collection of objects providing information about scripts\nthat can be launched.")
smRunGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 9)).setObjects(*(("DISMAN-SCRIPT-MIB", "smRunControl"), ("DISMAN-SCRIPT-MIB", "smRunLifeTime"), ("DISMAN-SCRIPT-MIB", "smRunResult"), ("DISMAN-SCRIPT-MIB", "smRunResultTime"), ("DISMAN-SCRIPT-MIB", "smRunStartTime"), ("DISMAN-SCRIPT-MIB", "smRunExpireTime"), ("DISMAN-SCRIPT-MIB", "smRunArgument"), ("DISMAN-SCRIPT-MIB", "smRunEndTime"), ("DISMAN-SCRIPT-MIB", "smRunError"), ("DISMAN-SCRIPT-MIB", "smRunState"), ("DISMAN-SCRIPT-MIB", "smRunErrorTime"), ("DISMAN-SCRIPT-MIB", "smRunExitCode"), ) )
if mibBuilder.loadTexts: smRunGroup2.setDescription("A collection of objects providing information about running\nscripts.")
smNotificationsGroup2 = NotificationGroup((1, 3, 6, 1, 2, 1, 64, 3, 2, 10)).setObjects(*(("DISMAN-SCRIPT-MIB", "smScriptResult"), ("DISMAN-SCRIPT-MIB", "smScriptAbort"), ("DISMAN-SCRIPT-MIB", "smScriptException"), ) )
if mibBuilder.loadTexts: smNotificationsGroup2.setDescription("The notifications emitted by the Script MIB.")

# Compliances

smCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 64, 3, 1, 1)).setObjects(*(("DISMAN-SCRIPT-MIB", "smRunGroup"), ("DISMAN-SCRIPT-MIB", "smLaunchGroup"), ("DISMAN-SCRIPT-MIB", "smLanguageGroup"), ("DISMAN-SCRIPT-MIB", "smCodeGroup"), ("DISMAN-SCRIPT-MIB", "smScriptGroup"), ) )
if mibBuilder.loadTexts: smCompliance.setDescription("The compliance statement for SNMP entities which implement\nthe Script MIB.")
smCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 64, 3, 1, 2)).setObjects(*(("DISMAN-SCRIPT-MIB", "smScriptGroup2"), ("DISMAN-SCRIPT-MIB", "smNotificationsGroup2"), ("DISMAN-SCRIPT-MIB", "smCodeGroup"), ("DISMAN-SCRIPT-MIB", "smLaunchGroup2"), ("DISMAN-SCRIPT-MIB", "smRunGroup2"), ("DISMAN-SCRIPT-MIB", "smLanguageGroup"), ) )
if mibBuilder.loadTexts: smCompliance2.setDescription("The compliance statement for SNMP entities which implement\nthe Script MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("DISMAN-SCRIPT-MIB", PYSNMP_MODULE_ID=scriptMIB)

# Objects
mibBuilder.exportSymbols("DISMAN-SCRIPT-MIB", scriptMIB=scriptMIB, smObjects=smObjects, smLangTable=smLangTable, smLangEntry=smLangEntry, smLangIndex=smLangIndex, smLangLanguage=smLangLanguage, smLangVersion=smLangVersion, smLangVendor=smLangVendor, smLangRevision=smLangRevision, smLangDescr=smLangDescr, smExtsnTable=smExtsnTable, smExtsnEntry=smExtsnEntry, smExtsnIndex=smExtsnIndex, smExtsnExtension=smExtsnExtension, smExtsnVersion=smExtsnVersion, smExtsnVendor=smExtsnVendor, smExtsnRevision=smExtsnRevision, smExtsnDescr=smExtsnDescr, smScriptObjects=smScriptObjects, smScriptTable=smScriptTable, smScriptEntry=smScriptEntry, smScriptOwner=smScriptOwner, smScriptName=smScriptName, smScriptDescr=smScriptDescr, smScriptLanguage=smScriptLanguage, smScriptSource=smScriptSource, smScriptAdminStatus=smScriptAdminStatus, smScriptOperStatus=smScriptOperStatus, smScriptStorageType=smScriptStorageType, smScriptRowStatus=smScriptRowStatus, smScriptError=smScriptError, smScriptLastChange=smScriptLastChange, smCodeTable=smCodeTable, smCodeEntry=smCodeEntry, smCodeIndex=smCodeIndex, smCodeText=smCodeText, smCodeRowStatus=smCodeRowStatus, smRunObjects=smRunObjects, smLaunchTable=smLaunchTable, smLaunchEntry=smLaunchEntry, smLaunchOwner=smLaunchOwner, smLaunchName=smLaunchName, smLaunchScriptOwner=smLaunchScriptOwner, smLaunchScriptName=smLaunchScriptName, smLaunchArgument=smLaunchArgument, smLaunchMaxRunning=smLaunchMaxRunning, smLaunchMaxCompleted=smLaunchMaxCompleted, smLaunchLifeTime=smLaunchLifeTime, smLaunchExpireTime=smLaunchExpireTime, smLaunchStart=smLaunchStart, smLaunchControl=smLaunchControl, smLaunchAdminStatus=smLaunchAdminStatus, smLaunchOperStatus=smLaunchOperStatus, smLaunchRunIndexNext=smLaunchRunIndexNext, smLaunchStorageType=smLaunchStorageType, smLaunchRowStatus=smLaunchRowStatus, smLaunchError=smLaunchError, smLaunchLastChange=smLaunchLastChange, smLaunchRowExpireTime=smLaunchRowExpireTime, smRunTable=smRunTable, smRunEntry=smRunEntry, smRunIndex=smRunIndex, smRunArgument=smRunArgument, smRunStartTime=smRunStartTime, smRunEndTime=smRunEndTime, smRunLifeTime=smRunLifeTime, smRunExpireTime=smRunExpireTime, smRunExitCode=smRunExitCode, smRunResult=smRunResult, smRunControl=smRunControl, smRunState=smRunState, smRunError=smRunError, smRunResultTime=smRunResultTime, smRunErrorTime=smRunErrorTime, smNotifications=smNotifications, smTraps=smTraps, smConformance=smConformance, smCompliances=smCompliances, smGroups=smGroups)

# Notifications
mibBuilder.exportSymbols("DISMAN-SCRIPT-MIB", smScriptAbort=smScriptAbort, smScriptResult=smScriptResult, smScriptException=smScriptException)

# Groups
mibBuilder.exportSymbols("DISMAN-SCRIPT-MIB", smLanguageGroup=smLanguageGroup, smScriptGroup=smScriptGroup, smCodeGroup=smCodeGroup, smLaunchGroup=smLaunchGroup, smRunGroup=smRunGroup, smNotificationsGroup=smNotificationsGroup, smScriptGroup2=smScriptGroup2, smLaunchGroup2=smLaunchGroup2, smRunGroup2=smRunGroup2, smNotificationsGroup2=smNotificationsGroup2)

# Compliances
mibBuilder.exportSymbols("DISMAN-SCRIPT-MIB", smCompliance=smCompliance, smCompliance2=smCompliance2)
