% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createProject.R
\name{createProject}
\alias{createProject}
\title{Create a new project}
\usage{
createProject(
  project,
  owners,
  uploaders = list(),
  baseline = NULL,
  growth = NULL,
  year = NULL,
  url = restUrl(),
  token = accessToken()
)
}
\arguments{
\item{project}{String containing the project name.}

\item{owners}{Character vector containing the GitHub users or organizations that are owners of this project.}

\item{uploaders}{List specifying the authorized uploaders for this project.
See the \code{uploaders} field in the \code{\link{fetchPermissions}} return value for the expected format.}

\item{baseline}{Numeric scalar specifying the baseline quota in bytes.
If \code{NULL}, the backend's default is used.}

\item{growth}{Numeric scalar specifying the quota's annual growth rate in bytes.
If \code{NULL}, the backend's default is used.}

\item{year}{Integer scalar specifying the year of the project creation.
If \code{NULL}, the backend's default is used - this should be the current year.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{token}{String containing a GitHub access token to authenticate to the gypsum REST API.
The token must refer to a gypsum administrator account.}
}
\value{
\code{NULL} is invisibly returned if the project was successfully created.
}
\description{
Create a new project with the associated permissions.
}
\examples{
if (interactive()) {
    createProject(
        "test-R-create", 
        owners="LTLA", 
        uploaders=list(list(id="ArtifactDB-bot"))
    )
}
}
\seealso{
\code{\link{removeProject}}, to remove a project.
}
\author{
Aaron Lun
}
