% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_weights.R
\name{plot_weights_heatmap}
\alias{plot_weights_heatmap}
\title{Plot heatmap of the weights}
\usage{
plot_weights_heatmap(
  object,
  view = 1,
  features = "all",
  factors = "all",
  threshold = 0,
  ...
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{view}{character vector with the view name(s), or numeric vector with the index of the view(s) to use. 
Default is the first view.}

\item{features}{character vector with the feature name(s), or numeric vector with the index of the feature(s) to use. 
Default is 'all'.}

\item{factors}{character vector with the factor name(s), or numeric vector with the index of the factor(s) to use. 
Default is 'all'.}

\item{threshold}{threshold on absolute weight values, so that weights with a magnitude below this threshold (in all factors) are removed}

\item{...}{extra arguments passed to \code{\link[pheatmap]{pheatmap}}.}
}
\value{
A \code{\link{pheatmap}} object
}
\description{
Function to visualize the weights for a given set of factors in a given view. \cr 
This is useful to visualize the overall pattern of the weights but not to individually characterise the factors. \cr
To inspect the weights of individual factors, use the functions \code{\link{plot_weights}} and \code{\link{plot_top_weights}}
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
plot_weights_heatmap(model)
}
