\name{EBMTP-class}
\alias{EBMTP-class}
\alias{EBMTP-method}

\title{Class "EBMTP", classes and methods for empirical Bayes multiple testing procedure output}

\description{An object of class EBMTP is the output of a particular multiple testing procedure, as generated by the function \code{EBMTP}. The object has slots for the various data used to make multiple testing decisions, in particular adjusted p-values.}

\section{Objects from the Class}{
Objects can be created by calls of the form \cr
new('MTP', \cr
	statistic = ...., object of class numeric\cr
	estimate  = ...., object of class numeric\cr
	sampsize  = ...., object of class numeric\cr
	rawp      = ...., object of class numeric\cr
	adjp      = ...., object of class numeric\cr
 	reject	  = ...., object of class matrix\cr
	rawdist	  = ...., object of class matrix\cr
        nulldist  = ...., object of class matrix\cr
	nulldist.type = ...., object of class character\cr
	marg.null = ...., object of class character\cr
	marg.par  = ...., object of class matrix\cr
	label	  = ...., object of class numeric\cr
	falsepos  = ...., object of class matrix\cr
        truepos   = ...., object of class matrix\cr
        errormat  = ...., object of class matrix\cr 
        EB.h0M    = ...., object of class numeric\cr
        prior     = ...., object of class numeric\cr
        prior.type= ...., object of class character\cr
        lqv       = ...., object of class numeric\cr
	Hsets	  = ...., object of class matrix\cr
	index	  = ...., object of class matrix\cr
        call      = ...., object of class call\cr
        seed      = ...., object of class integer\cr
       )
}

\section{Slots}{
\describe{
  \item{\code{statistic}}{Object of class \code{numeric}, observed test statistics for each hypothesis, specified by the values of the \code{MTP} arguments \code{test}, \code{robust}, \code{standardize}, and \code{psi0}.}
    \item{\code{estimate}}{For the test of single-parameter null hypotheses using t-statistics (i.e., not the F-tests), the numeric vector of estimated parameters corresponding to each hypothesis, e.g. means, differences in means, regression parameters.}
    \item{\code{sampsize}}{Object of class \code{numeric}, number of columns (i.e. observations) in the input data set.}
    \item{\code{rawp}}{Object of class \code{numeric}, unadjusted, marginal p-values for each hypothesis.}
    \item{\code{adjp}}{Object of class \code{numeric}, adjusted (for multiple testing) p-values for each hypothesis (computed only if the \code{get.adjp} argument is TRUE).}
   \item{\code{reject}}{Object of class \code{'matrix'}, rejection indicators (TRUE for a rejected null hypothesis), for each value of the nominal Type I error rate \code{alpha}.}
    \item{\code{rawdist}}{The numeric matrix for the estimated nonparametric non-null test statistics distribution (returned only if \code{keep.rawdist=TRUE} and if \code{nulldist} is one of 'boot.ctr', 'boot.cs', or 'boot.qt'). This slot must not be empty if one wishes to call \code{update} to change choice of bootstrap-based null distribution.}
    \item{\code{nulldist}}{The numeric matrix for the estimated test statistics null distribution (returned only if \code{keep.nulldist=TRUE}). By default (i.e., for \code{nulldist='boot.cs'}), the entries of \code{nulldist} are the null value shifted and scaled bootstrap test statistics, with one null test statistic value for each hypothesis (rows) and bootstrap iteration (columns).}
    \item{\code{nulldist.type}}{Character value describing which choice of null distribution was used to generate the MTP results.  Takes on one of the values of the original \code{nulldist} argument in the call to MTP, i.e., 'boot.cs', 'boot.ctr', 'boot.qt', or 'ic'.}
   \item{\code{marg.null}}{If \code{nulldist='boot.qt'}, a character value returning which choice of marginal null distribution was used by the MTP.  Can be used to check default values or to ensure manual settings were correctly applied.}
   \item{\code{marg.par}}{If \code{nulldist='boot.qt'}, a numeric matrix returning the parameters of the marginal null distribution(s) used by the MTP.  Can be used to check default values or to ensure manual settings were correctly applied.}
   \item{\code{falsepos}}{A matrix with rows equal to the number of hypotheses and columns the number of samples of null test statistics (\code{B}) indicating the number of guessed false positives when using the corresponding value of the observed test statistic as a cut-off.  Not returned unless \code{keep.falsepos=TRUE}.}
   \item{\code{truepos}}{A matrix with rows equal to the number of hypotheses and columns the number of samples of null test statistics (\code{B}) indicating the number of guessed true positives when using the corresponding value of the observed test statistic as a cut-off.  Not returned unless \code{keep.truepos=TRUE}.}
   \item{\code{errormat}}{The matrix obtained after applying to type I error rate function closure to the matrices in \code{falsepos}, and, if applicable, \code{truepos}.  Not returned unless \code{keep.errormat=TRUE}.}
   \item{\code{EB.h0M}}{The sum of the local q-values obtained after density estimation.  This number serves as an estimate of the proportion of true null hypotheses.  Values close to one indicate situations in which type I error control may not be guaranteed by the EBMTP.  When \code{prior='EBLQV'}, this value is used as the prior 'pi' during evaluation of the local q-value function.} 
   \item{\code{prior}}{The numeric value of the prior 'pi' used when evaluating the local q-value function.}
   \item{\code{prior.type}}{Character string returning the value of \code{prior} in the original call to \code{EBMTP}.  One of 'conservative', 'ABH', or 'EBLQV'.}
   \item{\code{lqv}}{A numeric vector of length the number of hypotheses with the estimated local q-values used for generating guessed sets of true null hypotheses.}
   \item{\code{Hsets}}{A numeric matrix with the same dimension as \code{nulldist}, containing the Bernoulli realizations of the estimated local q-values stored in \code{lqv} which were used to partition the hypotheses into guessed sets of true and false null hypotheses at each round of (re)sampling.  Not returned unless \code{keep.Hsets=TRUE}.}
   \item{\code{label}}{If \code{keep.label=TRUE}, a vector storing the values used in the argument \code{Y}.  Storing this object is particularly important when one wishes to update EBMTP objects with F-statistics using default \code{marg.null} and \code{marg.par} settings when \code{nulldist='boot.qt'}. }
   \item{\code{index}}{For tests of correlation parameters a matrix corresponding to \code{t(combn(p,2))}, where \code{p} is the number of variables in \code{X}.  This matrix gives the indices of the variables considered in each pairwise correlation.  For all other tests, this slot is empty, as the indices are in the same order as the rows of \code{X}.}
   \item{\code{call}}{Object of class \code{call}, the call to the MTP function.}
    \item{\code{seed}}{An integer or vector for specifying the state of the random number generator used to create the resampled datasets. The seed can be reused for reproducibility in a repeat call to \code{MTP}. This argument is currently used only for the bootstrap null distribution (i.e., for \code{nulldist="boot.xx"}). See \code{?set.seed} for details.}
	}
}

\section{Methods}{
 \code{signature(x = "EBMTP")} \cr
 \describe{
    \item{[}{: Subsetting method for \code{EBMTP} class, which operates selectively on each slot of an \code{EBMTP} instance to retain only the data related to the specified hypotheses.}

    \item{as.list}{: Converts an object of class \code{EBMTP} to an object of class \code{list}, with an entry for each slot.}
 
   \item{plot}{: plot methods for \code{EBMTP} class, produces the following graphical summaries of the results of a EBMTP. The type of display may be specified via the \code{which} argument. \cr

1. Scatterplot of number of rejected hypotheses vs. nominal Type I error rate. \cr

2. Plot of ordered adjusted p-values; can be viewed as a plot of Type I error rate vs. number of rejected hypotheses. \cr

3. Scatterplot of adjusted p-values vs. test statistics (also known as "volcano plot"). \cr

4. Plot of unordered adjusted p-values. \cr

The plot method for objects of class \code{EBMTP} does not return the plots associated with \code{which=5} (using confidence regions) or with \code{which=6} (pertaining to cut-offs) as it does for objects of class \code{MTP}.  This is because the function \code{EBMTP} currently only returns adjusted p-values.  The argument \code{logscale} (by default equal to FALSE) allows one to use the negative decimal logarithms of the adjusted p-values in the second, third, and fourth graphical displays. The arguments \code{caption} and \code{sub.caption} allow one to change the titles and subtitles for each of the plots (default subtitle is the MTP function call). Note that some of these plots are implemented in the older function \code{mt.plot}.}

    \item{print}{: print method for \code{EBMTP} class, returns a description of an object of class \code{EBMTP}, including sample size, number of tested hypotheses, type of test performed (value of argument \code{test}), Type I error rate (value of argument \code{typeone}), nominal level of the test  (value of argument \code{alpha}), name of the EBMTP (value of argument \code{method}), call to the function \code{EBMTP}.

In addition, this method produces a table with the class, mode, length, and dimension of each slot of the \code{EBMTP} instance. 
}

    \item{summary}{: summary method for \code{EBMTP} class, provides numerical summaries of the results of an EBMTP and returns a list with the following three components. \cr

1. rejections: A data.frame with the number(s) of rejected hypotheses for the nominal Type I error rate(s) specified by the \code{alpha} argument of the function \code{MTP}. \cr

2. index: A numeric vector of indices for ordering the hypotheses according to first \code{adjp}, then \code{rawp}, and finally the absolute value of \code{statistic} (not printed in the summary). \cr 

3. summaries: When applicable (i.e., when the corresponding quantities are returned by \code{MTP}), a table with six number summaries of the distributions of the adjusted p-values, unadjusted p-values, test statistics, and parameter estimates.}

    \item{EBupdate}{: update method for \code{EBMTP} class, provides a mechanism to re-run the MTP with different choices of the following arguments - nulldist, alternative, typeone, k, q, alpha, smooth.null, bw, kernel, prior, keep.nulldist, keep.rawdist, keep.falsepos, keep.truepos, keep.errormat, keep.margpar. When evaluate is 'TRUE', a new object of class EBMTP is returned. Else, the updated call is returned. The \code{EBMTP} object passed to the update method must have either a  non-empty \code{rawdist} slot or a non-empty \code{nulldist} slot (i.e., must have been called with either 'keep.rawdist=TRUE' or 'keep.nulldist=TRUE').  \cr

Additionally, when calling \code{EBupdate} for any Type I error rate other than FWER, the \code{typeone} argument must be specified (even if the original object did not control FWER). For example, 
\code{typeone="fdr"}, would always have to be specified, even if the original object also controlled the FDR. In other words, for all function arguments, it is safest to always assume that you 
are updating from the \code{EBMTP} default function settings, regardless of the original call to the \code{EBMTP} function. Currently, the main advantage of the \code{EBupdate} method is that it prevents the need for repeated estimation of the test statistics null distribution. \cr 

To save on memory, if one knows ahead of time that one will want to compare different choices of bootstrap-based null distribution, then it is both necessary and sufficient to specify 'keep.rawdist=TRUE', as there is no other means of moving between null distributions other than through the non-transformed non-parametric bootstrap distribution.  In this case, 'keep.nulldist=FALSE' may be used.  Specifically, if an object of class \code{EBMTP} contains a non-empty \code{rawdist} slot and an empty \code{nulldist} slot, then a new null distribution will be generated according to the values of the \code{nulldist=} argument in the original call to \code{EBMTP} or any additional specifications in the call to \code{update}. On the other hand, if one knows that one wishes to only update an \code{EBMTP} object in ways which do not involve choice of null distribution, then 'keep.nulldist=TRUE' will suffice and 'keep.rawdist' can be set to \code{FALSE} (default settings).  The original null distribution object will then be used for all subsequent calls to \code{update}. \cr

N.B.: Note that \code{keep.rawdist=TRUE} is only available for the bootstrap-based resampling methods.  The non-null distribution does not exist for the permutation or influence curve multivariate normal null distributions. }

    \item{ebmtp2mtp}{: coersion method for converting objects of class \code{EBMTP} to objects of class \code{MTP}.  Slots common to both objects are taken from the object of class \code{EBMTP} and used to create a new object of class \code{MTP}.  Once an object of class \code{MTP} is created, one may use the method \code{update} to perform resampling-based multiple testing (as would have been done with calls to \code{MTP}) without the need for repeated resampling.}
}
}


\references{
H.N. Gilbert, K.S. Pollard, M.J. van der Laan, and S. Dudoit (2009). Resampling-based multiple 
hypothesis testing with applications to genomics: New developments in R/Bioconductor 
package multtest. \emph{Journal of Statistical Software} (submitted). Temporary URL: \url{http://www.stat.berkeley.edu/~houston/JSSNullDistEBMTP.pdf}.\cr

Y. Benjamini and Y. Hochberg (2000). On the adaptive control of the false 
discovery rate in multiple testing with independent statistics. \emph{J. Behav. Educ. Statist}. Vol 25: 60-83.\cr

Y. Benjamini, A. M. Krieger and D. Yekutieli (2006). Adaptive linear step-up
procedures that control the false discovery rate. \emph{Biometrika}. 
Vol. 93: 491-507.\cr

M.J. van der Laan, M.D. Birkner, and A.E. Hubbard (2005).  Empirical Bayes and Resampling Based Multiple Testing Procedure Controlling the Tail Probability of the Proportion of False Positives. Statistical Applications in Genetics and Molecular Biology, 4(1).
\url{http://www.bepress.com/sagmb/vol4/iss1/art29/} \cr

S. Dudoit and M.J. van der Laan.  Multiple Testing Procedures and Applications to Genomics.  Springer Series in Statistics. Springer, New York, 2008. \cr

S. Dudoit, H. N. Gilbert, and M. J. van der Laan (2008). 
Resampling-based empirical Bayes multiple testing procedures for controlling 
generalized tail probability and expected value error rates: Focus on the false discovery rate and simulation study. \emph{Biometrical Journal}, 50(5):716-44. \url{http://www.stat.berkeley.edu/~houston/BJMCPSupp/BJMCPSupp.html}. \cr

H.N. Gilbert, M.J. van der Laan, and S. Dudoit. Joint multiple testing procedures for 
graphical model selection with applications to biological networks. Technical report, 
U.C. Berkeley Division of Biostatistics Working Paper Series, April 2009. URL \url{http://www.bepress.com/ucbbiostat/paper245}. \cr
}

\author{Houston N. Gilbert, based on the original \code{MTP} class and method definitions written by Katherine S. Pollard}

\seealso{ \code{\link{EBMTP}}, \code{\link{EBMTP-methods}},
\code{\link{MTP}}, \code{\link{MTP-methods}},
\code{\link{[-methods}}, \code{\link{as.list-methods}}, \code{\link{print-methods}}, \code{\link{plot-methods}}, \code{\link{summary-methods}}, \code{\link{mtp2ebmtp}}, 
\code{\link{ebmtp2mtp}}}

\examples{
## See EBMTP function: ? EBMTP
}

\keyword{classes}
