% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateAcrossFeatures.R
\name{aggregateAcrossFeatures}
\alias{aggregateAcrossFeatures}
\title{Aggregate feature sets in a SummarizedExperiment}
\usage{
aggregateAcrossFeatures(
  x,
  ids,
  ...,
  use.assay.type = "counts",
  use_exprs_values = NULL
)
}
\arguments{
\item{x}{A \linkS4class{SummarizedExperiment} containing an expression matrix.}

\item{ids}{A factor of length \code{nrow(x)}, specifying the set to which each feature in \code{x} belongs.

Alternatively, a list of integer or character vectors, where each vector specifies the indices or names of features in a set.
Logical vectors are also supported.}

\item{...}{Further arguments to be passed to \code{sumCountsAcrossFeatures}.}

\item{use.assay.type}{A character or integer vector specifying the assay(s) of \code{x} containing expression matrices.}

\item{use_exprs_values}{Soft-deprecated equivalent of \code{use.assay.type}.}
}
\value{
A SummarizedExperiment of the same class as \code{x} is returned,
containing summed matrices generated by \code{sumCountsAcrossFeatures} on all assays in \code{use.assay.type}.

If \code{ids} is a factor, row metadata is retained for the first instance of a feature from each set in \code{ids}.
This behavior assumes that \code{ids} specifies duplicates of the same gene, such that the first instance is a reasonable choice.

If \code{ids} is a list, row metadata is simply discarded.
This behavior assumes that \code{ids} specifies gene sets such that any existing gene-level metadata is meaningless.
}
\description{
Sum together expression values (by default, counts) for each feature set 
in each cell of a \linkS4class{SummarizedExperiment} object.
}
\examples{
example_sce <- mockSCE()
ids <- sample(LETTERS, nrow(example_sce), replace=TRUE)
aggr <- aggregateAcrossFeatures(example_sce, ids)
aggr

}
\seealso{
\code{\link{sumCountsAcrossFeatures}}, which does the heavy lifting.
}
\author{
Aaron Lun
}
