% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{safe_deparse}
\alias{safe_deparse}
\title{Safe version of deparse}
\usage{
safe_deparse(expr, ...)
}
\arguments{
\item{expr}{Any R expression.}

\item{...}{Passed to \code{\link[base]{deparse}}.}
}
\value{
A character vector or length one.
}
\description{
A version of \code{\link[base]{deparse}} that is guaranteed to always return 
a single string.
}
\note{
By default the RStudio IDE truncates output in the console at 1000 
characters.  Consequently, if you use \code{safe_deparse} on large or complex
objects, you won't see the full value. You can change the setting using
Tools -> "Global Options..." -> Code -> Display -> Console -> "Limit length
of lines displayed in console to:".
}
\examples{
# safe_deparse only differs from deparse when the deparse string is longer
# than width.cutoff
deparse(CO2, width.cutoff = 500L) # has length 6
safe_deparse(CO2)                 # has length 1
}
