\name{mprior-class}
\docType{class}
\alias{mprior-class}

\title{Class "mprior"}
\description{ An object pertaining to a BMA model prior}
\section{Objects from the Class}{
An \code{mprior} object holds descriptions and subfunctions pertaining to model priors. The BMA functions \code{\link{bms}} and post-processing functions rely on this class. \cr
There are currently five model prior structures built into the BMS package, generated by the following functions (cf. the appendix of \code{vignette(BMS)}): \cr
\code{mprior.uniform.init}: creates a uniform model prior object.\cr
\code{mprior.fixedt.init}: creates the popular binomial model prior object with common inclusion probabilities.\cr
\code{mprior.randomt.init}: creates a beta-binomial model prior object.\cr
\code{mprior.pip.init}: creates a binomial model prior object that allows for defining individual prior inclusion probabilities.\cr
\code{mprior.customk.init}: creates a model prior object that allows for defining a custom prior for each model parameter size.\cr
The following describes the necessary slots:
}
\section{Slots}{
  \describe{
    \item{\code{mp.mode}:}{A string with a human-readable identifier of the prior.}
    \item{\code{mp.msize}:}{A scalar holding the prior model size}
    \item{\code{mp.Kdist}:}{A vector holding the prior probabilities for each parameter size, from \code{0} to \code{K}. (Not necessary for \code{\link{bms}}, but for some post-processing functions.}
    \item{\code{pmp(ki, molddraw, ...):}}{A sub-function returning log-prior model probability depending on \code{molddraw} (a logical/numeric indicating the positions of regressors included in the model) and model size \code{k} (equivalent to \code{sum(molddraw)}.}
    }
}
\section{Methods}{
As for now, there are no methods defined with class "mprior" in the signature.
}
\author{Martin Feldkircher and Stefan Zeugner}
\seealso{
	 \code{\link{bms}} for creating \code{bma} objects. \cr
     Check the appendix of \code{vignette(BMS)} for a more detailed description of built-in priors.\cr
     Check \url{http://bms.zeugner.eu/custompriors.php} for examples.
}
%\examples{
%data(datafls)
%mm1=bms(datafls[,1:10], g="EBL")
%gg=mm1$gprior.info # is the g-prior object, augmented with some posterior statistics
%}
\keyword{classes}
