% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_outer.R
\name{variable.names.bma}
\alias{variable.names.bma}
\alias{model.frame.bma}
\title{Variable names and design matrix}
\usage{
\method{variable.names}{bma}(object, ...)
}
\arguments{
\item{object}{A \code{bma} object (as produced by \code{\link{bms}})}

\item{...}{further arguments passed to or from other methods}
}
\description{
Simple utilities retrieving variable names and design matrix from a bma
object
}
\details{
All functions are \code{bma}-functions for the generic methods
\code{\link{variable.names}}, \code{\link{deviance}}, and
\code{\link{model.frame}}.
}
\examples{

 data(datafls)
 bma_enum=bms(datafls[1:20,1:10])
 
 model.frame(bma_enum) # similar to 
 bma_enum$arguments$X.data
 
 variable.names(bma_enum)[-1] # is equivalent to
 bma_enum$reg.names
 
}
\seealso{
\code{\link{bms}} for creating bma objects

Check \url{http://bms.zeugner.eu} for additional help.
}
\keyword{utilities}
