% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-result-get-query.R
\docType{data}
\name{spec_result_get_query}
\alias{spec_result_get_query}
\title{spec_result_get_query}
\value{
\code{dbGetQuery()} always returns a \link{data.frame}
with as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
An error is raised when issuing a query over a closed
or invalid connection,
if the syntax of the query is invalid,
or if the query is not a non-\code{NA} string.
If the \code{n} argument is not an atomic whole number
greater or equal to -1 or Inf, an error is raised,
but a subsequent call to \code{dbGetQuery()} with proper \code{n} argument succeeds.
}
\description{
spec_result_get_query
}
\section{Additional arguments}{

The following arguments are not part of the \code{dbGetQuery()} generic
(to improve compatibility across backends)
but are part of the DBI specification:
\itemize{
\item \code{n} (default: -1)
\item \code{params} (default: \code{NULL})
\item \code{immediate} (default: \code{NULL})
}

They must be provided as named arguments.
See the "Specification" and "Value" sections for details on their usage.
}

\section{Specification}{


A column named \code{row_names} is treated like any other column.

The \code{n} argument specifies the number of rows to be fetched.
If omitted, fetching multi-row queries with one
or more columns returns the entire result.
A value of \link{Inf} for the \code{n} argument is supported
and also returns the full result.
If more rows than available are fetched (by passing a too large value for
\code{n}), the result is returned in full without warning.
If zero rows are requested, the columns of the data frame are still fully
typed.
Fetching fewer rows than available is permitted,
no warning is issued.

The \code{param} argument allows passing query parameters, see \code{\link[=dbBind]{dbBind()}} for details.
}

\section{Specification for the \code{immediate} argument}{


The \code{immediate} argument supports distinguishing between "direct"
and "prepared" APIs offered by many database drivers.
Passing \code{immediate = TRUE} leads to immediate execution of the
query or statement, via the "direct" API (if supported by the driver).
The default \code{NULL} means that the backend should choose whatever API
makes the most sense for the database, and (if relevant) tries the
other API if the first attempt fails. A successful second attempt
should result in a message that suggests passing the correct
\code{immediate} argument.
Examples for possible behaviors:
\enumerate{
\item DBI backend defaults to \code{immediate = TRUE} internally
\enumerate{
\item A query without parameters is passed: query is executed
\item A query with parameters is passed:
\enumerate{
\item \code{params} not given: rejected immediately by the database
because of a syntax error in the query, the backend tries
\code{immediate = FALSE} (and gives a message)
\item \code{params} given: query is executed using \code{immediate = FALSE}
}
}
\item DBI backend defaults to \code{immediate = FALSE} internally
\enumerate{
\item A query without parameters is passed:
\enumerate{
\item simple query: query is executed
\item "special" query (such as setting a config options): fails,
the backend tries \code{immediate = TRUE} (and gives a message)
}
\item A query with parameters is passed:
\enumerate{
\item \code{params} not given: waiting for parameters via \code{\link[=dbBind]{dbBind()}}
\item \code{params} given: query is executed
}
}
}
}

\keyword{internal}
