% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_attr_to_display.R
\name{set_node_attr_to_display}
\alias{set_node_attr_to_display}
\title{Set the node attribute values to be rendered}
\usage{
set_node_attr_to_display(graph, attr = NULL, nodes = NULL, default = "label")
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{attr}{The name of the attribute from which label text for the node will
be obtained. If set to \code{NULL}, then \code{NA} values will be assigned to the
\code{display} column for the chosen nodes.}

\item{nodes}{A length vector containing one or several node ID values (as
integers) for which node attributes are set for display in the rendered
graph. If \code{NULL}, all nodes from the graph are assigned the \code{display} value
given as \code{attr}.}

\item{default}{The name of an attribute to set for all other graph nodes not
included in \code{nodes}. This value only gets used if the \code{display} node
attribute is not in the graph's internal node data frame.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Set a node attribute type to display as node text when calling the
\code{\link[=render_graph]{render_graph()}} function. This allows for display of different types of node
attribute values on a per-node basis. Without setting the \code{display}
attribute, rendering a graph will default to printing text from the \code{label}
attribute on nodes. Setting the \code{display} node attribute with this function
for the first time (i.e., the \code{display} column doesn't exist in the graph's
internal node data frame) will insert the \code{attr} value for all nodes
specified in \code{nodes} and a default value (\code{default}) for all remaining nodes.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 4,
    m = 4,
    set_seed = 23) \%>\%
  set_node_attrs(
    node_attr = value,
    values = c(2.5, 8.2, 4.2, 2.4))

# For node ID values of `1`,
# `2`, and `3`, choose to display
# the node `value` attribute (for
# the other nodes, display nothing)
graph <-
  graph \%>\%
  set_node_attr_to_display(
    nodes = 1:3,
    attr = value,
    default = NA)

# Show the graph's node data frame; the
# `display` node attribute will show for
# each row, which node attribute value to
# display when the graph is rendered
graph \%>\% get_node_df()

# This function can be called multiple
# times on a graph; after the first time
# (i.e., creation of the `display`
# attribute), the `default` value won't
# be used
graph \%>\%
  set_node_attr_to_display(
    nodes = 4,
    attr = label) \%>\%
  set_node_attr_to_display(
    nodes = c(1, 3),
    attr = id) \%>\%
  get_node_df()

}
\seealso{
Other node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_node}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_node}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_position}()}
}
\concept{node creation and removal}
