% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_gce.R
\name{gce_access_token}
\alias{gce_access_token}
\title{Fetch access token for a service account on GCE}
\usage{
gce_access_token(
  scopes = "https://www.googleapis.com/auth/cloud-platform",
  service_account = "default"
)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
at \url{https://developers.google.com/identity/protocols/oauth2/scopes}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email and is generally considered a low-value
scope.}

\item{service_account}{Name of the GCE service account to use.}
}
\description{
Fetch access token for a service account on GCE
}
\keyword{internal}
