% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-boxplot.R, R/stat-boxplot.R
\name{geom_boxplot}
\alias{geom_boxplot}
\alias{stat_boxplot}
\title{A box and whiskers plot (in the style of Tukey)}
\usage{
geom_boxplot(
  mapping = NULL,
  data = NULL,
  stat = "boxplot",
  position = "dodge2",
  ...,
  outliers = TRUE,
  outlier.colour = NULL,
  outlier.color = NULL,
  outlier.fill = NULL,
  outlier.shape = NULL,
  outlier.size = NULL,
  outlier.stroke = 0.5,
  outlier.alpha = NULL,
  whisker.colour = NULL,
  whisker.color = NULL,
  whisker.linetype = NULL,
  whisker.linewidth = NULL,
  staple.colour = NULL,
  staple.color = NULL,
  staple.linetype = NULL,
  staple.linewidth = NULL,
  median.colour = NULL,
  median.color = NULL,
  median.linetype = NULL,
  median.linewidth = NULL,
  box.colour = NULL,
  box.color = NULL,
  box.linetype = NULL,
  box.linewidth = NULL,
  notch = FALSE,
  notchwidth = 0.5,
  staplewidth = 0,
  varwidth = FALSE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_boxplot(
  mapping = NULL,
  data = NULL,
  geom = "boxplot",
  position = "dodge2",
  ...,
  orientation = NA,
  coef = 1.5,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[=layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[=layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[=draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{outliers}{Whether to display (\code{TRUE}) or discard (\code{FALSE}) outliers
from the plot. Hiding or discarding outliers can be useful when, for
example, raw data points need to be displayed on top of the boxplot.
By discarding outliers, the axis limits will adapt to the box and whiskers
only, not the full data range. If outliers need to be hidden and the axes
needs to show the full data range, please use \code{outlier.shape = NA} instead.}

\item{outlier.colour, outlier.color, outlier.fill, outlier.shape, outlier.size, outlier.stroke, outlier.alpha}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{whisker.colour, whisker.color, whisker.linetype, whisker.linewidth}{Default aesthetics for the whiskers. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{staple.colour, staple.color, staple.linetype, staple.linewidth}{Default aesthetics for the staples. Set to \code{NULL} to inherit from the
data's aesthetics. Note that staples don't appear unless the \code{staplewidth}
argument is set to a non-zero size.}

\item{median.colour, median.color, median.linetype, median.linewidth}{Default aesthetics for the median line. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{box.colour, box.color, box.linetype, box.linewidth}{Default aesthetics for the boxes. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{notch}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, make a notched box plot. Notches are used to compare groups;
if the notches of two boxes do not overlap, this suggests that the medians
are significantly different.}

\item{notchwidth}{For a notched box plot, width of the notch relative to
the body (defaults to \code{notchwidth = 0.5}).}

\item{staplewidth}{The relative width of staples to the width of the box.
Staples mark the ends of the whiskers with a line.}

\item{varwidth}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=annotation_borders]{annotation_borders()}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_boxplot()} and \code{stat_boxplot()}. For more information about
overriding these connections, see how the \link[=layer_stats]{stat} and
\link[=layer_geoms]{geom} arguments work.}

\item{coef}{Length of the whiskers as multiple of IQR. Defaults to 1.5.}
}
\description{
The boxplot compactly displays the distribution of a continuous variable.
It visualises five summary statistics (the median, two hinges
and two whiskers), and all "outlying" points individually.
}
\note{
In the unlikely event you specify both US and UK spellings of colour,
the US spelling will take precedence.
}
\section{Orientation}{

This geom treats each axis differently and, thus, can thus have two orientations. Often the orientation is easy to deduce from a combination of the given mappings and the types of positional scales in use. Thus, ggplot2 will by default try to guess which orientation the layer should have. Under rare circumstances, the orientation is ambiguous and guessing may fail. In that case the orientation can be specified directly using the \code{orientation} parameter, which can be either \code{"x"} or \code{"y"}. The value gives the axis that the geom should run along, \code{"x"} being the default orientation you would expect for the geom.
}

\section{Summary statistics}{

The lower and upper hinges correspond to the first and third quartiles
(the 25th and 75th percentiles). This differs slightly from the method used
by the \code{\link[=boxplot]{boxplot()}} function, and may be apparent with small samples.
See \code{\link[=boxplot.stats]{boxplot.stats()}} for more information on how hinge
positions are calculated for \code{\link[=boxplot]{boxplot()}}.

The upper whisker extends from the hinge to the largest value no further than
1.5 * IQR from the hinge (where IQR is the inter-quartile range, or distance
between the first and third quartiles). The lower whisker extends from the
hinge to the smallest value at most 1.5 * IQR of the hinge. Data beyond the
end of the whiskers are called "outlying" points and are plotted
individually.

In a notched box plot, the notches extend \code{1.58 * IQR / sqrt(n)}.
This gives a roughly 95\% confidence interval for comparing medians.
See McGill et al. (1978) for more details.
}

\section{Computed variables}{

These are calculated by the 'stat' part of layers and can be accessed with \link[=aes_eval]{delayed evaluation}. \code{stat_boxplot()} provides the following variables, some of  which depend on the orientation:
\itemize{
\item \code{after_stat(width)}\cr width of boxplot.
\item \code{after_stat(ymin)} \emph{or} \code{after_stat(xmin)}\cr lower whisker = smallest observation greater than or equal  to lower hinger - 1.5 * IQR.
\item \code{after_stat(lower)} \emph{or} \code{after_stat(xlower)}\cr lower hinge, 25\% quantile.
\item \code{after_stat(notchlower)}\cr lower edge of notch = median - 1.58 * IQR / sqrt(n).
\item \code{after_stat(middle)} \emph{or} \code{after_stat(xmiddle)}\cr median, 50\% quantile.
\item \code{after_stat(notchupper)}\cr upper edge of notch = median + 1.58 * IQR / sqrt(n).
\item \code{after_stat(upper)} \emph{or} \code{after_stat(xupper)}\cr upper hinge, 75\% quantile.
\item \code{after_stat(ymax)} \emph{or} \code{after_stat(xmax)}\cr upper whisker = largest observation less than or equal to  upper hinger + 1.5 * IQR.
}
}

\examples{
p <- ggplot(mpg, aes(class, hwy))
p + geom_boxplot()
# Orientation follows the discrete axis
ggplot(mpg, aes(hwy, class)) + geom_boxplot()

p + geom_boxplot(notch = TRUE)
p + geom_boxplot(varwidth = TRUE)
p + geom_boxplot(fill = "white", colour = "#3366FF")
# By default, outlier points match the colour of the box. Use
# outlier.colour to override
p + geom_boxplot(outlier.colour = "red", outlier.shape = 1)
# Remove outliers when overlaying boxplot with original data points
p + geom_boxplot(outlier.shape = NA) + geom_jitter(width = 0.2)

# Boxplots are automatically dodged when any aesthetic is a factor
p + geom_boxplot(aes(colour = drv))

# You can also use boxplots with continuous x, as long as you supply
# a grouping variable. cut_width is particularly useful
ggplot(diamonds, aes(carat, price)) +
  geom_boxplot()
ggplot(diamonds, aes(carat, price)) +
  geom_boxplot(aes(group = cut_width(carat, 0.25)))
# Adjust the transparency of outliers using outlier.alpha
ggplot(diamonds, aes(carat, price)) +
  geom_boxplot(aes(group = cut_width(carat, 0.25)), outlier.alpha = 0.1)

\donttest{
# It's possible to draw a boxplot with your own computations if you
# use stat = "identity":
set.seed(1)
y <- rnorm(100)
df <- data.frame(
  x = 1,
  y0 = min(y),
  y25 = quantile(y, 0.25),
  y50 = median(y),
  y75 = quantile(y, 0.75),
  y100 = max(y)
)
ggplot(df, aes(x)) +
  geom_boxplot(
   aes(ymin = y0, lower = y25, middle = y50, upper = y75, ymax = y100),
   stat = "identity"
 )
}
}
\references{
McGill, R., Tukey, J. W. and Larsen, W. A. (1978) Variations of
box plots. The American Statistician 32, 12-16.
}
\seealso{
\code{\link[=geom_quantile]{geom_quantile()}} for continuous \code{x},
\code{\link[=geom_violin]{geom_violin()}} for a richer display of the distribution, and
\code{\link[=geom_jitter]{geom_jitter()}} for a useful technique for small data.
}
\section{Aesthetics}{

\code{geom_boxplot()} understands the following aesthetics. Required aesthetics are displayed in bold and defaults are displayed for optional aesthetics:
\tabular{rll}{
 • \tab \strong{\code{\link[=aes_position]{x}} \emph{or} \code{\link[=aes_position]{y}}} \tab   \cr
 • \tab \strong{\code{lower} \emph{or} \code{xlower}} \tab   \cr
 • \tab \strong{\code{upper} \emph{or} \code{xupper}} \tab   \cr
 • \tab \strong{\code{middle} \emph{or} \code{xmiddle}} \tab   \cr
 • \tab \strong{\code{\link[=aes_position]{ymin}} \emph{or} \code{\link[=aes_position]{xmin}}} \tab   \cr
 • \tab \strong{\code{\link[=aes_position]{ymax}} \emph{or} \code{\link[=aes_position]{xmax}}} \tab   \cr
 • \tab \code{\link[=aes_colour_fill_alpha]{alpha}} \tab → \code{NA} \cr
 • \tab \code{\link[=aes_colour_fill_alpha]{colour}} \tab → via \code{theme()} \cr
 • \tab \code{\link[=aes_colour_fill_alpha]{fill}} \tab → via \code{theme()} \cr
 • \tab \code{\link[=aes_group_order]{group}} \tab → inferred \cr
 • \tab \code{\link[=aes_linetype_size_shape]{linetype}} \tab → via \code{theme()} \cr
 • \tab \code{\link[=aes_linetype_size_shape]{linewidth}} \tab → via \code{theme()} \cr
 • \tab \code{\link[=aes_linetype_size_shape]{shape}} \tab → via \code{theme()} \cr
 • \tab \code{\link[=aes_linetype_size_shape]{size}} \tab → via \code{theme()} \cr
 • \tab \code{weight} \tab → \code{1} \cr
 • \tab \code{width} \tab → \code{0.9} \cr
}

Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}
