% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-grob.r
\name{gtable_add_grob}
\alias{gtable_add_grob}
\title{Add a single grob, possibly spanning multiple rows or columns.}
\usage{
gtable_add_grob(
  x,
  grobs,
  t,
  l,
  b = t,
  r = l,
  z = Inf,
  clip = "on",
  name = x$name
)
}
\arguments{
\item{x}{a \code{\link[=gtable]{gtable()}} object}

\item{grobs}{a single grob or a list of grobs}

\item{t}{a numeric vector giving the top extent of the grobs}

\item{l}{a numeric vector giving the left extent of the grobs}

\item{b}{a numeric vector giving the bottom extent of the grobs}

\item{r}{a numeric vector giving the right extent of the grobs}

\item{z}{a numeric vector giving the order in which the grobs should be
plotted.  Use \code{Inf} (the default) to plot above or \code{-Inf}
below all existing grobs. By default positions are on the integers,
giving plenty of room to insert new grobs between existing grobs.}

\item{clip}{should drawing be clipped to the specified cells
(\code{"on"}), the entire table (\code{"inherit"}), or not at all
(\code{"off"})}

\item{name}{name of the grob - used to modify the grob name before it's
plotted.}
}
\value{
A gtable object with the new grob(s) added
}
\description{
This only adds grobs into the table - it doesn't affect the table layout in
any way.  In the gtable model, grobs always fill up the complete table
cell.  If you want custom justification you might need to define the grob
dimension in absolute units, or put it into another gtable that can then be
added to the gtable instead of the grob.
}
\examples{
library(grid)

gt <- gtable(widths = unit(c(1, 1), 'null'), heights = unit(c(1, 1), 'null'))
pts <- pointsGrob(x = runif(5), y = runif(5))

# Add a grob to a single cell (top-right cell)
gt <- gtable_add_grob(gt, pts, t = 1, l = 2)

# Add a grob spanning multiple cells
gt <- gtable_add_grob(gt, pts, t = 1, l = 1, b = 2)

plot(gt)

}
\seealso{
Other gtable manipulation: 
\code{\link{gtable_add_cols}()},
\code{\link{gtable_add_padding}()},
\code{\link{gtable_add_rows}()},
\code{\link{gtable_add_space}},
\code{\link{gtable_filter}()}
}
\concept{gtable manipulation}
