% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters_emmeans.R
\name{get_parameters.emmGrid}
\alias{get_parameters.emmGrid}
\alias{get_parameters.emm_list}
\title{Get model parameters from estimated marginal means objects}
\usage{
\method{get_parameters}{emmGrid}(x, summary = FALSE, merge_parameters = FALSE, ...)

\method{get_parameters}{emm_list}(x, summary = FALSE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{summary}{Logical, indicates whether the full posterior samples
(\code{summary = FALSE})) or the summarized centrality indices of
the posterior samples (\code{summary = TRUE})) should be returned as
estimates.}

\item{merge_parameters}{Logical, if \code{TRUE} and \code{x} has multiple
columns for parameter names (like \code{emmGrid} objects may have), these
are merged into a single parameter column, with parameters names and values
as values.}

\item{...}{Currently not used.}
}
\value{
A data frame with two columns: the parameter names and the related
  point estimates.
}
\description{
Returns the coefficients from a model.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_parameters(m)
}
