% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dates.r
\docType{data}
\name{is.Date}
\alias{is.Date}
\alias{Date}
\alias{NA_Date_}
\title{Various date utilities}
\format{
An object of class \code{Date} of length 1.
}
\usage{
is.Date(x)

Date(length = 0L)

NA_Date_
}
\arguments{
\item{x}{an R object}

\item{length}{A non-negative number specifying the desired length. Supplying
an argument of length other than one is an error.}
}
\description{
\code{\link[=Date]{Date()}} mirrors primitive constructors in base R (\code{\link[=double]{double()}}, \code{\link[=character]{character()}}
etc.)
}
\examples{
is.Date(as.Date("2009-08-03")) # TRUE
is.Date(difftime(now() + 5, now())) # FALSE
}
\seealso{
\code{\link[=is.instant]{is.instant()}}, \code{\link[=is.timespan]{is.timespan()}}, \code{\link[=is.POSIXt]{is.POSIXt()}}, \code{\link[=POSIXct]{POSIXct()}}
}
\keyword{chron}
\keyword{datasets}
\keyword{logic}
