#' Morphometric data on scat
#'
#' Reid (2015) collected data on animal feses in coastal California. The data
#' consist of DNA verified species designations as well as fields related to
#' the time and place of the collection and the scat itself. The data are on
#' the three main species.
#'
#'
#' @name scat
#' @aliases scat
#' @docType data
#' @return \item{scat}{a tibble}
#' @source Reid, R. E. B. (2015). A morphometric modeling approach to
#' distinguishing among bobcat, coyote and gray fox scats. \emph{Wildlife
#' Biology}, 21(5), 254-262
#' @keywords datasets
#' @examples
#' data(scat)
#' str(scat)
NULL
